/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.ContextImpl;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.GraphicBuffer;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.MergedConfiguration;
import android.util.Slog;
import android.view.DisplayCutout;
import android.view.IWindowSession;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.policy.DecorView;
import com.android.internal.view.BaseIWindow;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import java.lang.invoke.LambdaMetafactory;

class TaskSnapshotSurface
implements WindowManagerPolicy.StartingSurface {
    private static final long SIZE_MISMATCH_MINIMUM_TIME_MS = 450L;
    private static final int FLAG_INHERIT_EXCLUDES = 830922808;
    private static final int PRIVATE_FLAG_INHERITS = 131072;
    private static final String TAG = "WindowManager";
    private static final int MSG_REPORT_DRAW = 0;
    private static final String TITLE_FORMAT = "SnapshotStartingWindow for taskId=%s";
    private final Window mWindow;
    private final Surface mSurface;
    private SurfaceControl mChildSurfaceControl;
    private final IWindowSession mSession;
    private final WindowManagerService mService;
    private final Rect mTaskBounds;
    private final Rect mStableInsets = new Rect();
    private final Rect mContentInsets = new Rect();
    private final Rect mFrame = new Rect();
    private ActivityManager.TaskSnapshot mSnapshot;
    private final CharSequence mTitle;
    private boolean mHasDrawn;
    private long mShownTime;
    private final Handler mHandler;
    private boolean mSizeMismatch;
    private final Paint mBackgroundPaint = new Paint();
    private final int mStatusBarColor;
    @VisibleForTesting
    final SystemBarBackgroundPainter mSystemBarBackgroundPainter;
    private final int mOrientationOnCreation;
    private static Handler sHandler = new Handler(Looper.getMainLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    boolean hasDrawn;
                    TaskSnapshotSurface surface = (TaskSnapshotSurface)msg.obj;
                    WindowHashMap windowHashMap = ((TaskSnapshotSurface)surface).mService.mWindowMap;
                    synchronized (windowHashMap) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            hasDrawn = surface.mHasDrawn;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[1, 2, 3, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var4_3
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    if (!hasDrawn) break;
                    surface.reportDrawn();
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static TaskSnapshotSurface create(WindowManagerService service, AppWindowToken token, ActivityManager.TaskSnapshot snapshot) {
        layoutParams = new WindowManager.LayoutParams();
        window = new Window();
        session = WindowManagerGlobal.getWindowSession();
        window.setSession(session);
        surface = new Surface();
        tmpRect = new Rect();
        tmpCutout = new DisplayCutout.ParcelableWrapper();
        tmpFrame = new Rect();
        tmpContentInsets = new Rect();
        tmpStableInsets = new Rect();
        tmpMergedConfiguration = new MergedConfiguration();
        backgroundColor = -1;
        statusBarColor = 0;
        navigationBarColor = 0;
        var21_16 = service.mWindowMap;
        synchronized (var21_16) {
            WindowManagerService.boostPriorityForLockedSection();
            mainWindow = token.findMainWindow();
            task = token.getTask();
            if (task != null) ** break block12
            Slog.w("WindowManager", "TaskSnapshotSurface.create: Failed to find task for token=" + token);
            v0 = null;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v0;
        {
            topFullscreenToken = token.getTask().getTopFullscreenAppToken();
            if (topFullscreenToken != null) ** break block13
            Slog.w("WindowManager", "TaskSnapshotSurface.create: Failed to find top fullscreen for task=" + task);
            v1 = null;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v1;
        {
            topFullscreenWindow = topFullscreenToken.getTopFullscreenWindow();
            if (mainWindow != null && topFullscreenWindow != null) ** break block14
            Slog.w("WindowManager", "TaskSnapshotSurface.create: Failed to find main window for token=" + token);
            v2 = null;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v2;
        {
            try {
                sysUiVis = topFullscreenWindow.getSystemUiVisibility();
                windowFlags = topFullscreenWindow.getAttrs().flags;
                windowPrivateFlags = topFullscreenWindow.getAttrs().privateFlags;
                layoutParams.packageName = mainWindow.getAttrs().packageName;
                layoutParams.windowAnimations = mainWindow.getAttrs().windowAnimations;
                layoutParams.dimAmount = mainWindow.getAttrs().dimAmount;
                layoutParams.type = 3;
                layoutParams.format = snapshot.getSnapshot().getFormat();
                layoutParams.flags = windowFlags & -830922809 | 8 | 16;
                layoutParams.privateFlags = windowPrivateFlags & 131072;
                layoutParams.token = token.token;
                layoutParams.width = -1;
                layoutParams.height = -1;
                layoutParams.systemUiVisibility = sysUiVis;
                layoutParams.setTitle(String.format("SnapshotStartingWindow for taskId=%s", new Object[]{task.mTaskId}));
                taskDescription = task.getTaskDescription();
                if (taskDescription != null) {
                    backgroundColor = taskDescription.getBackgroundColor();
                    statusBarColor = taskDescription.getStatusBarColor();
                    navigationBarColor = taskDescription.getNavigationBarColor();
                }
                taskBounds = new Rect();
                task.getBounds(taskBounds);
                currentOrientation = topFullscreenWindow.getConfiguration().orientation;
            }
            catch (Throwable var27_31) {
                // MONITOREXIT @DISABLED, blocks:[6, 7] lbl73 : MonitorExitStatement: MONITOREXIT : var21_16
                WindowManagerService.resetPriorityAfterLockedSection();
                throw var27_31;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        try {
            res = session.addToDisplay(window, window.mSeq, layoutParams, 8, token.getDisplayContent().getDisplayId(), tmpFrame, tmpRect, tmpRect, tmpRect, tmpCutout, null);
            if (res < 0) {
                Slog.w("WindowManager", "Failed to add snapshot starting window res=" + res);
                return null;
            }
        }
        catch (RemoteException res) {
            // empty catch block
        }
        snapshotSurface = new TaskSnapshotSurface(service, window, surface, snapshot, layoutParams.getTitle(), backgroundColor, statusBarColor, navigationBarColor, sysUiVis, windowFlags, windowPrivateFlags, taskBounds, currentOrientation);
        window.setOuter(snapshotSurface);
        try {
            session.relayout(window, window.mSeq, layoutParams, -1, -1, 0, 0, -1L, tmpFrame, tmpRect, tmpContentInsets, tmpRect, tmpStableInsets, tmpRect, tmpRect, tmpCutout, tmpMergedConfiguration, surface);
        }
        catch (RemoteException var22_21) {
            // empty catch block
        }
        snapshotSurface.setFrames(tmpFrame, tmpContentInsets, tmpStableInsets);
        snapshotSurface.drawSnapshot();
        return snapshotSurface;
    }

    @VisibleForTesting
    TaskSnapshotSurface(WindowManagerService service, Window window, Surface surface, ActivityManager.TaskSnapshot snapshot, CharSequence title, int backgroundColor, int statusBarColor, int navigationBarColor, int sysUiVis, int windowFlags, int windowPrivateFlags, Rect taskBounds, int currentOrientation) {
        this.mService = service;
        this.mHandler = new Handler(this.mService.mH.getLooper());
        this.mSession = WindowManagerGlobal.getWindowSession();
        this.mWindow = window;
        this.mSurface = surface;
        this.mSnapshot = snapshot;
        this.mTitle = title;
        this.mBackgroundPaint.setColor(backgroundColor != 0 ? backgroundColor : -1);
        this.mTaskBounds = taskBounds;
        this.mSystemBarBackgroundPainter = new SystemBarBackgroundPainter(windowFlags, windowPrivateFlags, sysUiVis, statusBarColor, navigationBarColor);
        this.mStatusBarColor = statusBarColor;
        this.mOrientationOnCreation = currentOrientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void remove() {
        var1_1 = this.mService.mWindowMap;
        synchronized (var1_1) {
            WindowManagerService.boostPriorityForLockedSection();
            now = SystemClock.uptimeMillis();
            if (!this.mSizeMismatch || now - this.mShownTime >= 450L) ** break block6
            this.mHandler.postAtTime((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, remove(), ()V)((TaskSnapshotSurface)this), this.mShownTime + 450L);
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return;
        {
            try {}
            catch (Throwable var4_4) {
                // MONITOREXIT @DISABLED, blocks:[3, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw var4_4;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        try {
            this.mSession.remove(this.mWindow);
        }
        catch (RemoteException var1_2) {
            // empty catch block
        }
    }

    @VisibleForTesting
    void setFrames(Rect frame, Rect contentInsets, Rect stableInsets) {
        this.mFrame.set(frame);
        this.mContentInsets.set(contentInsets);
        this.mStableInsets.set(stableInsets);
        this.mSizeMismatch = this.mFrame.width() != this.mSnapshot.getSnapshot().getWidth() || this.mFrame.height() != this.mSnapshot.getSnapshot().getHeight();
        this.mSystemBarBackgroundPainter.setInsets(contentInsets, stableInsets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawSnapshot() {
        GraphicBuffer buffer = this.mSnapshot.getSnapshot();
        if (this.mSizeMismatch) {
            this.drawSizeMismatchSnapshot(buffer);
        } else {
            this.drawSizeMatchSnapshot(buffer);
        }
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mShownTime = SystemClock.uptimeMillis();
                this.mHasDrawn = true;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        this.reportDrawn();
        this.mSnapshot = null;
    }

    private void drawSizeMatchSnapshot(GraphicBuffer buffer) {
        this.mSurface.attachAndQueueBuffer(buffer);
        this.mSurface.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawSizeMismatchSnapshot(GraphicBuffer buffer) {
        SurfaceSession session = new SurfaceSession(this.mSurface);
        this.mChildSurfaceControl = new SurfaceControl.Builder(session).setName(this.mTitle + " - task-snapshot-surface").setSize(buffer.getWidth(), buffer.getHeight()).setFormat(buffer.getFormat()).build();
        Surface surface = new Surface();
        surface.copyFrom(this.mChildSurfaceControl);
        Rect crop = this.calculateSnapshotCrop();
        Rect frame = this.calculateSnapshotFrame(crop);
        SurfaceControl.openTransaction();
        try {
            this.mChildSurfaceControl.show();
            this.mChildSurfaceControl.setWindowCrop(crop);
            this.mChildSurfaceControl.setPosition(frame.left, frame.top);
            float scale = 1.0f / this.mSnapshot.getScale();
            this.mChildSurfaceControl.setMatrix(scale, 0.0f, 0.0f, scale);
        }
        finally {
            SurfaceControl.closeTransaction();
        }
        surface.attachAndQueueBuffer(buffer);
        surface.release();
        Canvas c = this.mSurface.lockCanvas(null);
        this.drawBackgroundAndBars(c, frame);
        this.mSurface.unlockCanvasAndPost(c);
        this.mSurface.release();
    }

    @VisibleForTesting
    Rect calculateSnapshotCrop() {
        Rect rect = new Rect();
        rect.set(0, 0, this.mSnapshot.getSnapshot().getWidth(), this.mSnapshot.getSnapshot().getHeight());
        Rect insets = this.mSnapshot.getContentInsets();
        boolean isTop = this.mTaskBounds.top == 0 && this.mFrame.top == 0;
        rect.inset((int)((float)insets.left * this.mSnapshot.getScale()), isTop ? 0 : (int)((float)insets.top * this.mSnapshot.getScale()), (int)((float)insets.right * this.mSnapshot.getScale()), (int)((float)insets.bottom * this.mSnapshot.getScale()));
        return rect;
    }

    @VisibleForTesting
    Rect calculateSnapshotFrame(Rect crop) {
        Rect frame = new Rect(crop);
        float scale = this.mSnapshot.getScale();
        frame.scale(1.0f / scale);
        frame.offsetTo((int)((float)(-crop.left) / scale), (int)((float)(-crop.top) / scale));
        int colorViewLeftInset = DecorView.getColorViewLeftInset(this.mStableInsets.left, this.mContentInsets.left);
        frame.offset(colorViewLeftInset, 0);
        return frame;
    }

    @VisibleForTesting
    void drawBackgroundAndBars(Canvas c, Rect frame) {
        boolean fillVertically;
        int statusBarHeight = this.mSystemBarBackgroundPainter.getStatusBarColorViewHeight();
        boolean fillHorizontally = c.getWidth() > frame.right;
        boolean bl = fillVertically = c.getHeight() > frame.bottom;
        if (fillHorizontally) {
            c.drawRect(frame.right, Color.alpha(this.mStatusBarColor) == 255 ? (float)statusBarHeight : 0.0f, c.getWidth(), fillVertically ? (float)frame.bottom : (float)c.getHeight(), this.mBackgroundPaint);
        }
        if (fillVertically) {
            c.drawRect(0.0f, frame.bottom, c.getWidth(), c.getHeight(), this.mBackgroundPaint);
        }
        this.mSystemBarBackgroundPainter.drawDecors(c, frame);
    }

    private void reportDrawn() {
        try {
            this.mSession.finishDrawing(this.mWindow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    static class SystemBarBackgroundPainter {
        private final Rect mContentInsets = new Rect();
        private final Rect mStableInsets = new Rect();
        private final Paint mStatusBarPaint = new Paint();
        private final Paint mNavigationBarPaint = new Paint();
        private final int mStatusBarColor;
        private final int mNavigationBarColor;
        private final int mWindowFlags;
        private final int mWindowPrivateFlags;
        private final int mSysUiVis;

        SystemBarBackgroundPainter(int windowFlags, int windowPrivateFlags, int sysUiVis, int statusBarColor, int navigationBarColor) {
            this.mWindowFlags = windowFlags;
            this.mWindowPrivateFlags = windowPrivateFlags;
            this.mSysUiVis = sysUiVis;
            ContextImpl context = ActivityThread.currentActivityThread().getSystemUiContext();
            this.mStatusBarColor = DecorView.calculateStatusBarColor(windowFlags, context.getColor(17170773), statusBarColor);
            this.mNavigationBarColor = navigationBarColor;
            this.mStatusBarPaint.setColor(this.mStatusBarColor);
            this.mNavigationBarPaint.setColor(navigationBarColor);
        }

        void setInsets(Rect contentInsets, Rect stableInsets) {
            this.mContentInsets.set(contentInsets);
            this.mStableInsets.set(stableInsets);
        }

        int getStatusBarColorViewHeight() {
            boolean forceStatusBarBackground;
            boolean bl = forceStatusBarBackground = (this.mWindowPrivateFlags & 0x20000) != 0;
            if (DecorView.STATUS_BAR_COLOR_VIEW_ATTRIBUTES.isVisible(this.mSysUiVis, this.mStatusBarColor, this.mWindowFlags, forceStatusBarBackground)) {
                return DecorView.getColorViewTopInset(this.mStableInsets.top, this.mContentInsets.top);
            }
            return 0;
        }

        private boolean isNavigationBarColorViewVisible() {
            return DecorView.NAVIGATION_BAR_COLOR_VIEW_ATTRIBUTES.isVisible(this.mSysUiVis, this.mNavigationBarColor, this.mWindowFlags, false);
        }

        void drawDecors(Canvas c, Rect alreadyDrawnFrame) {
            this.drawStatusBarBackground(c, alreadyDrawnFrame, this.getStatusBarColorViewHeight());
            this.drawNavigationBarBackground(c);
        }

        @VisibleForTesting
        void drawStatusBarBackground(Canvas c, Rect alreadyDrawnFrame, int statusBarHeight) {
            if (statusBarHeight > 0 && Color.alpha(this.mStatusBarColor) != 0 && (alreadyDrawnFrame == null || c.getWidth() > alreadyDrawnFrame.right)) {
                int rightInset = DecorView.getColorViewRightInset(this.mStableInsets.right, this.mContentInsets.right);
                int left = alreadyDrawnFrame != null ? alreadyDrawnFrame.right : 0;
                c.drawRect(left, 0.0f, c.getWidth() - rightInset, statusBarHeight, this.mStatusBarPaint);
            }
        }

        @VisibleForTesting
        void drawNavigationBarBackground(Canvas c) {
            Rect navigationBarRect = new Rect();
            DecorView.getNavigationBarRect(c.getWidth(), c.getHeight(), this.mStableInsets, this.mContentInsets, navigationBarRect);
            boolean visible = this.isNavigationBarColorViewVisible();
            if (visible && Color.alpha(this.mNavigationBarColor) != 0 && !navigationBarRect.isEmpty()) {
                c.drawRect(navigationBarRect, this.mNavigationBarPaint);
            }
        }
    }

    @VisibleForTesting
    static class Window
    extends BaseIWindow {
        private TaskSnapshotSurface mOuter;

        Window() {
        }

        public void setOuter(TaskSnapshotSurface outer) {
            this.mOuter = outer;
        }

        @Override
        public void resized(Rect frame, Rect overscanInsets, Rect contentInsets, Rect visibleInsets, Rect stableInsets, Rect outsets, boolean reportDraw, MergedConfiguration mergedConfiguration, Rect backDropFrame, boolean forceLayout, boolean alwaysConsumeNavBar, int displayId, DisplayCutout.ParcelableWrapper displayCutout) {
            if (mergedConfiguration != null && this.mOuter != null && this.mOuter.mOrientationOnCreation != mergedConfiguration.getMergedConfiguration().orientation) {
                sHandler.post(this.mOuter::remove);
            }
            if (reportDraw) {
                sHandler.obtainMessage(0, this.mOuter).sendToTarget();
            }
        }
    }
}

