/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import android.view.DisplayInfo;
import android.view.SurfaceControl;
import com.android.internal.policy.DividerSnapAlgorithm;
import com.android.internal.policy.DockedDividerUtils;
import com.android.server.wm.AnimatingAppWindowTokenRegistry;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.BoundsAnimationTarget;
import com.android.server.wm.Dimmer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.PinnedStackWindowController;
import com.android.server.wm.StackWindowController;
import com.android.server.wm.Task;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;

public class TaskStack
extends WindowContainer<Task>
implements BoundsAnimationTarget {
    private static final float ADJUSTED_STACK_FRACTION_MIN = 0.3f;
    private static final float IME_ADJUST_DIM_AMOUNT = 0.25f;
    final int mStackId;
    private DisplayContent mDisplayContent;
    private Rect mTmpRect = new Rect();
    private Rect mTmpRect2 = new Rect();
    private Rect mTmpRect3 = new Rect();
    private final Rect mAdjustedBounds = new Rect();
    private final Rect mFullyAdjustedImeBounds = new Rect();
    private int mRotation;
    private int mDensity;
    private SurfaceControl mAnimationBackgroundSurface;
    private boolean mAnimationBackgroundSurfaceIsShown = false;
    private WindowStateAnimator mAnimationBackgroundAnimator;
    final AppTokenList mExitingAppTokens = new AppTokenList();
    final AppTokenList mTmpAppTokens = new AppTokenList();
    boolean mDeferRemoval;
    private final Rect mTmpAdjustedBounds = new Rect();
    private boolean mAdjustedForIme;
    private boolean mImeGoingAway;
    private WindowState mImeWin;
    private float mMinimizeAmount;
    private float mAdjustImeAmount;
    private float mAdjustDividerAmount;
    private final int mDockedStackMinimizeThickness;
    private boolean mBoundsAnimating = false;
    private boolean mBoundsAnimatingRequested = false;
    private boolean mBoundsAnimatingToFullscreen = false;
    private boolean mCancelCurrentBoundsAnimation = false;
    private Rect mBoundsAnimationTarget = new Rect();
    private Rect mBoundsAnimationSourceHintBounds = new Rect();
    private final Rect mBoundsAfterRotation = new Rect();
    Rect mPreAnimationBounds = new Rect();
    private Dimmer mDimmer = new Dimmer(this);
    final Rect mTmpDimBoundsRect = new Rect();
    private final Point mLastSurfaceSize = new Point();
    private final AnimatingAppWindowTokenRegistry mAnimatingAppWindowTokenRegistry = new AnimatingAppWindowTokenRegistry();

    TaskStack(WindowManagerService service, int stackId, StackWindowController controller) {
        super(service);
        this.mStackId = stackId;
        this.setController(controller);
        this.mDockedStackMinimizeThickness = service.mContext.getResources().getDimensionPixelSize(17105035);
        EventLog.writeEvent(31004, stackId);
    }

    DisplayContent getDisplayContent() {
        return this.mDisplayContent;
    }

    Task findHomeTask() {
        if (!this.isActivityTypeHome() || this.mChildren.isEmpty()) {
            return null;
        }
        return (Task)this.mChildren.get(this.mChildren.size() - 1);
    }

    boolean setBounds(Rect stackBounds, SparseArray<Rect> taskBounds, SparseArray<Rect> taskTempInsetBounds) {
        this.setBounds(stackBounds);
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            Task task = (Task)this.mChildren.get(taskNdx);
            task.setBounds(taskBounds.get(task.mTaskId), false);
            task.setTempInsetBounds(taskTempInsetBounds != null ? taskTempInsetBounds.get(task.mTaskId) : null);
        }
        return true;
    }

    void prepareFreezingTaskBounds() {
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            Task task = (Task)this.mChildren.get(taskNdx);
            task.prepareFreezingBounds();
        }
    }

    private void setAdjustedBounds(Rect bounds) {
        if (this.mAdjustedBounds.equals(bounds) && !this.isAnimatingForIme()) {
            return;
        }
        this.mAdjustedBounds.set(bounds);
        boolean adjusted = !this.mAdjustedBounds.isEmpty();
        Rect insetBounds = null;
        if (adjusted && this.isAdjustedForMinimizedDockedStack()) {
            insetBounds = this.getRawBounds();
        } else if (adjusted && this.mAdjustedForIme) {
            insetBounds = this.mImeGoingAway ? this.getRawBounds() : this.mFullyAdjustedImeBounds;
        }
        this.alignTasksToAdjustedBounds(adjusted ? this.mAdjustedBounds : this.getRawBounds(), insetBounds);
        this.mDisplayContent.setLayoutNeeded();
        this.updateSurfaceBounds();
    }

    private void alignTasksToAdjustedBounds(Rect adjustedBounds, Rect tempInsetBounds) {
        if (this.matchParentBounds()) {
            return;
        }
        boolean alignBottom = this.mAdjustedForIme && this.getDockSide() == 2;
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            Task task = (Task)this.mChildren.get(taskNdx);
            task.alignToAdjustedBounds(adjustedBounds, tempInsetBounds, alignBottom);
        }
    }

    private void updateAnimationBackgroundBounds() {
        if (this.mAnimationBackgroundSurface == null) {
            return;
        }
        this.getRawBounds(this.mTmpRect);
        Rect stackBounds = this.getBounds();
        this.getPendingTransaction().setSize(this.mAnimationBackgroundSurface, this.mTmpRect.width(), this.mTmpRect.height()).setPosition(this.mAnimationBackgroundSurface, this.mTmpRect.left - stackBounds.left, this.mTmpRect.top - stackBounds.top);
        this.scheduleAnimation();
    }

    private void hideAnimationSurface() {
        if (this.mAnimationBackgroundSurface == null) {
            return;
        }
        this.getPendingTransaction().hide(this.mAnimationBackgroundSurface);
        this.mAnimationBackgroundSurfaceIsShown = false;
        this.scheduleAnimation();
    }

    private void showAnimationSurface(float alpha) {
        if (this.mAnimationBackgroundSurface == null) {
            return;
        }
        this.getPendingTransaction().setLayer(this.mAnimationBackgroundSurface, Integer.MIN_VALUE).setAlpha(this.mAnimationBackgroundSurface, alpha).show(this.mAnimationBackgroundSurface);
        this.mAnimationBackgroundSurfaceIsShown = true;
        this.scheduleAnimation();
    }

    @Override
    public int setBounds(Rect bounds) {
        return this.setBounds(this.getOverrideBounds(), bounds);
    }

    private int setBounds(Rect existing, Rect bounds) {
        int rotation = 0;
        int density = 0;
        if (this.mDisplayContent != null) {
            this.mDisplayContent.getBounds(this.mTmpRect);
            rotation = this.mDisplayContent.getDisplayInfo().rotation;
            density = this.mDisplayContent.getDisplayInfo().logicalDensityDpi;
        }
        if (TaskStack.equivalentBounds(existing, bounds) && this.mRotation == rotation) {
            return 0;
        }
        int result = super.setBounds(bounds);
        if (this.mDisplayContent != null) {
            this.updateAnimationBackgroundBounds();
        }
        this.mRotation = rotation;
        this.mDensity = density;
        this.updateAdjustedBounds();
        this.updateSurfaceBounds();
        return result;
    }

    void getRawBounds(Rect out) {
        out.set(this.getRawBounds());
    }

    Rect getRawBounds() {
        return super.getBounds();
    }

    private boolean useCurrentBounds() {
        return this.matchParentBounds() || !this.inSplitScreenSecondaryWindowingMode() || this.mDisplayContent == null || this.mDisplayContent.getSplitScreenPrimaryStackIgnoringVisibility() != null;
    }

    @Override
    public void getBounds(Rect bounds) {
        bounds.set(this.getBounds());
    }

    @Override
    public Rect getBounds() {
        if (this.useCurrentBounds()) {
            if (!this.mAdjustedBounds.isEmpty()) {
                return this.mAdjustedBounds;
            }
            return super.getBounds();
        }
        return this.mDisplayContent.getBounds();
    }

    void setAnimationFinalBounds(Rect sourceHintBounds, Rect destBounds, boolean toFullscreen) {
        this.mBoundsAnimatingRequested = true;
        this.mBoundsAnimatingToFullscreen = toFullscreen;
        if (destBounds != null) {
            this.mBoundsAnimationTarget.set(destBounds);
        } else {
            this.mBoundsAnimationTarget.setEmpty();
        }
        if (sourceHintBounds != null) {
            this.mBoundsAnimationSourceHintBounds.set(sourceHintBounds);
        } else {
            this.mBoundsAnimationSourceHintBounds.setEmpty();
        }
        this.mPreAnimationBounds.set(this.getRawBounds());
    }

    void getFinalAnimationBounds(Rect outBounds) {
        outBounds.set(this.mBoundsAnimationTarget);
    }

    void getFinalAnimationSourceHintBounds(Rect outBounds) {
        outBounds.set(this.mBoundsAnimationSourceHintBounds);
    }

    void getAnimationOrCurrentBounds(Rect outBounds) {
        if ((this.mBoundsAnimatingRequested || this.mBoundsAnimating) && !this.mBoundsAnimationTarget.isEmpty()) {
            this.getFinalAnimationBounds(outBounds);
            return;
        }
        this.getBounds(outBounds);
    }

    public void getDimBounds(Rect out) {
        this.getBounds(out);
    }

    void updateDisplayInfo(Rect bounds) {
        if (this.mDisplayContent == null) {
            return;
        }
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            ((Task)this.mChildren.get(taskNdx)).updateDisplayInfo(this.mDisplayContent);
        }
        if (bounds != null) {
            this.setBounds(bounds);
            return;
        }
        if (this.matchParentBounds()) {
            this.setBounds(null);
            return;
        }
        this.mTmpRect2.set(this.getRawBounds());
        int newRotation = this.mDisplayContent.getDisplayInfo().rotation;
        int newDensity = this.mDisplayContent.getDisplayInfo().logicalDensityDpi;
        if (this.mRotation == newRotation && this.mDensity == newDensity) {
            this.setBounds(this.mTmpRect2);
        }
    }

    boolean updateBoundsAfterConfigChange() {
        if (this.mDisplayContent == null) {
            return false;
        }
        if (this.inPinnedWindowingMode()) {
            this.getAnimationOrCurrentBounds(this.mTmpRect2);
            boolean updated = this.mDisplayContent.mPinnedStackControllerLocked.onTaskStackBoundsChanged(this.mTmpRect2, this.mTmpRect3);
            if (updated) {
                this.mBoundsAfterRotation.set(this.mTmpRect3);
                this.mBoundsAnimationTarget.setEmpty();
                this.mBoundsAnimationSourceHintBounds.setEmpty();
                this.mCancelCurrentBoundsAnimation = true;
                return true;
            }
        }
        int newRotation = this.getDisplayInfo().rotation;
        int newDensity = this.getDisplayInfo().logicalDensityDpi;
        if (this.mRotation == newRotation && this.mDensity == newDensity) {
            return false;
        }
        if (this.matchParentBounds()) {
            this.setBounds(null);
            return false;
        }
        this.mTmpRect2.set(this.getRawBounds());
        this.mDisplayContent.rotateBounds(this.mRotation, newRotation, this.mTmpRect2);
        if (this.inSplitScreenPrimaryWindowingMode()) {
            this.repositionPrimarySplitScreenStackAfterRotation(this.mTmpRect2);
            this.snapDockedStackAfterRotation(this.mTmpRect2);
            int newDockSide = this.getDockSide(this.mTmpRect2);
            this.mService.setDockedStackCreateStateLocked(newDockSide == 1 || newDockSide == 2 ? 0 : 1, null);
            this.mDisplayContent.getDockedDividerController().notifyDockSideChanged(newDockSide);
        }
        this.mBoundsAfterRotation.set(this.mTmpRect2);
        return true;
    }

    void getBoundsForNewConfiguration(Rect outBounds) {
        outBounds.set(this.mBoundsAfterRotation);
        this.mBoundsAfterRotation.setEmpty();
    }

    private void repositionPrimarySplitScreenStackAfterRotation(Rect inOutBounds) {
        int dockSide = this.getDockSide(inOutBounds);
        if (this.mDisplayContent.getDockedDividerController().canPrimaryStackDockTo(dockSide)) {
            return;
        }
        this.mDisplayContent.getBounds(this.mTmpRect);
        dockSide = DockedDividerUtils.invertDockSide(dockSide);
        switch (dockSide) {
            case 1: {
                int movement = inOutBounds.left;
                inOutBounds.left -= movement;
                inOutBounds.right -= movement;
                break;
            }
            case 3: {
                int movement = this.mTmpRect.right - inOutBounds.right;
                inOutBounds.left += movement;
                inOutBounds.right += movement;
                break;
            }
            case 2: {
                int movement = inOutBounds.top;
                inOutBounds.top -= movement;
                inOutBounds.bottom -= movement;
                break;
            }
            case 4: {
                int movement = this.mTmpRect.bottom - inOutBounds.bottom;
                inOutBounds.top += movement;
                inOutBounds.bottom += movement;
            }
        }
    }

    private void snapDockedStackAfterRotation(Rect outBounds) {
        DisplayInfo displayInfo = this.mDisplayContent.getDisplayInfo();
        int dividerSize = this.mDisplayContent.getDockedDividerController().getContentWidth();
        int dockSide = this.getDockSide(outBounds);
        int dividerPosition = DockedDividerUtils.calculatePositionForBounds(outBounds, dockSide, dividerSize);
        int displayWidth = displayInfo.logicalWidth;
        int displayHeight = displayInfo.logicalHeight;
        int rotation = displayInfo.rotation;
        int orientation = this.mDisplayContent.getConfiguration().orientation;
        this.mService.mPolicy.getStableInsetsLw(rotation, displayWidth, displayHeight, displayInfo.displayCutout, outBounds);
        DividerSnapAlgorithm algorithm = new DividerSnapAlgorithm(this.mService.mContext.getResources(), displayWidth, displayHeight, dividerSize, orientation == 1, outBounds, this.getDockSide(), this.isMinimizedDockAndHomeStackResizable());
        DividerSnapAlgorithm.SnapTarget target = algorithm.calculateNonDismissingSnapTarget(dividerPosition);
        DockedDividerUtils.calculateBoundsForPosition(target.position, dockSide, outBounds, displayInfo.logicalWidth, displayInfo.logicalHeight, dividerSize);
    }

    void addTask(Task task, int position) {
        this.addTask(task, position, task.showForAllUsers(), true);
    }

    void addTask(Task task, int position, boolean showForAllUsers, boolean moveParents) {
        TaskStack currentStack = task.mStack;
        if (currentStack != null && currentStack.mStackId != this.mStackId) {
            throw new IllegalStateException("Trying to add taskId=" + task.mTaskId + " to stackId=" + this.mStackId + ", but it is already attached to stackId=" + task.mStack.mStackId);
        }
        task.mStack = this;
        this.addChild(task, null);
        this.positionChildAt(position, task, moveParents, showForAllUsers);
    }

    @Override
    void positionChildAt(int position, Task child, boolean includingParents) {
        this.positionChildAt(position, child, includingParents, child.showForAllUsers());
    }

    private void positionChildAt(int position, Task child, boolean includingParents, boolean showForAllUsers) {
        int targetPosition = this.findPositionForTask(child, position, showForAllUsers, false);
        super.positionChildAt(targetPosition, child, includingParents);
        int toTop = targetPosition == this.mChildren.size() - 1 ? 1 : 0;
        EventLog.writeEvent(31002, child.mTaskId, toTop, targetPosition);
    }

    private int findPositionForTask(Task task, int targetPosition, boolean showForAllUsers, boolean addingNew) {
        int maxPosition;
        boolean canShowTask = showForAllUsers || this.mService.isCurrentProfileLocked(task.mUserId);
        int stackSize = this.mChildren.size();
        int minPosition = 0;
        int n = maxPosition = addingNew ? stackSize : stackSize - 1;
        if (canShowTask) {
            minPosition = this.computeMinPosition(minPosition, stackSize);
        } else {
            maxPosition = this.computeMaxPosition(maxPosition);
        }
        if (targetPosition == Integer.MIN_VALUE && minPosition == 0) {
            return Integer.MIN_VALUE;
        }
        if (targetPosition == Integer.MAX_VALUE && maxPosition == (addingNew ? stackSize : stackSize - 1)) {
            return Integer.MAX_VALUE;
        }
        return Math.min(Math.max(targetPosition, minPosition), maxPosition);
    }

    private int computeMinPosition(int minPosition, int size) {
        while (minPosition < size) {
            boolean canShowTmpTask;
            Task tmpTask = (Task)this.mChildren.get(minPosition);
            boolean bl = canShowTmpTask = tmpTask.showForAllUsers() || this.mService.isCurrentProfileLocked(tmpTask.mUserId);
            if (canShowTmpTask) break;
            ++minPosition;
        }
        return minPosition;
    }

    private int computeMaxPosition(int maxPosition) {
        while (maxPosition > 0) {
            boolean canShowTmpTask;
            Task tmpTask = (Task)this.mChildren.get(maxPosition);
            boolean bl = canShowTmpTask = tmpTask.showForAllUsers() || this.mService.isCurrentProfileLocked(tmpTask.mUserId);
            if (!canShowTmpTask) break;
            --maxPosition;
        }
        return maxPosition;
    }

    @Override
    void removeChild(Task task) {
        super.removeChild(task);
        task.mStack = null;
        if (this.mDisplayContent != null) {
            if (this.mChildren.isEmpty()) {
                this.getParent().positionChildAt(Integer.MIN_VALUE, this, false);
            }
            this.mDisplayContent.setLayoutNeeded();
        }
        for (int appNdx = this.mExitingAppTokens.size() - 1; appNdx >= 0; --appNdx) {
            AppWindowToken wtoken = (AppWindowToken)this.mExitingAppTokens.get(appNdx);
            if (wtoken.getTask() != task) continue;
            wtoken.mIsExiting = false;
            this.mExitingAppTokens.remove(appNdx);
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newParentConfig) {
        int prevWindowingMode = this.getWindowingMode();
        super.onConfigurationChanged(newParentConfig);
        this.updateSurfaceSize(this.getPendingTransaction());
        int windowingMode = this.getWindowingMode();
        if (this.mDisplayContent == null || prevWindowingMode == windowingMode) {
            return;
        }
        this.mDisplayContent.onStackWindowingModeChanged(this);
        this.updateBoundsForWindowModeChange();
    }

    private void updateSurfaceBounds() {
        this.updateSurfaceSize(this.getPendingTransaction());
        this.updateSurfacePosition();
        this.scheduleAnimation();
    }

    int getStackOutset() {
        DisplayContent displayContent = this.getDisplayContent();
        if (this.inPinnedWindowingMode() && displayContent != null) {
            DisplayMetrics displayMetrics = displayContent.getDisplayMetrics();
            return (int)Math.ceil(WindowManagerService.dipToPixel(5, displayMetrics) * 2);
        }
        return 0;
    }

    private void updateSurfaceSize(SurfaceControl.Transaction transaction) {
        if (this.mSurfaceControl == null) {
            return;
        }
        Rect stackBounds = this.getBounds();
        int width = stackBounds.width();
        int height = stackBounds.height();
        int outset = this.getStackOutset();
        if ((width += 2 * outset) == this.mLastSurfaceSize.x && (height += 2 * outset) == this.mLastSurfaceSize.y) {
            return;
        }
        transaction.setSize(this.mSurfaceControl, width, height);
        this.mLastSurfaceSize.set(width, height);
    }

    @Override
    void onDisplayChanged(DisplayContent dc) {
        if (this.mDisplayContent != null) {
            throw new IllegalStateException("onDisplayChanged: Already attached");
        }
        this.mDisplayContent = dc;
        this.updateBoundsForWindowModeChange();
        this.mAnimationBackgroundSurface = this.makeChildSurface(null).setColorLayer(true).setName("animation background stackId=" + this.mStackId).build();
        super.onDisplayChanged(dc);
    }

    private void updateBoundsForWindowModeChange() {
        Rect bounds = this.calculateBoundsForWindowModeChange();
        if (this.inSplitScreenSecondaryWindowingMode()) {
            this.forAllWindows((WindowState w) -> w.mWinAnimator.setOffsetPositionForStackResize(true), true);
        }
        this.updateDisplayInfo(bounds);
        this.updateSurfaceBounds();
    }

    private Rect calculateBoundsForWindowModeChange() {
        boolean inSplitScreenPrimary = this.inSplitScreenPrimaryWindowingMode();
        TaskStack splitScreenStack = this.mDisplayContent.getSplitScreenPrimaryStackIgnoringVisibility();
        if (inSplitScreenPrimary || splitScreenStack != null && this.inSplitScreenSecondaryWindowingMode() && !splitScreenStack.fillsParent()) {
            Rect bounds = new Rect();
            this.mDisplayContent.getBounds(this.mTmpRect);
            this.mTmpRect2.setEmpty();
            if (splitScreenStack != null) {
                if (this.inSplitScreenSecondaryWindowingMode() && this.mDisplayContent.mDividerControllerLocked.isMinimizedDock() && splitScreenStack.getTopChild() != null) {
                    ((Task)splitScreenStack.getTopChild()).getBounds(this.mTmpRect2);
                } else {
                    splitScreenStack.getRawBounds(this.mTmpRect2);
                }
            }
            boolean dockedOnTopOrLeft = this.mService.mDockedStackCreateMode == 0;
            this.getStackDockedModeBounds(this.mTmpRect, bounds, this.mTmpRect2, this.mDisplayContent.mDividerControllerLocked.getContentWidth(), dockedOnTopOrLeft);
            return bounds;
        }
        if (this.inPinnedWindowingMode()) {
            this.getAnimationOrCurrentBounds(this.mTmpRect2);
            if (this.mDisplayContent.mPinnedStackControllerLocked.onTaskStackBoundsChanged(this.mTmpRect2, this.mTmpRect3)) {
                return new Rect(this.mTmpRect3);
            }
        }
        return null;
    }

    void getStackDockedModeBoundsLocked(Rect currentTempTaskBounds, Rect outStackBounds, Rect outTempTaskBounds, boolean ignoreVisibility) {
        outTempTaskBounds.setEmpty();
        if (this.isActivityTypeHome()) {
            Task homeTask = this.findHomeTask();
            if (homeTask != null && homeTask.isResizeable()) {
                this.getDisplayContent().mDividerControllerLocked.getHomeStackBoundsInDockedMode(outStackBounds);
            } else {
                outStackBounds.setEmpty();
            }
            outTempTaskBounds.set(outStackBounds);
            return;
        }
        if (this.isMinimizedDockAndHomeStackResizable() && currentTempTaskBounds != null) {
            outStackBounds.set(currentTempTaskBounds);
            return;
        }
        if (!this.inSplitScreenWindowingMode() || this.mDisplayContent == null) {
            outStackBounds.set(this.getRawBounds());
            return;
        }
        TaskStack dockedStack = this.mDisplayContent.getSplitScreenPrimaryStackIgnoringVisibility();
        if (dockedStack == null) {
            throw new IllegalStateException("Calling getStackDockedModeBoundsLocked() when there is no docked stack.");
        }
        if (!ignoreVisibility && !dockedStack.isVisible()) {
            this.mDisplayContent.getBounds(outStackBounds);
            return;
        }
        int dockedSide = dockedStack.getDockSide();
        if (dockedSide == -1) {
            Slog.e("WindowManager", "Failed to get valid docked side for docked stack=" + dockedStack);
            outStackBounds.set(this.getRawBounds());
            return;
        }
        this.mDisplayContent.getBounds(this.mTmpRect);
        dockedStack.getRawBounds(this.mTmpRect2);
        boolean dockedOnTopOrLeft = dockedSide == 2 || dockedSide == 1;
        this.getStackDockedModeBounds(this.mTmpRect, outStackBounds, this.mTmpRect2, this.mDisplayContent.mDividerControllerLocked.getContentWidth(), dockedOnTopOrLeft);
    }

    private void getStackDockedModeBounds(Rect displayRect, Rect outBounds, Rect dockedBounds, int dockDividerWidth, boolean dockOnTopOrLeft) {
        boolean dockedStack = this.inSplitScreenPrimaryWindowingMode();
        boolean splitHorizontally = displayRect.width() > displayRect.height();
        outBounds.set(displayRect);
        if (dockedStack) {
            if (this.mService.mDockedStackCreateBounds != null) {
                outBounds.set(this.mService.mDockedStackCreateBounds);
                return;
            }
            DisplayInfo di = this.mDisplayContent.getDisplayInfo();
            this.mService.mPolicy.getStableInsetsLw(di.rotation, di.logicalWidth, di.logicalHeight, di.displayCutout, this.mTmpRect2);
            int position = new DividerSnapAlgorithm((Resources)this.mService.mContext.getResources(), (int)di.logicalWidth, (int)di.logicalHeight, (int)dockDividerWidth, (boolean)(this.mDisplayContent.getConfiguration().orientation == 1 ? true : false), (Rect)this.mTmpRect2).getMiddleTarget().position;
            if (dockOnTopOrLeft) {
                if (splitHorizontally) {
                    outBounds.right = position;
                } else {
                    outBounds.bottom = position;
                }
            } else if (splitHorizontally) {
                outBounds.left = position + dockDividerWidth;
            } else {
                outBounds.top = position + dockDividerWidth;
            }
            return;
        }
        if (!dockOnTopOrLeft) {
            if (splitHorizontally) {
                outBounds.right = dockedBounds.left - dockDividerWidth;
            } else {
                outBounds.bottom = dockedBounds.top - dockDividerWidth;
            }
        } else if (splitHorizontally) {
            outBounds.left = dockedBounds.right + dockDividerWidth;
        } else {
            outBounds.top = dockedBounds.bottom + dockDividerWidth;
        }
        DockedDividerUtils.sanitizeStackBounds(outBounds, !dockOnTopOrLeft);
    }

    void resetDockedStackToMiddle() {
        if (this.inSplitScreenPrimaryWindowingMode()) {
            throw new IllegalStateException("Not a docked stack=" + this);
        }
        this.mService.mDockedStackCreateBounds = null;
        Rect bounds = new Rect();
        Rect tempBounds = new Rect();
        this.getStackDockedModeBoundsLocked(null, bounds, tempBounds, true);
        this.getController().requestResize(bounds);
    }

    @Override
    StackWindowController getController() {
        return (StackWindowController)super.getController();
    }

    @Override
    void removeIfPossible() {
        if (this.isSelfOrChildAnimating()) {
            this.mDeferRemoval = true;
            return;
        }
        this.removeImmediately();
    }

    @Override
    void onParentSet() {
        super.onParentSet();
        if (this.getParent() != null || this.mDisplayContent == null) {
            return;
        }
        EventLog.writeEvent(31006, this.mStackId);
        if (this.mAnimationBackgroundSurface != null) {
            this.mAnimationBackgroundSurface.destroy();
            this.mAnimationBackgroundSurface = null;
        }
        this.mDisplayContent = null;
        this.mService.mWindowPlacerLocked.requestTraversal();
    }

    void resetAnimationBackgroundAnimator() {
        this.mAnimationBackgroundAnimator = null;
        this.hideAnimationSurface();
    }

    void setAnimationBackground(WindowStateAnimator winAnimator, int color2) {
        int animLayer = winAnimator.mAnimLayer;
        if (this.mAnimationBackgroundAnimator == null || animLayer < this.mAnimationBackgroundAnimator.mAnimLayer) {
            this.mAnimationBackgroundAnimator = winAnimator;
            animLayer = this.mDisplayContent.getLayerForAnimationBackground(winAnimator);
            this.showAnimationSurface((float)(color2 >> 24 & 0xFF) / 255.0f);
        }
    }

    @Override
    void switchUser() {
        super.switchUser();
        int top = this.mChildren.size();
        for (int taskNdx = 0; taskNdx < top; ++taskNdx) {
            Task task = (Task)this.mChildren.get(taskNdx);
            if (!this.mService.isCurrentProfileLocked(task.mUserId) && !task.showForAllUsers()) continue;
            this.mChildren.remove(taskNdx);
            this.mChildren.add(task);
            --top;
        }
    }

    void setAdjustedForIme(WindowState imeWin, boolean forceUpdate) {
        this.mImeWin = imeWin;
        this.mImeGoingAway = false;
        if (!this.mAdjustedForIme || forceUpdate) {
            this.mAdjustedForIme = true;
            this.mAdjustImeAmount = 0.0f;
            this.mAdjustDividerAmount = 0.0f;
            this.updateAdjustForIme(0.0f, 0.0f, true);
        }
    }

    boolean isAdjustedForIme() {
        return this.mAdjustedForIme;
    }

    boolean isAnimatingForIme() {
        return this.mImeWin != null && this.mImeWin.isAnimatingLw();
    }

    boolean updateAdjustForIme(float adjustAmount, float adjustDividerAmount, boolean force) {
        if (adjustAmount != this.mAdjustImeAmount || adjustDividerAmount != this.mAdjustDividerAmount || force) {
            this.mAdjustImeAmount = adjustAmount;
            this.mAdjustDividerAmount = adjustDividerAmount;
            this.updateAdjustedBounds();
            return this.isVisible();
        }
        return false;
    }

    void resetAdjustedForIme(boolean adjustBoundsNow) {
        if (adjustBoundsNow) {
            this.mImeWin = null;
            this.mImeGoingAway = false;
            this.mAdjustImeAmount = 0.0f;
            this.mAdjustDividerAmount = 0.0f;
            if (!this.mAdjustedForIme) {
                return;
            }
            this.mAdjustedForIme = false;
            this.updateAdjustedBounds();
            this.mService.setResizeDimLayer(false, this.getWindowingMode(), 1.0f);
        } else {
            this.mImeGoingAway |= this.mAdjustedForIme;
        }
    }

    boolean setAdjustedForMinimizedDock(float minimizeAmount) {
        if (minimizeAmount != this.mMinimizeAmount) {
            this.mMinimizeAmount = minimizeAmount;
            this.updateAdjustedBounds();
            return this.isVisible();
        }
        return false;
    }

    boolean shouldIgnoreInput() {
        return this.isAdjustedForMinimizedDockedStack() || this.inSplitScreenPrimaryWindowingMode() && this.isMinimizedDockAndHomeStackResizable();
    }

    void beginImeAdjustAnimation() {
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            Task task = (Task)this.mChildren.get(j);
            if (!task.hasContentToDisplay()) continue;
            task.setDragResizing(true, 1);
            task.setWaitingForDrawnIfResizingChanged();
        }
    }

    void endImeAdjustAnimation() {
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            ((Task)this.mChildren.get(j)).setDragResizing(false, 1);
        }
    }

    int getMinTopStackBottom(Rect displayContentRect, int originalStackBottom) {
        return displayContentRect.top + (int)((float)(originalStackBottom - displayContentRect.top) * 0.3f);
    }

    private boolean adjustForIME(WindowState imeWin) {
        boolean dockedTopOrBottom;
        int dockedSide = this.getDockSide();
        boolean bl = dockedTopOrBottom = dockedSide == 2 || dockedSide == 4;
        if (imeWin == null || !dockedTopOrBottom) {
            return false;
        }
        Rect displayStableRect = this.mTmpRect;
        Rect contentBounds = this.mTmpRect2;
        this.getDisplayContent().getStableRect(displayStableRect);
        contentBounds.set(displayStableRect);
        int imeTop = Math.max(imeWin.getFrameLw().top, contentBounds.top);
        if (contentBounds.bottom > (imeTop += imeWin.getGivenContentInsetsLw().top)) {
            contentBounds.bottom = imeTop;
        }
        int yOffset = displayStableRect.bottom - contentBounds.bottom;
        int dividerWidth = this.getDisplayContent().mDividerControllerLocked.getContentWidth();
        int dividerWidthInactive = this.getDisplayContent().mDividerControllerLocked.getContentWidthInactive();
        if (dockedSide == 2) {
            int minTopStackBottom = this.getMinTopStackBottom(displayStableRect, this.getRawBounds().bottom);
            int bottom = Math.max(this.getRawBounds().bottom - yOffset + dividerWidth - dividerWidthInactive, minTopStackBottom);
            this.mTmpAdjustedBounds.set(this.getRawBounds());
            this.mTmpAdjustedBounds.bottom = (int)(this.mAdjustImeAmount * (float)bottom + (1.0f - this.mAdjustImeAmount) * (float)this.getRawBounds().bottom);
            this.mFullyAdjustedImeBounds.set(this.getRawBounds());
        } else {
            int dividerWidthDelta = dividerWidthInactive - dividerWidth;
            int topBeforeImeAdjust = this.getRawBounds().top - dividerWidth + dividerWidthInactive;
            int minTopStackBottom = this.getMinTopStackBottom(displayStableRect, this.getRawBounds().top - dividerWidth);
            int top = Math.max(this.getRawBounds().top - yOffset, minTopStackBottom + dividerWidthInactive);
            this.mTmpAdjustedBounds.set(this.getRawBounds());
            this.mTmpAdjustedBounds.top = this.getRawBounds().top + (int)(this.mAdjustImeAmount * (float)(top - topBeforeImeAdjust) + this.mAdjustDividerAmount * (float)dividerWidthDelta);
            this.mFullyAdjustedImeBounds.set(this.getRawBounds());
            this.mFullyAdjustedImeBounds.top = top;
            this.mFullyAdjustedImeBounds.bottom = top + this.getRawBounds().height();
        }
        return true;
    }

    private boolean adjustForMinimizedDockedStack(float minimizeAmount) {
        int dockSide = this.getDockSide();
        if (dockSide == -1 && !this.mTmpAdjustedBounds.isEmpty()) {
            return false;
        }
        if (dockSide == 2) {
            this.mService.getStableInsetsLocked(0, this.mTmpRect);
            int topInset = this.mTmpRect.top;
            this.mTmpAdjustedBounds.set(this.getRawBounds());
            this.mTmpAdjustedBounds.bottom = (int)(minimizeAmount * (float)topInset + (1.0f - minimizeAmount) * (float)this.getRawBounds().bottom);
        } else if (dockSide == 1) {
            this.mTmpAdjustedBounds.set(this.getRawBounds());
            int width = this.getRawBounds().width();
            this.mTmpAdjustedBounds.right = (int)(minimizeAmount * (float)this.mDockedStackMinimizeThickness + (1.0f - minimizeAmount) * (float)this.getRawBounds().right);
            this.mTmpAdjustedBounds.left = this.mTmpAdjustedBounds.right - width;
        } else if (dockSide == 3) {
            this.mTmpAdjustedBounds.set(this.getRawBounds());
            this.mTmpAdjustedBounds.left = (int)(minimizeAmount * (float)(this.getRawBounds().right - this.mDockedStackMinimizeThickness) + (1.0f - minimizeAmount) * (float)this.getRawBounds().left);
        }
        return true;
    }

    private boolean isMinimizedDockAndHomeStackResizable() {
        return this.mDisplayContent.mDividerControllerLocked.isMinimizedDock() && this.mDisplayContent.mDividerControllerLocked.isHomeStackResizable();
    }

    int getMinimizeDistance() {
        int dockSide = this.getDockSide();
        if (dockSide == -1) {
            return 0;
        }
        if (dockSide == 2) {
            this.mService.getStableInsetsLocked(0, this.mTmpRect);
            int topInset = this.mTmpRect.top;
            return this.getRawBounds().bottom - topInset;
        }
        if (dockSide == 1 || dockSide == 3) {
            return this.getRawBounds().width() - this.mDockedStackMinimizeThickness;
        }
        return 0;
    }

    private void updateAdjustedBounds() {
        boolean isImeTarget;
        boolean adjust = false;
        if (this.mMinimizeAmount != 0.0f) {
            adjust = this.adjustForMinimizedDockedStack(this.mMinimizeAmount);
        } else if (this.mAdjustedForIme) {
            adjust = this.adjustForIME(this.mImeWin);
        }
        if (!adjust) {
            this.mTmpAdjustedBounds.setEmpty();
        }
        this.setAdjustedBounds(this.mTmpAdjustedBounds);
        boolean bl = isImeTarget = this.mService.getImeFocusStackLocked() == this;
        if (this.mAdjustedForIme && adjust && !isImeTarget) {
            float alpha = Math.max(this.mAdjustImeAmount, this.mAdjustDividerAmount) * 0.25f;
            this.mService.setResizeDimLayer(true, this.getWindowingMode(), alpha);
        }
    }

    void applyAdjustForImeIfNeeded(Task task) {
        if (this.mMinimizeAmount != 0.0f || !this.mAdjustedForIme || this.mAdjustedBounds.isEmpty()) {
            return;
        }
        Rect insetBounds = this.mImeGoingAway ? this.getRawBounds() : this.mFullyAdjustedImeBounds;
        task.alignToAdjustedBounds(this.mAdjustedBounds, insetBounds, this.getDockSide() == 2);
        this.mDisplayContent.setLayoutNeeded();
    }

    boolean isAdjustedForMinimizedDockedStack() {
        return this.mMinimizeAmount != 0.0f;
    }

    boolean isTaskAnimating() {
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            Task task = (Task)this.mChildren.get(j);
            if (!task.isTaskAnimating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, boolean trim) {
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, trim);
        proto.write(1120986464258L, this.mStackId);
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            ((Task)this.mChildren.get(taskNdx)).writeToProto(proto, 2246267895811L, trim);
        }
        proto.write(1133871366148L, this.matchParentBounds());
        this.getRawBounds().writeToProto(proto, 1146756268037L);
        proto.write(1133871366150L, this.mAnimationBackgroundSurfaceIsShown);
        proto.write(1133871366151L, this.mDeferRemoval);
        proto.write(1108101562376L, this.mMinimizeAmount);
        proto.write(1133871366153L, this.mAdjustedForIme);
        proto.write(1108101562378L, this.mAdjustImeAmount);
        proto.write(1108101562379L, this.mAdjustDividerAmount);
        this.mAdjustedBounds.writeToProto(proto, 1146756268044L);
        proto.write(1133871366157L, this.mBoundsAnimating);
        proto.end(token);
    }

    @Override
    void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        pw.println(prefix + "mStackId=" + this.mStackId);
        pw.println(prefix + "mDeferRemoval=" + this.mDeferRemoval);
        pw.println(prefix + "mBounds=" + this.getRawBounds().toShortString());
        if (this.mMinimizeAmount != 0.0f) {
            pw.println(prefix + "mMinimizeAmount=" + this.mMinimizeAmount);
        }
        if (this.mAdjustedForIme) {
            pw.println(prefix + "mAdjustedForIme=true");
            pw.println(prefix + "mAdjustImeAmount=" + this.mAdjustImeAmount);
            pw.println(prefix + "mAdjustDividerAmount=" + this.mAdjustDividerAmount);
        }
        if (!this.mAdjustedBounds.isEmpty()) {
            pw.println(prefix + "mAdjustedBounds=" + this.mAdjustedBounds.toShortString());
        }
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            ((Task)this.mChildren.get(taskNdx)).dump(pw, prefix + "  ", dumpAll);
        }
        if (this.mAnimationBackgroundSurfaceIsShown) {
            pw.println(prefix + "mWindowAnimationBackgroundSurface is shown");
        }
        if (!this.mExitingAppTokens.isEmpty()) {
            pw.println();
            pw.println("  Exiting application tokens:");
            for (int i = this.mExitingAppTokens.size() - 1; i >= 0; --i) {
                WindowToken token = (WindowToken)this.mExitingAppTokens.get(i);
                pw.print("  Exiting App #");
                pw.print(i);
                pw.print(' ');
                pw.print(token);
                pw.println(':');
                token.dump(pw, "    ", dumpAll);
            }
        }
        this.mAnimatingAppWindowTokenRegistry.dump(pw, "AnimatingApps:", prefix);
    }

    @Override
    boolean fillsParent() {
        if (this.useCurrentBounds()) {
            return this.matchParentBounds();
        }
        return true;
    }

    public String toString() {
        return "{stackId=" + this.mStackId + " tasks=" + this.mChildren + "}";
    }

    @Override
    String getName() {
        return this.toShortString();
    }

    public String toShortString() {
        return "Stack=" + this.mStackId;
    }

    int getDockSide() {
        return this.getDockSide(this.getRawBounds());
    }

    int getDockSideForDisplay(DisplayContent dc) {
        return this.getDockSide(dc, this.getRawBounds());
    }

    private int getDockSide(Rect bounds) {
        if (this.mDisplayContent == null) {
            return -1;
        }
        return this.getDockSide(this.mDisplayContent, bounds);
    }

    private int getDockSide(DisplayContent dc, Rect bounds) {
        if (!this.inSplitScreenWindowingMode()) {
            return -1;
        }
        dc.getBounds(this.mTmpRect);
        int orientation = dc.getConfiguration().orientation;
        return dc.getDockedDividerController().getDockSide(bounds, this.mTmpRect, orientation);
    }

    boolean hasTaskForUser(int userId) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            Task task = (Task)this.mChildren.get(i);
            if (task.mUserId != userId) continue;
            return true;
        }
        return false;
    }

    int taskIdFromPoint(int x, int y) {
        this.getBounds(this.mTmpRect);
        if (!this.mTmpRect.contains(x, y) || this.isAdjustedForMinimizedDockedStack()) {
            return -1;
        }
        for (int taskNdx = this.mChildren.size() - 1; taskNdx >= 0; --taskNdx) {
            Task task = (Task)this.mChildren.get(taskNdx);
            WindowState win = task.getTopVisibleAppMainWindow();
            if (win == null) continue;
            task.getDimBounds(this.mTmpRect);
            if (!this.mTmpRect.contains(x, y)) continue;
            return task.mTaskId;
        }
        return -1;
    }

    void findTaskForResizePoint(int x, int y, int delta, DisplayContent.TaskForResizePointSearchResult results) {
        if (!this.getWindowConfiguration().canResizeTask()) {
            results.searchDone = true;
            return;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            Task task = (Task)this.mChildren.get(i);
            if (task.isFullscreen()) {
                results.searchDone = true;
                return;
            }
            task.getDimBounds(this.mTmpRect);
            this.mTmpRect.inset(-delta, -delta);
            if (!this.mTmpRect.contains(x, y)) continue;
            this.mTmpRect.inset(delta, delta);
            results.searchDone = true;
            if (!this.mTmpRect.contains(x, y)) {
                results.taskForResize = task;
                return;
            }
            return;
        }
    }

    void setTouchExcludeRegion(Task focusedTask, int delta, Region touchExcludeRegion, Rect contentRect, Rect postExclude) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            Task task = (Task)this.mChildren.get(i);
            AppWindowToken token = task.getTopVisibleAppToken();
            if (token == null || !token.hasContentToDisplay()) continue;
            if (task.isActivityTypeHome() && this.isMinimizedDockAndHomeStackResizable()) {
                this.mDisplayContent.getBounds(this.mTmpRect);
            } else {
                task.getDimBounds(this.mTmpRect);
            }
            if (task == focusedTask) {
                postExclude.set(this.mTmpRect);
            }
            boolean isFreeformed = task.inFreeformWindowingMode();
            if (task == focusedTask && !isFreeformed) continue;
            if (isFreeformed) {
                this.mTmpRect.inset(-delta, -delta);
                this.mTmpRect.intersect(contentRect);
            }
            touchExcludeRegion.op(this.mTmpRect, Region.Op.DIFFERENCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean setPinnedStackSize(Rect stackBounds, Rect tempTaskBounds) {
        var3_3 = this.mService.mWindowMap;
        synchronized (var3_3) {
            WindowManagerService.boostPriorityForLockedSection();
            if (!this.mCancelCurrentBoundsAnimation) ** break block6
            v0 = false;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v0;
        {
            try {}
            catch (Throwable var4_5) {
                // MONITOREXIT @DISABLED, blocks:[3, 4] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw var4_5;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        try {
            this.mService.mActivityManager.resizePinnedStack(stackBounds, tempTaskBounds);
        }
        catch (RemoteException var3_4) {
            // empty catch block
        }
        return true;
    }

    void onAllWindowsDrawn() {
        if (!this.mBoundsAnimating && !this.mBoundsAnimatingRequested) {
            return;
        }
        this.mService.mBoundsAnimationController.onAllWindowsDrawn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAnimationStart(boolean schedulePipModeChangedCallback, boolean forceUpdate) {
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mBoundsAnimatingRequested = false;
                this.mBoundsAnimating = true;
                this.mCancelCurrentBoundsAnimation = false;
                if (schedulePipModeChangedCallback) {
                    this.forAllWindows((WindowState w) -> w.mWinAnimator.resetDrawState(), false);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        if (this.inPinnedWindowingMode()) {
            try {
                this.mService.mActivityManager.notifyPinnedStackAnimationStarted();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            PinnedStackWindowController controller = (PinnedStackWindowController)this.getController();
            if (schedulePipModeChangedCallback && controller != null) {
                controller.updatePictureInPictureModeForPinnedStackAnimation(null, forceUpdate);
            }
        }
    }

    @Override
    public void onAnimationEnd(boolean schedulePipModeChangedCallback, Rect finalStackSize, boolean moveToFullscreen) {
        if (this.inPinnedWindowingMode()) {
            PinnedStackWindowController controller = (PinnedStackWindowController)this.getController();
            if (schedulePipModeChangedCallback && controller != null) {
                controller.updatePictureInPictureModeForPinnedStackAnimation(this.mBoundsAnimationTarget, false);
            }
            if (finalStackSize != null) {
                this.setPinnedStackSize(finalStackSize, null);
            } else {
                this.onPipAnimationEndResize();
            }
            try {
                this.mService.mActivityManager.notifyPinnedStackAnimationEnded();
                if (moveToFullscreen) {
                    this.mService.mActivityManager.moveTasksToFullscreenStack(this.mStackId, true);
                }
            }
            catch (RemoteException remoteException) {}
        } else {
            this.onPipAnimationEndResize();
        }
    }

    public void onPipAnimationEndResize() {
        this.mBoundsAnimating = false;
        for (int i = 0; i < this.mChildren.size(); ++i) {
            Task t = (Task)this.mChildren.get(i);
            t.clearPreserveNonFloatingState();
        }
        this.mService.requestTraversal();
    }

    @Override
    public boolean shouldDeferStartOnMoveToFullscreen() {
        TaskStack homeStack = this.mDisplayContent.getHomeStack();
        if (homeStack == null) {
            return true;
        }
        Task homeTask = (Task)homeStack.getTopChild();
        if (homeTask == null) {
            return true;
        }
        AppWindowToken homeApp = homeTask.getTopVisibleAppToken();
        if (!homeTask.isVisible() || homeApp == null) {
            return true;
        }
        return !homeApp.allDrawn;
    }

    public boolean deferScheduleMultiWindowModeChanged() {
        if (this.inPinnedWindowingMode()) {
            return this.mBoundsAnimatingRequested || this.mBoundsAnimating;
        }
        return false;
    }

    public boolean isForceScaled() {
        return this.mBoundsAnimating;
    }

    public boolean isAnimatingBounds() {
        return this.mBoundsAnimating;
    }

    public boolean lastAnimatingBoundsWasToFullscreen() {
        return this.mBoundsAnimatingToFullscreen;
    }

    public boolean isAnimatingBoundsToFullscreen() {
        return this.isAnimatingBounds() && this.lastAnimatingBoundsWasToFullscreen();
    }

    public boolean pinnedStackResizeDisallowed() {
        return this.mBoundsAnimating && this.mCancelCurrentBoundsAnimation;
    }

    @Override
    boolean checkCompleteDeferredRemoval() {
        if (this.isSelfOrChildAnimating()) {
            return true;
        }
        if (this.mDeferRemoval) {
            this.removeImmediately();
        }
        return super.checkCompleteDeferredRemoval();
    }

    @Override
    int getOrientation() {
        return this.canSpecifyOrientation() ? super.getOrientation() : -2;
    }

    private boolean canSpecifyOrientation() {
        int windowingMode = this.getWindowingMode();
        int activityType = this.getActivityType();
        return windowingMode == 1 || activityType == 2 || activityType == 3 || activityType == 4;
    }

    @Override
    Dimmer getDimmer() {
        return this.mDimmer;
    }

    @Override
    void prepareSurfaces() {
        this.mDimmer.resetDimStates();
        super.prepareSurfaces();
        this.getDimBounds(this.mTmpDimBoundsRect);
        this.mTmpDimBoundsRect.offsetTo(0, 0);
        if (this.mDimmer.updateDims(this.getPendingTransaction(), this.mTmpDimBoundsRect)) {
            this.scheduleAnimation();
        }
    }

    public DisplayInfo getDisplayInfo() {
        return this.mDisplayContent.getDisplayInfo();
    }

    void dim(float alpha) {
        this.mDimmer.dimAbove(this.getPendingTransaction(), alpha);
        this.scheduleAnimation();
    }

    void stopDimming() {
        this.mDimmer.stopDim(this.getPendingTransaction());
        this.scheduleAnimation();
    }

    @Override
    void getRelativePosition(Point outPos) {
        super.getRelativePosition(outPos);
        int outset = this.getStackOutset();
        outPos.x -= outset;
        outPos.y -= outset;
    }

    AnimatingAppWindowTokenRegistry getAnimatingAppWindowTokenRegistry() {
        return this.mAnimatingAppWindowTokenRegistry;
    }
}

