/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.ClipData;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.IBinder;
import android.view.Display;
import android.view.IInputFilter;
import android.view.IWindow;
import android.view.InputChannel;
import android.view.MagnificationSpec;
import android.view.WindowInfo;
import com.android.server.input.InputManagerService;
import com.android.server.wm.DragState;
import java.util.List;

public abstract class WindowManagerInternal {
    public abstract void requestTraversalFromDisplayManager();

    public abstract void setMagnificationCallbacks(MagnificationCallbacks var1);

    public abstract void setMagnificationSpec(MagnificationSpec var1);

    public abstract void setForceShowMagnifiableBounds(boolean var1);

    public abstract void getMagnificationRegion(Region var1);

    public abstract MagnificationSpec getCompatibleMagnificationSpecForWindow(IBinder var1);

    public abstract void setWindowsForAccessibilityCallback(WindowsForAccessibilityCallback var1);

    public abstract void setInputFilter(IInputFilter var1);

    public abstract IBinder getFocusedWindowToken();

    public abstract boolean isKeyguardLocked();

    public abstract boolean isKeyguardShowingAndNotOccluded();

    public abstract void getWindowFrame(IBinder var1, Rect var2);

    public abstract void showGlobalActions();

    public abstract void waitForAllWindowsDrawn(Runnable var1, long var2);

    public abstract void addWindowToken(IBinder var1, int var2, int var3);

    public abstract void removeWindowToken(IBinder var1, boolean var2, int var3);

    public abstract void registerAppTransitionListener(AppTransitionListener var1);

    public abstract int getInputMethodWindowVisibleHeight();

    public abstract void saveLastInputMethodWindowForTransition();

    public abstract void clearLastInputMethodWindowForTransition();

    public abstract void updateInputMethodWindowStatus(IBinder var1, boolean var2, boolean var3, IBinder var4);

    public abstract boolean isHardKeyboardAvailable();

    public abstract void setOnHardKeyboardStatusChangeListener(OnHardKeyboardStatusChangeListener var1);

    public abstract boolean isStackVisible(int var1);

    public abstract boolean isDockedDividerResizing();

    public abstract void computeWindowsForAccessibility();

    public abstract void setVr2dDisplayId(int var1);

    public abstract void registerDragDropControllerCallback(IDragDropCallback var1);

    public abstract void lockNow();

    public abstract int getWindowOwnerUserId(IBinder var1);

    public static interface IDragDropCallback {
        default public boolean registerInputChannel(DragState state, Display display, InputManagerService service, InputChannel source) {
            state.register(display);
            return service.transferTouchFocus(source, state.getInputChannel());
        }

        default public boolean prePerformDrag(IWindow window, IBinder dragToken, int touchSource, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) {
            return true;
        }

        default public void postPerformDrag() {
        }

        default public void preReportDropResult(IWindow window, boolean consumed) {
        }

        default public void postReportDropResult() {
        }

        default public void preCancelDragAndDrop(IBinder dragToken) {
        }

        default public void postCancelDragAndDrop() {
        }
    }

    public static interface OnHardKeyboardStatusChangeListener {
        public void onHardKeyboardStatusChange(boolean var1);
    }

    public static abstract class AppTransitionListener {
        public void onAppTransitionPendingLocked() {
        }

        public void onAppTransitionCancelledLocked(int transit) {
        }

        public int onAppTransitionStartingLocked(int transit, IBinder openToken, IBinder closeToken, long duration, long statusBarAnimationStartTime, long statusBarAnimationDuration) {
            return 0;
        }

        public void onAppTransitionFinishedLocked(IBinder token) {
        }
    }

    public static interface MagnificationCallbacks {
        public void onMagnificationRegionChanged(Region var1);

        public void onRectangleOnScreenRequested(int var1, int var2, int var3, int var4);

        public void onRotationChanged(int var1);

        public void onUserContextChanged();
    }

    public static interface WindowsForAccessibilityCallback {
        public void onWindowsForAccessibilityChanged(List<WindowInfo> var1);
    }
}

