/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.Process;
import com.android.internal.annotations.GuardedBy;
import com.android.server.AnimationThread;
import com.android.server.ThreadPriorityBooster;
import com.android.server.wm.SurfaceAnimationThread;

class WindowManagerThreadPriorityBooster
extends ThreadPriorityBooster {
    private final Object mLock = new Object();
    private final int mAnimationThreadId = AnimationThread.get().getThreadId();
    private final int mSurfaceAnimationThreadId = SurfaceAnimationThread.get().getThreadId();
    @GuardedBy(value="mLock")
    private boolean mAppTransitionRunning;
    @GuardedBy(value="mLock")
    private boolean mBoundsAnimationRunning;

    WindowManagerThreadPriorityBooster() {
        super(-4, 5);
    }

    @Override
    public void boost() {
        int myTid = Process.myTid();
        if (myTid == this.mAnimationThreadId || myTid == this.mSurfaceAnimationThreadId) {
            return;
        }
        super.boost();
    }

    @Override
    public void reset() {
        int myTid = Process.myTid();
        if (myTid == this.mAnimationThreadId || myTid == this.mSurfaceAnimationThreadId) {
            return;
        }
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAppTransitionRunning(boolean running) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAppTransitionRunning != running) {
                this.mAppTransitionRunning = running;
                this.updatePriorityLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBoundsAnimationRunning(boolean running) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBoundsAnimationRunning != running) {
                this.mBoundsAnimationRunning = running;
                this.updatePriorityLocked();
            }
        }
    }

    @GuardedBy(value="mLock")
    private void updatePriorityLocked() {
        int priority = this.mAppTransitionRunning || this.mBoundsAnimationRunning ? -10 : -4;
        this.setBoostToPriority(priority);
        Process.setThreadPriority(this.mAnimationThreadId, priority);
        Process.setThreadPriority(this.mSurfaceAnimationThreadId, priority);
    }
}

