/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.Debug;
import android.os.Trace;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseIntArray;
import android.view.RemoteAnimationAdapter;
import android.view.RemoteAnimationDefinition;
import android.view.WindowManager;
import android.view.animation.Animation;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.AppTransition;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.SplashScreenStartingData;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;
import java.util.function.Predicate;

class WindowSurfacePlacer {
    private static final String TAG = "WindowManager";
    private final WindowManagerService mService;
    private final WallpaperController mWallpaperControllerLocked;
    private boolean mInLayout = false;
    private int mLayoutRepeatCount;
    static final int SET_UPDATE_ROTATION = 1;
    static final int SET_WALLPAPER_MAY_CHANGE = 2;
    static final int SET_FORCE_HIDING_CHANGED = 4;
    static final int SET_ORIENTATION_CHANGE_COMPLETE = 8;
    static final int SET_WALLPAPER_ACTION_PENDING = 16;
    private boolean mTraversalScheduled;
    private int mDeferDepth = 0;
    private final LayerAndToken mTmpLayerAndToken = new LayerAndToken();
    private final SparseIntArray mTempTransitionReasons = new SparseIntArray();
    private final Runnable mPerformSurfacePlacement;

    public WindowSurfacePlacer(WindowManagerService service) {
        this.mService = service;
        this.mWallpaperControllerLocked = this.mService.mRoot.mWallpaperController;
        this.mPerformSurfacePlacement = () -> {
            WindowHashMap windowHashMap = this.mService.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    this.performSurfacePlacement();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        };
    }

    void deferLayout() {
        ++this.mDeferDepth;
    }

    void continueLayout() {
        --this.mDeferDepth;
        if (this.mDeferDepth <= 0) {
            this.performSurfacePlacement();
        }
    }

    boolean isLayoutDeferred() {
        return this.mDeferDepth > 0;
    }

    final void performSurfacePlacement() {
        this.performSurfacePlacement(false);
    }

    final void performSurfacePlacement(boolean force) {
        if (this.mDeferDepth > 0 && !force) {
            return;
        }
        int loopCount = 6;
        do {
            this.mTraversalScheduled = false;
            this.performSurfacePlacementLoop();
            this.mService.mAnimationHandler.removeCallbacks(this.mPerformSurfacePlacement);
        } while (this.mTraversalScheduled && --loopCount > 0);
        this.mService.mRoot.mWallpaperActionPending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSurfacePlacementLoop() {
        if (this.mInLayout) {
            Slog.w(TAG, "performLayoutAndPlaceSurfacesLocked called while in layout. Callers=" + Debug.getCallers(3));
            return;
        }
        if (this.mService.mWaitingForConfig) {
            return;
        }
        if (!this.mService.mDisplayReady) {
            return;
        }
        Trace.traceBegin(32L, "wmLayout");
        this.mInLayout = true;
        boolean recoveringMemory = false;
        if (!this.mService.mForceRemoves.isEmpty()) {
            Object tmp;
            recoveringMemory = true;
            while (!this.mService.mForceRemoves.isEmpty()) {
                WindowState ws = this.mService.mForceRemoves.remove(0);
                Slog.i(TAG, "Force removing: " + ws);
                ws.removeImmediately();
            }
            Slog.w(TAG, "Due to memory failure, waiting a bit for next layout");
            Object object = tmp = new Object();
            synchronized (object) {
                try {
                    tmp.wait(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            this.mService.mRoot.performSurfacePlacement(recoveringMemory);
            this.mInLayout = false;
            if (this.mService.mRoot.isLayoutNeeded()) {
                if (++this.mLayoutRepeatCount < 6) {
                    this.requestTraversal();
                } else {
                    Slog.e(TAG, "Performed 6 layouts in a row. Skipping");
                    this.mLayoutRepeatCount = 0;
                }
            } else {
                this.mLayoutRepeatCount = 0;
            }
            if (this.mService.mWindowsChanged && !this.mService.mWindowChangeListeners.isEmpty()) {
                this.mService.mH.removeMessages(19);
                this.mService.mH.sendEmptyMessage(19);
            }
        }
        catch (RuntimeException e) {
            this.mInLayout = false;
            Slog.wtf(TAG, "Unhandled exception while laying out windows", e);
        }
        Trace.traceEnd(32L);
    }

    void debugLayoutRepeats(String msg, int pendingLayoutChanges) {
        if (this.mLayoutRepeatCount >= 4) {
            Slog.v(TAG, "Layouts looping: " + msg + ", mPendingLayoutChanges = 0x" + Integer.toHexString(pendingLayoutChanges));
        }
    }

    boolean isInLayout() {
        return this.mInLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int handleAppTransitionReadyLocked() {
        int layoutRedo;
        int appsCount = this.mService.mOpeningApps.size();
        if (!this.transitionGoodToGo(appsCount, this.mTempTransitionReasons)) {
            return 0;
        }
        Trace.traceBegin(32L, "AppTransitionReady");
        int transit = this.mService.mAppTransition.getAppTransition();
        if (this.mService.mSkipAppTransitionAnimation && !AppTransition.isKeyguardGoingAwayTransit(transit)) {
            transit = -1;
        }
        this.mService.mSkipAppTransitionAnimation = false;
        this.mService.mNoAnimationNotifyOnTransitionFinished.clear();
        this.mService.mH.removeMessages(13);
        DisplayContent displayContent = this.mService.getDefaultDisplayContentLocked();
        this.mService.mRoot.mWallpaperMayChange = false;
        for (int i = 0; i < appsCount; ++i) {
            AppWindowToken wtoken = this.mService.mOpeningApps.valueAt(i);
            wtoken.clearAnimatingFlags();
        }
        this.mWallpaperControllerLocked.adjustWallpaperWindowsForAppTransitionIfNeeded(displayContent, this.mService.mOpeningApps);
        boolean hasWallpaperTarget = this.mWallpaperControllerLocked.getWallpaperTarget() != null;
        boolean openingAppHasWallpaper = this.canBeWallpaperTarget(this.mService.mOpeningApps) && hasWallpaperTarget;
        boolean closingAppHasWallpaper = this.canBeWallpaperTarget(this.mService.mClosingApps) && hasWallpaperTarget;
        transit = this.maybeUpdateTransitToTranslucentAnim(transit);
        transit = this.maybeUpdateTransitToWallpaper(transit, openingAppHasWallpaper, closingAppHasWallpaper);
        ArraySet<Integer> activityTypes = this.collectActivityTypes(this.mService.mOpeningApps, this.mService.mClosingApps);
        AppWindowToken animLpToken = this.mService.mPolicy.allowAppAnimationsLw() ? this.findAnimLayoutParamsToken(transit, activityTypes) : null;
        WindowManager.LayoutParams animLp = WindowSurfacePlacer.getAnimLp(animLpToken);
        this.overrideWithRemoteAnimationIfSet(animLpToken, transit, activityTypes);
        boolean voiceInteraction = this.containsVoiceInteraction(this.mService.mOpeningApps) || this.containsVoiceInteraction(this.mService.mOpeningApps);
        this.mService.mSurfaceAnimationRunner.deferStartingAnimations();
        try {
            this.processApplicationsAnimatingInPlace(transit);
            this.mTmpLayerAndToken.token = null;
            this.handleClosingApps(transit, animLp, voiceInteraction, this.mTmpLayerAndToken);
            AppWindowToken topClosingApp = this.mTmpLayerAndToken.token;
            AppWindowToken topOpeningApp = this.handleOpeningApps(transit, animLp, voiceInteraction);
            this.mService.mAppTransition.setLastAppTransition(transit, topOpeningApp, topClosingApp);
            int flags = this.mService.mAppTransition.getTransitFlags();
            layoutRedo = this.mService.mAppTransition.goodToGo(transit, topOpeningApp, topClosingApp, this.mService.mOpeningApps, this.mService.mClosingApps);
            this.handleNonAppWindowsInTransition(transit, flags);
            this.mService.mAppTransition.postAnimationCallback();
            this.mService.mAppTransition.clear();
        }
        finally {
            this.mService.mSurfaceAnimationRunner.continueStartingAnimations();
        }
        this.mService.mTaskSnapshotController.onTransitionStarting();
        this.mService.mOpeningApps.clear();
        this.mService.mClosingApps.clear();
        this.mService.mUnknownAppVisibilityController.clear();
        displayContent.setLayoutNeeded();
        DisplayContent dc = this.mService.getDefaultDisplayContentLocked();
        dc.computeImeTarget(true);
        this.mService.updateFocusedWindowLocked(2, true);
        this.mService.mFocusMayChange = false;
        this.mService.mH.obtainMessage(47, this.mTempTransitionReasons.clone()).sendToTarget();
        Trace.traceEnd(32L);
        return layoutRedo | 1 | 2;
    }

    private static WindowManager.LayoutParams getAnimLp(AppWindowToken wtoken) {
        WindowState mainWindow = wtoken != null ? wtoken.findMainWindow() : null;
        return mainWindow != null ? mainWindow.mAttrs : null;
    }

    private void overrideWithRemoteAnimationIfSet(AppWindowToken animLpToken, int transit, ArraySet<Integer> activityTypes) {
        RemoteAnimationAdapter adapter;
        if (transit == 26) {
            return;
        }
        if (animLpToken == null) {
            return;
        }
        RemoteAnimationDefinition definition = animLpToken.getRemoteAnimationDefinition();
        if (definition != null && (adapter = definition.getAdapter(transit, activityTypes)) != null) {
            this.mService.mAppTransition.overridePendingAppTransitionRemote(adapter);
        }
    }

    private AppWindowToken findAnimLayoutParamsToken(int transit, ArraySet<Integer> activityTypes) {
        AppWindowToken result = this.lookForHighestTokenWithFilter(this.mService.mClosingApps, this.mService.mOpeningApps, w -> w.getRemoteAnimationDefinition() != null && w.getRemoteAnimationDefinition().hasTransition(transit, activityTypes));
        if (result != null) {
            return result;
        }
        result = this.lookForHighestTokenWithFilter(this.mService.mClosingApps, this.mService.mOpeningApps, w -> w.fillsParent() && w.findMainWindow() != null);
        if (result != null) {
            return result;
        }
        return this.lookForHighestTokenWithFilter(this.mService.mClosingApps, this.mService.mOpeningApps, w -> w.findMainWindow() != null);
    }

    private ArraySet<Integer> collectActivityTypes(ArraySet<AppWindowToken> array1, ArraySet<AppWindowToken> array2) {
        int i;
        ArraySet<Integer> result = new ArraySet<Integer>();
        for (i = array1.size() - 1; i >= 0; --i) {
            result.add(array1.valueAt(i).getActivityType());
        }
        for (i = array2.size() - 1; i >= 0; --i) {
            result.add(array2.valueAt(i).getActivityType());
        }
        return result;
    }

    private AppWindowToken lookForHighestTokenWithFilter(ArraySet<AppWindowToken> array1, ArraySet<AppWindowToken> array2, Predicate<AppWindowToken> filter) {
        int array1count = array1.size();
        int count = array1count + array2.size();
        int bestPrefixOrderIndex = Integer.MIN_VALUE;
        AppWindowToken bestToken = null;
        for (int i = 0; i < count; ++i) {
            AppWindowToken wtoken = i < array1count ? array1.valueAt(i) : array2.valueAt(i - array1count);
            int prefixOrderIndex = wtoken.getPrefixOrderIndex();
            if (!filter.test(wtoken) || prefixOrderIndex <= bestPrefixOrderIndex) continue;
            bestPrefixOrderIndex = prefixOrderIndex;
            bestToken = wtoken;
        }
        return bestToken;
    }

    private boolean containsVoiceInteraction(ArraySet<AppWindowToken> apps) {
        for (int i = apps.size() - 1; i >= 0; --i) {
            if (!apps.valueAt((int)i).mVoiceInteraction) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppWindowToken handleOpeningApps(int transit, WindowManager.LayoutParams animLp, boolean voiceInteraction) {
        AppWindowToken topOpeningApp = null;
        int topOpeningLayer = Integer.MIN_VALUE;
        int appsCount = this.mService.mOpeningApps.size();
        for (int i = 0; i < appsCount; ++i) {
            AppWindowToken wtoken = this.mService.mOpeningApps.valueAt(i);
            if (!wtoken.setVisibility(animLp, true, transit, false, voiceInteraction)) {
                this.mService.mNoAnimationNotifyOnTransitionFinished.add(wtoken.token);
            }
            wtoken.updateReportedVisibilityLocked();
            wtoken.waitingToShow = false;
            this.mService.openSurfaceTransaction();
            try {
                wtoken.showAllWindowsLocked();
            }
            finally {
                this.mService.closeSurfaceTransaction("handleAppTransitionReadyLocked");
            }
            if (animLp != null) {
                int layer = wtoken.getHighestAnimLayer();
                if (topOpeningApp == null || layer > topOpeningLayer) {
                    topOpeningApp = wtoken;
                    topOpeningLayer = layer;
                }
            }
            if (this.mService.mAppTransition.isNextAppTransitionThumbnailUp()) {
                wtoken.attachThumbnailAnimation();
                continue;
            }
            if (!this.mService.mAppTransition.isNextAppTransitionOpenCrossProfileApps()) continue;
            wtoken.attachCrossProfileAppsThumbnailAnimation();
        }
        return topOpeningApp;
    }

    private void handleClosingApps(int transit, WindowManager.LayoutParams animLp, boolean voiceInteraction, LayerAndToken layerAndToken) {
        int appsCount = this.mService.mClosingApps.size();
        for (int i = 0; i < appsCount; ++i) {
            AppWindowToken wtoken = this.mService.mClosingApps.valueAt(i);
            wtoken.setVisibility(animLp, false, transit, false, voiceInteraction);
            wtoken.updateReportedVisibilityLocked();
            wtoken.allDrawn = true;
            wtoken.deferClearAllDrawn = false;
            if (wtoken.startingWindow != null && !wtoken.startingWindow.mAnimatingExit && wtoken.getController() != null) {
                wtoken.getController().removeStartingWindow();
            }
            if (animLp != null) {
                int layer = wtoken.getHighestAnimLayer();
                if (layerAndToken.token == null || layer > layerAndToken.layer) {
                    layerAndToken.token = wtoken;
                    layerAndToken.layer = layer;
                }
            }
            if (!this.mService.mAppTransition.isNextAppTransitionThumbnailDown()) continue;
            wtoken.attachThumbnailAnimation();
        }
    }

    private void handleNonAppWindowsInTransition(int transit, int flags) {
        Animation anim2;
        if (transit == 20 && (flags & 4) != 0 && (flags & 2) == 0 && (anim2 = this.mService.mPolicy.createKeyguardWallpaperExit((flags & 1) != 0)) != null) {
            this.mService.getDefaultDisplayContentLocked().mWallpaperController.startWallpaperAnimation(anim2);
        }
        if (transit == 20 || transit == 21) {
            this.mService.getDefaultDisplayContentLocked().startKeyguardExitOnNonAppWindows(transit == 21, (flags & 1) != 0);
        }
    }

    private boolean transitionGoodToGo(int appsCount, SparseIntArray outReasons) {
        ScreenRotationAnimation screenRotationAnimation = this.mService.mAnimator.getScreenRotationAnimationLocked(0);
        outReasons.clear();
        if (!this.mService.mAppTransition.isTimeout()) {
            boolean wallpaperReady;
            if (screenRotationAnimation != null && screenRotationAnimation.isAnimating() && this.mService.rotationNeedsUpdateLocked()) {
                return false;
            }
            for (int i = 0; i < appsCount; ++i) {
                boolean allDrawn;
                AppWindowToken wtoken = this.mService.mOpeningApps.valueAt(i);
                boolean bl = allDrawn = wtoken.allDrawn && !wtoken.isRelaunching();
                if (!(allDrawn || wtoken.startingDisplayed || wtoken.startingMoved)) {
                    return false;
                }
                int windowingMode = wtoken.getWindowingMode();
                if (allDrawn) {
                    outReasons.put(windowingMode, 2);
                    continue;
                }
                outReasons.put(windowingMode, wtoken.startingData instanceof SplashScreenStartingData ? 1 : 4);
            }
            if (this.mService.mAppTransition.isFetchingAppTransitionsSpecs()) {
                return false;
            }
            if (!this.mService.mUnknownAppVisibilityController.allResolved()) {
                return false;
            }
            boolean bl = wallpaperReady = !this.mWallpaperControllerLocked.isWallpaperVisible() || this.mWallpaperControllerLocked.wallpaperTransitionReady();
            return wallpaperReady;
        }
        return true;
    }

    private int maybeUpdateTransitToWallpaper(int transit, boolean openingAppHasWallpaper, boolean closingAppHasWallpaper) {
        if (transit == 0 || transit == 26 || transit == 19) {
            return transit;
        }
        WindowState wallpaperTarget = this.mWallpaperControllerLocked.getWallpaperTarget();
        WindowState oldWallpaper = this.mWallpaperControllerLocked.isWallpaperTargetAnimating() ? null : wallpaperTarget;
        ArraySet<AppWindowToken> openingApps = this.mService.mOpeningApps;
        ArraySet<AppWindowToken> closingApps = this.mService.mClosingApps;
        AppWindowToken topOpeningApp = this.getTopApp(this.mService.mOpeningApps, false);
        AppWindowToken topClosingApp = this.getTopApp(this.mService.mClosingApps, true);
        boolean openingCanBeWallpaperTarget = this.canBeWallpaperTarget(openingApps);
        if (openingCanBeWallpaperTarget && transit == 20) {
            transit = 21;
        } else if (!AppTransition.isKeyguardGoingAwayTransit(transit)) {
            if (closingAppHasWallpaper && openingAppHasWallpaper) {
                switch (transit) {
                    case 6: 
                    case 8: 
                    case 10: {
                        transit = 14;
                        break;
                    }
                    case 7: 
                    case 9: 
                    case 11: {
                        transit = 15;
                    }
                }
            } else if (oldWallpaper != null && !this.mService.mOpeningApps.isEmpty() && !openingApps.contains(oldWallpaper.mAppToken) && closingApps.contains(oldWallpaper.mAppToken) && topClosingApp == oldWallpaper.mAppToken) {
                transit = 12;
            } else if (wallpaperTarget != null && wallpaperTarget.isVisibleLw() && openingApps.contains(wallpaperTarget.mAppToken) && topOpeningApp == wallpaperTarget.mAppToken && transit != 25) {
                transit = 13;
            }
        }
        return transit;
    }

    @VisibleForTesting
    int maybeUpdateTransitToTranslucentAnim(int transit) {
        boolean taskOrActivity = AppTransition.isTaskTransit(transit) || AppTransition.isActivityTransit(transit);
        boolean allOpeningVisible = true;
        boolean allTranslucentOpeningApps = !this.mService.mOpeningApps.isEmpty();
        for (int i = this.mService.mOpeningApps.size() - 1; i >= 0; --i) {
            AppWindowToken token = this.mService.mOpeningApps.valueAt(i);
            if (token.isVisible()) continue;
            allOpeningVisible = false;
            if (!token.fillsParent()) continue;
            allTranslucentOpeningApps = false;
        }
        boolean allTranslucentClosingApps = !this.mService.mClosingApps.isEmpty();
        for (int i = this.mService.mClosingApps.size() - 1; i >= 0; --i) {
            if (!this.mService.mClosingApps.valueAt(i).fillsParent()) continue;
            allTranslucentClosingApps = false;
            break;
        }
        if (taskOrActivity && allTranslucentClosingApps && allOpeningVisible) {
            return 25;
        }
        if (taskOrActivity && allTranslucentOpeningApps && this.mService.mClosingApps.isEmpty()) {
            return 24;
        }
        return transit;
    }

    private boolean canBeWallpaperTarget(ArraySet<AppWindowToken> apps) {
        for (int i = apps.size() - 1; i >= 0; --i) {
            if (!apps.valueAt(i).windowsCanBeWallpaperTarget()) continue;
            return true;
        }
        return false;
    }

    private AppWindowToken getTopApp(ArraySet<AppWindowToken> apps, boolean ignoreHidden) {
        int topPrefixOrderIndex = Integer.MIN_VALUE;
        AppWindowToken topApp = null;
        for (int i = apps.size() - 1; i >= 0; --i) {
            int prefixOrderIndex;
            AppWindowToken app = apps.valueAt(i);
            if (ignoreHidden && app.isHidden() || (prefixOrderIndex = app.getPrefixOrderIndex()) <= topPrefixOrderIndex) continue;
            topPrefixOrderIndex = prefixOrderIndex;
            topApp = app;
        }
        return topApp;
    }

    private void processApplicationsAnimatingInPlace(int transit) {
        WindowState win;
        if (transit == 17 && (win = this.mService.getDefaultDisplayContentLocked().findFocusedWindow()) != null) {
            AppWindowToken wtoken = win.mAppToken;
            wtoken.cancelAnimation();
            wtoken.applyAnimationLocked(null, transit, false, false);
            wtoken.updateReportedVisibilityLocked();
            wtoken.showAllWindowsLocked();
        }
    }

    void requestTraversal() {
        if (!this.mTraversalScheduled) {
            this.mTraversalScheduled = true;
            this.mService.mAnimationHandler.post(this.mPerformSurfacePlacement);
        }
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "mTraversalScheduled=" + this.mTraversalScheduled);
        pw.println(prefix + "mHoldScreenWindow=" + this.mService.mRoot.mHoldScreenWindow);
        pw.println(prefix + "mObscuringWindow=" + this.mService.mRoot.mObscuringWindow);
    }

    private static final class LayerAndToken {
        public int layer;
        public AppWindowToken token;

        private LayerAndToken() {
        }
    }
}

