/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm.utils;

import android.util.SparseArray;

public class RotationCache<T, R> {
    private final RotationDependentComputation<T, R> mComputation;
    private final SparseArray<R> mCache = new SparseArray(4);
    private T mCachedFor;

    public RotationCache(RotationDependentComputation<T, R> computation) {
        this.mComputation = computation;
    }

    public R getOrCompute(T t, int rotation) {
        int idx;
        if (t != this.mCachedFor) {
            this.mCache.clear();
            this.mCachedFor = t;
        }
        if ((idx = this.mCache.indexOfKey(rotation)) >= 0) {
            return this.mCache.valueAt(idx);
        }
        R result = this.mComputation.compute(t, rotation);
        this.mCache.put(rotation, result);
        return result;
    }

    @FunctionalInterface
    public static interface RotationDependentComputation<T, R> {
        public R compute(T var1, int var2);
    }
}

