/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm.utils;

import android.graphics.Rect;
import android.util.Size;
import android.view.DisplayCutout;
import java.util.List;
import java.util.Objects;

public class WmDisplayCutout {
    public static final WmDisplayCutout NO_CUTOUT = new WmDisplayCutout(DisplayCutout.NO_CUTOUT, null);
    private final DisplayCutout mInner;
    private final Size mFrameSize;

    public WmDisplayCutout(DisplayCutout inner, Size frameSize) {
        this.mInner = inner;
        this.mFrameSize = frameSize;
    }

    public static WmDisplayCutout computeSafeInsets(DisplayCutout inner, int displayWidth, int displayHeight) {
        if (inner == DisplayCutout.NO_CUTOUT || inner.isBoundsEmpty()) {
            return NO_CUTOUT;
        }
        Size displaySize = new Size(displayWidth, displayHeight);
        Rect safeInsets = WmDisplayCutout.computeSafeInsets(displaySize, inner);
        return new WmDisplayCutout(inner.replaceSafeInsets(safeInsets), displaySize);
    }

    public WmDisplayCutout inset(int insetLeft, int insetTop, int insetRight, int insetBottom) {
        DisplayCutout newInner = this.mInner.inset(insetLeft, insetTop, insetRight, insetBottom);
        if (this.mInner == newInner) {
            return this;
        }
        Size frame = this.mFrameSize == null ? null : new Size(this.mFrameSize.getWidth() - insetLeft - insetRight, this.mFrameSize.getHeight() - insetTop - insetBottom);
        return new WmDisplayCutout(newInner, frame);
    }

    public WmDisplayCutout calculateRelativeTo(Rect frame) {
        if (this.mInner.isEmpty()) {
            return this;
        }
        return this.inset(frame.left, frame.top, this.mFrameSize.getWidth() - frame.right, this.mFrameSize.getHeight() - frame.bottom);
    }

    public WmDisplayCutout computeSafeInsets(int width, int height) {
        return WmDisplayCutout.computeSafeInsets(this.mInner, width, height);
    }

    private static Rect computeSafeInsets(Size displaySize, DisplayCutout cutout) {
        if (displaySize.getWidth() < displaySize.getHeight()) {
            List<Rect> boundingRects = cutout.replaceSafeInsets(new Rect(0, displaySize.getHeight() / 2, 0, displaySize.getHeight() / 2)).getBoundingRects();
            int topInset = WmDisplayCutout.findInsetForSide(displaySize, boundingRects, 48);
            int bottomInset = WmDisplayCutout.findInsetForSide(displaySize, boundingRects, 80);
            return new Rect(0, topInset, 0, bottomInset);
        }
        if (displaySize.getWidth() > displaySize.getHeight()) {
            List<Rect> boundingRects = cutout.replaceSafeInsets(new Rect(displaySize.getWidth() / 2, 0, displaySize.getWidth() / 2, 0)).getBoundingRects();
            int leftInset = WmDisplayCutout.findInsetForSide(displaySize, boundingRects, 3);
            int right = WmDisplayCutout.findInsetForSide(displaySize, boundingRects, 5);
            return new Rect(leftInset, 0, right, 0);
        }
        throw new UnsupportedOperationException("not implemented: display=" + displaySize + " cutout=" + cutout);
    }

    private static int findInsetForSide(Size display, List<Rect> boundingRects, int gravity) {
        int inset = 0;
        int size = boundingRects.size();
        block6: for (int i = 0; i < size; ++i) {
            Rect boundingRect = boundingRects.get(i);
            switch (gravity) {
                case 48: {
                    if (boundingRect.top != 0) continue block6;
                    inset = Math.max(inset, boundingRect.bottom);
                    continue block6;
                }
                case 80: {
                    if (boundingRect.bottom != display.getHeight()) continue block6;
                    inset = Math.max(inset, display.getHeight() - boundingRect.top);
                    continue block6;
                }
                case 3: {
                    if (boundingRect.left != 0) continue block6;
                    inset = Math.max(inset, boundingRect.right);
                    continue block6;
                }
                case 5: {
                    if (boundingRect.right != display.getWidth()) continue block6;
                    inset = Math.max(inset, display.getWidth() - boundingRect.left);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("unknown gravity: " + gravity);
                }
            }
        }
        return inset;
    }

    public DisplayCutout getDisplayCutout() {
        return this.mInner;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WmDisplayCutout)) {
            return false;
        }
        WmDisplayCutout that = (WmDisplayCutout)o;
        return Objects.equals(this.mInner, that.mInner) && Objects.equals(this.mFrameSize, that.mFrameSize);
    }

    public int hashCode() {
        return Objects.hash(this.mInner, this.mFrameSize);
    }
}

