/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class GestureDescription
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int MAX_STROKE_COUNT = 10;
    private static long MAX_GESTURE_DURATION_MS = 60000L;
    private List<StrokeDescription> mStrokes;
    private float[] mTempPos;

    private static final int $$robo$$android_accessibilityservice_GestureDescription$getMaxStrokeCount() {
        return 10;
    }

    private static final long $$robo$$android_accessibilityservice_GestureDescription$getMaxGestureDuration() {
        return 60000L;
    }

    private void $$robo$$android_accessibilityservice_GestureDescription$__constructor__() {
        this.mStrokes = new ArrayList<StrokeDescription>();
        this.mTempPos = new float[2];
    }

    private void $$robo$$android_accessibilityservice_GestureDescription$__constructor__(List<StrokeDescription> strokes) {
        this.mStrokes = new ArrayList<StrokeDescription>();
        this.mTempPos = new float[2];
        this.mStrokes.addAll(strokes);
    }

    private final int $$robo$$android_accessibilityservice_GestureDescription$getStrokeCount() {
        return this.mStrokes.size();
    }

    private final StrokeDescription $$robo$$android_accessibilityservice_GestureDescription$getStroke(int index) {
        return this.mStrokes.get(index);
    }

    private final long $$robo$$android_accessibilityservice_GestureDescription$getNextKeyPointAtLeast(long offset) {
        long nextKeyPoint = Long.MAX_VALUE;
        for (int i = 0; i < this.mStrokes.size(); ++i) {
            long thisEndTime;
            long thisStartTime = this.mStrokes.get((int)i).mStartTime;
            if (thisStartTime < nextKeyPoint && thisStartTime >= offset) {
                nextKeyPoint = thisStartTime;
            }
            if ((thisEndTime = this.mStrokes.get((int)i).mEndTime) >= nextKeyPoint || thisEndTime < offset) continue;
            nextKeyPoint = thisEndTime;
        }
        return nextKeyPoint == Long.MAX_VALUE ? -1L : nextKeyPoint;
    }

    private final int $$robo$$android_accessibilityservice_GestureDescription$getPointsForTime(long time, TouchPoint[] touchPoints) {
        int numPointsFound = 0;
        for (int i = 0; i < this.mStrokes.size(); ++i) {
            StrokeDescription strokeDescription = this.mStrokes.get(i);
            if (!strokeDescription.hasPointForTime(time)) continue;
            touchPoints[numPointsFound].mStrokeId = strokeDescription.getId();
            touchPoints[numPointsFound].mContinuedStrokeId = strokeDescription.getContinuedStrokeId();
            touchPoints[numPointsFound].mIsStartOfPath = strokeDescription.getContinuedStrokeId() < 0 && time == strokeDescription.mStartTime;
            touchPoints[numPointsFound].mIsEndOfPath = !strokeDescription.willContinue() && time == strokeDescription.mEndTime;
            strokeDescription.getPosForTime(time, this.mTempPos);
            touchPoints[numPointsFound].mX = Math.round(this.mTempPos[0]);
            touchPoints[numPointsFound].mY = Math.round(this.mTempPos[1]);
            ++numPointsFound;
        }
        return numPointsFound;
    }

    private static final long $$robo$$android_accessibilityservice_GestureDescription$getTotalDuration(List<StrokeDescription> paths) {
        long latestEnd = Long.MIN_VALUE;
        for (int i = 0; i < paths.size(); ++i) {
            StrokeDescription path = paths.get(i);
            latestEnd = Math.max(latestEnd, path.mEndTime);
        }
        return Math.max(latestEnd, 0L);
    }

    private /* synthetic */ void $$robo$$android_accessibilityservice_GestureDescription$__constructor__(List x0, 1 x1) {
    }

    public static int getMaxStrokeCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxStrokeCount", $$robo$$android_accessibilityservice_GestureDescription$getMaxStrokeCount(), 0);
    }

    public static long getMaxGestureDuration() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getMaxGestureDuration", $$robo$$android_accessibilityservice_GestureDescription$getMaxGestureDuration(), 0);
    }

    private void __constructor__() {
        this.$$robo$$android_accessibilityservice_GestureDescription$__constructor__();
    }

    private GestureDescription() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription$__constructor__(), 0, this);
    }

    private void __constructor__(List<StrokeDescription> list) {
        this.$$robo$$android_accessibilityservice_GestureDescription$__constructor__(list);
    }

    private GestureDescription(List<StrokeDescription> list) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription$__constructor__(java.util.List<android.accessibilityservice.GestureDescription$StrokeDescription> ), 0, this, list);
    }

    public int getStrokeCount() {
        return (int)InvokeDynamicSupport.bootstrap("getStrokeCount", $$robo$$android_accessibilityservice_GestureDescription$getStrokeCount(), 0, this);
    }

    public StrokeDescription getStroke(int n) {
        return InvokeDynamicSupport.bootstrap("getStroke", $$robo$$android_accessibilityservice_GestureDescription$getStroke(int ), 0, this, n);
    }

    private long getNextKeyPointAtLeast(long l) {
        return (long)InvokeDynamicSupport.bootstrap("getNextKeyPointAtLeast", $$robo$$android_accessibilityservice_GestureDescription$getNextKeyPointAtLeast(long ), 0, this, l);
    }

    private int getPointsForTime(long l, TouchPoint[] touchPointArray) {
        return (int)InvokeDynamicSupport.bootstrap("getPointsForTime", $$robo$$android_accessibilityservice_GestureDescription$getPointsForTime(long android.accessibilityservice.GestureDescription$TouchPoint[] ), 0, this, l, touchPointArray);
    }

    private static long getTotalDuration(List<StrokeDescription> list) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getTotalDuration", $$robo$$android_accessibilityservice_GestureDescription$getTotalDuration(java.util.List<android.accessibilityservice.GestureDescription$StrokeDescription> ), 0, list);
    }

    private /* synthetic */ void __constructor__(List list, 1 var2_2) {
        this.$$robo$$android_accessibilityservice_GestureDescription$__constructor__(list, var2_2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GestureDescription)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class MotionEventGenerator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static TouchPoint[] sCurrentTouchPoints;

        private void $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$__constructor__() {
        }

        private static final List<GestureStep> $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$getGestureStepsFromGestureDescription(GestureDescription description, int sampleTimeMs) {
            ArrayList<GestureStep> gestureSteps = new ArrayList<GestureStep>();
            TouchPoint[] currentTouchPoints = MotionEventGenerator.getCurrentTouchPoints(description.getStrokeCount());
            int currentTouchPointSize = 0;
            long timeSinceGestureStart = 0L;
            long nextKeyPointTime = description.getNextKeyPointAtLeast(timeSinceGestureStart);
            while (nextKeyPointTime >= 0L) {
                timeSinceGestureStart = currentTouchPointSize == 0 ? nextKeyPointTime : Math.min(nextKeyPointTime, timeSinceGestureStart + (long)sampleTimeMs);
                currentTouchPointSize = description.getPointsForTime(timeSinceGestureStart, currentTouchPoints);
                gestureSteps.add(new GestureStep(timeSinceGestureStart, currentTouchPointSize, currentTouchPoints));
                nextKeyPointTime = description.getNextKeyPointAtLeast(timeSinceGestureStart + 1L);
            }
            return gestureSteps;
        }

        private static final TouchPoint[] $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$getCurrentTouchPoints(int requiredCapacity) {
            if (sCurrentTouchPoints == null || sCurrentTouchPoints.length < requiredCapacity) {
                sCurrentTouchPoints = new TouchPoint[requiredCapacity];
                for (int i = 0; i < requiredCapacity; ++i) {
                    MotionEventGenerator.sCurrentTouchPoints[i] = new TouchPoint();
                }
            }
            return sCurrentTouchPoints;
        }

        private void __constructor__() {
            this.$$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$__constructor__();
        }

        public MotionEventGenerator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$__constructor__(), 0, this);
        }

        public static List<GestureStep> getGestureStepsFromGestureDescription(GestureDescription gestureDescription, int n) {
            return InvokeDynamicSupport.bootstrapStatic("getGestureStepsFromGestureDescription", $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$getGestureStepsFromGestureDescription(android.accessibilityservice.GestureDescription int ), 0, (GestureDescription)gestureDescription, (int)n);
        }

        private static TouchPoint[] getCurrentTouchPoints(int n) {
            return InvokeDynamicSupport.bootstrapStatic("getCurrentTouchPoints", $$robo$$android_accessibilityservice_GestureDescription_MotionEventGenerator$getCurrentTouchPoints(int ), 0, (int)n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MotionEventGenerator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class GestureStep
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public long timeSinceGestureStart;
        public int numTouchPoints;
        public TouchPoint[] touchPoints;
        public static Parcelable.Creator<GestureStep> CREATOR;

        private void $$robo$$android_accessibilityservice_GestureDescription_GestureStep$__constructor__(long timeSinceGestureStart, int numTouchPoints, TouchPoint[] touchPointsToCopy) {
            this.timeSinceGestureStart = timeSinceGestureStart;
            this.numTouchPoints = numTouchPoints;
            this.touchPoints = new TouchPoint[numTouchPoints];
            for (int i = 0; i < numTouchPoints; ++i) {
                this.touchPoints[i] = new TouchPoint(touchPointsToCopy[i]);
            }
        }

        private void $$robo$$android_accessibilityservice_GestureDescription_GestureStep$__constructor__(Parcel parcel) {
            this.timeSinceGestureStart = parcel.readLong();
            Parcelable[] parcelables = parcel.readParcelableArray(TouchPoint.class.getClassLoader());
            this.numTouchPoints = parcelables == null ? 0 : parcelables.length;
            this.touchPoints = new TouchPoint[this.numTouchPoints];
            for (int i = 0; i < this.numTouchPoints; ++i) {
                this.touchPoints[i] = (TouchPoint)parcelables[i];
            }
        }

        private final int $$robo$$android_accessibilityservice_GestureDescription_GestureStep$describeContents() {
            return 0;
        }

        private final void $$robo$$android_accessibilityservice_GestureDescription_GestureStep$writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.timeSinceGestureStart);
            dest.writeParcelableArray(this.touchPoints, flags);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<GestureStep>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_accessibilityservice_GestureDescription_GestureStep_1$__constructor__() {
                }

                private final GestureStep $$robo$$android_accessibilityservice_GestureDescription_GestureStep_1$createFromParcel(Parcel in) {
                    return new GestureStep(in);
                }

                private final GestureStep[] $$robo$$android_accessibilityservice_GestureDescription_GestureStep_1$newArray(int size) {
                    return new GestureStep[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_accessibilityservice_GestureDescription_GestureStep_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_GestureStep_1$__constructor__(), 0, this);
                }

                @Override
                public GestureStep createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_accessibilityservice_GestureDescription_GestureStep_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public GestureStep[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_accessibilityservice_GestureDescription_GestureStep_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(long l, int n, TouchPoint[] touchPointArray) {
            this.$$robo$$android_accessibilityservice_GestureDescription_GestureStep$__constructor__(l, n, touchPointArray);
        }

        public GestureStep(long l, int n, TouchPoint[] touchPointArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_GestureStep$__constructor__(long int android.accessibilityservice.GestureDescription$TouchPoint[] ), 0, this, l, n, touchPointArray);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_accessibilityservice_GestureDescription_GestureStep$__constructor__(parcel);
        }

        public GestureStep(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_GestureStep$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_accessibilityservice_GestureDescription_GestureStep$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_accessibilityservice_GestureDescription_GestureStep$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(GestureStep.class);
        }

        public /* synthetic */ GestureStep() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GestureStep)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class TouchPoint
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int FLAG_IS_START_OF_PATH = 1;
        private static int FLAG_IS_END_OF_PATH = 2;
        public int mStrokeId;
        public int mContinuedStrokeId;
        public boolean mIsStartOfPath;
        public boolean mIsEndOfPath;
        public float mX;
        public float mY;
        public static Parcelable.Creator<TouchPoint> CREATOR;

        private void $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$__constructor__() {
        }

        private void $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$__constructor__(TouchPoint pointToCopy) {
            this.copyFrom(pointToCopy);
        }

        private void $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$__constructor__(Parcel parcel) {
            this.mStrokeId = parcel.readInt();
            this.mContinuedStrokeId = parcel.readInt();
            int startEnd = parcel.readInt();
            this.mIsStartOfPath = (startEnd & 1) != 0;
            this.mIsEndOfPath = (startEnd & 2) != 0;
            this.mX = parcel.readFloat();
            this.mY = parcel.readFloat();
        }

        private final void $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$copyFrom(TouchPoint other) {
            this.mStrokeId = other.mStrokeId;
            this.mContinuedStrokeId = other.mContinuedStrokeId;
            this.mIsStartOfPath = other.mIsStartOfPath;
            this.mIsEndOfPath = other.mIsEndOfPath;
            this.mX = other.mX;
            this.mY = other.mY;
        }

        private final String $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$toString() {
            return "TouchPoint{mStrokeId=" + this.mStrokeId + ", mContinuedStrokeId=" + this.mContinuedStrokeId + ", mIsStartOfPath=" + this.mIsStartOfPath + ", mIsEndOfPath=" + this.mIsEndOfPath + ", mX=" + this.mX + ", mY=" + this.mY + '}';
        }

        private final int $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$describeContents() {
            return 0;
        }

        private final void $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mStrokeId);
            dest.writeInt(this.mContinuedStrokeId);
            int startEnd = this.mIsStartOfPath ? 1 : 0;
            dest.writeInt(startEnd |= this.mIsEndOfPath ? 2 : 0);
            dest.writeFloat(this.mX);
            dest.writeFloat(this.mY);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<TouchPoint>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_accessibilityservice_GestureDescription_TouchPoint_1$__constructor__() {
                }

                private final TouchPoint $$robo$$android_accessibilityservice_GestureDescription_TouchPoint_1$createFromParcel(Parcel in) {
                    return new TouchPoint(in);
                }

                private final TouchPoint[] $$robo$$android_accessibilityservice_GestureDescription_TouchPoint_1$newArray(int size) {
                    return new TouchPoint[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_accessibilityservice_GestureDescription_TouchPoint_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_TouchPoint_1$__constructor__(), 0, this);
                }

                @Override
                public TouchPoint createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_accessibilityservice_GestureDescription_TouchPoint_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public TouchPoint[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_accessibilityservice_GestureDescription_TouchPoint_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_accessibilityservice_GestureDescription_TouchPoint$__constructor__();
        }

        public TouchPoint() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$__constructor__(), 0, this);
        }

        private void __constructor__(TouchPoint touchPoint) {
            this.$$robo$$android_accessibilityservice_GestureDescription_TouchPoint$__constructor__(touchPoint);
        }

        public TouchPoint(TouchPoint touchPoint) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$__constructor__(android.accessibilityservice.GestureDescription$TouchPoint ), 0, this, touchPoint);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_accessibilityservice_GestureDescription_TouchPoint$__constructor__(parcel);
        }

        public TouchPoint(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public void copyFrom(TouchPoint touchPoint) {
            InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$copyFrom(android.accessibilityservice.GestureDescription$TouchPoint ), 0, this, touchPoint);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$toString(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_accessibilityservice_GestureDescription_TouchPoint$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(TouchPoint.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TouchPoint)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class StrokeDescription
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int INVALID_STROKE_ID = -1;
        static int sIdCounter;
        Path mPath;
        long mStartTime;
        long mEndTime;
        private float mTimeToLengthConversion;
        private PathMeasure mPathMeasure;
        float[] mTapLocation;
        int mId;
        boolean mContinued;
        int mContinuedStrokeId;

        private void $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$__constructor__(Path path, long startTime, long duration) {
        }

        private void $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$__constructor__(Path path, long startTime, long duration, boolean willContinue) {
            this.mContinuedStrokeId = -1;
            this.mContinued = willContinue;
            Preconditions.checkArgument(duration > 0L, "Duration must be positive");
            Preconditions.checkArgument(startTime >= 0L, "Start time must not be negative");
            Preconditions.checkArgument(!path.isEmpty(), "Path is empty");
            RectF bounds = new RectF();
            path.computeBounds(bounds, false);
            Preconditions.checkArgument(bounds.bottom >= 0.0f && bounds.top >= 0.0f && bounds.right >= 0.0f && bounds.left >= 0.0f, "Path bounds must not be negative");
            this.mPath = new Path(path);
            this.mPathMeasure = new PathMeasure(path, false);
            if (this.mPathMeasure.getLength() == 0.0f) {
                Path tempPath = new Path(path);
                tempPath.lineTo(-1.0f, -1.0f);
                this.mTapLocation = new float[2];
                PathMeasure pathMeasure = new PathMeasure(tempPath, false);
                pathMeasure.getPosTan(0.0f, this.mTapLocation, null);
            }
            if (this.mPathMeasure.nextContour()) {
                throw new IllegalArgumentException("Path has more than one contour");
            }
            this.mPathMeasure.setPath(this.mPath, false);
            this.mStartTime = startTime;
            this.mEndTime = startTime + duration;
            this.mTimeToLengthConversion = this.getLength() / (float)duration;
            this.mId = sIdCounter++;
        }

        private final Path $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getPath() {
            return new Path(this.mPath);
        }

        private final long $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getStartTime() {
            return this.mStartTime;
        }

        private final long $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getDuration() {
            return this.mEndTime - this.mStartTime;
        }

        private final int $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getId() {
            return this.mId;
        }

        private final StrokeDescription $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$continueStroke(Path path, long startTime, long duration, boolean willContinue) {
            if (!this.mContinued) {
                throw new IllegalStateException("Only strokes marked willContinue can be continued");
            }
            StrokeDescription strokeDescription = new StrokeDescription(path, startTime, duration, willContinue);
            strokeDescription.mContinuedStrokeId = this.mId;
            return strokeDescription;
        }

        private final boolean $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$willContinue() {
            return this.mContinued;
        }

        private final int $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getContinuedStrokeId() {
            return this.mContinuedStrokeId;
        }

        private final float $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getLength() {
            return this.mPathMeasure.getLength();
        }

        private final boolean $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getPosForTime(long time, float[] pos) {
            if (this.mTapLocation != null) {
                pos[0] = this.mTapLocation[0];
                pos[1] = this.mTapLocation[1];
                return true;
            }
            if (time == this.mEndTime) {
                return this.mPathMeasure.getPosTan(this.getLength(), pos, null);
            }
            float length = this.mTimeToLengthConversion * (float)(time - this.mStartTime);
            return this.mPathMeasure.getPosTan(length, pos, null);
        }

        private final boolean $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$hasPointForTime(long time) {
            return time >= this.mStartTime && time <= this.mEndTime;
        }

        private void __constructor__(Path path, long l, long l2) {
            this.$$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$__constructor__(path, l, l2);
        }

        public StrokeDescription(Path path, long l, long l2) {
            this(path, l, l2, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$__constructor__(android.graphics.Path long long ), 0, this, path, l, l2);
        }

        private void __constructor__(Path path, long l, long l2, boolean bl) {
            this.$$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$__constructor__(path, l, l2, bl);
        }

        public StrokeDescription(Path path, long l, long l2, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$__constructor__(android.graphics.Path long long boolean ), 0, this, path, l, l2, bl);
        }

        public Path getPath() {
            return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getPath(), 0, this);
        }

        public long getStartTime() {
            return (long)InvokeDynamicSupport.bootstrap("getStartTime", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getStartTime(), 0, this);
        }

        public long getDuration() {
            return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getDuration(), 0, this);
        }

        public int getId() {
            return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getId(), 0, this);
        }

        public StrokeDescription continueStroke(Path path, long l, long l2, boolean bl) {
            return InvokeDynamicSupport.bootstrap("continueStroke", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$continueStroke(android.graphics.Path long long boolean ), 0, this, path, l, l2, bl);
        }

        public boolean willContinue() {
            return (boolean)InvokeDynamicSupport.bootstrap("willContinue", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$willContinue(), 0, this);
        }

        public int getContinuedStrokeId() {
            return (int)InvokeDynamicSupport.bootstrap("getContinuedStrokeId", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getContinuedStrokeId(), 0, this);
        }

        float getLength() {
            return (float)InvokeDynamicSupport.bootstrap("getLength", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getLength(), 0, this);
        }

        boolean getPosForTime(long l, float[] fArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("getPosForTime", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$getPosForTime(long float[] ), 0, this, l, fArray);
        }

        boolean hasPointForTime(long l) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasPointForTime", $$robo$$android_accessibilityservice_GestureDescription_StrokeDescription$hasPointForTime(long ), 0, this, l);
        }

        public /* synthetic */ StrokeDescription() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrokeDescription)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private List<StrokeDescription> mStrokes;

        private void $$robo$$android_accessibilityservice_GestureDescription_Builder$__constructor__() {
            this.mStrokes = new ArrayList<StrokeDescription>();
        }

        private final Builder $$robo$$android_accessibilityservice_GestureDescription_Builder$addStroke(StrokeDescription strokeDescription) {
            if (this.mStrokes.size() >= 10) {
                throw new IllegalStateException("Attempting to add too many strokes to a gesture");
            }
            this.mStrokes.add(strokeDescription);
            if (GestureDescription.getTotalDuration(this.mStrokes) > 60000L) {
                this.mStrokes.remove(strokeDescription);
                throw new IllegalStateException("Gesture would exceed maximum duration with new stroke");
            }
            return this;
        }

        private final GestureDescription $$robo$$android_accessibilityservice_GestureDescription_Builder$build() {
            if (this.mStrokes.size() == 0) {
                throw new IllegalStateException("Gestures must have at least one stroke");
            }
            return new GestureDescription(this.mStrokes);
        }

        private void __constructor__() {
            this.$$robo$$android_accessibilityservice_GestureDescription_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_GestureDescription_Builder$__constructor__(), 0, this);
        }

        public Builder addStroke(StrokeDescription strokeDescription) {
            return InvokeDynamicSupport.bootstrap("addStroke", $$robo$$android_accessibilityservice_GestureDescription_Builder$addStroke(android.accessibilityservice.GestureDescription$StrokeDescription ), 0, this, strokeDescription);
        }

        public GestureDescription build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_accessibilityservice_GestureDescription_Builder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

