/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.os.FileUtils;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DexLoadReporter
implements BaseDexClassLoader.Reporter,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DexLoadReporter";
    private static DexLoadReporter INSTANCE;
    private static boolean DEBUG = false;
    @GuardedBy(value="mDataDirs")
    private Set<String> mDataDirs;

    private void $$robo$$android_app_DexLoadReporter$__constructor__() {
        this.mDataDirs = new HashSet<String>();
    }

    private static final DexLoadReporter $$robo$$android_app_DexLoadReporter$getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_DexLoadReporter$registerAppDataDir(String packageName, String dataDir) {
        if (dataDir != null) {
            Set<String> set = this.mDataDirs;
            synchronized (set) {
                this.mDataDirs.add(dataDir);
            }
        }
    }

    private final void $$robo$$android_app_DexLoadReporter$report(List<BaseDexClassLoader> classLoadersChain, List<String> classPaths) {
        if (classLoadersChain.size() != classPaths.size()) {
            Slog.wtf("DexLoadReporter", "Bad call to DexLoadReporter: argument size mismatch");
            return;
        }
        if (classPaths.isEmpty()) {
            Slog.wtf("DexLoadReporter", "Bad call to DexLoadReporter: empty dex paths");
            return;
        }
        String[] dexPathsForRegistration = classPaths.get(0).split(File.pathSeparator);
        if (dexPathsForRegistration.length == 0) {
            return;
        }
        this.notifyPackageManager(classLoadersChain, classPaths);
        this.registerSecondaryDexForProfiling(dexPathsForRegistration);
    }

    private final void $$robo$$android_app_DexLoadReporter$notifyPackageManager(List<BaseDexClassLoader> classLoadersChain, List<String> classPaths) {
        ArrayList<String> classLoadersNames = new ArrayList<String>(classPaths.size());
        for (BaseDexClassLoader bdc : classLoadersChain) {
            classLoadersNames.add(bdc.getClass().getName());
        }
        String packageName = ActivityThread.currentPackageName();
        try {
            ActivityThread.getPackageManager().notifyDexLoad(packageName, classLoadersNames, classPaths, VMRuntime.getRuntime().vmInstructionSet());
        }
        catch (RemoteException re) {
            Slog.e("DexLoadReporter", "Failed to notify PM about dex load for package " + packageName, re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_DexLoadReporter$registerSecondaryDexForProfiling(String[] dexPaths) {
        if (!SystemProperties.getBoolean("dalvik.vm.dexopt.secondary", false)) {
            return;
        }
        String[] stringArray = this.mDataDirs;
        synchronized (this.mDataDirs) {
            String[] dataDirs = this.mDataDirs.toArray(new String[0]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (String dexPath : dexPaths) {
                this.registerSecondaryDexForProfiling(dexPath, dataDirs);
            }
            return;
        }
    }

    private final void $$robo$$android_app_DexLoadReporter$registerSecondaryDexForProfiling(String dexPath, String[] dataDirs) {
        if (!this.isSecondaryDexFile(dexPath, dataDirs)) {
            return;
        }
        File dexPathFile = new File(dexPath);
        File secondaryProfileDir = new File(dexPathFile.getParent(), "oat");
        File secondaryProfile = new File(secondaryProfileDir, dexPathFile.getName() + ".cur.prof");
        if (!secondaryProfileDir.exists() && !secondaryProfileDir.mkdir()) {
            Slog.e("DexLoadReporter", "Could not create the profile directory: " + secondaryProfile);
            return;
        }
        try {
            boolean bl = secondaryProfile.createNewFile();
        }
        catch (IOException ex) {
            Slog.e("DexLoadReporter", "Failed to create profile for secondary dex " + dexPath + ":" + ex.getMessage());
            return;
        }
        VMRuntime.registerAppInfo(secondaryProfile.getPath(), new String[]{dexPath});
    }

    private final boolean $$robo$$android_app_DexLoadReporter$isSecondaryDexFile(String dexPath, String[] dataDirs) {
        for (String dataDir : dataDirs) {
            if (!FileUtils.contains(dataDir, dexPath)) continue;
            return true;
        }
        return false;
    }

    static void __staticInitializer__() {
        INSTANCE = new DexLoadReporter();
    }

    private void __constructor__() {
        this.$$robo$$android_app_DexLoadReporter$__constructor__();
    }

    private DexLoadReporter() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_DexLoadReporter$__constructor__(), 0, this);
    }

    static DexLoadReporter getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_app_DexLoadReporter$getInstance(), 0);
    }

    void registerAppDataDir(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("registerAppDataDir", $$robo$$android_app_DexLoadReporter$registerAppDataDir(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public void report(List<BaseDexClassLoader> list, List<String> list2) {
        InvokeDynamicSupport.bootstrap("report", $$robo$$android_app_DexLoadReporter$report(java.util.List<dalvik.system.BaseDexClassLoader> java.util.List<java.lang.String> ), 0, this, list, list2);
    }

    private void notifyPackageManager(List<BaseDexClassLoader> list, List<String> list2) {
        InvokeDynamicSupport.bootstrap("notifyPackageManager", $$robo$$android_app_DexLoadReporter$notifyPackageManager(java.util.List<dalvik.system.BaseDexClassLoader> java.util.List<java.lang.String> ), 0, this, list, list2);
    }

    private void registerSecondaryDexForProfiling(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("registerSecondaryDexForProfiling", $$robo$$android_app_DexLoadReporter$registerSecondaryDexForProfiling(java.lang.String[] ), 0, this, stringArray);
    }

    private void registerSecondaryDexForProfiling(String string2, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("registerSecondaryDexForProfiling", $$robo$$android_app_DexLoadReporter$registerSecondaryDexForProfiling(java.lang.String java.lang.String[] ), 0, this, string2, stringArray);
    }

    private boolean isSecondaryDexFile(String string2, String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecondaryDexFile", $$robo$$android_app_DexLoadReporter$isSecondaryDexFile(java.lang.String java.lang.String[] ), 0, this, string2, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(DexLoadReporter.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DexLoadReporter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

