/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.app.Notification;
import android.content.ContentResolver;
import android.content.Context;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.service.notification.NotificationListenerService;
import android.text.TextUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlSerializer;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NotificationChannel
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String DEFAULT_CHANNEL_ID = "miscellaneous";
    private static int MAX_TEXT_LENGTH = 1000;
    private static String TAG_CHANNEL = "channel";
    private static String ATT_NAME = "name";
    private static String ATT_DESC = "desc";
    private static String ATT_ID = "id";
    private static String ATT_DELETED = "deleted";
    private static String ATT_PRIORITY = "priority";
    private static String ATT_VISIBILITY = "visibility";
    private static String ATT_IMPORTANCE = "importance";
    private static String ATT_LIGHTS = "lights";
    private static String ATT_LIGHT_COLOR = "light_color";
    private static String ATT_VIBRATION = "vibration";
    private static String ATT_VIBRATION_ENABLED = "vibration_enabled";
    private static String ATT_SOUND = "sound";
    private static String ATT_USAGE = "usage";
    private static String ATT_FLAGS = "flags";
    private static String ATT_CONTENT_TYPE = "content_type";
    private static String ATT_SHOW_BADGE = "show_badge";
    private static String ATT_USER_LOCKED = "locked";
    private static String ATT_FG_SERVICE_SHOWN = "fgservice";
    private static String ATT_GROUP = "group";
    private static String ATT_BLOCKABLE_SYSTEM = "blockable_system";
    private static String DELIMITER = ",";
    public static int USER_LOCKED_PRIORITY = 1;
    public static int USER_LOCKED_VISIBILITY = 2;
    public static int USER_LOCKED_IMPORTANCE = 4;
    public static int USER_LOCKED_LIGHTS = 8;
    public static int USER_LOCKED_VIBRATION = 16;
    public static int USER_LOCKED_SOUND = 32;
    public static int USER_LOCKED_SHOW_BADGE = 128;
    public static int[] LOCKABLE_FIELDS;
    private static int DEFAULT_LIGHT_COLOR = 0;
    private static int DEFAULT_VISIBILITY = -1000;
    private static int DEFAULT_IMPORTANCE = -1000;
    private static boolean DEFAULT_DELETED = false;
    private static boolean DEFAULT_SHOW_BADGE = true;
    private String mId;
    private String mName;
    private String mDesc;
    private int mImportance;
    private boolean mBypassDnd;
    private int mLockscreenVisibility;
    private Uri mSound;
    private boolean mLights;
    private int mLightColor;
    private long[] mVibration;
    private int mUserLockedFields;
    private boolean mFgServiceShown;
    private boolean mVibrationEnabled;
    private boolean mShowBadge;
    private boolean mDeleted;
    private String mGroup;
    private AudioAttributes mAudioAttributes;
    private boolean mBlockableSystem;
    public static Parcelable.Creator<NotificationChannel> CREATOR;

    private void $$robo$$android_app_NotificationChannel$__constructor__(String id2, CharSequence name, int importance) {
        this.mImportance = -1000;
        this.mLockscreenVisibility = -1000;
        this.mSound = Settings.System.DEFAULT_NOTIFICATION_URI;
        this.mLightColor = 0;
        this.mShowBadge = true;
        this.mDeleted = false;
        this.mAudioAttributes = Notification.AUDIO_ATTRIBUTES_DEFAULT;
        this.mBlockableSystem = false;
        this.mId = this.getTrimmedString(id2);
        this.mName = name != null ? this.getTrimmedString(name.toString()) : null;
        this.mImportance = importance;
    }

    private void $$robo$$android_app_NotificationChannel$__constructor__(Parcel in) {
        this.mImportance = -1000;
        this.mLockscreenVisibility = -1000;
        this.mSound = Settings.System.DEFAULT_NOTIFICATION_URI;
        this.mLightColor = 0;
        this.mShowBadge = true;
        this.mDeleted = false;
        this.mAudioAttributes = Notification.AUDIO_ATTRIBUTES_DEFAULT;
        this.mBlockableSystem = false;
        this.mId = in.readByte() != 0 ? in.readString() : null;
        this.mName = in.readByte() != 0 ? in.readString() : null;
        this.mDesc = in.readByte() != 0 ? in.readString() : null;
        this.mImportance = in.readInt();
        this.mBypassDnd = in.readByte() != 0;
        this.mLockscreenVisibility = in.readInt();
        this.mSound = in.readByte() != 0 ? Uri.CREATOR.createFromParcel(in) : null;
        this.mLights = in.readByte() != 0;
        this.mVibration = in.createLongArray();
        this.mUserLockedFields = in.readInt();
        this.mFgServiceShown = in.readByte() != 0;
        this.mVibrationEnabled = in.readByte() != 0;
        this.mShowBadge = in.readByte() != 0;
        this.mDeleted = in.readByte() != 0;
        this.mGroup = in.readByte() != 0 ? in.readString() : null;
        this.mAudioAttributes = in.readInt() > 0 ? AudioAttributes.CREATOR.createFromParcel(in) : null;
        this.mLightColor = in.readInt();
        this.mBlockableSystem = in.readBoolean();
    }

    private final void $$robo$$android_app_NotificationChannel$writeToParcel(Parcel dest, int flags) {
        if (this.mId != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mId);
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mName != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mName);
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mDesc != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mDesc);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeInt(this.mImportance);
        dest.writeByte(this.mBypassDnd ? (byte)1 : 0);
        dest.writeInt(this.mLockscreenVisibility);
        if (this.mSound != null) {
            dest.writeByte((byte)1);
            this.mSound.writeToParcel(dest, 0);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeByte(this.mLights ? (byte)1 : 0);
        dest.writeLongArray(this.mVibration);
        dest.writeInt(this.mUserLockedFields);
        dest.writeByte(this.mFgServiceShown ? (byte)1 : 0);
        dest.writeByte(this.mVibrationEnabled ? (byte)1 : 0);
        dest.writeByte(this.mShowBadge ? (byte)1 : 0);
        dest.writeByte(this.mDeleted ? (byte)1 : 0);
        if (this.mGroup != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mGroup);
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mAudioAttributes != null) {
            dest.writeInt(1);
            this.mAudioAttributes.writeToParcel(dest, 0);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mLightColor);
        dest.writeBoolean(this.mBlockableSystem);
    }

    private final void $$robo$$android_app_NotificationChannel$lockFields(int field) {
        this.mUserLockedFields |= field;
    }

    private final void $$robo$$android_app_NotificationChannel$unlockFields(int field) {
        this.mUserLockedFields &= ~field;
    }

    private final void $$robo$$android_app_NotificationChannel$setFgServiceShown(boolean shown) {
        this.mFgServiceShown = shown;
    }

    private final void $$robo$$android_app_NotificationChannel$setDeleted(boolean deleted) {
        this.mDeleted = deleted;
    }

    private final void $$robo$$android_app_NotificationChannel$setBlockableSystem(boolean blockableSystem) {
        this.mBlockableSystem = blockableSystem;
    }

    private final void $$robo$$android_app_NotificationChannel$setName(CharSequence name) {
        this.mName = name != null ? this.getTrimmedString(name.toString()) : null;
    }

    private final void $$robo$$android_app_NotificationChannel$setDescription(String description) {
        this.mDesc = this.getTrimmedString(description);
    }

    private final String $$robo$$android_app_NotificationChannel$getTrimmedString(String input) {
        if (input != null && input.length() > 1000) {
            return input.substring(0, 1000);
        }
        return input;
    }

    private final void $$robo$$android_app_NotificationChannel$setGroup(String groupId) {
        this.mGroup = groupId;
    }

    private final void $$robo$$android_app_NotificationChannel$setShowBadge(boolean showBadge) {
        this.mShowBadge = showBadge;
    }

    private final void $$robo$$android_app_NotificationChannel$setSound(Uri sound, AudioAttributes audioAttributes) {
        this.mSound = sound;
        this.mAudioAttributes = audioAttributes;
    }

    private final void $$robo$$android_app_NotificationChannel$enableLights(boolean lights) {
        this.mLights = lights;
    }

    private final void $$robo$$android_app_NotificationChannel$setLightColor(int argb) {
        this.mLightColor = argb;
    }

    private final void $$robo$$android_app_NotificationChannel$enableVibration(boolean vibration) {
        this.mVibrationEnabled = vibration;
    }

    private final void $$robo$$android_app_NotificationChannel$setVibrationPattern(long[] vibrationPattern) {
        this.mVibrationEnabled = vibrationPattern != null && vibrationPattern.length > 0;
        this.mVibration = vibrationPattern;
    }

    private final void $$robo$$android_app_NotificationChannel$setImportance(int importance) {
        this.mImportance = importance;
    }

    private final void $$robo$$android_app_NotificationChannel$setBypassDnd(boolean bypassDnd) {
        this.mBypassDnd = bypassDnd;
    }

    private final void $$robo$$android_app_NotificationChannel$setLockscreenVisibility(int lockscreenVisibility) {
        this.mLockscreenVisibility = lockscreenVisibility;
    }

    private final String $$robo$$android_app_NotificationChannel$getId() {
        return this.mId;
    }

    private final CharSequence $$robo$$android_app_NotificationChannel$getName() {
        return this.mName;
    }

    private final String $$robo$$android_app_NotificationChannel$getDescription() {
        return this.mDesc;
    }

    private final int $$robo$$android_app_NotificationChannel$getImportance() {
        return this.mImportance;
    }

    private final boolean $$robo$$android_app_NotificationChannel$canBypassDnd() {
        return this.mBypassDnd;
    }

    private final Uri $$robo$$android_app_NotificationChannel$getSound() {
        return this.mSound;
    }

    private final AudioAttributes $$robo$$android_app_NotificationChannel$getAudioAttributes() {
        return this.mAudioAttributes;
    }

    private final boolean $$robo$$android_app_NotificationChannel$shouldShowLights() {
        return this.mLights;
    }

    private final int $$robo$$android_app_NotificationChannel$getLightColor() {
        return this.mLightColor;
    }

    private final boolean $$robo$$android_app_NotificationChannel$shouldVibrate() {
        return this.mVibrationEnabled;
    }

    private final long[] $$robo$$android_app_NotificationChannel$getVibrationPattern() {
        return this.mVibration;
    }

    private final int $$robo$$android_app_NotificationChannel$getLockscreenVisibility() {
        return this.mLockscreenVisibility;
    }

    private final boolean $$robo$$android_app_NotificationChannel$canShowBadge() {
        return this.mShowBadge;
    }

    private final String $$robo$$android_app_NotificationChannel$getGroup() {
        return this.mGroup;
    }

    @SystemApi
    private final boolean $$robo$$android_app_NotificationChannel$isDeleted() {
        return this.mDeleted;
    }

    @SystemApi
    private final int $$robo$$android_app_NotificationChannel$getUserLockedFields() {
        return this.mUserLockedFields;
    }

    private final boolean $$robo$$android_app_NotificationChannel$isFgServiceShown() {
        return this.mFgServiceShown;
    }

    private final boolean $$robo$$android_app_NotificationChannel$isBlockableSystem() {
        return this.mBlockableSystem;
    }

    private final void $$robo$$android_app_NotificationChannel$populateFromXmlForRestore(XmlPullParser parser, Context context) {
        this.populateFromXml(parser, true, context);
    }

    @SystemApi
    private final void $$robo$$android_app_NotificationChannel$populateFromXml(XmlPullParser parser) {
        this.populateFromXml(parser, false, null);
    }

    private final void $$robo$$android_app_NotificationChannel$populateFromXml(XmlPullParser parser, boolean forRestore, Context context) {
        Preconditions.checkArgument(!forRestore || context != null, "forRestore is true but got null context");
        this.setDescription(parser.getAttributeValue(null, "desc"));
        this.setBypassDnd(0 != NotificationChannel.safeInt(parser, "priority", 0));
        this.setLockscreenVisibility(NotificationChannel.safeInt(parser, "visibility", -1000));
        Uri sound = NotificationChannel.safeUri(parser, "sound");
        this.setSound(forRestore ? this.restoreSoundUri(context, sound) : sound, NotificationChannel.safeAudioAttributes(parser));
        this.enableLights(NotificationChannel.safeBool(parser, "lights", false));
        this.setLightColor(NotificationChannel.safeInt(parser, "light_color", 0));
        this.setVibrationPattern(NotificationChannel.safeLongArray(parser, "vibration", null));
        this.enableVibration(NotificationChannel.safeBool(parser, "vibration_enabled", false));
        this.setShowBadge(NotificationChannel.safeBool(parser, "show_badge", false));
        this.setDeleted(NotificationChannel.safeBool(parser, "deleted", false));
        this.setGroup(parser.getAttributeValue(null, "group"));
        this.lockFields(NotificationChannel.safeInt(parser, "locked", 0));
        this.setFgServiceShown(NotificationChannel.safeBool(parser, "fgservice", false));
        this.setBlockableSystem(NotificationChannel.safeBool(parser, "blockable_system", false));
    }

    private final Uri $$robo$$android_app_NotificationChannel$restoreSoundUri(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        ContentResolver contentResolver = context.getContentResolver();
        Uri canonicalizedUri = contentResolver.canonicalize(uri);
        if (canonicalizedUri == null) {
            return Settings.System.DEFAULT_NOTIFICATION_URI;
        }
        return contentResolver.uncanonicalize(canonicalizedUri);
    }

    @SystemApi
    private final void $$robo$$android_app_NotificationChannel$writeXml(XmlSerializer out) throws IOException {
        this.writeXml(out, false, null);
    }

    private final void $$robo$$android_app_NotificationChannel$writeXmlForBackup(XmlSerializer out, Context context) throws IOException {
        this.writeXml(out, true, context);
    }

    private final Uri $$robo$$android_app_NotificationChannel$getSoundForBackup(Context context) {
        Uri sound = this.getSound();
        if (sound == null) {
            return null;
        }
        Uri canonicalSound = context.getContentResolver().canonicalize(sound);
        if (canonicalSound == null) {
            return Settings.System.DEFAULT_NOTIFICATION_URI;
        }
        return canonicalSound;
    }

    private final void $$robo$$android_app_NotificationChannel$writeXml(XmlSerializer out, boolean forBackup, Context context) throws IOException {
        Uri sound;
        Preconditions.checkArgument(!forBackup || context != null, "forBackup is true but got null context");
        out.startTag(null, "channel");
        out.attribute(null, "id", this.getId());
        if (this.getName() != null) {
            out.attribute(null, "name", this.getName().toString());
        }
        if (this.getDescription() != null) {
            out.attribute(null, "desc", this.getDescription());
        }
        if (this.getImportance() != -1000) {
            out.attribute(null, "importance", Integer.toString(this.getImportance()));
        }
        if (this.canBypassDnd()) {
            out.attribute(null, "priority", Integer.toString(2));
        }
        if (this.getLockscreenVisibility() != -1000) {
            out.attribute(null, "visibility", Integer.toString(this.getLockscreenVisibility()));
        }
        Uri uri = sound = forBackup ? this.getSoundForBackup(context) : this.getSound();
        if (sound != null) {
            out.attribute(null, "sound", sound.toString());
        }
        if (this.getAudioAttributes() != null) {
            out.attribute(null, "usage", Integer.toString(this.getAudioAttributes().getUsage()));
            out.attribute(null, "content_type", Integer.toString(this.getAudioAttributes().getContentType()));
            out.attribute(null, "flags", Integer.toString(this.getAudioAttributes().getFlags()));
        }
        if (this.shouldShowLights()) {
            out.attribute(null, "lights", Boolean.toString(this.shouldShowLights()));
        }
        if (this.getLightColor() != 0) {
            out.attribute(null, "light_color", Integer.toString(this.getLightColor()));
        }
        if (this.shouldVibrate()) {
            out.attribute(null, "vibration_enabled", Boolean.toString(this.shouldVibrate()));
        }
        if (this.getVibrationPattern() != null) {
            out.attribute(null, "vibration", NotificationChannel.longArrayToString(this.getVibrationPattern()));
        }
        if (this.getUserLockedFields() != 0) {
            out.attribute(null, "locked", Integer.toString(this.getUserLockedFields()));
        }
        if (this.isFgServiceShown()) {
            out.attribute(null, "fgservice", Boolean.toString(this.isFgServiceShown()));
        }
        if (this.canShowBadge()) {
            out.attribute(null, "show_badge", Boolean.toString(this.canShowBadge()));
        }
        if (this.isDeleted()) {
            out.attribute(null, "deleted", Boolean.toString(this.isDeleted()));
        }
        if (this.getGroup() != null) {
            out.attribute(null, "group", this.getGroup());
        }
        if (this.isBlockableSystem()) {
            out.attribute(null, "blockable_system", Boolean.toString(this.isBlockableSystem()));
        }
        out.endTag(null, "channel");
    }

    @SystemApi
    private final JSONObject $$robo$$android_app_NotificationChannel$toJson() throws JSONException {
        JSONObject record = new JSONObject();
        record.put("id", this.getId());
        record.put("name", this.getName());
        record.put("desc", this.getDescription());
        if (this.getImportance() != -1000) {
            record.put("importance", NotificationListenerService.Ranking.importanceToString(this.getImportance()));
        }
        if (this.canBypassDnd()) {
            record.put("priority", 2);
        }
        if (this.getLockscreenVisibility() != -1000) {
            record.put("visibility", Notification.visibilityToString(this.getLockscreenVisibility()));
        }
        if (this.getSound() != null) {
            record.put("sound", this.getSound().toString());
        }
        if (this.getAudioAttributes() != null) {
            record.put("usage", Integer.toString(this.getAudioAttributes().getUsage()));
            record.put("content_type", Integer.toString(this.getAudioAttributes().getContentType()));
            record.put("flags", Integer.toString(this.getAudioAttributes().getFlags()));
        }
        record.put("lights", Boolean.toString(this.shouldShowLights()));
        record.put("light_color", Integer.toString(this.getLightColor()));
        record.put("vibration_enabled", Boolean.toString(this.shouldVibrate()));
        record.put("locked", Integer.toString(this.getUserLockedFields()));
        record.put("fgservice", Boolean.toString(this.isFgServiceShown()));
        record.put("vibration", NotificationChannel.longArrayToString(this.getVibrationPattern()));
        record.put("show_badge", Boolean.toString(this.canShowBadge()));
        record.put("deleted", Boolean.toString(this.isDeleted()));
        record.put("group", this.getGroup());
        record.put("blockable_system", this.isBlockableSystem());
        return record;
    }

    private static final AudioAttributes $$robo$$android_app_NotificationChannel$safeAudioAttributes(XmlPullParser parser) {
        int usage = NotificationChannel.safeInt(parser, "usage", 5);
        int contentType = NotificationChannel.safeInt(parser, "content_type", 4);
        int flags = NotificationChannel.safeInt(parser, "flags", 0);
        return new AudioAttributes.Builder().setUsage(usage).setContentType(contentType).setFlags(flags).build();
    }

    private static final Uri $$robo$$android_app_NotificationChannel$safeUri(XmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        return val == null ? null : Uri.parse(val);
    }

    private static final int $$robo$$android_app_NotificationChannel$safeInt(XmlPullParser parser, String att, int defValue) {
        String val = parser.getAttributeValue(null, att);
        return NotificationChannel.tryParseInt(val, defValue);
    }

    private static final int $$robo$$android_app_NotificationChannel$tryParseInt(String value, int defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private static final boolean $$robo$$android_app_NotificationChannel$safeBool(XmlPullParser parser, String att, boolean defValue) {
        String value = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        return Boolean.parseBoolean(value);
    }

    private static final long[] $$robo$$android_app_NotificationChannel$safeLongArray(XmlPullParser parser, String att, long[] defValue) {
        String attributeValue = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(attributeValue)) {
            return defValue;
        }
        String[] values = attributeValue.split(",");
        long[] longValues = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                longValues[i] = Long.parseLong(values[i]);
                continue;
            }
            catch (NumberFormatException e) {
                longValues[i] = 0L;
            }
        }
        return longValues;
    }

    private static final String $$robo$$android_app_NotificationChannel$longArrayToString(long[] values) {
        StringBuffer sb = new StringBuffer();
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length - 1; ++i) {
                sb.append(values[i]).append(",");
            }
            sb.append(values[values.length - 1]);
        }
        return sb.toString();
    }

    private final int $$robo$$android_app_NotificationChannel$describeContents() {
        return 0;
    }

    private final boolean $$robo$$android_app_NotificationChannel$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationChannel that = (NotificationChannel)o;
        if (this.getImportance() != that.getImportance()) {
            return false;
        }
        if (this.mBypassDnd != that.mBypassDnd) {
            return false;
        }
        if (this.getLockscreenVisibility() != that.getLockscreenVisibility()) {
            return false;
        }
        if (this.mLights != that.mLights) {
            return false;
        }
        if (this.getLightColor() != that.getLightColor()) {
            return false;
        }
        if (this.getUserLockedFields() != that.getUserLockedFields()) {
            return false;
        }
        if (this.mVibrationEnabled != that.mVibrationEnabled) {
            return false;
        }
        if (this.mShowBadge != that.mShowBadge) {
            return false;
        }
        if (this.isDeleted() != that.isDeleted()) {
            return false;
        }
        if (this.isBlockableSystem() != that.isBlockableSystem()) {
            return false;
        }
        if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getDescription() != null ? !this.getDescription().equals(that.getDescription()) : that.getDescription() != null) {
            return false;
        }
        if (this.getSound() != null ? !this.getSound().equals(that.getSound()) : that.getSound() != null) {
            return false;
        }
        if (!Arrays.equals(this.mVibration, that.mVibration)) {
            return false;
        }
        if (this.getGroup() != null ? !this.getGroup().equals(that.getGroup()) : that.getGroup() != null) {
            return false;
        }
        return this.getAudioAttributes() != null ? this.getAudioAttributes().equals(that.getAudioAttributes()) : that.getAudioAttributes() == null;
    }

    private final int $$robo$$android_app_NotificationChannel$hashCode() {
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getDescription() != null ? this.getDescription().hashCode() : 0);
        result = 31 * result + this.getImportance();
        result = 31 * result + (this.mBypassDnd ? 1 : 0);
        result = 31 * result + this.getLockscreenVisibility();
        result = 31 * result + (this.getSound() != null ? this.getSound().hashCode() : 0);
        result = 31 * result + (this.mLights ? 1 : 0);
        result = 31 * result + this.getLightColor();
        result = 31 * result + Arrays.hashCode(this.mVibration);
        result = 31 * result + this.getUserLockedFields();
        result = 31 * result + (this.mVibrationEnabled ? 1 : 0);
        result = 31 * result + (this.mShowBadge ? 1 : 0);
        result = 31 * result + (this.isDeleted() ? 1 : 0);
        result = 31 * result + (this.getGroup() != null ? this.getGroup().hashCode() : 0);
        result = 31 * result + (this.getAudioAttributes() != null ? this.getAudioAttributes().hashCode() : 0);
        result = 31 * result + (this.isBlockableSystem() ? 1 : 0);
        return result;
    }

    private final String $$robo$$android_app_NotificationChannel$toString() {
        return "NotificationChannel{mId='" + this.mId + '\'' + ", mName=" + this.mName + ", mDescription=" + (!TextUtils.isEmpty(this.mDesc) ? "hasDescription " : "") + ", mImportance=" + this.mImportance + ", mBypassDnd=" + this.mBypassDnd + ", mLockscreenVisibility=" + this.mLockscreenVisibility + ", mSound=" + this.mSound + ", mLights=" + this.mLights + ", mLightColor=" + this.mLightColor + ", mVibration=" + Arrays.toString(this.mVibration) + ", mUserLockedFields=" + Integer.toHexString(this.mUserLockedFields) + ", mFgServiceShown=" + this.mFgServiceShown + ", mVibrationEnabled=" + this.mVibrationEnabled + ", mShowBadge=" + this.mShowBadge + ", mDeleted=" + this.mDeleted + ", mGroup='" + this.mGroup + '\'' + ", mAudioAttributes=" + this.mAudioAttributes + ", mBlockableSystem=" + this.mBlockableSystem + '}';
    }

    private final void $$robo$$android_app_NotificationChannel$writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.mId);
        proto.write(1138166333442L, this.mName);
        proto.write(1138166333443L, this.mDesc);
        proto.write(1120986464260L, this.mImportance);
        proto.write(1133871366149L, this.mBypassDnd);
        proto.write(1120986464262L, this.mLockscreenVisibility);
        if (this.mSound != null) {
            proto.write(1138166333447L, this.mSound.toString());
        }
        proto.write(0x10800000008L, this.mLights);
        proto.write(1120986464265L, this.mLightColor);
        if (this.mVibration != null) {
            for (long v : this.mVibration) {
                proto.write(2211908157450L, v);
            }
        }
        proto.write(1120986464267L, this.mUserLockedFields);
        proto.write(1133871366162L, this.mFgServiceShown);
        proto.write(1133871366156L, this.mVibrationEnabled);
        proto.write(1133871366157L, this.mShowBadge);
        proto.write(1133871366158L, this.mDeleted);
        proto.write(1138166333455L, this.mGroup);
        if (this.mAudioAttributes != null) {
            this.mAudioAttributes.writeToProto(proto, 0x10B00000010L);
        }
        proto.write(0x10800000011L, this.mBlockableSystem);
        proto.end(token);
    }

    static void __staticInitializer__() {
        LOCKABLE_FIELDS = new int[]{1, 2, 4, 8, 16, 32, 128};
        CREATOR = new Parcelable.Creator<NotificationChannel>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_NotificationChannel_1$__constructor__() {
            }

            private final NotificationChannel $$robo$$android_app_NotificationChannel_1$createFromParcel(Parcel in) {
                return new NotificationChannel(in);
            }

            private final NotificationChannel[] $$robo$$android_app_NotificationChannel_1$newArray(int size) {
                return new NotificationChannel[size];
            }

            private void __constructor__() {
                this.$$robo$$android_app_NotificationChannel_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_NotificationChannel_1$__constructor__(), 0, this);
            }

            @Override
            public NotificationChannel createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_NotificationChannel_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public NotificationChannel[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_NotificationChannel_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, CharSequence charSequence, int n) {
        this.$$robo$$android_app_NotificationChannel$__constructor__(string2, charSequence, n);
    }

    public NotificationChannel(String string2, CharSequence charSequence, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_NotificationChannel$__constructor__(java.lang.String java.lang.CharSequence int ), 0, this, string2, charSequence, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_app_NotificationChannel$__constructor__(parcel);
    }

    protected NotificationChannel(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_NotificationChannel$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_NotificationChannel$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public void lockFields(int n) {
        InvokeDynamicSupport.bootstrap("lockFields", $$robo$$android_app_NotificationChannel$lockFields(int ), 0, this, n);
    }

    public void unlockFields(int n) {
        InvokeDynamicSupport.bootstrap("unlockFields", $$robo$$android_app_NotificationChannel$unlockFields(int ), 0, this, n);
    }

    public void setFgServiceShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFgServiceShown", $$robo$$android_app_NotificationChannel$setFgServiceShown(boolean ), 0, this, bl);
    }

    public void setDeleted(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDeleted", $$robo$$android_app_NotificationChannel$setDeleted(boolean ), 0, this, bl);
    }

    public void setBlockableSystem(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBlockableSystem", $$robo$$android_app_NotificationChannel$setBlockableSystem(boolean ), 0, this, bl);
    }

    public void setName(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setName", $$robo$$android_app_NotificationChannel$setName(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setDescription(String string2) {
        InvokeDynamicSupport.bootstrap("setDescription", $$robo$$android_app_NotificationChannel$setDescription(java.lang.String ), 0, this, string2);
    }

    private String getTrimmedString(String string2) {
        return InvokeDynamicSupport.bootstrap("getTrimmedString", $$robo$$android_app_NotificationChannel$getTrimmedString(java.lang.String ), 0, this, string2);
    }

    public void setGroup(String string2) {
        InvokeDynamicSupport.bootstrap("setGroup", $$robo$$android_app_NotificationChannel$setGroup(java.lang.String ), 0, this, string2);
    }

    public void setShowBadge(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShowBadge", $$robo$$android_app_NotificationChannel$setShowBadge(boolean ), 0, this, bl);
    }

    public void setSound(Uri uri, AudioAttributes audioAttributes) {
        InvokeDynamicSupport.bootstrap("setSound", $$robo$$android_app_NotificationChannel$setSound(android.net.Uri android.media.AudioAttributes ), 0, this, uri, audioAttributes);
    }

    public void enableLights(boolean bl) {
        InvokeDynamicSupport.bootstrap("enableLights", $$robo$$android_app_NotificationChannel$enableLights(boolean ), 0, this, bl);
    }

    public void setLightColor(int n) {
        InvokeDynamicSupport.bootstrap("setLightColor", $$robo$$android_app_NotificationChannel$setLightColor(int ), 0, this, n);
    }

    public void enableVibration(boolean bl) {
        InvokeDynamicSupport.bootstrap("enableVibration", $$robo$$android_app_NotificationChannel$enableVibration(boolean ), 0, this, bl);
    }

    public void setVibrationPattern(long[] lArray) {
        InvokeDynamicSupport.bootstrap("setVibrationPattern", $$robo$$android_app_NotificationChannel$setVibrationPattern(long[] ), 0, this, lArray);
    }

    public void setImportance(int n) {
        InvokeDynamicSupport.bootstrap("setImportance", $$robo$$android_app_NotificationChannel$setImportance(int ), 0, this, n);
    }

    public void setBypassDnd(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBypassDnd", $$robo$$android_app_NotificationChannel$setBypassDnd(boolean ), 0, this, bl);
    }

    public void setLockscreenVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setLockscreenVisibility", $$robo$$android_app_NotificationChannel$setLockscreenVisibility(int ), 0, this, n);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_app_NotificationChannel$getId(), 0, this);
    }

    public CharSequence getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_app_NotificationChannel$getName(), 0, this);
    }

    public String getDescription() {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_app_NotificationChannel$getDescription(), 0, this);
    }

    public int getImportance() {
        return (int)InvokeDynamicSupport.bootstrap("getImportance", $$robo$$android_app_NotificationChannel$getImportance(), 0, this);
    }

    public boolean canBypassDnd() {
        return (boolean)InvokeDynamicSupport.bootstrap("canBypassDnd", $$robo$$android_app_NotificationChannel$canBypassDnd(), 0, this);
    }

    public Uri getSound() {
        return InvokeDynamicSupport.bootstrap("getSound", $$robo$$android_app_NotificationChannel$getSound(), 0, this);
    }

    public AudioAttributes getAudioAttributes() {
        return InvokeDynamicSupport.bootstrap("getAudioAttributes", $$robo$$android_app_NotificationChannel$getAudioAttributes(), 0, this);
    }

    public boolean shouldShowLights() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldShowLights", $$robo$$android_app_NotificationChannel$shouldShowLights(), 0, this);
    }

    public int getLightColor() {
        return (int)InvokeDynamicSupport.bootstrap("getLightColor", $$robo$$android_app_NotificationChannel$getLightColor(), 0, this);
    }

    public boolean shouldVibrate() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldVibrate", $$robo$$android_app_NotificationChannel$shouldVibrate(), 0, this);
    }

    public long[] getVibrationPattern() {
        return InvokeDynamicSupport.bootstrap("getVibrationPattern", $$robo$$android_app_NotificationChannel$getVibrationPattern(), 0, this);
    }

    public int getLockscreenVisibility() {
        return (int)InvokeDynamicSupport.bootstrap("getLockscreenVisibility", $$robo$$android_app_NotificationChannel$getLockscreenVisibility(), 0, this);
    }

    public boolean canShowBadge() {
        return (boolean)InvokeDynamicSupport.bootstrap("canShowBadge", $$robo$$android_app_NotificationChannel$canShowBadge(), 0, this);
    }

    public String getGroup() {
        return InvokeDynamicSupport.bootstrap("getGroup", $$robo$$android_app_NotificationChannel$getGroup(), 0, this);
    }

    @SystemApi
    public boolean isDeleted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeleted", $$robo$$android_app_NotificationChannel$isDeleted(), 0, this);
    }

    @SystemApi
    public int getUserLockedFields() {
        return (int)InvokeDynamicSupport.bootstrap("getUserLockedFields", $$robo$$android_app_NotificationChannel$getUserLockedFields(), 0, this);
    }

    public boolean isFgServiceShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFgServiceShown", $$robo$$android_app_NotificationChannel$isFgServiceShown(), 0, this);
    }

    public boolean isBlockableSystem() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBlockableSystem", $$robo$$android_app_NotificationChannel$isBlockableSystem(), 0, this);
    }

    public void populateFromXmlForRestore(XmlPullParser xmlPullParser, Context context) {
        InvokeDynamicSupport.bootstrap("populateFromXmlForRestore", $$robo$$android_app_NotificationChannel$populateFromXmlForRestore(org.xmlpull.v1.XmlPullParser android.content.Context ), 0, this, xmlPullParser, context);
    }

    @SystemApi
    public void populateFromXml(XmlPullParser xmlPullParser) {
        InvokeDynamicSupport.bootstrap("populateFromXml", $$robo$$android_app_NotificationChannel$populateFromXml(org.xmlpull.v1.XmlPullParser ), 0, this, xmlPullParser);
    }

    private void populateFromXml(XmlPullParser xmlPullParser, boolean bl, Context context) {
        InvokeDynamicSupport.bootstrap("populateFromXml", $$robo$$android_app_NotificationChannel$populateFromXml(org.xmlpull.v1.XmlPullParser boolean android.content.Context ), 0, this, xmlPullParser, bl, context);
    }

    private Uri restoreSoundUri(Context context, Uri uri) {
        return InvokeDynamicSupport.bootstrap("restoreSoundUri", $$robo$$android_app_NotificationChannel$restoreSoundUri(android.content.Context android.net.Uri ), 0, this, context, uri);
    }

    @SystemApi
    public void writeXml(XmlSerializer xmlSerializer) throws IOException {
        InvokeDynamicSupport.bootstrap("writeXml", $$robo$$android_app_NotificationChannel$writeXml(org.xmlpull.v1.XmlSerializer ), 0, this, xmlSerializer);
    }

    public void writeXmlForBackup(XmlSerializer xmlSerializer, Context context) throws IOException {
        InvokeDynamicSupport.bootstrap("writeXmlForBackup", $$robo$$android_app_NotificationChannel$writeXmlForBackup(org.xmlpull.v1.XmlSerializer android.content.Context ), 0, this, xmlSerializer, context);
    }

    private Uri getSoundForBackup(Context context) {
        return InvokeDynamicSupport.bootstrap("getSoundForBackup", $$robo$$android_app_NotificationChannel$getSoundForBackup(android.content.Context ), 0, this, context);
    }

    private void writeXml(XmlSerializer xmlSerializer, boolean bl, Context context) throws IOException {
        InvokeDynamicSupport.bootstrap("writeXml", $$robo$$android_app_NotificationChannel$writeXml(org.xmlpull.v1.XmlSerializer boolean android.content.Context ), 0, this, xmlSerializer, bl, context);
    }

    @SystemApi
    public JSONObject toJson() throws JSONException {
        return InvokeDynamicSupport.bootstrap("toJson", $$robo$$android_app_NotificationChannel$toJson(), 0, this);
    }

    private static AudioAttributes safeAudioAttributes(XmlPullParser xmlPullParser) {
        return InvokeDynamicSupport.bootstrapStatic("safeAudioAttributes", $$robo$$android_app_NotificationChannel$safeAudioAttributes(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    private static Uri safeUri(XmlPullParser xmlPullParser, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("safeUri", $$robo$$android_app_NotificationChannel$safeUri(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    private static int safeInt(XmlPullParser xmlPullParser, String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("safeInt", $$robo$$android_app_NotificationChannel$safeInt(org.xmlpull.v1.XmlPullParser java.lang.String int ), 0, (XmlPullParser)xmlPullParser, (String)string2, (int)n);
    }

    private static int tryParseInt(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("tryParseInt", $$robo$$android_app_NotificationChannel$tryParseInt(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static boolean safeBool(XmlPullParser xmlPullParser, String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("safeBool", $$robo$$android_app_NotificationChannel$safeBool(org.xmlpull.v1.XmlPullParser java.lang.String boolean ), 0, (XmlPullParser)xmlPullParser, (String)string2, (boolean)bl);
    }

    private static long[] safeLongArray(XmlPullParser xmlPullParser, String string2, long[] lArray) {
        return InvokeDynamicSupport.bootstrapStatic("safeLongArray", $$robo$$android_app_NotificationChannel$safeLongArray(org.xmlpull.v1.XmlPullParser java.lang.String long[] ), 0, (XmlPullParser)xmlPullParser, (String)string2, (long[])lArray);
    }

    private static String longArrayToString(long[] lArray) {
        return InvokeDynamicSupport.bootstrapStatic("longArrayToString", $$robo$$android_app_NotificationChannel$longArrayToString(long[] ), 0, (long[])lArray);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_NotificationChannel$describeContents(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_app_NotificationChannel$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_app_NotificationChannel$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_NotificationChannel$toString(), 0, this);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long l) {
        InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_app_NotificationChannel$writeToProto(android.util.proto.ProtoOutputStream long ), 0, this, protoOutputStream, l);
    }

    static {
        RobolectricInternals.classInitializing(NotificationChannel.class);
    }

    public /* synthetic */ NotificationChannel() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationChannel)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

