/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.IActivityManager;
import android.app.ISearchManager;
import android.app.SearchDialog;
import android.app.SearchableInfo;
import android.app.UiModeManager;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.TextUtils;
import android.util.Log;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SearchManager
implements DialogInterface.OnDismissListener,
DialogInterface.OnCancelListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String TAG = "SearchManager";
    public static char MENU_KEY = 's';
    public static int MENU_KEYCODE = 47;
    public static String QUERY = "query";
    public static String USER_QUERY = "user_query";
    public static String APP_DATA = "app_data";
    public static String SEARCH_MODE = "search_mode";
    public static String ACTION_KEY = "action_key";
    public static String EXTRA_DATA_KEY = "intent_extra_data_key";
    public static String EXTRA_SELECT_QUERY = "select_query";
    public static String EXTRA_NEW_SEARCH = "new_search";
    public static String EXTRA_WEB_SEARCH_PENDINGINTENT = "web_search_pendingintent";
    public static String CURSOR_EXTRA_KEY_IN_PROGRESS = "in_progress";
    public static String ACTION_MSG = "action_msg";
    public static int FLAG_QUERY_REFINEMENT = 1;
    public static String SUGGEST_URI_PATH_QUERY = "search_suggest_query";
    public static String SUGGEST_MIME_TYPE = "vnd.android.cursor.dir/vnd.android.search.suggest";
    public static String SUGGEST_URI_PATH_SHORTCUT = "search_suggest_shortcut";
    public static String SHORTCUT_MIME_TYPE = "vnd.android.cursor.item/vnd.android.search.suggest";
    public static String SUGGEST_COLUMN_FORMAT = "suggest_format";
    public static String SUGGEST_COLUMN_TEXT_1 = "suggest_text_1";
    public static String SUGGEST_COLUMN_TEXT_2 = "suggest_text_2";
    public static String SUGGEST_COLUMN_TEXT_2_URL = "suggest_text_2_url";
    public static String SUGGEST_COLUMN_ICON_1 = "suggest_icon_1";
    public static String SUGGEST_COLUMN_ICON_2 = "suggest_icon_2";
    public static String SUGGEST_COLUMN_RESULT_CARD_IMAGE = "suggest_result_card_image";
    public static String SUGGEST_COLUMN_INTENT_ACTION = "suggest_intent_action";
    public static String SUGGEST_COLUMN_INTENT_DATA = "suggest_intent_data";
    public static String SUGGEST_COLUMN_INTENT_EXTRA_DATA = "suggest_intent_extra_data";
    public static String SUGGEST_COLUMN_INTENT_DATA_ID = "suggest_intent_data_id";
    public static String SUGGEST_COLUMN_QUERY = "suggest_intent_query";
    public static String SUGGEST_COLUMN_SHORTCUT_ID = "suggest_shortcut_id";
    public static String SUGGEST_COLUMN_SPINNER_WHILE_REFRESHING = "suggest_spinner_while_refreshing";
    public static String SUGGEST_COLUMN_CONTENT_TYPE = "suggest_content_type";
    public static String SUGGEST_COLUMN_IS_LIVE = "suggest_is_live";
    public static String SUGGEST_COLUMN_VIDEO_WIDTH = "suggest_video_width";
    public static String SUGGEST_COLUMN_VIDEO_HEIGHT = "suggest_video_height";
    public static String SUGGEST_COLUMN_AUDIO_CHANNEL_CONFIG = "suggest_audio_channel_config";
    public static String SUGGEST_COLUMN_PURCHASE_PRICE = "suggest_purchase_price";
    public static String SUGGEST_COLUMN_RENTAL_PRICE = "suggest_rental_price";
    public static String SUGGEST_COLUMN_RATING_STYLE = "suggest_rating_style";
    public static String SUGGEST_COLUMN_RATING_SCORE = "suggest_rating_score";
    public static String SUGGEST_COLUMN_PRODUCTION_YEAR = "suggest_production_year";
    public static String SUGGEST_COLUMN_DURATION = "suggest_duration";
    public static String SUGGEST_COLUMN_FLAGS = "suggest_flags";
    public static String SUGGEST_COLUMN_LAST_ACCESS_HINT = "suggest_last_access_hint";
    public static String SUGGEST_NEVER_MAKE_SHORTCUT = "_-1";
    public static String SUGGEST_PARAMETER_LIMIT = "limit";
    public static String INTENT_ACTION_GLOBAL_SEARCH = "android.search.action.GLOBAL_SEARCH";
    public static String INTENT_ACTION_SEARCH_SETTINGS = "android.search.action.SEARCH_SETTINGS";
    public static String INTENT_ACTION_WEB_SEARCH_SETTINGS = "android.search.action.WEB_SEARCH_SETTINGS";
    public static String INTENT_ACTION_SEARCHABLES_CHANGED = "android.search.action.SEARCHABLES_CHANGED";
    public static String INTENT_GLOBAL_SEARCH_ACTIVITY_CHANGED = "android.search.action.GLOBAL_SEARCH_ACTIVITY_CHANGED";
    public static String INTENT_ACTION_SEARCH_SETTINGS_CHANGED = "android.search.action.SETTINGS_CHANGED";
    public static String CONTEXT_IS_VOICE = "android.search.CONTEXT_IS_VOICE";
    public static String DISABLE_VOICE_SEARCH = "android.search.DISABLE_VOICE_SEARCH";
    private ISearchManager mService;
    private Context mContext;
    Handler mHandler;
    OnDismissListener mDismissListener;
    OnCancelListener mCancelListener;
    private SearchDialog mSearchDialog;

    private void $$robo$$android_app_SearchManager$__constructor__(Context context, Handler handler) throws ServiceManager.ServiceNotFoundException {
        this.mDismissListener = null;
        this.mCancelListener = null;
        this.mContext = context;
        this.mHandler = handler;
        this.mService = ISearchManager.Stub.asInterface(ServiceManager.getServiceOrThrow("search"));
    }

    private final void $$robo$$android_app_SearchManager$startSearch(String initialQuery, boolean selectInitialQuery, ComponentName launchActivity, Bundle appSearchData, boolean globalSearch) {
        this.startSearch(initialQuery, selectInitialQuery, launchActivity, appSearchData, globalSearch, null);
    }

    private final void $$robo$$android_app_SearchManager$startSearch(String initialQuery, boolean selectInitialQuery, ComponentName launchActivity, Bundle appSearchData, boolean globalSearch, Rect sourceBounds) {
        if (globalSearch) {
            this.startGlobalSearch(initialQuery, selectInitialQuery, appSearchData, sourceBounds);
            return;
        }
        UiModeManager uiModeManager = this.mContext.getSystemService(UiModeManager.class);
        if (uiModeManager.getCurrentModeType() != 4) {
            this.ensureSearchDialog();
            this.mSearchDialog.show(initialQuery, selectInitialQuery, launchActivity, appSearchData);
        }
    }

    private final void $$robo$$android_app_SearchManager$ensureSearchDialog() {
        if (this.mSearchDialog == null) {
            this.mSearchDialog = new SearchDialog(this.mContext, this);
            this.mSearchDialog.setOnCancelListener(this);
            this.mSearchDialog.setOnDismissListener(this);
        }
    }

    private final void $$robo$$android_app_SearchManager$startGlobalSearch(String initialQuery, boolean selectInitialQuery, Bundle appSearchData, Rect sourceBounds) {
        ComponentName globalSearchActivity = this.getGlobalSearchActivity();
        if (globalSearchActivity == null) {
            Log.w("SearchManager", "No global search activity found.");
            return;
        }
        Intent intent = new Intent("android.search.action.GLOBAL_SEARCH");
        intent.addFlags(0x10000000);
        intent.setComponent(globalSearchActivity);
        appSearchData = appSearchData == null ? new Bundle() : new Bundle(appSearchData);
        if (!appSearchData.containsKey("source")) {
            appSearchData.putString("source", this.mContext.getPackageName());
        }
        intent.putExtra("app_data", appSearchData);
        if (!TextUtils.isEmpty(initialQuery)) {
            intent.putExtra("query", initialQuery);
        }
        if (selectInitialQuery) {
            intent.putExtra("select_query", selectInitialQuery);
        }
        intent.setSourceBounds(sourceBounds);
        try {
            this.mContext.startActivity(intent);
        }
        catch (ActivityNotFoundException ex) {
            Log.e("SearchManager", "Global search activity not found: " + globalSearchActivity);
        }
    }

    private final List<ResolveInfo> $$robo$$android_app_SearchManager$getGlobalSearchActivities() {
        try {
            return this.mService.getGlobalSearchActivities();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final ComponentName $$robo$$android_app_SearchManager$getGlobalSearchActivity() {
        try {
            return this.mService.getGlobalSearchActivity();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final ComponentName $$robo$$android_app_SearchManager$getWebSearchActivity() {
        try {
            return this.mService.getWebSearchActivity();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_SearchManager$triggerSearch(String query, ComponentName launchActivity, Bundle appSearchData) {
        if (query == null || TextUtils.getTrimmedLength(query) == 0) {
            Log.w("SearchManager", "triggerSearch called with empty query, ignoring.");
            return;
        }
        this.startSearch(query, false, launchActivity, appSearchData, false);
        this.mSearchDialog.launchQuerySearch();
    }

    private final void $$robo$$android_app_SearchManager$stopSearch() {
        if (this.mSearchDialog != null) {
            this.mSearchDialog.cancel();
        }
    }

    private final boolean $$robo$$android_app_SearchManager$isVisible() {
        return this.mSearchDialog == null ? false : this.mSearchDialog.isShowing();
    }

    private final void $$robo$$android_app_SearchManager$setOnDismissListener(OnDismissListener listener) {
        this.mDismissListener = listener;
    }

    private final void $$robo$$android_app_SearchManager$setOnCancelListener(OnCancelListener listener) {
        this.mCancelListener = listener;
    }

    @Deprecated
    private final void $$robo$$android_app_SearchManager$onCancel(DialogInterface dialog) {
        if (this.mCancelListener != null) {
            this.mCancelListener.onCancel();
        }
    }

    @Deprecated
    private final void $$robo$$android_app_SearchManager$onDismiss(DialogInterface dialog) {
        if (this.mDismissListener != null) {
            this.mDismissListener.onDismiss();
        }
    }

    private final SearchableInfo $$robo$$android_app_SearchManager$getSearchableInfo(ComponentName componentName) {
        try {
            return this.mService.getSearchableInfo(componentName);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final Cursor $$robo$$android_app_SearchManager$getSuggestions(SearchableInfo searchable, String query) {
        return this.getSuggestions(searchable, query, -1);
    }

    private final Cursor $$robo$$android_app_SearchManager$getSuggestions(SearchableInfo searchable, String query, int limit) {
        if (searchable == null) {
            return null;
        }
        String authority = searchable.getSuggestAuthority();
        if (authority == null) {
            return null;
        }
        Uri.Builder uriBuilder = new Uri.Builder().scheme("content").authority(authority).query("").fragment("");
        String contentPath = searchable.getSuggestPath();
        if (contentPath != null) {
            uriBuilder.appendEncodedPath(contentPath);
        }
        uriBuilder.appendPath("search_suggest_query");
        String selection = searchable.getSuggestSelection();
        String[] selArgs = null;
        if (selection != null) {
            selArgs = new String[]{query};
        } else {
            uriBuilder.appendPath(query);
        }
        if (limit > 0) {
            uriBuilder.appendQueryParameter("limit", String.valueOf(limit));
        }
        Uri uri = uriBuilder.build();
        return this.mContext.getContentResolver().query(uri, null, selection, selArgs, null);
    }

    private final List<SearchableInfo> $$robo$$android_app_SearchManager$getSearchablesInGlobalSearch() {
        try {
            return this.mService.getSearchablesInGlobalSearch();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Intent $$robo$$android_app_SearchManager$getAssistIntent(boolean inclContext) {
        try {
            IActivityManager am;
            Bundle extras;
            Intent intent = new Intent("android.intent.action.ASSIST");
            if (inclContext && (extras = (am = ActivityManager.getService()).getAssistContextExtras(0)) != null) {
                intent.replaceExtras(extras);
            }
            return intent;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_SearchManager$launchAssist(Bundle args) {
        try {
            if (this.mService == null) {
                return;
            }
            this.mService.launchAssist(args);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_SearchManager$launchLegacyAssist(String hint, int userHandle, Bundle args) {
        try {
            if (this.mService == null) {
                return false;
            }
            return this.mService.launchLegacyAssist(hint, userHandle, args);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private void __constructor__(Context context, Handler handler) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$$android_app_SearchManager$__constructor__(context, handler);
    }

    SearchManager(Context context, Handler handler) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_SearchManager$__constructor__(android.content.Context android.os.Handler ), 0, this, context, handler);
    }

    public void startSearch(String string2, boolean bl, ComponentName componentName, Bundle bundle, boolean bl2) {
        InvokeDynamicSupport.bootstrap("startSearch", $$robo$$android_app_SearchManager$startSearch(java.lang.String boolean android.content.ComponentName android.os.Bundle boolean ), 0, this, string2, bl, componentName, bundle, bl2);
    }

    public void startSearch(String string2, boolean bl, ComponentName componentName, Bundle bundle, boolean bl2, Rect rect) {
        InvokeDynamicSupport.bootstrap("startSearch", $$robo$$android_app_SearchManager$startSearch(java.lang.String boolean android.content.ComponentName android.os.Bundle boolean android.graphics.Rect ), 0, this, string2, bl, componentName, bundle, bl2, rect);
    }

    private void ensureSearchDialog() {
        InvokeDynamicSupport.bootstrap("ensureSearchDialog", $$robo$$android_app_SearchManager$ensureSearchDialog(), 0, this);
    }

    void startGlobalSearch(String string2, boolean bl, Bundle bundle, Rect rect) {
        InvokeDynamicSupport.bootstrap("startGlobalSearch", $$robo$$android_app_SearchManager$startGlobalSearch(java.lang.String boolean android.os.Bundle android.graphics.Rect ), 0, this, string2, bl, bundle, rect);
    }

    public List<ResolveInfo> getGlobalSearchActivities() {
        return InvokeDynamicSupport.bootstrap("getGlobalSearchActivities", $$robo$$android_app_SearchManager$getGlobalSearchActivities(), 0, this);
    }

    public ComponentName getGlobalSearchActivity() {
        return InvokeDynamicSupport.bootstrap("getGlobalSearchActivity", $$robo$$android_app_SearchManager$getGlobalSearchActivity(), 0, this);
    }

    public ComponentName getWebSearchActivity() {
        return InvokeDynamicSupport.bootstrap("getWebSearchActivity", $$robo$$android_app_SearchManager$getWebSearchActivity(), 0, this);
    }

    public void triggerSearch(String string2, ComponentName componentName, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("triggerSearch", $$robo$$android_app_SearchManager$triggerSearch(java.lang.String android.content.ComponentName android.os.Bundle ), 0, this, string2, componentName, bundle);
    }

    public void stopSearch() {
        InvokeDynamicSupport.bootstrap("stopSearch", $$robo$$android_app_SearchManager$stopSearch(), 0, this);
    }

    public boolean isVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisible", $$robo$$android_app_SearchManager$isVisible(), 0, this);
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        InvokeDynamicSupport.bootstrap("setOnDismissListener", $$robo$$android_app_SearchManager$setOnDismissListener(android.app.SearchManager$OnDismissListener ), 0, this, onDismissListener);
    }

    public void setOnCancelListener(OnCancelListener onCancelListener) {
        InvokeDynamicSupport.bootstrap("setOnCancelListener", $$robo$$android_app_SearchManager$setOnCancelListener(android.app.SearchManager$OnCancelListener ), 0, this, onCancelListener);
    }

    @Override
    @Deprecated
    public void onCancel(DialogInterface dialogInterface) {
        InvokeDynamicSupport.bootstrap("onCancel", $$robo$$android_app_SearchManager$onCancel(android.content.DialogInterface ), 0, this, dialogInterface);
    }

    @Override
    @Deprecated
    public void onDismiss(DialogInterface dialogInterface) {
        InvokeDynamicSupport.bootstrap("onDismiss", $$robo$$android_app_SearchManager$onDismiss(android.content.DialogInterface ), 0, this, dialogInterface);
    }

    public SearchableInfo getSearchableInfo(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getSearchableInfo", $$robo$$android_app_SearchManager$getSearchableInfo(android.content.ComponentName ), 0, this, componentName);
    }

    public Cursor getSuggestions(SearchableInfo searchableInfo, String string2) {
        return InvokeDynamicSupport.bootstrap("getSuggestions", $$robo$$android_app_SearchManager$getSuggestions(android.app.SearchableInfo java.lang.String ), 0, this, searchableInfo, string2);
    }

    public Cursor getSuggestions(SearchableInfo searchableInfo, String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getSuggestions", $$robo$$android_app_SearchManager$getSuggestions(android.app.SearchableInfo java.lang.String int ), 0, this, searchableInfo, string2, n);
    }

    public List<SearchableInfo> getSearchablesInGlobalSearch() {
        return InvokeDynamicSupport.bootstrap("getSearchablesInGlobalSearch", $$robo$$android_app_SearchManager$getSearchablesInGlobalSearch(), 0, this);
    }

    public Intent getAssistIntent(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getAssistIntent", $$robo$$android_app_SearchManager$getAssistIntent(boolean ), 0, this, bl);
    }

    public void launchAssist(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("launchAssist", $$robo$$android_app_SearchManager$launchAssist(android.os.Bundle ), 0, this, bundle);
    }

    public boolean launchLegacyAssist(String string2, int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("launchLegacyAssist", $$robo$$android_app_SearchManager$launchLegacyAssist(java.lang.String int android.os.Bundle ), 0, this, string2, n, bundle);
    }

    public /* synthetic */ SearchManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SearchManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnCancelListener
    extends InstrumentedInterface {
        public void onCancel();
    }

    public static interface OnDismissListener
    extends InstrumentedInterface {
        public void onDismiss();
    }
}

