/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.content.Context;
import android.os.IBinder;
import android.os.IStatsManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.AndroidException;
import android.util.Slog;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class StatsManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "StatsManager";
    private static boolean DEBUG = false;
    private Context mContext;
    private IStatsManager mService;
    public static String EXTRA_STATS_CONFIG_UID = "android.app.extra.STATS_CONFIG_UID";
    public static String EXTRA_STATS_CONFIG_KEY = "android.app.extra.STATS_CONFIG_KEY";
    public static String EXTRA_STATS_SUBSCRIPTION_ID = "android.app.extra.STATS_SUBSCRIPTION_ID";
    public static String EXTRA_STATS_SUBSCRIPTION_RULE_ID = "android.app.extra.STATS_SUBSCRIPTION_RULE_ID";
    public static String EXTRA_STATS_BROADCAST_SUBSCRIBER_COOKIES = "android.app.extra.STATS_BROADCAST_SUBSCRIBER_COOKIES";
    public static String EXTRA_STATS_DIMENSIONS_VALUE = "android.app.extra.STATS_DIMENSIONS_VALUE";
    public static String ACTION_STATSD_STARTED = "android.app.action.STATSD_STARTED";

    private void $$robo$$android_app_StatsManager$__constructor__(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_StatsManager$addConfig(long configKey, byte[] config) throws StatsUnavailableException {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                service.addConfiguration(configKey, config, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Slog.e("StatsManager", "Failed to connect to statsd when adding configuration");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    private final boolean $$robo$$android_app_StatsManager$addConfiguration(long configKey, byte[] config) {
        try {
            this.addConfig(configKey, config);
            return true;
        }
        catch (StatsUnavailableException | IllegalArgumentException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_StatsManager$removeConfig(long configKey) throws StatsUnavailableException {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                service.removeConfiguration(configKey, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Slog.e("StatsManager", "Failed to connect to statsd when removing configuration");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    private final boolean $$robo$$android_app_StatsManager$removeConfiguration(long configKey) {
        try {
            this.removeConfig(configKey);
            return true;
        }
        catch (StatsUnavailableException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_StatsManager$setBroadcastSubscriber(PendingIntent pendingIntent, long configKey, long subscriberId) throws StatsUnavailableException {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (pendingIntent != null) {
                    IBinder intentSender = pendingIntent.getTarget().asBinder();
                    service.setBroadcastSubscriber(configKey, subscriberId, intentSender, this.mContext.getOpPackageName());
                } else {
                    service.unsetBroadcastSubscriber(configKey, subscriberId, this.mContext.getOpPackageName());
                }
            }
            catch (RemoteException e) {
                Slog.e("StatsManager", "Failed to connect to statsd when adding broadcast subscriber", e);
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    private final boolean $$robo$$android_app_StatsManager$setBroadcastSubscriber(long configKey, long subscriberId, PendingIntent pendingIntent) {
        try {
            this.setBroadcastSubscriber(pendingIntent, configKey, subscriberId);
            return true;
        }
        catch (StatsUnavailableException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_StatsManager$setFetchReportsOperation(PendingIntent pendingIntent, long configKey) throws StatsUnavailableException {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (pendingIntent == null) {
                    service.removeDataFetchOperation(configKey, this.mContext.getOpPackageName());
                } else {
                    IBinder intentSender = pendingIntent.getTarget().asBinder();
                    service.setDataFetchOperation(configKey, intentSender, this.mContext.getOpPackageName());
                }
            }
            catch (RemoteException e) {
                Slog.e("StatsManager", "Failed to connect to statsd when registering data listener.");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    private final boolean $$robo$$android_app_StatsManager$setDataFetchOperation(long configKey, PendingIntent pendingIntent) {
        try {
            this.setFetchReportsOperation(pendingIntent, configKey);
            return true;
        }
        catch (StatsUnavailableException e) {
            return false;
        }
    }

    private final byte[] $$robo$$android_app_StatsManager$getReports(long configKey) throws StatsUnavailableException {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                return service.getData(configKey, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Slog.e("StatsManager", "Failed to connect to statsd when getting data");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    private final byte[] $$robo$$android_app_StatsManager$getData(long configKey) {
        try {
            return this.getReports(configKey);
        }
        catch (StatsUnavailableException e) {
            return null;
        }
    }

    private final byte[] $$robo$$android_app_StatsManager$getStatsMetadata() throws StatsUnavailableException {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                return service.getMetadata(this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Slog.e("StatsManager", "Failed to connect to statsd when getting metadata");
                throw new StatsUnavailableException("could not connect", e);
            }
            catch (SecurityException e) {
                throw new StatsUnavailableException(e.getMessage(), e);
            }
        }
    }

    private final byte[] $$robo$$android_app_StatsManager$getMetadata() {
        try {
            return this.getStatsMetadata();
        }
        catch (StatsUnavailableException e) {
            return null;
        }
    }

    private final IStatsManager $$robo$$android_app_StatsManager$getIStatsManagerLocked() throws StatsUnavailableException {
        if (this.mService != null) {
            return this.mService;
        }
        this.mService = IStatsManager.Stub.asInterface(ServiceManager.getService("stats"));
        if (this.mService == null) {
            throw new StatsUnavailableException("could not be found");
        }
        try {
            this.mService.asBinder().linkToDeath(new StatsdDeathRecipient(this), 0);
        }
        catch (RemoteException e) {
            throw new StatsUnavailableException("could not connect when linkToDeath", e);
        }
        return this.mService;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_StatsManager$__constructor__(context);
    }

    public StatsManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_StatsManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public void addConfig(long l, byte[] byArray) throws StatsUnavailableException {
        InvokeDynamicSupport.bootstrap("addConfig", $$robo$$android_app_StatsManager$addConfig(long byte[] ), 0, this, l, byArray);
    }

    public boolean addConfiguration(long l, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("addConfiguration", $$robo$$android_app_StatsManager$addConfiguration(long byte[] ), 0, this, l, byArray);
    }

    public void removeConfig(long l) throws StatsUnavailableException {
        InvokeDynamicSupport.bootstrap("removeConfig", $$robo$$android_app_StatsManager$removeConfig(long ), 0, this, l);
    }

    public boolean removeConfiguration(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeConfiguration", $$robo$$android_app_StatsManager$removeConfiguration(long ), 0, this, l);
    }

    public void setBroadcastSubscriber(PendingIntent pendingIntent, long l, long l2) throws StatsUnavailableException {
        InvokeDynamicSupport.bootstrap("setBroadcastSubscriber", $$robo$$android_app_StatsManager$setBroadcastSubscriber(android.app.PendingIntent long long ), 0, this, pendingIntent, l, l2);
    }

    public boolean setBroadcastSubscriber(long l, long l2, PendingIntent pendingIntent) {
        return (boolean)InvokeDynamicSupport.bootstrap("setBroadcastSubscriber", $$robo$$android_app_StatsManager$setBroadcastSubscriber(long long android.app.PendingIntent ), 0, this, l, l2, pendingIntent);
    }

    public void setFetchReportsOperation(PendingIntent pendingIntent, long l) throws StatsUnavailableException {
        InvokeDynamicSupport.bootstrap("setFetchReportsOperation", $$robo$$android_app_StatsManager$setFetchReportsOperation(android.app.PendingIntent long ), 0, this, pendingIntent, l);
    }

    public boolean setDataFetchOperation(long l, PendingIntent pendingIntent) {
        return (boolean)InvokeDynamicSupport.bootstrap("setDataFetchOperation", $$robo$$android_app_StatsManager$setDataFetchOperation(long android.app.PendingIntent ), 0, this, l, pendingIntent);
    }

    public byte[] getReports(long l) throws StatsUnavailableException {
        return InvokeDynamicSupport.bootstrap("getReports", $$robo$$android_app_StatsManager$getReports(long ), 0, this, l);
    }

    public byte[] getData(long l) {
        return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_app_StatsManager$getData(long ), 0, this, l);
    }

    public byte[] getStatsMetadata() throws StatsUnavailableException {
        return InvokeDynamicSupport.bootstrap("getStatsMetadata", $$robo$$android_app_StatsManager$getStatsMetadata(), 0, this);
    }

    public byte[] getMetadata() {
        return InvokeDynamicSupport.bootstrap("getMetadata", $$robo$$android_app_StatsManager$getMetadata(), 0, this);
    }

    private IStatsManager getIStatsManagerLocked() throws StatsUnavailableException {
        return InvokeDynamicSupport.bootstrap("getIStatsManagerLocked", $$robo$$android_app_StatsManager$getIStatsManagerLocked(), 0, this);
    }

    public /* synthetic */ StatsManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StatsManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class StatsUnavailableException
    extends AndroidException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_app_StatsManager_StatsUnavailableException$__constructor__(String reason) {
        }

        private void $$robo$$android_app_StatsManager_StatsUnavailableException$__constructor__(String reason, Throwable e) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_app_StatsManager_StatsUnavailableException$__constructor__(string2);
        }

        public StatsUnavailableException(String string2) {
            super("Failed to connect to statsd: " + string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_StatsManager_StatsUnavailableException$__constructor__(java.lang.String ), 0, this, string2);
        }

        private void __constructor__(String string2, Throwable throwable) {
            this.$$robo$$android_app_StatsManager_StatsUnavailableException$__constructor__(string2, throwable);
        }

        public StatsUnavailableException(String string2, Throwable throwable) {
            super("Failed to connect to statsd: " + string2, throwable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_StatsManager_StatsUnavailableException$__constructor__(java.lang.String java.lang.Throwable ), 0, this, string2, throwable);
        }

        public /* synthetic */ StatsUnavailableException() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StatsUnavailableException)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class StatsdDeathRecipient
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ StatsManager this$0;

        private void $$robo$$android_app_StatsManager_StatsdDeathRecipient$__constructor__(StatsManager statsManager) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_StatsManager_StatsdDeathRecipient$binderDied() {
            StatsdDeathRecipient statsdDeathRecipient = this;
            synchronized (statsdDeathRecipient) {
                this.this$0.mService = null;
            }
        }

        private /* synthetic */ void $$robo$$android_app_StatsManager_StatsdDeathRecipient$__constructor__(StatsManager x0, 1 x1) {
        }

        private void __constructor__(StatsManager statsManager) {
            this.$$robo$$android_app_StatsManager_StatsdDeathRecipient$__constructor__(statsManager);
        }

        private StatsdDeathRecipient(StatsManager statsManager) {
            this.this$0 = statsManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_StatsManager_StatsdDeathRecipient$__constructor__(android.app.StatsManager ), 0, this, statsManager);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_app_StatsManager_StatsdDeathRecipient$binderDied(), 0, this);
        }

        private /* synthetic */ void __constructor__(StatsManager statsManager, 1 var2_2) {
            this.$$robo$$android_app_StatsManager_StatsdDeathRecipient$__constructor__(statsManager, var2_2);
        }

        public /* synthetic */ StatsdDeathRecipient() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StatsdDeathRecipient)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

