/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Printer;
import android.util.Xml;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class WallpaperInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "WallpaperInfo";
    ResolveInfo mService;
    String mSettingsActivityName;
    int mThumbnailResource;
    int mAuthorResource;
    int mDescriptionResource;
    int mContextUriResource;
    int mContextDescriptionResource;
    boolean mShowMetadataInPreview;
    boolean mSupportsAmbientMode;
    public static Parcelable.Creator<WallpaperInfo> CREATOR;

    private void $$robo$$android_app_WallpaperInfo$__constructor__(Context context, ResolveInfo service) throws XmlPullParserException, IOException {
        this.mService = service;
        ServiceInfo si = service.serviceInfo;
        PackageManager pm = context.getPackageManager();
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, "android.service.wallpaper");
            if (parser == null) {
                throw new XmlPullParserException("No android.service.wallpaper meta-data");
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"wallpaper".equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with wallpaper tag");
            }
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.Wallpaper);
            this.mSettingsActivityName = sa.getString(1);
            this.mThumbnailResource = sa.getResourceId(2, -1);
            this.mAuthorResource = sa.getResourceId(3, -1);
            this.mDescriptionResource = sa.getResourceId(0, -1);
            this.mContextUriResource = sa.getResourceId(4, -1);
            this.mContextDescriptionResource = sa.getResourceId(5, -1);
            this.mShowMetadataInPreview = sa.getBoolean(6, false);
            this.mSupportsAmbientMode = sa.getBoolean(7, false);
            sa.recycle();
        }
    }

    private void $$robo$$android_app_WallpaperInfo$__constructor__(Parcel source) {
        this.mSettingsActivityName = source.readString();
        this.mThumbnailResource = source.readInt();
        this.mAuthorResource = source.readInt();
        this.mDescriptionResource = source.readInt();
        this.mContextUriResource = source.readInt();
        this.mContextDescriptionResource = source.readInt();
        this.mShowMetadataInPreview = source.readInt() != 0;
        this.mSupportsAmbientMode = source.readInt() != 0;
        this.mService = ResolveInfo.CREATOR.createFromParcel(source);
    }

    private final String $$robo$$android_app_WallpaperInfo$getPackageName() {
        return this.mService.serviceInfo.packageName;
    }

    private final String $$robo$$android_app_WallpaperInfo$getServiceName() {
        return this.mService.serviceInfo.name;
    }

    private final ServiceInfo $$robo$$android_app_WallpaperInfo$getServiceInfo() {
        return this.mService.serviceInfo;
    }

    private final ComponentName $$robo$$android_app_WallpaperInfo$getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    private final CharSequence $$robo$$android_app_WallpaperInfo$loadLabel(PackageManager pm) {
        return this.mService.loadLabel(pm);
    }

    private final Drawable $$robo$$android_app_WallpaperInfo$loadIcon(PackageManager pm) {
        return this.mService.loadIcon(pm);
    }

    private final Drawable $$robo$$android_app_WallpaperInfo$loadThumbnail(PackageManager pm) {
        if (this.mThumbnailResource < 0) {
            return null;
        }
        return pm.getDrawable(this.mService.serviceInfo.packageName, this.mThumbnailResource, this.mService.serviceInfo.applicationInfo);
    }

    private final CharSequence $$robo$$android_app_WallpaperInfo$loadAuthor(PackageManager pm) throws Resources.NotFoundException {
        if (this.mAuthorResource <= 0) {
            throw new Resources.NotFoundException();
        }
        String packageName = this.mService.resolvePackageName;
        ApplicationInfo applicationInfo = null;
        if (packageName == null) {
            packageName = this.mService.serviceInfo.packageName;
            applicationInfo = this.mService.serviceInfo.applicationInfo;
        }
        return pm.getText(packageName, this.mAuthorResource, applicationInfo);
    }

    private final CharSequence $$robo$$android_app_WallpaperInfo$loadDescription(PackageManager pm) throws Resources.NotFoundException {
        String packageName = this.mService.resolvePackageName;
        ApplicationInfo applicationInfo = null;
        if (packageName == null) {
            packageName = this.mService.serviceInfo.packageName;
            applicationInfo = this.mService.serviceInfo.applicationInfo;
        }
        if (this.mService.serviceInfo.descriptionRes != 0) {
            return pm.getText(packageName, this.mService.serviceInfo.descriptionRes, applicationInfo);
        }
        if (this.mDescriptionResource <= 0) {
            throw new Resources.NotFoundException();
        }
        return pm.getText(packageName, this.mDescriptionResource, this.mService.serviceInfo.applicationInfo);
    }

    private final Uri $$robo$$android_app_WallpaperInfo$loadContextUri(PackageManager pm) throws Resources.NotFoundException {
        String contextUriString;
        if (this.mContextUriResource <= 0) {
            throw new Resources.NotFoundException();
        }
        String packageName = this.mService.resolvePackageName;
        ApplicationInfo applicationInfo = null;
        if (packageName == null) {
            packageName = this.mService.serviceInfo.packageName;
            applicationInfo = this.mService.serviceInfo.applicationInfo;
        }
        if ((contextUriString = pm.getText(packageName, this.mContextUriResource, applicationInfo).toString()) == null) {
            return null;
        }
        return Uri.parse(contextUriString);
    }

    private final CharSequence $$robo$$android_app_WallpaperInfo$loadContextDescription(PackageManager pm) throws Resources.NotFoundException {
        if (this.mContextDescriptionResource <= 0) {
            throw new Resources.NotFoundException();
        }
        String packageName = this.mService.resolvePackageName;
        ApplicationInfo applicationInfo = null;
        if (packageName == null) {
            packageName = this.mService.serviceInfo.packageName;
            applicationInfo = this.mService.serviceInfo.applicationInfo;
        }
        return pm.getText(packageName, this.mContextDescriptionResource, applicationInfo).toString();
    }

    private final boolean $$robo$$android_app_WallpaperInfo$getShowMetadataInPreview() {
        return this.mShowMetadataInPreview;
    }

    private final boolean $$robo$$android_app_WallpaperInfo$getSupportsAmbientMode() {
        return this.mSupportsAmbientMode;
    }

    private final String $$robo$$android_app_WallpaperInfo$getSettingsActivity() {
        return this.mSettingsActivityName;
    }

    private final void $$robo$$android_app_WallpaperInfo$dump(Printer pw, String prefix) {
        pw.println(prefix + "Service:");
        this.mService.dump(pw, prefix + "  ");
        pw.println(prefix + "mSettingsActivityName=" + this.mSettingsActivityName);
    }

    private final String $$robo$$android_app_WallpaperInfo$toString() {
        return "WallpaperInfo{" + this.mService.serviceInfo.name + ", settings: " + this.mSettingsActivityName + "}";
    }

    private final void $$robo$$android_app_WallpaperInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mSettingsActivityName);
        dest.writeInt(this.mThumbnailResource);
        dest.writeInt(this.mAuthorResource);
        dest.writeInt(this.mDescriptionResource);
        dest.writeInt(this.mContextUriResource);
        dest.writeInt(this.mContextDescriptionResource);
        dest.writeInt(this.mShowMetadataInPreview ? 1 : 0);
        dest.writeInt(this.mSupportsAmbientMode ? 1 : 0);
        this.mService.writeToParcel(dest, flags);
    }

    private final int $$robo$$android_app_WallpaperInfo$describeContents() {
        return 0;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<WallpaperInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_WallpaperInfo_1$__constructor__() {
            }

            private final WallpaperInfo $$robo$$android_app_WallpaperInfo_1$createFromParcel(Parcel source) {
                return new WallpaperInfo(source);
            }

            private final WallpaperInfo[] $$robo$$android_app_WallpaperInfo_1$newArray(int size) {
                return new WallpaperInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_app_WallpaperInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WallpaperInfo_1$__constructor__(), 0, this);
            }

            @Override
            public WallpaperInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_WallpaperInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public WallpaperInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_WallpaperInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Context context, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        this.$$robo$$android_app_WallpaperInfo$__constructor__(context, resolveInfo);
    }

    public WallpaperInfo(Context context, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WallpaperInfo$__constructor__(android.content.Context android.content.pm.ResolveInfo ), 0, this, context, resolveInfo);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_app_WallpaperInfo$__constructor__(parcel);
    }

    WallpaperInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WallpaperInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public String getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_app_WallpaperInfo$getPackageName(), 0, this);
    }

    public String getServiceName() {
        return InvokeDynamicSupport.bootstrap("getServiceName", $$robo$$android_app_WallpaperInfo$getServiceName(), 0, this);
    }

    public ServiceInfo getServiceInfo() {
        return InvokeDynamicSupport.bootstrap("getServiceInfo", $$robo$$android_app_WallpaperInfo$getServiceInfo(), 0, this);
    }

    public ComponentName getComponent() {
        return InvokeDynamicSupport.bootstrap("getComponent", $$robo$$android_app_WallpaperInfo$getComponent(), 0, this);
    }

    public CharSequence loadLabel(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadLabel", $$robo$$android_app_WallpaperInfo$loadLabel(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public Drawable loadIcon(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadIcon", $$robo$$android_app_WallpaperInfo$loadIcon(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public Drawable loadThumbnail(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadThumbnail", $$robo$$android_app_WallpaperInfo$loadThumbnail(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public CharSequence loadAuthor(PackageManager packageManager) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadAuthor", $$robo$$android_app_WallpaperInfo$loadAuthor(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public CharSequence loadDescription(PackageManager packageManager) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadDescription", $$robo$$android_app_WallpaperInfo$loadDescription(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public Uri loadContextUri(PackageManager packageManager) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadContextUri", $$robo$$android_app_WallpaperInfo$loadContextUri(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public CharSequence loadContextDescription(PackageManager packageManager) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadContextDescription", $$robo$$android_app_WallpaperInfo$loadContextDescription(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public boolean getShowMetadataInPreview() {
        return (boolean)InvokeDynamicSupport.bootstrap("getShowMetadataInPreview", $$robo$$android_app_WallpaperInfo$getShowMetadataInPreview(), 0, this);
    }

    public boolean getSupportsAmbientMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSupportsAmbientMode", $$robo$$android_app_WallpaperInfo$getSupportsAmbientMode(), 0, this);
    }

    public String getSettingsActivity() {
        return InvokeDynamicSupport.bootstrap("getSettingsActivity", $$robo$$android_app_WallpaperInfo$getSettingsActivity(), 0, this);
    }

    public void dump(Printer printer, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_WallpaperInfo$dump(android.util.Printer java.lang.String ), 0, this, printer, string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_WallpaperInfo$toString(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_WallpaperInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_WallpaperInfo$describeContents(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(WallpaperInfo.class);
    }

    public /* synthetic */ WallpaperInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WallpaperInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

