/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.IServiceConnection;
import android.app.admin.IDevicePolicyManager;
import android.app.admin.NetworkEvent;
import android.app.admin.PasswordMetrics;
import android.app.admin.SecurityLog;
import android.app.admin.SystemUpdateInfo;
import android.app.admin.SystemUpdatePolicy;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.IPackageDataObserver;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.UserInfo;
import android.graphics.Bitmap;
import android.net.ProxyInfo;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.os.UserHandle;
import android.os.UserManager;
import android.security.AttestedKeyPair;
import android.security.Credentials;
import android.security.KeyChain;
import android.security.KeyChainException;
import android.security.keymaster.KeymasterCertificateChain;
import android.security.keystore.AttestationUtils;
import android.security.keystore.KeyAttestationException;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.ParcelableKeyGenParameterSpec;
import android.telephony.data.ApnSetting;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.android.org.conscrypt.TrustedCertificateStore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DevicePolicyManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private Context mContext;
    private IDevicePolicyManager mService;
    private boolean mParentInstance;
    public static String ACTION_PROVISION_MANAGED_PROFILE = "android.app.action.PROVISION_MANAGED_PROFILE";
    public static String ACTION_PROVISION_MANAGED_USER = "android.app.action.PROVISION_MANAGED_USER";
    public static String ACTION_PROVISION_MANAGED_DEVICE = "android.app.action.PROVISION_MANAGED_DEVICE";
    @SystemApi
    public static String ACTION_STATE_USER_SETUP_COMPLETE = "android.app.action.STATE_USER_SETUP_COMPLETE";
    @SystemApi
    public static String ACTION_PROVISION_MANAGED_DEVICE_FROM_TRUSTED_SOURCE = "android.app.action.PROVISION_MANAGED_DEVICE_FROM_TRUSTED_SOURCE";
    public static String ACTION_PROVISION_MANAGED_SHAREABLE_DEVICE = "android.app.action.PROVISION_MANAGED_SHAREABLE_DEVICE";
    @SystemApi
    public static String ACTION_PROVISION_FINALIZATION = "android.app.action.PROVISION_FINALIZATION";
    public static String ACTION_BUGREPORT_SHARING_ACCEPTED = "com.android.server.action.REMOTE_BUGREPORT_SHARING_ACCEPTED";
    public static String ACTION_BUGREPORT_SHARING_DECLINED = "com.android.server.action.REMOTE_BUGREPORT_SHARING_DECLINED";
    public static String ACTION_REMOTE_BUGREPORT_DISPATCH = "android.intent.action.REMOTE_BUGREPORT_DISPATCH";
    public static String EXTRA_REMOTE_BUGREPORT_HASH = "android.intent.extra.REMOTE_BUGREPORT_HASH";
    public static String EXTRA_BUGREPORT_NOTIFICATION_TYPE = "android.app.extra.bugreport_notification_type";
    public static int NOTIFICATION_BUGREPORT_STARTED = 1;
    public static int NOTIFICATION_BUGREPORT_ACCEPTED_NOT_FINISHED = 2;
    public static int NOTIFICATION_BUGREPORT_FINISHED_NOT_ACCEPTED = 3;
    public static long DEFAULT_STRONG_AUTH_TIMEOUT_MS = 259200000L;
    public static String EXTRA_PROVISIONING_ADMIN_EXTRAS_BUNDLE = "android.app.extra.PROVISIONING_ADMIN_EXTRAS_BUNDLE";
    @Deprecated
    public static String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_NAME = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_NAME";
    public static String EXTRA_PROVISIONING_DEVICE_ADMIN_COMPONENT_NAME = "android.app.extra.PROVISIONING_DEVICE_ADMIN_COMPONENT_NAME";
    public static String EXTRA_PROVISIONING_ACCOUNT_TO_MIGRATE = "android.app.extra.PROVISIONING_ACCOUNT_TO_MIGRATE";
    public static String EXTRA_PROVISIONING_KEEP_ACCOUNT_ON_MIGRATION = "android.app.extra.PROVISIONING_KEEP_ACCOUNT_ON_MIGRATION";
    @Deprecated
    public static String EXTRA_PROVISIONING_EMAIL_ADDRESS = "android.app.extra.PROVISIONING_EMAIL_ADDRESS";
    public static String EXTRA_PROVISIONING_MAIN_COLOR = "android.app.extra.PROVISIONING_MAIN_COLOR";
    public static String EXTRA_PROVISIONING_LEAVE_ALL_SYSTEM_APPS_ENABLED = "android.app.extra.PROVISIONING_LEAVE_ALL_SYSTEM_APPS_ENABLED";
    public static String EXTRA_PROVISIONING_TIME_ZONE = "android.app.extra.PROVISIONING_TIME_ZONE";
    public static String EXTRA_PROVISIONING_LOCAL_TIME = "android.app.extra.PROVISIONING_LOCAL_TIME";
    public static String EXTRA_PROVISIONING_LOCALE = "android.app.extra.PROVISIONING_LOCALE";
    public static String EXTRA_PROVISIONING_WIFI_SSID = "android.app.extra.PROVISIONING_WIFI_SSID";
    public static String EXTRA_PROVISIONING_WIFI_HIDDEN = "android.app.extra.PROVISIONING_WIFI_HIDDEN";
    public static String EXTRA_PROVISIONING_WIFI_SECURITY_TYPE = "android.app.extra.PROVISIONING_WIFI_SECURITY_TYPE";
    public static String EXTRA_PROVISIONING_WIFI_PASSWORD = "android.app.extra.PROVISIONING_WIFI_PASSWORD";
    public static String EXTRA_PROVISIONING_WIFI_PROXY_HOST = "android.app.extra.PROVISIONING_WIFI_PROXY_HOST";
    public static String EXTRA_PROVISIONING_WIFI_PROXY_PORT = "android.app.extra.PROVISIONING_WIFI_PROXY_PORT";
    public static String EXTRA_PROVISIONING_WIFI_PROXY_BYPASS = "android.app.extra.PROVISIONING_WIFI_PROXY_BYPASS";
    public static String EXTRA_PROVISIONING_WIFI_PAC_URL = "android.app.extra.PROVISIONING_WIFI_PAC_URL";
    public static String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_LOCATION = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_LOCATION";
    @SystemApi
    public static String EXTRA_PROVISIONING_ORGANIZATION_NAME = "android.app.extra.PROVISIONING_ORGANIZATION_NAME";
    @SystemApi
    public static String EXTRA_PROVISIONING_SUPPORT_URL = "android.app.extra.PROVISIONING_SUPPORT_URL";
    @SystemApi
    public static String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_LABEL = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_LABEL";
    @SystemApi
    public static String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_ICON_URI = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_ICON_URI";
    public static String EXTRA_PROVISIONING_DEVICE_ADMIN_MINIMUM_VERSION_CODE = "android.app.extra.PROVISIONING_DEVICE_ADMIN_MINIMUM_VERSION_CODE";
    public static String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_COOKIE_HEADER = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_COOKIE_HEADER";
    public static String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_CHECKSUM = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_CHECKSUM";
    public static String EXTRA_PROVISIONING_DEVICE_ADMIN_SIGNATURE_CHECKSUM = "android.app.extra.PROVISIONING_DEVICE_ADMIN_SIGNATURE_CHECKSUM";
    public static String ACTION_MANAGED_PROFILE_PROVISIONED = "android.app.action.MANAGED_PROFILE_PROVISIONED";
    public static String ACTION_PROVISIONING_SUCCESSFUL = "android.app.action.PROVISIONING_SUCCESSFUL";
    public static String EXTRA_PROVISIONING_SKIP_ENCRYPTION = "android.app.extra.PROVISIONING_SKIP_ENCRYPTION";
    public static String EXTRA_PROVISIONING_LOGO_URI = "android.app.extra.PROVISIONING_LOGO_URI";
    public static String EXTRA_PROVISIONING_DISCLAIMERS = "android.app.extra.PROVISIONING_DISCLAIMERS";
    public static String EXTRA_PROVISIONING_DISCLAIMER_HEADER = "android.app.extra.PROVISIONING_DISCLAIMER_HEADER";
    public static String EXTRA_PROVISIONING_DISCLAIMER_CONTENT = "android.app.extra.PROVISIONING_DISCLAIMER_CONTENT";
    public static String EXTRA_PROVISIONING_SKIP_USER_SETUP = "android.app.extra.PROVISIONING_SKIP_USER_SETUP";
    public static String EXTRA_PROVISIONING_SKIP_USER_CONSENT = "android.app.extra.PROVISIONING_SKIP_USER_CONSENT";
    public static String EXTRA_PROVISIONING_USE_MOBILE_DATA = "android.app.extra.PROVISIONING_USE_MOBILE_DATA";
    public static String MIME_TYPE_PROVISIONING_NFC = "application/com.android.managedprovisioning";
    public static String ACTION_ADD_DEVICE_ADMIN = "android.app.action.ADD_DEVICE_ADMIN";
    @SystemApi
    public static String ACTION_SET_PROFILE_OWNER = "android.app.action.SET_PROFILE_OWNER";
    @SystemApi
    public static String EXTRA_PROFILE_OWNER_NAME = "android.app.extra.PROFILE_OWNER_NAME";
    public static String ACTION_DEVICE_POLICY_MANAGER_STATE_CHANGED = "android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED";
    public static String ACTION_DEVICE_OWNER_CHANGED = "android.app.action.DEVICE_OWNER_CHANGED";
    public static String EXTRA_DEVICE_ADMIN = "android.app.extra.DEVICE_ADMIN";
    public static String EXTRA_ADD_EXPLANATION = "android.app.extra.ADD_EXPLANATION";
    public static String POLICY_DISABLE_CAMERA = "policy_disable_camera";
    public static String POLICY_DISABLE_SCREEN_CAPTURE = "policy_disable_screen_capture";
    public static String POLICY_MANDATORY_BACKUPS = "policy_mandatory_backups";
    public static String POLICY_SUSPEND_PACKAGES = "policy_suspend_packages";
    public static String EXTRA_RESTRICTION = "android.app.extra.RESTRICTION";
    public static String ACTION_SET_NEW_PASSWORD = "android.app.action.SET_NEW_PASSWORD";
    public static String ACTION_SET_NEW_PARENT_PROFILE_PASSWORD = "android.app.action.SET_NEW_PARENT_PROFILE_PASSWORD";
    public static String ACTION_SHOW_DEVICE_MONITORING_DIALOG = "android.app.action.SHOW_DEVICE_MONITORING_DIALOG";
    public static String ACTION_APPLICATION_DELEGATION_SCOPES_CHANGED = "android.app.action.APPLICATION_DELEGATION_SCOPES_CHANGED";
    public static String EXTRA_DELEGATION_SCOPES = "android.app.extra.DELEGATION_SCOPES";
    public static int FLAG_PARENT_CAN_ACCESS_MANAGED = 1;
    public static int FLAG_MANAGED_CAN_ACCESS_PARENT = 2;
    public static String ACTION_SYSTEM_UPDATE_POLICY_CHANGED = "android.app.action.SYSTEM_UPDATE_POLICY_CHANGED";
    public static String ACTION_DATA_SHARING_RESTRICTION_CHANGED = "android.app.action.DATA_SHARING_RESTRICTION_CHANGED";
    public static String ACTION_DATA_SHARING_RESTRICTION_APPLIED = "android.app.action.DATA_SHARING_RESTRICTION_APPLIED";
    public static int PERMISSION_POLICY_PROMPT = 0;
    public static int PERMISSION_POLICY_AUTO_GRANT = 1;
    public static int PERMISSION_POLICY_AUTO_DENY = 2;
    public static int PERMISSION_GRANT_STATE_DEFAULT = 0;
    public static int PERMISSION_GRANT_STATE_GRANTED = 1;
    public static int PERMISSION_GRANT_STATE_DENIED = 2;
    public static String DELEGATION_CERT_INSTALL = "delegation-cert-install";
    public static String DELEGATION_APP_RESTRICTIONS = "delegation-app-restrictions";
    public static String DELEGATION_BLOCK_UNINSTALL = "delegation-block-uninstall";
    public static String DELEGATION_PERMISSION_GRANT = "delegation-permission-grant";
    public static String DELEGATION_PACKAGE_ACCESS = "delegation-package-access";
    public static String DELEGATION_ENABLE_SYSTEM_APP = "delegation-enable-system-app";
    public static String DELEGATION_INSTALL_EXISTING_PACKAGE = "delegation-install-existing-package";
    public static String DELEGATION_KEEP_UNINSTALLED_PACKAGES = "delegation-keep-uninstalled-packages";
    @SystemApi
    public static int STATE_USER_UNMANAGED = 0;
    @SystemApi
    public static int STATE_USER_SETUP_INCOMPLETE = 1;
    @SystemApi
    public static int STATE_USER_SETUP_COMPLETE = 2;
    @SystemApi
    public static int STATE_USER_SETUP_FINALIZED = 3;
    @SystemApi
    public static int STATE_USER_PROFILE_COMPLETE = 4;
    public static int CODE_OK = 0;
    public static int CODE_HAS_DEVICE_OWNER = 1;
    public static int CODE_USER_HAS_PROFILE_OWNER = 2;
    public static int CODE_USER_NOT_RUNNING = 3;
    public static int CODE_USER_SETUP_COMPLETED = 4;
    public static int CODE_NONSYSTEM_USER_EXISTS = 5;
    public static int CODE_ACCOUNTS_NOT_EMPTY = 6;
    public static int CODE_NOT_SYSTEM_USER = 7;
    public static int CODE_HAS_PAIRED = 8;
    public static int CODE_MANAGED_USERS_NOT_SUPPORTED = 9;
    public static int CODE_SYSTEM_USER = 10;
    public static int CODE_CANNOT_ADD_MANAGED_PROFILE = 11;
    public static int CODE_NOT_SYSTEM_USER_SPLIT = 12;
    public static int CODE_DEVICE_ADMIN_NOT_SUPPORTED = 13;
    public static int CODE_SPLIT_SYSTEM_USER_DEVICE_SYSTEM_USER = 14;
    public static int CODE_ADD_MANAGED_PROFILE_DISALLOWED = 15;
    public static int LOCK_TASK_FEATURE_NONE = 0;
    public static int LOCK_TASK_FEATURE_SYSTEM_INFO = 1;
    public static int LOCK_TASK_FEATURE_NOTIFICATIONS = 2;
    public static int LOCK_TASK_FEATURE_HOME = 4;
    public static int LOCK_TASK_FEATURE_OVERVIEW = 8;
    public static int LOCK_TASK_FEATURE_GLOBAL_ACTIONS = 16;
    public static int LOCK_TASK_FEATURE_KEYGUARD = 32;
    public static String ACTION_DEVICE_ADMIN_SERVICE = "android.app.action.DEVICE_ADMIN_SERVICE";
    public static int ID_TYPE_BASE_INFO = 1;
    public static int ID_TYPE_SERIAL = 2;
    public static int ID_TYPE_IMEI = 4;
    public static int ID_TYPE_MEID = 8;
    public static int INSTALLKEY_REQUEST_CREDENTIALS_ACCESS = 1;
    public static int INSTALLKEY_SET_USER_SELECTABLE = 2;
    public static String ACTION_PROFILE_OWNER_CHANGED = "android.app.action.PROFILE_OWNER_CHANGED";
    public static int PASSWORD_QUALITY_UNSPECIFIED = 0;
    public static int PASSWORD_QUALITY_BIOMETRIC_WEAK = 32768;
    public static int PASSWORD_QUALITY_SOMETHING = 65536;
    public static int PASSWORD_QUALITY_NUMERIC = 131072;
    public static int PASSWORD_QUALITY_NUMERIC_COMPLEX = 196608;
    public static int PASSWORD_QUALITY_ALPHABETIC = 262144;
    public static int PASSWORD_QUALITY_ALPHANUMERIC = 327680;
    public static int PASSWORD_QUALITY_COMPLEX = 393216;
    public static int PASSWORD_QUALITY_MANAGED = 524288;
    @SystemApi
    public static String ACCOUNT_FEATURE_DEVICE_OR_PROFILE_OWNER_ALLOWED = "android.account.DEVICE_OR_PROFILE_OWNER_ALLOWED";
    @SystemApi
    public static String ACCOUNT_FEATURE_DEVICE_OR_PROFILE_OWNER_DISALLOWED = "android.account.DEVICE_OR_PROFILE_OWNER_DISALLOWED";
    public static int RESET_PASSWORD_REQUIRE_ENTRY = 1;
    public static int RESET_PASSWORD_DO_NOT_ASK_CREDENTIALS_ON_BOOT = 2;
    public static int FLAG_EVICT_CREDENTIAL_ENCRYPTION_KEY = 1;
    public static int WIPE_EXTERNAL_STORAGE = 1;
    public static int WIPE_RESET_PROTECTION_DATA = 2;
    public static int WIPE_EUICC = 4;
    public static int ENCRYPTION_STATUS_UNSUPPORTED = 0;
    public static int ENCRYPTION_STATUS_INACTIVE = 1;
    public static int ENCRYPTION_STATUS_ACTIVATING = 2;
    public static int ENCRYPTION_STATUS_ACTIVE = 3;
    public static int ENCRYPTION_STATUS_ACTIVE_DEFAULT_KEY = 4;
    public static int ENCRYPTION_STATUS_ACTIVE_PER_USER = 5;
    public static String ACTION_START_ENCRYPTION = "android.app.action.START_ENCRYPTION";
    public static String ACTION_MANAGED_USER_CREATED = "android.app.action.MANAGED_USER_CREATED";
    public static int KEYGUARD_DISABLE_FEATURES_NONE = 0;
    public static int KEYGUARD_DISABLE_WIDGETS_ALL = 1;
    public static int KEYGUARD_DISABLE_SECURE_CAMERA = 2;
    public static int KEYGUARD_DISABLE_SECURE_NOTIFICATIONS = 4;
    public static int KEYGUARD_DISABLE_UNREDACTED_NOTIFICATIONS = 8;
    public static int KEYGUARD_DISABLE_TRUST_AGENTS = 16;
    public static int KEYGUARD_DISABLE_FINGERPRINT = 32;
    public static int KEYGUARD_DISABLE_REMOTE_INPUT = 64;
    public static int KEYGUARD_DISABLE_FACE = 128;
    public static int KEYGUARD_DISABLE_IRIS = 256;
    public static int KEYGUARD_DISABLE_BIOMETRICS = 416;
    public static int KEYGUARD_DISABLE_FEATURES_ALL = Integer.MAX_VALUE;
    public static int PROFILE_KEYGUARD_FEATURES_AFFECT_OWNER = 432;
    public static int SKIP_SETUP_WIZARD = 1;
    public static int MAKE_USER_EPHEMERAL = 2;
    public static int MAKE_USER_DEMO = 4;
    public static int LEAVE_ALL_SYSTEM_APPS_ENABLED = 16;

    private void $$robo$$android_app_admin_DevicePolicyManager$__constructor__(Context context, IDevicePolicyManager service) {
    }

    @VisibleForTesting
    private void $$robo$$android_app_admin_DevicePolicyManager$__constructor__(Context context, IDevicePolicyManager service, boolean parentInstance) {
        this.mContext = context;
        this.mService = service;
        this.mParentInstance = parentInstance;
    }

    @VisibleForTesting
    private final int $$robo$$android_app_admin_DevicePolicyManager$myUserId() {
        return this.mContext.getUserId();
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isAdminActive(ComponentName admin) {
        this.throwIfParentInstance("isAdminActive");
        return this.isAdminActiveAsUser(admin, this.myUserId());
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isAdminActiveAsUser(ComponentName admin, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.isAdminActive(admin, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isRemovingAdmin(ComponentName admin, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.isRemovingAdmin(admin, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final List<ComponentName> $$robo$$android_app_admin_DevicePolicyManager$getActiveAdmins() {
        this.throwIfParentInstance("getActiveAdmins");
        return this.getActiveAdminsAsUser(this.myUserId());
    }

    private final List<ComponentName> $$robo$$android_app_admin_DevicePolicyManager$getActiveAdminsAsUser(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getActiveAdmins(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @SystemApi
    private final boolean $$robo$$android_app_admin_DevicePolicyManager$packageHasActiveAdmins(String packageName) {
        return this.packageHasActiveAdmins(packageName, this.myUserId());
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$packageHasActiveAdmins(String packageName, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.packageHasActiveAdmins(packageName, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$removeActiveAdmin(ComponentName admin) {
        this.throwIfParentInstance("removeActiveAdmin");
        if (this.mService != null) {
            try {
                this.mService.removeActiveAdmin(admin, this.myUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$hasGrantedPolicy(ComponentName admin, int usesPolicy) {
        this.throwIfParentInstance("hasGrantedPolicy");
        if (this.mService != null) {
            try {
                return this.mService.hasGrantedPolicy(admin, usesPolicy, this.myUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isSeparateProfileChallengeAllowed(int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.isSeparateProfileChallengeAllowed(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordQuality(ComponentName admin, int quality) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordQuality(admin, quality, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordQuality(ComponentName admin) {
        return this.getPasswordQuality(admin, this.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordQuality(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordQuality(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumLength(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumLength(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLength(ComponentName admin) {
        return this.getPasswordMinimumLength(admin, this.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLength(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumLength(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumUpperCase(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumUpperCase(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumUpperCase(ComponentName admin) {
        return this.getPasswordMinimumUpperCase(admin, this.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumUpperCase(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumUpperCase(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumLowerCase(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumLowerCase(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLowerCase(ComponentName admin) {
        return this.getPasswordMinimumLowerCase(admin, this.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLowerCase(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumLowerCase(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumLetters(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumLetters(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLetters(ComponentName admin) {
        return this.getPasswordMinimumLetters(admin, this.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLetters(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumLetters(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumNumeric(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumNumeric(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNumeric(ComponentName admin) {
        return this.getPasswordMinimumNumeric(admin, this.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNumeric(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumNumeric(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumSymbols(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumSymbols(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumSymbols(ComponentName admin) {
        return this.getPasswordMinimumSymbols(admin, this.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumSymbols(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumSymbols(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumNonLetter(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumNonLetter(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNonLetter(ComponentName admin) {
        return this.getPasswordMinimumNonLetter(admin, this.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNonLetter(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumNonLetter(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordHistoryLength(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordHistoryLength(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPasswordExpirationTimeout(ComponentName admin, long timeout) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordExpirationTimeout(admin, timeout, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final long $$robo$$android_app_admin_DevicePolicyManager$getPasswordExpirationTimeout(ComponentName admin) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordExpirationTimeout(admin, this.myUserId(), this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0L;
    }

    private final long $$robo$$android_app_admin_DevicePolicyManager$getPasswordExpiration(ComponentName admin) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordExpiration(admin, this.myUserId(), this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0L;
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordHistoryLength(ComponentName admin) {
        return this.getPasswordHistoryLength(admin, this.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordHistoryLength(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordHistoryLength(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPasswordMaximumLength(int quality) {
        return 16;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isActivePasswordSufficient() {
        if (this.mService != null) {
            try {
                return this.mService.isActivePasswordSufficient(this.myUserId(), this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isUsingUnifiedPassword(ComponentName admin) {
        this.throwIfParentInstance("isUsingUnifiedPassword");
        if (this.mService != null) {
            try {
                return this.mService.isUsingUnifiedPassword(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isProfileActivePasswordSufficientForParent(int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.isProfileActivePasswordSufficientForParent(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getCurrentFailedPasswordAttempts() {
        return this.getCurrentFailedPasswordAttempts(this.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getCurrentFailedPasswordAttempts(int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getCurrentFailedPasswordAttempts(userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -1;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getDoNotAskCredentialsOnBoot() {
        if (this.mService != null) {
            try {
                return this.mService.getDoNotAskCredentialsOnBoot();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setMaximumFailedPasswordsForWipe(ComponentName admin, int num) {
        if (this.mService != null) {
            try {
                this.mService.setMaximumFailedPasswordsForWipe(admin, num, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getMaximumFailedPasswordsForWipe(ComponentName admin) {
        return this.getMaximumFailedPasswordsForWipe(admin, this.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getMaximumFailedPasswordsForWipe(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getMaximumFailedPasswordsForWipe(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getProfileWithMinimumFailedPasswordsForWipe(int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getProfileWithMinimumFailedPasswordsForWipe(userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -10000;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$resetPassword(String password, int flags) {
        this.throwIfParentInstance("resetPassword");
        if (this.mService != null) {
            try {
                return this.mService.resetPassword(password, flags);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setResetPasswordToken(ComponentName admin, byte[] token) {
        this.throwIfParentInstance("setResetPasswordToken");
        if (this.mService != null) {
            try {
                return this.mService.setResetPasswordToken(admin, token);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$clearResetPasswordToken(ComponentName admin) {
        this.throwIfParentInstance("clearResetPasswordToken");
        if (this.mService != null) {
            try {
                return this.mService.clearResetPasswordToken(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isResetPasswordTokenActive(ComponentName admin) {
        this.throwIfParentInstance("isResetPasswordTokenActive");
        if (this.mService != null) {
            try {
                return this.mService.isResetPasswordTokenActive(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$resetPasswordWithToken(ComponentName admin, String password, byte[] token, int flags) {
        this.throwIfParentInstance("resetPassword");
        if (this.mService != null) {
            try {
                return this.mService.resetPasswordWithToken(admin, password, token, flags);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setMaximumTimeToLock(ComponentName admin, long timeMs) {
        if (this.mService != null) {
            try {
                this.mService.setMaximumTimeToLock(admin, timeMs, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final long $$robo$$android_app_admin_DevicePolicyManager$getMaximumTimeToLock(ComponentName admin) {
        return this.getMaximumTimeToLock(admin, this.myUserId());
    }

    private final long $$robo$$android_app_admin_DevicePolicyManager$getMaximumTimeToLock(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getMaximumTimeToLock(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0L;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setRequiredStrongAuthTimeout(ComponentName admin, long timeoutMs) {
        if (this.mService != null) {
            try {
                this.mService.setRequiredStrongAuthTimeout(admin, timeoutMs, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final long $$robo$$android_app_admin_DevicePolicyManager$getRequiredStrongAuthTimeout(ComponentName admin) {
        return this.getRequiredStrongAuthTimeout(admin, this.myUserId());
    }

    private final long $$robo$$android_app_admin_DevicePolicyManager$getRequiredStrongAuthTimeout(ComponentName admin, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getRequiredStrongAuthTimeout(admin, userId, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 259200000L;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$lockNow() {
        this.lockNow(0);
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$lockNow(int flags) {
        if (this.mService != null) {
            try {
                this.mService.lockNow(flags, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$wipeData(int flags) {
        this.throwIfParentInstance("wipeData");
        String wipeReasonForUser = this.mContext.getString(17041134);
        this.wipeDataInternal(flags, wipeReasonForUser);
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$wipeData(int flags, CharSequence reason) {
        this.throwIfParentInstance("wipeData");
        Preconditions.checkNotNull(reason, "CharSequence is null");
        this.wipeDataInternal(flags, reason.toString());
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$wipeDataInternal(int flags, String wipeReasonForUser) {
        if (this.mService != null) {
            try {
                this.mService.wipeDataWithReason(flags, wipeReasonForUser);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final ComponentName $$robo$$android_app_admin_DevicePolicyManager$setGlobalProxy(ComponentName admin, Proxy proxySpec, List<String> exclusionList) {
        this.throwIfParentInstance("setGlobalProxy");
        if (proxySpec == null) {
            throw new NullPointerException();
        }
        if (this.mService != null) {
            try {
                String exclSpec;
                String hostSpec;
                if (proxySpec.equals(Proxy.NO_PROXY)) {
                    hostSpec = null;
                    exclSpec = null;
                } else {
                    if (!proxySpec.type().equals((Object)Proxy.Type.HTTP)) {
                        throw new IllegalArgumentException();
                    }
                    InetSocketAddress sa = (InetSocketAddress)proxySpec.address();
                    String hostName = sa.getHostName();
                    int port = sa.getPort();
                    StringBuilder hostBuilder = new StringBuilder();
                    hostSpec = hostBuilder.append(hostName).append(":").append(Integer.toString(port)).toString();
                    if (exclusionList == null) {
                        exclSpec = "";
                    } else {
                        StringBuilder listBuilder = new StringBuilder();
                        boolean firstDomain = true;
                        for (String exclDomain : exclusionList) {
                            if (!firstDomain) {
                                listBuilder = listBuilder.append(",");
                            } else {
                                firstDomain = false;
                            }
                            listBuilder = listBuilder.append(exclDomain.trim());
                        }
                        exclSpec = listBuilder.toString();
                    }
                    if (android.net.Proxy.validate(hostName, Integer.toString(port), exclSpec) != 0) {
                        throw new IllegalArgumentException();
                    }
                }
                return this.mService.setGlobalProxy(admin, hostSpec, exclSpec);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setRecommendedGlobalProxy(ComponentName admin, ProxyInfo proxyInfo) {
        this.throwIfParentInstance("setRecommendedGlobalProxy");
        if (this.mService != null) {
            try {
                this.mService.setRecommendedGlobalProxy(admin, proxyInfo);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final ComponentName $$robo$$android_app_admin_DevicePolicyManager$getGlobalProxyAdmin() {
        if (this.mService != null) {
            try {
                return this.mService.getGlobalProxyAdmin(this.myUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$setStorageEncryption(ComponentName admin, boolean encrypt) {
        this.throwIfParentInstance("setStorageEncryption");
        if (this.mService != null) {
            try {
                return this.mService.setStorageEncryption(admin, encrypt);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getStorageEncryption(ComponentName admin) {
        this.throwIfParentInstance("getStorageEncryption");
        if (this.mService != null) {
            try {
                return this.mService.getStorageEncryption(admin, this.myUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getStorageEncryptionStatus() {
        this.throwIfParentInstance("getStorageEncryptionStatus");
        return this.getStorageEncryptionStatus(this.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getStorageEncryptionStatus(int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getStorageEncryptionStatus(this.mContext.getPackageName(), userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$approveCaCert(String alias, int userHandle, boolean approval) {
        if (this.mService != null) {
            try {
                return this.mService.approveCaCert(alias, userHandle, approval);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isCaCertApproved(String alias, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.isCaCertApproved(alias, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$installCaCert(ComponentName admin, byte[] certBuffer) {
        this.throwIfParentInstance("installCaCert");
        if (this.mService != null) {
            try {
                return this.mService.installCaCert(admin, this.mContext.getPackageName(), certBuffer);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$uninstallCaCert(ComponentName admin, byte[] certBuffer) {
        this.throwIfParentInstance("uninstallCaCert");
        if (this.mService != null) {
            try {
                String alias = DevicePolicyManager.getCaCertAlias(certBuffer);
                this.mService.uninstallCaCerts(admin, this.mContext.getPackageName(), new String[]{alias});
            }
            catch (CertificateException e) {
                Log.w(TAG, "Unable to parse certificate", e);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final List<byte[]> $$robo$$android_app_admin_DevicePolicyManager$getInstalledCaCerts(ComponentName admin) {
        ArrayList<byte[]> certs = new ArrayList<byte[]>();
        this.throwIfParentInstance("getInstalledCaCerts");
        if (this.mService != null) {
            try {
                this.mService.enforceCanManageCaCerts(admin, this.mContext.getPackageName());
                TrustedCertificateStore certStore = new TrustedCertificateStore();
                for (String alias : certStore.userAliases()) {
                    try {
                        certs.add(certStore.getCertificate(alias).getEncoded());
                    }
                    catch (CertificateException ce) {
                        Log.w(TAG, "Could not encode certificate: " + alias, ce);
                    }
                }
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return certs;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$uninstallAllUserCaCerts(ComponentName admin) {
        this.throwIfParentInstance("uninstallAllUserCaCerts");
        if (this.mService != null) {
            try {
                this.mService.uninstallCaCerts(admin, this.mContext.getPackageName(), new TrustedCertificateStore().userAliases().toArray(new String[0]));
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$hasCaCertInstalled(ComponentName admin, byte[] certBuffer) {
        this.throwIfParentInstance("hasCaCertInstalled");
        if (this.mService != null) {
            try {
                this.mService.enforceCanManageCaCerts(admin, this.mContext.getPackageName());
                return DevicePolicyManager.getCaCertAlias(certBuffer) != null;
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
            catch (CertificateException ce) {
                Log.w(TAG, "Could not parse certificate", ce);
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$installKeyPair(ComponentName admin, PrivateKey privKey, Certificate cert, String alias) {
        return this.installKeyPair(admin, privKey, new Certificate[]{cert}, alias, false);
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$installKeyPair(ComponentName admin, PrivateKey privKey, Certificate[] certs, String alias, boolean requestAccess) {
        int flags = 2;
        if (requestAccess) {
            flags |= 1;
        }
        return this.installKeyPair(admin, privKey, certs, alias, flags);
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$installKeyPair(ComponentName admin, PrivateKey privKey, Certificate[] certs, String alias, int flags) {
        this.throwIfParentInstance("installKeyPair");
        boolean requestAccess = (flags & 1) == 1;
        boolean isUserSelectable = (flags & 2) == 2;
        try {
            byte[] pemCert = Credentials.convertToPem(certs[0]);
            byte[] pemChain = null;
            if (certs.length > 1) {
                pemChain = Credentials.convertToPem(Arrays.copyOfRange(certs, 1, certs.length));
            }
            byte[] pkcs8Key = KeyFactory.getInstance(privKey.getAlgorithm()).getKeySpec(privKey, PKCS8EncodedKeySpec.class).getEncoded();
            return this.mService.installKeyPair(admin, this.mContext.getPackageName(), pkcs8Key, pemCert, pemChain, alias, requestAccess, isUserSelectable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            Log.w(TAG, "Failed to obtain private key material", e);
        }
        catch (IOException | CertificateException e) {
            Log.w(TAG, "Could not pem-encode certificate", e);
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$removeKeyPair(ComponentName admin, String alias) {
        this.throwIfParentInstance("removeKeyPair");
        try {
            return this.mService.removeKeyPair(admin, this.mContext.getPackageName(), alias);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final AttestedKeyPair $$robo$$android_app_admin_DevicePolicyManager$generateKeyPair(ComponentName admin, String algorithm, KeyGenParameterSpec keySpec, int idAttestationFlags) {
        this.throwIfParentInstance("generateKeyPair");
        try {
            ParcelableKeyGenParameterSpec parcelableSpec = new ParcelableKeyGenParameterSpec(keySpec);
            KeymasterCertificateChain attestationChain = new KeymasterCertificateChain();
            boolean success = this.mService.generateKeyPair(admin, this.mContext.getPackageName(), algorithm, parcelableSpec, idAttestationFlags, attestationChain);
            if (!success) {
                Log.e(TAG, "Error generating key via DevicePolicyManagerService.");
                return null;
            }
            String alias = keySpec.getKeystoreAlias();
            KeyPair keyPair = KeyChain.getKeyPair(this.mContext, alias);
            Certificate[] outputChain = null;
            try {
                if (AttestationUtils.isChainValid(attestationChain)) {
                    outputChain = AttestationUtils.parseCertificateChain(attestationChain);
                }
            }
            catch (KeyAttestationException e) {
                Log.e(TAG, "Error parsing attestation chain for alias " + alias, e);
                this.mService.removeKeyPair(admin, this.mContext.getPackageName(), alias);
                return null;
            }
            return new AttestedKeyPair(keyPair, outputChain);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (KeyChainException e) {
            Log.w(TAG, "Failed to generate key", e);
        }
        catch (InterruptedException e) {
            Log.w(TAG, "Interrupted while generating key", e);
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isDeviceIdAttestationSupported() {
        PackageManager pm = this.mContext.getPackageManager();
        return pm.hasSystemFeature("android.software.device_id_attestation");
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setKeyPairCertificate(ComponentName admin, String alias, List<Certificate> certs, boolean isUserSelectable) {
        this.throwIfParentInstance("setKeyPairCertificate");
        try {
            byte[] pemCert = Credentials.convertToPem(certs.get(0));
            byte[] pemChain = null;
            if (certs.size() > 1) {
                pemChain = Credentials.convertToPem(certs.subList(1, certs.size()).toArray(new Certificate[0]));
            }
            return this.mService.setKeyPairCertificate(admin, this.mContext.getPackageName(), alias, pemCert, pemChain, isUserSelectable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (IOException | CertificateException e) {
            Log.w(TAG, "Could not pem-encode certificate", e);
            return false;
        }
    }

    private static final String $$robo$$android_app_admin_DevicePolicyManager$getCaCertAlias(byte[] certBuffer) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBuffer));
        return new TrustedCertificateStore().getCertificateAlias(cert);
    }

    @Deprecated
    private final void $$robo$$android_app_admin_DevicePolicyManager$setCertInstallerPackage(ComponentName admin, String installerPackage) throws SecurityException {
        this.throwIfParentInstance("setCertInstallerPackage");
        if (this.mService != null) {
            try {
                this.mService.setCertInstallerPackage(admin, installerPackage);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    private final String $$robo$$android_app_admin_DevicePolicyManager$getCertInstallerPackage(ComponentName admin) throws SecurityException {
        this.throwIfParentInstance("getCertInstallerPackage");
        if (this.mService != null) {
            try {
                return this.mService.getCertInstallerPackage(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setDelegatedScopes(ComponentName admin, String delegatePackage, List<String> scopes) {
        this.throwIfParentInstance("setDelegatedScopes");
        if (this.mService != null) {
            try {
                this.mService.setDelegatedScopes(admin, delegatePackage, scopes);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getDelegatedScopes(ComponentName admin, String delegatedPackage) {
        this.throwIfParentInstance("getDelegatedScopes");
        if (this.mService != null) {
            try {
                return this.mService.getDelegatedScopes(admin, delegatedPackage);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getDelegatePackages(ComponentName admin, String delegationScope) {
        this.throwIfParentInstance("getDelegatePackages");
        if (this.mService != null) {
            try {
                return this.mService.getDelegatePackages(admin, delegationScope);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setAlwaysOnVpnPackage(ComponentName admin, String vpnPackage, boolean lockdownEnabled) throws PackageManager.NameNotFoundException, UnsupportedOperationException {
        this.throwIfParentInstance("setAlwaysOnVpnPackage");
        if (this.mService != null) {
            try {
                if (!this.mService.setAlwaysOnVpnPackage(admin, vpnPackage, lockdownEnabled)) {
                    throw new PackageManager.NameNotFoundException(vpnPackage);
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final String $$robo$$android_app_admin_DevicePolicyManager$getAlwaysOnVpnPackage(ComponentName admin) {
        this.throwIfParentInstance("getAlwaysOnVpnPackage");
        if (this.mService != null) {
            try {
                return this.mService.getAlwaysOnVpnPackage(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setCameraDisabled(ComponentName admin, boolean disabled) {
        this.throwIfParentInstance("setCameraDisabled");
        if (this.mService != null) {
            try {
                this.mService.setCameraDisabled(admin, disabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getCameraDisabled(ComponentName admin) {
        this.throwIfParentInstance("getCameraDisabled");
        return this.getCameraDisabled(admin, this.myUserId());
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getCameraDisabled(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getCameraDisabled(admin, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$requestBugreport(ComponentName admin) {
        this.throwIfParentInstance("requestBugreport");
        if (this.mService != null) {
            try {
                return this.mService.requestBugreport(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getGuestUserDisabled(ComponentName admin) {
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setScreenCaptureDisabled(ComponentName admin, boolean disabled) {
        this.throwIfParentInstance("setScreenCaptureDisabled");
        if (this.mService != null) {
            try {
                this.mService.setScreenCaptureDisabled(admin, disabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getScreenCaptureDisabled(ComponentName admin) {
        this.throwIfParentInstance("getScreenCaptureDisabled");
        return this.getScreenCaptureDisabled(admin, this.myUserId());
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getScreenCaptureDisabled(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getScreenCaptureDisabled(admin, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setAutoTimeRequired(ComponentName admin, boolean required) {
        this.throwIfParentInstance("setAutoTimeRequired");
        if (this.mService != null) {
            try {
                this.mService.setAutoTimeRequired(admin, required);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getAutoTimeRequired() {
        this.throwIfParentInstance("getAutoTimeRequired");
        if (this.mService != null) {
            try {
                return this.mService.getAutoTimeRequired();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setForceEphemeralUsers(ComponentName admin, boolean forceEphemeralUsers) {
        this.throwIfParentInstance("setForceEphemeralUsers");
        if (this.mService != null) {
            try {
                this.mService.setForceEphemeralUsers(admin, forceEphemeralUsers);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getForceEphemeralUsers(ComponentName admin) {
        this.throwIfParentInstance("getForceEphemeralUsers");
        if (this.mService != null) {
            try {
                return this.mService.getForceEphemeralUsers(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setKeyguardDisabledFeatures(ComponentName admin, int which) {
        if (this.mService != null) {
            try {
                this.mService.setKeyguardDisabledFeatures(admin, which, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getKeyguardDisabledFeatures(ComponentName admin) {
        return this.getKeyguardDisabledFeatures(admin, this.myUserId());
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getKeyguardDisabledFeatures(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getKeyguardDisabledFeatures(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setActiveAdmin(ComponentName policyReceiver, boolean refreshing, int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.setActiveAdmin(policyReceiver, refreshing, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setActiveAdmin(ComponentName policyReceiver, boolean refreshing) {
        this.setActiveAdmin(policyReceiver, refreshing, this.myUserId());
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$getRemoveWarning(ComponentName admin, RemoteCallback result) {
        if (this.mService != null) {
            try {
                this.mService.getRemoveWarning(admin, result, this.myUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setActivePasswordState(PasswordMetrics metrics, int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.setActivePasswordState(metrics, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$reportPasswordChanged(int userId) {
        if (this.mService != null) {
            try {
                this.mService.reportPasswordChanged(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$reportFailedPasswordAttempt(int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.reportFailedPasswordAttempt(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$reportSuccessfulPasswordAttempt(int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.reportSuccessfulPasswordAttempt(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$reportFailedFingerprintAttempt(int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.reportFailedFingerprintAttempt(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$reportSuccessfulFingerprintAttempt(int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.reportSuccessfulFingerprintAttempt(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$reportKeyguardDismissed(int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.reportKeyguardDismissed(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$reportKeyguardSecured(int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.reportKeyguardSecured(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setDeviceOwner(ComponentName who) {
        return this.setDeviceOwner(who, null);
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setDeviceOwner(ComponentName who, int userId) {
        return this.setDeviceOwner(who, null, userId);
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setDeviceOwner(ComponentName who, String ownerName) {
        return this.setDeviceOwner(who, ownerName, 0);
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setDeviceOwner(ComponentName who, String ownerName, int userId) throws IllegalArgumentException, IllegalStateException {
        if (this.mService != null) {
            try {
                return this.mService.setDeviceOwner(who, ownerName, userId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isDeviceOwnerApp(String packageName) {
        this.throwIfParentInstance("isDeviceOwnerApp");
        return this.isDeviceOwnerAppOnCallingUser(packageName);
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isDeviceOwnerAppOnCallingUser(String packageName) {
        return this.isDeviceOwnerAppOnAnyUserInner(packageName, true);
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isDeviceOwnerAppOnAnyUser(String packageName) {
        return this.isDeviceOwnerAppOnAnyUserInner(packageName, false);
    }

    private final ComponentName $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerComponentOnCallingUser() {
        return this.getDeviceOwnerComponentInner(true);
    }

    @SystemApi
    private final ComponentName $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerComponentOnAnyUser() {
        return this.getDeviceOwnerComponentInner(false);
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isDeviceOwnerAppOnAnyUserInner(String packageName, boolean callingUserOnly) {
        if (packageName == null) {
            return false;
        }
        ComponentName deviceOwner = this.getDeviceOwnerComponentInner(callingUserOnly);
        if (deviceOwner == null) {
            return false;
        }
        return packageName.equals(deviceOwner.getPackageName());
    }

    private final ComponentName $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerComponentInner(boolean callingUserOnly) {
        if (this.mService != null) {
            try {
                return this.mService.getDeviceOwnerComponent(callingUserOnly);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerUserId() {
        if (this.mService != null) {
            try {
                return this.mService.getDeviceOwnerUserId();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return -10000;
    }

    @Deprecated
    private final void $$robo$$android_app_admin_DevicePolicyManager$clearDeviceOwnerApp(String packageName) {
        this.throwIfParentInstance("clearDeviceOwnerApp");
        if (this.mService != null) {
            try {
                this.mService.clearDeviceOwner(packageName);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    private final String $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwner() {
        this.throwIfParentInstance("getDeviceOwner");
        ComponentName name = this.getDeviceOwnerComponentOnCallingUser();
        return name != null ? name.getPackageName() : null;
    }

    @SystemApi
    @SuppressLint(value={"Doclava125"})
    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isDeviceManaged() {
        try {
            return this.mService.hasDeviceOwner();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final String $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerNameOnAnyUser() {
        this.throwIfParentInstance("getDeviceOwnerNameOnAnyUser");
        if (this.mService != null) {
            try {
                return this.mService.getDeviceOwnerName();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @Deprecated
    @SystemApi
    @SuppressLint(value={"Doclava125"})
    private final String $$robo$$android_app_admin_DevicePolicyManager$getDeviceInitializerApp() {
        return null;
    }

    @Deprecated
    @SystemApi
    @SuppressLint(value={"Doclava125"})
    private final ComponentName $$robo$$android_app_admin_DevicePolicyManager$getDeviceInitializerComponent() {
        return null;
    }

    @Deprecated
    @SystemApi
    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setActiveProfileOwner(ComponentName admin, @Deprecated String ownerName) throws IllegalArgumentException {
        this.throwIfParentInstance("setActiveProfileOwner");
        if (this.mService != null) {
            try {
                int myUserId = this.myUserId();
                this.mService.setActiveAdmin(admin, false, myUserId);
                return this.mService.setProfileOwner(admin, ownerName, myUserId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @Deprecated
    private final void $$robo$$android_app_admin_DevicePolicyManager$clearProfileOwner(ComponentName admin) {
        this.throwIfParentInstance("clearProfileOwner");
        if (this.mService != null) {
            try {
                this.mService.clearProfileOwner(admin);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$hasUserSetupCompleted() {
        if (this.mService != null) {
            try {
                return this.mService.hasUserSetupCompleted();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return true;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setProfileOwner(ComponentName admin, @Deprecated String ownerName, int userHandle) throws IllegalArgumentException {
        if (this.mService != null) {
            try {
                if (ownerName == null) {
                    ownerName = "";
                }
                return this.mService.setProfileOwner(admin, ownerName, userHandle);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setDeviceOwnerLockScreenInfo(ComponentName admin, CharSequence info) {
        this.throwIfParentInstance("setDeviceOwnerLockScreenInfo");
        if (this.mService != null) {
            try {
                this.mService.setDeviceOwnerLockScreenInfo(admin, info);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    private final CharSequence $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerLockScreenInfo() {
        this.throwIfParentInstance("getDeviceOwnerLockScreenInfo");
        if (this.mService != null) {
            try {
                return this.mService.getDeviceOwnerLockScreenInfo();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final String[] $$robo$$android_app_admin_DevicePolicyManager$setPackagesSuspended(ComponentName admin, String[] packageNames, boolean suspended) {
        this.throwIfParentInstance("setPackagesSuspended");
        if (this.mService != null) {
            try {
                return this.mService.setPackagesSuspended(admin, this.mContext.getPackageName(), packageNames, suspended);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return packageNames;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isPackageSuspended(ComponentName admin, String packageName) throws PackageManager.NameNotFoundException {
        this.throwIfParentInstance("isPackageSuspended");
        if (this.mService != null) {
            try {
                return this.mService.isPackageSuspended(admin, this.mContext.getPackageName(), packageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            catch (IllegalArgumentException ex) {
                throw new PackageManager.NameNotFoundException(packageName);
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setProfileEnabled(ComponentName admin) {
        this.throwIfParentInstance("setProfileEnabled");
        if (this.mService != null) {
            try {
                this.mService.setProfileEnabled(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setProfileName(ComponentName admin, String profileName) {
        this.throwIfParentInstance("setProfileName");
        if (this.mService != null) {
            try {
                this.mService.setProfileName(admin, profileName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isProfileOwnerApp(String packageName) {
        this.throwIfParentInstance("isProfileOwnerApp");
        if (this.mService != null) {
            try {
                ComponentName profileOwner = this.mService.getProfileOwner(this.myUserId());
                return profileOwner != null && profileOwner.getPackageName().equals(packageName);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    private final ComponentName $$robo$$android_app_admin_DevicePolicyManager$getProfileOwner() throws IllegalArgumentException {
        this.throwIfParentInstance("getProfileOwner");
        return this.getProfileOwnerAsUser(this.mContext.getUserId());
    }

    private final ComponentName $$robo$$android_app_admin_DevicePolicyManager$getProfileOwnerAsUser(int userId) throws IllegalArgumentException {
        if (this.mService != null) {
            try {
                return this.mService.getProfileOwner(userId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final String $$robo$$android_app_admin_DevicePolicyManager$getProfileOwnerName() throws IllegalArgumentException {
        if (this.mService != null) {
            try {
                return this.mService.getProfileOwnerName(this.mContext.getUserId());
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @SystemApi
    private final String $$robo$$android_app_admin_DevicePolicyManager$getProfileOwnerNameAsUser(int userId) throws IllegalArgumentException {
        this.throwIfParentInstance("getProfileOwnerNameAsUser");
        if (this.mService != null) {
            try {
                return this.mService.getProfileOwnerName(userId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$addPersistentPreferredActivity(ComponentName admin, IntentFilter filter, ComponentName activity) {
        this.throwIfParentInstance("addPersistentPreferredActivity");
        if (this.mService != null) {
            try {
                this.mService.addPersistentPreferredActivity(admin, filter, activity);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$clearPackagePersistentPreferredActivities(ComponentName admin, String packageName) {
        this.throwIfParentInstance("clearPackagePersistentPreferredActivities");
        if (this.mService != null) {
            try {
                this.mService.clearPackagePersistentPreferredActivities(admin, packageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setDefaultSmsApplication(ComponentName admin, String packageName) {
        this.throwIfParentInstance("setDefaultSmsApplication");
        if (this.mService != null) {
            try {
                this.mService.setDefaultSmsApplication(admin, packageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    private final void $$robo$$android_app_admin_DevicePolicyManager$setApplicationRestrictionsManagingPackage(ComponentName admin, String packageName) throws PackageManager.NameNotFoundException {
        this.throwIfParentInstance("setApplicationRestrictionsManagingPackage");
        if (this.mService != null) {
            try {
                if (!this.mService.setApplicationRestrictionsManagingPackage(admin, packageName)) {
                    throw new PackageManager.NameNotFoundException(packageName);
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    private final String $$robo$$android_app_admin_DevicePolicyManager$getApplicationRestrictionsManagingPackage(ComponentName admin) {
        this.throwIfParentInstance("getApplicationRestrictionsManagingPackage");
        if (this.mService != null) {
            try {
                return this.mService.getApplicationRestrictionsManagingPackage(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @Deprecated
    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isCallerApplicationRestrictionsManagingPackage() {
        this.throwIfParentInstance("isCallerApplicationRestrictionsManagingPackage");
        if (this.mService != null) {
            try {
                return this.mService.isCallerApplicationRestrictionsManagingPackage(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setApplicationRestrictions(ComponentName admin, String packageName, Bundle settings) {
        this.throwIfParentInstance("setApplicationRestrictions");
        if (this.mService != null) {
            try {
                this.mService.setApplicationRestrictions(admin, this.mContext.getPackageName(), packageName, settings);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setTrustAgentConfiguration(ComponentName admin, ComponentName target, PersistableBundle configuration) {
        if (this.mService != null) {
            try {
                this.mService.setTrustAgentConfiguration(admin, target, configuration, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final List<PersistableBundle> $$robo$$android_app_admin_DevicePolicyManager$getTrustAgentConfiguration(ComponentName admin, ComponentName agent) {
        return this.getTrustAgentConfiguration(admin, agent, this.myUserId());
    }

    private final List<PersistableBundle> $$robo$$android_app_admin_DevicePolicyManager$getTrustAgentConfiguration(ComponentName admin, ComponentName agent, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getTrustAgentConfiguration(admin, agent, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return new ArrayList<PersistableBundle>();
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setCrossProfileCallerIdDisabled(ComponentName admin, boolean disabled) {
        this.throwIfParentInstance("setCrossProfileCallerIdDisabled");
        if (this.mService != null) {
            try {
                this.mService.setCrossProfileCallerIdDisabled(admin, disabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileCallerIdDisabled(ComponentName admin) {
        this.throwIfParentInstance("getCrossProfileCallerIdDisabled");
        if (this.mService != null) {
            try {
                return this.mService.getCrossProfileCallerIdDisabled(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileCallerIdDisabled(UserHandle userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getCrossProfileCallerIdDisabledForUser(userHandle.getIdentifier());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setCrossProfileContactsSearchDisabled(ComponentName admin, boolean disabled) {
        this.throwIfParentInstance("setCrossProfileContactsSearchDisabled");
        if (this.mService != null) {
            try {
                this.mService.setCrossProfileContactsSearchDisabled(admin, disabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileContactsSearchDisabled(ComponentName admin) {
        this.throwIfParentInstance("getCrossProfileContactsSearchDisabled");
        if (this.mService != null) {
            try {
                return this.mService.getCrossProfileContactsSearchDisabled(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileContactsSearchDisabled(UserHandle userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getCrossProfileContactsSearchDisabledForUser(userHandle.getIdentifier());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$startManagedQuickContact(String actualLookupKey, long actualContactId, boolean isContactIdIgnored, long directoryId, Intent originalIntent) {
        if (this.mService != null) {
            try {
                this.mService.startManagedQuickContact(actualLookupKey, actualContactId, isContactIdIgnored, directoryId, originalIntent);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$startManagedQuickContact(String actualLookupKey, long actualContactId, Intent originalIntent) {
        this.startManagedQuickContact(actualLookupKey, actualContactId, false, 0L, originalIntent);
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setBluetoothContactSharingDisabled(ComponentName admin, boolean disabled) {
        this.throwIfParentInstance("setBluetoothContactSharingDisabled");
        if (this.mService != null) {
            try {
                this.mService.setBluetoothContactSharingDisabled(admin, disabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getBluetoothContactSharingDisabled(ComponentName admin) {
        this.throwIfParentInstance("getBluetoothContactSharingDisabled");
        if (this.mService != null) {
            try {
                return this.mService.getBluetoothContactSharingDisabled(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$getBluetoothContactSharingDisabled(UserHandle userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getBluetoothContactSharingDisabledForUser(userHandle.getIdentifier());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$addCrossProfileIntentFilter(ComponentName admin, IntentFilter filter, int flags) {
        this.throwIfParentInstance("addCrossProfileIntentFilter");
        if (this.mService != null) {
            try {
                this.mService.addCrossProfileIntentFilter(admin, filter, flags);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$clearCrossProfileIntentFilters(ComponentName admin) {
        this.throwIfParentInstance("clearCrossProfileIntentFilters");
        if (this.mService != null) {
            try {
                this.mService.clearCrossProfileIntentFilters(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setPermittedAccessibilityServices(ComponentName admin, List<String> packageNames) {
        this.throwIfParentInstance("setPermittedAccessibilityServices");
        if (this.mService != null) {
            try {
                return this.mService.setPermittedAccessibilityServices(admin, packageNames);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getPermittedAccessibilityServices(ComponentName admin) {
        this.throwIfParentInstance("getPermittedAccessibilityServices");
        if (this.mService != null) {
            try {
                return this.mService.getPermittedAccessibilityServices(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isAccessibilityServicePermittedByAdmin(ComponentName admin, String packageName, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.isAccessibilityServicePermittedByAdmin(admin, packageName, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getPermittedAccessibilityServices(int userId) {
        this.throwIfParentInstance("getPermittedAccessibilityServices");
        if (this.mService != null) {
            try {
                return this.mService.getPermittedAccessibilityServicesForUser(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setPermittedInputMethods(ComponentName admin, List<String> packageNames) {
        this.throwIfParentInstance("setPermittedInputMethods");
        if (this.mService != null) {
            try {
                return this.mService.setPermittedInputMethods(admin, packageNames);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getPermittedInputMethods(ComponentName admin) {
        this.throwIfParentInstance("getPermittedInputMethods");
        if (this.mService != null) {
            try {
                return this.mService.getPermittedInputMethods(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isInputMethodPermittedByAdmin(ComponentName admin, String packageName, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.isInputMethodPermittedByAdmin(admin, packageName, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getPermittedInputMethodsForCurrentUser() {
        this.throwIfParentInstance("getPermittedInputMethodsForCurrentUser");
        if (this.mService != null) {
            try {
                return this.mService.getPermittedInputMethodsForCurrentUser();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setPermittedCrossProfileNotificationListeners(ComponentName admin, List<String> packageList) {
        this.throwIfParentInstance("setPermittedCrossProfileNotificationListeners");
        if (this.mService != null) {
            try {
                return this.mService.setPermittedCrossProfileNotificationListeners(admin, packageList);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getPermittedCrossProfileNotificationListeners(ComponentName admin) {
        this.throwIfParentInstance("getPermittedCrossProfileNotificationListeners");
        if (this.mService != null) {
            try {
                return this.mService.getPermittedCrossProfileNotificationListeners(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isNotificationListenerServicePermitted(String packageName, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.isNotificationListenerServicePermitted(packageName, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getKeepUninstalledPackages(ComponentName admin) {
        this.throwIfParentInstance("getKeepUninstalledPackages");
        if (this.mService != null) {
            try {
                return this.mService.getKeepUninstalledPackages(admin, this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setKeepUninstalledPackages(ComponentName admin, List<String> packageNames) {
        this.throwIfParentInstance("setKeepUninstalledPackages");
        if (this.mService != null) {
            try {
                this.mService.setKeepUninstalledPackages(admin, this.mContext.getPackageName(), packageNames);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    private final UserHandle $$robo$$android_app_admin_DevicePolicyManager$createUser(ComponentName admin, String name) {
        return null;
    }

    @Deprecated
    private final UserHandle $$robo$$android_app_admin_DevicePolicyManager$createAndInitializeUser(ComponentName admin, String name, String ownerName, ComponentName profileOwnerComponent, Bundle adminExtras) {
        return null;
    }

    private final UserHandle $$robo$$android_app_admin_DevicePolicyManager$createAndManageUser(ComponentName admin, String name, ComponentName profileOwner, PersistableBundle adminExtras, int flags) {
        this.throwIfParentInstance("createAndManageUser");
        try {
            return this.mService.createAndManageUser(admin, name, profileOwner, adminExtras, flags);
        }
        catch (ServiceSpecificException e) {
            throw new UserManager.UserOperationException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$removeUser(ComponentName admin, UserHandle userHandle) {
        this.throwIfParentInstance("removeUser");
        try {
            return this.mService.removeUser(admin, userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$switchUser(ComponentName admin, UserHandle userHandle) {
        this.throwIfParentInstance("switchUser");
        try {
            return this.mService.switchUser(admin, userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$startUserInBackground(ComponentName admin, UserHandle userHandle) {
        this.throwIfParentInstance("startUserInBackground");
        try {
            return this.mService.startUserInBackground(admin, userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$stopUser(ComponentName admin, UserHandle userHandle) {
        this.throwIfParentInstance("stopUser");
        try {
            return this.mService.stopUser(admin, userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$logoutUser(ComponentName admin) {
        this.throwIfParentInstance("logoutUser");
        try {
            return this.mService.logoutUser(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<UserHandle> $$robo$$android_app_admin_DevicePolicyManager$getSecondaryUsers(ComponentName admin) {
        this.throwIfParentInstance("getSecondaryUsers");
        try {
            return this.mService.getSecondaryUsers(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isEphemeralUser(ComponentName admin) {
        this.throwIfParentInstance("isEphemeralUser");
        try {
            return this.mService.isEphemeralUser(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final Bundle $$robo$$android_app_admin_DevicePolicyManager$getApplicationRestrictions(ComponentName admin, String packageName) {
        this.throwIfParentInstance("getApplicationRestrictions");
        if (this.mService != null) {
            try {
                return this.mService.getApplicationRestrictions(admin, this.mContext.getPackageName(), packageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$addUserRestriction(ComponentName admin, String key) {
        this.throwIfParentInstance("addUserRestriction");
        if (this.mService != null) {
            try {
                this.mService.setUserRestriction(admin, key, true);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$clearUserRestriction(ComponentName admin, String key) {
        this.throwIfParentInstance("clearUserRestriction");
        if (this.mService != null) {
            try {
                this.mService.setUserRestriction(admin, key, false);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final Bundle $$robo$$android_app_admin_DevicePolicyManager$getUserRestrictions(ComponentName admin) {
        this.throwIfParentInstance("getUserRestrictions");
        Bundle ret = null;
        if (this.mService != null) {
            try {
                ret = this.mService.getUserRestrictions(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return ret == null ? new Bundle() : ret;
    }

    private final Intent $$robo$$android_app_admin_DevicePolicyManager$createAdminSupportIntent(String restriction) {
        this.throwIfParentInstance("createAdminSupportIntent");
        if (this.mService != null) {
            try {
                return this.mService.createAdminSupportIntent(restriction);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setApplicationHidden(ComponentName admin, String packageName, boolean hidden) {
        this.throwIfParentInstance("setApplicationHidden");
        if (this.mService != null) {
            try {
                return this.mService.setApplicationHidden(admin, this.mContext.getPackageName(), packageName, hidden);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isApplicationHidden(ComponentName admin, String packageName) {
        this.throwIfParentInstance("isApplicationHidden");
        if (this.mService != null) {
            try {
                return this.mService.isApplicationHidden(admin, this.mContext.getPackageName(), packageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$enableSystemApp(ComponentName admin, String packageName) {
        this.throwIfParentInstance("enableSystemApp");
        if (this.mService != null) {
            try {
                this.mService.enableSystemApp(admin, this.mContext.getPackageName(), packageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$enableSystemApp(ComponentName admin, Intent intent) {
        this.throwIfParentInstance("enableSystemApp");
        if (this.mService != null) {
            try {
                return this.mService.enableSystemAppWithIntent(admin, this.mContext.getPackageName(), intent);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$installExistingPackage(ComponentName admin, String packageName) {
        this.throwIfParentInstance("installExistingPackage");
        if (this.mService != null) {
            try {
                return this.mService.installExistingPackage(admin, this.mContext.getPackageName(), packageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setAccountManagementDisabled(ComponentName admin, String accountType, boolean disabled) {
        this.throwIfParentInstance("setAccountManagementDisabled");
        if (this.mService != null) {
            try {
                this.mService.setAccountManagementDisabled(admin, accountType, disabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final String[] $$robo$$android_app_admin_DevicePolicyManager$getAccountTypesWithManagementDisabled() {
        this.throwIfParentInstance("getAccountTypesWithManagementDisabled");
        return this.getAccountTypesWithManagementDisabledAsUser(this.myUserId());
    }

    private final String[] $$robo$$android_app_admin_DevicePolicyManager$getAccountTypesWithManagementDisabledAsUser(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getAccountTypesWithManagementDisabledAsUser(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setLockTaskPackages(ComponentName admin, String[] packages) throws SecurityException {
        this.throwIfParentInstance("setLockTaskPackages");
        if (this.mService != null) {
            try {
                this.mService.setLockTaskPackages(admin, packages);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final String[] $$robo$$android_app_admin_DevicePolicyManager$getLockTaskPackages(ComponentName admin) {
        this.throwIfParentInstance("getLockTaskPackages");
        if (this.mService != null) {
            try {
                return this.mService.getLockTaskPackages(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return new String[0];
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isLockTaskPermitted(String pkg) {
        this.throwIfParentInstance("isLockTaskPermitted");
        if (this.mService != null) {
            try {
                return this.mService.isLockTaskPermitted(pkg);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setLockTaskFeatures(ComponentName admin, int flags) {
        this.throwIfParentInstance("setLockTaskFeatures");
        if (this.mService != null) {
            try {
                this.mService.setLockTaskFeatures(admin, flags);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getLockTaskFeatures(ComponentName admin) {
        this.throwIfParentInstance("getLockTaskFeatures");
        if (this.mService != null) {
            try {
                return this.mService.getLockTaskFeatures(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setGlobalSetting(ComponentName admin, String setting, String value) {
        this.throwIfParentInstance("setGlobalSetting");
        if (this.mService != null) {
            try {
                this.mService.setGlobalSetting(admin, setting, value);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setSystemSetting(ComponentName admin, String setting, String value) {
        this.throwIfParentInstance("setSystemSetting");
        if (this.mService != null) {
            try {
                this.mService.setSystemSetting(admin, setting, value);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setTime(ComponentName admin, long millis) {
        this.throwIfParentInstance("setTime");
        if (this.mService != null) {
            try {
                return this.mService.setTime(admin, millis);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setTimeZone(ComponentName admin, String timeZone) {
        this.throwIfParentInstance("setTimeZone");
        if (this.mService != null) {
            try {
                return this.mService.setTimeZone(admin, timeZone);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setSecureSetting(ComponentName admin, String setting, String value) {
        this.throwIfParentInstance("setSecureSetting");
        if (this.mService != null) {
            try {
                this.mService.setSecureSetting(admin, setting, value);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setRestrictionsProvider(ComponentName admin, ComponentName provider) {
        this.throwIfParentInstance("setRestrictionsProvider");
        if (this.mService != null) {
            try {
                this.mService.setRestrictionsProvider(admin, provider);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setMasterVolumeMuted(ComponentName admin, boolean on) {
        this.throwIfParentInstance("setMasterVolumeMuted");
        if (this.mService != null) {
            try {
                this.mService.setMasterVolumeMuted(admin, on);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isMasterVolumeMuted(ComponentName admin) {
        this.throwIfParentInstance("isMasterVolumeMuted");
        if (this.mService != null) {
            try {
                return this.mService.isMasterVolumeMuted(admin);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setUninstallBlocked(ComponentName admin, String packageName, boolean uninstallBlocked) {
        this.throwIfParentInstance("setUninstallBlocked");
        if (this.mService != null) {
            try {
                this.mService.setUninstallBlocked(admin, this.mContext.getPackageName(), packageName, uninstallBlocked);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isUninstallBlocked(ComponentName admin, String packageName) {
        this.throwIfParentInstance("isUninstallBlocked");
        if (this.mService != null) {
            try {
                return this.mService.isUninstallBlocked(admin, packageName);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$addCrossProfileWidgetProvider(ComponentName admin, String packageName) {
        this.throwIfParentInstance("addCrossProfileWidgetProvider");
        if (this.mService != null) {
            try {
                return this.mService.addCrossProfileWidgetProvider(admin, packageName);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$removeCrossProfileWidgetProvider(ComponentName admin, String packageName) {
        this.throwIfParentInstance("removeCrossProfileWidgetProvider");
        if (this.mService != null) {
            try {
                return this.mService.removeCrossProfileWidgetProvider(admin, packageName);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileWidgetProviders(ComponentName admin) {
        this.throwIfParentInstance("getCrossProfileWidgetProviders");
        if (this.mService != null) {
            try {
                List<String> providers = this.mService.getCrossProfileWidgetProviders(admin);
                if (providers != null) {
                    return providers;
                }
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return Collections.emptyList();
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setUserIcon(ComponentName admin, Bitmap icon) {
        this.throwIfParentInstance("setUserIcon");
        try {
            this.mService.setUserIcon(admin, icon);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setSystemUpdatePolicy(ComponentName admin, SystemUpdatePolicy policy) {
        this.throwIfParentInstance("setSystemUpdatePolicy");
        if (this.mService != null) {
            try {
                this.mService.setSystemUpdatePolicy(admin, policy);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    private final SystemUpdatePolicy $$robo$$android_app_admin_DevicePolicyManager$getSystemUpdatePolicy() {
        this.throwIfParentInstance("getSystemUpdatePolicy");
        if (this.mService != null) {
            try {
                return this.mService.getSystemUpdatePolicy();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$clearSystemUpdatePolicyFreezePeriodRecord() {
        this.throwIfParentInstance("clearSystemUpdatePolicyFreezePeriodRecord");
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.clearSystemUpdatePolicyFreezePeriodRecord();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setKeyguardDisabled(ComponentName admin, boolean disabled) {
        this.throwIfParentInstance("setKeyguardDisabled");
        try {
            return this.mService.setKeyguardDisabled(admin, disabled);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setStatusBarDisabled(ComponentName admin, boolean disabled) {
        this.throwIfParentInstance("setStatusBarDisabled");
        try {
            return this.mService.setStatusBarDisabled(admin, disabled);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final void $$robo$$android_app_admin_DevicePolicyManager$notifyPendingSystemUpdate(long updateReceivedTime) {
        this.throwIfParentInstance("notifyPendingSystemUpdate");
        if (this.mService != null) {
            try {
                this.mService.notifyPendingSystemUpdate(SystemUpdateInfo.of(updateReceivedTime));
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    private final void $$robo$$android_app_admin_DevicePolicyManager$notifyPendingSystemUpdate(long updateReceivedTime, boolean isSecurityPatch) {
        this.throwIfParentInstance("notifyPendingSystemUpdate");
        if (this.mService != null) {
            try {
                this.mService.notifyPendingSystemUpdate(SystemUpdateInfo.of(updateReceivedTime, isSecurityPatch));
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    private final SystemUpdateInfo $$robo$$android_app_admin_DevicePolicyManager$getPendingSystemUpdate(ComponentName admin) {
        this.throwIfParentInstance("getPendingSystemUpdate");
        try {
            return this.mService.getPendingSystemUpdate(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setPermissionPolicy(ComponentName admin, int policy) {
        this.throwIfParentInstance("setPermissionPolicy");
        try {
            this.mService.setPermissionPolicy(admin, this.mContext.getPackageName(), policy);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPermissionPolicy(ComponentName admin) {
        this.throwIfParentInstance("getPermissionPolicy");
        try {
            return this.mService.getPermissionPolicy(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setPermissionGrantState(ComponentName admin, String packageName, String permission2, int grantState) {
        this.throwIfParentInstance("setPermissionGrantState");
        try {
            return this.mService.setPermissionGrantState(admin, this.mContext.getPackageName(), packageName, permission2, grantState);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getPermissionGrantState(ComponentName admin, String packageName, String permission2) {
        this.throwIfParentInstance("getPermissionGrantState");
        try {
            return this.mService.getPermissionGrantState(admin, this.mContext.getPackageName(), packageName, permission2);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isProvisioningAllowed(String action) {
        this.throwIfParentInstance("isProvisioningAllowed");
        try {
            return this.mService.isProvisioningAllowed(action, this.mContext.getPackageName());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$checkProvisioningPreCondition(String action, String packageName) {
        try {
            return this.mService.checkProvisioningPreCondition(action, packageName);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isManagedProfile(ComponentName admin) {
        this.throwIfParentInstance("isManagedProfile");
        try {
            return this.mService.isManagedProfile(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isSystemOnlyUser(ComponentName admin) {
        try {
            return this.mService.isSystemOnlyUser(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_app_admin_DevicePolicyManager$getWifiMacAddress(ComponentName admin) {
        this.throwIfParentInstance("getWifiMacAddress");
        try {
            return this.mService.getWifiMacAddress(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$reboot(ComponentName admin) {
        this.throwIfParentInstance("reboot");
        try {
            this.mService.reboot(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setShortSupportMessage(ComponentName admin, CharSequence message) {
        this.throwIfParentInstance("setShortSupportMessage");
        if (this.mService != null) {
            try {
                this.mService.setShortSupportMessage(admin, message);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final CharSequence $$robo$$android_app_admin_DevicePolicyManager$getShortSupportMessage(ComponentName admin) {
        this.throwIfParentInstance("getShortSupportMessage");
        if (this.mService != null) {
            try {
                return this.mService.getShortSupportMessage(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setLongSupportMessage(ComponentName admin, CharSequence message) {
        this.throwIfParentInstance("setLongSupportMessage");
        if (this.mService != null) {
            try {
                this.mService.setLongSupportMessage(admin, message);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final CharSequence $$robo$$android_app_admin_DevicePolicyManager$getLongSupportMessage(ComponentName admin) {
        this.throwIfParentInstance("getLongSupportMessage");
        if (this.mService != null) {
            try {
                return this.mService.getLongSupportMessage(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final CharSequence $$robo$$android_app_admin_DevicePolicyManager$getShortSupportMessageForUser(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getShortSupportMessageForUser(admin, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final CharSequence $$robo$$android_app_admin_DevicePolicyManager$getLongSupportMessageForUser(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getLongSupportMessageForUser(admin, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final DevicePolicyManager $$robo$$android_app_admin_DevicePolicyManager$getParentProfileInstance(ComponentName admin) {
        this.throwIfParentInstance("getParentProfileInstance");
        try {
            if (!this.mService.isManagedProfile(admin)) {
                throw new SecurityException("The current user does not have a parent profile.");
            }
            return new DevicePolicyManager(this.mContext, this.mService, true);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setSecurityLoggingEnabled(ComponentName admin, boolean enabled) {
        this.throwIfParentInstance("setSecurityLoggingEnabled");
        try {
            this.mService.setSecurityLoggingEnabled(admin, enabled);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isSecurityLoggingEnabled(ComponentName admin) {
        this.throwIfParentInstance("isSecurityLoggingEnabled");
        try {
            return this.mService.isSecurityLoggingEnabled(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<SecurityLog.SecurityEvent> $$robo$$android_app_admin_DevicePolicyManager$retrieveSecurityLogs(ComponentName admin) {
        this.throwIfParentInstance("retrieveSecurityLogs");
        try {
            ParceledListSlice list = this.mService.retrieveSecurityLogs(admin);
            if (list != null) {
                return list.getList();
            }
            return null;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final long $$robo$$android_app_admin_DevicePolicyManager$forceSecurityLogs() {
        if (this.mService == null) {
            return 0L;
        }
        try {
            return this.mService.forceSecurityLogs();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final DevicePolicyManager $$robo$$android_app_admin_DevicePolicyManager$getParentProfileInstance(UserInfo uInfo) {
        this.mContext.checkSelfPermission("android.permission.MANAGE_PROFILE_AND_DEVICE_OWNERS");
        if (!uInfo.isManagedProfile()) {
            throw new SecurityException("The user " + uInfo.id + " does not have a parent profile.");
        }
        return new DevicePolicyManager(this.mContext, this.mService, true);
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$setMeteredDataDisabledPackages(ComponentName admin, List<String> packageNames) {
        this.throwIfParentInstance("setMeteredDataDisabled");
        if (this.mService != null) {
            try {
                return this.mService.setMeteredDataDisabledPackages(admin, packageNames);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return packageNames;
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getMeteredDataDisabledPackages(ComponentName admin) {
        this.throwIfParentInstance("getMeteredDataDisabled");
        if (this.mService != null) {
            try {
                return this.mService.getMeteredDataDisabledPackages(admin);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return new ArrayList<String>();
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isMeteredDataDisabledPackageForUser(ComponentName admin, String packageName, int userId) {
        this.throwIfParentInstance("getMeteredDataDisabledForUser");
        if (this.mService != null) {
            try {
                return this.mService.isMeteredDataDisabledPackageForUser(admin, packageName, userId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final List<SecurityLog.SecurityEvent> $$robo$$android_app_admin_DevicePolicyManager$retrievePreRebootSecurityLogs(ComponentName admin) {
        this.throwIfParentInstance("retrievePreRebootSecurityLogs");
        try {
            ParceledListSlice list = this.mService.retrievePreRebootSecurityLogs(admin);
            if (list != null) {
                return list.getList();
            }
            return null;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setOrganizationColor(ComponentName admin, int color2) {
        this.throwIfParentInstance("setOrganizationColor");
        try {
            this.mService.setOrganizationColor(admin, color2 |= 0xFF000000);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setOrganizationColorForUser(int color2, int userId) {
        try {
            this.mService.setOrganizationColorForUser(color2 |= 0xFF000000, userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getOrganizationColor(ComponentName admin) {
        this.throwIfParentInstance("getOrganizationColor");
        try {
            return this.mService.getOrganizationColor(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$getOrganizationColorForUser(int userHandle) {
        try {
            return this.mService.getOrganizationColorForUser(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setOrganizationName(ComponentName admin, CharSequence title) {
        this.throwIfParentInstance("setOrganizationName");
        try {
            this.mService.setOrganizationName(admin, title);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final CharSequence $$robo$$android_app_admin_DevicePolicyManager$getOrganizationName(ComponentName admin) {
        this.throwIfParentInstance("getOrganizationName");
        try {
            return this.mService.getOrganizationName(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @SuppressLint(value={"Doclava125"})
    private final CharSequence $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerOrganizationName() {
        try {
            return this.mService.getDeviceOwnerOrganizationName();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final CharSequence $$robo$$android_app_admin_DevicePolicyManager$getOrganizationNameForUser(int userHandle) {
        try {
            return this.mService.getOrganizationNameForUser(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final int $$robo$$android_app_admin_DevicePolicyManager$getUserProvisioningState() {
        this.throwIfParentInstance("getUserProvisioningState");
        if (this.mService != null) {
            try {
                return this.mService.getUserProvisioningState();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setUserProvisioningState(int state, int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.setUserProvisioningState(state, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setAffiliationIds(ComponentName admin, Set<String> ids) {
        this.throwIfParentInstance("setAffiliationIds");
        if (ids == null) {
            throw new IllegalArgumentException("ids must not be null");
        }
        try {
            this.mService.setAffiliationIds(admin, new ArrayList<String>(ids));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Set<String> $$robo$$android_app_admin_DevicePolicyManager$getAffiliationIds(ComponentName admin) {
        this.throwIfParentInstance("getAffiliationIds");
        try {
            return new ArraySet<String>(this.mService.getAffiliationIds(admin));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isAffiliatedUser() {
        this.throwIfParentInstance("isAffiliatedUser");
        try {
            return this.mService.isAffiliatedUser();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isUninstallInQueue(String packageName) {
        try {
            return this.mService.isUninstallInQueue(packageName);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$uninstallPackageWithActiveAdmins(String packageName) {
        try {
            this.mService.uninstallPackageWithActiveAdmins(packageName);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$forceRemoveActiveAdmin(ComponentName adminReceiver, int userHandle) {
        try {
            this.mService.forceRemoveActiveAdmin(adminReceiver, userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isDeviceProvisioned() {
        try {
            return this.mService.isDeviceProvisioned();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final void $$robo$$android_app_admin_DevicePolicyManager$setDeviceProvisioningConfigApplied() {
        try {
            this.mService.setDeviceProvisioningConfigApplied();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isDeviceProvisioningConfigApplied() {
        try {
            return this.mService.isDeviceProvisioningConfigApplied();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$forceUpdateUserSetupComplete() {
        try {
            this.mService.forceUpdateUserSetupComplete();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$throwIfParentInstance(String functionName) {
        if (this.mParentInstance) {
            throw new SecurityException(functionName + " cannot be called on the parent instance");
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setBackupServiceEnabled(ComponentName admin, boolean enabled) {
        this.throwIfParentInstance("setBackupServiceEnabled");
        try {
            this.mService.setBackupServiceEnabled(admin, enabled);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isBackupServiceEnabled(ComponentName admin) {
        this.throwIfParentInstance("isBackupServiceEnabled");
        try {
            return this.mService.isBackupServiceEnabled(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$setMandatoryBackupTransport(ComponentName admin, ComponentName backupTransportComponent) {
        this.throwIfParentInstance("setMandatoryBackupTransport");
        try {
            return this.mService.setMandatoryBackupTransport(admin, backupTransportComponent);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final ComponentName $$robo$$android_app_admin_DevicePolicyManager$getMandatoryBackupTransport() {
        this.throwIfParentInstance("getMandatoryBackupTransport");
        try {
            return this.mService.getMandatoryBackupTransport();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setNetworkLoggingEnabled(ComponentName admin, boolean enabled) {
        this.throwIfParentInstance("setNetworkLoggingEnabled");
        try {
            this.mService.setNetworkLoggingEnabled(admin, enabled);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isNetworkLoggingEnabled(ComponentName admin) {
        this.throwIfParentInstance("isNetworkLoggingEnabled");
        try {
            return this.mService.isNetworkLoggingEnabled(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<NetworkEvent> $$robo$$android_app_admin_DevicePolicyManager$retrieveNetworkLogs(ComponentName admin, long batchToken) {
        this.throwIfParentInstance("retrieveNetworkLogs");
        try {
            return this.mService.retrieveNetworkLogs(admin, batchToken);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$bindDeviceAdminServiceAsUser(ComponentName admin, Intent serviceIntent, ServiceConnection conn, int flags, UserHandle targetUser) {
        this.throwIfParentInstance("bindDeviceAdminServiceAsUser");
        try {
            IServiceConnection sd = this.mContext.getServiceDispatcher(conn, this.mContext.getMainThreadHandler(), flags);
            serviceIntent.prepareToLeaveProcess(this.mContext);
            return this.mService.bindDeviceAdminServiceAsUser(admin, this.mContext.getIApplicationThread(), this.mContext.getActivityToken(), serviceIntent, sd, flags, targetUser.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<UserHandle> $$robo$$android_app_admin_DevicePolicyManager$getBindDeviceAdminTargetUsers(ComponentName admin) {
        this.throwIfParentInstance("getBindDeviceAdminTargetUsers");
        try {
            return this.mService.getBindDeviceAdminTargetUsers(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final long $$robo$$android_app_admin_DevicePolicyManager$getLastSecurityLogRetrievalTime() {
        try {
            return this.mService.getLastSecurityLogRetrievalTime();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final long $$robo$$android_app_admin_DevicePolicyManager$getLastBugReportRequestTime() {
        try {
            return this.mService.getLastBugReportRequestTime();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final long $$robo$$android_app_admin_DevicePolicyManager$getLastNetworkLogRetrievalTime() {
        try {
            return this.mService.getLastNetworkLogRetrievalTime();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isCurrentInputMethodSetByOwner() {
        try {
            return this.mService.isCurrentInputMethodSetByOwner();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<String> $$robo$$android_app_admin_DevicePolicyManager$getOwnerInstalledCaCerts(UserHandle user) {
        try {
            return this.mService.getOwnerInstalledCaCerts(user).getList();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$clearApplicationUserData(ComponentName admin, String packageName, Executor executor, OnClearApplicationUserDataListener listener) {
        this.throwIfParentInstance("clearAppData");
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(listener);
        try {
            this.mService.clearApplicationUserData(admin, packageName, (IPackageDataObserver)new ShadowedObject(this, executor, listener){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Executor val$executor;
                /* synthetic */ OnClearApplicationUserDataListener val$listener;
                /* synthetic */ DevicePolicyManager this$0;

                private void $$robo$$android_app_admin_DevicePolicyManager_1$__constructor__(DevicePolicyManager this$0, Executor executor, OnClearApplicationUserDataListener onClearApplicationUserDataListener) {
                }

                private final void $$robo$$android_app_admin_DevicePolicyManager_1$onRemoveCompleted(String pkg, boolean succeeded) {
                    this.val$executor.execute(() -> this.val$listener.onApplicationUserDataCleared(pkg, succeeded));
                }

                private void __constructor__(DevicePolicyManager devicePolicyManager, Executor executor, OnClearApplicationUserDataListener onClearApplicationUserDataListener) {
                    this.$$robo$$android_app_admin_DevicePolicyManager_1$__constructor__(devicePolicyManager, executor, onClearApplicationUserDataListener);
                }
                {
                    this.this$0 = devicePolicyManager;
                    this.val$executor = executor;
                    this.val$listener = onClearApplicationUserDataListener;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_DevicePolicyManager_1$__constructor__(android.app.admin.DevicePolicyManager java.util.concurrent.Executor android.app.admin.DevicePolicyManager$OnClearApplicationUserDataListener ), 0, this, devicePolicyManager, executor, onClearApplicationUserDataListener);
                }

                @Override
                public void onRemoveCompleted(String string2, boolean bl) {
                    InvokeDynamicSupport.bootstrap("onRemoveCompleted", $$robo$$android_app_admin_DevicePolicyManager_1$onRemoveCompleted(java.lang.String boolean ), 0, this, string2, bl);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setLogoutEnabled(ComponentName admin, boolean enabled) {
        this.throwIfParentInstance("setLogoutEnabled");
        try {
            this.mService.setLogoutEnabled(admin, enabled);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isLogoutEnabled() {
        this.throwIfParentInstance("isLogoutEnabled");
        try {
            return this.mService.isLogoutEnabled();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final Set<String> $$robo$$android_app_admin_DevicePolicyManager$getDisallowedSystemApps(ComponentName admin, int userId, String provisioningAction) {
        try {
            return new ArraySet<String>(this.mService.getDisallowedSystemApps(admin, userId, provisioningAction));
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$transferOwnership(ComponentName admin, ComponentName target, PersistableBundle bundle) {
        this.throwIfParentInstance("transferOwnership");
        try {
            this.mService.transferOwnership(admin, target, bundle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setStartUserSessionMessage(ComponentName admin, CharSequence startUserSessionMessage) {
        this.throwIfParentInstance("setStartUserSessionMessage");
        try {
            this.mService.setStartUserSessionMessage(admin, startUserSessionMessage);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setEndUserSessionMessage(ComponentName admin, CharSequence endUserSessionMessage) {
        this.throwIfParentInstance("setEndUserSessionMessage");
        try {
            this.mService.setEndUserSessionMessage(admin, endUserSessionMessage);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final CharSequence $$robo$$android_app_admin_DevicePolicyManager$getStartUserSessionMessage(ComponentName admin) {
        this.throwIfParentInstance("getStartUserSessionMessage");
        try {
            return this.mService.getStartUserSessionMessage(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final CharSequence $$robo$$android_app_admin_DevicePolicyManager$getEndUserSessionMessage(ComponentName admin) {
        this.throwIfParentInstance("getEndUserSessionMessage");
        try {
            return this.mService.getEndUserSessionMessage(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_admin_DevicePolicyManager$addOverrideApn(ComponentName admin, ApnSetting apnSetting) {
        this.throwIfParentInstance("addOverrideApn");
        if (this.mService != null) {
            try {
                return this.mService.addOverrideApn(admin, apnSetting);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -1;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$updateOverrideApn(ComponentName admin, int apnId, ApnSetting apnSetting) {
        this.throwIfParentInstance("updateOverrideApn");
        if (this.mService != null) {
            try {
                return this.mService.updateOverrideApn(admin, apnId, apnSetting);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$removeOverrideApn(ComponentName admin, int apnId) {
        this.throwIfParentInstance("removeOverrideApn");
        if (this.mService != null) {
            try {
                return this.mService.removeOverrideApn(admin, apnId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final List<ApnSetting> $$robo$$android_app_admin_DevicePolicyManager$getOverrideApns(ComponentName admin) {
        this.throwIfParentInstance("getOverrideApns");
        if (this.mService != null) {
            try {
                return this.mService.getOverrideApns(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return Collections.emptyList();
    }

    private final void $$robo$$android_app_admin_DevicePolicyManager$setOverrideApnsEnabled(ComponentName admin, boolean enabled) {
        this.throwIfParentInstance("setOverrideApnEnabled");
        if (this.mService != null) {
            try {
                this.mService.setOverrideApnsEnabled(admin, enabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_admin_DevicePolicyManager$isOverrideApnEnabled(ComponentName admin) {
        this.throwIfParentInstance("isOverrideApnEnabled");
        if (this.mService != null) {
            try {
                return this.mService.isOverrideApnEnabled(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final PersistableBundle $$robo$$android_app_admin_DevicePolicyManager$getTransferOwnershipBundle() {
        this.throwIfParentInstance("getTransferOwnershipBundle");
        try {
            return this.mService.getTransferOwnershipBundle();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    static void __staticInitializer__() {
        TAG = "DevicePolicyManager";
    }

    private void __constructor__(Context context, IDevicePolicyManager iDevicePolicyManager) {
        this.$$robo$$android_app_admin_DevicePolicyManager$__constructor__(context, iDevicePolicyManager);
    }

    public DevicePolicyManager(Context context, IDevicePolicyManager iDevicePolicyManager) {
        this(context, iDevicePolicyManager, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_DevicePolicyManager$__constructor__(android.content.Context android.app.admin.IDevicePolicyManager ), 0, this, context, iDevicePolicyManager);
    }

    private void __constructor__(Context context, IDevicePolicyManager iDevicePolicyManager, boolean bl) {
        this.$$robo$$android_app_admin_DevicePolicyManager$__constructor__(context, iDevicePolicyManager, bl);
    }

    protected DevicePolicyManager(Context context, IDevicePolicyManager iDevicePolicyManager, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_DevicePolicyManager$__constructor__(android.content.Context android.app.admin.IDevicePolicyManager boolean ), 0, this, context, iDevicePolicyManager, bl);
    }

    protected int myUserId() {
        return (int)InvokeDynamicSupport.bootstrap("myUserId", $$robo$$android_app_admin_DevicePolicyManager$myUserId(), 0, this);
    }

    public boolean isAdminActive(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAdminActive", $$robo$$android_app_admin_DevicePolicyManager$isAdminActive(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isAdminActiveAsUser(ComponentName componentName, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAdminActiveAsUser", $$robo$$android_app_admin_DevicePolicyManager$isAdminActiveAsUser(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public boolean isRemovingAdmin(ComponentName componentName, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isRemovingAdmin", $$robo$$android_app_admin_DevicePolicyManager$isRemovingAdmin(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public List<ComponentName> getActiveAdmins() {
        return InvokeDynamicSupport.bootstrap("getActiveAdmins", $$robo$$android_app_admin_DevicePolicyManager$getActiveAdmins(), 0, this);
    }

    public List<ComponentName> getActiveAdminsAsUser(int n) {
        return InvokeDynamicSupport.bootstrap("getActiveAdminsAsUser", $$robo$$android_app_admin_DevicePolicyManager$getActiveAdminsAsUser(int ), 0, this, n);
    }

    @SystemApi
    public boolean packageHasActiveAdmins(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("packageHasActiveAdmins", $$robo$$android_app_admin_DevicePolicyManager$packageHasActiveAdmins(java.lang.String ), 0, this, string2);
    }

    public boolean packageHasActiveAdmins(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("packageHasActiveAdmins", $$robo$$android_app_admin_DevicePolicyManager$packageHasActiveAdmins(java.lang.String int ), 0, this, string2, n);
    }

    public void removeActiveAdmin(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("removeActiveAdmin", $$robo$$android_app_admin_DevicePolicyManager$removeActiveAdmin(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean hasGrantedPolicy(ComponentName componentName, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasGrantedPolicy", $$robo$$android_app_admin_DevicePolicyManager$hasGrantedPolicy(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public boolean isSeparateProfileChallengeAllowed(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSeparateProfileChallengeAllowed", $$robo$$android_app_admin_DevicePolicyManager$isSeparateProfileChallengeAllowed(int ), 0, this, n);
    }

    public void setPasswordQuality(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordQuality", $$robo$$android_app_admin_DevicePolicyManager$setPasswordQuality(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordQuality(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordQuality", $$robo$$android_app_admin_DevicePolicyManager$getPasswordQuality(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordQuality(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordQuality", $$robo$$android_app_admin_DevicePolicyManager$getPasswordQuality(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordMinimumLength(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordMinimumLength", $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumLength(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMinimumLength(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumLength", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLength(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordMinimumLength(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumLength", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLength(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordMinimumUpperCase(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordMinimumUpperCase", $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumUpperCase(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMinimumUpperCase(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumUpperCase", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumUpperCase(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordMinimumUpperCase(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumUpperCase", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumUpperCase(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordMinimumLowerCase(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordMinimumLowerCase", $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumLowerCase(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMinimumLowerCase(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumLowerCase", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLowerCase(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordMinimumLowerCase(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumLowerCase", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLowerCase(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordMinimumLetters(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordMinimumLetters", $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumLetters(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMinimumLetters(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumLetters", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLetters(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordMinimumLetters(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumLetters", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumLetters(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordMinimumNumeric(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordMinimumNumeric", $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumNumeric(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMinimumNumeric(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumNumeric", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNumeric(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordMinimumNumeric(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumNumeric", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNumeric(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordMinimumSymbols(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordMinimumSymbols", $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumSymbols(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMinimumSymbols(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumSymbols", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumSymbols(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordMinimumSymbols(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumSymbols", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumSymbols(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordMinimumNonLetter(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordMinimumNonLetter", $$robo$$android_app_admin_DevicePolicyManager$setPasswordMinimumNonLetter(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMinimumNonLetter(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumNonLetter", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNonLetter(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordMinimumNonLetter(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMinimumNonLetter", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMinimumNonLetter(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordHistoryLength(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPasswordHistoryLength", $$robo$$android_app_admin_DevicePolicyManager$setPasswordHistoryLength(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setPasswordExpirationTimeout(ComponentName componentName, long l) {
        InvokeDynamicSupport.bootstrap("setPasswordExpirationTimeout", $$robo$$android_app_admin_DevicePolicyManager$setPasswordExpirationTimeout(android.content.ComponentName long ), 0, this, componentName, l);
    }

    public long getPasswordExpirationTimeout(ComponentName componentName) {
        return (long)InvokeDynamicSupport.bootstrap("getPasswordExpirationTimeout", $$robo$$android_app_admin_DevicePolicyManager$getPasswordExpirationTimeout(android.content.ComponentName ), 0, this, componentName);
    }

    public long getPasswordExpiration(ComponentName componentName) {
        return (long)InvokeDynamicSupport.bootstrap("getPasswordExpiration", $$robo$$android_app_admin_DevicePolicyManager$getPasswordExpiration(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordHistoryLength(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordHistoryLength", $$robo$$android_app_admin_DevicePolicyManager$getPasswordHistoryLength(android.content.ComponentName ), 0, this, componentName);
    }

    public int getPasswordHistoryLength(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordHistoryLength", $$robo$$android_app_admin_DevicePolicyManager$getPasswordHistoryLength(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPasswordMaximumLength(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPasswordMaximumLength", $$robo$$android_app_admin_DevicePolicyManager$getPasswordMaximumLength(int ), 0, this, n);
    }

    public boolean isActivePasswordSufficient() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActivePasswordSufficient", $$robo$$android_app_admin_DevicePolicyManager$isActivePasswordSufficient(), 0, this);
    }

    public boolean isUsingUnifiedPassword(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUsingUnifiedPassword", $$robo$$android_app_admin_DevicePolicyManager$isUsingUnifiedPassword(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isProfileActivePasswordSufficientForParent(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isProfileActivePasswordSufficientForParent", $$robo$$android_app_admin_DevicePolicyManager$isProfileActivePasswordSufficientForParent(int ), 0, this, n);
    }

    public int getCurrentFailedPasswordAttempts() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentFailedPasswordAttempts", $$robo$$android_app_admin_DevicePolicyManager$getCurrentFailedPasswordAttempts(), 0, this);
    }

    public int getCurrentFailedPasswordAttempts(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentFailedPasswordAttempts", $$robo$$android_app_admin_DevicePolicyManager$getCurrentFailedPasswordAttempts(int ), 0, this, n);
    }

    public boolean getDoNotAskCredentialsOnBoot() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDoNotAskCredentialsOnBoot", $$robo$$android_app_admin_DevicePolicyManager$getDoNotAskCredentialsOnBoot(), 0, this);
    }

    public void setMaximumFailedPasswordsForWipe(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setMaximumFailedPasswordsForWipe", $$robo$$android_app_admin_DevicePolicyManager$setMaximumFailedPasswordsForWipe(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getMaximumFailedPasswordsForWipe(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumFailedPasswordsForWipe", $$robo$$android_app_admin_DevicePolicyManager$getMaximumFailedPasswordsForWipe(android.content.ComponentName ), 0, this, componentName);
    }

    public int getMaximumFailedPasswordsForWipe(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumFailedPasswordsForWipe", $$robo$$android_app_admin_DevicePolicyManager$getMaximumFailedPasswordsForWipe(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getProfileWithMinimumFailedPasswordsForWipe(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getProfileWithMinimumFailedPasswordsForWipe", $$robo$$android_app_admin_DevicePolicyManager$getProfileWithMinimumFailedPasswordsForWipe(int ), 0, this, n);
    }

    public boolean resetPassword(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("resetPassword", $$robo$$android_app_admin_DevicePolicyManager$resetPassword(java.lang.String int ), 0, this, string2, n);
    }

    public boolean setResetPasswordToken(ComponentName componentName, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setResetPasswordToken", $$robo$$android_app_admin_DevicePolicyManager$setResetPasswordToken(android.content.ComponentName byte[] ), 0, this, componentName, byArray);
    }

    public boolean clearResetPasswordToken(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("clearResetPasswordToken", $$robo$$android_app_admin_DevicePolicyManager$clearResetPasswordToken(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isResetPasswordTokenActive(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isResetPasswordTokenActive", $$robo$$android_app_admin_DevicePolicyManager$isResetPasswordTokenActive(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean resetPasswordWithToken(ComponentName componentName, String string2, byte[] byArray, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("resetPasswordWithToken", $$robo$$android_app_admin_DevicePolicyManager$resetPasswordWithToken(android.content.ComponentName java.lang.String byte[] int ), 0, this, componentName, string2, byArray, n);
    }

    public void setMaximumTimeToLock(ComponentName componentName, long l) {
        InvokeDynamicSupport.bootstrap("setMaximumTimeToLock", $$robo$$android_app_admin_DevicePolicyManager$setMaximumTimeToLock(android.content.ComponentName long ), 0, this, componentName, l);
    }

    public long getMaximumTimeToLock(ComponentName componentName) {
        return (long)InvokeDynamicSupport.bootstrap("getMaximumTimeToLock", $$robo$$android_app_admin_DevicePolicyManager$getMaximumTimeToLock(android.content.ComponentName ), 0, this, componentName);
    }

    public long getMaximumTimeToLock(ComponentName componentName, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getMaximumTimeToLock", $$robo$$android_app_admin_DevicePolicyManager$getMaximumTimeToLock(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setRequiredStrongAuthTimeout(ComponentName componentName, long l) {
        InvokeDynamicSupport.bootstrap("setRequiredStrongAuthTimeout", $$robo$$android_app_admin_DevicePolicyManager$setRequiredStrongAuthTimeout(android.content.ComponentName long ), 0, this, componentName, l);
    }

    public long getRequiredStrongAuthTimeout(ComponentName componentName) {
        return (long)InvokeDynamicSupport.bootstrap("getRequiredStrongAuthTimeout", $$robo$$android_app_admin_DevicePolicyManager$getRequiredStrongAuthTimeout(android.content.ComponentName ), 0, this, componentName);
    }

    public long getRequiredStrongAuthTimeout(ComponentName componentName, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getRequiredStrongAuthTimeout", $$robo$$android_app_admin_DevicePolicyManager$getRequiredStrongAuthTimeout(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void lockNow() {
        InvokeDynamicSupport.bootstrap("lockNow", $$robo$$android_app_admin_DevicePolicyManager$lockNow(), 0, this);
    }

    public void lockNow(int n) {
        InvokeDynamicSupport.bootstrap("lockNow", $$robo$$android_app_admin_DevicePolicyManager$lockNow(int ), 0, this, n);
    }

    public void wipeData(int n) {
        InvokeDynamicSupport.bootstrap("wipeData", $$robo$$android_app_admin_DevicePolicyManager$wipeData(int ), 0, this, n);
    }

    public void wipeData(int n, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("wipeData", $$robo$$android_app_admin_DevicePolicyManager$wipeData(int java.lang.CharSequence ), 0, this, n, charSequence);
    }

    private void wipeDataInternal(int n, String string2) {
        InvokeDynamicSupport.bootstrap("wipeDataInternal", $$robo$$android_app_admin_DevicePolicyManager$wipeDataInternal(int java.lang.String ), 0, this, n, string2);
    }

    public ComponentName setGlobalProxy(ComponentName componentName, Proxy proxy, List<String> list) {
        return InvokeDynamicSupport.bootstrap("setGlobalProxy", $$robo$$android_app_admin_DevicePolicyManager$setGlobalProxy(android.content.ComponentName java.net.Proxy java.util.List<java.lang.String> ), 0, this, componentName, proxy, list);
    }

    public void setRecommendedGlobalProxy(ComponentName componentName, ProxyInfo proxyInfo) {
        InvokeDynamicSupport.bootstrap("setRecommendedGlobalProxy", $$robo$$android_app_admin_DevicePolicyManager$setRecommendedGlobalProxy(android.content.ComponentName android.net.ProxyInfo ), 0, this, componentName, proxyInfo);
    }

    public ComponentName getGlobalProxyAdmin() {
        return InvokeDynamicSupport.bootstrap("getGlobalProxyAdmin", $$robo$$android_app_admin_DevicePolicyManager$getGlobalProxyAdmin(), 0, this);
    }

    public int setStorageEncryption(ComponentName componentName, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("setStorageEncryption", $$robo$$android_app_admin_DevicePolicyManager$setStorageEncryption(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean getStorageEncryption(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("getStorageEncryption", $$robo$$android_app_admin_DevicePolicyManager$getStorageEncryption(android.content.ComponentName ), 0, this, componentName);
    }

    public int getStorageEncryptionStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getStorageEncryptionStatus", $$robo$$android_app_admin_DevicePolicyManager$getStorageEncryptionStatus(), 0, this);
    }

    public int getStorageEncryptionStatus(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStorageEncryptionStatus", $$robo$$android_app_admin_DevicePolicyManager$getStorageEncryptionStatus(int ), 0, this, n);
    }

    public boolean approveCaCert(String string2, int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("approveCaCert", $$robo$$android_app_admin_DevicePolicyManager$approveCaCert(java.lang.String int boolean ), 0, this, string2, n, bl);
    }

    public boolean isCaCertApproved(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCaCertApproved", $$robo$$android_app_admin_DevicePolicyManager$isCaCertApproved(java.lang.String int ), 0, this, string2, n);
    }

    public boolean installCaCert(ComponentName componentName, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("installCaCert", $$robo$$android_app_admin_DevicePolicyManager$installCaCert(android.content.ComponentName byte[] ), 0, this, componentName, byArray);
    }

    public void uninstallCaCert(ComponentName componentName, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("uninstallCaCert", $$robo$$android_app_admin_DevicePolicyManager$uninstallCaCert(android.content.ComponentName byte[] ), 0, this, componentName, byArray);
    }

    public List<byte[]> getInstalledCaCerts(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getInstalledCaCerts", $$robo$$android_app_admin_DevicePolicyManager$getInstalledCaCerts(android.content.ComponentName ), 0, this, componentName);
    }

    public void uninstallAllUserCaCerts(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("uninstallAllUserCaCerts", $$robo$$android_app_admin_DevicePolicyManager$uninstallAllUserCaCerts(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean hasCaCertInstalled(ComponentName componentName, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCaCertInstalled", $$robo$$android_app_admin_DevicePolicyManager$hasCaCertInstalled(android.content.ComponentName byte[] ), 0, this, componentName, byArray);
    }

    public boolean installKeyPair(ComponentName componentName, PrivateKey privateKey, Certificate certificate, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("installKeyPair", $$robo$$android_app_admin_DevicePolicyManager$installKeyPair(android.content.ComponentName java.security.PrivateKey java.security.cert.Certificate java.lang.String ), 0, this, componentName, privateKey, certificate, string2);
    }

    public boolean installKeyPair(ComponentName componentName, PrivateKey privateKey, Certificate[] certificateArray, String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("installKeyPair", $$robo$$android_app_admin_DevicePolicyManager$installKeyPair(android.content.ComponentName java.security.PrivateKey java.security.cert.Certificate[] java.lang.String boolean ), 0, this, componentName, privateKey, certificateArray, string2, bl);
    }

    public boolean installKeyPair(ComponentName componentName, PrivateKey privateKey, Certificate[] certificateArray, String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("installKeyPair", $$robo$$android_app_admin_DevicePolicyManager$installKeyPair(android.content.ComponentName java.security.PrivateKey java.security.cert.Certificate[] java.lang.String int ), 0, this, componentName, privateKey, certificateArray, string2, n);
    }

    public boolean removeKeyPair(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeKeyPair", $$robo$$android_app_admin_DevicePolicyManager$removeKeyPair(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public AttestedKeyPair generateKeyPair(ComponentName componentName, String string2, KeyGenParameterSpec keyGenParameterSpec, int n) {
        return InvokeDynamicSupport.bootstrap("generateKeyPair", $$robo$$android_app_admin_DevicePolicyManager$generateKeyPair(android.content.ComponentName java.lang.String android.security.keystore.KeyGenParameterSpec int ), 0, this, componentName, string2, keyGenParameterSpec, n);
    }

    public boolean isDeviceIdAttestationSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceIdAttestationSupported", $$robo$$android_app_admin_DevicePolicyManager$isDeviceIdAttestationSupported(), 0, this);
    }

    public boolean setKeyPairCertificate(ComponentName componentName, String string2, List<Certificate> list, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setKeyPairCertificate", $$robo$$android_app_admin_DevicePolicyManager$setKeyPairCertificate(android.content.ComponentName java.lang.String java.util.List<java.security.cert.Certificate> boolean ), 0, this, componentName, string2, list, bl);
    }

    private static String getCaCertAlias(byte[] byArray) throws CertificateException {
        return InvokeDynamicSupport.bootstrapStatic("getCaCertAlias", $$robo$$android_app_admin_DevicePolicyManager$getCaCertAlias(byte[] ), 0, (byte[])byArray);
    }

    @Deprecated
    public void setCertInstallerPackage(ComponentName componentName, String string2) throws SecurityException {
        InvokeDynamicSupport.bootstrap("setCertInstallerPackage", $$robo$$android_app_admin_DevicePolicyManager$setCertInstallerPackage(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    @Deprecated
    public String getCertInstallerPackage(ComponentName componentName) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("getCertInstallerPackage", $$robo$$android_app_admin_DevicePolicyManager$getCertInstallerPackage(android.content.ComponentName ), 0, this, componentName);
    }

    public void setDelegatedScopes(ComponentName componentName, String string2, List<String> list) {
        InvokeDynamicSupport.bootstrap("setDelegatedScopes", $$robo$$android_app_admin_DevicePolicyManager$setDelegatedScopes(android.content.ComponentName java.lang.String java.util.List<java.lang.String> ), 0, this, componentName, string2, list);
    }

    public List<String> getDelegatedScopes(ComponentName componentName, String string2) {
        return InvokeDynamicSupport.bootstrap("getDelegatedScopes", $$robo$$android_app_admin_DevicePolicyManager$getDelegatedScopes(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public List<String> getDelegatePackages(ComponentName componentName, String string2) {
        return InvokeDynamicSupport.bootstrap("getDelegatePackages", $$robo$$android_app_admin_DevicePolicyManager$getDelegatePackages(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public void setAlwaysOnVpnPackage(ComponentName componentName, String string2, boolean bl) throws PackageManager.NameNotFoundException, UnsupportedOperationException {
        InvokeDynamicSupport.bootstrap("setAlwaysOnVpnPackage", $$robo$$android_app_admin_DevicePolicyManager$setAlwaysOnVpnPackage(android.content.ComponentName java.lang.String boolean ), 0, this, componentName, string2, bl);
    }

    public String getAlwaysOnVpnPackage(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getAlwaysOnVpnPackage", $$robo$$android_app_admin_DevicePolicyManager$getAlwaysOnVpnPackage(android.content.ComponentName ), 0, this, componentName);
    }

    public void setCameraDisabled(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCameraDisabled", $$robo$$android_app_admin_DevicePolicyManager$setCameraDisabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean getCameraDisabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("getCameraDisabled", $$robo$$android_app_admin_DevicePolicyManager$getCameraDisabled(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean getCameraDisabled(ComponentName componentName, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getCameraDisabled", $$robo$$android_app_admin_DevicePolicyManager$getCameraDisabled(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public boolean requestBugreport(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestBugreport", $$robo$$android_app_admin_DevicePolicyManager$requestBugreport(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean getGuestUserDisabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("getGuestUserDisabled", $$robo$$android_app_admin_DevicePolicyManager$getGuestUserDisabled(android.content.ComponentName ), 0, this, componentName);
    }

    public void setScreenCaptureDisabled(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setScreenCaptureDisabled", $$robo$$android_app_admin_DevicePolicyManager$setScreenCaptureDisabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean getScreenCaptureDisabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("getScreenCaptureDisabled", $$robo$$android_app_admin_DevicePolicyManager$getScreenCaptureDisabled(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean getScreenCaptureDisabled(ComponentName componentName, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getScreenCaptureDisabled", $$robo$$android_app_admin_DevicePolicyManager$getScreenCaptureDisabled(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setAutoTimeRequired(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoTimeRequired", $$robo$$android_app_admin_DevicePolicyManager$setAutoTimeRequired(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean getAutoTimeRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAutoTimeRequired", $$robo$$android_app_admin_DevicePolicyManager$getAutoTimeRequired(), 0, this);
    }

    public void setForceEphemeralUsers(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setForceEphemeralUsers", $$robo$$android_app_admin_DevicePolicyManager$setForceEphemeralUsers(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean getForceEphemeralUsers(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("getForceEphemeralUsers", $$robo$$android_app_admin_DevicePolicyManager$getForceEphemeralUsers(android.content.ComponentName ), 0, this, componentName);
    }

    public void setKeyguardDisabledFeatures(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setKeyguardDisabledFeatures", $$robo$$android_app_admin_DevicePolicyManager$setKeyguardDisabledFeatures(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getKeyguardDisabledFeatures(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getKeyguardDisabledFeatures", $$robo$$android_app_admin_DevicePolicyManager$getKeyguardDisabledFeatures(android.content.ComponentName ), 0, this, componentName);
    }

    public int getKeyguardDisabledFeatures(ComponentName componentName, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getKeyguardDisabledFeatures", $$robo$$android_app_admin_DevicePolicyManager$getKeyguardDisabledFeatures(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setActiveAdmin(ComponentName componentName, boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setActiveAdmin", $$robo$$android_app_admin_DevicePolicyManager$setActiveAdmin(android.content.ComponentName boolean int ), 0, this, componentName, bl, n);
    }

    public void setActiveAdmin(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setActiveAdmin", $$robo$$android_app_admin_DevicePolicyManager$setActiveAdmin(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public void getRemoveWarning(ComponentName componentName, RemoteCallback remoteCallback) {
        InvokeDynamicSupport.bootstrap("getRemoveWarning", $$robo$$android_app_admin_DevicePolicyManager$getRemoveWarning(android.content.ComponentName android.os.RemoteCallback ), 0, this, componentName, remoteCallback);
    }

    public void setActivePasswordState(PasswordMetrics passwordMetrics, int n) {
        InvokeDynamicSupport.bootstrap("setActivePasswordState", $$robo$$android_app_admin_DevicePolicyManager$setActivePasswordState(android.app.admin.PasswordMetrics int ), 0, this, passwordMetrics, n);
    }

    public void reportPasswordChanged(int n) {
        InvokeDynamicSupport.bootstrap("reportPasswordChanged", $$robo$$android_app_admin_DevicePolicyManager$reportPasswordChanged(int ), 0, this, n);
    }

    public void reportFailedPasswordAttempt(int n) {
        InvokeDynamicSupport.bootstrap("reportFailedPasswordAttempt", $$robo$$android_app_admin_DevicePolicyManager$reportFailedPasswordAttempt(int ), 0, this, n);
    }

    public void reportSuccessfulPasswordAttempt(int n) {
        InvokeDynamicSupport.bootstrap("reportSuccessfulPasswordAttempt", $$robo$$android_app_admin_DevicePolicyManager$reportSuccessfulPasswordAttempt(int ), 0, this, n);
    }

    public void reportFailedFingerprintAttempt(int n) {
        InvokeDynamicSupport.bootstrap("reportFailedFingerprintAttempt", $$robo$$android_app_admin_DevicePolicyManager$reportFailedFingerprintAttempt(int ), 0, this, n);
    }

    public void reportSuccessfulFingerprintAttempt(int n) {
        InvokeDynamicSupport.bootstrap("reportSuccessfulFingerprintAttempt", $$robo$$android_app_admin_DevicePolicyManager$reportSuccessfulFingerprintAttempt(int ), 0, this, n);
    }

    public void reportKeyguardDismissed(int n) {
        InvokeDynamicSupport.bootstrap("reportKeyguardDismissed", $$robo$$android_app_admin_DevicePolicyManager$reportKeyguardDismissed(int ), 0, this, n);
    }

    public void reportKeyguardSecured(int n) {
        InvokeDynamicSupport.bootstrap("reportKeyguardSecured", $$robo$$android_app_admin_DevicePolicyManager$reportKeyguardSecured(int ), 0, this, n);
    }

    public boolean setDeviceOwner(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("setDeviceOwner", $$robo$$android_app_admin_DevicePolicyManager$setDeviceOwner(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean setDeviceOwner(ComponentName componentName, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setDeviceOwner", $$robo$$android_app_admin_DevicePolicyManager$setDeviceOwner(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public boolean setDeviceOwner(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setDeviceOwner", $$robo$$android_app_admin_DevicePolicyManager$setDeviceOwner(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public boolean setDeviceOwner(ComponentName componentName, String string2, int n) throws IllegalArgumentException, IllegalStateException {
        return (boolean)InvokeDynamicSupport.bootstrap("setDeviceOwner", $$robo$$android_app_admin_DevicePolicyManager$setDeviceOwner(android.content.ComponentName java.lang.String int ), 0, this, componentName, string2, n);
    }

    public boolean isDeviceOwnerApp(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceOwnerApp", $$robo$$android_app_admin_DevicePolicyManager$isDeviceOwnerApp(java.lang.String ), 0, this, string2);
    }

    public boolean isDeviceOwnerAppOnCallingUser(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceOwnerAppOnCallingUser", $$robo$$android_app_admin_DevicePolicyManager$isDeviceOwnerAppOnCallingUser(java.lang.String ), 0, this, string2);
    }

    public boolean isDeviceOwnerAppOnAnyUser(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceOwnerAppOnAnyUser", $$robo$$android_app_admin_DevicePolicyManager$isDeviceOwnerAppOnAnyUser(java.lang.String ), 0, this, string2);
    }

    public ComponentName getDeviceOwnerComponentOnCallingUser() {
        return InvokeDynamicSupport.bootstrap("getDeviceOwnerComponentOnCallingUser", $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerComponentOnCallingUser(), 0, this);
    }

    @SystemApi
    public ComponentName getDeviceOwnerComponentOnAnyUser() {
        return InvokeDynamicSupport.bootstrap("getDeviceOwnerComponentOnAnyUser", $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerComponentOnAnyUser(), 0, this);
    }

    private boolean isDeviceOwnerAppOnAnyUserInner(String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceOwnerAppOnAnyUserInner", $$robo$$android_app_admin_DevicePolicyManager$isDeviceOwnerAppOnAnyUserInner(java.lang.String boolean ), 0, this, string2, bl);
    }

    private ComponentName getDeviceOwnerComponentInner(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getDeviceOwnerComponentInner", $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerComponentInner(boolean ), 0, this, bl);
    }

    public int getDeviceOwnerUserId() {
        return (int)InvokeDynamicSupport.bootstrap("getDeviceOwnerUserId", $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerUserId(), 0, this);
    }

    @Deprecated
    public void clearDeviceOwnerApp(String string2) {
        InvokeDynamicSupport.bootstrap("clearDeviceOwnerApp", $$robo$$android_app_admin_DevicePolicyManager$clearDeviceOwnerApp(java.lang.String ), 0, this, string2);
    }

    @SystemApi
    public String getDeviceOwner() {
        return InvokeDynamicSupport.bootstrap("getDeviceOwner", $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwner(), 0, this);
    }

    @SystemApi
    public boolean isDeviceManaged() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceManaged", $$robo$$android_app_admin_DevicePolicyManager$isDeviceManaged(), 0, this);
    }

    @SystemApi
    public String getDeviceOwnerNameOnAnyUser() {
        return InvokeDynamicSupport.bootstrap("getDeviceOwnerNameOnAnyUser", $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerNameOnAnyUser(), 0, this);
    }

    @Deprecated
    @SystemApi
    public String getDeviceInitializerApp() {
        return InvokeDynamicSupport.bootstrap("getDeviceInitializerApp", $$robo$$android_app_admin_DevicePolicyManager$getDeviceInitializerApp(), 0, this);
    }

    @Deprecated
    @SystemApi
    public ComponentName getDeviceInitializerComponent() {
        return InvokeDynamicSupport.bootstrap("getDeviceInitializerComponent", $$robo$$android_app_admin_DevicePolicyManager$getDeviceInitializerComponent(), 0, this);
    }

    @Deprecated
    @SystemApi
    public boolean setActiveProfileOwner(ComponentName componentName, String string2) throws IllegalArgumentException {
        return (boolean)InvokeDynamicSupport.bootstrap("setActiveProfileOwner", $$robo$$android_app_admin_DevicePolicyManager$setActiveProfileOwner(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    @Deprecated
    public void clearProfileOwner(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("clearProfileOwner", $$robo$$android_app_admin_DevicePolicyManager$clearProfileOwner(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean hasUserSetupCompleted() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasUserSetupCompleted", $$robo$$android_app_admin_DevicePolicyManager$hasUserSetupCompleted(), 0, this);
    }

    public boolean setProfileOwner(ComponentName componentName, String string2, int n) throws IllegalArgumentException {
        return (boolean)InvokeDynamicSupport.bootstrap("setProfileOwner", $$robo$$android_app_admin_DevicePolicyManager$setProfileOwner(android.content.ComponentName java.lang.String int ), 0, this, componentName, string2, n);
    }

    public void setDeviceOwnerLockScreenInfo(ComponentName componentName, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setDeviceOwnerLockScreenInfo", $$robo$$android_app_admin_DevicePolicyManager$setDeviceOwnerLockScreenInfo(android.content.ComponentName java.lang.CharSequence ), 0, this, componentName, charSequence);
    }

    public CharSequence getDeviceOwnerLockScreenInfo() {
        return InvokeDynamicSupport.bootstrap("getDeviceOwnerLockScreenInfo", $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerLockScreenInfo(), 0, this);
    }

    public String[] setPackagesSuspended(ComponentName componentName, String[] stringArray, boolean bl) {
        return InvokeDynamicSupport.bootstrap("setPackagesSuspended", $$robo$$android_app_admin_DevicePolicyManager$setPackagesSuspended(android.content.ComponentName java.lang.String[] boolean ), 0, this, componentName, stringArray, bl);
    }

    public boolean isPackageSuspended(ComponentName componentName, String string2) throws PackageManager.NameNotFoundException {
        return (boolean)InvokeDynamicSupport.bootstrap("isPackageSuspended", $$robo$$android_app_admin_DevicePolicyManager$isPackageSuspended(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public void setProfileEnabled(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("setProfileEnabled", $$robo$$android_app_admin_DevicePolicyManager$setProfileEnabled(android.content.ComponentName ), 0, this, componentName);
    }

    public void setProfileName(ComponentName componentName, String string2) {
        InvokeDynamicSupport.bootstrap("setProfileName", $$robo$$android_app_admin_DevicePolicyManager$setProfileName(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public boolean isProfileOwnerApp(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isProfileOwnerApp", $$robo$$android_app_admin_DevicePolicyManager$isProfileOwnerApp(java.lang.String ), 0, this, string2);
    }

    @SystemApi
    public ComponentName getProfileOwner() throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("getProfileOwner", $$robo$$android_app_admin_DevicePolicyManager$getProfileOwner(), 0, this);
    }

    public ComponentName getProfileOwnerAsUser(int n) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("getProfileOwnerAsUser", $$robo$$android_app_admin_DevicePolicyManager$getProfileOwnerAsUser(int ), 0, this, n);
    }

    public String getProfileOwnerName() throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("getProfileOwnerName", $$robo$$android_app_admin_DevicePolicyManager$getProfileOwnerName(), 0, this);
    }

    @SystemApi
    public String getProfileOwnerNameAsUser(int n) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("getProfileOwnerNameAsUser", $$robo$$android_app_admin_DevicePolicyManager$getProfileOwnerNameAsUser(int ), 0, this, n);
    }

    public void addPersistentPreferredActivity(ComponentName componentName, IntentFilter intentFilter, ComponentName componentName2) {
        InvokeDynamicSupport.bootstrap("addPersistentPreferredActivity", $$robo$$android_app_admin_DevicePolicyManager$addPersistentPreferredActivity(android.content.ComponentName android.content.IntentFilter android.content.ComponentName ), 0, this, componentName, intentFilter, componentName2);
    }

    public void clearPackagePersistentPreferredActivities(ComponentName componentName, String string2) {
        InvokeDynamicSupport.bootstrap("clearPackagePersistentPreferredActivities", $$robo$$android_app_admin_DevicePolicyManager$clearPackagePersistentPreferredActivities(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public void setDefaultSmsApplication(ComponentName componentName, String string2) {
        InvokeDynamicSupport.bootstrap("setDefaultSmsApplication", $$robo$$android_app_admin_DevicePolicyManager$setDefaultSmsApplication(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    @Deprecated
    public void setApplicationRestrictionsManagingPackage(ComponentName componentName, String string2) throws PackageManager.NameNotFoundException {
        InvokeDynamicSupport.bootstrap("setApplicationRestrictionsManagingPackage", $$robo$$android_app_admin_DevicePolicyManager$setApplicationRestrictionsManagingPackage(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    @Deprecated
    public String getApplicationRestrictionsManagingPackage(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getApplicationRestrictionsManagingPackage", $$robo$$android_app_admin_DevicePolicyManager$getApplicationRestrictionsManagingPackage(android.content.ComponentName ), 0, this, componentName);
    }

    @Deprecated
    public boolean isCallerApplicationRestrictionsManagingPackage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCallerApplicationRestrictionsManagingPackage", $$robo$$android_app_admin_DevicePolicyManager$isCallerApplicationRestrictionsManagingPackage(), 0, this);
    }

    public void setApplicationRestrictions(ComponentName componentName, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setApplicationRestrictions", $$robo$$android_app_admin_DevicePolicyManager$setApplicationRestrictions(android.content.ComponentName java.lang.String android.os.Bundle ), 0, this, componentName, string2, bundle);
    }

    public void setTrustAgentConfiguration(ComponentName componentName, ComponentName componentName2, PersistableBundle persistableBundle) {
        InvokeDynamicSupport.bootstrap("setTrustAgentConfiguration", $$robo$$android_app_admin_DevicePolicyManager$setTrustAgentConfiguration(android.content.ComponentName android.content.ComponentName android.os.PersistableBundle ), 0, this, componentName, componentName2, persistableBundle);
    }

    public List<PersistableBundle> getTrustAgentConfiguration(ComponentName componentName, ComponentName componentName2) {
        return InvokeDynamicSupport.bootstrap("getTrustAgentConfiguration", $$robo$$android_app_admin_DevicePolicyManager$getTrustAgentConfiguration(android.content.ComponentName android.content.ComponentName ), 0, this, componentName, componentName2);
    }

    public List<PersistableBundle> getTrustAgentConfiguration(ComponentName componentName, ComponentName componentName2, int n) {
        return InvokeDynamicSupport.bootstrap("getTrustAgentConfiguration", $$robo$$android_app_admin_DevicePolicyManager$getTrustAgentConfiguration(android.content.ComponentName android.content.ComponentName int ), 0, this, componentName, componentName2, n);
    }

    public void setCrossProfileCallerIdDisabled(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCrossProfileCallerIdDisabled", $$robo$$android_app_admin_DevicePolicyManager$setCrossProfileCallerIdDisabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean getCrossProfileCallerIdDisabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("getCrossProfileCallerIdDisabled", $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileCallerIdDisabled(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean getCrossProfileCallerIdDisabled(UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("getCrossProfileCallerIdDisabled", $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileCallerIdDisabled(android.os.UserHandle ), 0, this, userHandle);
    }

    public void setCrossProfileContactsSearchDisabled(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCrossProfileContactsSearchDisabled", $$robo$$android_app_admin_DevicePolicyManager$setCrossProfileContactsSearchDisabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean getCrossProfileContactsSearchDisabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("getCrossProfileContactsSearchDisabled", $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileContactsSearchDisabled(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean getCrossProfileContactsSearchDisabled(UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("getCrossProfileContactsSearchDisabled", $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileContactsSearchDisabled(android.os.UserHandle ), 0, this, userHandle);
    }

    public void startManagedQuickContact(String string2, long l, boolean bl, long l2, Intent intent) {
        InvokeDynamicSupport.bootstrap("startManagedQuickContact", $$robo$$android_app_admin_DevicePolicyManager$startManagedQuickContact(java.lang.String long boolean long android.content.Intent ), 0, this, string2, l, bl, l2, intent);
    }

    public void startManagedQuickContact(String string2, long l, Intent intent) {
        InvokeDynamicSupport.bootstrap("startManagedQuickContact", $$robo$$android_app_admin_DevicePolicyManager$startManagedQuickContact(java.lang.String long android.content.Intent ), 0, this, string2, l, intent);
    }

    public void setBluetoothContactSharingDisabled(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setBluetoothContactSharingDisabled", $$robo$$android_app_admin_DevicePolicyManager$setBluetoothContactSharingDisabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean getBluetoothContactSharingDisabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBluetoothContactSharingDisabled", $$robo$$android_app_admin_DevicePolicyManager$getBluetoothContactSharingDisabled(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean getBluetoothContactSharingDisabled(UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBluetoothContactSharingDisabled", $$robo$$android_app_admin_DevicePolicyManager$getBluetoothContactSharingDisabled(android.os.UserHandle ), 0, this, userHandle);
    }

    public void addCrossProfileIntentFilter(ComponentName componentName, IntentFilter intentFilter, int n) {
        InvokeDynamicSupport.bootstrap("addCrossProfileIntentFilter", $$robo$$android_app_admin_DevicePolicyManager$addCrossProfileIntentFilter(android.content.ComponentName android.content.IntentFilter int ), 0, this, componentName, intentFilter, n);
    }

    public void clearCrossProfileIntentFilters(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("clearCrossProfileIntentFilters", $$robo$$android_app_admin_DevicePolicyManager$clearCrossProfileIntentFilters(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean setPermittedAccessibilityServices(ComponentName componentName, List<String> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPermittedAccessibilityServices", $$robo$$android_app_admin_DevicePolicyManager$setPermittedAccessibilityServices(android.content.ComponentName java.util.List<java.lang.String> ), 0, this, componentName, list);
    }

    public List<String> getPermittedAccessibilityServices(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getPermittedAccessibilityServices", $$robo$$android_app_admin_DevicePolicyManager$getPermittedAccessibilityServices(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isAccessibilityServicePermittedByAdmin(ComponentName componentName, String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAccessibilityServicePermittedByAdmin", $$robo$$android_app_admin_DevicePolicyManager$isAccessibilityServicePermittedByAdmin(android.content.ComponentName java.lang.String int ), 0, this, componentName, string2, n);
    }

    @SystemApi
    public List<String> getPermittedAccessibilityServices(int n) {
        return InvokeDynamicSupport.bootstrap("getPermittedAccessibilityServices", $$robo$$android_app_admin_DevicePolicyManager$getPermittedAccessibilityServices(int ), 0, this, n);
    }

    public boolean setPermittedInputMethods(ComponentName componentName, List<String> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPermittedInputMethods", $$robo$$android_app_admin_DevicePolicyManager$setPermittedInputMethods(android.content.ComponentName java.util.List<java.lang.String> ), 0, this, componentName, list);
    }

    public List<String> getPermittedInputMethods(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getPermittedInputMethods", $$robo$$android_app_admin_DevicePolicyManager$getPermittedInputMethods(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isInputMethodPermittedByAdmin(ComponentName componentName, String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isInputMethodPermittedByAdmin", $$robo$$android_app_admin_DevicePolicyManager$isInputMethodPermittedByAdmin(android.content.ComponentName java.lang.String int ), 0, this, componentName, string2, n);
    }

    @SystemApi
    public List<String> getPermittedInputMethodsForCurrentUser() {
        return InvokeDynamicSupport.bootstrap("getPermittedInputMethodsForCurrentUser", $$robo$$android_app_admin_DevicePolicyManager$getPermittedInputMethodsForCurrentUser(), 0, this);
    }

    public boolean setPermittedCrossProfileNotificationListeners(ComponentName componentName, List<String> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPermittedCrossProfileNotificationListeners", $$robo$$android_app_admin_DevicePolicyManager$setPermittedCrossProfileNotificationListeners(android.content.ComponentName java.util.List<java.lang.String> ), 0, this, componentName, list);
    }

    public List<String> getPermittedCrossProfileNotificationListeners(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getPermittedCrossProfileNotificationListeners", $$robo$$android_app_admin_DevicePolicyManager$getPermittedCrossProfileNotificationListeners(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isNotificationListenerServicePermitted(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNotificationListenerServicePermitted", $$robo$$android_app_admin_DevicePolicyManager$isNotificationListenerServicePermitted(java.lang.String int ), 0, this, string2, n);
    }

    public List<String> getKeepUninstalledPackages(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getKeepUninstalledPackages", $$robo$$android_app_admin_DevicePolicyManager$getKeepUninstalledPackages(android.content.ComponentName ), 0, this, componentName);
    }

    public void setKeepUninstalledPackages(ComponentName componentName, List<String> list) {
        InvokeDynamicSupport.bootstrap("setKeepUninstalledPackages", $$robo$$android_app_admin_DevicePolicyManager$setKeepUninstalledPackages(android.content.ComponentName java.util.List<java.lang.String> ), 0, this, componentName, list);
    }

    @Deprecated
    public UserHandle createUser(ComponentName componentName, String string2) {
        return InvokeDynamicSupport.bootstrap("createUser", $$robo$$android_app_admin_DevicePolicyManager$createUser(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    @Deprecated
    public UserHandle createAndInitializeUser(ComponentName componentName, String string2, String string3, ComponentName componentName2, Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("createAndInitializeUser", $$robo$$android_app_admin_DevicePolicyManager$createAndInitializeUser(android.content.ComponentName java.lang.String java.lang.String android.content.ComponentName android.os.Bundle ), 0, this, componentName, string2, string3, componentName2, bundle);
    }

    public UserHandle createAndManageUser(ComponentName componentName, String string2, ComponentName componentName2, PersistableBundle persistableBundle, int n) {
        return InvokeDynamicSupport.bootstrap("createAndManageUser", $$robo$$android_app_admin_DevicePolicyManager$createAndManageUser(android.content.ComponentName java.lang.String android.content.ComponentName android.os.PersistableBundle int ), 0, this, componentName, string2, componentName2, persistableBundle, n);
    }

    public boolean removeUser(ComponentName componentName, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeUser", $$robo$$android_app_admin_DevicePolicyManager$removeUser(android.content.ComponentName android.os.UserHandle ), 0, this, componentName, userHandle);
    }

    public boolean switchUser(ComponentName componentName, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("switchUser", $$robo$$android_app_admin_DevicePolicyManager$switchUser(android.content.ComponentName android.os.UserHandle ), 0, this, componentName, userHandle);
    }

    public int startUserInBackground(ComponentName componentName, UserHandle userHandle) {
        return (int)InvokeDynamicSupport.bootstrap("startUserInBackground", $$robo$$android_app_admin_DevicePolicyManager$startUserInBackground(android.content.ComponentName android.os.UserHandle ), 0, this, componentName, userHandle);
    }

    public int stopUser(ComponentName componentName, UserHandle userHandle) {
        return (int)InvokeDynamicSupport.bootstrap("stopUser", $$robo$$android_app_admin_DevicePolicyManager$stopUser(android.content.ComponentName android.os.UserHandle ), 0, this, componentName, userHandle);
    }

    public int logoutUser(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("logoutUser", $$robo$$android_app_admin_DevicePolicyManager$logoutUser(android.content.ComponentName ), 0, this, componentName);
    }

    public List<UserHandle> getSecondaryUsers(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getSecondaryUsers", $$robo$$android_app_admin_DevicePolicyManager$getSecondaryUsers(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isEphemeralUser(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isEphemeralUser", $$robo$$android_app_admin_DevicePolicyManager$isEphemeralUser(android.content.ComponentName ), 0, this, componentName);
    }

    public Bundle getApplicationRestrictions(ComponentName componentName, String string2) {
        return InvokeDynamicSupport.bootstrap("getApplicationRestrictions", $$robo$$android_app_admin_DevicePolicyManager$getApplicationRestrictions(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public void addUserRestriction(ComponentName componentName, String string2) {
        InvokeDynamicSupport.bootstrap("addUserRestriction", $$robo$$android_app_admin_DevicePolicyManager$addUserRestriction(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public void clearUserRestriction(ComponentName componentName, String string2) {
        InvokeDynamicSupport.bootstrap("clearUserRestriction", $$robo$$android_app_admin_DevicePolicyManager$clearUserRestriction(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public Bundle getUserRestrictions(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getUserRestrictions", $$robo$$android_app_admin_DevicePolicyManager$getUserRestrictions(android.content.ComponentName ), 0, this, componentName);
    }

    public Intent createAdminSupportIntent(String string2) {
        return InvokeDynamicSupport.bootstrap("createAdminSupportIntent", $$robo$$android_app_admin_DevicePolicyManager$createAdminSupportIntent(java.lang.String ), 0, this, string2);
    }

    public boolean setApplicationHidden(ComponentName componentName, String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setApplicationHidden", $$robo$$android_app_admin_DevicePolicyManager$setApplicationHidden(android.content.ComponentName java.lang.String boolean ), 0, this, componentName, string2, bl);
    }

    public boolean isApplicationHidden(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isApplicationHidden", $$robo$$android_app_admin_DevicePolicyManager$isApplicationHidden(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public void enableSystemApp(ComponentName componentName, String string2) {
        InvokeDynamicSupport.bootstrap("enableSystemApp", $$robo$$android_app_admin_DevicePolicyManager$enableSystemApp(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public int enableSystemApp(ComponentName componentName, Intent intent) {
        return (int)InvokeDynamicSupport.bootstrap("enableSystemApp", $$robo$$android_app_admin_DevicePolicyManager$enableSystemApp(android.content.ComponentName android.content.Intent ), 0, this, componentName, intent);
    }

    public boolean installExistingPackage(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("installExistingPackage", $$robo$$android_app_admin_DevicePolicyManager$installExistingPackage(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public void setAccountManagementDisabled(ComponentName componentName, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setAccountManagementDisabled", $$robo$$android_app_admin_DevicePolicyManager$setAccountManagementDisabled(android.content.ComponentName java.lang.String boolean ), 0, this, componentName, string2, bl);
    }

    public String[] getAccountTypesWithManagementDisabled() {
        return InvokeDynamicSupport.bootstrap("getAccountTypesWithManagementDisabled", $$robo$$android_app_admin_DevicePolicyManager$getAccountTypesWithManagementDisabled(), 0, this);
    }

    public String[] getAccountTypesWithManagementDisabledAsUser(int n) {
        return InvokeDynamicSupport.bootstrap("getAccountTypesWithManagementDisabledAsUser", $$robo$$android_app_admin_DevicePolicyManager$getAccountTypesWithManagementDisabledAsUser(int ), 0, this, n);
    }

    public void setLockTaskPackages(ComponentName componentName, String[] stringArray) throws SecurityException {
        InvokeDynamicSupport.bootstrap("setLockTaskPackages", $$robo$$android_app_admin_DevicePolicyManager$setLockTaskPackages(android.content.ComponentName java.lang.String[] ), 0, this, componentName, stringArray);
    }

    public String[] getLockTaskPackages(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getLockTaskPackages", $$robo$$android_app_admin_DevicePolicyManager$getLockTaskPackages(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isLockTaskPermitted(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLockTaskPermitted", $$robo$$android_app_admin_DevicePolicyManager$isLockTaskPermitted(java.lang.String ), 0, this, string2);
    }

    public void setLockTaskFeatures(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setLockTaskFeatures", $$robo$$android_app_admin_DevicePolicyManager$setLockTaskFeatures(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getLockTaskFeatures(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getLockTaskFeatures", $$robo$$android_app_admin_DevicePolicyManager$getLockTaskFeatures(android.content.ComponentName ), 0, this, componentName);
    }

    public void setGlobalSetting(ComponentName componentName, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setGlobalSetting", $$robo$$android_app_admin_DevicePolicyManager$setGlobalSetting(android.content.ComponentName java.lang.String java.lang.String ), 0, this, componentName, string2, string3);
    }

    public void setSystemSetting(ComponentName componentName, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setSystemSetting", $$robo$$android_app_admin_DevicePolicyManager$setSystemSetting(android.content.ComponentName java.lang.String java.lang.String ), 0, this, componentName, string2, string3);
    }

    public boolean setTime(ComponentName componentName, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("setTime", $$robo$$android_app_admin_DevicePolicyManager$setTime(android.content.ComponentName long ), 0, this, componentName, l);
    }

    public boolean setTimeZone(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setTimeZone", $$robo$$android_app_admin_DevicePolicyManager$setTimeZone(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public void setSecureSetting(ComponentName componentName, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setSecureSetting", $$robo$$android_app_admin_DevicePolicyManager$setSecureSetting(android.content.ComponentName java.lang.String java.lang.String ), 0, this, componentName, string2, string3);
    }

    public void setRestrictionsProvider(ComponentName componentName, ComponentName componentName2) {
        InvokeDynamicSupport.bootstrap("setRestrictionsProvider", $$robo$$android_app_admin_DevicePolicyManager$setRestrictionsProvider(android.content.ComponentName android.content.ComponentName ), 0, this, componentName, componentName2);
    }

    public void setMasterVolumeMuted(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setMasterVolumeMuted", $$robo$$android_app_admin_DevicePolicyManager$setMasterVolumeMuted(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean isMasterVolumeMuted(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isMasterVolumeMuted", $$robo$$android_app_admin_DevicePolicyManager$isMasterVolumeMuted(android.content.ComponentName ), 0, this, componentName);
    }

    public void setUninstallBlocked(ComponentName componentName, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setUninstallBlocked", $$robo$$android_app_admin_DevicePolicyManager$setUninstallBlocked(android.content.ComponentName java.lang.String boolean ), 0, this, componentName, string2, bl);
    }

    public boolean isUninstallBlocked(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUninstallBlocked", $$robo$$android_app_admin_DevicePolicyManager$isUninstallBlocked(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public boolean addCrossProfileWidgetProvider(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("addCrossProfileWidgetProvider", $$robo$$android_app_admin_DevicePolicyManager$addCrossProfileWidgetProvider(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public boolean removeCrossProfileWidgetProvider(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeCrossProfileWidgetProvider", $$robo$$android_app_admin_DevicePolicyManager$removeCrossProfileWidgetProvider(android.content.ComponentName java.lang.String ), 0, this, componentName, string2);
    }

    public List<String> getCrossProfileWidgetProviders(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getCrossProfileWidgetProviders", $$robo$$android_app_admin_DevicePolicyManager$getCrossProfileWidgetProviders(android.content.ComponentName ), 0, this, componentName);
    }

    public void setUserIcon(ComponentName componentName, Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setUserIcon", $$robo$$android_app_admin_DevicePolicyManager$setUserIcon(android.content.ComponentName android.graphics.Bitmap ), 0, this, componentName, bitmap);
    }

    public void setSystemUpdatePolicy(ComponentName componentName, SystemUpdatePolicy systemUpdatePolicy) {
        InvokeDynamicSupport.bootstrap("setSystemUpdatePolicy", $$robo$$android_app_admin_DevicePolicyManager$setSystemUpdatePolicy(android.content.ComponentName android.app.admin.SystemUpdatePolicy ), 0, this, componentName, systemUpdatePolicy);
    }

    public SystemUpdatePolicy getSystemUpdatePolicy() {
        return InvokeDynamicSupport.bootstrap("getSystemUpdatePolicy", $$robo$$android_app_admin_DevicePolicyManager$getSystemUpdatePolicy(), 0, this);
    }

    public void clearSystemUpdatePolicyFreezePeriodRecord() {
        InvokeDynamicSupport.bootstrap("clearSystemUpdatePolicyFreezePeriodRecord", $$robo$$android_app_admin_DevicePolicyManager$clearSystemUpdatePolicyFreezePeriodRecord(), 0, this);
    }

    public boolean setKeyguardDisabled(ComponentName componentName, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setKeyguardDisabled", $$robo$$android_app_admin_DevicePolicyManager$setKeyguardDisabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean setStatusBarDisabled(ComponentName componentName, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setStatusBarDisabled", $$robo$$android_app_admin_DevicePolicyManager$setStatusBarDisabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    @SystemApi
    public void notifyPendingSystemUpdate(long l) {
        InvokeDynamicSupport.bootstrap("notifyPendingSystemUpdate", $$robo$$android_app_admin_DevicePolicyManager$notifyPendingSystemUpdate(long ), 0, this, l);
    }

    @SystemApi
    public void notifyPendingSystemUpdate(long l, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyPendingSystemUpdate", $$robo$$android_app_admin_DevicePolicyManager$notifyPendingSystemUpdate(long boolean ), 0, this, l, bl);
    }

    public SystemUpdateInfo getPendingSystemUpdate(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getPendingSystemUpdate", $$robo$$android_app_admin_DevicePolicyManager$getPendingSystemUpdate(android.content.ComponentName ), 0, this, componentName);
    }

    public void setPermissionPolicy(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setPermissionPolicy", $$robo$$android_app_admin_DevicePolicyManager$setPermissionPolicy(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public int getPermissionPolicy(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getPermissionPolicy", $$robo$$android_app_admin_DevicePolicyManager$getPermissionPolicy(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean setPermissionGrantState(ComponentName componentName, String string2, String string3, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPermissionGrantState", $$robo$$android_app_admin_DevicePolicyManager$setPermissionGrantState(android.content.ComponentName java.lang.String java.lang.String int ), 0, this, componentName, string2, string3, n);
    }

    public int getPermissionGrantState(ComponentName componentName, String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("getPermissionGrantState", $$robo$$android_app_admin_DevicePolicyManager$getPermissionGrantState(android.content.ComponentName java.lang.String java.lang.String ), 0, this, componentName, string2, string3);
    }

    public boolean isProvisioningAllowed(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isProvisioningAllowed", $$robo$$android_app_admin_DevicePolicyManager$isProvisioningAllowed(java.lang.String ), 0, this, string2);
    }

    public int checkProvisioningPreCondition(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("checkProvisioningPreCondition", $$robo$$android_app_admin_DevicePolicyManager$checkProvisioningPreCondition(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public boolean isManagedProfile(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isManagedProfile", $$robo$$android_app_admin_DevicePolicyManager$isManagedProfile(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isSystemOnlyUser(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSystemOnlyUser", $$robo$$android_app_admin_DevicePolicyManager$isSystemOnlyUser(android.content.ComponentName ), 0, this, componentName);
    }

    public String getWifiMacAddress(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getWifiMacAddress", $$robo$$android_app_admin_DevicePolicyManager$getWifiMacAddress(android.content.ComponentName ), 0, this, componentName);
    }

    public void reboot(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("reboot", $$robo$$android_app_admin_DevicePolicyManager$reboot(android.content.ComponentName ), 0, this, componentName);
    }

    public void setShortSupportMessage(ComponentName componentName, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setShortSupportMessage", $$robo$$android_app_admin_DevicePolicyManager$setShortSupportMessage(android.content.ComponentName java.lang.CharSequence ), 0, this, componentName, charSequence);
    }

    public CharSequence getShortSupportMessage(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getShortSupportMessage", $$robo$$android_app_admin_DevicePolicyManager$getShortSupportMessage(android.content.ComponentName ), 0, this, componentName);
    }

    public void setLongSupportMessage(ComponentName componentName, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setLongSupportMessage", $$robo$$android_app_admin_DevicePolicyManager$setLongSupportMessage(android.content.ComponentName java.lang.CharSequence ), 0, this, componentName, charSequence);
    }

    public CharSequence getLongSupportMessage(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getLongSupportMessage", $$robo$$android_app_admin_DevicePolicyManager$getLongSupportMessage(android.content.ComponentName ), 0, this, componentName);
    }

    public CharSequence getShortSupportMessageForUser(ComponentName componentName, int n) {
        return InvokeDynamicSupport.bootstrap("getShortSupportMessageForUser", $$robo$$android_app_admin_DevicePolicyManager$getShortSupportMessageForUser(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public CharSequence getLongSupportMessageForUser(ComponentName componentName, int n) {
        return InvokeDynamicSupport.bootstrap("getLongSupportMessageForUser", $$robo$$android_app_admin_DevicePolicyManager$getLongSupportMessageForUser(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public DevicePolicyManager getParentProfileInstance(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getParentProfileInstance", $$robo$$android_app_admin_DevicePolicyManager$getParentProfileInstance(android.content.ComponentName ), 0, this, componentName);
    }

    public void setSecurityLoggingEnabled(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setSecurityLoggingEnabled", $$robo$$android_app_admin_DevicePolicyManager$setSecurityLoggingEnabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean isSecurityLoggingEnabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecurityLoggingEnabled", $$robo$$android_app_admin_DevicePolicyManager$isSecurityLoggingEnabled(android.content.ComponentName ), 0, this, componentName);
    }

    public List<SecurityLog.SecurityEvent> retrieveSecurityLogs(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("retrieveSecurityLogs", $$robo$$android_app_admin_DevicePolicyManager$retrieveSecurityLogs(android.content.ComponentName ), 0, this, componentName);
    }

    public long forceSecurityLogs() {
        return (long)InvokeDynamicSupport.bootstrap("forceSecurityLogs", $$robo$$android_app_admin_DevicePolicyManager$forceSecurityLogs(), 0, this);
    }

    public DevicePolicyManager getParentProfileInstance(UserInfo userInfo) {
        return InvokeDynamicSupport.bootstrap("getParentProfileInstance", $$robo$$android_app_admin_DevicePolicyManager$getParentProfileInstance(android.content.pm.UserInfo ), 0, this, userInfo);
    }

    public List<String> setMeteredDataDisabledPackages(ComponentName componentName, List<String> list) {
        return InvokeDynamicSupport.bootstrap("setMeteredDataDisabledPackages", $$robo$$android_app_admin_DevicePolicyManager$setMeteredDataDisabledPackages(android.content.ComponentName java.util.List<java.lang.String> ), 0, this, componentName, list);
    }

    public List<String> getMeteredDataDisabledPackages(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getMeteredDataDisabledPackages", $$robo$$android_app_admin_DevicePolicyManager$getMeteredDataDisabledPackages(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isMeteredDataDisabledPackageForUser(ComponentName componentName, String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isMeteredDataDisabledPackageForUser", $$robo$$android_app_admin_DevicePolicyManager$isMeteredDataDisabledPackageForUser(android.content.ComponentName java.lang.String int ), 0, this, componentName, string2, n);
    }

    public List<SecurityLog.SecurityEvent> retrievePreRebootSecurityLogs(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("retrievePreRebootSecurityLogs", $$robo$$android_app_admin_DevicePolicyManager$retrievePreRebootSecurityLogs(android.content.ComponentName ), 0, this, componentName);
    }

    public void setOrganizationColor(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("setOrganizationColor", $$robo$$android_app_admin_DevicePolicyManager$setOrganizationColor(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setOrganizationColorForUser(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setOrganizationColorForUser", $$robo$$android_app_admin_DevicePolicyManager$setOrganizationColorForUser(int int ), 0, this, n, n2);
    }

    public int getOrganizationColor(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getOrganizationColor", $$robo$$android_app_admin_DevicePolicyManager$getOrganizationColor(android.content.ComponentName ), 0, this, componentName);
    }

    public int getOrganizationColorForUser(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getOrganizationColorForUser", $$robo$$android_app_admin_DevicePolicyManager$getOrganizationColorForUser(int ), 0, this, n);
    }

    public void setOrganizationName(ComponentName componentName, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setOrganizationName", $$robo$$android_app_admin_DevicePolicyManager$setOrganizationName(android.content.ComponentName java.lang.CharSequence ), 0, this, componentName, charSequence);
    }

    public CharSequence getOrganizationName(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getOrganizationName", $$robo$$android_app_admin_DevicePolicyManager$getOrganizationName(android.content.ComponentName ), 0, this, componentName);
    }

    @SystemApi
    public CharSequence getDeviceOwnerOrganizationName() {
        return InvokeDynamicSupport.bootstrap("getDeviceOwnerOrganizationName", $$robo$$android_app_admin_DevicePolicyManager$getDeviceOwnerOrganizationName(), 0, this);
    }

    public CharSequence getOrganizationNameForUser(int n) {
        return InvokeDynamicSupport.bootstrap("getOrganizationNameForUser", $$robo$$android_app_admin_DevicePolicyManager$getOrganizationNameForUser(int ), 0, this, n);
    }

    @SystemApi
    public int getUserProvisioningState() {
        return (int)InvokeDynamicSupport.bootstrap("getUserProvisioningState", $$robo$$android_app_admin_DevicePolicyManager$getUserProvisioningState(), 0, this);
    }

    public void setUserProvisioningState(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setUserProvisioningState", $$robo$$android_app_admin_DevicePolicyManager$setUserProvisioningState(int int ), 0, this, n, n2);
    }

    public void setAffiliationIds(ComponentName componentName, Set<String> set) {
        InvokeDynamicSupport.bootstrap("setAffiliationIds", $$robo$$android_app_admin_DevicePolicyManager$setAffiliationIds(android.content.ComponentName java.util.Set<java.lang.String> ), 0, this, componentName, set);
    }

    public Set<String> getAffiliationIds(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getAffiliationIds", $$robo$$android_app_admin_DevicePolicyManager$getAffiliationIds(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isAffiliatedUser() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAffiliatedUser", $$robo$$android_app_admin_DevicePolicyManager$isAffiliatedUser(), 0, this);
    }

    public boolean isUninstallInQueue(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUninstallInQueue", $$robo$$android_app_admin_DevicePolicyManager$isUninstallInQueue(java.lang.String ), 0, this, string2);
    }

    public void uninstallPackageWithActiveAdmins(String string2) {
        InvokeDynamicSupport.bootstrap("uninstallPackageWithActiveAdmins", $$robo$$android_app_admin_DevicePolicyManager$uninstallPackageWithActiveAdmins(java.lang.String ), 0, this, string2);
    }

    public void forceRemoveActiveAdmin(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("forceRemoveActiveAdmin", $$robo$$android_app_admin_DevicePolicyManager$forceRemoveActiveAdmin(android.content.ComponentName int ), 0, this, componentName, n);
    }

    @SystemApi
    public boolean isDeviceProvisioned() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceProvisioned", $$robo$$android_app_admin_DevicePolicyManager$isDeviceProvisioned(), 0, this);
    }

    @SystemApi
    public void setDeviceProvisioningConfigApplied() {
        InvokeDynamicSupport.bootstrap("setDeviceProvisioningConfigApplied", $$robo$$android_app_admin_DevicePolicyManager$setDeviceProvisioningConfigApplied(), 0, this);
    }

    @SystemApi
    public boolean isDeviceProvisioningConfigApplied() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceProvisioningConfigApplied", $$robo$$android_app_admin_DevicePolicyManager$isDeviceProvisioningConfigApplied(), 0, this);
    }

    public void forceUpdateUserSetupComplete() {
        InvokeDynamicSupport.bootstrap("forceUpdateUserSetupComplete", $$robo$$android_app_admin_DevicePolicyManager$forceUpdateUserSetupComplete(), 0, this);
    }

    private void throwIfParentInstance(String string2) {
        InvokeDynamicSupport.bootstrap("throwIfParentInstance", $$robo$$android_app_admin_DevicePolicyManager$throwIfParentInstance(java.lang.String ), 0, this, string2);
    }

    public void setBackupServiceEnabled(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setBackupServiceEnabled", $$robo$$android_app_admin_DevicePolicyManager$setBackupServiceEnabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean isBackupServiceEnabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isBackupServiceEnabled", $$robo$$android_app_admin_DevicePolicyManager$isBackupServiceEnabled(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean setMandatoryBackupTransport(ComponentName componentName, ComponentName componentName2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setMandatoryBackupTransport", $$robo$$android_app_admin_DevicePolicyManager$setMandatoryBackupTransport(android.content.ComponentName android.content.ComponentName ), 0, this, componentName, componentName2);
    }

    public ComponentName getMandatoryBackupTransport() {
        return InvokeDynamicSupport.bootstrap("getMandatoryBackupTransport", $$robo$$android_app_admin_DevicePolicyManager$getMandatoryBackupTransport(), 0, this);
    }

    public void setNetworkLoggingEnabled(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setNetworkLoggingEnabled", $$robo$$android_app_admin_DevicePolicyManager$setNetworkLoggingEnabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean isNetworkLoggingEnabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNetworkLoggingEnabled", $$robo$$android_app_admin_DevicePolicyManager$isNetworkLoggingEnabled(android.content.ComponentName ), 0, this, componentName);
    }

    public List<NetworkEvent> retrieveNetworkLogs(ComponentName componentName, long l) {
        return InvokeDynamicSupport.bootstrap("retrieveNetworkLogs", $$robo$$android_app_admin_DevicePolicyManager$retrieveNetworkLogs(android.content.ComponentName long ), 0, this, componentName, l);
    }

    public boolean bindDeviceAdminServiceAsUser(ComponentName componentName, Intent intent, ServiceConnection serviceConnection, int n, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("bindDeviceAdminServiceAsUser", $$robo$$android_app_admin_DevicePolicyManager$bindDeviceAdminServiceAsUser(android.content.ComponentName android.content.Intent android.content.ServiceConnection int android.os.UserHandle ), 0, this, componentName, intent, serviceConnection, n, userHandle);
    }

    public List<UserHandle> getBindDeviceAdminTargetUsers(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getBindDeviceAdminTargetUsers", $$robo$$android_app_admin_DevicePolicyManager$getBindDeviceAdminTargetUsers(android.content.ComponentName ), 0, this, componentName);
    }

    public long getLastSecurityLogRetrievalTime() {
        return (long)InvokeDynamicSupport.bootstrap("getLastSecurityLogRetrievalTime", $$robo$$android_app_admin_DevicePolicyManager$getLastSecurityLogRetrievalTime(), 0, this);
    }

    public long getLastBugReportRequestTime() {
        return (long)InvokeDynamicSupport.bootstrap("getLastBugReportRequestTime", $$robo$$android_app_admin_DevicePolicyManager$getLastBugReportRequestTime(), 0, this);
    }

    public long getLastNetworkLogRetrievalTime() {
        return (long)InvokeDynamicSupport.bootstrap("getLastNetworkLogRetrievalTime", $$robo$$android_app_admin_DevicePolicyManager$getLastNetworkLogRetrievalTime(), 0, this);
    }

    public boolean isCurrentInputMethodSetByOwner() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCurrentInputMethodSetByOwner", $$robo$$android_app_admin_DevicePolicyManager$isCurrentInputMethodSetByOwner(), 0, this);
    }

    public List<String> getOwnerInstalledCaCerts(UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getOwnerInstalledCaCerts", $$robo$$android_app_admin_DevicePolicyManager$getOwnerInstalledCaCerts(android.os.UserHandle ), 0, this, userHandle);
    }

    public void clearApplicationUserData(ComponentName componentName, String string2, Executor executor, OnClearApplicationUserDataListener onClearApplicationUserDataListener) {
        InvokeDynamicSupport.bootstrap("clearApplicationUserData", $$robo$$android_app_admin_DevicePolicyManager$clearApplicationUserData(android.content.ComponentName java.lang.String java.util.concurrent.Executor android.app.admin.DevicePolicyManager$OnClearApplicationUserDataListener ), 0, this, componentName, string2, executor, onClearApplicationUserDataListener);
    }

    public void setLogoutEnabled(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setLogoutEnabled", $$robo$$android_app_admin_DevicePolicyManager$setLogoutEnabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean isLogoutEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLogoutEnabled", $$robo$$android_app_admin_DevicePolicyManager$isLogoutEnabled(), 0, this);
    }

    public Set<String> getDisallowedSystemApps(ComponentName componentName, int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getDisallowedSystemApps", $$robo$$android_app_admin_DevicePolicyManager$getDisallowedSystemApps(android.content.ComponentName int java.lang.String ), 0, this, componentName, n, string2);
    }

    public void transferOwnership(ComponentName componentName, ComponentName componentName2, PersistableBundle persistableBundle) {
        InvokeDynamicSupport.bootstrap("transferOwnership", $$robo$$android_app_admin_DevicePolicyManager$transferOwnership(android.content.ComponentName android.content.ComponentName android.os.PersistableBundle ), 0, this, componentName, componentName2, persistableBundle);
    }

    public void setStartUserSessionMessage(ComponentName componentName, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setStartUserSessionMessage", $$robo$$android_app_admin_DevicePolicyManager$setStartUserSessionMessage(android.content.ComponentName java.lang.CharSequence ), 0, this, componentName, charSequence);
    }

    public void setEndUserSessionMessage(ComponentName componentName, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setEndUserSessionMessage", $$robo$$android_app_admin_DevicePolicyManager$setEndUserSessionMessage(android.content.ComponentName java.lang.CharSequence ), 0, this, componentName, charSequence);
    }

    public CharSequence getStartUserSessionMessage(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getStartUserSessionMessage", $$robo$$android_app_admin_DevicePolicyManager$getStartUserSessionMessage(android.content.ComponentName ), 0, this, componentName);
    }

    public CharSequence getEndUserSessionMessage(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getEndUserSessionMessage", $$robo$$android_app_admin_DevicePolicyManager$getEndUserSessionMessage(android.content.ComponentName ), 0, this, componentName);
    }

    public int addOverrideApn(ComponentName componentName, ApnSetting apnSetting) {
        return (int)InvokeDynamicSupport.bootstrap("addOverrideApn", $$robo$$android_app_admin_DevicePolicyManager$addOverrideApn(android.content.ComponentName android.telephony.data.ApnSetting ), 0, this, componentName, apnSetting);
    }

    public boolean updateOverrideApn(ComponentName componentName, int n, ApnSetting apnSetting) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateOverrideApn", $$robo$$android_app_admin_DevicePolicyManager$updateOverrideApn(android.content.ComponentName int android.telephony.data.ApnSetting ), 0, this, componentName, n, apnSetting);
    }

    public boolean removeOverrideApn(ComponentName componentName, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeOverrideApn", $$robo$$android_app_admin_DevicePolicyManager$removeOverrideApn(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public List<ApnSetting> getOverrideApns(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getOverrideApns", $$robo$$android_app_admin_DevicePolicyManager$getOverrideApns(android.content.ComponentName ), 0, this, componentName);
    }

    public void setOverrideApnsEnabled(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setOverrideApnsEnabled", $$robo$$android_app_admin_DevicePolicyManager$setOverrideApnsEnabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public boolean isOverrideApnEnabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverrideApnEnabled", $$robo$$android_app_admin_DevicePolicyManager$isOverrideApnEnabled(android.content.ComponentName ), 0, this, componentName);
    }

    public PersistableBundle getTransferOwnershipBundle() {
        return InvokeDynamicSupport.bootstrap("getTransferOwnershipBundle", $$robo$$android_app_admin_DevicePolicyManager$getTransferOwnershipBundle(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(DevicePolicyManager.class);
    }

    public /* synthetic */ DevicePolicyManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DevicePolicyManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnClearApplicationUserDataListener
    extends InstrumentedInterface {
        public void onApplicationUserDataCleared(String var1, boolean var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SystemSettingsWhitelist {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CreateAndManageUserFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LockNowFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AttestationIdType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LockTaskFeature {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProvisioningPreCondition {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserProvisioningState {
    }
}

