/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.app.admin.SystemUpdatePolicy;
import android.util.Log;
import android.util.Pair;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FreezePeriod
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "FreezePeriod";
    private static int DUMMY_YEAR = 2001;
    static int DAYS_IN_YEAR = 365;
    private MonthDay mStart;
    private MonthDay mEnd;
    private int mStartDay;
    private int mEndDay;

    private void $$robo$$android_app_admin_FreezePeriod$__constructor__(MonthDay start, MonthDay end) {
        this.mStart = start;
        this.mStartDay = this.mStart.atYear(2001).getDayOfYear();
        this.mEnd = end;
        this.mEndDay = this.mEnd.atYear(2001).getDayOfYear();
    }

    private final MonthDay $$robo$$android_app_admin_FreezePeriod$getStart() {
        return this.mStart;
    }

    private final MonthDay $$robo$$android_app_admin_FreezePeriod$getEnd() {
        return this.mEnd;
    }

    private void $$robo$$android_app_admin_FreezePeriod$__constructor__(int startDay, int endDay) {
        this.mStartDay = startDay;
        this.mStart = FreezePeriod.dayOfYearToMonthDay(startDay);
        this.mEndDay = endDay;
        this.mEnd = FreezePeriod.dayOfYearToMonthDay(endDay);
    }

    private final int $$robo$$android_app_admin_FreezePeriod$getLength() {
        return this.getEffectiveEndDay() - this.mStartDay + 1;
    }

    private final boolean $$robo$$android_app_admin_FreezePeriod$isWrapped() {
        return this.mEndDay < this.mStartDay;
    }

    private final int $$robo$$android_app_admin_FreezePeriod$getEffectiveEndDay() {
        if (!this.isWrapped()) {
            return this.mEndDay;
        }
        return this.mEndDay + 365;
    }

    private final boolean $$robo$$android_app_admin_FreezePeriod$contains(LocalDate localDate) {
        int daysOfYear = FreezePeriod.dayOfYearDisregardLeapYear(localDate);
        if (!this.isWrapped()) {
            return this.mStartDay <= daysOfYear && daysOfYear <= this.mEndDay;
        }
        return this.mStartDay <= daysOfYear || daysOfYear <= this.mEndDay;
    }

    private final boolean $$robo$$android_app_admin_FreezePeriod$after(LocalDate localDate) {
        return this.mStartDay > FreezePeriod.dayOfYearDisregardLeapYear(localDate);
    }

    private final Pair<LocalDate, LocalDate> $$robo$$android_app_admin_FreezePeriod$toCurrentOrFutureRealDates(LocalDate now) {
        int endYearAdjustment;
        int startYearAdjustment;
        int nowDays = FreezePeriod.dayOfYearDisregardLeapYear(now);
        if (this.contains(now)) {
            if (this.mStartDay <= nowDays) {
                startYearAdjustment = 0;
                endYearAdjustment = this.isWrapped() ? 1 : 0;
            } else {
                startYearAdjustment = -1;
                endYearAdjustment = 0;
            }
        } else if (this.mStartDay > nowDays) {
            startYearAdjustment = 0;
            endYearAdjustment = this.isWrapped() ? 1 : 0;
        } else {
            startYearAdjustment = 1;
            endYearAdjustment = 1;
        }
        LocalDate startDate = LocalDate.ofYearDay(2001, this.mStartDay).withYear(now.getYear() + startYearAdjustment);
        LocalDate endDate = LocalDate.ofYearDay(2001, this.mEndDay).withYear(now.getYear() + endYearAdjustment);
        return new Pair<LocalDate, LocalDate>(startDate, endDate);
    }

    private final String $$robo$$android_app_admin_FreezePeriod$toString() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMM dd");
        return LocalDate.ofYearDay(2001, this.mStartDay).format(formatter) + " - " + LocalDate.ofYearDay(2001, this.mEndDay).format(formatter);
    }

    private static final MonthDay $$robo$$android_app_admin_FreezePeriod$dayOfYearToMonthDay(int dayOfYear) {
        LocalDate date = LocalDate.ofYearDay(2001, dayOfYear);
        return MonthDay.of(date.getMonth(), date.getDayOfMonth());
    }

    private static final int $$robo$$android_app_admin_FreezePeriod$dayOfYearDisregardLeapYear(LocalDate date) {
        return date.withYear(2001).getDayOfYear();
    }

    private static final int $$robo$$android_app_admin_FreezePeriod$distanceWithoutLeapYear(LocalDate first, LocalDate second) {
        return FreezePeriod.dayOfYearDisregardLeapYear(first) - FreezePeriod.dayOfYearDisregardLeapYear(second) + 365 * (first.getYear() - second.getYear());
    }

    private static final List<FreezePeriod> $$robo$$android_app_admin_FreezePeriod$canonicalizePeriods(List<FreezePeriod> intervals) {
        boolean[] taken = new boolean[365];
        for (FreezePeriod interval : intervals) {
            for (int i = interval.mStartDay; i <= interval.getEffectiveEndDay(); ++i) {
                taken[(i - 1) % 365] = true;
            }
        }
        ArrayList<FreezePeriod> result = new ArrayList<FreezePeriod>();
        int i = 0;
        while (i < 365) {
            if (!taken[i]) {
                ++i;
                continue;
            }
            int intervalStart = i + 1;
            while (i < 365 && taken[i]) {
                ++i;
            }
            result.add(new FreezePeriod(intervalStart, i));
        }
        int lastIndex = result.size() - 1;
        if (lastIndex > 0 && ((FreezePeriod)result.get((int)lastIndex)).mEndDay == 365 && ((FreezePeriod)result.get((int)0)).mStartDay == 1) {
            FreezePeriod wrappedInterval = new FreezePeriod(((FreezePeriod)result.get((int)lastIndex)).mStartDay, ((FreezePeriod)result.get((int)0)).mEndDay);
            result.set(lastIndex, wrappedInterval);
            result.remove(0);
        }
        return result;
    }

    private static final void $$robo$$android_app_admin_FreezePeriod$validatePeriods(List<FreezePeriod> periods) {
        List<FreezePeriod> allPeriods = FreezePeriod.canonicalizePeriods(periods);
        if (allPeriods.size() != periods.size()) {
            throw SystemUpdatePolicy.ValidationFailedException.duplicateOrOverlapPeriods();
        }
        for (int i = 0; i < allPeriods.size(); ++i) {
            int separation;
            FreezePeriod previous;
            FreezePeriod current = allPeriods.get(i);
            if (current.getLength() > 90) {
                throw SystemUpdatePolicy.ValidationFailedException.freezePeriodTooLong("Freeze period " + current + " is too long: " + current.getLength() + " days");
            }
            FreezePeriod freezePeriod = previous = i > 0 ? allPeriods.get(i - 1) : allPeriods.get(allPeriods.size() - 1);
            if (previous == current || (separation = i == 0 && !previous.isWrapped() ? current.mStartDay + (365 - previous.mEndDay) - 1 : current.mStartDay - previous.mEndDay - 1) >= 60) continue;
            throw SystemUpdatePolicy.ValidationFailedException.freezePeriodTooClose("Freeze periods " + previous + " and " + current + " are too close together: " + separation + " days apart");
        }
    }

    private static final void $$robo$$android_app_admin_FreezePeriod$validateAgainstPreviousFreezePeriod(List<FreezePeriod> periods, LocalDate prevPeriodStart, LocalDate prevPeriodEnd, LocalDate now) {
        if (periods.size() == 0 || prevPeriodStart == null || prevPeriodEnd == null) {
            return;
        }
        if (prevPeriodStart.isAfter(now) || prevPeriodEnd.isAfter(now)) {
            Log.w("FreezePeriod", "Previous period (" + prevPeriodStart + "," + prevPeriodEnd + ") is after current date " + now);
        }
        List<FreezePeriod> allPeriods = FreezePeriod.canonicalizePeriods(periods);
        FreezePeriod curOrNextFreezePeriod = allPeriods.get(0);
        for (FreezePeriod interval : allPeriods) {
            if (!interval.contains(now) && interval.mStartDay <= FreezePeriod.dayOfYearDisregardLeapYear(now)) continue;
            curOrNextFreezePeriod = interval;
            break;
        }
        Pair<LocalDate, LocalDate> curOrNextFreezeDates = curOrNextFreezePeriod.toCurrentOrFutureRealDates(now);
        if (now.isAfter((ChronoLocalDate)curOrNextFreezeDates.first)) {
            curOrNextFreezeDates = new Pair<LocalDate, LocalDate>(now, (LocalDate)curOrNextFreezeDates.second);
        }
        if (((LocalDate)curOrNextFreezeDates.first).isAfter((ChronoLocalDate)curOrNextFreezeDates.second)) {
            throw new IllegalStateException("Current freeze dates inverted: " + curOrNextFreezeDates.first + "-" + curOrNextFreezeDates.second);
        }
        String periodsDescription = "Prev: " + prevPeriodStart + "," + prevPeriodEnd + "; cur: " + curOrNextFreezeDates.first + "," + curOrNextFreezeDates.second;
        long separation = FreezePeriod.distanceWithoutLeapYear((LocalDate)curOrNextFreezeDates.first, prevPeriodEnd) - 1;
        if (separation > 0L) {
            if (separation < 60L) {
                throw SystemUpdatePolicy.ValidationFailedException.combinedPeriodTooClose("Previous freeze period too close to new period: " + separation + ", " + periodsDescription);
            }
        } else {
            long length = FreezePeriod.distanceWithoutLeapYear((LocalDate)curOrNextFreezeDates.second, prevPeriodStart) + 1;
            if (length > 90L) {
                throw SystemUpdatePolicy.ValidationFailedException.combinedPeriodTooLong("Combined freeze period exceeds maximum days: " + length + ", " + periodsDescription);
            }
        }
    }

    private void __constructor__(MonthDay monthDay, MonthDay monthDay2) {
        this.$$robo$$android_app_admin_FreezePeriod$__constructor__(monthDay, monthDay2);
    }

    public FreezePeriod(MonthDay monthDay, MonthDay monthDay2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_FreezePeriod$__constructor__(java.time.MonthDay java.time.MonthDay ), 0, this, monthDay, monthDay2);
    }

    public MonthDay getStart() {
        return InvokeDynamicSupport.bootstrap("getStart", $$robo$$android_app_admin_FreezePeriod$getStart(), 0, this);
    }

    public MonthDay getEnd() {
        return InvokeDynamicSupport.bootstrap("getEnd", $$robo$$android_app_admin_FreezePeriod$getEnd(), 0, this);
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_app_admin_FreezePeriod$__constructor__(n, n2);
    }

    private FreezePeriod(int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_FreezePeriod$__constructor__(int int ), 0, this, n, n2);
    }

    int getLength() {
        return (int)InvokeDynamicSupport.bootstrap("getLength", $$robo$$android_app_admin_FreezePeriod$getLength(), 0, this);
    }

    boolean isWrapped() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWrapped", $$robo$$android_app_admin_FreezePeriod$isWrapped(), 0, this);
    }

    int getEffectiveEndDay() {
        return (int)InvokeDynamicSupport.bootstrap("getEffectiveEndDay", $$robo$$android_app_admin_FreezePeriod$getEffectiveEndDay(), 0, this);
    }

    boolean contains(LocalDate localDate) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_app_admin_FreezePeriod$contains(java.time.LocalDate ), 0, this, localDate);
    }

    boolean after(LocalDate localDate) {
        return (boolean)InvokeDynamicSupport.bootstrap("after", $$robo$$android_app_admin_FreezePeriod$after(java.time.LocalDate ), 0, this, localDate);
    }

    Pair<LocalDate, LocalDate> toCurrentOrFutureRealDates(LocalDate localDate) {
        return InvokeDynamicSupport.bootstrap("toCurrentOrFutureRealDates", $$robo$$android_app_admin_FreezePeriod$toCurrentOrFutureRealDates(java.time.LocalDate ), 0, this, localDate);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_admin_FreezePeriod$toString(), 0, this);
    }

    private static MonthDay dayOfYearToMonthDay(int n) {
        return InvokeDynamicSupport.bootstrapStatic("dayOfYearToMonthDay", $$robo$$android_app_admin_FreezePeriod$dayOfYearToMonthDay(int ), 0, (int)n);
    }

    private static int dayOfYearDisregardLeapYear(LocalDate localDate) {
        return (int)InvokeDynamicSupport.bootstrapStatic("dayOfYearDisregardLeapYear", $$robo$$android_app_admin_FreezePeriod$dayOfYearDisregardLeapYear(java.time.LocalDate ), 0, (LocalDate)localDate);
    }

    public static int distanceWithoutLeapYear(LocalDate localDate, LocalDate localDate2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("distanceWithoutLeapYear", $$robo$$android_app_admin_FreezePeriod$distanceWithoutLeapYear(java.time.LocalDate java.time.LocalDate ), 0, (LocalDate)localDate, (LocalDate)localDate2);
    }

    static List<FreezePeriod> canonicalizePeriods(List<FreezePeriod> list) {
        return InvokeDynamicSupport.bootstrapStatic("canonicalizePeriods", $$robo$$android_app_admin_FreezePeriod$canonicalizePeriods(java.util.List<android.app.admin.FreezePeriod> ), 0, list);
    }

    static void validatePeriods(List<FreezePeriod> list) {
        InvokeDynamicSupport.bootstrapStatic("validatePeriods", $$robo$$android_app_admin_FreezePeriod$validatePeriods(java.util.List<android.app.admin.FreezePeriod> ), 0, list);
    }

    static void validateAgainstPreviousFreezePeriod(List<FreezePeriod> list, LocalDate localDate, LocalDate localDate2, LocalDate localDate3) {
        InvokeDynamicSupport.bootstrapStatic("validateAgainstPreviousFreezePeriod", $$robo$$android_app_admin_FreezePeriod$validateAgainstPreviousFreezePeriod(java.util.List<android.app.admin.FreezePeriod> java.time.LocalDate java.time.LocalDate java.time.LocalDate ), 0, list, (LocalDate)localDate, (LocalDate)localDate2, (LocalDate)localDate3);
    }

    public /* synthetic */ FreezePeriod() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FreezePeriod)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

