/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.annotation.SystemApi;
import android.app.admin.FreezePeriod;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.Pair;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SystemUpdatePolicy
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SystemUpdatePolicy";
    private static int TYPE_UNKNOWN = -1;
    public static int TYPE_INSTALL_AUTOMATIC = 1;
    public static int TYPE_INSTALL_WINDOWED = 2;
    public static int TYPE_POSTPONE = 3;
    @SystemApi
    public static int TYPE_PAUSE = 4;
    private static String KEY_POLICY_TYPE = "policy_type";
    private static String KEY_INSTALL_WINDOW_START = "install_window_start";
    private static String KEY_INSTALL_WINDOW_END = "install_window_end";
    private static String KEY_FREEZE_TAG = "freeze";
    private static String KEY_FREEZE_START = "start";
    private static String KEY_FREEZE_END = "end";
    private static int WINDOW_BOUNDARY = 1440;
    static int FREEZE_PERIOD_MAX_LENGTH = 90;
    static int FREEZE_PERIOD_MIN_SEPARATION = 60;
    private int mPolicyType;
    private int mMaintenanceWindowStart;
    private int mMaintenanceWindowEnd;
    private ArrayList<FreezePeriod> mFreezePeriods;
    @SystemApi
    public static Parcelable.Creator<SystemUpdatePolicy> CREATOR;

    private void $$robo$$android_app_admin_SystemUpdatePolicy$__constructor__() {
        this.mPolicyType = -1;
        this.mFreezePeriods = new ArrayList();
    }

    private static final SystemUpdatePolicy $$robo$$android_app_admin_SystemUpdatePolicy$createAutomaticInstallPolicy() {
        SystemUpdatePolicy policy = new SystemUpdatePolicy();
        policy.mPolicyType = 1;
        return policy;
    }

    private static final SystemUpdatePolicy $$robo$$android_app_admin_SystemUpdatePolicy$createWindowedInstallPolicy(int startTime, int endTime) {
        if (startTime < 0 || startTime >= 1440 || endTime < 0 || endTime >= 1440) {
            throw new IllegalArgumentException("startTime and endTime must be inside [0, 1440)");
        }
        SystemUpdatePolicy policy = new SystemUpdatePolicy();
        policy.mPolicyType = 2;
        policy.mMaintenanceWindowStart = startTime;
        policy.mMaintenanceWindowEnd = endTime;
        return policy;
    }

    private static final SystemUpdatePolicy $$robo$$android_app_admin_SystemUpdatePolicy$createPostponeInstallPolicy() {
        SystemUpdatePolicy policy = new SystemUpdatePolicy();
        policy.mPolicyType = 3;
        return policy;
    }

    private final int $$robo$$android_app_admin_SystemUpdatePolicy$getPolicyType() {
        return this.mPolicyType;
    }

    private final int $$robo$$android_app_admin_SystemUpdatePolicy$getInstallWindowStart() {
        if (this.mPolicyType == 2) {
            return this.mMaintenanceWindowStart;
        }
        return -1;
    }

    private final int $$robo$$android_app_admin_SystemUpdatePolicy$getInstallWindowEnd() {
        if (this.mPolicyType == 2) {
            return this.mMaintenanceWindowEnd;
        }
        return -1;
    }

    private final boolean $$robo$$android_app_admin_SystemUpdatePolicy$isValid() {
        try {
            this.validateType();
            this.validateFreezePeriods();
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private final void $$robo$$android_app_admin_SystemUpdatePolicy$validateType() {
        if (this.mPolicyType == 1 || this.mPolicyType == 3) {
            return;
        }
        if (this.mPolicyType == 2) {
            if (this.mMaintenanceWindowStart < 0 || this.mMaintenanceWindowStart >= 1440 || this.mMaintenanceWindowEnd < 0 || this.mMaintenanceWindowEnd >= 1440) {
                throw new IllegalArgumentException("Invalid maintenance window");
            }
        } else {
            throw new IllegalArgumentException("Invalid system update policy type.");
        }
    }

    private final SystemUpdatePolicy $$robo$$android_app_admin_SystemUpdatePolicy$setFreezePeriods(List<FreezePeriod> freezePeriods) {
        FreezePeriod.validatePeriods(freezePeriods);
        this.mFreezePeriods.clear();
        this.mFreezePeriods.addAll(freezePeriods);
        return this;
    }

    private final List<FreezePeriod> $$robo$$android_app_admin_SystemUpdatePolicy$getFreezePeriods() {
        return Collections.unmodifiableList(this.mFreezePeriods);
    }

    private final Pair<LocalDate, LocalDate> $$robo$$android_app_admin_SystemUpdatePolicy$getCurrentFreezePeriod(LocalDate now) {
        for (FreezePeriod interval : this.mFreezePeriods) {
            if (!interval.contains(now)) continue;
            return interval.toCurrentOrFutureRealDates(now);
        }
        return null;
    }

    private final long $$robo$$android_app_admin_SystemUpdatePolicy$timeUntilNextFreezePeriod(long now) {
        List<FreezePeriod> sortedPeriods = FreezePeriod.canonicalizePeriods(this.mFreezePeriods);
        LocalDate nowDate = SystemUpdatePolicy.millisToDate(now);
        LocalDate nextFreezeStart = null;
        for (FreezePeriod interval : sortedPeriods) {
            if (interval.after(nowDate)) {
                nextFreezeStart = (LocalDate)interval.toCurrentOrFutureRealDates((LocalDate)nowDate).first;
                break;
            }
            if (!interval.contains(nowDate)) continue;
            throw new IllegalArgumentException("Given date is inside a freeze period");
        }
        if (nextFreezeStart == null) {
            nextFreezeStart = (LocalDate)sortedPeriods.get((int)0).toCurrentOrFutureRealDates((LocalDate)nowDate).first;
        }
        return SystemUpdatePolicy.dateToMillis(nextFreezeStart) - now;
    }

    private final void $$robo$$android_app_admin_SystemUpdatePolicy$validateFreezePeriods() {
        FreezePeriod.validatePeriods(this.mFreezePeriods);
    }

    private final void $$robo$$android_app_admin_SystemUpdatePolicy$validateAgainstPreviousFreezePeriod(LocalDate prevPeriodStart, LocalDate prevPeriodEnd, LocalDate now) {
        FreezePeriod.validateAgainstPreviousFreezePeriod(this.mFreezePeriods, prevPeriodStart, prevPeriodEnd, now);
    }

    @SystemApi
    private final InstallationOption $$robo$$android_app_admin_SystemUpdatePolicy$getInstallationOptionAt(long when) {
        LocalDate whenDate = SystemUpdatePolicy.millisToDate(when);
        Pair<LocalDate, LocalDate> current = this.getCurrentFreezePeriod(whenDate);
        if (current != null) {
            return new InstallationOption(4, SystemUpdatePolicy.dateToMillis(SystemUpdatePolicy.roundUpLeapDay((LocalDate)current.second).plusDays(1L)) - when);
        }
        InstallationOption option = this.getInstallationOptionRegardlessFreezeAt(when);
        if (this.mFreezePeriods.size() > 0) {
            option.limitEffectiveTime(this.timeUntilNextFreezePeriod(when));
        }
        return option;
    }

    private final InstallationOption $$robo$$android_app_admin_SystemUpdatePolicy$getInstallationOptionRegardlessFreezeAt(long when) {
        if (this.mPolicyType == 1 || this.mPolicyType == 3) {
            return new InstallationOption(this.mPolicyType, Long.MAX_VALUE);
        }
        if (this.mPolicyType == 2) {
            Calendar query = Calendar.getInstance();
            query.setTimeInMillis(when);
            long whenMillis = TimeUnit.HOURS.toMillis(query.get(11)) + TimeUnit.MINUTES.toMillis(query.get(12)) + TimeUnit.SECONDS.toMillis(query.get(13)) + (long)query.get(14);
            long windowStartMillis = TimeUnit.MINUTES.toMillis(this.mMaintenanceWindowStart);
            long windowEndMillis = TimeUnit.MINUTES.toMillis(this.mMaintenanceWindowEnd);
            long dayInMillis = TimeUnit.DAYS.toMillis(1L);
            if (windowStartMillis <= whenMillis && whenMillis <= windowEndMillis || windowStartMillis > windowEndMillis && (windowStartMillis <= whenMillis || whenMillis <= windowEndMillis)) {
                return new InstallationOption(1, (windowEndMillis - whenMillis + dayInMillis) % dayInMillis);
            }
            return new InstallationOption(4, (windowStartMillis - whenMillis + dayInMillis) % dayInMillis);
        }
        throw new RuntimeException("Unknown policy type");
    }

    private static final LocalDate $$robo$$android_app_admin_SystemUpdatePolicy$roundUpLeapDay(LocalDate date) {
        if (date.isLeapYear() && date.getMonthValue() == 2 && date.getDayOfMonth() == 28) {
            return date.plusDays(1L);
        }
        return date;
    }

    private static final LocalDate $$robo$$android_app_admin_SystemUpdatePolicy$millisToDate(long when) {
        return Instant.ofEpochMilli(when).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    private static final long $$robo$$android_app_admin_SystemUpdatePolicy$dateToMillis(LocalDate when) {
        return LocalDateTime.of(when, LocalTime.MIN).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    private final String $$robo$$android_app_admin_SystemUpdatePolicy$toString() {
        return String.format("SystemUpdatePolicy (type: %d, windowStart: %d, windowEnd: %d, freezes: [%s])", this.mPolicyType, this.mMaintenanceWindowStart, this.mMaintenanceWindowEnd, this.mFreezePeriods.stream().map(n -> n.toString()).collect(Collectors.joining(",")));
    }

    @SystemApi
    private final int $$robo$$android_app_admin_SystemUpdatePolicy$describeContents() {
        return 0;
    }

    @SystemApi
    private final void $$robo$$android_app_admin_SystemUpdatePolicy$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mPolicyType);
        dest.writeInt(this.mMaintenanceWindowStart);
        dest.writeInt(this.mMaintenanceWindowEnd);
        int freezeCount = this.mFreezePeriods.size();
        dest.writeInt(freezeCount);
        for (int i = 0; i < freezeCount; ++i) {
            FreezePeriod interval = this.mFreezePeriods.get(i);
            dest.writeInt(interval.getStart().getMonthValue());
            dest.writeInt(interval.getStart().getDayOfMonth());
            dest.writeInt(interval.getEnd().getMonthValue());
            dest.writeInt(interval.getEnd().getDayOfMonth());
        }
    }

    private static final SystemUpdatePolicy $$robo$$android_app_admin_SystemUpdatePolicy$restoreFromXml(XmlPullParser parser) {
        try {
            SystemUpdatePolicy policy = new SystemUpdatePolicy();
            String value = parser.getAttributeValue(null, "policy_type");
            if (value != null) {
                int type;
                policy.mPolicyType = Integer.parseInt(value);
                value = parser.getAttributeValue(null, "install_window_start");
                if (value != null) {
                    policy.mMaintenanceWindowStart = Integer.parseInt(value);
                }
                if ((value = parser.getAttributeValue(null, "install_window_end")) != null) {
                    policy.mMaintenanceWindowEnd = Integer.parseInt(value);
                }
                int outerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                    if (type == 3 || type == 4 || !parser.getName().equals("freeze")) continue;
                    policy.mFreezePeriods.add(new FreezePeriod(MonthDay.parse(parser.getAttributeValue(null, "start")), MonthDay.parse(parser.getAttributeValue(null, "end"))));
                }
                return policy;
            }
        }
        catch (IOException | NumberFormatException | XmlPullParserException e) {
            Log.w("SystemUpdatePolicy", "Load xml failed", e);
        }
        return null;
    }

    private final void $$robo$$android_app_admin_SystemUpdatePolicy$saveToXml(XmlSerializer out) throws IOException {
        out.attribute(null, "policy_type", Integer.toString(this.mPolicyType));
        out.attribute(null, "install_window_start", Integer.toString(this.mMaintenanceWindowStart));
        out.attribute(null, "install_window_end", Integer.toString(this.mMaintenanceWindowEnd));
        for (int i = 0; i < this.mFreezePeriods.size(); ++i) {
            FreezePeriod interval = this.mFreezePeriods.get(i);
            out.startTag(null, "freeze");
            out.attribute(null, "start", interval.getStart().toString());
            out.attribute(null, "end", interval.getEnd().toString());
            out.endTag(null, "freeze");
        }
    }

    private /* synthetic */ void $$robo$$android_app_admin_SystemUpdatePolicy$__constructor__(1 x0) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<SystemUpdatePolicy>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_admin_SystemUpdatePolicy_1$__constructor__() {
            }

            private final SystemUpdatePolicy $$robo$$android_app_admin_SystemUpdatePolicy_1$createFromParcel(Parcel source) {
                SystemUpdatePolicy policy = new SystemUpdatePolicy();
                policy.mPolicyType = source.readInt();
                policy.mMaintenanceWindowStart = source.readInt();
                policy.mMaintenanceWindowEnd = source.readInt();
                int freezeCount = source.readInt();
                policy.mFreezePeriods.ensureCapacity(freezeCount);
                for (int i = 0; i < freezeCount; ++i) {
                    MonthDay start = MonthDay.of(source.readInt(), source.readInt());
                    MonthDay end = MonthDay.of(source.readInt(), source.readInt());
                    policy.mFreezePeriods.add(new FreezePeriod(start, end));
                }
                return policy;
            }

            private final SystemUpdatePolicy[] $$robo$$android_app_admin_SystemUpdatePolicy_1$newArray(int size) {
                return new SystemUpdatePolicy[size];
            }

            private void __constructor__() {
                this.$$robo$$android_app_admin_SystemUpdatePolicy_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_SystemUpdatePolicy_1$__constructor__(), 0, this);
            }

            @Override
            public SystemUpdatePolicy createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_admin_SystemUpdatePolicy_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public SystemUpdatePolicy[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_admin_SystemUpdatePolicy_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_app_admin_SystemUpdatePolicy$__constructor__();
    }

    private SystemUpdatePolicy() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_SystemUpdatePolicy$__constructor__(), 0, this);
    }

    public static SystemUpdatePolicy createAutomaticInstallPolicy() {
        return InvokeDynamicSupport.bootstrapStatic("createAutomaticInstallPolicy", $$robo$$android_app_admin_SystemUpdatePolicy$createAutomaticInstallPolicy(), 0);
    }

    public static SystemUpdatePolicy createWindowedInstallPolicy(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("createWindowedInstallPolicy", $$robo$$android_app_admin_SystemUpdatePolicy$createWindowedInstallPolicy(int int ), 0, (int)n, (int)n2);
    }

    public static SystemUpdatePolicy createPostponeInstallPolicy() {
        return InvokeDynamicSupport.bootstrapStatic("createPostponeInstallPolicy", $$robo$$android_app_admin_SystemUpdatePolicy$createPostponeInstallPolicy(), 0);
    }

    public int getPolicyType() {
        return (int)InvokeDynamicSupport.bootstrap("getPolicyType", $$robo$$android_app_admin_SystemUpdatePolicy$getPolicyType(), 0, this);
    }

    public int getInstallWindowStart() {
        return (int)InvokeDynamicSupport.bootstrap("getInstallWindowStart", $$robo$$android_app_admin_SystemUpdatePolicy$getInstallWindowStart(), 0, this);
    }

    public int getInstallWindowEnd() {
        return (int)InvokeDynamicSupport.bootstrap("getInstallWindowEnd", $$robo$$android_app_admin_SystemUpdatePolicy$getInstallWindowEnd(), 0, this);
    }

    public boolean isValid() {
        return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_app_admin_SystemUpdatePolicy$isValid(), 0, this);
    }

    public void validateType() {
        InvokeDynamicSupport.bootstrap("validateType", $$robo$$android_app_admin_SystemUpdatePolicy$validateType(), 0, this);
    }

    public SystemUpdatePolicy setFreezePeriods(List<FreezePeriod> list) {
        return InvokeDynamicSupport.bootstrap("setFreezePeriods", $$robo$$android_app_admin_SystemUpdatePolicy$setFreezePeriods(java.util.List<android.app.admin.FreezePeriod> ), 0, this, list);
    }

    public List<FreezePeriod> getFreezePeriods() {
        return InvokeDynamicSupport.bootstrap("getFreezePeriods", $$robo$$android_app_admin_SystemUpdatePolicy$getFreezePeriods(), 0, this);
    }

    public Pair<LocalDate, LocalDate> getCurrentFreezePeriod(LocalDate localDate) {
        return InvokeDynamicSupport.bootstrap("getCurrentFreezePeriod", $$robo$$android_app_admin_SystemUpdatePolicy$getCurrentFreezePeriod(java.time.LocalDate ), 0, this, localDate);
    }

    private long timeUntilNextFreezePeriod(long l) {
        return (long)InvokeDynamicSupport.bootstrap("timeUntilNextFreezePeriod", $$robo$$android_app_admin_SystemUpdatePolicy$timeUntilNextFreezePeriod(long ), 0, this, l);
    }

    public void validateFreezePeriods() {
        InvokeDynamicSupport.bootstrap("validateFreezePeriods", $$robo$$android_app_admin_SystemUpdatePolicy$validateFreezePeriods(), 0, this);
    }

    public void validateAgainstPreviousFreezePeriod(LocalDate localDate, LocalDate localDate2, LocalDate localDate3) {
        InvokeDynamicSupport.bootstrap("validateAgainstPreviousFreezePeriod", $$robo$$android_app_admin_SystemUpdatePolicy$validateAgainstPreviousFreezePeriod(java.time.LocalDate java.time.LocalDate java.time.LocalDate ), 0, this, localDate, localDate2, localDate3);
    }

    @SystemApi
    public InstallationOption getInstallationOptionAt(long l) {
        return InvokeDynamicSupport.bootstrap("getInstallationOptionAt", $$robo$$android_app_admin_SystemUpdatePolicy$getInstallationOptionAt(long ), 0, this, l);
    }

    private InstallationOption getInstallationOptionRegardlessFreezeAt(long l) {
        return InvokeDynamicSupport.bootstrap("getInstallationOptionRegardlessFreezeAt", $$robo$$android_app_admin_SystemUpdatePolicy$getInstallationOptionRegardlessFreezeAt(long ), 0, this, l);
    }

    private static LocalDate roundUpLeapDay(LocalDate localDate) {
        return InvokeDynamicSupport.bootstrapStatic("roundUpLeapDay", $$robo$$android_app_admin_SystemUpdatePolicy$roundUpLeapDay(java.time.LocalDate ), 0, (LocalDate)localDate);
    }

    private static LocalDate millisToDate(long l) {
        return InvokeDynamicSupport.bootstrapStatic("millisToDate", $$robo$$android_app_admin_SystemUpdatePolicy$millisToDate(long ), 0, (long)l);
    }

    private static long dateToMillis(LocalDate localDate) {
        return (long)InvokeDynamicSupport.bootstrapStatic("dateToMillis", $$robo$$android_app_admin_SystemUpdatePolicy$dateToMillis(java.time.LocalDate ), 0, (LocalDate)localDate);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_admin_SystemUpdatePolicy$toString(), 0, this);
    }

    @Override
    @SystemApi
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_admin_SystemUpdatePolicy$describeContents(), 0, this);
    }

    @Override
    @SystemApi
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_admin_SystemUpdatePolicy$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public static SystemUpdatePolicy restoreFromXml(XmlPullParser xmlPullParser) {
        return InvokeDynamicSupport.bootstrapStatic("restoreFromXml", $$robo$$android_app_admin_SystemUpdatePolicy$restoreFromXml(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    public void saveToXml(XmlSerializer xmlSerializer) throws IOException {
        InvokeDynamicSupport.bootstrap("saveToXml", $$robo$$android_app_admin_SystemUpdatePolicy$saveToXml(org.xmlpull.v1.XmlSerializer ), 0, this, xmlSerializer);
    }

    private /* synthetic */ void __constructor__(1 var1_1) {
        this.$$robo$$android_app_admin_SystemUpdatePolicy$__constructor__(var1_1);
    }

    static {
        RobolectricInternals.classInitializing(SystemUpdatePolicy.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SystemUpdatePolicy)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @SystemApi
    public static class InstallationOption
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mType;
        private long mEffectiveTime;

        private void $$robo$$android_app_admin_SystemUpdatePolicy_InstallationOption$__constructor__(int type, long effectiveTime) {
            this.mType = type;
            this.mEffectiveTime = effectiveTime;
        }

        private final int $$robo$$android_app_admin_SystemUpdatePolicy_InstallationOption$getType() {
            return this.mType;
        }

        private final long $$robo$$android_app_admin_SystemUpdatePolicy_InstallationOption$getEffectiveTime() {
            return this.mEffectiveTime;
        }

        private final void $$robo$$android_app_admin_SystemUpdatePolicy_InstallationOption$limitEffectiveTime(long otherTime) {
            this.mEffectiveTime = Long.min(this.mEffectiveTime, otherTime);
        }

        private void __constructor__(int n, long l) {
            this.$$robo$$android_app_admin_SystemUpdatePolicy_InstallationOption$__constructor__(n, l);
        }

        InstallationOption(int n, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_SystemUpdatePolicy_InstallationOption$__constructor__(int long ), 0, this, n, l);
        }

        public int getType() {
            return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_app_admin_SystemUpdatePolicy_InstallationOption$getType(), 0, this);
        }

        public long getEffectiveTime() {
            return (long)InvokeDynamicSupport.bootstrap("getEffectiveTime", $$robo$$android_app_admin_SystemUpdatePolicy_InstallationOption$getEffectiveTime(), 0, this);
        }

        protected void limitEffectiveTime(long l) {
            InvokeDynamicSupport.bootstrap("limitEffectiveTime", $$robo$$android_app_admin_SystemUpdatePolicy_InstallationOption$limitEffectiveTime(long ), 0, this, l);
        }

        public /* synthetic */ InstallationOption() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InstallationOption)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface InstallationOptionType {
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ValidationFailedException
    extends IllegalArgumentException
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int ERROR_NONE = 0;
        public static int ERROR_UNKNOWN = 1;
        public static int ERROR_DUPLICATE_OR_OVERLAP = 2;
        public static int ERROR_NEW_FREEZE_PERIOD_TOO_LONG = 3;
        public static int ERROR_NEW_FREEZE_PERIOD_TOO_CLOSE = 4;
        public static int ERROR_COMBINED_FREEZE_PERIOD_TOO_LONG = 5;
        public static int ERROR_COMBINED_FREEZE_PERIOD_TOO_CLOSE = 6;
        private int mErrorCode;
        public static Parcelable.Creator<ValidationFailedException> CREATOR;

        private void $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$__constructor__(int errorCode, String message) {
            this.mErrorCode = errorCode;
        }

        private final int $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$getErrorCode() {
            return this.mErrorCode;
        }

        private static final ValidationFailedException $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$duplicateOrOverlapPeriods() {
            return new ValidationFailedException(2, "Found duplicate or overlapping periods");
        }

        private static final ValidationFailedException $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$freezePeriodTooLong(String message) {
            return new ValidationFailedException(3, message);
        }

        private static final ValidationFailedException $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$freezePeriodTooClose(String message) {
            return new ValidationFailedException(4, message);
        }

        private static final ValidationFailedException $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$combinedPeriodTooLong(String message) {
            return new ValidationFailedException(5, message);
        }

        private static final ValidationFailedException $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$combinedPeriodTooClose(String message) {
            return new ValidationFailedException(6, message);
        }

        private final int $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mErrorCode);
            dest.writeString(this.getMessage());
        }

        private /* synthetic */ void $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$__constructor__(int x0, String x1, 1 x2) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ValidationFailedException>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException_1$__constructor__() {
                }

                private final ValidationFailedException $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException_1$createFromParcel(Parcel source) {
                    return new ValidationFailedException(source.readInt(), source.readString());
                }

                private final ValidationFailedException[] $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException_1$newArray(int size) {
                    return new ValidationFailedException[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException_1$__constructor__(), 0, this);
                }

                @Override
                public ValidationFailedException createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ValidationFailedException[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$__constructor__(n, string2);
        }

        private ValidationFailedException(int n, String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$__constructor__(int java.lang.String ), 0, this, n, string2);
        }

        public int getErrorCode() {
            return (int)InvokeDynamicSupport.bootstrap("getErrorCode", $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$getErrorCode(), 0, this);
        }

        public static ValidationFailedException duplicateOrOverlapPeriods() {
            return InvokeDynamicSupport.bootstrapStatic("duplicateOrOverlapPeriods", $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$duplicateOrOverlapPeriods(), 0);
        }

        public static ValidationFailedException freezePeriodTooLong(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("freezePeriodTooLong", $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$freezePeriodTooLong(java.lang.String ), 0, (String)string2);
        }

        public static ValidationFailedException freezePeriodTooClose(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("freezePeriodTooClose", $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$freezePeriodTooClose(java.lang.String ), 0, (String)string2);
        }

        public static ValidationFailedException combinedPeriodTooLong(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("combinedPeriodTooLong", $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$combinedPeriodTooLong(java.lang.String ), 0, (String)string2);
        }

        public static ValidationFailedException combinedPeriodTooClose(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("combinedPeriodTooClose", $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$combinedPeriodTooClose(java.lang.String ), 0, (String)string2);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(int n, String string2, 1 var3_3) {
            this.$$robo$$android_app_admin_SystemUpdatePolicy_ValidationFailedException$__constructor__(n, string2, var3_3);
        }

        static {
            RobolectricInternals.classInitializing(ValidationFailedException.class);
        }

        public /* synthetic */ ValidationFailedException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ValidationFailedException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface ValidationFailureType {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface SystemUpdatePolicyType {
    }
}

