/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.IBackupAgent;
import android.app.QueuedWork;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.FullBackup;
import android.app.backup.FullBackupDataOutput;
import android.app.backup.IBackupManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ApplicationInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.util.ArraySet;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public abstract class BackupAgent
extends ContextWrapper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BackupAgent";
    private static boolean DEBUG = false;
    public static int TYPE_EOF = 0;
    public static int TYPE_FILE = 1;
    public static int TYPE_DIRECTORY = 2;
    public static int TYPE_SYMLINK = 3;
    public static int FLAG_CLIENT_SIDE_ENCRYPTION_ENABLED = 1;
    public static int FLAG_DEVICE_TO_DEVICE_TRANSFER = 2;
    public static int FLAG_FAKE_CLIENT_SIDE_ENCRYPTION_ENABLED = Integer.MIN_VALUE;
    Handler mHandler;
    private IBinder mBinder;

    private final Handler $$robo$$android_app_backup_BackupAgent$getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        return this.mHandler;
    }

    private final void $$robo$$android_app_backup_BackupAgent$waitForSharedPrefs() {
        Handler h = this.getHandler();
        SharedPrefsSynchronizer s = new SharedPrefsSynchronizer(this);
        h.postAtFrontOfQueue(s);
        try {
            s.mLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void $$robo$$android_app_backup_BackupAgent$__constructor__() {
        this.mHandler = null;
        this.mBinder = new BackupServiceBinder(this).asBinder();
    }

    private final void $$robo$$android_app_backup_BackupAgent$onCreate() {
    }

    private final void $$robo$$android_app_backup_BackupAgent$onDestroy() {
    }

    public abstract void onBackup(ParcelFileDescriptor var1, BackupDataOutput var2, ParcelFileDescriptor var3) throws IOException;

    public abstract void onRestore(BackupDataInput var1, int var2, ParcelFileDescriptor var3) throws IOException;

    private final void $$robo$$android_app_backup_BackupAgent$onRestore(BackupDataInput data, long appVersionCode, ParcelFileDescriptor newState) throws IOException {
        this.onRestore(data, (int)appVersionCode, newState);
    }

    private final void $$robo$$android_app_backup_BackupAgent$onFullBackup(FullBackupDataOutput data) throws IOException {
        File efLocation;
        ArraySet<FullBackup.BackupScheme.PathWithRequiredFlags> manifestExcludeSet;
        Map<String, Set<FullBackup.BackupScheme.PathWithRequiredFlags>> manifestIncludeMap;
        FullBackup.BackupScheme backupScheme = FullBackup.getBackupScheme(this);
        if (!backupScheme.isFullBackupContentEnabled()) {
            return;
        }
        try {
            manifestIncludeMap = backupScheme.maybeParseAndGetCanonicalIncludePaths();
            manifestExcludeSet = backupScheme.maybeParseAndGetCanonicalExcludePaths();
        }
        catch (IOException | XmlPullParserException e) {
            if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                Log.v("BackupXmlParserLogging", "Exception trying to parse fullBackupContent xml file! Aborting full backup.", e);
            }
            return;
        }
        String packageName = this.getPackageName();
        ApplicationInfo appInfo = this.getApplicationInfo();
        Context ceContext = this.createCredentialProtectedStorageContext();
        String rootDir = ceContext.getDataDir().getCanonicalPath();
        String filesDir = ceContext.getFilesDir().getCanonicalPath();
        String noBackupDir = ceContext.getNoBackupFilesDir().getCanonicalPath();
        String databaseDir = ceContext.getDatabasePath("foo").getParentFile().getCanonicalPath();
        String sharedPrefsDir = ceContext.getSharedPreferencesPath("foo").getParentFile().getCanonicalPath();
        String cacheDir = ceContext.getCacheDir().getCanonicalPath();
        String codeCacheDir = ceContext.getCodeCacheDir().getCanonicalPath();
        Context deContext = this.createDeviceProtectedStorageContext();
        String deviceRootDir = deContext.getDataDir().getCanonicalPath();
        String deviceFilesDir = deContext.getFilesDir().getCanonicalPath();
        String deviceNoBackupDir = deContext.getNoBackupFilesDir().getCanonicalPath();
        String deviceDatabaseDir = deContext.getDatabasePath("foo").getParentFile().getCanonicalPath();
        String deviceSharedPrefsDir = deContext.getSharedPreferencesPath("foo").getParentFile().getCanonicalPath();
        String deviceCacheDir = deContext.getCacheDir().getCanonicalPath();
        String deviceCodeCacheDir = deContext.getCodeCacheDir().getCanonicalPath();
        String libDir = appInfo.nativeLibraryDir != null ? new File(appInfo.nativeLibraryDir).getCanonicalPath() : null;
        ArraySet<String> traversalExcludeSet = new ArraySet<String>();
        traversalExcludeSet.add(filesDir);
        traversalExcludeSet.add(noBackupDir);
        traversalExcludeSet.add(databaseDir);
        traversalExcludeSet.add(sharedPrefsDir);
        traversalExcludeSet.add(cacheDir);
        traversalExcludeSet.add(codeCacheDir);
        traversalExcludeSet.add(deviceFilesDir);
        traversalExcludeSet.add(deviceNoBackupDir);
        traversalExcludeSet.add(deviceDatabaseDir);
        traversalExcludeSet.add(deviceSharedPrefsDir);
        traversalExcludeSet.add(deviceCacheDir);
        traversalExcludeSet.add(deviceCodeCacheDir);
        if (libDir != null) {
            traversalExcludeSet.add(libDir);
        }
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "r", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(rootDir);
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "d_r", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(deviceRootDir);
        traversalExcludeSet.remove(filesDir);
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "f", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(filesDir);
        traversalExcludeSet.remove(deviceFilesDir);
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "d_f", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(deviceFilesDir);
        traversalExcludeSet.remove(databaseDir);
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "db", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(databaseDir);
        traversalExcludeSet.remove(deviceDatabaseDir);
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "d_db", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(deviceDatabaseDir);
        traversalExcludeSet.remove(sharedPrefsDir);
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "sp", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(sharedPrefsDir);
        traversalExcludeSet.remove(deviceSharedPrefsDir);
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "d_sp", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(deviceSharedPrefsDir);
        if (Process.myUid() != 1000 && (efLocation = this.getExternalFilesDir(null)) != null) {
            this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "ef", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        }
    }

    private final void $$robo$$android_app_backup_BackupAgent$onQuotaExceeded(long backupDataBytes, long quotaBytes) {
    }

    private final void $$robo$$android_app_backup_BackupAgent$applyXmlFiltersAndDoFullBackupForDomain(String packageName, String domainToken, Map<String, Set<FullBackup.BackupScheme.PathWithRequiredFlags>> includeMap, ArraySet<FullBackup.BackupScheme.PathWithRequiredFlags> filterSet, ArraySet<String> traversalExcludeSet, FullBackupDataOutput data) throws IOException {
        if (includeMap == null || includeMap.size() == 0) {
            this.fullBackupFileTree(packageName, domainToken, FullBackup.getBackupScheme(this).tokenToDirectoryPath(domainToken), filterSet, traversalExcludeSet, data);
        } else if (includeMap.get(domainToken) != null) {
            for (FullBackup.BackupScheme.PathWithRequiredFlags includeFile : includeMap.get(domainToken)) {
                if (!this.areIncludeRequiredTransportFlagsSatisfied(includeFile.getRequiredFlags(), data.getTransportFlags())) continue;
                this.fullBackupFileTree(packageName, domainToken, includeFile.getPath(), filterSet, traversalExcludeSet, data);
            }
        }
    }

    private final boolean $$robo$$android_app_backup_BackupAgent$areIncludeRequiredTransportFlagsSatisfied(int includeFlags, int transportFlags) {
        return (transportFlags & includeFlags) == includeFlags;
    }

    private final void $$robo$$android_app_backup_BackupAgent$fullBackupFile(File file, FullBackupDataOutput output) {
        String domain;
        String filePath;
        String libDir;
        String deviceCodeCacheDir;
        String deviceCacheDir;
        String deviceSpDir;
        String deviceDbDir;
        String deviceNbFilesDir;
        String deviceFilesDir;
        String deviceRootDir;
        String codeCacheDir;
        String cacheDir;
        String spDir;
        String dbDir;
        String nbFilesDir;
        String filesDir;
        String rootDir;
        String efDir = null;
        ApplicationInfo appInfo = this.getApplicationInfo();
        try {
            File efLocation;
            Context ceContext = this.createCredentialProtectedStorageContext();
            rootDir = ceContext.getDataDir().getCanonicalPath();
            filesDir = ceContext.getFilesDir().getCanonicalPath();
            nbFilesDir = ceContext.getNoBackupFilesDir().getCanonicalPath();
            dbDir = ceContext.getDatabasePath("foo").getParentFile().getCanonicalPath();
            spDir = ceContext.getSharedPreferencesPath("foo").getParentFile().getCanonicalPath();
            cacheDir = ceContext.getCacheDir().getCanonicalPath();
            codeCacheDir = ceContext.getCodeCacheDir().getCanonicalPath();
            Context deContext = this.createDeviceProtectedStorageContext();
            deviceRootDir = deContext.getDataDir().getCanonicalPath();
            deviceFilesDir = deContext.getFilesDir().getCanonicalPath();
            deviceNbFilesDir = deContext.getNoBackupFilesDir().getCanonicalPath();
            deviceDbDir = deContext.getDatabasePath("foo").getParentFile().getCanonicalPath();
            deviceSpDir = deContext.getSharedPreferencesPath("foo").getParentFile().getCanonicalPath();
            deviceCacheDir = deContext.getCacheDir().getCanonicalPath();
            deviceCodeCacheDir = deContext.getCodeCacheDir().getCanonicalPath();
            String string2 = libDir = appInfo.nativeLibraryDir == null ? null : new File(appInfo.nativeLibraryDir).getCanonicalPath();
            if (Process.myUid() != 1000 && (efLocation = this.getExternalFilesDir(null)) != null) {
                efDir = efLocation.getCanonicalPath();
            }
            filePath = file.getCanonicalPath();
        }
        catch (IOException e) {
            Log.w("BackupAgent", "Unable to obtain canonical paths");
            return;
        }
        if (filePath.startsWith(cacheDir) || filePath.startsWith(codeCacheDir) || filePath.startsWith(nbFilesDir) || filePath.startsWith(deviceCacheDir) || filePath.startsWith(deviceCodeCacheDir) || filePath.startsWith(deviceNbFilesDir) || filePath.startsWith(libDir)) {
            Log.w("BackupAgent", "lib, cache, code_cache, and no_backup files are not backed up");
            return;
        }
        String rootpath = null;
        if (filePath.startsWith(dbDir)) {
            domain = "db";
            rootpath = dbDir;
        } else if (filePath.startsWith(spDir)) {
            domain = "sp";
            rootpath = spDir;
        } else if (filePath.startsWith(filesDir)) {
            domain = "f";
            rootpath = filesDir;
        } else if (filePath.startsWith(rootDir)) {
            domain = "r";
            rootpath = rootDir;
        } else if (filePath.startsWith(deviceDbDir)) {
            domain = "d_db";
            rootpath = deviceDbDir;
        } else if (filePath.startsWith(deviceSpDir)) {
            domain = "d_sp";
            rootpath = deviceSpDir;
        } else if (filePath.startsWith(deviceFilesDir)) {
            domain = "d_f";
            rootpath = deviceFilesDir;
        } else if (filePath.startsWith(deviceRootDir)) {
            domain = "d_r";
            rootpath = deviceRootDir;
        } else if (efDir != null && filePath.startsWith(efDir)) {
            domain = "ef";
            rootpath = efDir;
        } else {
            Log.w("BackupAgent", "File " + filePath + " is in an unsupported location; skipping");
            return;
        }
        FullBackup.backupToTar(this.getPackageName(), domain, null, rootpath, filePath, output);
    }

    private final void $$robo$$android_app_backup_BackupAgent$fullBackupFileTree(String packageName, String domain, String startingPath, ArraySet<FullBackup.BackupScheme.PathWithRequiredFlags> manifestExcludes, ArraySet<String> systemExcludes, FullBackupDataOutput output) {
        String domainPath = FullBackup.getBackupScheme(this).tokenToDirectoryPath(domain);
        if (domainPath == null) {
            return;
        }
        File rootFile = new File(startingPath);
        if (rootFile.exists()) {
            LinkedList<File> scanQueue = new LinkedList<File>();
            scanQueue.add(rootFile);
            while (scanQueue.size() > 0) {
                String filePath;
                block7: {
                    File file = (File)scanQueue.remove(0);
                    try {
                        File[] contents;
                        StructStat stat = Os.lstat(file.getPath());
                        if (!OsConstants.S_ISREG(stat.st_mode) && !OsConstants.S_ISDIR(stat.st_mode)) continue;
                        filePath = file.getCanonicalPath();
                        if (manifestExcludes != null && this.manifestExcludesContainFilePath(manifestExcludes, filePath) || systemExcludes != null && systemExcludes.contains(filePath)) continue;
                        if (!OsConstants.S_ISDIR(stat.st_mode) || (contents = file.listFiles()) == null) break block7;
                        for (File entry : contents) {
                            scanQueue.add(0, entry);
                        }
                    }
                    catch (IOException e) {
                        if (!Log.isLoggable("BackupXmlParserLogging", 2)) continue;
                        Log.v("BackupXmlParserLogging", "Error canonicalizing path of " + file);
                        continue;
                    }
                    catch (ErrnoException e) {
                        if (!Log.isLoggable("BackupXmlParserLogging", 2)) continue;
                        Log.v("BackupXmlParserLogging", "Error scanning file " + file + " : " + e);
                        continue;
                    }
                }
                FullBackup.backupToTar(packageName, domain, null, domainPath, filePath, output);
            }
        }
    }

    private final boolean $$robo$$android_app_backup_BackupAgent$manifestExcludesContainFilePath(ArraySet<FullBackup.BackupScheme.PathWithRequiredFlags> manifestExcludes, String filePath) {
        for (FullBackup.BackupScheme.PathWithRequiredFlags exclude : manifestExcludes) {
            String excludePath = exclude.getPath();
            if (excludePath == null || !excludePath.equals(filePath)) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_app_backup_BackupAgent$onRestoreFile(ParcelFileDescriptor data, long size, File destination, int type, long mode, long mtime) throws IOException {
        boolean accept = this.isFileEligibleForRestore(destination);
        FullBackup.restoreFile(data, size, type, mode, mtime, accept ? destination : null);
    }

    private final boolean $$robo$$android_app_backup_BackupAgent$isFileEligibleForRestore(File destination) throws IOException {
        FullBackup.BackupScheme bs = FullBackup.getBackupScheme(this);
        if (!bs.isFullBackupContentEnabled()) {
            if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                Log.v("BackupXmlParserLogging", "onRestoreFile \"" + destination.getCanonicalPath() + "\" : fullBackupContent not enabled for " + this.getPackageName());
            }
            return false;
        }
        Map<String, Set<FullBackup.BackupScheme.PathWithRequiredFlags>> includes = null;
        ArraySet<FullBackup.BackupScheme.PathWithRequiredFlags> excludes = null;
        String destinationCanonicalPath = destination.getCanonicalPath();
        try {
            includes = bs.maybeParseAndGetCanonicalIncludePaths();
            excludes = bs.maybeParseAndGetCanonicalExcludePaths();
        }
        catch (XmlPullParserException e) {
            if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                Log.v("BackupXmlParserLogging", "onRestoreFile \"" + destinationCanonicalPath + "\" : Exception trying to parse fullBackupContent xml file! Aborting onRestoreFile.", e);
            }
            return false;
        }
        if (excludes != null && this.isFileSpecifiedInPathList(destination, excludes)) {
            if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                Log.v("BackupXmlParserLogging", "onRestoreFile: \"" + destinationCanonicalPath + "\": listed in excludes; skipping.");
            }
            return false;
        }
        if (includes != null && !includes.isEmpty()) {
            boolean explicitlyIncluded = false;
            for (Set<FullBackup.BackupScheme.PathWithRequiredFlags> domainIncludes : includes.values()) {
                if (explicitlyIncluded |= this.isFileSpecifiedInPathList(destination, domainIncludes)) break;
            }
            if (!explicitlyIncluded) {
                if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                    Log.v("BackupXmlParserLogging", "onRestoreFile: Trying to restore \"" + destinationCanonicalPath + "\" but it isn't specified in the included files; skipping.");
                }
                return false;
            }
        }
        return true;
    }

    private final boolean $$robo$$android_app_backup_BackupAgent$isFileSpecifiedInPathList(File file, Collection<FullBackup.BackupScheme.PathWithRequiredFlags> canonicalPathList) throws IOException {
        for (FullBackup.BackupScheme.PathWithRequiredFlags canonical : canonicalPathList) {
            String canonicalPath = canonical.getPath();
            File fileFromList = new File(canonicalPath);
            if (fileFromList.isDirectory()) {
                if (file.isDirectory()) {
                    return file.equals(fileFromList);
                }
                return file.getCanonicalPath().startsWith(canonicalPath);
            }
            if (!file.equals(fileFromList)) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_app_backup_BackupAgent$onRestoreFile(ParcelFileDescriptor data, long size, int type, String domain, String path, long mode, long mtime) throws IOException {
        File outFile;
        String outPath;
        String basePath = null;
        basePath = FullBackup.getBackupScheme(this).tokenToDirectoryPath(domain);
        if (domain.equals("ef")) {
            mode = -1L;
        }
        if (basePath != null && (outPath = (outFile = new File(basePath, path)).getCanonicalPath()).startsWith(basePath + File.separatorChar)) {
            this.onRestoreFile(data, size, outFile, type, mode, mtime);
            return;
        }
        FullBackup.restoreFile(data, size, type, mode, mtime, null);
    }

    private final void $$robo$$android_app_backup_BackupAgent$onRestoreFinished() {
    }

    private final IBinder $$robo$$android_app_backup_BackupAgent$onBind() {
        return this.mBinder;
    }

    private final void $$robo$$android_app_backup_BackupAgent$attach(Context context) {
        this.attachBaseContext(context);
    }

    Handler getHandler() {
        return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_app_backup_BackupAgent$getHandler(), 0, this);
    }

    private void waitForSharedPrefs() {
        InvokeDynamicSupport.bootstrap("waitForSharedPrefs", $$robo$$android_app_backup_BackupAgent$waitForSharedPrefs(), 0, this);
    }

    private void __constructor__() {
        this.$$robo$$android_app_backup_BackupAgent$__constructor__();
    }

    public BackupAgent() {
        super(null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupAgent$__constructor__(), 0, this);
    }

    public void onCreate() {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_app_backup_BackupAgent$onCreate(), 0, this);
    }

    public void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_app_backup_BackupAgent$onDestroy(), 0, this);
    }

    public void onRestore(BackupDataInput backupDataInput, long l, ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrap("onRestore", $$robo$$android_app_backup_BackupAgent$onRestore(android.app.backup.BackupDataInput long android.os.ParcelFileDescriptor ), 0, this, backupDataInput, l, parcelFileDescriptor);
    }

    public void onFullBackup(FullBackupDataOutput fullBackupDataOutput) throws IOException {
        InvokeDynamicSupport.bootstrap("onFullBackup", $$robo$$android_app_backup_BackupAgent$onFullBackup(android.app.backup.FullBackupDataOutput ), 0, this, fullBackupDataOutput);
    }

    public void onQuotaExceeded(long l, long l2) {
        InvokeDynamicSupport.bootstrap("onQuotaExceeded", $$robo$$android_app_backup_BackupAgent$onQuotaExceeded(long long ), 0, this, l, l2);
    }

    private void applyXmlFiltersAndDoFullBackupForDomain(String string2, String string3, Map<String, Set<FullBackup.BackupScheme.PathWithRequiredFlags>> map, ArraySet<FullBackup.BackupScheme.PathWithRequiredFlags> arraySet, ArraySet<String> arraySet2, FullBackupDataOutput fullBackupDataOutput) throws IOException {
        InvokeDynamicSupport.bootstrap("applyXmlFiltersAndDoFullBackupForDomain", $$robo$$android_app_backup_BackupAgent$applyXmlFiltersAndDoFullBackupForDomain(java.lang.String java.lang.String java.util.Map<java.lang.String, java.util.Set<android.app.backup.FullBackup$BackupScheme$PathWithRequiredFlags>> android.util.ArraySet<android.app.backup.FullBackup$BackupScheme$PathWithRequiredFlags> android.util.ArraySet<java.lang.String> android.app.backup.FullBackupDataOutput ), 0, this, string2, string3, map, arraySet, arraySet2, fullBackupDataOutput);
    }

    private boolean areIncludeRequiredTransportFlagsSatisfied(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("areIncludeRequiredTransportFlagsSatisfied", $$robo$$android_app_backup_BackupAgent$areIncludeRequiredTransportFlagsSatisfied(int int ), 0, this, n, n2);
    }

    public void fullBackupFile(File file, FullBackupDataOutput fullBackupDataOutput) {
        InvokeDynamicSupport.bootstrap("fullBackupFile", $$robo$$android_app_backup_BackupAgent$fullBackupFile(java.io.File android.app.backup.FullBackupDataOutput ), 0, this, file, fullBackupDataOutput);
    }

    protected void fullBackupFileTree(String string2, String string3, String string4, ArraySet<FullBackup.BackupScheme.PathWithRequiredFlags> arraySet, ArraySet<String> arraySet2, FullBackupDataOutput fullBackupDataOutput) {
        InvokeDynamicSupport.bootstrap("fullBackupFileTree", $$robo$$android_app_backup_BackupAgent$fullBackupFileTree(java.lang.String java.lang.String java.lang.String android.util.ArraySet<android.app.backup.FullBackup$BackupScheme$PathWithRequiredFlags> android.util.ArraySet<java.lang.String> android.app.backup.FullBackupDataOutput ), 0, this, string2, string3, string4, arraySet, arraySet2, fullBackupDataOutput);
    }

    private boolean manifestExcludesContainFilePath(ArraySet<FullBackup.BackupScheme.PathWithRequiredFlags> arraySet, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("manifestExcludesContainFilePath", $$robo$$android_app_backup_BackupAgent$manifestExcludesContainFilePath(android.util.ArraySet<android.app.backup.FullBackup$BackupScheme$PathWithRequiredFlags> java.lang.String ), 0, this, arraySet, string2);
    }

    public void onRestoreFile(ParcelFileDescriptor parcelFileDescriptor, long l, File file, int n, long l2, long l3) throws IOException {
        InvokeDynamicSupport.bootstrap("onRestoreFile", $$robo$$android_app_backup_BackupAgent$onRestoreFile(android.os.ParcelFileDescriptor long java.io.File int long long ), 0, this, parcelFileDescriptor, l, file, n, l2, l3);
    }

    private boolean isFileEligibleForRestore(File file) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("isFileEligibleForRestore", $$robo$$android_app_backup_BackupAgent$isFileEligibleForRestore(java.io.File ), 0, this, file);
    }

    private boolean isFileSpecifiedInPathList(File file, Collection<FullBackup.BackupScheme.PathWithRequiredFlags> collection) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("isFileSpecifiedInPathList", $$robo$$android_app_backup_BackupAgent$isFileSpecifiedInPathList(java.io.File java.util.Collection<android.app.backup.FullBackup$BackupScheme$PathWithRequiredFlags> ), 0, this, file, collection);
    }

    protected void onRestoreFile(ParcelFileDescriptor parcelFileDescriptor, long l, int n, String string2, String string3, long l2, long l3) throws IOException {
        InvokeDynamicSupport.bootstrap("onRestoreFile", $$robo$$android_app_backup_BackupAgent$onRestoreFile(android.os.ParcelFileDescriptor long int java.lang.String java.lang.String long long ), 0, this, parcelFileDescriptor, l, n, string2, string3, l2, l3);
    }

    public void onRestoreFinished() {
        InvokeDynamicSupport.bootstrap("onRestoreFinished", $$robo$$android_app_backup_BackupAgent$onRestoreFinished(), 0, this);
    }

    public IBinder onBind() {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_app_backup_BackupAgent$onBind(), 0, this);
    }

    public void attach(Context context) {
        InvokeDynamicSupport.bootstrap("attach", $$robo$$android_app_backup_BackupAgent$attach(android.content.Context ), 0, this, context);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackupAgent)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class FailRunnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mMessage;

        private void $$robo$$android_app_backup_BackupAgent_FailRunnable$__constructor__(String message) {
            this.mMessage = message;
        }

        private final void $$robo$$android_app_backup_BackupAgent_FailRunnable$run() {
            throw new IllegalStateException(this.mMessage);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_app_backup_BackupAgent_FailRunnable$__constructor__(string2);
        }

        FailRunnable(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupAgent_FailRunnable$__constructor__(java.lang.String ), 0, this, string2);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_backup_BackupAgent_FailRunnable$run(), 0, this);
        }

        public /* synthetic */ FailRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FailRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class BackupServiceBinder
    extends IBackupAgent.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "BackupServiceBinder";
        /* synthetic */ BackupAgent this$0;

        private void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$__constructor__(BackupAgent backupAgent) {
        }

        private final void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doBackup(ParcelFileDescriptor oldState, ParcelFileDescriptor data, ParcelFileDescriptor newState, long quotaBytes, int token, IBackupManager callbackBinder, int transportFlags) throws RemoteException {
            long ident = Binder.clearCallingIdentity();
            BackupDataOutput output = new BackupDataOutput(data.getFileDescriptor(), quotaBytes, transportFlags);
            try {
                this.this$0.onBackup(oldState, output, newState);
            }
            catch (IOException ex) {
                Log.d("BackupServiceBinder", "onBackup (" + this.this$0.getClass().getName() + ") threw", ex);
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                Log.d("BackupServiceBinder", "onBackup (" + this.this$0.getClass().getName() + ") threw", ex);
                throw ex;
            }
            finally {
                this.this$0.waitForSharedPrefs();
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token, 0L);
                }
                catch (RemoteException remoteException) {}
                if (Binder.getCallingPid() != Process.myPid()) {
                    IoUtils.closeQuietly(oldState);
                    IoUtils.closeQuietly(data);
                    IoUtils.closeQuietly(newState);
                }
            }
        }

        private final void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doRestore(ParcelFileDescriptor data, long appVersionCode, ParcelFileDescriptor newState, int token, IBackupManager callbackBinder) throws RemoteException {
            long ident = Binder.clearCallingIdentity();
            this.this$0.waitForSharedPrefs();
            BackupDataInput input = new BackupDataInput(data.getFileDescriptor());
            try {
                this.this$0.onRestore(input, appVersionCode, newState);
            }
            catch (IOException ex) {
                Log.d("BackupServiceBinder", "onRestore (" + this.this$0.getClass().getName() + ") threw", ex);
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                Log.d("BackupServiceBinder", "onRestore (" + this.this$0.getClass().getName() + ") threw", ex);
                throw ex;
            }
            finally {
                this.this$0.reloadSharedPreferences();
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token, 0L);
                }
                catch (RemoteException remoteException) {}
                if (Binder.getCallingPid() != Process.myPid()) {
                    IoUtils.closeQuietly(data);
                    IoUtils.closeQuietly(newState);
                }
            }
        }

        private final void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doFullBackup(ParcelFileDescriptor data, long quotaBytes, int token, IBackupManager callbackBinder, int transportFlags) {
            long ident = Binder.clearCallingIdentity();
            this.this$0.waitForSharedPrefs();
            try {
                this.this$0.onFullBackup(new FullBackupDataOutput(data, quotaBytes, transportFlags));
            }
            catch (IOException ex) {
                Log.d("BackupServiceBinder", "onFullBackup (" + this.this$0.getClass().getName() + ") threw", ex);
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                Log.d("BackupServiceBinder", "onFullBackup (" + this.this$0.getClass().getName() + ") threw", ex);
                throw ex;
            }
            finally {
                this.this$0.waitForSharedPrefs();
                try {
                    FileOutputStream out = new FileOutputStream(data.getFileDescriptor());
                    byte[] buf = new byte[4];
                    out.write(buf);
                }
                catch (IOException e) {
                    Log.e("BackupServiceBinder", "Unable to finalize backup stream!");
                }
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token, 0L);
                }
                catch (RemoteException remoteException) {}
                if (Binder.getCallingPid() != Process.myPid()) {
                    IoUtils.closeQuietly(data);
                }
            }
        }

        private final void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doMeasureFullBackup(long quotaBytes, int token, IBackupManager callbackBinder, int transportFlags) {
            long ident = Binder.clearCallingIdentity();
            FullBackupDataOutput measureOutput = new FullBackupDataOutput(quotaBytes, transportFlags);
            this.this$0.waitForSharedPrefs();
            try {
                this.this$0.onFullBackup(measureOutput);
            }
            catch (IOException ex) {
                Log.d("BackupServiceBinder", "onFullBackup[M] (" + this.this$0.getClass().getName() + ") threw", ex);
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                Log.d("BackupServiceBinder", "onFullBackup[M] (" + this.this$0.getClass().getName() + ") threw", ex);
                throw ex;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token, measureOutput.getSize());
                }
                catch (RemoteException remoteException) {}
            }
        }

        private final void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doRestoreFile(ParcelFileDescriptor data, long size, int type, String domain, String path, long mode, long mtime, int token, IBackupManager callbackBinder) throws RemoteException {
            long ident = Binder.clearCallingIdentity();
            try {
                this.this$0.onRestoreFile(data, size, type, domain, path, mode, mtime);
            }
            catch (IOException e) {
                Log.d("BackupServiceBinder", "onRestoreFile (" + this.this$0.getClass().getName() + ") threw", e);
                throw new RuntimeException(e);
            }
            finally {
                this.this$0.waitForSharedPrefs();
                this.this$0.reloadSharedPreferences();
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token, 0L);
                }
                catch (RemoteException remoteException) {}
                if (Binder.getCallingPid() != Process.myPid()) {
                    IoUtils.closeQuietly(data);
                }
            }
        }

        private final void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doRestoreFinished(int token, IBackupManager callbackBinder) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.this$0.onRestoreFinished();
            }
            catch (Exception e) {
                Log.d("BackupServiceBinder", "onRestoreFinished (" + this.this$0.getClass().getName() + ") threw", e);
                throw e;
            }
            finally {
                this.this$0.waitForSharedPrefs();
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token, 0L);
                }
                catch (RemoteException remoteException) {}
            }
        }

        private final void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$fail(String message) {
            this.this$0.getHandler().post(new FailRunnable(message));
        }

        private final void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doQuotaExceeded(long backupDataBytes, long quotaBytes) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.this$0.onQuotaExceeded(backupDataBytes, quotaBytes);
            }
            catch (Exception e) {
                Log.d("BackupServiceBinder", "onQuotaExceeded(" + this.this$0.getClass().getName() + ") threw", e);
                throw e;
            }
            finally {
                this.this$0.waitForSharedPrefs();
                Binder.restoreCallingIdentity(ident);
            }
        }

        private /* synthetic */ void $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$__constructor__(BackupAgent x0, 1 x1) {
        }

        private void __constructor__(BackupAgent backupAgent) {
            this.$$robo$$android_app_backup_BackupAgent_BackupServiceBinder$__constructor__(backupAgent);
        }

        private BackupServiceBinder(BackupAgent backupAgent) {
            this.this$0 = backupAgent;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$__constructor__(android.app.backup.BackupAgent ), 0, this, backupAgent);
        }

        @Override
        public void doBackup(ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, ParcelFileDescriptor parcelFileDescriptor3, long l, int n, IBackupManager iBackupManager, int n2) throws RemoteException {
            InvokeDynamicSupport.bootstrap("doBackup", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doBackup(android.os.ParcelFileDescriptor android.os.ParcelFileDescriptor android.os.ParcelFileDescriptor long int android.app.backup.IBackupManager int ), 0, this, parcelFileDescriptor, parcelFileDescriptor2, parcelFileDescriptor3, l, n, iBackupManager, n2);
        }

        @Override
        public void doRestore(ParcelFileDescriptor parcelFileDescriptor, long l, ParcelFileDescriptor parcelFileDescriptor2, int n, IBackupManager iBackupManager) throws RemoteException {
            InvokeDynamicSupport.bootstrap("doRestore", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doRestore(android.os.ParcelFileDescriptor long android.os.ParcelFileDescriptor int android.app.backup.IBackupManager ), 0, this, parcelFileDescriptor, l, parcelFileDescriptor2, n, iBackupManager);
        }

        @Override
        public void doFullBackup(ParcelFileDescriptor parcelFileDescriptor, long l, int n, IBackupManager iBackupManager, int n2) {
            InvokeDynamicSupport.bootstrap("doFullBackup", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doFullBackup(android.os.ParcelFileDescriptor long int android.app.backup.IBackupManager int ), 0, this, parcelFileDescriptor, l, n, iBackupManager, n2);
        }

        @Override
        public void doMeasureFullBackup(long l, int n, IBackupManager iBackupManager, int n2) {
            InvokeDynamicSupport.bootstrap("doMeasureFullBackup", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doMeasureFullBackup(long int android.app.backup.IBackupManager int ), 0, this, l, n, iBackupManager, n2);
        }

        @Override
        public void doRestoreFile(ParcelFileDescriptor parcelFileDescriptor, long l, int n, String string2, String string3, long l2, long l3, int n2, IBackupManager iBackupManager) throws RemoteException {
            InvokeDynamicSupport.bootstrap("doRestoreFile", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doRestoreFile(android.os.ParcelFileDescriptor long int java.lang.String java.lang.String long long int android.app.backup.IBackupManager ), 0, this, parcelFileDescriptor, l, n, string2, string3, l2, l3, n2, iBackupManager);
        }

        @Override
        public void doRestoreFinished(int n, IBackupManager iBackupManager) {
            InvokeDynamicSupport.bootstrap("doRestoreFinished", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doRestoreFinished(int android.app.backup.IBackupManager ), 0, this, n, iBackupManager);
        }

        @Override
        public void fail(String string2) {
            InvokeDynamicSupport.bootstrap("fail", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$fail(java.lang.String ), 0, this, string2);
        }

        @Override
        public void doQuotaExceeded(long l, long l2) {
            InvokeDynamicSupport.bootstrap("doQuotaExceeded", $$robo$$android_app_backup_BackupAgent_BackupServiceBinder$doQuotaExceeded(long long ), 0, this, l, l2);
        }

        private /* synthetic */ void __constructor__(BackupAgent backupAgent, 1 var2_2) {
            this.$$robo$$android_app_backup_BackupAgent_BackupServiceBinder$__constructor__(backupAgent, var2_2);
        }

        public /* synthetic */ BackupServiceBinder() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackupServiceBinder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class SharedPrefsSynchronizer
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public CountDownLatch mLatch;
        /* synthetic */ BackupAgent this$0;

        private void $$robo$$android_app_backup_BackupAgent_SharedPrefsSynchronizer$__constructor__(BackupAgent this$0) {
            this.mLatch = new CountDownLatch(1);
        }

        private final void $$robo$$android_app_backup_BackupAgent_SharedPrefsSynchronizer$run() {
            QueuedWork.waitToFinish();
            this.mLatch.countDown();
        }

        private void __constructor__(BackupAgent backupAgent) {
            this.$$robo$$android_app_backup_BackupAgent_SharedPrefsSynchronizer$__constructor__(backupAgent);
        }

        SharedPrefsSynchronizer(BackupAgent backupAgent) {
            this.this$0 = backupAgent;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupAgent_SharedPrefsSynchronizer$__constructor__(android.app.backup.BackupAgent ), 0, this, backupAgent);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_backup_BackupAgent_SharedPrefsSynchronizer$run(), 0, this);
        }

        public /* synthetic */ SharedPrefsSynchronizer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SharedPrefsSynchronizer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

