/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IBackupObserver;
import android.app.backup.IFullBackupRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.ISelectBackupTransportCallback;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public interface IBackupManager
extends IInterface,
InstrumentedInterface {
    public void dataChanged(String var1) throws RemoteException;

    public void clearBackupData(String var1, String var2) throws RemoteException;

    public void initializeTransports(String[] var1, IBackupObserver var2) throws RemoteException;

    public void agentConnected(String var1, IBinder var2) throws RemoteException;

    public void agentDisconnected(String var1) throws RemoteException;

    public void restoreAtInstall(String var1, int var2) throws RemoteException;

    public void setBackupEnabled(boolean var1) throws RemoteException;

    public void setAutoRestore(boolean var1) throws RemoteException;

    public void setBackupProvisioned(boolean var1) throws RemoteException;

    public boolean isBackupEnabled() throws RemoteException;

    public boolean setBackupPassword(String var1, String var2) throws RemoteException;

    public boolean hasBackupPassword() throws RemoteException;

    public void backupNow() throws RemoteException;

    public void adbBackup(ParcelFileDescriptor var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, String[] var10) throws RemoteException;

    public void fullTransportBackup(String[] var1) throws RemoteException;

    public void adbRestore(ParcelFileDescriptor var1) throws RemoteException;

    public void acknowledgeFullBackupOrRestore(int var1, boolean var2, String var3, String var4, IFullBackupRestoreObserver var5) throws RemoteException;

    public void updateTransportAttributes(ComponentName var1, String var2, Intent var3, String var4, Intent var5, String var6) throws RemoteException;

    public String getCurrentTransport() throws RemoteException;

    public String[] listAllTransports() throws RemoteException;

    public ComponentName[] listAllTransportComponents() throws RemoteException;

    public String[] getTransportWhitelist() throws RemoteException;

    public String selectBackupTransport(String var1) throws RemoteException;

    public void selectBackupTransportAsync(ComponentName var1, ISelectBackupTransportCallback var2) throws RemoteException;

    public Intent getConfigurationIntent(String var1) throws RemoteException;

    public String getDestinationString(String var1) throws RemoteException;

    public Intent getDataManagementIntent(String var1) throws RemoteException;

    public String getDataManagementLabel(String var1) throws RemoteException;

    public IRestoreSession beginRestoreSession(String var1, String var2) throws RemoteException;

    public void opComplete(int var1, long var2) throws RemoteException;

    public void setBackupServiceActive(int var1, boolean var2) throws RemoteException;

    public boolean isBackupServiceActive(int var1) throws RemoteException;

    public long getAvailableRestoreToken(String var1) throws RemoteException;

    public boolean isAppEligibleForBackup(String var1) throws RemoteException;

    public String[] filterAppsEligibleForBackup(String[] var1) throws RemoteException;

    public int requestBackup(String[] var1, IBackupObserver var2, IBackupManagerMonitor var3, int var4) throws RemoteException;

    public void cancelBackups() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBackupManager,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String DESCRIPTOR = "android.app.backup.IBackupManager";
        static int TRANSACTION_dataChanged = 1;
        static int TRANSACTION_clearBackupData = 2;
        static int TRANSACTION_initializeTransports = 3;
        static int TRANSACTION_agentConnected = 4;
        static int TRANSACTION_agentDisconnected = 5;
        static int TRANSACTION_restoreAtInstall = 6;
        static int TRANSACTION_setBackupEnabled = 7;
        static int TRANSACTION_setAutoRestore = 8;
        static int TRANSACTION_setBackupProvisioned = 9;
        static int TRANSACTION_isBackupEnabled = 10;
        static int TRANSACTION_setBackupPassword = 11;
        static int TRANSACTION_hasBackupPassword = 12;
        static int TRANSACTION_backupNow = 13;
        static int TRANSACTION_adbBackup = 14;
        static int TRANSACTION_fullTransportBackup = 15;
        static int TRANSACTION_adbRestore = 16;
        static int TRANSACTION_acknowledgeFullBackupOrRestore = 17;
        static int TRANSACTION_updateTransportAttributes = 18;
        static int TRANSACTION_getCurrentTransport = 19;
        static int TRANSACTION_listAllTransports = 20;
        static int TRANSACTION_listAllTransportComponents = 21;
        static int TRANSACTION_getTransportWhitelist = 22;
        static int TRANSACTION_selectBackupTransport = 23;
        static int TRANSACTION_selectBackupTransportAsync = 24;
        static int TRANSACTION_getConfigurationIntent = 25;
        static int TRANSACTION_getDestinationString = 26;
        static int TRANSACTION_getDataManagementIntent = 27;
        static int TRANSACTION_getDataManagementLabel = 28;
        static int TRANSACTION_beginRestoreSession = 29;
        static int TRANSACTION_opComplete = 30;
        static int TRANSACTION_setBackupServiceActive = 31;
        static int TRANSACTION_isBackupServiceActive = 32;
        static int TRANSACTION_getAvailableRestoreToken = 33;
        static int TRANSACTION_isAppEligibleForBackup = 34;
        static int TRANSACTION_filterAppsEligibleForBackup = 35;
        static int TRANSACTION_requestBackup = 36;
        static int TRANSACTION_cancelBackups = 37;

        private void $$robo$$android_app_backup_IBackupManager_Stub$__constructor__() {
            this.attachInterface(this, "android.app.backup.IBackupManager");
        }

        private static final IBackupManager $$robo$$android_app_backup_IBackupManager_Stub$asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface("android.app.backup.IBackupManager");
            if (iin != null && iin instanceof IBackupManager) {
                return (IBackupManager)iin;
            }
            return new Proxy(obj);
        }

        private final IBinder $$robo$$android_app_backup_IBackupManager_Stub$asBinder() {
            return this;
        }

        private final boolean $$robo$$android_app_backup_IBackupManager_Stub$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = "android.app.backup.IBackupManager";
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.dataChanged(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.clearBackupData(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    IBackupObserver _arg1 = IBackupObserver.Stub.asInterface(data.readStrongBinder());
                    this.initializeTransports(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    this.agentConnected(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.agentDisconnected(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.restoreAtInstall(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setBackupEnabled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setAutoRestore(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setBackupProvisioned(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isBackupEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.setBackupPassword(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.hasBackupPassword();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    this.backupNow();
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    ParcelFileDescriptor _arg0 = 0 != data.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    boolean _arg3 = 0 != data.readInt();
                    boolean _arg4 = 0 != data.readInt();
                    boolean _arg5 = 0 != data.readInt();
                    boolean _arg6 = 0 != data.readInt();
                    boolean _arg7 = 0 != data.readInt();
                    boolean _arg8 = 0 != data.readInt();
                    String[] _arg9 = data.createStringArray();
                    this.adbBackup(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    this.fullTransportBackup(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    ParcelFileDescriptor _arg0 = 0 != data.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(data) : null;
                    this.adbRestore(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    IFullBackupRestoreObserver _arg4 = IFullBackupRestoreObserver.Stub.asInterface(data.readStrongBinder());
                    this.acknowledgeFullBackupOrRestore(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    Intent _arg2 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    String _arg3 = data.readString();
                    Intent _arg4 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    String _arg5 = data.readString();
                    this.updateTransportAttributes(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    String _result = this.getCurrentTransport();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.listAllTransports();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.listAllTransportComponents();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.getTransportWhitelist();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _result = this.selectBackupTransport(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    ISelectBackupTransportCallback _arg1 = ISelectBackupTransportCallback.Stub.asInterface(data.readStrongBinder());
                    this.selectBackupTransportAsync(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Intent _result = this.getConfigurationIntent(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _result = this.getDestinationString(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Intent _result = this.getDataManagementIntent(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _result = this.getDataManagementLabel(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    IRestoreSession _result = this.beginRestoreSession(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    this.opComplete(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.setBackupServiceActive(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.isBackupServiceActive(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    long _result = this.getAvailableRestoreToken(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isAppEligibleForBackup(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    String[] _result = this.filterAppsEligibleForBackup(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    IBackupObserver _arg1 = IBackupObserver.Stub.asInterface(data.readStrongBinder());
                    IBackupManagerMonitor _arg2 = IBackupManagerMonitor.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    int _result = this.requestBackup(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    this.cancelBackups();
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private void __constructor__() {
            this.$$robo$$android_app_backup_IBackupManager_Stub$__constructor__();
        }

        public Stub() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_IBackupManager_Stub$__constructor__(), 0, this);
        }

        public static IBackupManager asInterface(IBinder iBinder) {
            return InvokeDynamicSupport.bootstrapStatic("asInterface", $$robo$$android_app_backup_IBackupManager_Stub$asInterface(android.os.IBinder ), 0, (IBinder)iBinder);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_app_backup_IBackupManager_Stub$asBinder(), 0, this);
        }

        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_app_backup_IBackupManager_Stub$onTransact(int android.os.Parcel android.os.Parcel int ), 0, this, n, parcel, parcel2, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Stub)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class Proxy
        implements IBackupManager,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private IBinder mRemote;

            private void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$__constructor__(IBinder remote) {
                this.mRemote = remote;
            }

            private final IBinder $$robo$$android_app_backup_IBackupManager_Stub_Proxy$asBinder() {
                return this.mRemote;
            }

            private final String $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getInterfaceDescriptor() {
                return "android.app.backup.IBackupManager";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$dataChanged(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeString(packageName);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$clearBackupData(String transportName, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeString(transportName);
                    _data.writeString(packageName);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$initializeTransports(String[] transportNames, IBackupObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeStringArray(transportNames);
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$agentConnected(String packageName, IBinder agent) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeString(packageName);
                    _data.writeStrongBinder(agent);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$agentDisconnected(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeString(packageName);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$restoreAtInstall(String packageName, int token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeString(packageName);
                    _data.writeInt(token);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$setBackupEnabled(boolean isEnabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeInt(isEnabled ? 1 : 0);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$setAutoRestore(boolean doAutoRestore) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeInt(doAutoRestore ? 1 : 0);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$setBackupProvisioned(boolean isProvisioned) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeInt(isProvisioned ? 1 : 0);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_app_backup_IBackupManager_Stub_Proxy$isBackupEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_app_backup_IBackupManager_Stub_Proxy$setBackupPassword(String currentPw, String newPw) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeString(currentPw);
                    _data.writeString(newPw);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_app_backup_IBackupManager_Stub_Proxy$hasBackupPassword() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$backupNow() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$adbBackup(ParcelFileDescriptor fd, boolean includeApks, boolean includeObbs, boolean includeShared, boolean doWidgets, boolean allApps, boolean allIncludesSystem, boolean doCompress, boolean doKeyValue, String[] packageNames) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    if (fd != null) {
                        _data.writeInt(1);
                        fd.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(includeApks ? 1 : 0);
                    _data.writeInt(includeObbs ? 1 : 0);
                    _data.writeInt(includeShared ? 1 : 0);
                    _data.writeInt(doWidgets ? 1 : 0);
                    _data.writeInt(allApps ? 1 : 0);
                    _data.writeInt(allIncludesSystem ? 1 : 0);
                    _data.writeInt(doCompress ? 1 : 0);
                    _data.writeInt(doKeyValue ? 1 : 0);
                    _data.writeStringArray(packageNames);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$fullTransportBackup(String[] packageNames) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeStringArray(packageNames);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$adbRestore(ParcelFileDescriptor fd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    if (fd != null) {
                        _data.writeInt(1);
                        fd.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$acknowledgeFullBackupOrRestore(int token, boolean allow, String curPassword, String encryptionPassword, IFullBackupRestoreObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeInt(token);
                    _data.writeInt(allow ? 1 : 0);
                    _data.writeString(curPassword);
                    _data.writeString(encryptionPassword);
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$updateTransportAttributes(ComponentName transportComponent, String name, Intent configurationIntent, String currentDestinationString, Intent dataManagementIntent, String dataManagementLabel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    if (transportComponent != null) {
                        _data.writeInt(1);
                        transportComponent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(name);
                    if (configurationIntent != null) {
                        _data.writeInt(1);
                        configurationIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(currentDestinationString);
                    if (dataManagementIntent != null) {
                        _data.writeInt(1);
                        dataManagementIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(dataManagementLabel);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getCurrentTransport() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String[] $$robo$$android_app_backup_IBackupManager_Stub_Proxy$listAllTransports() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final ComponentName[] $$robo$$android_app_backup_IBackupManager_Stub_Proxy$listAllTransportComponents() throws RemoteException {
                ComponentName[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String[] $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getTransportWhitelist() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_app_backup_IBackupManager_Stub_Proxy$selectBackupTransport(String transport) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeString(transport);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$selectBackupTransportAsync(ComponentName transport, ISelectBackupTransportCallback listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    if (transport != null) {
                        _data.writeInt(1);
                        transport.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Intent $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getConfigurationIntent(String transport) throws RemoteException {
                Intent _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeString(transport);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Intent.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getDestinationString(String transport) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeString(transport);
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Intent $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getDataManagementIntent(String transport) throws RemoteException {
                Intent _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeString(transport);
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Intent.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getDataManagementLabel(String transport) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeString(transport);
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final IRestoreSession $$robo$$android_app_backup_IBackupManager_Stub_Proxy$beginRestoreSession(String packageName, String transportID) throws RemoteException {
                IRestoreSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeString(packageName);
                    _data.writeString(transportID);
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = IRestoreSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$opComplete(int token, long result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeInt(token);
                    _data.writeLong(result);
                    this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$setBackupServiceActive(int whichUser, boolean makeActive) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeInt(whichUser);
                    _data.writeInt(makeActive ? 1 : 0);
                    this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_app_backup_IBackupManager_Stub_Proxy$isBackupServiceActive(int whichUser) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeInt(whichUser);
                    this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final long $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getAvailableRestoreToken(String packageName) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeString(packageName);
                    this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_app_backup_IBackupManager_Stub_Proxy$isAppEligibleForBackup(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeString(packageName);
                    this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String[] $$robo$$android_app_backup_IBackupManager_Stub_Proxy$filterAppsEligibleForBackup(String[] packages) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeStringArray(packages);
                    this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_app_backup_IBackupManager_Stub_Proxy$requestBackup(String[] packages, IBackupObserver observer, IBackupManagerMonitor monitor, int flags) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    _data.writeStringArray(packages);
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    _data.writeStrongBinder(monitor != null ? monitor.asBinder() : null);
                    _data.writeInt(flags);
                    this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            private final void $$robo$$android_app_backup_IBackupManager_Stub_Proxy$cancelBackups() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.app.backup.IBackupManager");
                    this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private void __constructor__(IBinder iBinder) {
                this.$$robo$$android_app_backup_IBackupManager_Stub_Proxy$__constructor__(iBinder);
            }

            Proxy(IBinder iBinder) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$__constructor__(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public IBinder asBinder() {
                return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$asBinder(), 0, this);
            }

            public String getInterfaceDescriptor() {
                return InvokeDynamicSupport.bootstrap("getInterfaceDescriptor", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getInterfaceDescriptor(), 0, this);
            }

            @Override
            public void dataChanged(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("dataChanged", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$dataChanged(java.lang.String ), 0, this, string2);
            }

            @Override
            public void clearBackupData(String string2, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("clearBackupData", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$clearBackupData(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public void initializeTransports(String[] stringArray, IBackupObserver iBackupObserver) throws RemoteException {
                InvokeDynamicSupport.bootstrap("initializeTransports", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$initializeTransports(java.lang.String[] android.app.backup.IBackupObserver ), 0, this, stringArray, iBackupObserver);
            }

            @Override
            public void agentConnected(String string2, IBinder iBinder) throws RemoteException {
                InvokeDynamicSupport.bootstrap("agentConnected", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$agentConnected(java.lang.String android.os.IBinder ), 0, this, string2, iBinder);
            }

            @Override
            public void agentDisconnected(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("agentDisconnected", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$agentDisconnected(java.lang.String ), 0, this, string2);
            }

            @Override
            public void restoreAtInstall(String string2, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("restoreAtInstall", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$restoreAtInstall(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public void setBackupEnabled(boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setBackupEnabled", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$setBackupEnabled(boolean ), 0, this, bl);
            }

            @Override
            public void setAutoRestore(boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setAutoRestore", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$setAutoRestore(boolean ), 0, this, bl);
            }

            @Override
            public void setBackupProvisioned(boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setBackupProvisioned", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$setBackupProvisioned(boolean ), 0, this, bl);
            }

            @Override
            public boolean isBackupEnabled() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isBackupEnabled", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$isBackupEnabled(), 0, this);
            }

            @Override
            public boolean setBackupPassword(String string2, String string3) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setBackupPassword", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$setBackupPassword(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public boolean hasBackupPassword() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("hasBackupPassword", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$hasBackupPassword(), 0, this);
            }

            @Override
            public void backupNow() throws RemoteException {
                InvokeDynamicSupport.bootstrap("backupNow", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$backupNow(), 0, this);
            }

            @Override
            public void adbBackup(ParcelFileDescriptor parcelFileDescriptor, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, String[] stringArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("adbBackup", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$adbBackup(android.os.ParcelFileDescriptor boolean boolean boolean boolean boolean boolean boolean boolean java.lang.String[] ), 0, this, parcelFileDescriptor, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, stringArray);
            }

            @Override
            public void fullTransportBackup(String[] stringArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("fullTransportBackup", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$fullTransportBackup(java.lang.String[] ), 0, this, stringArray);
            }

            @Override
            public void adbRestore(ParcelFileDescriptor parcelFileDescriptor) throws RemoteException {
                InvokeDynamicSupport.bootstrap("adbRestore", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$adbRestore(android.os.ParcelFileDescriptor ), 0, this, parcelFileDescriptor);
            }

            @Override
            public void acknowledgeFullBackupOrRestore(int n, boolean bl, String string2, String string3, IFullBackupRestoreObserver iFullBackupRestoreObserver) throws RemoteException {
                InvokeDynamicSupport.bootstrap("acknowledgeFullBackupOrRestore", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$acknowledgeFullBackupOrRestore(int boolean java.lang.String java.lang.String android.app.backup.IFullBackupRestoreObserver ), 0, this, n, bl, string2, string3, iFullBackupRestoreObserver);
            }

            @Override
            public void updateTransportAttributes(ComponentName componentName, String string2, Intent intent, String string3, Intent intent2, String string4) throws RemoteException {
                InvokeDynamicSupport.bootstrap("updateTransportAttributes", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$updateTransportAttributes(android.content.ComponentName java.lang.String android.content.Intent java.lang.String android.content.Intent java.lang.String ), 0, this, componentName, string2, intent, string3, intent2, string4);
            }

            @Override
            public String getCurrentTransport() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getCurrentTransport", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getCurrentTransport(), 0, this);
            }

            @Override
            public String[] listAllTransports() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("listAllTransports", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$listAllTransports(), 0, this);
            }

            @Override
            public ComponentName[] listAllTransportComponents() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("listAllTransportComponents", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$listAllTransportComponents(), 0, this);
            }

            @Override
            public String[] getTransportWhitelist() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getTransportWhitelist", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getTransportWhitelist(), 0, this);
            }

            @Override
            public String selectBackupTransport(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("selectBackupTransport", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$selectBackupTransport(java.lang.String ), 0, this, string2);
            }

            @Override
            public void selectBackupTransportAsync(ComponentName componentName, ISelectBackupTransportCallback iSelectBackupTransportCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("selectBackupTransportAsync", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$selectBackupTransportAsync(android.content.ComponentName android.app.backup.ISelectBackupTransportCallback ), 0, this, componentName, iSelectBackupTransportCallback);
            }

            @Override
            public Intent getConfigurationIntent(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getConfigurationIntent", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getConfigurationIntent(java.lang.String ), 0, this, string2);
            }

            @Override
            public String getDestinationString(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getDestinationString", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getDestinationString(java.lang.String ), 0, this, string2);
            }

            @Override
            public Intent getDataManagementIntent(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getDataManagementIntent", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getDataManagementIntent(java.lang.String ), 0, this, string2);
            }

            @Override
            public String getDataManagementLabel(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getDataManagementLabel", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getDataManagementLabel(java.lang.String ), 0, this, string2);
            }

            @Override
            public IRestoreSession beginRestoreSession(String string2, String string3) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("beginRestoreSession", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$beginRestoreSession(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public void opComplete(int n, long l) throws RemoteException {
                InvokeDynamicSupport.bootstrap("opComplete", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$opComplete(int long ), 0, this, n, l);
            }

            @Override
            public void setBackupServiceActive(int n, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setBackupServiceActive", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$setBackupServiceActive(int boolean ), 0, this, n, bl);
            }

            @Override
            public boolean isBackupServiceActive(int n) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isBackupServiceActive", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$isBackupServiceActive(int ), 0, this, n);
            }

            @Override
            public long getAvailableRestoreToken(String string2) throws RemoteException {
                return (long)InvokeDynamicSupport.bootstrap("getAvailableRestoreToken", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$getAvailableRestoreToken(java.lang.String ), 0, this, string2);
            }

            @Override
            public boolean isAppEligibleForBackup(String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isAppEligibleForBackup", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$isAppEligibleForBackup(java.lang.String ), 0, this, string2);
            }

            @Override
            public String[] filterAppsEligibleForBackup(String[] stringArray) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("filterAppsEligibleForBackup", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$filterAppsEligibleForBackup(java.lang.String[] ), 0, this, stringArray);
            }

            @Override
            public int requestBackup(String[] stringArray, IBackupObserver iBackupObserver, IBackupManagerMonitor iBackupManagerMonitor, int n) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("requestBackup", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$requestBackup(java.lang.String[] android.app.backup.IBackupObserver android.app.backup.IBackupManagerMonitor int ), 0, this, stringArray, iBackupObserver, iBackupManagerMonitor, n);
            }

            @Override
            public void cancelBackups() throws RemoteException {
                InvokeDynamicSupport.bootstrap("cancelBackups", $$robo$$android_app_backup_IBackupManager_Stub_Proxy$cancelBackups(), 0, this);
            }

            public /* synthetic */ Proxy() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Proxy)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

