/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.app.ActivityThread;
import android.app.ClientTransactionHandler;
import android.app.servertransaction.ActivityLifecycleItem;
import android.app.servertransaction.ClientTransaction;
import android.app.servertransaction.ClientTransactionItem;
import android.app.servertransaction.PendingTransactionActions;
import android.app.servertransaction.TransactionExecutorHelper;
import android.os.IBinder;
import android.util.IntArray;
import com.android.internal.annotations.VisibleForTesting;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TransactionExecutor
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG_RESOLVER = false;
    private static String TAG = "TransactionExecutor";
    private ClientTransactionHandler mTransactionHandler;
    private PendingTransactionActions mPendingActions;
    private TransactionExecutorHelper mHelper;

    private void $$robo$$android_app_servertransaction_TransactionExecutor$__constructor__(ClientTransactionHandler clientTransactionHandler) {
        this.mPendingActions = new PendingTransactionActions();
        this.mHelper = new TransactionExecutorHelper();
        this.mTransactionHandler = clientTransactionHandler;
    }

    private final void $$robo$$android_app_servertransaction_TransactionExecutor$execute(ClientTransaction transaction) {
        IBinder token = transaction.getActivityToken();
        TransactionExecutor.log("Start resolving transaction for client: " + this.mTransactionHandler + ", token: " + token);
        this.executeCallbacks(transaction);
        this.executeLifecycleState(transaction);
        this.mPendingActions.clear();
        TransactionExecutor.log("End resolving transaction");
    }

    @VisibleForTesting
    private final void $$robo$$android_app_servertransaction_TransactionExecutor$executeCallbacks(ClientTransaction transaction) {
        List<ClientTransactionItem> callbacks = transaction.getCallbacks();
        if (callbacks == null) {
            return;
        }
        TransactionExecutor.log("Resolving callbacks");
        IBinder token = transaction.getActivityToken();
        ActivityThread.ActivityClientRecord r = this.mTransactionHandler.getActivityClient(token);
        ActivityLifecycleItem finalStateRequest = transaction.getLifecycleStateRequest();
        int finalState = finalStateRequest != null ? finalStateRequest.getTargetState() : -1;
        int lastCallbackRequestingState = TransactionExecutorHelper.lastCallbackRequestingState(transaction);
        int size = callbacks.size();
        for (int i = 0; i < size; ++i) {
            ClientTransactionItem item = callbacks.get(i);
            TransactionExecutor.log("Resolving callback: " + item);
            int postExecutionState = item.getPostExecutionState();
            int closestPreExecutionState = this.mHelper.getClosestPreExecutionState(r, item.getPostExecutionState());
            if (closestPreExecutionState != -1) {
                this.cycleToPath(r, closestPreExecutionState);
            }
            item.execute(this.mTransactionHandler, token, this.mPendingActions);
            item.postExecute(this.mTransactionHandler, token, this.mPendingActions);
            if (r == null) {
                r = this.mTransactionHandler.getActivityClient(token);
            }
            if (postExecutionState == -1 || r == null) continue;
            boolean shouldExcludeLastTransition = i == lastCallbackRequestingState && finalState == postExecutionState;
            this.cycleToPath(r, postExecutionState, shouldExcludeLastTransition);
        }
    }

    private final void $$robo$$android_app_servertransaction_TransactionExecutor$executeLifecycleState(ClientTransaction transaction) {
        ActivityLifecycleItem lifecycleItem = transaction.getLifecycleStateRequest();
        if (lifecycleItem == null) {
            return;
        }
        TransactionExecutor.log("Resolving lifecycle state: " + lifecycleItem);
        IBinder token = transaction.getActivityToken();
        ActivityThread.ActivityClientRecord r = this.mTransactionHandler.getActivityClient(token);
        if (r == null) {
            return;
        }
        this.cycleToPath(r, lifecycleItem.getTargetState(), true);
        lifecycleItem.execute(this.mTransactionHandler, token, this.mPendingActions);
        lifecycleItem.postExecute(this.mTransactionHandler, token, this.mPendingActions);
    }

    @VisibleForTesting
    private final void $$robo$$android_app_servertransaction_TransactionExecutor$cycleToPath(ActivityThread.ActivityClientRecord r, int finish) {
        this.cycleToPath(r, finish, false);
    }

    private final void $$robo$$android_app_servertransaction_TransactionExecutor$cycleToPath(ActivityThread.ActivityClientRecord r, int finish, boolean excludeLastState) {
        int start = r.getLifecycleState();
        TransactionExecutor.log("Cycle from: " + start + " to: " + finish + " excludeLastState:" + excludeLastState);
        IntArray path = this.mHelper.getLifecyclePath(start, finish, excludeLastState);
        this.performLifecycleSequence(r, path);
    }

    private final void $$robo$$android_app_servertransaction_TransactionExecutor$performLifecycleSequence(ActivityThread.ActivityClientRecord r, IntArray path) {
        int size = path.size();
        block9: for (int i = 0; i < size; ++i) {
            int state = path.get(i);
            TransactionExecutor.log("Transitioning to state: " + state);
            switch (state) {
                case 1: {
                    this.mTransactionHandler.handleLaunchActivity(r, this.mPendingActions, null);
                    continue block9;
                }
                case 2: {
                    this.mTransactionHandler.handleStartActivity(r, this.mPendingActions);
                    continue block9;
                }
                case 3: {
                    this.mTransactionHandler.handleResumeActivity(r.token, false, r.isForward, "LIFECYCLER_RESUME_ACTIVITY");
                    continue block9;
                }
                case 4: {
                    this.mTransactionHandler.handlePauseActivity(r.token, false, false, 0, this.mPendingActions, "LIFECYCLER_PAUSE_ACTIVITY");
                    continue block9;
                }
                case 5: {
                    this.mTransactionHandler.handleStopActivity(r.token, false, 0, this.mPendingActions, false, "LIFECYCLER_STOP_ACTIVITY");
                    continue block9;
                }
                case 6: {
                    this.mTransactionHandler.handleDestroyActivity(r.token, false, 0, false, "performLifecycleSequence. cycling to:" + path.get(size - 1));
                    continue block9;
                }
                case 7: {
                    this.mTransactionHandler.performRestartActivity(r.token, false);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected lifecycle state: " + state);
                }
            }
        }
    }

    private static final void $$robo$$android_app_servertransaction_TransactionExecutor$log(String message) {
    }

    private void __constructor__(ClientTransactionHandler clientTransactionHandler) {
        this.$$robo$$android_app_servertransaction_TransactionExecutor$__constructor__(clientTransactionHandler);
    }

    public TransactionExecutor(ClientTransactionHandler clientTransactionHandler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_servertransaction_TransactionExecutor$__constructor__(android.app.ClientTransactionHandler ), 0, this, clientTransactionHandler);
    }

    public void execute(ClientTransaction clientTransaction) {
        InvokeDynamicSupport.bootstrap("execute", $$robo$$android_app_servertransaction_TransactionExecutor$execute(android.app.servertransaction.ClientTransaction ), 0, this, clientTransaction);
    }

    public void executeCallbacks(ClientTransaction clientTransaction) {
        InvokeDynamicSupport.bootstrap("executeCallbacks", $$robo$$android_app_servertransaction_TransactionExecutor$executeCallbacks(android.app.servertransaction.ClientTransaction ), 0, this, clientTransaction);
    }

    private void executeLifecycleState(ClientTransaction clientTransaction) {
        InvokeDynamicSupport.bootstrap("executeLifecycleState", $$robo$$android_app_servertransaction_TransactionExecutor$executeLifecycleState(android.app.servertransaction.ClientTransaction ), 0, this, clientTransaction);
    }

    public void cycleToPath(ActivityThread.ActivityClientRecord activityClientRecord, int n) {
        InvokeDynamicSupport.bootstrap("cycleToPath", $$robo$$android_app_servertransaction_TransactionExecutor$cycleToPath(android.app.ActivityThread$ActivityClientRecord int ), 0, this, activityClientRecord, n);
    }

    private void cycleToPath(ActivityThread.ActivityClientRecord activityClientRecord, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("cycleToPath", $$robo$$android_app_servertransaction_TransactionExecutor$cycleToPath(android.app.ActivityThread$ActivityClientRecord int boolean ), 0, this, activityClientRecord, n, bl);
    }

    private void performLifecycleSequence(ActivityThread.ActivityClientRecord activityClientRecord, IntArray intArray) {
        InvokeDynamicSupport.bootstrap("performLifecycleSequence", $$robo$$android_app_servertransaction_TransactionExecutor$performLifecycleSequence(android.app.ActivityThread$ActivityClientRecord android.util.IntArray ), 0, this, activityClientRecord, intArray);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_app_servertransaction_TransactionExecutor$log(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ TransactionExecutor() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransactionExecutor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

