/*
 * Decompiled with CFR 0.152.
 */
package android.app.slice;

import android.app.slice.ISliceManager;
import android.app.slice.Slice;
import android.app.slice.SliceSpec;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SliceManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SliceManager";
    public static String ACTION_REQUEST_SLICE_PERMISSION = "com.android.intent.action.REQUEST_SLICE_PERMISSION";
    public static String CATEGORY_SLICE = "android.app.slice.category.SLICE";
    public static String SLICE_METADATA_KEY = "android.metadata.SLICE_URI";
    private ISliceManager mService;
    private Context mContext;
    private IBinder mToken;

    private void $$robo$$android_app_slice_SliceManager$__constructor__(Context context, Handler handler) throws ServiceManager.ServiceNotFoundException {
        this.mToken = new Binder();
        this.mContext = context;
        this.mService = ISliceManager.Stub.asInterface(ServiceManager.getServiceOrThrow("slice"));
    }

    private final void $$robo$$android_app_slice_SliceManager$pinSlice(Uri uri, Set<SliceSpec> specs) {
        try {
            this.mService.pinSlice(this.mContext.getPackageName(), uri, specs.toArray(new SliceSpec[specs.size()]), this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_app_slice_SliceManager$pinSlice(Uri uri, List<SliceSpec> specs) {
        this.pinSlice(uri, new ArraySet<SliceSpec>(specs));
    }

    private final void $$robo$$android_app_slice_SliceManager$unpinSlice(Uri uri) {
        try {
            this.mService.unpinSlice(this.mContext.getPackageName(), uri, this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_slice_SliceManager$hasSliceAccess() {
        try {
            return this.mService.hasSliceAccess(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Set<SliceSpec> $$robo$$android_app_slice_SliceManager$getPinnedSpecs(Uri uri) {
        try {
            return new ArraySet<SliceSpec>(Arrays.asList(this.mService.getPinnedSpecs(uri, this.mContext.getPackageName())));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<Uri> $$robo$$android_app_slice_SliceManager$getPinnedSlices() {
        try {
            return Arrays.asList(this.mService.getPinnedSlices(this.mContext.getPackageName()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Collection<Uri> $$robo$$android_app_slice_SliceManager$getSliceDescendants(Uri uri) {
        ArrayList<Uri> arrayList;
        block8: {
            ContentResolver resolver = this.mContext.getContentResolver();
            ContentProviderClient provider = resolver.acquireUnstableContentProviderClient(uri);
            Throwable throwable = null;
            try {
                Bundle extras = new Bundle();
                extras.putParcelable("slice_uri", uri);
                Bundle res = provider.call("get_descendants", null, extras);
                arrayList = res.getParcelableArrayList("slice_descendants");
                if (provider == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (provider != null) {
                            SliceManager.$closeResource(throwable, provider);
                        }
                        throw throwable3;
                    }
                }
                catch (RemoteException e) {
                    Log.e("SliceManager", "Unable to get slice descendants", e);
                    return Collections.emptyList();
                }
            }
            SliceManager.$closeResource(throwable, provider);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Slice $$robo$$android_app_slice_SliceManager$bindSlice(Uri uri, Set<SliceSpec> supportedSpecs) {
        Preconditions.checkNotNull(uri, "uri");
        ContentResolver resolver = this.mContext.getContentResolver();
        try (ContentProviderClient provider = resolver.acquireUnstableContentProviderClient(uri);){
            if (provider == null) {
                Log.w("SliceManager", String.format("Unknown URI: %s", uri));
                Slice slice = null;
                return slice;
            }
            Bundle extras = new Bundle();
            extras.putParcelable("slice_uri", uri);
            extras.putParcelableArrayList("supported_specs", new ArrayList<SliceSpec>(supportedSpecs));
            Bundle res = provider.call("bind_slice", null, extras);
            Bundle.setDefusable(res, true);
            if (res == null) {
                Slice slice = null;
                return slice;
            }
            Slice slice = (Slice)res.getParcelable("slice");
            return slice;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Deprecated
    private final Slice $$robo$$android_app_slice_SliceManager$bindSlice(Uri uri, List<SliceSpec> supportedSpecs) {
        return this.bindSlice(uri, new ArraySet<SliceSpec>(supportedSpecs));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Uri $$robo$$android_app_slice_SliceManager$mapIntentToUri(Intent intent) {
        ContentResolver resolver = this.mContext.getContentResolver();
        Uri staticUri = this.resolveStatic(intent, resolver);
        if (staticUri != null) {
            return staticUri;
        }
        String authority = this.getAuthority(intent);
        if (authority == null) {
            return null;
        }
        Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
        try (ContentProviderClient provider = resolver.acquireUnstableContentProviderClient(uri);){
            if (provider == null) {
                Log.w("SliceManager", String.format("Unknown URI: %s", uri));
                Uri uri2 = null;
                return uri2;
            }
            Bundle extras = new Bundle();
            extras.putParcelable("slice_intent", intent);
            Bundle res = provider.call("map_only", null, extras);
            if (res == null) {
                Uri uri3 = null;
                return uri3;
            }
            Uri uri4 = (Uri)res.getParcelable("slice");
            return uri4;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final String $$robo$$android_app_slice_SliceManager$getAuthority(Intent intent) {
        List<ResolveInfo> providers;
        Intent queryIntent = new Intent(intent);
        if (!queryIntent.hasCategory("android.app.slice.category.SLICE")) {
            queryIntent.addCategory("android.app.slice.category.SLICE");
        }
        return (providers = this.mContext.getPackageManager().queryIntentContentProviders(queryIntent, 0)) != null && !providers.isEmpty() ? providers.get((int)0).providerInfo.authority : null;
    }

    private final Uri $$robo$$android_app_slice_SliceManager$resolveStatic(Intent intent, ContentResolver resolver) {
        Preconditions.checkNotNull(intent, "intent");
        Preconditions.checkArgument(intent.getComponent() != null || intent.getPackage() != null || intent.getData() != null, "Slice intent must be explicit %s", intent);
        Uri intentData = intent.getData();
        if (intentData != null && "vnd.android.slice".equals(resolver.getType(intentData))) {
            return intentData;
        }
        ResolveInfo resolve = this.mContext.getPackageManager().resolveActivity(intent, 128);
        if (resolve != null && resolve.activityInfo != null && resolve.activityInfo.metaData != null && resolve.activityInfo.metaData.containsKey("android.metadata.SLICE_URI")) {
            return Uri.parse(resolve.activityInfo.metaData.getString("android.metadata.SLICE_URI"));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Slice $$robo$$android_app_slice_SliceManager$bindSlice(Intent intent, Set<SliceSpec> supportedSpecs) {
        Preconditions.checkNotNull(intent, "intent");
        Preconditions.checkArgument(intent.getComponent() != null || intent.getPackage() != null || intent.getData() != null, "Slice intent must be explicit %s", intent);
        ContentResolver resolver = this.mContext.getContentResolver();
        Uri staticUri = this.resolveStatic(intent, resolver);
        if (staticUri != null) {
            return this.bindSlice(staticUri, supportedSpecs);
        }
        String authority = this.getAuthority(intent);
        if (authority == null) {
            return null;
        }
        Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
        try (ContentProviderClient provider = resolver.acquireUnstableContentProviderClient(uri);){
            if (provider == null) {
                Log.w("SliceManager", String.format("Unknown URI: %s", uri));
                Slice slice = null;
                return slice;
            }
            Bundle extras = new Bundle();
            extras.putParcelable("slice_intent", intent);
            Bundle res = provider.call("map_slice", null, extras);
            if (res == null) {
                Slice slice = null;
                return slice;
            }
            Slice slice = (Slice)res.getParcelable("slice");
            return slice;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Deprecated
    private final Slice $$robo$$android_app_slice_SliceManager$bindSlice(Intent intent, List<SliceSpec> supportedSpecs) {
        return this.bindSlice(intent, new ArraySet<SliceSpec>(supportedSpecs));
    }

    private final int $$robo$$android_app_slice_SliceManager$checkSlicePermission(Uri uri, int pid, int uid) {
        try {
            return this.mService.checkSlicePermission(uri, null, pid, uid, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_slice_SliceManager$grantSlicePermission(String toPackage, Uri uri) {
        try {
            this.mService.grantSlicePermission(this.mContext.getPackageName(), toPackage, uri);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_slice_SliceManager$revokeSlicePermission(String toPackage, Uri uri) {
        try {
            this.mService.revokeSlicePermission(this.mContext.getPackageName(), toPackage, uri);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_slice_SliceManager$enforceSlicePermission(Uri uri, String pkg, int pid, int uid, String[] autoGrantPermissions) {
        try {
            if (UserHandle.isSameApp(uid, Process.myUid())) {
                return;
            }
            if (pkg == null) {
                throw new SecurityException("No pkg specified");
            }
            int result = this.mService.checkSlicePermission(uri, pkg, pid, uid, autoGrantPermissions);
            if (result == -1) {
                throw new SecurityException("User " + uid + " does not have slice permission for " + uri + ".");
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_slice_SliceManager$grantPermissionFromUser(Uri uri, String pkg, boolean allSlices) {
        try {
            this.mService.grantPermissionFromUser(uri, pkg, this.mContext.getPackageName(), allSlices);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void __constructor__(Context context, Handler handler) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$$android_app_slice_SliceManager$__constructor__(context, handler);
    }

    public SliceManager(Context context, Handler handler) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_slice_SliceManager$__constructor__(android.content.Context android.os.Handler ), 0, this, context, handler);
    }

    public void pinSlice(Uri uri, Set<SliceSpec> set) {
        InvokeDynamicSupport.bootstrap("pinSlice", $$robo$$android_app_slice_SliceManager$pinSlice(android.net.Uri java.util.Set<android.app.slice.SliceSpec> ), 0, this, uri, set);
    }

    @Deprecated
    public void pinSlice(Uri uri, List<SliceSpec> list) {
        InvokeDynamicSupport.bootstrap("pinSlice", $$robo$$android_app_slice_SliceManager$pinSlice(android.net.Uri java.util.List<android.app.slice.SliceSpec> ), 0, this, uri, list);
    }

    public void unpinSlice(Uri uri) {
        InvokeDynamicSupport.bootstrap("unpinSlice", $$robo$$android_app_slice_SliceManager$unpinSlice(android.net.Uri ), 0, this, uri);
    }

    public boolean hasSliceAccess() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSliceAccess", $$robo$$android_app_slice_SliceManager$hasSliceAccess(), 0, this);
    }

    public Set<SliceSpec> getPinnedSpecs(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getPinnedSpecs", $$robo$$android_app_slice_SliceManager$getPinnedSpecs(android.net.Uri ), 0, this, uri);
    }

    public List<Uri> getPinnedSlices() {
        return InvokeDynamicSupport.bootstrap("getPinnedSlices", $$robo$$android_app_slice_SliceManager$getPinnedSlices(), 0, this);
    }

    public Collection<Uri> getSliceDescendants(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getSliceDescendants", $$robo$$android_app_slice_SliceManager$getSliceDescendants(android.net.Uri ), 0, this, uri);
    }

    public Slice bindSlice(Uri uri, Set<SliceSpec> set) {
        return InvokeDynamicSupport.bootstrap("bindSlice", $$robo$$android_app_slice_SliceManager$bindSlice(android.net.Uri java.util.Set<android.app.slice.SliceSpec> ), 0, this, uri, set);
    }

    @Deprecated
    public Slice bindSlice(Uri uri, List<SliceSpec> list) {
        return InvokeDynamicSupport.bootstrap("bindSlice", $$robo$$android_app_slice_SliceManager$bindSlice(android.net.Uri java.util.List<android.app.slice.SliceSpec> ), 0, this, uri, list);
    }

    public Uri mapIntentToUri(Intent intent) {
        return InvokeDynamicSupport.bootstrap("mapIntentToUri", $$robo$$android_app_slice_SliceManager$mapIntentToUri(android.content.Intent ), 0, this, intent);
    }

    private String getAuthority(Intent intent) {
        return InvokeDynamicSupport.bootstrap("getAuthority", $$robo$$android_app_slice_SliceManager$getAuthority(android.content.Intent ), 0, this, intent);
    }

    private Uri resolveStatic(Intent intent, ContentResolver contentResolver) {
        return InvokeDynamicSupport.bootstrap("resolveStatic", $$robo$$android_app_slice_SliceManager$resolveStatic(android.content.Intent android.content.ContentResolver ), 0, this, intent, contentResolver);
    }

    public Slice bindSlice(Intent intent, Set<SliceSpec> set) {
        return InvokeDynamicSupport.bootstrap("bindSlice", $$robo$$android_app_slice_SliceManager$bindSlice(android.content.Intent java.util.Set<android.app.slice.SliceSpec> ), 0, this, intent, set);
    }

    @Deprecated
    public Slice bindSlice(Intent intent, List<SliceSpec> list) {
        return InvokeDynamicSupport.bootstrap("bindSlice", $$robo$$android_app_slice_SliceManager$bindSlice(android.content.Intent java.util.List<android.app.slice.SliceSpec> ), 0, this, intent, list);
    }

    public int checkSlicePermission(Uri uri, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("checkSlicePermission", $$robo$$android_app_slice_SliceManager$checkSlicePermission(android.net.Uri int int ), 0, this, uri, n, n2);
    }

    public void grantSlicePermission(String string2, Uri uri) {
        InvokeDynamicSupport.bootstrap("grantSlicePermission", $$robo$$android_app_slice_SliceManager$grantSlicePermission(java.lang.String android.net.Uri ), 0, this, string2, uri);
    }

    public void revokeSlicePermission(String string2, Uri uri) {
        InvokeDynamicSupport.bootstrap("revokeSlicePermission", $$robo$$android_app_slice_SliceManager$revokeSlicePermission(java.lang.String android.net.Uri ), 0, this, string2, uri);
    }

    public void enforceSlicePermission(Uri uri, String string2, int n, int n2, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("enforceSlicePermission", $$robo$$android_app_slice_SliceManager$enforceSlicePermission(android.net.Uri java.lang.String int int java.lang.String[] ), 0, this, uri, string2, n, n2, stringArray);
    }

    public void grantPermissionFromUser(Uri uri, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("grantPermissionFromUser", $$robo$$android_app_slice_SliceManager$grantPermissionFromUser(android.net.Uri java.lang.String boolean ), 0, this, uri, string2, bl);
    }

    public /* synthetic */ SliceManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SliceManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

