/*
 * Decompiled with CFR 0.152.
 */
package android.app.slice;

import android.app.PendingIntent;
import android.app.slice.Slice;
import android.app.slice.SliceManager;
import android.app.slice.SliceSpec;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.Process;
import android.os.StrictMode;
import android.util.ArraySet;
import android.util.Log;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class SliceProvider
extends ContentProvider
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String SLICE_TYPE = "vnd.android.slice";
    private static String TAG = "SliceProvider";
    public static String EXTRA_BIND_URI = "slice_uri";
    public static String EXTRA_SUPPORTED_SPECS = "supported_specs";
    public static String METHOD_SLICE = "bind_slice";
    public static String METHOD_MAP_INTENT = "map_slice";
    public static String METHOD_MAP_ONLY_INTENT = "map_only";
    public static String METHOD_PIN = "pin";
    public static String METHOD_UNPIN = "unpin";
    public static String METHOD_GET_DESCENDANTS = "get_descendants";
    public static String METHOD_GET_PERMISSIONS = "get_permissions";
    public static String EXTRA_INTENT = "slice_intent";
    public static String EXTRA_SLICE = "slice";
    public static String EXTRA_SLICE_DESCENDANTS = "slice_descendants";
    public static String EXTRA_PKG = "pkg";
    public static String EXTRA_PROVIDER_PKG = "provider_pkg";
    public static String EXTRA_RESULT = "result";
    private static boolean DEBUG = false;
    private static long SLICE_BIND_ANR = 2000L;
    private String[] mAutoGrantPermissions;
    private String mCallback;
    private SliceManager mSliceManager;
    private Runnable mAnr;

    private void $$robo$$android_app_slice_SliceProvider$__constructor__(String ... autoGrantPermissions) {
        this.mAnr = () -> {
            Process.sendSignal(Process.myPid(), 3);
            Log.wtf("SliceProvider", "Timed out while handling slice callback " + this.mCallback);
        };
        this.mAutoGrantPermissions = autoGrantPermissions;
    }

    private void $$robo$$android_app_slice_SliceProvider$__constructor__() {
        this.mAnr = () -> {
            Process.sendSignal(Process.myPid(), 3);
            Log.wtf("SliceProvider", "Timed out while handling slice callback " + this.mCallback);
        };
        this.mAutoGrantPermissions = new String[0];
    }

    private final void $$robo$$android_app_slice_SliceProvider$attachInfo(Context context, ProviderInfo info) {
        super.attachInfo(context, info);
        this.mSliceManager = context.getSystemService(SliceManager.class);
    }

    private final Slice $$robo$$android_app_slice_SliceProvider$onBindSlice(Uri sliceUri, Set<SliceSpec> supportedSpecs) {
        return this.onBindSlice(sliceUri, new ArrayList<SliceSpec>(supportedSpecs));
    }

    @Deprecated
    private final Slice $$robo$$android_app_slice_SliceProvider$onBindSlice(Uri sliceUri, List<SliceSpec> supportedSpecs) {
        return null;
    }

    private final void $$robo$$android_app_slice_SliceProvider$onSlicePinned(Uri sliceUri) {
    }

    private final void $$robo$$android_app_slice_SliceProvider$onSliceUnpinned(Uri sliceUri) {
    }

    private final Collection<Uri> $$robo$$android_app_slice_SliceProvider$onGetSliceDescendants(Uri uri) {
        return Collections.emptyList();
    }

    private final Uri $$robo$$android_app_slice_SliceProvider$onMapIntentToUri(Intent intent) {
        throw new UnsupportedOperationException("This provider has not implemented intent to uri mapping");
    }

    private final PendingIntent $$robo$$android_app_slice_SliceProvider$onCreatePermissionRequest(Uri sliceUri) {
        return SliceProvider.createPermissionIntent(this.getContext(), sliceUri, this.getCallingPackage());
    }

    private final int $$robo$$android_app_slice_SliceProvider$update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    private final int $$robo$$android_app_slice_SliceProvider$delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    private final Cursor $$robo$$android_app_slice_SliceProvider$query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    private final Cursor $$robo$$android_app_slice_SliceProvider$query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        return null;
    }

    private final Cursor $$robo$$android_app_slice_SliceProvider$query(Uri uri, String[] projection, Bundle queryArgs, CancellationSignal cancellationSignal) {
        return null;
    }

    private final Uri $$robo$$android_app_slice_SliceProvider$insert(Uri uri, ContentValues values) {
        return null;
    }

    private final String $$robo$$android_app_slice_SliceProvider$getType(Uri uri) {
        return "vnd.android.slice";
    }

    private final Bundle $$robo$$android_app_slice_SliceProvider$call(String method, String arg, Bundle extras) {
        if (method.equals("bind_slice")) {
            Uri uri = SliceProvider.getUriWithoutUserId((Uri)extras.getParcelable("slice_uri"));
            ArrayList<SliceSpec> supportedSpecs = extras.getParcelableArrayList("supported_specs");
            String callingPackage = this.getCallingPackage();
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            Slice s = this.handleBindSlice(uri, supportedSpecs, callingPackage, callingUid, callingPid);
            Bundle b = new Bundle();
            b.putParcelable("slice", s);
            return b;
        }
        if (method.equals("map_slice")) {
            Intent intent = (Intent)extras.getParcelable("slice_intent");
            if (intent == null) {
                return null;
            }
            Uri uri = this.onMapIntentToUri(intent);
            ArrayList<SliceSpec> supportedSpecs = extras.getParcelableArrayList("supported_specs");
            Bundle b = new Bundle();
            if (uri != null) {
                Slice s = this.handleBindSlice(uri, supportedSpecs, this.getCallingPackage(), Binder.getCallingUid(), Binder.getCallingPid());
                b.putParcelable("slice", s);
            } else {
                b.putParcelable("slice", null);
            }
            return b;
        }
        if (method.equals("map_only")) {
            Intent intent = (Intent)extras.getParcelable("slice_intent");
            if (intent == null) {
                return null;
            }
            Uri uri = this.onMapIntentToUri(intent);
            Bundle b = new Bundle();
            b.putParcelable("slice", uri);
            return b;
        }
        if (method.equals("pin")) {
            Uri uri = SliceProvider.getUriWithoutUserId((Uri)extras.getParcelable("slice_uri"));
            if (Binder.getCallingUid() != 1000) {
                throw new SecurityException("Only the system can pin/unpin slices");
            }
            this.handlePinSlice(uri);
        } else if (method.equals("unpin")) {
            Uri uri = SliceProvider.getUriWithoutUserId((Uri)extras.getParcelable("slice_uri"));
            if (Binder.getCallingUid() != 1000) {
                throw new SecurityException("Only the system can pin/unpin slices");
            }
            this.handleUnpinSlice(uri);
        } else {
            if (method.equals("get_descendants")) {
                Uri uri = SliceProvider.getUriWithoutUserId((Uri)extras.getParcelable("slice_uri"));
                Bundle b = new Bundle();
                b.putParcelableArrayList("slice_descendants", new ArrayList<Uri>(this.handleGetDescendants(uri)));
                return b;
            }
            if (method.equals("get_permissions")) {
                if (Binder.getCallingUid() != 1000) {
                    throw new SecurityException("Only the system can get permissions");
                }
                Bundle b = new Bundle();
                b.putStringArray("result", this.mAutoGrantPermissions);
                return b;
            }
        }
        return super.call(method, arg, extras);
    }

    private final Collection<Uri> $$robo$$android_app_slice_SliceProvider$handleGetDescendants(Uri uri) {
        this.mCallback = "onGetSliceDescendants";
        return this.onGetSliceDescendants(uri);
    }

    private final void $$robo$$android_app_slice_SliceProvider$handlePinSlice(Uri sliceUri) {
        this.mCallback = "onSlicePinned";
        Handler.getMain().postDelayed(this.mAnr, 2000L);
        try {
            this.onSlicePinned(sliceUri);
        }
        finally {
            Handler.getMain().removeCallbacks(this.mAnr);
        }
    }

    private final void $$robo$$android_app_slice_SliceProvider$handleUnpinSlice(Uri sliceUri) {
        this.mCallback = "onSliceUnpinned";
        Handler.getMain().postDelayed(this.mAnr, 2000L);
        try {
            this.onSliceUnpinned(sliceUri);
        }
        finally {
            Handler.getMain().removeCallbacks(this.mAnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Slice $$robo$$android_app_slice_SliceProvider$handleBindSlice(Uri sliceUri, List<SliceSpec> supportedSpecs, String callingPkg, int callingUid, int callingPid) {
        String pkg = callingPkg != null ? callingPkg : this.getContext().getPackageManager().getNameForUid(callingUid);
        try {
            this.mSliceManager.enforceSlicePermission(sliceUri, pkg, callingPid, callingUid, this.mAutoGrantPermissions);
        }
        catch (SecurityException e) {
            return this.createPermissionSlice(this.getContext(), sliceUri, pkg);
        }
        this.mCallback = "onBindSlice";
        Handler.getMain().postDelayed(this.mAnr, 2000L);
        try {
            Slice slice = this.onBindSliceStrict(sliceUri, supportedSpecs);
            return slice;
        }
        finally {
            Handler.getMain().removeCallbacks(this.mAnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Slice $$robo$$android_app_slice_SliceProvider$createPermissionSlice(Context context, Uri sliceUri, String callingPackage) {
        PendingIntent action;
        this.mCallback = "onCreatePermissionRequest";
        Handler.getMain().postDelayed(this.mAnr, 2000L);
        try {
            action = this.onCreatePermissionRequest(sliceUri);
        }
        finally {
            Handler.getMain().removeCallbacks(this.mAnr);
        }
        Slice.Builder parent = new Slice.Builder(sliceUri);
        Slice.Builder childAction = new Slice.Builder(parent).addIcon(Icon.createWithResource(context, 17302717), null, Collections.emptyList()).addHints(Arrays.asList("title", "shortcut")).addAction(action, new Slice.Builder(parent).build(), null);
        TypedValue tv = new TypedValue();
        new ContextThemeWrapper(context, 16974123).getTheme().resolveAttribute(16843829, tv, true);
        int deviceDefaultAccent = tv.data;
        parent.addSubSlice(new Slice.Builder(sliceUri.buildUpon().appendPath("permission").build()).addIcon(Icon.createWithResource(context, 17302263), null, Collections.emptyList()).addText(SliceProvider.getPermissionString(context, callingPackage), null, Collections.emptyList()).addInt(deviceDefaultAccent, "color", Collections.emptyList()).addSubSlice(childAction.build(), null).build(), null);
        return parent.addHints(Arrays.asList("permission_request")).build();
    }

    private static final PendingIntent $$robo$$android_app_slice_SliceProvider$createPermissionIntent(Context context, Uri sliceUri, String callingPackage) {
        Intent intent = new Intent("com.android.intent.action.REQUEST_SLICE_PERMISSION");
        intent.setComponent(new ComponentName("com.android.systemui", "com.android.systemui.SlicePermissionActivity"));
        intent.putExtra("slice_uri", sliceUri);
        intent.putExtra("pkg", callingPackage);
        intent.putExtra("provider_pkg", context.getPackageName());
        intent.setData(sliceUri.buildUpon().appendQueryParameter("package", callingPackage).build());
        return PendingIntent.getActivity(context, 0, intent, 0);
    }

    private static final CharSequence $$robo$$android_app_slice_SliceProvider$getPermissionString(Context context, String callingPackage) {
        PackageManager pm = context.getPackageManager();
        try {
            return context.getString(17040885, pm.getApplicationInfo(callingPackage, 0).loadLabel(pm), context.getApplicationInfo().loadLabel(pm));
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Unknown calling app", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Slice $$robo$$android_app_slice_SliceProvider$onBindSliceStrict(Uri sliceUri, List<SliceSpec> supportedSpecs) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
        try {
            StrictMode.setThreadPolicy(new StrictMode.ThreadPolicy.Builder().detectAll().penaltyDeath().build());
            Slice slice = this.onBindSlice(sliceUri, new ArraySet<SliceSpec>(supportedSpecs));
            return slice;
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
    }

    private void __constructor__(String ... stringArray) {
        this.$$robo$$android_app_slice_SliceProvider$__constructor__(stringArray);
    }

    public SliceProvider(String ... stringArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_slice_SliceProvider$__constructor__(java.lang.String[] ), 0, this, stringArray);
    }

    private void __constructor__() {
        this.$$robo$$android_app_slice_SliceProvider$__constructor__();
    }

    public SliceProvider() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_slice_SliceProvider$__constructor__(), 0, this);
    }

    @Override
    public void attachInfo(Context context, ProviderInfo providerInfo) {
        InvokeDynamicSupport.bootstrap("attachInfo", $$robo$$android_app_slice_SliceProvider$attachInfo(android.content.Context android.content.pm.ProviderInfo ), 0, this, context, providerInfo);
    }

    public Slice onBindSlice(Uri uri, Set<SliceSpec> set) {
        return InvokeDynamicSupport.bootstrap("onBindSlice", $$robo$$android_app_slice_SliceProvider$onBindSlice(android.net.Uri java.util.Set<android.app.slice.SliceSpec> ), 0, this, uri, set);
    }

    @Deprecated
    public Slice onBindSlice(Uri uri, List<SliceSpec> list) {
        return InvokeDynamicSupport.bootstrap("onBindSlice", $$robo$$android_app_slice_SliceProvider$onBindSlice(android.net.Uri java.util.List<android.app.slice.SliceSpec> ), 0, this, uri, list);
    }

    public void onSlicePinned(Uri uri) {
        InvokeDynamicSupport.bootstrap("onSlicePinned", $$robo$$android_app_slice_SliceProvider$onSlicePinned(android.net.Uri ), 0, this, uri);
    }

    public void onSliceUnpinned(Uri uri) {
        InvokeDynamicSupport.bootstrap("onSliceUnpinned", $$robo$$android_app_slice_SliceProvider$onSliceUnpinned(android.net.Uri ), 0, this, uri);
    }

    public Collection<Uri> onGetSliceDescendants(Uri uri) {
        return InvokeDynamicSupport.bootstrap("onGetSliceDescendants", $$robo$$android_app_slice_SliceProvider$onGetSliceDescendants(android.net.Uri ), 0, this, uri);
    }

    public Uri onMapIntentToUri(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onMapIntentToUri", $$robo$$android_app_slice_SliceProvider$onMapIntentToUri(android.content.Intent ), 0, this, intent);
    }

    public PendingIntent onCreatePermissionRequest(Uri uri) {
        return InvokeDynamicSupport.bootstrap("onCreatePermissionRequest", $$robo$$android_app_slice_SliceProvider$onCreatePermissionRequest(android.net.Uri ), 0, this, uri);
    }

    @Override
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("update", $$robo$$android_app_slice_SliceProvider$update(android.net.Uri android.content.ContentValues java.lang.String java.lang.String[] ), 0, this, uri, contentValues, string2, stringArray);
    }

    @Override
    public int delete(Uri uri, String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("delete", $$robo$$android_app_slice_SliceProvider$delete(android.net.Uri java.lang.String java.lang.String[] ), 0, this, uri, string2, stringArray);
    }

    @Override
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_app_slice_SliceProvider$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String ), 0, this, uri, stringArray, string2, stringArray2, string3);
    }

    @Override
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_app_slice_SliceProvider$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String android.os.CancellationSignal ), 0, this, uri, stringArray, string2, stringArray2, string3, cancellationSignal);
    }

    @Override
    public Cursor query(Uri uri, String[] stringArray, Bundle bundle, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_app_slice_SliceProvider$query(android.net.Uri java.lang.String[] android.os.Bundle android.os.CancellationSignal ), 0, this, uri, stringArray, bundle, cancellationSignal);
    }

    @Override
    public Uri insert(Uri uri, ContentValues contentValues) {
        return InvokeDynamicSupport.bootstrap("insert", $$robo$$android_app_slice_SliceProvider$insert(android.net.Uri android.content.ContentValues ), 0, this, uri, contentValues);
    }

    @Override
    public String getType(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_app_slice_SliceProvider$getType(android.net.Uri ), 0, this, uri);
    }

    @Override
    public Bundle call(String string2, String string3, Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("call", $$robo$$android_app_slice_SliceProvider$call(java.lang.String java.lang.String android.os.Bundle ), 0, this, string2, string3, bundle);
    }

    private Collection<Uri> handleGetDescendants(Uri uri) {
        return InvokeDynamicSupport.bootstrap("handleGetDescendants", $$robo$$android_app_slice_SliceProvider$handleGetDescendants(android.net.Uri ), 0, this, uri);
    }

    private void handlePinSlice(Uri uri) {
        InvokeDynamicSupport.bootstrap("handlePinSlice", $$robo$$android_app_slice_SliceProvider$handlePinSlice(android.net.Uri ), 0, this, uri);
    }

    private void handleUnpinSlice(Uri uri) {
        InvokeDynamicSupport.bootstrap("handleUnpinSlice", $$robo$$android_app_slice_SliceProvider$handleUnpinSlice(android.net.Uri ), 0, this, uri);
    }

    private Slice handleBindSlice(Uri uri, List<SliceSpec> list, String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("handleBindSlice", $$robo$$android_app_slice_SliceProvider$handleBindSlice(android.net.Uri java.util.List<android.app.slice.SliceSpec> java.lang.String int int ), 0, this, uri, list, string2, n, n2);
    }

    public Slice createPermissionSlice(Context context, Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrap("createPermissionSlice", $$robo$$android_app_slice_SliceProvider$createPermissionSlice(android.content.Context android.net.Uri java.lang.String ), 0, this, context, uri, string2);
    }

    public static PendingIntent createPermissionIntent(Context context, Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createPermissionIntent", $$robo$$android_app_slice_SliceProvider$createPermissionIntent(android.content.Context android.net.Uri java.lang.String ), 0, (Context)context, (Uri)uri, (String)string2);
    }

    public static CharSequence getPermissionString(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getPermissionString", $$robo$$android_app_slice_SliceProvider$getPermissionString(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    private Slice onBindSliceStrict(Uri uri, List<SliceSpec> list) {
        return InvokeDynamicSupport.bootstrap("onBindSliceStrict", $$robo$$android_app_slice_SliceProvider$onBindSliceStrict(android.net.Uri java.util.List<android.app.slice.SliceSpec> ), 0, this, uri, list);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SliceProvider)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

