/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.app.usage.ExternalStorageStats;
import android.app.usage.IStorageStatsManager;
import android.app.usage.StorageStats;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.ParcelableException;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StorageStatsManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Context mContext;
    private IStorageStatsManager mService;

    private void $$robo$$android_app_usage_StorageStatsManager$__constructor__(Context context, IStorageStatsManager service) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mService = Preconditions.checkNotNull(service);
    }

    private final boolean $$robo$$android_app_usage_StorageStatsManager$isQuotaSupported(UUID storageUuid) {
        try {
            return this.mService.isQuotaSupported(StorageManager.convert(storageUuid), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_app_usage_StorageStatsManager$isQuotaSupported(String uuid) {
        return this.isQuotaSupported(StorageManager.convert(uuid));
    }

    private final boolean $$robo$$android_app_usage_StorageStatsManager$isReservedSupported(UUID storageUuid) {
        try {
            return this.mService.isReservedSupported(StorageManager.convert(storageUuid), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final long $$robo$$android_app_usage_StorageStatsManager$getTotalBytes(UUID storageUuid) throws IOException {
        try {
            return this.mService.getTotalBytes(StorageManager.convert(storageUuid), this.mContext.getOpPackageName());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final long $$robo$$android_app_usage_StorageStatsManager$getTotalBytes(String uuid) throws IOException {
        return this.getTotalBytes(StorageManager.convert(uuid));
    }

    private final long $$robo$$android_app_usage_StorageStatsManager$getFreeBytes(UUID storageUuid) throws IOException {
        try {
            return this.mService.getFreeBytes(StorageManager.convert(storageUuid), this.mContext.getOpPackageName());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final long $$robo$$android_app_usage_StorageStatsManager$getFreeBytes(String uuid) throws IOException {
        return this.getFreeBytes(StorageManager.convert(uuid));
    }

    private final long $$robo$$android_app_usage_StorageStatsManager$getCacheBytes(UUID storageUuid) throws IOException {
        try {
            return this.mService.getCacheBytes(StorageManager.convert(storageUuid), this.mContext.getOpPackageName());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final long $$robo$$android_app_usage_StorageStatsManager$getCacheBytes(String uuid) throws IOException {
        return this.getCacheBytes(StorageManager.convert(uuid));
    }

    private final StorageStats $$robo$$android_app_usage_StorageStatsManager$queryStatsForPackage(UUID storageUuid, String packageName, UserHandle user) throws PackageManager.NameNotFoundException, IOException {
        try {
            return this.mService.queryStatsForPackage(StorageManager.convert(storageUuid), packageName, user.getIdentifier(), this.mContext.getOpPackageName());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(PackageManager.NameNotFoundException.class);
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final StorageStats $$robo$$android_app_usage_StorageStatsManager$queryStatsForPackage(String uuid, String packageName, UserHandle user) throws PackageManager.NameNotFoundException, IOException {
        return this.queryStatsForPackage(StorageManager.convert(uuid), packageName, user);
    }

    private final StorageStats $$robo$$android_app_usage_StorageStatsManager$queryStatsForUid(UUID storageUuid, int uid) throws IOException {
        try {
            return this.mService.queryStatsForUid(StorageManager.convert(storageUuid), uid, this.mContext.getOpPackageName());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final StorageStats $$robo$$android_app_usage_StorageStatsManager$queryStatsForUid(String uuid, int uid) throws IOException {
        return this.queryStatsForUid(StorageManager.convert(uuid), uid);
    }

    private final StorageStats $$robo$$android_app_usage_StorageStatsManager$queryStatsForUser(UUID storageUuid, UserHandle user) throws IOException {
        try {
            return this.mService.queryStatsForUser(StorageManager.convert(storageUuid), user.getIdentifier(), this.mContext.getOpPackageName());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final StorageStats $$robo$$android_app_usage_StorageStatsManager$queryStatsForUser(String uuid, UserHandle user) throws IOException {
        return this.queryStatsForUser(StorageManager.convert(uuid), user);
    }

    private final ExternalStorageStats $$robo$$android_app_usage_StorageStatsManager$queryExternalStatsForUser(UUID storageUuid, UserHandle user) throws IOException {
        try {
            return this.mService.queryExternalStatsForUser(StorageManager.convert(storageUuid), user.getIdentifier(), this.mContext.getOpPackageName());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final ExternalStorageStats $$robo$$android_app_usage_StorageStatsManager$queryExternalStatsForUser(String uuid, UserHandle user) throws IOException {
        return this.queryExternalStatsForUser(StorageManager.convert(uuid), user);
    }

    private final long $$robo$$android_app_usage_StorageStatsManager$getCacheQuotaBytes(String volumeUuid, int uid) {
        try {
            return this.mService.getCacheQuotaBytes(volumeUuid, uid, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void __constructor__(Context context, IStorageStatsManager iStorageStatsManager) {
        this.$$robo$$android_app_usage_StorageStatsManager$__constructor__(context, iStorageStatsManager);
    }

    public StorageStatsManager(Context context, IStorageStatsManager iStorageStatsManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_usage_StorageStatsManager$__constructor__(android.content.Context android.app.usage.IStorageStatsManager ), 0, this, context, iStorageStatsManager);
    }

    public boolean isQuotaSupported(UUID uUID) {
        return (boolean)InvokeDynamicSupport.bootstrap("isQuotaSupported", $$robo$$android_app_usage_StorageStatsManager$isQuotaSupported(java.util.UUID ), 0, this, uUID);
    }

    @Deprecated
    public boolean isQuotaSupported(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isQuotaSupported", $$robo$$android_app_usage_StorageStatsManager$isQuotaSupported(java.lang.String ), 0, this, string2);
    }

    public boolean isReservedSupported(UUID uUID) {
        return (boolean)InvokeDynamicSupport.bootstrap("isReservedSupported", $$robo$$android_app_usage_StorageStatsManager$isReservedSupported(java.util.UUID ), 0, this, uUID);
    }

    public long getTotalBytes(UUID uUID) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("getTotalBytes", $$robo$$android_app_usage_StorageStatsManager$getTotalBytes(java.util.UUID ), 0, this, uUID);
    }

    @Deprecated
    public long getTotalBytes(String string2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("getTotalBytes", $$robo$$android_app_usage_StorageStatsManager$getTotalBytes(java.lang.String ), 0, this, string2);
    }

    public long getFreeBytes(UUID uUID) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("getFreeBytes", $$robo$$android_app_usage_StorageStatsManager$getFreeBytes(java.util.UUID ), 0, this, uUID);
    }

    @Deprecated
    public long getFreeBytes(String string2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("getFreeBytes", $$robo$$android_app_usage_StorageStatsManager$getFreeBytes(java.lang.String ), 0, this, string2);
    }

    public long getCacheBytes(UUID uUID) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("getCacheBytes", $$robo$$android_app_usage_StorageStatsManager$getCacheBytes(java.util.UUID ), 0, this, uUID);
    }

    @Deprecated
    public long getCacheBytes(String string2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("getCacheBytes", $$robo$$android_app_usage_StorageStatsManager$getCacheBytes(java.lang.String ), 0, this, string2);
    }

    public StorageStats queryStatsForPackage(UUID uUID, String string2, UserHandle userHandle) throws PackageManager.NameNotFoundException, IOException {
        return InvokeDynamicSupport.bootstrap("queryStatsForPackage", $$robo$$android_app_usage_StorageStatsManager$queryStatsForPackage(java.util.UUID java.lang.String android.os.UserHandle ), 0, this, uUID, string2, userHandle);
    }

    @Deprecated
    public StorageStats queryStatsForPackage(String string2, String string3, UserHandle userHandle) throws PackageManager.NameNotFoundException, IOException {
        return InvokeDynamicSupport.bootstrap("queryStatsForPackage", $$robo$$android_app_usage_StorageStatsManager$queryStatsForPackage(java.lang.String java.lang.String android.os.UserHandle ), 0, this, string2, string3, userHandle);
    }

    public StorageStats queryStatsForUid(UUID uUID, int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("queryStatsForUid", $$robo$$android_app_usage_StorageStatsManager$queryStatsForUid(java.util.UUID int ), 0, this, uUID, n);
    }

    @Deprecated
    public StorageStats queryStatsForUid(String string2, int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("queryStatsForUid", $$robo$$android_app_usage_StorageStatsManager$queryStatsForUid(java.lang.String int ), 0, this, string2, n);
    }

    public StorageStats queryStatsForUser(UUID uUID, UserHandle userHandle) throws IOException {
        return InvokeDynamicSupport.bootstrap("queryStatsForUser", $$robo$$android_app_usage_StorageStatsManager$queryStatsForUser(java.util.UUID android.os.UserHandle ), 0, this, uUID, userHandle);
    }

    @Deprecated
    public StorageStats queryStatsForUser(String string2, UserHandle userHandle) throws IOException {
        return InvokeDynamicSupport.bootstrap("queryStatsForUser", $$robo$$android_app_usage_StorageStatsManager$queryStatsForUser(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    public ExternalStorageStats queryExternalStatsForUser(UUID uUID, UserHandle userHandle) throws IOException {
        return InvokeDynamicSupport.bootstrap("queryExternalStatsForUser", $$robo$$android_app_usage_StorageStatsManager$queryExternalStatsForUser(java.util.UUID android.os.UserHandle ), 0, this, uUID, userHandle);
    }

    @Deprecated
    public ExternalStorageStats queryExternalStatsForUser(String string2, UserHandle userHandle) throws IOException {
        return InvokeDynamicSupport.bootstrap("queryExternalStatsForUser", $$robo$$android_app_usage_StorageStatsManager$queryExternalStatsForUser(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    public long getCacheQuotaBytes(String string2, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getCacheQuotaBytes", $$robo$$android_app_usage_StorageStatsManager$getCacheQuotaBytes(java.lang.String int ), 0, this, string2, n);
    }

    public /* synthetic */ StorageStatsManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StorageStatsManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

