/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProviderInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.RemoteViewsAdapter;
import android.widget.TextView;
import java.util.concurrent.Executor;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AppWidgetHostView
extends FrameLayout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "AppWidgetHostView";
    private static String KEY_JAILED_ARRAY = "jail";
    static boolean LOGD = false;
    static int VIEW_MODE_NOINIT = 0;
    static int VIEW_MODE_CONTENT = 1;
    static int VIEW_MODE_ERROR = 2;
    static int VIEW_MODE_DEFAULT = 3;
    private static LayoutInflater.Filter INFLATER_FILTER;
    Context mContext;
    Context mRemoteContext;
    int mAppWidgetId;
    AppWidgetProviderInfo mInfo;
    View mView;
    int mViewMode;
    int mLayoutId;
    private RemoteViews.OnClickHandler mOnClickHandler;
    private Executor mAsyncExecutor;
    private CancellationSignal mLastExecutionSignal;

    private void $$robo$$android_appwidget_AppWidgetHostView$__constructor__(Context context) {
    }

    private void $$robo$$android_appwidget_AppWidgetHostView$__constructor__(Context context, RemoteViews.OnClickHandler handler) {
        this.mOnClickHandler = handler;
    }

    private void $$robo$$android_appwidget_AppWidgetHostView$__constructor__(Context context, int animationIn, int animationOut) {
        this.mViewMode = 0;
        this.mLayoutId = -1;
        this.mContext = context;
        this.setIsRootNamespace(true);
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$setOnClickHandler(RemoteViews.OnClickHandler handler) {
        this.mOnClickHandler = handler;
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$setAppWidget(int appWidgetId, AppWidgetProviderInfo info) {
        this.mAppWidgetId = appWidgetId;
        this.mInfo = info;
        Rect padding = this.getDefaultPadding();
        this.setPadding(padding.left, padding.top, padding.right, padding.bottom);
        if (info != null) {
            String description = info.loadLabel(this.getContext().getPackageManager());
            if ((info.providerInfo.applicationInfo.flags & 0x40000000) != 0) {
                description = Resources.getSystem().getString(17040953, description);
            }
            this.setContentDescription(description);
        }
    }

    private static final Rect $$robo$$android_appwidget_AppWidgetHostView$getDefaultPaddingForWidget(Context context, ComponentName component, Rect padding) {
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getPackageManager().getApplicationInfo(component.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return AppWidgetHostView.getDefaultPaddingForWidget(context, appInfo, padding);
    }

    private static final Rect $$robo$$android_appwidget_AppWidgetHostView$getDefaultPaddingForWidget(Context context, ApplicationInfo appInfo, Rect padding) {
        if (padding == null) {
            padding = new Rect(0, 0, 0, 0);
        } else {
            padding.set(0, 0, 0, 0);
        }
        if (appInfo != null && appInfo.targetSdkVersion >= 14) {
            Resources r = context.getResources();
            padding.left = r.getDimensionPixelSize(17105012);
            padding.right = r.getDimensionPixelSize(17105013);
            padding.top = r.getDimensionPixelSize(17105014);
            padding.bottom = r.getDimensionPixelSize(17105011);
        }
        return padding;
    }

    private final Rect $$robo$$android_appwidget_AppWidgetHostView$getDefaultPadding() {
        return AppWidgetHostView.getDefaultPaddingForWidget(this.mContext, this.mInfo == null ? null : this.mInfo.providerInfo.applicationInfo, null);
    }

    private final int $$robo$$android_appwidget_AppWidgetHostView$getAppWidgetId() {
        return this.mAppWidgetId;
    }

    private final AppWidgetProviderInfo $$robo$$android_appwidget_AppWidgetHostView$getAppWidgetInfo() {
        return this.mInfo;
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        SparseArray<Parcelable> jail = new SparseArray<Parcelable>();
        super.dispatchSaveInstanceState(jail);
        Bundle bundle = new Bundle();
        bundle.putSparseParcelableArray("jail", jail);
        container.put(this.generateId(), bundle);
    }

    private final int $$robo$$android_appwidget_AppWidgetHostView$generateId() {
        int id2 = this.getId();
        return id2 == -1 ? this.mAppWidgetId : id2;
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        Parcelable parcelable = container.get(this.generateId());
        SparseArray<Parcelable> jail = null;
        if (parcelable instanceof Bundle) {
            jail = ((Bundle)parcelable).getSparseParcelableArray("jail");
        }
        if (jail == null) {
            jail = new SparseArray();
        }
        try {
            super.dispatchRestoreInstanceState(jail);
        }
        catch (Exception e) {
            Log.e("AppWidgetHostView", "failed to restoreInstanceState for widget id: " + this.mAppWidgetId + ", " + (this.mInfo == null ? "null" : this.mInfo.provider), e);
        }
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        try {
            super.onLayout(changed, left, top, right, bottom);
        }
        catch (RuntimeException e) {
            Log.e("AppWidgetHostView", "Remote provider threw runtime exception, using error view instead.", e);
            this.removeViewInLayout(this.mView);
            View child = this.getErrorView();
            this.prepareView(child);
            this.addViewInLayout(child, 0, child.getLayoutParams());
            this.measureChild(child, View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), 0x40000000), View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), 0x40000000));
            child.layout(0, 0, child.getMeasuredWidth() + this.mPaddingLeft + this.mPaddingRight, child.getMeasuredHeight() + this.mPaddingTop + this.mPaddingBottom);
            this.mView = child;
            this.mViewMode = 2;
        }
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$updateAppWidgetSize(Bundle newOptions, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        this.updateAppWidgetSize(newOptions, minWidth, minHeight, maxWidth, maxHeight, false);
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$updateAppWidgetSize(Bundle newOptions, int minWidth, int minHeight, int maxWidth, int maxHeight, boolean ignorePadding) {
        if (newOptions == null) {
            newOptions = new Bundle();
        }
        Rect padding = this.getDefaultPadding();
        float density = this.getResources().getDisplayMetrics().density;
        int xPaddingDips = (int)((float)(padding.left + padding.right) / density);
        int yPaddingDips = (int)((float)(padding.top + padding.bottom) / density);
        int newMinWidth = minWidth - (ignorePadding ? 0 : xPaddingDips);
        int newMinHeight = minHeight - (ignorePadding ? 0 : yPaddingDips);
        int newMaxWidth = maxWidth - (ignorePadding ? 0 : xPaddingDips);
        int newMaxHeight = maxHeight - (ignorePadding ? 0 : yPaddingDips);
        AppWidgetManager widgetManager = AppWidgetManager.getInstance(this.mContext);
        Bundle oldOptions = widgetManager.getAppWidgetOptions(this.mAppWidgetId);
        boolean needsUpdate = false;
        if (newMinWidth != oldOptions.getInt("appWidgetMinWidth") || newMinHeight != oldOptions.getInt("appWidgetMinHeight") || newMaxWidth != oldOptions.getInt("appWidgetMaxWidth") || newMaxHeight != oldOptions.getInt("appWidgetMaxHeight")) {
            needsUpdate = true;
        }
        if (needsUpdate) {
            newOptions.putInt("appWidgetMinWidth", newMinWidth);
            newOptions.putInt("appWidgetMinHeight", newMinHeight);
            newOptions.putInt("appWidgetMaxWidth", newMaxWidth);
            newOptions.putInt("appWidgetMaxHeight", newMaxHeight);
            this.updateAppWidgetOptions(newOptions);
        }
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$updateAppWidgetOptions(Bundle options) {
        AppWidgetManager.getInstance(this.mContext).updateAppWidgetOptions(this.mAppWidgetId, options);
    }

    private final FrameLayout.LayoutParams $$robo$$android_appwidget_AppWidgetHostView$generateLayoutParams(AttributeSet attrs) {
        Context context = this.mRemoteContext != null ? this.mRemoteContext : this.mContext;
        return new FrameLayout.LayoutParams(context, attrs);
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$setExecutor(Executor executor) {
        if (this.mLastExecutionSignal != null) {
            this.mLastExecutionSignal.cancel();
            this.mLastExecutionSignal = null;
        }
        this.mAsyncExecutor = executor;
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$resetAppWidget(AppWidgetProviderInfo info) {
        this.setAppWidget(this.mAppWidgetId, info);
        this.mViewMode = 0;
        this.updateAppWidget(null);
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$updateAppWidget(RemoteViews remoteViews) {
        this.applyRemoteViews(remoteViews, true);
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$applyRemoteViews(RemoteViews remoteViews, boolean useAsyncIfPossible) {
        boolean recycled = false;
        View content = null;
        RuntimeException exception = null;
        if (this.mLastExecutionSignal != null) {
            this.mLastExecutionSignal.cancel();
            this.mLastExecutionSignal = null;
        }
        if (remoteViews == null) {
            if (this.mViewMode == 3) {
                return;
            }
            content = this.getDefaultView();
            this.mLayoutId = -1;
            this.mViewMode = 3;
        } else {
            if (this.mAsyncExecutor != null && useAsyncIfPossible) {
                this.inflateAsync(remoteViews);
                return;
            }
            this.mRemoteContext = this.getRemoteContext();
            int layoutId = remoteViews.getLayoutId();
            if (content == null && layoutId == this.mLayoutId) {
                try {
                    remoteViews.reapply(this.mContext, this.mView, this.mOnClickHandler);
                    content = this.mView;
                    recycled = true;
                }
                catch (RuntimeException e) {
                    exception = e;
                }
            }
            if (content == null) {
                try {
                    content = remoteViews.apply(this.mContext, this, this.mOnClickHandler);
                }
                catch (RuntimeException e) {
                    exception = e;
                }
            }
            this.mLayoutId = layoutId;
            this.mViewMode = 1;
        }
        this.applyContent(content, recycled, exception);
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$applyContent(View content, boolean recycled, Exception exception) {
        if (content == null) {
            if (this.mViewMode == 2) {
                return;
            }
            if (exception != null) {
                Log.w("AppWidgetHostView", "Error inflating RemoteViews : " + exception.toString());
            }
            content = this.getErrorView();
            this.mViewMode = 2;
        }
        if (!recycled) {
            this.prepareView(content);
            this.addView(content);
        }
        if (this.mView != content) {
            this.removeView(this.mView);
            this.mView = content;
        }
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$inflateAsync(RemoteViews remoteViews) {
        this.mRemoteContext = this.getRemoteContext();
        int layoutId = remoteViews.getLayoutId();
        if (layoutId == this.mLayoutId && this.mView != null) {
            try {
                this.mLastExecutionSignal = remoteViews.reapplyAsync(this.mContext, this.mView, this.mAsyncExecutor, new ViewApplyListener(this, remoteViews, layoutId, true), this.mOnClickHandler);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mLastExecutionSignal == null) {
            this.mLastExecutionSignal = remoteViews.applyAsync(this.mContext, this, this.mAsyncExecutor, new ViewApplyListener(this, remoteViews, layoutId, false), this.mOnClickHandler);
        }
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$viewDataChanged(int viewId) {
        Object v = this.findViewById(viewId);
        if (v != null && v instanceof AdapterView) {
            AdapterView adapterView = (AdapterView)v;
            Object adapter = adapterView.getAdapter();
            if (adapter instanceof BaseAdapter) {
                BaseAdapter baseAdapter = (BaseAdapter)adapter;
                baseAdapter.notifyDataSetChanged();
            } else if (adapter == null && adapterView instanceof RemoteViewsAdapter.RemoteAdapterConnectionCallback) {
                ((RemoteViewsAdapter.RemoteAdapterConnectionCallback)((Object)adapterView)).deferNotifyDataSetChanged();
            }
        }
    }

    private final Context $$robo$$android_appwidget_AppWidgetHostView$getRemoteContext() {
        try {
            return this.mContext.createApplicationContext(this.mInfo.providerInfo.applicationInfo, 4);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("AppWidgetHostView", "Package name " + this.mInfo.providerInfo.packageName + " not found");
            return this.mContext;
        }
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$prepareView(View view) {
        FrameLayout.LayoutParams requested = (FrameLayout.LayoutParams)view.getLayoutParams();
        if (requested == null) {
            requested = new FrameLayout.LayoutParams(-1, -1);
        }
        requested.gravity = 17;
        view.setLayoutParams(requested);
    }

    private final View $$robo$$android_appwidget_AppWidgetHostView$getDefaultView() {
        View defaultView = null;
        RuntimeException exception = null;
        try {
            if (this.mInfo != null) {
                int category;
                Context theirContext;
                this.mRemoteContext = theirContext = this.getRemoteContext();
                LayoutInflater inflater = (LayoutInflater)theirContext.getSystemService("layout_inflater");
                inflater = inflater.cloneInContext(theirContext);
                inflater.setFilter(INFLATER_FILTER);
                AppWidgetManager manager = AppWidgetManager.getInstance(this.mContext);
                Bundle options = manager.getAppWidgetOptions(this.mAppWidgetId);
                int layoutId = this.mInfo.initialLayout;
                if (options.containsKey("appWidgetCategory") && (category = options.getInt("appWidgetCategory")) == 2) {
                    int kgLayoutId = this.mInfo.initialKeyguardLayout;
                    layoutId = kgLayoutId == 0 ? layoutId : kgLayoutId;
                }
                defaultView = inflater.inflate(layoutId, (ViewGroup)this, false);
            } else {
                Log.w("AppWidgetHostView", "can't inflate defaultView because mInfo is missing");
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        if (exception != null) {
            Log.w("AppWidgetHostView", "Error inflating AppWidget " + this.mInfo + ": " + exception.toString());
        }
        if (defaultView == null) {
            defaultView = this.getErrorView();
        }
        return defaultView;
    }

    private final View $$robo$$android_appwidget_AppWidgetHostView$getErrorView() {
        TextView tv = new TextView(this.mContext);
        tv.setText(17039939);
        tv.setBackgroundColor(Color.argb(127, 0, 0, 0));
        return tv;
    }

    private final void $$robo$$android_appwidget_AppWidgetHostView$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        info.setClassName(AppWidgetHostView.class.getName());
    }

    static void __staticInitializer__() {
        INFLATER_FILTER = clazz -> clazz.isAnnotationPresent(RemoteViews.RemoteView.class);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_appwidget_AppWidgetHostView$__constructor__(context);
    }

    public AppWidgetHostView(Context context) {
        this(context, 0x10A0000, 0x10A0001);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_appwidget_AppWidgetHostView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, RemoteViews.OnClickHandler onClickHandler) {
        this.$$robo$$android_appwidget_AppWidgetHostView$__constructor__(context, onClickHandler);
    }

    public AppWidgetHostView(Context context, RemoteViews.OnClickHandler onClickHandler) {
        this(context, 0x10A0000, 0x10A0001);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_appwidget_AppWidgetHostView$__constructor__(android.content.Context android.widget.RemoteViews$OnClickHandler ), 0, this, context, onClickHandler);
    }

    private void __constructor__(Context context, int n, int n2) {
        this.$$robo$$android_appwidget_AppWidgetHostView$__constructor__(context, n, n2);
    }

    public AppWidgetHostView(Context context, int n, int n2) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_appwidget_AppWidgetHostView$__constructor__(android.content.Context int int ), 0, this, context, n, n2);
    }

    public void setOnClickHandler(RemoteViews.OnClickHandler onClickHandler) {
        InvokeDynamicSupport.bootstrap("setOnClickHandler", $$robo$$android_appwidget_AppWidgetHostView$setOnClickHandler(android.widget.RemoteViews$OnClickHandler ), 0, this, onClickHandler);
    }

    public void setAppWidget(int n, AppWidgetProviderInfo appWidgetProviderInfo) {
        InvokeDynamicSupport.bootstrap("setAppWidget", $$robo$$android_appwidget_AppWidgetHostView$setAppWidget(int android.appwidget.AppWidgetProviderInfo ), 0, this, n, appWidgetProviderInfo);
    }

    public static Rect getDefaultPaddingForWidget(Context context, ComponentName componentName, Rect rect) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultPaddingForWidget", $$robo$$android_appwidget_AppWidgetHostView$getDefaultPaddingForWidget(android.content.Context android.content.ComponentName android.graphics.Rect ), 0, (Context)context, (ComponentName)componentName, (Rect)rect);
    }

    private static Rect getDefaultPaddingForWidget(Context context, ApplicationInfo applicationInfo, Rect rect) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultPaddingForWidget", $$robo$$android_appwidget_AppWidgetHostView$getDefaultPaddingForWidget(android.content.Context android.content.pm.ApplicationInfo android.graphics.Rect ), 0, (Context)context, (ApplicationInfo)applicationInfo, (Rect)rect);
    }

    private Rect getDefaultPadding() {
        return InvokeDynamicSupport.bootstrap("getDefaultPadding", $$robo$$android_appwidget_AppWidgetHostView$getDefaultPadding(), 0, this);
    }

    public int getAppWidgetId() {
        return (int)InvokeDynamicSupport.bootstrap("getAppWidgetId", $$robo$$android_appwidget_AppWidgetHostView$getAppWidgetId(), 0, this);
    }

    public AppWidgetProviderInfo getAppWidgetInfo() {
        return InvokeDynamicSupport.bootstrap("getAppWidgetInfo", $$robo$$android_appwidget_AppWidgetHostView$getAppWidgetInfo(), 0, this);
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("dispatchSaveInstanceState", $$robo$$android_appwidget_AppWidgetHostView$dispatchSaveInstanceState(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    private int generateId() {
        return (int)InvokeDynamicSupport.bootstrap("generateId", $$robo$$android_appwidget_AppWidgetHostView$generateId(), 0, this);
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("dispatchRestoreInstanceState", $$robo$$android_appwidget_AppWidgetHostView$dispatchRestoreInstanceState(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_appwidget_AppWidgetHostView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    public void updateAppWidgetSize(Bundle bundle, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("updateAppWidgetSize", $$robo$$android_appwidget_AppWidgetHostView$updateAppWidgetSize(android.os.Bundle int int int int ), 0, this, bundle, n, n2, n3, n4);
    }

    public void updateAppWidgetSize(Bundle bundle, int n, int n2, int n3, int n4, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateAppWidgetSize", $$robo$$android_appwidget_AppWidgetHostView$updateAppWidgetSize(android.os.Bundle int int int int boolean ), 0, this, bundle, n, n2, n3, n4, bl);
    }

    public void updateAppWidgetOptions(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("updateAppWidgetOptions", $$robo$$android_appwidget_AppWidgetHostView$updateAppWidgetOptions(android.os.Bundle ), 0, this, bundle);
    }

    @Override
    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_appwidget_AppWidgetHostView$generateLayoutParams(android.util.AttributeSet ), 0, this, attributeSet);
    }

    public void setExecutor(Executor executor) {
        InvokeDynamicSupport.bootstrap("setExecutor", $$robo$$android_appwidget_AppWidgetHostView$setExecutor(java.util.concurrent.Executor ), 0, this, executor);
    }

    void resetAppWidget(AppWidgetProviderInfo appWidgetProviderInfo) {
        InvokeDynamicSupport.bootstrap("resetAppWidget", $$robo$$android_appwidget_AppWidgetHostView$resetAppWidget(android.appwidget.AppWidgetProviderInfo ), 0, this, appWidgetProviderInfo);
    }

    public void updateAppWidget(RemoteViews remoteViews) {
        InvokeDynamicSupport.bootstrap("updateAppWidget", $$robo$$android_appwidget_AppWidgetHostView$updateAppWidget(android.widget.RemoteViews ), 0, this, remoteViews);
    }

    protected void applyRemoteViews(RemoteViews remoteViews, boolean bl) {
        InvokeDynamicSupport.bootstrap("applyRemoteViews", $$robo$$android_appwidget_AppWidgetHostView$applyRemoteViews(android.widget.RemoteViews boolean ), 0, this, remoteViews, bl);
    }

    private void applyContent(View view, boolean bl, Exception exception) {
        InvokeDynamicSupport.bootstrap("applyContent", $$robo$$android_appwidget_AppWidgetHostView$applyContent(android.view.View boolean java.lang.Exception ), 0, this, view, bl, exception);
    }

    private void inflateAsync(RemoteViews remoteViews) {
        InvokeDynamicSupport.bootstrap("inflateAsync", $$robo$$android_appwidget_AppWidgetHostView$inflateAsync(android.widget.RemoteViews ), 0, this, remoteViews);
    }

    void viewDataChanged(int n) {
        InvokeDynamicSupport.bootstrap("viewDataChanged", $$robo$$android_appwidget_AppWidgetHostView$viewDataChanged(int ), 0, this, n);
    }

    protected Context getRemoteContext() {
        return InvokeDynamicSupport.bootstrap("getRemoteContext", $$robo$$android_appwidget_AppWidgetHostView$getRemoteContext(), 0, this);
    }

    protected void prepareView(View view) {
        InvokeDynamicSupport.bootstrap("prepareView", $$robo$$android_appwidget_AppWidgetHostView$prepareView(android.view.View ), 0, this, view);
    }

    protected View getDefaultView() {
        return InvokeDynamicSupport.bootstrap("getDefaultView", $$robo$$android_appwidget_AppWidgetHostView$getDefaultView(), 0, this);
    }

    protected View getErrorView() {
        return InvokeDynamicSupport.bootstrap("getErrorView", $$robo$$android_appwidget_AppWidgetHostView$getErrorView(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_appwidget_AppWidgetHostView$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    static {
        RobolectricInternals.classInitializing(AppWidgetHostView.class);
    }

    public /* synthetic */ AppWidgetHostView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppWidgetHostView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ViewApplyListener
    implements RemoteViews.OnViewAppliedListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private RemoteViews mViews;
        private boolean mIsReapply;
        private int mLayoutId;
        /* synthetic */ AppWidgetHostView this$0;

        private void $$robo$$android_appwidget_AppWidgetHostView_ViewApplyListener$__constructor__(AppWidgetHostView appWidgetHostView, RemoteViews views, int layoutId, boolean isReapply) {
            this.mViews = views;
            this.mLayoutId = layoutId;
            this.mIsReapply = isReapply;
        }

        private final void $$robo$$android_appwidget_AppWidgetHostView_ViewApplyListener$onViewApplied(View v) {
            this.this$0.mLayoutId = this.mLayoutId;
            this.this$0.mViewMode = 1;
            this.this$0.applyContent(v, this.mIsReapply, null);
        }

        private final void $$robo$$android_appwidget_AppWidgetHostView_ViewApplyListener$onError(Exception e) {
            if (this.mIsReapply) {
                this.this$0.mLastExecutionSignal = this.mViews.applyAsync(this.this$0.mContext, this.this$0, this.this$0.mAsyncExecutor, new ViewApplyListener(this.this$0, this.mViews, this.mLayoutId, false), this.this$0.mOnClickHandler);
            } else {
                this.this$0.applyContent(null, false, e);
            }
        }

        private void __constructor__(AppWidgetHostView appWidgetHostView, RemoteViews remoteViews, int n, boolean bl) {
            this.$$robo$$android_appwidget_AppWidgetHostView_ViewApplyListener$__constructor__(appWidgetHostView, remoteViews, n, bl);
        }

        public ViewApplyListener(AppWidgetHostView appWidgetHostView, RemoteViews remoteViews, int n, boolean bl) {
            this.this$0 = appWidgetHostView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_appwidget_AppWidgetHostView_ViewApplyListener$__constructor__(android.appwidget.AppWidgetHostView android.widget.RemoteViews int boolean ), 0, this, appWidgetHostView, remoteViews, n, bl);
        }

        @Override
        public void onViewApplied(View view) {
            InvokeDynamicSupport.bootstrap("onViewApplied", $$robo$$android_appwidget_AppWidgetHostView_ViewApplyListener$onViewApplied(android.view.View ), 0, this, view);
        }

        @Override
        public void onError(Exception exception) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$android_appwidget_AppWidgetHostView_ViewApplyListener$onError(java.lang.Exception ), 0, this, exception);
        }

        public /* synthetic */ ViewApplyListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewApplyListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

