/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothGattCallback;
import android.os.Handler;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothGatt
implements BluetoothProfile,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothGatt";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private IBluetoothGatt mService;
    private volatile BluetoothGattCallback mCallback;
    private Handler mHandler;
    private int mClientIf;
    private BluetoothDevice mDevice;
    private boolean mAutoConnect;
    private int mAuthRetryState;
    private int mConnState;
    private Object mStateLock;
    private Boolean mDeviceBusy;
    private int mTransport;
    private int mPhy;
    private boolean mOpportunistic;
    private static int AUTH_RETRY_STATE_IDLE = 0;
    private static int AUTH_RETRY_STATE_NO_MITM = 1;
    private static int AUTH_RETRY_STATE_MITM = 2;
    private static int CONN_STATE_IDLE = 0;
    private static int CONN_STATE_CONNECTING = 1;
    private static int CONN_STATE_CONNECTED = 2;
    private static int CONN_STATE_DISCONNECTING = 3;
    private static int CONN_STATE_CLOSED = 4;
    private List<BluetoothGattService> mServices;
    public static int GATT_SUCCESS = 0;
    public static int GATT_READ_NOT_PERMITTED = 2;
    public static int GATT_WRITE_NOT_PERMITTED = 3;
    public static int GATT_INSUFFICIENT_AUTHENTICATION = 5;
    public static int GATT_REQUEST_NOT_SUPPORTED = 6;
    public static int GATT_INSUFFICIENT_ENCRYPTION = 15;
    public static int GATT_INVALID_OFFSET = 7;
    public static int GATT_INVALID_ATTRIBUTE_LENGTH = 13;
    public static int GATT_CONNECTION_CONGESTED = 143;
    public static int GATT_FAILURE = 257;
    public static int CONNECTION_PRIORITY_BALANCED = 0;
    public static int CONNECTION_PRIORITY_HIGH = 1;
    public static int CONNECTION_PRIORITY_LOW_POWER = 2;
    static int AUTHENTICATION_NONE = 0;
    static int AUTHENTICATION_NO_MITM = 1;
    static int AUTHENTICATION_MITM = 2;
    private IBluetoothGattCallback mBluetoothGattCallback;

    private void $$robo$$android_bluetooth_BluetoothGatt$__constructor__(IBluetoothGatt iGatt, BluetoothDevice device, int transport, boolean opportunistic, int phy) {
        this.mStateLock = new Object();
        this.mDeviceBusy = false;
        this.mBluetoothGattCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothGatt this$0;

            private void $$robo$$android_bluetooth_BluetoothGatt_1$__constructor__(BluetoothGatt this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onClientRegistered(int status, int clientIf) {
                Log.d("BluetoothGatt", "onClientRegistered() - status=" + status + " clientIf=" + clientIf);
                this.this$0.mClientIf = clientIf;
                if (status != 0) {
                    this.this$0.runOrQueueCallback(new Runnable(this){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ 1 this$1;

                        private void $$robo$$android_bluetooth_BluetoothGatt_1_1$__constructor__(1 this$1) {
                        }

                        private final void $$robo$$android_bluetooth_BluetoothGatt_1_1$run() {
                            BluetoothGattCallback callback = this.this$1.this$0.mCallback;
                            if (callback != null) {
                                callback.onConnectionStateChange(this.this$1.this$0, 257, 0);
                            }
                        }

                        private void __constructor__(1 var1_1) {
                            this.$$robo$$android_bluetooth_BluetoothGatt_1_1$__constructor__(var1_1);
                        }
                        {
                            this.this$1 = var1_1;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1_1$__constructor__(android.bluetooth.BluetoothGatt$1 ), 0, this, var1_1);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_BluetoothGatt_1_1$run(), 0, this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                    Object object = this.this$0.mStateLock;
                    synchronized (object) {
                        this.this$0.mConnState = 0;
                    }
                    return;
                }
                try {
                    this.this$0.mService.clientConnect(this.this$0.mClientIf, this.this$0.mDevice.getAddress(), !this.this$0.mAutoConnect, this.this$0.mTransport, this.this$0.mOpportunistic, this.this$0.mPhy);
                }
                catch (RemoteException e) {
                    Log.e("BluetoothGatt", "", e);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onPhyUpdate(String address, int txPhy, int rxPhy, int status) {
                Log.d("BluetoothGatt", "onPhyUpdate() - status=" + status + " address=" + address + " txPhy=" + txPhy + " rxPhy=" + rxPhy);
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                this.this$0.runOrQueueCallback(new Runnable(this, txPhy, rxPhy, status){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$txPhy;
                    /* synthetic */ int val$rxPhy;
                    /* synthetic */ int val$status;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_BluetoothGatt_1_2$__constructor__(1 this$1, int n, int n2, int n3) {
                    }

                    private final void $$robo$$android_bluetooth_BluetoothGatt_1_2$run() {
                        BluetoothGattCallback callback = this.this$1.this$0.mCallback;
                        if (callback != null) {
                            callback.onPhyUpdate(this.this$1.this$0, this.val$txPhy, this.val$rxPhy, this.val$status);
                        }
                    }

                    private void __constructor__(1 var1_1, int n, int n2, int n3) {
                        this.$$robo$$android_bluetooth_BluetoothGatt_1_2$__constructor__(var1_1, n, n2, n3);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$txPhy = n;
                        this.val$rxPhy = n2;
                        this.val$status = n3;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1_2$__constructor__(android.bluetooth.BluetoothGatt$1 int int int ), 0, this, var1_1, n, n2, n3);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_BluetoothGatt_1_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onPhyRead(String address, int txPhy, int rxPhy, int status) {
                Log.d("BluetoothGatt", "onPhyRead() - status=" + status + " address=" + address + " txPhy=" + txPhy + " rxPhy=" + rxPhy);
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                this.this$0.runOrQueueCallback(new Runnable(this, txPhy, rxPhy, status){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$txPhy;
                    /* synthetic */ int val$rxPhy;
                    /* synthetic */ int val$status;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_BluetoothGatt_1_3$__constructor__(1 this$1, int n, int n2, int n3) {
                    }

                    private final void $$robo$$android_bluetooth_BluetoothGatt_1_3$run() {
                        BluetoothGattCallback callback = this.this$1.this$0.mCallback;
                        if (callback != null) {
                            callback.onPhyRead(this.this$1.this$0, this.val$txPhy, this.val$rxPhy, this.val$status);
                        }
                    }

                    private void __constructor__(1 var1_1, int n, int n2, int n3) {
                        this.$$robo$$android_bluetooth_BluetoothGatt_1_3$__constructor__(var1_1, n, n2, n3);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$txPhy = n;
                        this.val$rxPhy = n2;
                        this.val$status = n3;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1_3$__constructor__(android.bluetooth.BluetoothGatt$1 int int int ), 0, this, var1_1, n, n2, n3);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_BluetoothGatt_1_3$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onClientConnectionState(int status, int clientIf, boolean connected, String address) {
                Log.d("BluetoothGatt", "onClientConnectionState() - status=" + status + " clientIf=" + clientIf + " device=" + address);
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                int profileState = connected ? 2 : 0;
                this.this$0.runOrQueueCallback(new Runnable(this, status, profileState){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$status;
                    /* synthetic */ int val$profileState;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_BluetoothGatt_1_4$__constructor__(1 this$1, int n, int n2) {
                    }

                    private final void $$robo$$android_bluetooth_BluetoothGatt_1_4$run() {
                        BluetoothGattCallback callback = this.this$1.this$0.mCallback;
                        if (callback != null) {
                            callback.onConnectionStateChange(this.this$1.this$0, this.val$status, this.val$profileState);
                        }
                    }

                    private void __constructor__(1 var1_1, int n, int n2) {
                        this.$$robo$$android_bluetooth_BluetoothGatt_1_4$__constructor__(var1_1, n, n2);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$status = n;
                        this.val$profileState = n2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1_4$__constructor__(android.bluetooth.BluetoothGatt$1 int int ), 0, this, var1_1, n, n2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_BluetoothGatt_1_4$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                Object object = this.this$0.mStateLock;
                synchronized (object) {
                    if (connected) {
                        this.this$0.mConnState = 2;
                    } else {
                        this.this$0.mConnState = 0;
                    }
                }
                object = this.this$0.mDeviceBusy;
                synchronized (object) {
                    this.this$0.mDeviceBusy = false;
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onSearchComplete(String address, List<BluetoothGattService> services, int status) {
                Log.d("BluetoothGatt", "onSearchComplete() = Device=" + address + " Status=" + status);
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                for (BluetoothGattService s : services) {
                    s.setDevice(this.this$0.mDevice);
                }
                this.this$0.mServices.addAll(services);
                for (BluetoothGattService fixedService : this.this$0.mServices) {
                    ArrayList<BluetoothGattService> includedServices = new ArrayList<BluetoothGattService>(fixedService.getIncludedServices());
                    fixedService.getIncludedServices().clear();
                    for (BluetoothGattService brokenRef : includedServices) {
                        BluetoothGattService includedService = this.this$0.getService(this.this$0.mDevice, brokenRef.getUuid(), brokenRef.getInstanceId());
                        if (includedService != null) {
                            fixedService.addIncludedService(includedService);
                            continue;
                        }
                        Log.e("BluetoothGatt", "Broken GATT database: can't find included service.");
                    }
                }
                this.this$0.runOrQueueCallback(new Runnable(this, status){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$status;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_BluetoothGatt_1_5$__constructor__(1 this$1, int n) {
                    }

                    private final void $$robo$$android_bluetooth_BluetoothGatt_1_5$run() {
                        BluetoothGattCallback callback = this.this$1.this$0.mCallback;
                        if (callback != null) {
                            callback.onServicesDiscovered(this.this$1.this$0, this.val$status);
                        }
                    }

                    private void __constructor__(1 var1_1, int n) {
                        this.$$robo$$android_bluetooth_BluetoothGatt_1_5$__constructor__(var1_1, n);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$status = n;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1_5$__constructor__(android.bluetooth.BluetoothGatt$1 int ), 0, this, var1_1, n);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_BluetoothGatt_1_5$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onCharacteristicRead(String address, int status, int handle, byte[] value) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                Boolean bl = this.this$0.mDeviceBusy;
                synchronized (bl) {
                    this.this$0.mDeviceBusy = false;
                }
                if ((status == 5 || status == 15) && this.this$0.mAuthRetryState != 2) {
                    try {
                        int authReq = this.this$0.mAuthRetryState == 0 ? 1 : 2;
                        this.this$0.mService.readCharacteristic(this.this$0.mClientIf, address, handle, authReq);
                        this.this$0.mAuthRetryState++;
                        return;
                    }
                    catch (RemoteException e) {
                        Log.e("BluetoothGatt", "", e);
                    }
                }
                this.this$0.mAuthRetryState = 0;
                BluetoothGattCharacteristic characteristic = this.this$0.getCharacteristicById(this.this$0.mDevice, handle);
                if (characteristic == null) {
                    Log.w("BluetoothGatt", "onCharacteristicRead() failed to find characteristic!");
                    return;
                }
                this.this$0.runOrQueueCallback(new Runnable(this, status, characteristic, value){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$status;
                    /* synthetic */ BluetoothGattCharacteristic val$characteristic;
                    /* synthetic */ byte[] val$value;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_BluetoothGatt_1_6$__constructor__(1 this$1, int n, BluetoothGattCharacteristic bluetoothGattCharacteristic, byte[] byArray) {
                    }

                    private final void $$robo$$android_bluetooth_BluetoothGatt_1_6$run() {
                        BluetoothGattCallback callback = this.this$1.this$0.mCallback;
                        if (callback != null) {
                            if (this.val$status == 0) {
                                this.val$characteristic.setValue(this.val$value);
                            }
                            callback.onCharacteristicRead(this.this$1.this$0, this.val$characteristic, this.val$status);
                        }
                    }

                    private void __constructor__(1 var1_1, int n, BluetoothGattCharacteristic bluetoothGattCharacteristic, byte[] byArray) {
                        this.$$robo$$android_bluetooth_BluetoothGatt_1_6$__constructor__(var1_1, n, bluetoothGattCharacteristic, byArray);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$status = n;
                        this.val$characteristic = bluetoothGattCharacteristic;
                        this.val$value = byArray;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1_6$__constructor__(android.bluetooth.BluetoothGatt$1 int android.bluetooth.BluetoothGattCharacteristic byte[] ), 0, this, var1_1, n, bluetoothGattCharacteristic, byArray);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_BluetoothGatt_1_6$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onCharacteristicWrite(String address, int status, int handle) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                Boolean bl = this.this$0.mDeviceBusy;
                synchronized (bl) {
                    this.this$0.mDeviceBusy = false;
                }
                BluetoothGattCharacteristic characteristic = this.this$0.getCharacteristicById(this.this$0.mDevice, handle);
                if (characteristic == null) {
                    return;
                }
                if ((status == 5 || status == 15) && this.this$0.mAuthRetryState != 2) {
                    try {
                        int authReq = this.this$0.mAuthRetryState == 0 ? 1 : 2;
                        this.this$0.mService.writeCharacteristic(this.this$0.mClientIf, address, handle, characteristic.getWriteType(), authReq, characteristic.getValue());
                        this.this$0.mAuthRetryState++;
                        return;
                    }
                    catch (RemoteException e) {
                        Log.e("BluetoothGatt", "", e);
                    }
                }
                this.this$0.mAuthRetryState = 0;
                this.this$0.runOrQueueCallback(new Runnable(this, characteristic, status){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ BluetoothGattCharacteristic val$characteristic;
                    /* synthetic */ int val$status;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_BluetoothGatt_1_7$__constructor__(1 this$1, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
                    }

                    private final void $$robo$$android_bluetooth_BluetoothGatt_1_7$run() {
                        BluetoothGattCallback callback = this.this$1.this$0.mCallback;
                        if (callback != null) {
                            callback.onCharacteristicWrite(this.this$1.this$0, this.val$characteristic, this.val$status);
                        }
                    }

                    private void __constructor__(1 var1_1, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
                        this.$$robo$$android_bluetooth_BluetoothGatt_1_7$__constructor__(var1_1, bluetoothGattCharacteristic, n);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$characteristic = bluetoothGattCharacteristic;
                        this.val$status = n;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1_7$__constructor__(android.bluetooth.BluetoothGatt$1 android.bluetooth.BluetoothGattCharacteristic int ), 0, this, var1_1, bluetoothGattCharacteristic, n);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_BluetoothGatt_1_7$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onNotify(String address, int handle, byte[] value) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                BluetoothGattCharacteristic characteristic = this.this$0.getCharacteristicById(this.this$0.mDevice, handle);
                if (characteristic == null) {
                    return;
                }
                this.this$0.runOrQueueCallback(new Runnable(this, characteristic, value){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ BluetoothGattCharacteristic val$characteristic;
                    /* synthetic */ byte[] val$value;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_BluetoothGatt_1_8$__constructor__(1 this$1, BluetoothGattCharacteristic bluetoothGattCharacteristic, byte[] byArray) {
                    }

                    private final void $$robo$$android_bluetooth_BluetoothGatt_1_8$run() {
                        BluetoothGattCallback callback = this.this$1.this$0.mCallback;
                        if (callback != null) {
                            this.val$characteristic.setValue(this.val$value);
                            callback.onCharacteristicChanged(this.this$1.this$0, this.val$characteristic);
                        }
                    }

                    private void __constructor__(1 var1_1, BluetoothGattCharacteristic bluetoothGattCharacteristic, byte[] byArray) {
                        this.$$robo$$android_bluetooth_BluetoothGatt_1_8$__constructor__(var1_1, bluetoothGattCharacteristic, byArray);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$characteristic = bluetoothGattCharacteristic;
                        this.val$value = byArray;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1_8$__constructor__(android.bluetooth.BluetoothGatt$1 android.bluetooth.BluetoothGattCharacteristic byte[] ), 0, this, var1_1, bluetoothGattCharacteristic, byArray);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_BluetoothGatt_1_8$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onDescriptorRead(String address, int status, int handle, byte[] value) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                Boolean bl = this.this$0.mDeviceBusy;
                synchronized (bl) {
                    this.this$0.mDeviceBusy = false;
                }
                BluetoothGattDescriptor descriptor = this.this$0.getDescriptorById(this.this$0.mDevice, handle);
                if (descriptor == null) {
                    return;
                }
                if ((status == 5 || status == 15) && this.this$0.mAuthRetryState != 2) {
                    try {
                        int authReq = this.this$0.mAuthRetryState == 0 ? 1 : 2;
                        this.this$0.mService.readDescriptor(this.this$0.mClientIf, address, handle, authReq);
                        this.this$0.mAuthRetryState++;
                        return;
                    }
                    catch (RemoteException e) {
                        Log.e("BluetoothGatt", "", e);
                    }
                }
                this.this$0.mAuthRetryState = 0;
                this.this$0.runOrQueueCallback(new Runnable(this, status, descriptor, value){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$status;
                    /* synthetic */ BluetoothGattDescriptor val$descriptor;
                    /* synthetic */ byte[] val$value;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_BluetoothGatt_1_9$__constructor__(1 this$1, int n, BluetoothGattDescriptor bluetoothGattDescriptor, byte[] byArray) {
                    }

                    private final void $$robo$$android_bluetooth_BluetoothGatt_1_9$run() {
                        BluetoothGattCallback callback = this.this$1.this$0.mCallback;
                        if (callback != null) {
                            if (this.val$status == 0) {
                                this.val$descriptor.setValue(this.val$value);
                            }
                            callback.onDescriptorRead(this.this$1.this$0, this.val$descriptor, this.val$status);
                        }
                    }

                    private void __constructor__(1 var1_1, int n, BluetoothGattDescriptor bluetoothGattDescriptor, byte[] byArray) {
                        this.$$robo$$android_bluetooth_BluetoothGatt_1_9$__constructor__(var1_1, n, bluetoothGattDescriptor, byArray);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$status = n;
                        this.val$descriptor = bluetoothGattDescriptor;
                        this.val$value = byArray;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1_9$__constructor__(android.bluetooth.BluetoothGatt$1 int android.bluetooth.BluetoothGattDescriptor byte[] ), 0, this, var1_1, n, bluetoothGattDescriptor, byArray);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_BluetoothGatt_1_9$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onDescriptorWrite(String address, int status, int handle) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                Boolean bl = this.this$0.mDeviceBusy;
                synchronized (bl) {
                    this.this$0.mDeviceBusy = false;
                }
                BluetoothGattDescriptor descriptor = this.this$0.getDescriptorById(this.this$0.mDevice, handle);
                if (descriptor == null) {
                    return;
                }
                if ((status == 5 || status == 15) && this.this$0.mAuthRetryState != 2) {
                    try {
                        int authReq = this.this$0.mAuthRetryState == 0 ? 1 : 2;
                        this.this$0.mService.writeDescriptor(this.this$0.mClientIf, address, handle, authReq, descriptor.getValue());
                        this.this$0.mAuthRetryState++;
                        return;
                    }
                    catch (RemoteException e) {
                        Log.e("BluetoothGatt", "", e);
                    }
                }
                this.this$0.mAuthRetryState = 0;
                this.this$0.runOrQueueCallback(new Runnable(this, descriptor, status){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ BluetoothGattDescriptor val$descriptor;
                    /* synthetic */ int val$status;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_BluetoothGatt_1_10$__constructor__(1 this$1, BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
                    }

                    private final void $$robo$$android_bluetooth_BluetoothGatt_1_10$run() {
                        BluetoothGattCallback callback = this.this$1.this$0.mCallback;
                        if (callback != null) {
                            callback.onDescriptorWrite(this.this$1.this$0, this.val$descriptor, this.val$status);
                        }
                    }

                    private void __constructor__(1 var1_1, BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
                        this.$$robo$$android_bluetooth_BluetoothGatt_1_10$__constructor__(var1_1, bluetoothGattDescriptor, n);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$descriptor = bluetoothGattDescriptor;
                        this.val$status = n;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1_10$__constructor__(android.bluetooth.BluetoothGatt$1 android.bluetooth.BluetoothGattDescriptor int ), 0, this, var1_1, bluetoothGattDescriptor, n);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_BluetoothGatt_1_10$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onExecuteWrite(String address, int status) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                Boolean bl = this.this$0.mDeviceBusy;
                synchronized (bl) {
                    this.this$0.mDeviceBusy = false;
                }
                this.this$0.runOrQueueCallback(new Runnable(this, status){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$status;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_BluetoothGatt_1_11$__constructor__(1 this$1, int n) {
                    }

                    private final void $$robo$$android_bluetooth_BluetoothGatt_1_11$run() {
                        BluetoothGattCallback callback = this.this$1.this$0.mCallback;
                        if (callback != null) {
                            callback.onReliableWriteCompleted(this.this$1.this$0, this.val$status);
                        }
                    }

                    private void __constructor__(1 var1_1, int n) {
                        this.$$robo$$android_bluetooth_BluetoothGatt_1_11$__constructor__(var1_1, n);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$status = n;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1_11$__constructor__(android.bluetooth.BluetoothGatt$1 int ), 0, this, var1_1, n);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_BluetoothGatt_1_11$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onReadRemoteRssi(String address, int rssi, int status) {
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                this.this$0.runOrQueueCallback(new Runnable(this, rssi, status){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$rssi;
                    /* synthetic */ int val$status;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_BluetoothGatt_1_12$__constructor__(1 this$1, int n, int n2) {
                    }

                    private final void $$robo$$android_bluetooth_BluetoothGatt_1_12$run() {
                        BluetoothGattCallback callback = this.this$1.this$0.mCallback;
                        if (callback != null) {
                            callback.onReadRemoteRssi(this.this$1.this$0, this.val$rssi, this.val$status);
                        }
                    }

                    private void __constructor__(1 var1_1, int n, int n2) {
                        this.$$robo$$android_bluetooth_BluetoothGatt_1_12$__constructor__(var1_1, n, n2);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$rssi = n;
                        this.val$status = n2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1_12$__constructor__(android.bluetooth.BluetoothGatt$1 int int ), 0, this, var1_1, n, n2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_BluetoothGatt_1_12$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onConfigureMTU(String address, int mtu, int status) {
                Log.d("BluetoothGatt", "onConfigureMTU() - Device=" + address + " mtu=" + mtu + " status=" + status);
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                this.this$0.runOrQueueCallback(new Runnable(this, mtu, status){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$mtu;
                    /* synthetic */ int val$status;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_BluetoothGatt_1_13$__constructor__(1 this$1, int n, int n2) {
                    }

                    private final void $$robo$$android_bluetooth_BluetoothGatt_1_13$run() {
                        BluetoothGattCallback callback = this.this$1.this$0.mCallback;
                        if (callback != null) {
                            callback.onMtuChanged(this.this$1.this$0, this.val$mtu, this.val$status);
                        }
                    }

                    private void __constructor__(1 var1_1, int n, int n2) {
                        this.$$robo$$android_bluetooth_BluetoothGatt_1_13$__constructor__(var1_1, n, n2);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$mtu = n;
                        this.val$status = n2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1_13$__constructor__(android.bluetooth.BluetoothGatt$1 int int ), 0, this, var1_1, n, n2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_BluetoothGatt_1_13$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_BluetoothGatt_1$onConnectionUpdated(String address, int interval, int latency, int timeout, int status) {
                Log.d("BluetoothGatt", "onConnectionUpdated() - Device=" + address + " interval=" + interval + " latency=" + latency + " timeout=" + timeout + " status=" + status);
                if (!address.equals(this.this$0.mDevice.getAddress())) {
                    return;
                }
                this.this$0.runOrQueueCallback(new Runnable(this, interval, latency, timeout, status){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$interval;
                    /* synthetic */ int val$latency;
                    /* synthetic */ int val$timeout;
                    /* synthetic */ int val$status;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_bluetooth_BluetoothGatt_1_14$__constructor__(1 this$1, int n, int n2, int n3, int n4) {
                    }

                    private final void $$robo$$android_bluetooth_BluetoothGatt_1_14$run() {
                        BluetoothGattCallback callback = this.this$1.this$0.mCallback;
                        if (callback != null) {
                            callback.onConnectionUpdated(this.this$1.this$0, this.val$interval, this.val$latency, this.val$timeout, this.val$status);
                        }
                    }

                    private void __constructor__(1 var1_1, int n, int n2, int n3, int n4) {
                        this.$$robo$$android_bluetooth_BluetoothGatt_1_14$__constructor__(var1_1, n, n2, n3, n4);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$interval = n;
                        this.val$latency = n2;
                        this.val$timeout = n3;
                        this.val$status = n4;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1_14$__constructor__(android.bluetooth.BluetoothGatt$1 int int int int ), 0, this, var1_1, n, n2, n3, n4);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_BluetoothGatt_1_14$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private void __constructor__(BluetoothGatt bluetoothGatt) {
                this.$$robo$$android_bluetooth_BluetoothGatt_1$__constructor__(bluetoothGatt);
            }
            {
                this.this$0 = bluetoothGatt;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt_1$__constructor__(android.bluetooth.BluetoothGatt ), 0, this, bluetoothGatt);
            }

            @Override
            public void onClientRegistered(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onClientRegistered", $$robo$$android_bluetooth_BluetoothGatt_1$onClientRegistered(int int ), 0, this, n, n2);
            }

            @Override
            public void onPhyUpdate(String string2, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("onPhyUpdate", $$robo$$android_bluetooth_BluetoothGatt_1$onPhyUpdate(java.lang.String int int int ), 0, this, string2, n, n2, n3);
            }

            @Override
            public void onPhyRead(String string2, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("onPhyRead", $$robo$$android_bluetooth_BluetoothGatt_1$onPhyRead(java.lang.String int int int ), 0, this, string2, n, n2, n3);
            }

            @Override
            public void onClientConnectionState(int n, int n2, boolean bl, String string2) {
                InvokeDynamicSupport.bootstrap("onClientConnectionState", $$robo$$android_bluetooth_BluetoothGatt_1$onClientConnectionState(int int boolean java.lang.String ), 0, this, n, n2, bl, string2);
            }

            @Override
            public void onSearchComplete(String string2, List<BluetoothGattService> list, int n) {
                InvokeDynamicSupport.bootstrap("onSearchComplete", $$robo$$android_bluetooth_BluetoothGatt_1$onSearchComplete(java.lang.String java.util.List<android.bluetooth.BluetoothGattService> int ), 0, this, string2, list, n);
            }

            @Override
            public void onCharacteristicRead(String string2, int n, int n2, byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onCharacteristicRead", $$robo$$android_bluetooth_BluetoothGatt_1$onCharacteristicRead(java.lang.String int int byte[] ), 0, this, string2, n, n2, byArray);
            }

            @Override
            public void onCharacteristicWrite(String string2, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onCharacteristicWrite", $$robo$$android_bluetooth_BluetoothGatt_1$onCharacteristicWrite(java.lang.String int int ), 0, this, string2, n, n2);
            }

            @Override
            public void onNotify(String string2, int n, byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onNotify", $$robo$$android_bluetooth_BluetoothGatt_1$onNotify(java.lang.String int byte[] ), 0, this, string2, n, byArray);
            }

            @Override
            public void onDescriptorRead(String string2, int n, int n2, byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onDescriptorRead", $$robo$$android_bluetooth_BluetoothGatt_1$onDescriptorRead(java.lang.String int int byte[] ), 0, this, string2, n, n2, byArray);
            }

            @Override
            public void onDescriptorWrite(String string2, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onDescriptorWrite", $$robo$$android_bluetooth_BluetoothGatt_1$onDescriptorWrite(java.lang.String int int ), 0, this, string2, n, n2);
            }

            @Override
            public void onExecuteWrite(String string2, int n) {
                InvokeDynamicSupport.bootstrap("onExecuteWrite", $$robo$$android_bluetooth_BluetoothGatt_1$onExecuteWrite(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public void onReadRemoteRssi(String string2, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onReadRemoteRssi", $$robo$$android_bluetooth_BluetoothGatt_1$onReadRemoteRssi(java.lang.String int int ), 0, this, string2, n, n2);
            }

            @Override
            public void onConfigureMTU(String string2, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onConfigureMTU", $$robo$$android_bluetooth_BluetoothGatt_1$onConfigureMTU(java.lang.String int int ), 0, this, string2, n, n2);
            }

            @Override
            public void onConnectionUpdated(String string2, int n, int n2, int n3, int n4) {
                InvokeDynamicSupport.bootstrap("onConnectionUpdated", $$robo$$android_bluetooth_BluetoothGatt_1$onConnectionUpdated(java.lang.String int int int int ), 0, this, string2, n, n2, n3, n4);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mService = iGatt;
        this.mDevice = device;
        this.mTransport = transport;
        this.mPhy = phy;
        this.mOpportunistic = opportunistic;
        this.mServices = new ArrayList<BluetoothGattService>();
        this.mConnState = 0;
        this.mAuthRetryState = 0;
    }

    private final void $$robo$$android_bluetooth_BluetoothGatt$close() {
        Log.d("BluetoothGatt", "close()");
        this.unregisterApp();
        this.mConnState = 4;
        this.mAuthRetryState = 0;
    }

    private final BluetoothGattService $$robo$$android_bluetooth_BluetoothGatt$getService(BluetoothDevice device, UUID uuid, int instanceId) {
        for (BluetoothGattService svc : this.mServices) {
            if (!svc.getDevice().equals(device) || svc.getInstanceId() != instanceId || !svc.getUuid().equals(uuid)) continue;
            return svc;
        }
        return null;
    }

    private final BluetoothGattCharacteristic $$robo$$android_bluetooth_BluetoothGatt$getCharacteristicById(BluetoothDevice device, int instanceId) {
        for (BluetoothGattService svc : this.mServices) {
            for (BluetoothGattCharacteristic charac : svc.getCharacteristics()) {
                if (charac.getInstanceId() != instanceId) continue;
                return charac;
            }
        }
        return null;
    }

    private final BluetoothGattDescriptor $$robo$$android_bluetooth_BluetoothGatt$getDescriptorById(BluetoothDevice device, int instanceId) {
        for (BluetoothGattService svc : this.mServices) {
            for (BluetoothGattCharacteristic charac : svc.getCharacteristics()) {
                for (BluetoothGattDescriptor desc : charac.getDescriptors()) {
                    if (desc.getInstanceId() != instanceId) continue;
                    return desc;
                }
            }
        }
        return null;
    }

    private final void $$robo$$android_bluetooth_BluetoothGatt$runOrQueueCallback(Runnable cb) {
        if (this.mHandler == null) {
            try {
                cb.run();
            }
            catch (Exception ex) {
                Log.w("BluetoothGatt", "Unhandled exception in callback", ex);
            }
        } else {
            this.mHandler.post(cb);
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$registerApp(BluetoothGattCallback callback, Handler handler) {
        Log.d("BluetoothGatt", "registerApp()");
        if (this.mService == null) {
            return false;
        }
        this.mCallback = callback;
        this.mHandler = handler;
        UUID uuid = UUID.randomUUID();
        Log.d("BluetoothGatt", "registerApp() - UUID=" + uuid);
        try {
            this.mService.registerClient(new ParcelUuid(uuid), this.mBluetoothGattCallback);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothGatt$unregisterApp() {
        Log.d("BluetoothGatt", "unregisterApp() - mClientIf=" + this.mClientIf);
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mCallback = null;
            this.mService.unregisterClient(this.mClientIf);
            this.mClientIf = 0;
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothGatt$connect(Boolean autoConnect, BluetoothGattCallback callback, Handler handler) {
        Log.d("BluetoothGatt", "connect() - device: " + this.mDevice.getAddress() + ", auto: " + autoConnect);
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mConnState != 0) {
                throw new IllegalStateException("Not idle");
            }
            this.mConnState = 1;
        }
        this.mAutoConnect = autoConnect;
        if (!this.registerApp(callback, handler)) {
            object = this.mStateLock;
            synchronized (object) {
                this.mConnState = 0;
            }
            Log.e("BluetoothGatt", "Failed to register callback");
            return false;
        }
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothGatt$disconnect() {
        Log.d("BluetoothGatt", "cancelOpen() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mService.clientDisconnect(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$connect() {
        try {
            this.mService.clientConnect(this.mClientIf, this.mDevice.getAddress(), false, this.mTransport, this.mOpportunistic, this.mPhy);
            return true;
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothGatt$setPreferredPhy(int txPhy, int rxPhy, int phyOptions) {
        try {
            this.mService.clientSetPreferredPhy(this.mClientIf, this.mDevice.getAddress(), txPhy, rxPhy, phyOptions);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothGatt$readPhy() {
        try {
            this.mService.clientReadPhy(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
        }
    }

    private final BluetoothDevice $$robo$$android_bluetooth_BluetoothGatt$getDevice() {
        return this.mDevice;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$discoverServices() {
        Log.d("BluetoothGatt", "discoverServices() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        this.mServices.clear();
        try {
            this.mService.discoverServices(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$discoverServiceByUuid(UUID uuid) {
        Log.d("BluetoothGatt", "discoverServiceByUuid() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        this.mServices.clear();
        try {
            this.mService.discoverServiceByUuid(this.mClientIf, this.mDevice.getAddress(), new ParcelUuid(uuid));
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final List<BluetoothGattService> $$robo$$android_bluetooth_BluetoothGatt$getServices() {
        ArrayList<BluetoothGattService> result = new ArrayList<BluetoothGattService>();
        for (BluetoothGattService service : this.mServices) {
            if (!service.getDevice().equals(this.mDevice)) continue;
            result.add(service);
        }
        return result;
    }

    private final BluetoothGattService $$robo$$android_bluetooth_BluetoothGatt$getService(UUID uuid) {
        for (BluetoothGattService service : this.mServices) {
            if (!service.getDevice().equals(this.mDevice) || !service.getUuid().equals(uuid)) continue;
            return service;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothGatt$readCharacteristic(BluetoothGattCharacteristic characteristic) {
        if ((characteristic.getProperties() & 2) == 0) {
            return false;
        }
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.readCharacteristic(this.mClientIf, device.getAddress(), characteristic.getInstanceId(), 0);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothGatt$readUsingCharacteristicUuid(UUID uuid, int startHandle, int endHandle) {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.readUsingCharacteristicUuid(this.mClientIf, this.mDevice.getAddress(), new ParcelUuid(uuid), startHandle, endHandle, 0);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothGatt$writeCharacteristic(BluetoothGattCharacteristic characteristic) {
        if ((characteristic.getProperties() & 8) == 0 && (characteristic.getProperties() & 4) == 0) {
            return false;
        }
        if (this.mService == null || this.mClientIf == 0 || characteristic.getValue() == null) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.writeCharacteristic(this.mClientIf, device.getAddress(), characteristic.getInstanceId(), characteristic.getWriteType(), 0, characteristic.getValue());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothGatt$readDescriptor(BluetoothGattDescriptor descriptor) {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattCharacteristic characteristic = descriptor.getCharacteristic();
        if (characteristic == null) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.readDescriptor(this.mClientIf, device.getAddress(), descriptor.getInstanceId(), 0);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothGatt$writeDescriptor(BluetoothGattDescriptor descriptor) {
        if (this.mService == null || this.mClientIf == 0 || descriptor.getValue() == null) {
            return false;
        }
        BluetoothGattCharacteristic characteristic = descriptor.getCharacteristic();
        if (characteristic == null) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.writeDescriptor(this.mClientIf, device.getAddress(), descriptor.getInstanceId(), 0, descriptor.getValue());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$beginReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.beginReliableWrite(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothGatt$executeReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.endReliableWrite(this.mClientIf, this.mDevice.getAddress(), true);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothGatt$abortReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mService.endReliableWrite(this.mClientIf, this.mDevice.getAddress(), false);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
        }
    }

    @Deprecated
    private final void $$robo$$android_bluetooth_BluetoothGatt$abortReliableWrite(BluetoothDevice mDevice) {
        this.abortReliableWrite();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$setCharacteristicNotification(BluetoothGattCharacteristic characteristic, boolean enable) {
        Log.d("BluetoothGatt", "setCharacteristicNotification() - uuid: " + characteristic.getUuid() + " enable: " + enable);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        try {
            this.mService.registerForNotification(this.mClientIf, device.getAddress(), characteristic.getInstanceId(), enable);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$refresh() {
        Log.d("BluetoothGatt", "refresh() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.refreshDevice(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$readRemoteRssi() {
        Log.d("BluetoothGatt", "readRssi() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.readRemoteRssi(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$requestMtu(int mtu) {
        Log.d("BluetoothGatt", "configureMTU() - device: " + this.mDevice.getAddress() + " mtu: " + mtu);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.configureMTU(this.mClientIf, this.mDevice.getAddress(), mtu);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$requestConnectionPriority(int connectionPriority) {
        if (connectionPriority < 0 || connectionPriority > 2) {
            throw new IllegalArgumentException("connectionPriority not within valid range");
        }
        Log.d("BluetoothGatt", "requestConnectionPriority() - params: " + connectionPriority);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.connectionParameterUpdate(this.mClientIf, this.mDevice.getAddress(), connectionPriority);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGatt$requestLeConnectionUpdate(int minConnectionInterval, int maxConnectionInterval, int slaveLatency, int supervisionTimeout, int minConnectionEventLen, int maxConnectionEventLen) {
        Log.d("BluetoothGatt", "requestLeConnectionUpdate() - min=(" + minConnectionInterval + ")" + 1.25 * (double)minConnectionInterval + "msec, max=(" + maxConnectionInterval + ")" + 1.25 * (double)maxConnectionInterval + "msec, latency=" + slaveLatency + ", timeout=" + supervisionTimeout + "msec, min_ce=" + minConnectionEventLen + ", max_ce=" + maxConnectionEventLen);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.leConnectionUpdate(this.mClientIf, this.mDevice.getAddress(), minConnectionInterval, maxConnectionInterval, slaveLatency, supervisionTimeout, minConnectionEventLen, maxConnectionEventLen);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGatt", "", e);
            return false;
        }
        return true;
    }

    private final int $$robo$$android_bluetooth_BluetoothGatt$getConnectionState(BluetoothDevice device) {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectionState instead.");
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothGatt$getConnectedDevices() {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectedDevices instead.");
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothGatt$getDevicesMatchingConnectionStates(int[] states) {
        throw new UnsupportedOperationException("Use BluetoothManager#getDevicesMatchingConnectionStates instead.");
    }

    private void __constructor__(IBluetoothGatt iBluetoothGatt, BluetoothDevice bluetoothDevice, int n, boolean bl, int n2) {
        this.$$robo$$android_bluetooth_BluetoothGatt$__constructor__(iBluetoothGatt, bluetoothDevice, n, bl, n2);
    }

    BluetoothGatt(IBluetoothGatt iBluetoothGatt, BluetoothDevice bluetoothDevice, int n, boolean bl, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGatt$__constructor__(android.bluetooth.IBluetoothGatt android.bluetooth.BluetoothDevice int boolean int ), 0, this, iBluetoothGatt, bluetoothDevice, n, bl, n2);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothGatt$close(), 0, this);
    }

    BluetoothGattService getService(BluetoothDevice bluetoothDevice, UUID uUID, int n) {
        return InvokeDynamicSupport.bootstrap("getService", $$robo$$android_bluetooth_BluetoothGatt$getService(android.bluetooth.BluetoothDevice java.util.UUID int ), 0, this, bluetoothDevice, uUID, n);
    }

    BluetoothGattCharacteristic getCharacteristicById(BluetoothDevice bluetoothDevice, int n) {
        return InvokeDynamicSupport.bootstrap("getCharacteristicById", $$robo$$android_bluetooth_BluetoothGatt$getCharacteristicById(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    BluetoothGattDescriptor getDescriptorById(BluetoothDevice bluetoothDevice, int n) {
        return InvokeDynamicSupport.bootstrap("getDescriptorById", $$robo$$android_bluetooth_BluetoothGatt$getDescriptorById(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    private void runOrQueueCallback(Runnable runnable) {
        InvokeDynamicSupport.bootstrap("runOrQueueCallback", $$robo$$android_bluetooth_BluetoothGatt$runOrQueueCallback(java.lang.Runnable ), 0, this, runnable);
    }

    private boolean registerApp(BluetoothGattCallback bluetoothGattCallback, Handler handler) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerApp", $$robo$$android_bluetooth_BluetoothGatt$registerApp(android.bluetooth.BluetoothGattCallback android.os.Handler ), 0, this, bluetoothGattCallback, handler);
    }

    private void unregisterApp() {
        InvokeDynamicSupport.bootstrap("unregisterApp", $$robo$$android_bluetooth_BluetoothGatt$unregisterApp(), 0, this);
    }

    boolean connect(Boolean bl, BluetoothGattCallback bluetoothGattCallback, Handler handler) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothGatt$connect(java.lang.Boolean android.bluetooth.BluetoothGattCallback android.os.Handler ), 0, this, bl, bluetoothGattCallback, handler);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothGatt$disconnect(), 0, this);
    }

    public boolean connect() {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothGatt$connect(), 0, this);
    }

    public void setPreferredPhy(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setPreferredPhy", $$robo$$android_bluetooth_BluetoothGatt$setPreferredPhy(int int int ), 0, this, n, n2, n3);
    }

    public void readPhy() {
        InvokeDynamicSupport.bootstrap("readPhy", $$robo$$android_bluetooth_BluetoothGatt$readPhy(), 0, this);
    }

    public BluetoothDevice getDevice() {
        return InvokeDynamicSupport.bootstrap("getDevice", $$robo$$android_bluetooth_BluetoothGatt$getDevice(), 0, this);
    }

    public boolean discoverServices() {
        return (boolean)InvokeDynamicSupport.bootstrap("discoverServices", $$robo$$android_bluetooth_BluetoothGatt$discoverServices(), 0, this);
    }

    public boolean discoverServiceByUuid(UUID uUID) {
        return (boolean)InvokeDynamicSupport.bootstrap("discoverServiceByUuid", $$robo$$android_bluetooth_BluetoothGatt$discoverServiceByUuid(java.util.UUID ), 0, this, uUID);
    }

    public List<BluetoothGattService> getServices() {
        return InvokeDynamicSupport.bootstrap("getServices", $$robo$$android_bluetooth_BluetoothGatt$getServices(), 0, this);
    }

    public BluetoothGattService getService(UUID uUID) {
        return InvokeDynamicSupport.bootstrap("getService", $$robo$$android_bluetooth_BluetoothGatt$getService(java.util.UUID ), 0, this, uUID);
    }

    public boolean readCharacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        return (boolean)InvokeDynamicSupport.bootstrap("readCharacteristic", $$robo$$android_bluetooth_BluetoothGatt$readCharacteristic(android.bluetooth.BluetoothGattCharacteristic ), 0, this, bluetoothGattCharacteristic);
    }

    public boolean readUsingCharacteristicUuid(UUID uUID, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("readUsingCharacteristicUuid", $$robo$$android_bluetooth_BluetoothGatt$readUsingCharacteristicUuid(java.util.UUID int int ), 0, this, uUID, n, n2);
    }

    public boolean writeCharacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        return (boolean)InvokeDynamicSupport.bootstrap("writeCharacteristic", $$robo$$android_bluetooth_BluetoothGatt$writeCharacteristic(android.bluetooth.BluetoothGattCharacteristic ), 0, this, bluetoothGattCharacteristic);
    }

    public boolean readDescriptor(BluetoothGattDescriptor bluetoothGattDescriptor) {
        return (boolean)InvokeDynamicSupport.bootstrap("readDescriptor", $$robo$$android_bluetooth_BluetoothGatt$readDescriptor(android.bluetooth.BluetoothGattDescriptor ), 0, this, bluetoothGattDescriptor);
    }

    public boolean writeDescriptor(BluetoothGattDescriptor bluetoothGattDescriptor) {
        return (boolean)InvokeDynamicSupport.bootstrap("writeDescriptor", $$robo$$android_bluetooth_BluetoothGatt$writeDescriptor(android.bluetooth.BluetoothGattDescriptor ), 0, this, bluetoothGattDescriptor);
    }

    public boolean beginReliableWrite() {
        return (boolean)InvokeDynamicSupport.bootstrap("beginReliableWrite", $$robo$$android_bluetooth_BluetoothGatt$beginReliableWrite(), 0, this);
    }

    public boolean executeReliableWrite() {
        return (boolean)InvokeDynamicSupport.bootstrap("executeReliableWrite", $$robo$$android_bluetooth_BluetoothGatt$executeReliableWrite(), 0, this);
    }

    public void abortReliableWrite() {
        InvokeDynamicSupport.bootstrap("abortReliableWrite", $$robo$$android_bluetooth_BluetoothGatt$abortReliableWrite(), 0, this);
    }

    @Deprecated
    public void abortReliableWrite(BluetoothDevice bluetoothDevice) {
        InvokeDynamicSupport.bootstrap("abortReliableWrite", $$robo$$android_bluetooth_BluetoothGatt$abortReliableWrite(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean setCharacteristicNotification(BluetoothGattCharacteristic bluetoothGattCharacteristic, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setCharacteristicNotification", $$robo$$android_bluetooth_BluetoothGatt$setCharacteristicNotification(android.bluetooth.BluetoothGattCharacteristic boolean ), 0, this, bluetoothGattCharacteristic, bl);
    }

    public boolean refresh() {
        return (boolean)InvokeDynamicSupport.bootstrap("refresh", $$robo$$android_bluetooth_BluetoothGatt$refresh(), 0, this);
    }

    public boolean readRemoteRssi() {
        return (boolean)InvokeDynamicSupport.bootstrap("readRemoteRssi", $$robo$$android_bluetooth_BluetoothGatt$readRemoteRssi(), 0, this);
    }

    public boolean requestMtu(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestMtu", $$robo$$android_bluetooth_BluetoothGatt$requestMtu(int ), 0, this, n);
    }

    public boolean requestConnectionPriority(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestConnectionPriority", $$robo$$android_bluetooth_BluetoothGatt$requestConnectionPriority(int ), 0, this, n);
    }

    public boolean requestLeConnectionUpdate(int n, int n2, int n3, int n4, int n5, int n6) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestLeConnectionUpdate", $$robo$$android_bluetooth_BluetoothGatt$requestLeConnectionUpdate(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothGatt$getConnectionState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothGatt$getConnectedDevices(), 0, this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothGatt$getDevicesMatchingConnectionStates(int[] ), 0, this, nArray);
    }

    public /* synthetic */ BluetoothGatt() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothGatt)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

