/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothPbap;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BluetoothPbap
implements BluetoothProfile,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothPbap";
    private static boolean DBG = false;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.pbap.profile.action.CONNECTION_STATE_CHANGED";
    private volatile IBluetoothPbap mService;
    private Context mContext;
    private ServiceListener mServiceListener;
    private BluetoothAdapter mAdapter;
    public static int RESULT_FAILURE = 0;
    public static int RESULT_SUCCESS = 1;
    public static int RESULT_CANCELED = 2;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothPbap$__constructor__(Context context, ServiceListener l) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothPbap this$0;

            private void $$robo$$android_bluetooth_BluetoothPbap_1$__constructor__(BluetoothPbap this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothPbap_1$onBluetoothStateChange(boolean up) {
                BluetoothPbap.log("onBluetoothStateChange: up=" + up);
                if (!up) {
                    BluetoothPbap.log("Unbinding service...");
                    ServiceConnection serviceConnection = this.this$0.mConnection;
                    synchronized (serviceConnection) {
                        try {
                            this.this$0.mService = null;
                            this.this$0.mContext.unbindService(this.this$0.mConnection);
                        }
                        catch (Exception re) {
                            Log.e("BluetoothPbap", "", re);
                        }
                    }
                }
                ServiceConnection serviceConnection = this.this$0.mConnection;
                synchronized (serviceConnection) {
                    try {
                        if (this.this$0.mService == null) {
                            BluetoothPbap.log("Binding service...");
                            this.this$0.doBind();
                        }
                    }
                    catch (Exception re) {
                        Log.e("BluetoothPbap", "", re);
                    }
                }
            }

            private void __constructor__(BluetoothPbap bluetoothPbap) {
                this.$$robo$$android_bluetooth_BluetoothPbap_1$__constructor__(bluetoothPbap);
            }
            {
                this.this$0 = bluetoothPbap;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothPbap_1$__constructor__(android.bluetooth.BluetoothPbap ), 0, this, bluetoothPbap);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothPbap_1$onBluetoothStateChange(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothPbap this$0;

            private void $$robo$$android_bluetooth_BluetoothPbap_2$__constructor__(BluetoothPbap this$0) {
            }

            private final void $$robo$$android_bluetooth_BluetoothPbap_2$onServiceConnected(ComponentName className, IBinder service) {
                BluetoothPbap.log("Proxy object connected");
                this.this$0.mService = IBluetoothPbap.Stub.asInterface(service);
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothPbap_2$onServiceDisconnected(ComponentName className) {
                BluetoothPbap.log("Proxy object disconnected");
                this.this$0.mService = null;
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected();
                }
            }

            private void __constructor__(BluetoothPbap bluetoothPbap) {
                this.$$robo$$android_bluetooth_BluetoothPbap_2$__constructor__(bluetoothPbap);
            }
            {
                this.this$0 = bluetoothPbap;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothPbap_2$__constructor__(android.bluetooth.BluetoothPbap ), 0, this, bluetoothPbap);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothPbap_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothPbap_2$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothPbap", "", e);
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPbap$doBind() {
        Intent intent = new Intent(IBluetoothPbap.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, this.mContext.getUser())) {
            Log.e("BluetoothPbap", "Could not bind to Bluetooth Pbap Service with " + intent);
            return false;
        }
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothPbap$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void $$robo$$android_bluetooth_BluetoothPbap$close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothPbap", "", e);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception re) {
                    Log.e("BluetoothPbap", "", re);
                }
            }
        }
        this.mServiceListener = null;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothPbap$getConnectedDevices() {
        BluetoothPbap.log("getConnectedDevices()");
        IBluetoothPbap service = this.mService;
        if (service == null) {
            Log.w("BluetoothPbap", "Proxy not attached to service");
            return new ArrayList<BluetoothDevice>();
        }
        try {
            return service.getConnectedDevices();
        }
        catch (RemoteException e) {
            Log.e("BluetoothPbap", e.toString());
            return new ArrayList<BluetoothDevice>();
        }
    }

    private final int $$robo$$android_bluetooth_BluetoothPbap$getConnectionState(BluetoothDevice device) {
        BluetoothPbap.log("getConnectionState: device=" + device);
        IBluetoothPbap service = this.mService;
        if (service == null) {
            Log.w("BluetoothPbap", "Proxy not attached to service");
            return 0;
        }
        try {
            return service.getConnectionState(device);
        }
        catch (RemoteException e) {
            Log.e("BluetoothPbap", e.toString());
            return 0;
        }
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothPbap$getDevicesMatchingConnectionStates(int[] states) {
        BluetoothPbap.log("getDevicesMatchingConnectionStates: states=" + Arrays.toString(states));
        IBluetoothPbap service = this.mService;
        if (service == null) {
            Log.w("BluetoothPbap", "Proxy not attached to service");
            return new ArrayList<BluetoothDevice>();
        }
        try {
            return service.getDevicesMatchingConnectionStates(states);
        }
        catch (RemoteException e) {
            Log.e("BluetoothPbap", e.toString());
            return new ArrayList<BluetoothDevice>();
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPbap$isConnected(BluetoothDevice device) {
        return this.getConnectionState(device) == 2;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPbap$disconnect(BluetoothDevice device) {
        BluetoothPbap.log("disconnect()");
        IBluetoothPbap service = this.mService;
        if (service == null) {
            Log.w("BluetoothPbap", "Proxy not attached to service");
            return false;
        }
        try {
            service.disconnect(device);
            return true;
        }
        catch (RemoteException e) {
            Log.e("BluetoothPbap", e.toString());
            return false;
        }
    }

    private static final void $$robo$$android_bluetooth_BluetoothPbap$log(String msg) {
    }

    private void __constructor__(Context context, ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothPbap$__constructor__(context, serviceListener);
    }

    public BluetoothPbap(Context context, ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothPbap$__constructor__(android.content.Context android.bluetooth.BluetoothPbap$ServiceListener ), 0, this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothPbap$doBind(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_bluetooth_BluetoothPbap$finalize(), 0, this);
    }

    public synchronized void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothPbap$close(), 0, this);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothPbap$getConnectedDevices(), 0, this);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothPbap$getConnectionState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothPbap$getDevicesMatchingConnectionStates(int[] ), 0, this, nArray);
    }

    public boolean isConnected(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$android_bluetooth_BluetoothPbap$isConnected(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothPbap$disconnect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothPbap$log(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ BluetoothPbap() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothPbap)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface ServiceListener
    extends InstrumentedInterface {
        public void onServiceConnected(BluetoothPbap var1);

        public void onServiceDisconnected();
    }
}

