/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothCallback;
import android.bluetooth.IBluetoothSocketManager;
import android.bluetooth.OobData;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public interface IBluetooth
extends IInterface,
InstrumentedInterface {
    public boolean isEnabled() throws RemoteException;

    public int getState() throws RemoteException;

    public boolean enable() throws RemoteException;

    public boolean enableNoAutoConnect() throws RemoteException;

    public boolean disable() throws RemoteException;

    public String getAddress() throws RemoteException;

    public ParcelUuid[] getUuids() throws RemoteException;

    public boolean setName(String var1) throws RemoteException;

    public String getName() throws RemoteException;

    public BluetoothClass getBluetoothClass() throws RemoteException;

    public boolean setBluetoothClass(BluetoothClass var1) throws RemoteException;

    public int getScanMode() throws RemoteException;

    public boolean setScanMode(int var1, int var2) throws RemoteException;

    public int getDiscoverableTimeout() throws RemoteException;

    public boolean setDiscoverableTimeout(int var1) throws RemoteException;

    public boolean startDiscovery() throws RemoteException;

    public boolean cancelDiscovery() throws RemoteException;

    public boolean isDiscovering() throws RemoteException;

    public long getDiscoveryEndMillis() throws RemoteException;

    public int getAdapterConnectionState() throws RemoteException;

    public int getProfileConnectionState(int var1) throws RemoteException;

    public BluetoothDevice[] getBondedDevices() throws RemoteException;

    public boolean createBond(BluetoothDevice var1, int var2) throws RemoteException;

    public boolean createBondOutOfBand(BluetoothDevice var1, int var2, OobData var3) throws RemoteException;

    public boolean cancelBondProcess(BluetoothDevice var1) throws RemoteException;

    public boolean removeBond(BluetoothDevice var1) throws RemoteException;

    public int getBondState(BluetoothDevice var1) throws RemoteException;

    public boolean isBondingInitiatedLocally(BluetoothDevice var1) throws RemoteException;

    public long getSupportedProfiles() throws RemoteException;

    public int getConnectionState(BluetoothDevice var1) throws RemoteException;

    public String getRemoteName(BluetoothDevice var1) throws RemoteException;

    public int getRemoteType(BluetoothDevice var1) throws RemoteException;

    public String getRemoteAlias(BluetoothDevice var1) throws RemoteException;

    public boolean setRemoteAlias(BluetoothDevice var1, String var2) throws RemoteException;

    public int getRemoteClass(BluetoothDevice var1) throws RemoteException;

    public ParcelUuid[] getRemoteUuids(BluetoothDevice var1) throws RemoteException;

    public boolean fetchRemoteUuids(BluetoothDevice var1) throws RemoteException;

    public boolean sdpSearch(BluetoothDevice var1, ParcelUuid var2) throws RemoteException;

    public int getBatteryLevel(BluetoothDevice var1) throws RemoteException;

    public int getMaxConnectedAudioDevices() throws RemoteException;

    public boolean setPin(BluetoothDevice var1, boolean var2, int var3, byte[] var4) throws RemoteException;

    public boolean setPasskey(BluetoothDevice var1, boolean var2, int var3, byte[] var4) throws RemoteException;

    public boolean setPairingConfirmation(BluetoothDevice var1, boolean var2) throws RemoteException;

    public int getPhonebookAccessPermission(BluetoothDevice var1) throws RemoteException;

    public boolean setPhonebookAccessPermission(BluetoothDevice var1, int var2) throws RemoteException;

    public int getMessageAccessPermission(BluetoothDevice var1) throws RemoteException;

    public boolean setMessageAccessPermission(BluetoothDevice var1, int var2) throws RemoteException;

    public int getSimAccessPermission(BluetoothDevice var1) throws RemoteException;

    public boolean setSimAccessPermission(BluetoothDevice var1, int var2) throws RemoteException;

    public void sendConnectionStateChange(BluetoothDevice var1, int var2, int var3, int var4) throws RemoteException;

    public void registerCallback(IBluetoothCallback var1) throws RemoteException;

    public void unregisterCallback(IBluetoothCallback var1) throws RemoteException;

    public IBluetoothSocketManager getSocketManager() throws RemoteException;

    public boolean factoryReset() throws RemoteException;

    public boolean isMultiAdvertisementSupported() throws RemoteException;

    public boolean isOffloadedFilteringSupported() throws RemoteException;

    public boolean isOffloadedScanBatchingSupported() throws RemoteException;

    public boolean isActivityAndEnergyReportingSupported() throws RemoteException;

    public boolean isLe2MPhySupported() throws RemoteException;

    public boolean isLeCodedPhySupported() throws RemoteException;

    public boolean isLeExtendedAdvertisingSupported() throws RemoteException;

    public boolean isLePeriodicAdvertisingSupported() throws RemoteException;

    public int getLeMaximumAdvertisingDataLength() throws RemoteException;

    public BluetoothActivityEnergyInfo reportActivityInfo() throws RemoteException;

    public void requestActivityInfo(ResultReceiver var1) throws RemoteException;

    public void onLeServiceUp() throws RemoteException;

    public void onBrEdrDown() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetooth,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String DESCRIPTOR = "android.bluetooth.IBluetooth";
        static int TRANSACTION_isEnabled = 1;
        static int TRANSACTION_getState = 2;
        static int TRANSACTION_enable = 3;
        static int TRANSACTION_enableNoAutoConnect = 4;
        static int TRANSACTION_disable = 5;
        static int TRANSACTION_getAddress = 6;
        static int TRANSACTION_getUuids = 7;
        static int TRANSACTION_setName = 8;
        static int TRANSACTION_getName = 9;
        static int TRANSACTION_getBluetoothClass = 10;
        static int TRANSACTION_setBluetoothClass = 11;
        static int TRANSACTION_getScanMode = 12;
        static int TRANSACTION_setScanMode = 13;
        static int TRANSACTION_getDiscoverableTimeout = 14;
        static int TRANSACTION_setDiscoverableTimeout = 15;
        static int TRANSACTION_startDiscovery = 16;
        static int TRANSACTION_cancelDiscovery = 17;
        static int TRANSACTION_isDiscovering = 18;
        static int TRANSACTION_getDiscoveryEndMillis = 19;
        static int TRANSACTION_getAdapterConnectionState = 20;
        static int TRANSACTION_getProfileConnectionState = 21;
        static int TRANSACTION_getBondedDevices = 22;
        static int TRANSACTION_createBond = 23;
        static int TRANSACTION_createBondOutOfBand = 24;
        static int TRANSACTION_cancelBondProcess = 25;
        static int TRANSACTION_removeBond = 26;
        static int TRANSACTION_getBondState = 27;
        static int TRANSACTION_isBondingInitiatedLocally = 28;
        static int TRANSACTION_getSupportedProfiles = 29;
        static int TRANSACTION_getConnectionState = 30;
        static int TRANSACTION_getRemoteName = 31;
        static int TRANSACTION_getRemoteType = 32;
        static int TRANSACTION_getRemoteAlias = 33;
        static int TRANSACTION_setRemoteAlias = 34;
        static int TRANSACTION_getRemoteClass = 35;
        static int TRANSACTION_getRemoteUuids = 36;
        static int TRANSACTION_fetchRemoteUuids = 37;
        static int TRANSACTION_sdpSearch = 38;
        static int TRANSACTION_getBatteryLevel = 39;
        static int TRANSACTION_getMaxConnectedAudioDevices = 40;
        static int TRANSACTION_setPin = 41;
        static int TRANSACTION_setPasskey = 42;
        static int TRANSACTION_setPairingConfirmation = 43;
        static int TRANSACTION_getPhonebookAccessPermission = 44;
        static int TRANSACTION_setPhonebookAccessPermission = 45;
        static int TRANSACTION_getMessageAccessPermission = 46;
        static int TRANSACTION_setMessageAccessPermission = 47;
        static int TRANSACTION_getSimAccessPermission = 48;
        static int TRANSACTION_setSimAccessPermission = 49;
        static int TRANSACTION_sendConnectionStateChange = 50;
        static int TRANSACTION_registerCallback = 51;
        static int TRANSACTION_unregisterCallback = 52;
        static int TRANSACTION_getSocketManager = 53;
        static int TRANSACTION_factoryReset = 54;
        static int TRANSACTION_isMultiAdvertisementSupported = 55;
        static int TRANSACTION_isOffloadedFilteringSupported = 56;
        static int TRANSACTION_isOffloadedScanBatchingSupported = 57;
        static int TRANSACTION_isActivityAndEnergyReportingSupported = 58;
        static int TRANSACTION_isLe2MPhySupported = 59;
        static int TRANSACTION_isLeCodedPhySupported = 60;
        static int TRANSACTION_isLeExtendedAdvertisingSupported = 61;
        static int TRANSACTION_isLePeriodicAdvertisingSupported = 62;
        static int TRANSACTION_getLeMaximumAdvertisingDataLength = 63;
        static int TRANSACTION_reportActivityInfo = 64;
        static int TRANSACTION_requestActivityInfo = 65;
        static int TRANSACTION_onLeServiceUp = 66;
        static int TRANSACTION_onBrEdrDown = 67;

        private void $$robo$$android_bluetooth_IBluetooth_Stub$__constructor__() {
            this.attachInterface(this, "android.bluetooth.IBluetooth");
        }

        private static final IBluetooth $$robo$$android_bluetooth_IBluetooth_Stub$asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface("android.bluetooth.IBluetooth");
            if (iin != null && iin instanceof IBluetooth) {
                return (IBluetooth)iin;
            }
            return new Proxy(obj);
        }

        private final IBinder $$robo$$android_bluetooth_IBluetooth_Stub$asBinder() {
            return this;
        }

        private final boolean $$robo$$android_bluetooth_IBluetooth_Stub$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = "android.bluetooth.IBluetooth";
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _result = this.getState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.enable();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.enableNoAutoConnect();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.disable();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _result = this.getAddress();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.getUuids();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.setName(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _result = this.getName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    BluetoothClass _result = this.getBluetoothClass();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    BluetoothClass _arg0 = 0 != data.readInt() ? BluetoothClass.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setBluetoothClass(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _result = this.getScanMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _result = this.setScanMode(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    int _result = this.getDiscoverableTimeout();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.setDiscoverableTimeout(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.startDiscovery();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.cancelDiscovery();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isDiscovering();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    long _result = this.getDiscoveryEndMillis();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    int _result = this.getAdapterConnectionState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getProfileConnectionState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.getBondedDevices();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    boolean _result = this.createBond(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    OobData _arg2 = 0 != data.readInt() ? OobData.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.createBondOutOfBand(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.cancelBondProcess(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.removeBond(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _result = this.getBondState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.isBondingInitiatedLocally(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    long _result = this.getSupportedProfiles();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _result = this.getConnectionState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    String _result = this.getRemoteName(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _result = this.getRemoteType(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    String _result = this.getRemoteAlias(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    boolean _result = this.setRemoteAlias(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _result = this.getRemoteClass(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    Parcelable[] _result = this.getRemoteUuids(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.fetchRemoteUuids(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    ParcelUuid _arg1 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.sdpSearch(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _result = this.getBatteryLevel(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    int _result = this.getMaxConnectedAudioDevices();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    boolean _result = this.setPin(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    boolean _result = this.setPasskey(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    boolean _result = this.setPairingConfirmation(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _result = this.getPhonebookAccessPermission(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    boolean _result = this.setPhonebookAccessPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _result = this.getMessageAccessPermission(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    boolean _result = this.setMessageAccessPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _result = this.getSimAccessPermission(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 49: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    boolean _result = this.setSimAccessPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 50: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.sendConnectionStateChange(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 51: {
                    data.enforceInterface(descriptor);
                    IBluetoothCallback _arg0 = IBluetoothCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 52: {
                    data.enforceInterface(descriptor);
                    IBluetoothCallback _arg0 = IBluetoothCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 53: {
                    data.enforceInterface(descriptor);
                    IBluetoothSocketManager _result = this.getSocketManager();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 54: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.factoryReset();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 55: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isMultiAdvertisementSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 56: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isOffloadedFilteringSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 57: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isOffloadedScanBatchingSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 58: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isActivityAndEnergyReportingSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 59: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isLe2MPhySupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 60: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isLeCodedPhySupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 61: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isLeExtendedAdvertisingSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 62: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isLePeriodicAdvertisingSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 63: {
                    data.enforceInterface(descriptor);
                    int _result = this.getLeMaximumAdvertisingDataLength();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 64: {
                    data.enforceInterface(descriptor);
                    BluetoothActivityEnergyInfo _result = this.reportActivityInfo();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 65: {
                    data.enforceInterface(descriptor);
                    ResultReceiver _arg0 = 0 != data.readInt() ? ResultReceiver.CREATOR.createFromParcel(data) : null;
                    this.requestActivityInfo(_arg0);
                    return true;
                }
                case 66: {
                    data.enforceInterface(descriptor);
                    this.onLeServiceUp();
                    reply.writeNoException();
                    return true;
                }
                case 67: {
                    data.enforceInterface(descriptor);
                    this.onBrEdrDown();
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private void __constructor__() {
            this.$$robo$$android_bluetooth_IBluetooth_Stub$__constructor__();
        }

        public Stub() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_IBluetooth_Stub$__constructor__(), 0, this);
        }

        public static IBluetooth asInterface(IBinder iBinder) {
            return InvokeDynamicSupport.bootstrapStatic("asInterface", $$robo$$android_bluetooth_IBluetooth_Stub$asInterface(android.os.IBinder ), 0, (IBinder)iBinder);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_bluetooth_IBluetooth_Stub$asBinder(), 0, this);
        }

        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_bluetooth_IBluetooth_Stub$onTransact(int android.os.Parcel android.os.Parcel int ), 0, this, n, parcel, parcel2, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Stub)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class Proxy
        implements IBluetooth,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private IBinder mRemote;

            private void $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$__constructor__(IBinder remote) {
                this.mRemote = remote;
            }

            private final IBinder $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$asBinder() {
                return this.mRemote;
            }

            private final String $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getInterfaceDescriptor() {
                return "android.bluetooth.IBluetooth";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$enable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$enableNoAutoConnect() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$disable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getAddress() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final ParcelUuid[] $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getUuids() throws RemoteException {
                ParcelUuid[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(ParcelUuid.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setName(String name) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    _data.writeString(name);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final BluetoothClass $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getBluetoothClass() throws RemoteException {
                BluetoothClass _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? BluetoothClass.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setBluetoothClass(BluetoothClass bluetoothClass) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (bluetoothClass != null) {
                        _data.writeInt(1);
                        bluetoothClass.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getScanMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setScanMode(int mode, int duration) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    _data.writeInt(mode);
                    _data.writeInt(duration);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getDiscoverableTimeout() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setDiscoverableTimeout(int timeout) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    _data.writeInt(timeout);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$startDiscovery() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$cancelDiscovery() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isDiscovering() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final long $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getDiscoveryEndMillis() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getAdapterConnectionState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getProfileConnectionState(int profile) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    _data.writeInt(profile);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final BluetoothDevice[] $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getBondedDevices() throws RemoteException {
                BluetoothDevice[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(BluetoothDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$createBond(BluetoothDevice device, int transport) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(transport);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$createBondOutOfBand(BluetoothDevice device, int transport, OobData oobData) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(transport);
                    if (oobData != null) {
                        _data.writeInt(1);
                        oobData.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$cancelBondProcess(BluetoothDevice device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$removeBond(BluetoothDevice device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getBondState(BluetoothDevice device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isBondingInitiatedLocally(BluetoothDevice device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final long $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getSupportedProfiles() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getConnectionState(BluetoothDevice device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getRemoteName(BluetoothDevice device) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getRemoteType(BluetoothDevice device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getRemoteAlias(BluetoothDevice device) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setRemoteAlias(BluetoothDevice device, String name) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(name);
                    this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getRemoteClass(BluetoothDevice device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final ParcelUuid[] $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getRemoteUuids(BluetoothDevice device) throws RemoteException {
                ParcelUuid[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(ParcelUuid.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$fetchRemoteUuids(BluetoothDevice device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$sdpSearch(BluetoothDevice device, ParcelUuid uuid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (uuid != null) {
                        _data.writeInt(1);
                        uuid.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getBatteryLevel(BluetoothDevice device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getMaxConnectedAudioDevices() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setPin(BluetoothDevice device, boolean accept, int len, byte[] pinCode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(accept ? 1 : 0);
                    _data.writeInt(len);
                    _data.writeByteArray(pinCode);
                    this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setPasskey(BluetoothDevice device, boolean accept, int len, byte[] passkey) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(accept ? 1 : 0);
                    _data.writeInt(len);
                    _data.writeByteArray(passkey);
                    this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setPairingConfirmation(BluetoothDevice device, boolean accept) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(accept ? 1 : 0);
                    this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getPhonebookAccessPermission(BluetoothDevice device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setPhonebookAccessPermission(BluetoothDevice device, int value) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(value);
                    this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getMessageAccessPermission(BluetoothDevice device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setMessageAccessPermission(BluetoothDevice device, int value) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(value);
                    this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getSimAccessPermission(BluetoothDevice device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setSimAccessPermission(BluetoothDevice device, int value) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(value);
                    this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$sendConnectionStateChange(BluetoothDevice device, int profile, int state, int prevState) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (device != null) {
                        _data.writeInt(1);
                        device.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(profile);
                    _data.writeInt(state);
                    _data.writeInt(prevState);
                    this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$registerCallback(IBluetoothCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$unregisterCallback(IBluetoothCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final IBluetoothSocketManager $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getSocketManager() throws RemoteException {
                IBluetoothSocketManager _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = IBluetoothSocketManager.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$factoryReset() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isMultiAdvertisementSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isOffloadedFilteringSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isOffloadedScanBatchingSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isActivityAndEnergyReportingSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isLe2MPhySupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isLeCodedPhySupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isLeExtendedAdvertisingSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isLePeriodicAdvertisingSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getLeMaximumAdvertisingDataLength() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final BluetoothActivityEnergyInfo $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$reportActivityInfo() throws RemoteException {
                BluetoothActivityEnergyInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? BluetoothActivityEnergyInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            private final void $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$requestActivityInfo(ResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    if (result != null) {
                        _data.writeInt(1);
                        result.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(65, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            private final void $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$onLeServiceUp() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private final void $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$onBrEdrDown() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetooth");
                    this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private void __constructor__(IBinder iBinder) {
                this.$$robo$$android_bluetooth_IBluetooth_Stub_Proxy$__constructor__(iBinder);
            }

            Proxy(IBinder iBinder) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$__constructor__(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public IBinder asBinder() {
                return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$asBinder(), 0, this);
            }

            public String getInterfaceDescriptor() {
                return InvokeDynamicSupport.bootstrap("getInterfaceDescriptor", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getInterfaceDescriptor(), 0, this);
            }

            @Override
            public boolean isEnabled() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isEnabled(), 0, this);
            }

            @Override
            public int getState() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getState(), 0, this);
            }

            @Override
            public boolean enable() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("enable", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$enable(), 0, this);
            }

            @Override
            public boolean enableNoAutoConnect() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("enableNoAutoConnect", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$enableNoAutoConnect(), 0, this);
            }

            @Override
            public boolean disable() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("disable", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$disable(), 0, this);
            }

            @Override
            public String getAddress() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getAddress(), 0, this);
            }

            @Override
            public ParcelUuid[] getUuids() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getUuids", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getUuids(), 0, this);
            }

            @Override
            public boolean setName(String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setName", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setName(java.lang.String ), 0, this, string2);
            }

            @Override
            public String getName() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getName(), 0, this);
            }

            @Override
            public BluetoothClass getBluetoothClass() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getBluetoothClass", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getBluetoothClass(), 0, this);
            }

            @Override
            public boolean setBluetoothClass(BluetoothClass bluetoothClass) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setBluetoothClass", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setBluetoothClass(android.bluetooth.BluetoothClass ), 0, this, bluetoothClass);
            }

            @Override
            public int getScanMode() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getScanMode", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getScanMode(), 0, this);
            }

            @Override
            public boolean setScanMode(int n, int n2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setScanMode", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setScanMode(int int ), 0, this, n, n2);
            }

            @Override
            public int getDiscoverableTimeout() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getDiscoverableTimeout", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getDiscoverableTimeout(), 0, this);
            }

            @Override
            public boolean setDiscoverableTimeout(int n) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setDiscoverableTimeout", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setDiscoverableTimeout(int ), 0, this, n);
            }

            @Override
            public boolean startDiscovery() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("startDiscovery", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$startDiscovery(), 0, this);
            }

            @Override
            public boolean cancelDiscovery() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("cancelDiscovery", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$cancelDiscovery(), 0, this);
            }

            @Override
            public boolean isDiscovering() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isDiscovering", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isDiscovering(), 0, this);
            }

            @Override
            public long getDiscoveryEndMillis() throws RemoteException {
                return (long)InvokeDynamicSupport.bootstrap("getDiscoveryEndMillis", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getDiscoveryEndMillis(), 0, this);
            }

            @Override
            public int getAdapterConnectionState() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getAdapterConnectionState", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getAdapterConnectionState(), 0, this);
            }

            @Override
            public int getProfileConnectionState(int n) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getProfileConnectionState", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getProfileConnectionState(int ), 0, this, n);
            }

            @Override
            public BluetoothDevice[] getBondedDevices() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getBondedDevices", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getBondedDevices(), 0, this);
            }

            @Override
            public boolean createBond(BluetoothDevice bluetoothDevice, int n) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("createBond", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$createBond(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
            }

            @Override
            public boolean createBondOutOfBand(BluetoothDevice bluetoothDevice, int n, OobData oobData) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("createBondOutOfBand", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$createBondOutOfBand(android.bluetooth.BluetoothDevice int android.bluetooth.OobData ), 0, this, bluetoothDevice, n, oobData);
            }

            @Override
            public boolean cancelBondProcess(BluetoothDevice bluetoothDevice) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("cancelBondProcess", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$cancelBondProcess(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public boolean removeBond(BluetoothDevice bluetoothDevice) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("removeBond", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$removeBond(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public int getBondState(BluetoothDevice bluetoothDevice) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getBondState", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getBondState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public boolean isBondingInitiatedLocally(BluetoothDevice bluetoothDevice) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isBondingInitiatedLocally", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isBondingInitiatedLocally(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public long getSupportedProfiles() throws RemoteException {
                return (long)InvokeDynamicSupport.bootstrap("getSupportedProfiles", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getSupportedProfiles(), 0, this);
            }

            @Override
            public int getConnectionState(BluetoothDevice bluetoothDevice) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getConnectionState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public String getRemoteName(BluetoothDevice bluetoothDevice) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getRemoteName", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getRemoteName(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public int getRemoteType(BluetoothDevice bluetoothDevice) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getRemoteType", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getRemoteType(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public String getRemoteAlias(BluetoothDevice bluetoothDevice) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getRemoteAlias", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getRemoteAlias(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public boolean setRemoteAlias(BluetoothDevice bluetoothDevice, String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setRemoteAlias", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setRemoteAlias(android.bluetooth.BluetoothDevice java.lang.String ), 0, this, bluetoothDevice, string2);
            }

            @Override
            public int getRemoteClass(BluetoothDevice bluetoothDevice) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getRemoteClass", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getRemoteClass(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public ParcelUuid[] getRemoteUuids(BluetoothDevice bluetoothDevice) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getRemoteUuids", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getRemoteUuids(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public boolean fetchRemoteUuids(BluetoothDevice bluetoothDevice) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("fetchRemoteUuids", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$fetchRemoteUuids(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public boolean sdpSearch(BluetoothDevice bluetoothDevice, ParcelUuid parcelUuid) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("sdpSearch", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$sdpSearch(android.bluetooth.BluetoothDevice android.os.ParcelUuid ), 0, this, bluetoothDevice, parcelUuid);
            }

            @Override
            public int getBatteryLevel(BluetoothDevice bluetoothDevice) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getBatteryLevel", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getBatteryLevel(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public int getMaxConnectedAudioDevices() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getMaxConnectedAudioDevices", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getMaxConnectedAudioDevices(), 0, this);
            }

            @Override
            public boolean setPin(BluetoothDevice bluetoothDevice, boolean bl, int n, byte[] byArray) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setPin", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setPin(android.bluetooth.BluetoothDevice boolean int byte[] ), 0, this, bluetoothDevice, bl, n, byArray);
            }

            @Override
            public boolean setPasskey(BluetoothDevice bluetoothDevice, boolean bl, int n, byte[] byArray) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setPasskey", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setPasskey(android.bluetooth.BluetoothDevice boolean int byte[] ), 0, this, bluetoothDevice, bl, n, byArray);
            }

            @Override
            public boolean setPairingConfirmation(BluetoothDevice bluetoothDevice, boolean bl) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setPairingConfirmation", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setPairingConfirmation(android.bluetooth.BluetoothDevice boolean ), 0, this, bluetoothDevice, bl);
            }

            @Override
            public int getPhonebookAccessPermission(BluetoothDevice bluetoothDevice) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getPhonebookAccessPermission", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getPhonebookAccessPermission(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public boolean setPhonebookAccessPermission(BluetoothDevice bluetoothDevice, int n) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setPhonebookAccessPermission", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setPhonebookAccessPermission(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
            }

            @Override
            public int getMessageAccessPermission(BluetoothDevice bluetoothDevice) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getMessageAccessPermission", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getMessageAccessPermission(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public boolean setMessageAccessPermission(BluetoothDevice bluetoothDevice, int n) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setMessageAccessPermission", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setMessageAccessPermission(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
            }

            @Override
            public int getSimAccessPermission(BluetoothDevice bluetoothDevice) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getSimAccessPermission", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getSimAccessPermission(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
            }

            @Override
            public boolean setSimAccessPermission(BluetoothDevice bluetoothDevice, int n) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setSimAccessPermission", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$setSimAccessPermission(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
            }

            @Override
            public void sendConnectionStateChange(BluetoothDevice bluetoothDevice, int n, int n2, int n3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("sendConnectionStateChange", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$sendConnectionStateChange(android.bluetooth.BluetoothDevice int int int ), 0, this, bluetoothDevice, n, n2, n3);
            }

            @Override
            public void registerCallback(IBluetoothCallback iBluetoothCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$registerCallback(android.bluetooth.IBluetoothCallback ), 0, this, iBluetoothCallback);
            }

            @Override
            public void unregisterCallback(IBluetoothCallback iBluetoothCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$unregisterCallback(android.bluetooth.IBluetoothCallback ), 0, this, iBluetoothCallback);
            }

            @Override
            public IBluetoothSocketManager getSocketManager() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getSocketManager", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getSocketManager(), 0, this);
            }

            @Override
            public boolean factoryReset() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("factoryReset", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$factoryReset(), 0, this);
            }

            @Override
            public boolean isMultiAdvertisementSupported() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isMultiAdvertisementSupported", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isMultiAdvertisementSupported(), 0, this);
            }

            @Override
            public boolean isOffloadedFilteringSupported() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isOffloadedFilteringSupported", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isOffloadedFilteringSupported(), 0, this);
            }

            @Override
            public boolean isOffloadedScanBatchingSupported() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isOffloadedScanBatchingSupported", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isOffloadedScanBatchingSupported(), 0, this);
            }

            @Override
            public boolean isActivityAndEnergyReportingSupported() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isActivityAndEnergyReportingSupported", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isActivityAndEnergyReportingSupported(), 0, this);
            }

            @Override
            public boolean isLe2MPhySupported() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isLe2MPhySupported", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isLe2MPhySupported(), 0, this);
            }

            @Override
            public boolean isLeCodedPhySupported() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isLeCodedPhySupported", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isLeCodedPhySupported(), 0, this);
            }

            @Override
            public boolean isLeExtendedAdvertisingSupported() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isLeExtendedAdvertisingSupported", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isLeExtendedAdvertisingSupported(), 0, this);
            }

            @Override
            public boolean isLePeriodicAdvertisingSupported() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isLePeriodicAdvertisingSupported", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$isLePeriodicAdvertisingSupported(), 0, this);
            }

            @Override
            public int getLeMaximumAdvertisingDataLength() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getLeMaximumAdvertisingDataLength", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$getLeMaximumAdvertisingDataLength(), 0, this);
            }

            @Override
            public BluetoothActivityEnergyInfo reportActivityInfo() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("reportActivityInfo", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$reportActivityInfo(), 0, this);
            }

            @Override
            public void requestActivityInfo(ResultReceiver resultReceiver) throws RemoteException {
                InvokeDynamicSupport.bootstrap("requestActivityInfo", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$requestActivityInfo(android.os.ResultReceiver ), 0, this, resultReceiver);
            }

            @Override
            public void onLeServiceUp() throws RemoteException {
                InvokeDynamicSupport.bootstrap("onLeServiceUp", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$onLeServiceUp(), 0, this);
            }

            @Override
            public void onBrEdrDown() throws RemoteException {
                InvokeDynamicSupport.bootstrap("onBrEdrDown", $$robo$$android_bluetooth_IBluetooth_Stub_Proxy$onBrEdrDown(), 0, this);
            }

            public /* synthetic */ Proxy() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Proxy)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

