/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.app.PendingIntent;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.IBluetoothGattCallback;
import android.bluetooth.IBluetoothGattServerCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.IAdvertisingSetCallback;
import android.bluetooth.le.IPeriodicAdvertisingCallback;
import android.bluetooth.le.IScannerCallback;
import android.bluetooth.le.PeriodicAdvertisingParameters;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.WorkSource;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public interface IBluetoothGatt
extends IInterface,
InstrumentedInterface {
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] var1) throws RemoteException;

    public void registerScanner(IScannerCallback var1, WorkSource var2) throws RemoteException;

    public void unregisterScanner(int var1) throws RemoteException;

    public void startScan(int var1, ScanSettings var2, List<ScanFilter> var3, List var4, String var5) throws RemoteException;

    public void startScanForIntent(PendingIntent var1, ScanSettings var2, List<ScanFilter> var3, String var4) throws RemoteException;

    public void stopScanForIntent(PendingIntent var1, String var2) throws RemoteException;

    public void stopScan(int var1) throws RemoteException;

    public void flushPendingBatchResults(int var1) throws RemoteException;

    public void startAdvertisingSet(AdvertisingSetParameters var1, AdvertiseData var2, AdvertiseData var3, PeriodicAdvertisingParameters var4, AdvertiseData var5, int var6, int var7, IAdvertisingSetCallback var8) throws RemoteException;

    public void stopAdvertisingSet(IAdvertisingSetCallback var1) throws RemoteException;

    public void getOwnAddress(int var1) throws RemoteException;

    public void enableAdvertisingSet(int var1, boolean var2, int var3, int var4) throws RemoteException;

    public void setAdvertisingData(int var1, AdvertiseData var2) throws RemoteException;

    public void setScanResponseData(int var1, AdvertiseData var2) throws RemoteException;

    public void setAdvertisingParameters(int var1, AdvertisingSetParameters var2) throws RemoteException;

    public void setPeriodicAdvertisingParameters(int var1, PeriodicAdvertisingParameters var2) throws RemoteException;

    public void setPeriodicAdvertisingData(int var1, AdvertiseData var2) throws RemoteException;

    public void setPeriodicAdvertisingEnable(int var1, boolean var2) throws RemoteException;

    public void registerSync(ScanResult var1, int var2, int var3, IPeriodicAdvertisingCallback var4) throws RemoteException;

    public void unregisterSync(IPeriodicAdvertisingCallback var1) throws RemoteException;

    public void registerClient(ParcelUuid var1, IBluetoothGattCallback var2) throws RemoteException;

    public void unregisterClient(int var1) throws RemoteException;

    public void clientConnect(int var1, String var2, boolean var3, int var4, boolean var5, int var6) throws RemoteException;

    public void clientDisconnect(int var1, String var2) throws RemoteException;

    public void clientSetPreferredPhy(int var1, String var2, int var3, int var4, int var5) throws RemoteException;

    public void clientReadPhy(int var1, String var2) throws RemoteException;

    public void refreshDevice(int var1, String var2) throws RemoteException;

    public void discoverServices(int var1, String var2) throws RemoteException;

    public void discoverServiceByUuid(int var1, String var2, ParcelUuid var3) throws RemoteException;

    public void readCharacteristic(int var1, String var2, int var3, int var4) throws RemoteException;

    public void readUsingCharacteristicUuid(int var1, String var2, ParcelUuid var3, int var4, int var5, int var6) throws RemoteException;

    public void writeCharacteristic(int var1, String var2, int var3, int var4, int var5, byte[] var6) throws RemoteException;

    public void readDescriptor(int var1, String var2, int var3, int var4) throws RemoteException;

    public void writeDescriptor(int var1, String var2, int var3, int var4, byte[] var5) throws RemoteException;

    public void registerForNotification(int var1, String var2, int var3, boolean var4) throws RemoteException;

    public void beginReliableWrite(int var1, String var2) throws RemoteException;

    public void endReliableWrite(int var1, String var2, boolean var3) throws RemoteException;

    public void readRemoteRssi(int var1, String var2) throws RemoteException;

    public void configureMTU(int var1, String var2, int var3) throws RemoteException;

    public void connectionParameterUpdate(int var1, String var2, int var3) throws RemoteException;

    public void leConnectionUpdate(int var1, String var2, int var3, int var4, int var5, int var6, int var7, int var8) throws RemoteException;

    public void registerServer(ParcelUuid var1, IBluetoothGattServerCallback var2) throws RemoteException;

    public void unregisterServer(int var1) throws RemoteException;

    public void serverConnect(int var1, String var2, boolean var3, int var4) throws RemoteException;

    public void serverDisconnect(int var1, String var2) throws RemoteException;

    public void serverSetPreferredPhy(int var1, String var2, int var3, int var4, int var5) throws RemoteException;

    public void serverReadPhy(int var1, String var2) throws RemoteException;

    public void addService(int var1, BluetoothGattService var2) throws RemoteException;

    public void removeService(int var1, int var2) throws RemoteException;

    public void clearServices(int var1) throws RemoteException;

    public void sendResponse(int var1, String var2, int var3, int var4, int var5, byte[] var6) throws RemoteException;

    public void sendNotification(int var1, String var2, int var3, boolean var4, byte[] var5) throws RemoteException;

    public void disconnectAll() throws RemoteException;

    public void unregAll() throws RemoteException;

    public int numHwTrackFiltersAvailable() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothGatt,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String DESCRIPTOR = "android.bluetooth.IBluetoothGatt";
        static int TRANSACTION_getDevicesMatchingConnectionStates = 1;
        static int TRANSACTION_registerScanner = 2;
        static int TRANSACTION_unregisterScanner = 3;
        static int TRANSACTION_startScan = 4;
        static int TRANSACTION_startScanForIntent = 5;
        static int TRANSACTION_stopScanForIntent = 6;
        static int TRANSACTION_stopScan = 7;
        static int TRANSACTION_flushPendingBatchResults = 8;
        static int TRANSACTION_startAdvertisingSet = 9;
        static int TRANSACTION_stopAdvertisingSet = 10;
        static int TRANSACTION_getOwnAddress = 11;
        static int TRANSACTION_enableAdvertisingSet = 12;
        static int TRANSACTION_setAdvertisingData = 13;
        static int TRANSACTION_setScanResponseData = 14;
        static int TRANSACTION_setAdvertisingParameters = 15;
        static int TRANSACTION_setPeriodicAdvertisingParameters = 16;
        static int TRANSACTION_setPeriodicAdvertisingData = 17;
        static int TRANSACTION_setPeriodicAdvertisingEnable = 18;
        static int TRANSACTION_registerSync = 19;
        static int TRANSACTION_unregisterSync = 20;
        static int TRANSACTION_registerClient = 21;
        static int TRANSACTION_unregisterClient = 22;
        static int TRANSACTION_clientConnect = 23;
        static int TRANSACTION_clientDisconnect = 24;
        static int TRANSACTION_clientSetPreferredPhy = 25;
        static int TRANSACTION_clientReadPhy = 26;
        static int TRANSACTION_refreshDevice = 27;
        static int TRANSACTION_discoverServices = 28;
        static int TRANSACTION_discoverServiceByUuid = 29;
        static int TRANSACTION_readCharacteristic = 30;
        static int TRANSACTION_readUsingCharacteristicUuid = 31;
        static int TRANSACTION_writeCharacteristic = 32;
        static int TRANSACTION_readDescriptor = 33;
        static int TRANSACTION_writeDescriptor = 34;
        static int TRANSACTION_registerForNotification = 35;
        static int TRANSACTION_beginReliableWrite = 36;
        static int TRANSACTION_endReliableWrite = 37;
        static int TRANSACTION_readRemoteRssi = 38;
        static int TRANSACTION_configureMTU = 39;
        static int TRANSACTION_connectionParameterUpdate = 40;
        static int TRANSACTION_leConnectionUpdate = 41;
        static int TRANSACTION_registerServer = 42;
        static int TRANSACTION_unregisterServer = 43;
        static int TRANSACTION_serverConnect = 44;
        static int TRANSACTION_serverDisconnect = 45;
        static int TRANSACTION_serverSetPreferredPhy = 46;
        static int TRANSACTION_serverReadPhy = 47;
        static int TRANSACTION_addService = 48;
        static int TRANSACTION_removeService = 49;
        static int TRANSACTION_clearServices = 50;
        static int TRANSACTION_sendResponse = 51;
        static int TRANSACTION_sendNotification = 52;
        static int TRANSACTION_disconnectAll = 53;
        static int TRANSACTION_unregAll = 54;
        static int TRANSACTION_numHwTrackFiltersAvailable = 55;

        private void $$robo$$android_bluetooth_IBluetoothGatt_Stub$__constructor__() {
            this.attachInterface(this, "android.bluetooth.IBluetoothGatt");
        }

        private static final IBluetoothGatt $$robo$$android_bluetooth_IBluetoothGatt_Stub$asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface("android.bluetooth.IBluetoothGatt");
            if (iin != null && iin instanceof IBluetoothGatt) {
                return (IBluetoothGatt)iin;
            }
            return new Proxy(obj);
        }

        private final IBinder $$robo$$android_bluetooth_IBluetoothGatt_Stub$asBinder() {
            return this;
        }

        private final boolean $$robo$$android_bluetooth_IBluetoothGatt_Stub$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = "android.bluetooth.IBluetoothGatt";
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    List _result = this.getDevicesMatchingConnectionStates(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IScannerCallback _arg0 = IScannerCallback.Stub.asInterface(data.readStrongBinder());
                    WorkSource _arg1 = 0 != data.readInt() ? WorkSource.CREATOR.createFromParcel(data) : null;
                    this.registerScanner(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.unregisterScanner(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ScanSettings _arg1 = 0 != data.readInt() ? ScanSettings.CREATOR.createFromParcel(data) : null;
                    ArrayList<ScanFilter> _arg2 = data.createTypedArrayList(ScanFilter.CREATOR);
                    ClassLoader cl = this.getClass().getClassLoader();
                    ArrayList _arg3 = data.readArrayList(cl);
                    String _arg4 = data.readString();
                    this.startScan(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    PendingIntent _arg0 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    ScanSettings _arg1 = 0 != data.readInt() ? ScanSettings.CREATOR.createFromParcel(data) : null;
                    ArrayList<ScanFilter> _arg2 = data.createTypedArrayList(ScanFilter.CREATOR);
                    String _arg3 = data.readString();
                    this.startScanForIntent(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    PendingIntent _arg0 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    this.stopScanForIntent(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.stopScan(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.flushPendingBatchResults(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    AdvertisingSetParameters _arg0 = 0 != data.readInt() ? AdvertisingSetParameters.CREATOR.createFromParcel(data) : null;
                    AdvertiseData _arg1 = 0 != data.readInt() ? AdvertiseData.CREATOR.createFromParcel(data) : null;
                    AdvertiseData _arg2 = 0 != data.readInt() ? AdvertiseData.CREATOR.createFromParcel(data) : null;
                    PeriodicAdvertisingParameters _arg3 = 0 != data.readInt() ? PeriodicAdvertisingParameters.CREATOR.createFromParcel(data) : null;
                    AdvertiseData _arg4 = 0 != data.readInt() ? AdvertiseData.CREATOR.createFromParcel(data) : null;
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    IAdvertisingSetCallback _arg7 = IAdvertisingSetCallback.Stub.asInterface(data.readStrongBinder());
                    this.startAdvertisingSet(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    IAdvertisingSetCallback _arg0 = IAdvertisingSetCallback.Stub.asInterface(data.readStrongBinder());
                    this.stopAdvertisingSet(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.getOwnAddress(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.enableAdvertisingSet(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AdvertiseData _arg1 = 0 != data.readInt() ? AdvertiseData.CREATOR.createFromParcel(data) : null;
                    this.setAdvertisingData(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AdvertiseData _arg1 = 0 != data.readInt() ? AdvertiseData.CREATOR.createFromParcel(data) : null;
                    this.setScanResponseData(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AdvertisingSetParameters _arg1 = 0 != data.readInt() ? AdvertisingSetParameters.CREATOR.createFromParcel(data) : null;
                    this.setAdvertisingParameters(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    PeriodicAdvertisingParameters _arg1 = 0 != data.readInt() ? PeriodicAdvertisingParameters.CREATOR.createFromParcel(data) : null;
                    this.setPeriodicAdvertisingParameters(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AdvertiseData _arg1 = 0 != data.readInt() ? AdvertiseData.CREATOR.createFromParcel(data) : null;
                    this.setPeriodicAdvertisingData(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.setPeriodicAdvertisingEnable(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    ScanResult _arg0 = 0 != data.readInt() ? ScanResult.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IPeriodicAdvertisingCallback _arg3 = IPeriodicAdvertisingCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerSync(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    IPeriodicAdvertisingCallback _arg0 = IPeriodicAdvertisingCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterSync(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    ParcelUuid _arg0 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    IBluetoothGattCallback _arg1 = IBluetoothGattCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerClient(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.unregisterClient(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    int _arg3 = data.readInt();
                    boolean _arg4 = 0 != data.readInt();
                    int _arg5 = data.readInt();
                    this.clientConnect(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.clientDisconnect(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    this.clientSetPreferredPhy(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.clientReadPhy(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.refreshDevice(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.discoverServices(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    ParcelUuid _arg2 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    this.discoverServiceByUuid(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.readCharacteristic(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    ParcelUuid _arg2 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    this.readUsingCharacteristicUuid(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    byte[] _arg5 = data.createByteArray();
                    this.writeCharacteristic(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.readDescriptor(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    byte[] _arg4 = data.createByteArray();
                    this.writeDescriptor(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _arg3 = 0 != data.readInt();
                    this.registerForNotification(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.beginReliableWrite(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    this.endReliableWrite(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.readRemoteRssi(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.configureMTU(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.connectionParameterUpdate(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    int _arg7 = data.readInt();
                    this.leConnectionUpdate(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    ParcelUuid _arg0 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    IBluetoothGattServerCallback _arg1 = IBluetoothGattServerCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerServer(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.unregisterServer(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    int _arg3 = data.readInt();
                    this.serverConnect(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.serverDisconnect(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    this.serverSetPreferredPhy(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.serverReadPhy(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    BluetoothGattService _arg1 = 0 != data.readInt() ? BluetoothGattService.CREATOR.createFromParcel(data) : null;
                    this.addService(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 49: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.removeService(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 50: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.clearServices(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 51: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    byte[] _arg5 = data.createByteArray();
                    this.sendResponse(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 52: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _arg3 = 0 != data.readInt();
                    byte[] _arg4 = data.createByteArray();
                    this.sendNotification(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 53: {
                    data.enforceInterface(descriptor);
                    this.disconnectAll();
                    reply.writeNoException();
                    return true;
                }
                case 54: {
                    data.enforceInterface(descriptor);
                    this.unregAll();
                    reply.writeNoException();
                    return true;
                }
                case 55: {
                    data.enforceInterface(descriptor);
                    int _result = this.numHwTrackFiltersAvailable();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private void __constructor__() {
            this.$$robo$$android_bluetooth_IBluetoothGatt_Stub$__constructor__();
        }

        public Stub() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_IBluetoothGatt_Stub$__constructor__(), 0, this);
        }

        public static IBluetoothGatt asInterface(IBinder iBinder) {
            return InvokeDynamicSupport.bootstrapStatic("asInterface", $$robo$$android_bluetooth_IBluetoothGatt_Stub$asInterface(android.os.IBinder ), 0, (IBinder)iBinder);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_bluetooth_IBluetoothGatt_Stub$asBinder(), 0, this);
        }

        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_bluetooth_IBluetoothGatt_Stub$onTransact(int android.os.Parcel android.os.Parcel int ), 0, this, n, parcel, parcel2, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Stub)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class Proxy
        implements IBluetoothGatt,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private IBinder mRemote;

            private void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$__constructor__(IBinder remote) {
                this.mRemote = remote;
            }

            private final IBinder $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$asBinder() {
                return this.mRemote;
            }

            private final String $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$getInterfaceDescriptor() {
                return "android.bluetooth.IBluetoothGatt";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<BluetoothDevice> $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$getDevicesMatchingConnectionStates(int[] states) throws RemoteException {
                ArrayList<BluetoothDevice> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeIntArray(states);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BluetoothDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerScanner(IScannerCallback callback, WorkSource workSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    if (workSource != null) {
                        _data.writeInt(1);
                        workSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$unregisterScanner(int scannerId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(scannerId);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$startScan(int scannerId, ScanSettings settings, List<ScanFilter> filters, List scanStorages, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(scannerId);
                    if (settings != null) {
                        _data.writeInt(1);
                        settings.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedList(filters);
                    _data.writeList(scanStorages);
                    _data.writeString(callingPackage);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$startScanForIntent(PendingIntent intent, ScanSettings settings, List<ScanFilter> filters, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (settings != null) {
                        _data.writeInt(1);
                        settings.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedList(filters);
                    _data.writeString(callingPackage);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$stopScanForIntent(PendingIntent intent, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(callingPackage);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$stopScan(int scannerId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(scannerId);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$flushPendingBatchResults(int scannerId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(scannerId);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtAdvEvents, IAdvertisingSetCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    if (parameters != null) {
                        _data.writeInt(1);
                        parameters.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (advertiseData != null) {
                        _data.writeInt(1);
                        advertiseData.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (scanResponse != null) {
                        _data.writeInt(1);
                        scanResponse.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (periodicParameters != null) {
                        _data.writeInt(1);
                        periodicParameters.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (periodicData != null) {
                        _data.writeInt(1);
                        periodicData.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(duration);
                    _data.writeInt(maxExtAdvEvents);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$stopAdvertisingSet(IAdvertisingSetCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$getOwnAddress(int advertiserId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(advertiserId);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$enableAdvertisingSet(int advertiserId, boolean enable, int duration, int maxExtAdvEvents) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(advertiserId);
                    _data.writeInt(enable ? 1 : 0);
                    _data.writeInt(duration);
                    _data.writeInt(maxExtAdvEvents);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$setAdvertisingData(int advertiserId, AdvertiseData data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(advertiserId);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$setScanResponseData(int advertiserId, AdvertiseData data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(advertiserId);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$setAdvertisingParameters(int advertiserId, AdvertisingSetParameters parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(advertiserId);
                    if (parameters != null) {
                        _data.writeInt(1);
                        parameters.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$setPeriodicAdvertisingParameters(int advertiserId, PeriodicAdvertisingParameters parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(advertiserId);
                    if (parameters != null) {
                        _data.writeInt(1);
                        parameters.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$setPeriodicAdvertisingData(int advertiserId, AdvertiseData data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(advertiserId);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$setPeriodicAdvertisingEnable(int advertiserId, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(advertiserId);
                    _data.writeInt(enable ? 1 : 0);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerSync(ScanResult scanResult, int skip, int timeout, IPeriodicAdvertisingCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    if (scanResult != null) {
                        _data.writeInt(1);
                        scanResult.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(skip);
                    _data.writeInt(timeout);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$unregisterSync(IPeriodicAdvertisingCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerClient(ParcelUuid appId, IBluetoothGattCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    if (appId != null) {
                        _data.writeInt(1);
                        appId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$unregisterClient(int clientIf) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clientConnect(int clientIf, String address, boolean isDirect, int transport, boolean opportunistic, int phy) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(isDirect ? 1 : 0);
                    _data.writeInt(transport);
                    _data.writeInt(opportunistic ? 1 : 0);
                    _data.writeInt(phy);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clientDisconnect(int clientIf, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clientSetPreferredPhy(int clientIf, String address, int txPhy, int rxPhy, int phyOptions) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(txPhy);
                    _data.writeInt(rxPhy);
                    _data.writeInt(phyOptions);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clientReadPhy(int clientIf, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$refreshDevice(int clientIf, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$discoverServices(int clientIf, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$discoverServiceByUuid(int clientIf, String address, ParcelUuid uuid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    if (uuid != null) {
                        _data.writeInt(1);
                        uuid.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$readCharacteristic(int clientIf, String address, int handle, int authReq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(handle);
                    _data.writeInt(authReq);
                    this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$readUsingCharacteristicUuid(int clientIf, String address, ParcelUuid uuid, int startHandle, int endHandle, int authReq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    if (uuid != null) {
                        _data.writeInt(1);
                        uuid.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(startHandle);
                    _data.writeInt(endHandle);
                    _data.writeInt(authReq);
                    this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$writeCharacteristic(int clientIf, String address, int handle, int writeType, int authReq, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(handle);
                    _data.writeInt(writeType);
                    _data.writeInt(authReq);
                    _data.writeByteArray(value);
                    this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$readDescriptor(int clientIf, String address, int handle, int authReq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(handle);
                    _data.writeInt(authReq);
                    this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$writeDescriptor(int clientIf, String address, int handle, int authReq, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(handle);
                    _data.writeInt(authReq);
                    _data.writeByteArray(value);
                    this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerForNotification(int clientIf, String address, int handle, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(handle);
                    _data.writeInt(enable ? 1 : 0);
                    this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$beginReliableWrite(int clientIf, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$endReliableWrite(int clientIf, String address, boolean execute) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(execute ? 1 : 0);
                    this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$readRemoteRssi(int clientIf, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$configureMTU(int clientIf, String address, int mtu) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(mtu);
                    this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$connectionParameterUpdate(int clientIf, String address, int connectionPriority) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(connectionPriority);
                    this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$leConnectionUpdate(int clientIf, String address, int minInterval, int maxInterval, int slaveLatency, int supervisionTimeout, int minConnectionEventLen, int maxConnectionEventLen) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(minInterval);
                    _data.writeInt(maxInterval);
                    _data.writeInt(slaveLatency);
                    _data.writeInt(supervisionTimeout);
                    _data.writeInt(minConnectionEventLen);
                    _data.writeInt(maxConnectionEventLen);
                    this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerServer(ParcelUuid appId, IBluetoothGattServerCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    if (appId != null) {
                        _data.writeInt(1);
                        appId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$unregisterServer(int serverIf) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$serverConnect(int serverIf, String address, boolean isDirect, int transport) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    _data.writeString(address);
                    _data.writeInt(isDirect ? 1 : 0);
                    _data.writeInt(transport);
                    this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$serverDisconnect(int serverIf, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    _data.writeString(address);
                    this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$serverSetPreferredPhy(int clientIf, String address, int txPhy, int rxPhy, int phyOptions) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(txPhy);
                    _data.writeInt(rxPhy);
                    _data.writeInt(phyOptions);
                    this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$serverReadPhy(int clientIf, String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$addService(int serverIf, BluetoothGattService service) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    if (service != null) {
                        _data.writeInt(1);
                        service.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$removeService(int serverIf, int handle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    _data.writeInt(handle);
                    this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clearServices(int serverIf) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$sendResponse(int serverIf, String address, int requestId, int status, int offset, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    _data.writeString(address);
                    _data.writeInt(requestId);
                    _data.writeInt(status);
                    _data.writeInt(offset);
                    _data.writeByteArray(value);
                    this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$sendNotification(int serverIf, String address, int handle, boolean confirm, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    _data.writeInt(serverIf);
                    _data.writeString(address);
                    _data.writeInt(handle);
                    _data.writeInt(confirm ? 1 : 0);
                    _data.writeByteArray(value);
                    this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$disconnectAll() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private final void $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$unregAll() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$numHwTrackFiltersAvailable() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.bluetooth.IBluetoothGatt");
                    this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            private void __constructor__(IBinder iBinder) {
                this.$$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$__constructor__(iBinder);
            }

            Proxy(IBinder iBinder) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$__constructor__(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public IBinder asBinder() {
                return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$asBinder(), 0, this);
            }

            public String getInterfaceDescriptor() {
                return InvokeDynamicSupport.bootstrap("getInterfaceDescriptor", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$getInterfaceDescriptor(), 0, this);
            }

            @Override
            public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$getDevicesMatchingConnectionStates(int[] ), 0, this, nArray);
            }

            @Override
            public void registerScanner(IScannerCallback iScannerCallback, WorkSource workSource) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registerScanner", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerScanner(android.bluetooth.le.IScannerCallback android.os.WorkSource ), 0, this, iScannerCallback, workSource);
            }

            @Override
            public void unregisterScanner(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unregisterScanner", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$unregisterScanner(int ), 0, this, n);
            }

            @Override
            public void startScan(int n, ScanSettings scanSettings, List<ScanFilter> list, List list2, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("startScan", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$startScan(int android.bluetooth.le.ScanSettings java.util.List<android.bluetooth.le.ScanFilter> java.util.List java.lang.String ), 0, this, n, scanSettings, list, list2, string2);
            }

            @Override
            public void startScanForIntent(PendingIntent pendingIntent, ScanSettings scanSettings, List<ScanFilter> list, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("startScanForIntent", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$startScanForIntent(android.app.PendingIntent android.bluetooth.le.ScanSettings java.util.List<android.bluetooth.le.ScanFilter> java.lang.String ), 0, this, pendingIntent, scanSettings, list, string2);
            }

            @Override
            public void stopScanForIntent(PendingIntent pendingIntent, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("stopScanForIntent", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$stopScanForIntent(android.app.PendingIntent java.lang.String ), 0, this, pendingIntent, string2);
            }

            @Override
            public void stopScan(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("stopScan", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$stopScan(int ), 0, this, n);
            }

            @Override
            public void flushPendingBatchResults(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("flushPendingBatchResults", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$flushPendingBatchResults(int ), 0, this, n);
            }

            @Override
            public void startAdvertisingSet(AdvertisingSetParameters advertisingSetParameters, AdvertiseData advertiseData, AdvertiseData advertiseData2, PeriodicAdvertisingParameters periodicAdvertisingParameters, AdvertiseData advertiseData3, int n, int n2, IAdvertisingSetCallback iAdvertisingSetCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("startAdvertisingSet", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$startAdvertisingSet(android.bluetooth.le.AdvertisingSetParameters android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseData android.bluetooth.le.PeriodicAdvertisingParameters android.bluetooth.le.AdvertiseData int int android.bluetooth.le.IAdvertisingSetCallback ), 0, this, advertisingSetParameters, advertiseData, advertiseData2, periodicAdvertisingParameters, advertiseData3, n, n2, iAdvertisingSetCallback);
            }

            @Override
            public void stopAdvertisingSet(IAdvertisingSetCallback iAdvertisingSetCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("stopAdvertisingSet", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$stopAdvertisingSet(android.bluetooth.le.IAdvertisingSetCallback ), 0, this, iAdvertisingSetCallback);
            }

            @Override
            public void getOwnAddress(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("getOwnAddress", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$getOwnAddress(int ), 0, this, n);
            }

            @Override
            public void enableAdvertisingSet(int n, boolean bl, int n2, int n3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("enableAdvertisingSet", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$enableAdvertisingSet(int boolean int int ), 0, this, n, bl, n2, n3);
            }

            @Override
            public void setAdvertisingData(int n, AdvertiseData advertiseData) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setAdvertisingData", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$setAdvertisingData(int android.bluetooth.le.AdvertiseData ), 0, this, n, advertiseData);
            }

            @Override
            public void setScanResponseData(int n, AdvertiseData advertiseData) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setScanResponseData", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$setScanResponseData(int android.bluetooth.le.AdvertiseData ), 0, this, n, advertiseData);
            }

            @Override
            public void setAdvertisingParameters(int n, AdvertisingSetParameters advertisingSetParameters) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setAdvertisingParameters", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$setAdvertisingParameters(int android.bluetooth.le.AdvertisingSetParameters ), 0, this, n, advertisingSetParameters);
            }

            @Override
            public void setPeriodicAdvertisingParameters(int n, PeriodicAdvertisingParameters periodicAdvertisingParameters) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setPeriodicAdvertisingParameters", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$setPeriodicAdvertisingParameters(int android.bluetooth.le.PeriodicAdvertisingParameters ), 0, this, n, periodicAdvertisingParameters);
            }

            @Override
            public void setPeriodicAdvertisingData(int n, AdvertiseData advertiseData) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setPeriodicAdvertisingData", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$setPeriodicAdvertisingData(int android.bluetooth.le.AdvertiseData ), 0, this, n, advertiseData);
            }

            @Override
            public void setPeriodicAdvertisingEnable(int n, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setPeriodicAdvertisingEnable", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$setPeriodicAdvertisingEnable(int boolean ), 0, this, n, bl);
            }

            @Override
            public void registerSync(ScanResult scanResult, int n, int n2, IPeriodicAdvertisingCallback iPeriodicAdvertisingCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registerSync", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerSync(android.bluetooth.le.ScanResult int int android.bluetooth.le.IPeriodicAdvertisingCallback ), 0, this, scanResult, n, n2, iPeriodicAdvertisingCallback);
            }

            @Override
            public void unregisterSync(IPeriodicAdvertisingCallback iPeriodicAdvertisingCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unregisterSync", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$unregisterSync(android.bluetooth.le.IPeriodicAdvertisingCallback ), 0, this, iPeriodicAdvertisingCallback);
            }

            @Override
            public void registerClient(ParcelUuid parcelUuid, IBluetoothGattCallback iBluetoothGattCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registerClient", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerClient(android.os.ParcelUuid android.bluetooth.IBluetoothGattCallback ), 0, this, parcelUuid, iBluetoothGattCallback);
            }

            @Override
            public void unregisterClient(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unregisterClient", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$unregisterClient(int ), 0, this, n);
            }

            @Override
            public void clientConnect(int n, String string2, boolean bl, int n2, boolean bl2, int n3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("clientConnect", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clientConnect(int java.lang.String boolean int boolean int ), 0, this, n, string2, bl, n2, bl2, n3);
            }

            @Override
            public void clientDisconnect(int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("clientDisconnect", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clientDisconnect(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void clientSetPreferredPhy(int n, String string2, int n2, int n3, int n4) throws RemoteException {
                InvokeDynamicSupport.bootstrap("clientSetPreferredPhy", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clientSetPreferredPhy(int java.lang.String int int int ), 0, this, n, string2, n2, n3, n4);
            }

            @Override
            public void clientReadPhy(int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("clientReadPhy", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clientReadPhy(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void refreshDevice(int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("refreshDevice", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$refreshDevice(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void discoverServices(int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("discoverServices", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$discoverServices(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void discoverServiceByUuid(int n, String string2, ParcelUuid parcelUuid) throws RemoteException {
                InvokeDynamicSupport.bootstrap("discoverServiceByUuid", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$discoverServiceByUuid(int java.lang.String android.os.ParcelUuid ), 0, this, n, string2, parcelUuid);
            }

            @Override
            public void readCharacteristic(int n, String string2, int n2, int n3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("readCharacteristic", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$readCharacteristic(int java.lang.String int int ), 0, this, n, string2, n2, n3);
            }

            @Override
            public void readUsingCharacteristicUuid(int n, String string2, ParcelUuid parcelUuid, int n2, int n3, int n4) throws RemoteException {
                InvokeDynamicSupport.bootstrap("readUsingCharacteristicUuid", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$readUsingCharacteristicUuid(int java.lang.String android.os.ParcelUuid int int int ), 0, this, n, string2, parcelUuid, n2, n3, n4);
            }

            @Override
            public void writeCharacteristic(int n, String string2, int n2, int n3, int n4, byte[] byArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("writeCharacteristic", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$writeCharacteristic(int java.lang.String int int int byte[] ), 0, this, n, string2, n2, n3, n4, byArray);
            }

            @Override
            public void readDescriptor(int n, String string2, int n2, int n3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("readDescriptor", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$readDescriptor(int java.lang.String int int ), 0, this, n, string2, n2, n3);
            }

            @Override
            public void writeDescriptor(int n, String string2, int n2, int n3, byte[] byArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("writeDescriptor", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$writeDescriptor(int java.lang.String int int byte[] ), 0, this, n, string2, n2, n3, byArray);
            }

            @Override
            public void registerForNotification(int n, String string2, int n2, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registerForNotification", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerForNotification(int java.lang.String int boolean ), 0, this, n, string2, n2, bl);
            }

            @Override
            public void beginReliableWrite(int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("beginReliableWrite", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$beginReliableWrite(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void endReliableWrite(int n, String string2, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("endReliableWrite", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$endReliableWrite(int java.lang.String boolean ), 0, this, n, string2, bl);
            }

            @Override
            public void readRemoteRssi(int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("readRemoteRssi", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$readRemoteRssi(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void configureMTU(int n, String string2, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("configureMTU", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$configureMTU(int java.lang.String int ), 0, this, n, string2, n2);
            }

            @Override
            public void connectionParameterUpdate(int n, String string2, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("connectionParameterUpdate", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$connectionParameterUpdate(int java.lang.String int ), 0, this, n, string2, n2);
            }

            @Override
            public void leConnectionUpdate(int n, String string2, int n2, int n3, int n4, int n5, int n6, int n7) throws RemoteException {
                InvokeDynamicSupport.bootstrap("leConnectionUpdate", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$leConnectionUpdate(int java.lang.String int int int int int int ), 0, this, n, string2, n2, n3, n4, n5, n6, n7);
            }

            @Override
            public void registerServer(ParcelUuid parcelUuid, IBluetoothGattServerCallback iBluetoothGattServerCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registerServer", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$registerServer(android.os.ParcelUuid android.bluetooth.IBluetoothGattServerCallback ), 0, this, parcelUuid, iBluetoothGattServerCallback);
            }

            @Override
            public void unregisterServer(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unregisterServer", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$unregisterServer(int ), 0, this, n);
            }

            @Override
            public void serverConnect(int n, String string2, boolean bl, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("serverConnect", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$serverConnect(int java.lang.String boolean int ), 0, this, n, string2, bl, n2);
            }

            @Override
            public void serverDisconnect(int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("serverDisconnect", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$serverDisconnect(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void serverSetPreferredPhy(int n, String string2, int n2, int n3, int n4) throws RemoteException {
                InvokeDynamicSupport.bootstrap("serverSetPreferredPhy", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$serverSetPreferredPhy(int java.lang.String int int int ), 0, this, n, string2, n2, n3, n4);
            }

            @Override
            public void serverReadPhy(int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("serverReadPhy", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$serverReadPhy(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void addService(int n, BluetoothGattService bluetoothGattService) throws RemoteException {
                InvokeDynamicSupport.bootstrap("addService", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$addService(int android.bluetooth.BluetoothGattService ), 0, this, n, bluetoothGattService);
            }

            @Override
            public void removeService(int n, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("removeService", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$removeService(int int ), 0, this, n, n2);
            }

            @Override
            public void clearServices(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("clearServices", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$clearServices(int ), 0, this, n);
            }

            @Override
            public void sendResponse(int n, String string2, int n2, int n3, int n4, byte[] byArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("sendResponse", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$sendResponse(int java.lang.String int int int byte[] ), 0, this, n, string2, n2, n3, n4, byArray);
            }

            @Override
            public void sendNotification(int n, String string2, int n2, boolean bl, byte[] byArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("sendNotification", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$sendNotification(int java.lang.String int boolean byte[] ), 0, this, n, string2, n2, bl, byArray);
            }

            @Override
            public void disconnectAll() throws RemoteException {
                InvokeDynamicSupport.bootstrap("disconnectAll", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$disconnectAll(), 0, this);
            }

            @Override
            public void unregAll() throws RemoteException {
                InvokeDynamicSupport.bootstrap("unregAll", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$unregAll(), 0, this);
            }

            @Override
            public int numHwTrackFiltersAvailable() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("numHwTrackFiltersAvailable", $$robo$$android_bluetooth_IBluetoothGatt_Stub_Proxy$numHwTrackFiltersAvailable(), 0, this);
            }

            public /* synthetic */ Proxy() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Proxy)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

