/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.text.TextUtils;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ClipDescription
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String MIMETYPE_TEXT_PLAIN = "text/plain";
    public static String MIMETYPE_TEXT_HTML = "text/html";
    public static String MIMETYPE_TEXT_URILIST = "text/uri-list";
    public static String MIMETYPE_TEXT_INTENT = "text/vnd.android.intent";
    public static String EXTRA_TARGET_COMPONENT_NAME = "android.content.extra.TARGET_COMPONENT_NAME";
    public static String EXTRA_USER_SERIAL_NUMBER = "android.content.extra.USER_SERIAL_NUMBER";
    CharSequence mLabel;
    private ArrayList<String> mMimeTypes;
    private PersistableBundle mExtras;
    private long mTimeStamp;
    public static Parcelable.Creator<ClipDescription> CREATOR;

    private void $$robo$$android_content_ClipDescription$__constructor__(CharSequence label, String[] mimeTypes) {
        if (mimeTypes == null) {
            throw new NullPointerException("mimeTypes is null");
        }
        this.mLabel = label;
        this.mMimeTypes = new ArrayList<String>(Arrays.asList(mimeTypes));
    }

    private void $$robo$$android_content_ClipDescription$__constructor__(ClipDescription o) {
        this.mLabel = o.mLabel;
        this.mMimeTypes = new ArrayList<String>(o.mMimeTypes);
        this.mTimeStamp = o.mTimeStamp;
    }

    private static final boolean $$robo$$android_content_ClipDescription$compareMimeTypes(String concreteType, String desiredType) {
        int typeLength = desiredType.length();
        if (typeLength == 3 && desiredType.equals("*/*")) {
            return true;
        }
        int slashpos = desiredType.indexOf(47);
        return slashpos > 0 && (typeLength == slashpos + 2 && desiredType.charAt(slashpos + 1) == '*' ? desiredType.regionMatches(0, concreteType, 0, slashpos + 1) : desiredType.equals(concreteType));
    }

    private final void $$robo$$android_content_ClipDescription$setTimestamp(long timeStamp) {
        this.mTimeStamp = timeStamp;
    }

    private final long $$robo$$android_content_ClipDescription$getTimestamp() {
        return this.mTimeStamp;
    }

    private final CharSequence $$robo$$android_content_ClipDescription$getLabel() {
        return this.mLabel;
    }

    private final boolean $$robo$$android_content_ClipDescription$hasMimeType(String mimeType) {
        int size = this.mMimeTypes.size();
        for (int i = 0; i < size; ++i) {
            if (!ClipDescription.compareMimeTypes(this.mMimeTypes.get(i), mimeType)) continue;
            return true;
        }
        return false;
    }

    private final String[] $$robo$$android_content_ClipDescription$filterMimeTypes(String mimeType) {
        ArrayList<String> array2 = null;
        int size = this.mMimeTypes.size();
        for (int i = 0; i < size; ++i) {
            if (!ClipDescription.compareMimeTypes(this.mMimeTypes.get(i), mimeType)) continue;
            if (array2 == null) {
                array2 = new ArrayList<String>();
            }
            array2.add(this.mMimeTypes.get(i));
        }
        if (array2 == null) {
            return null;
        }
        String[] rawArray = new String[array2.size()];
        array2.toArray(rawArray);
        return rawArray;
    }

    private final int $$robo$$android_content_ClipDescription$getMimeTypeCount() {
        return this.mMimeTypes.size();
    }

    private final String $$robo$$android_content_ClipDescription$getMimeType(int index) {
        return this.mMimeTypes.get(index);
    }

    private final void $$robo$$android_content_ClipDescription$addMimeTypes(String[] mimeTypes) {
        for (int i = 0; i != mimeTypes.length; ++i) {
            String mimeType = mimeTypes[i];
            if (this.mMimeTypes.contains(mimeType)) continue;
            this.mMimeTypes.add(mimeType);
        }
    }

    private final PersistableBundle $$robo$$android_content_ClipDescription$getExtras() {
        return this.mExtras;
    }

    private final void $$robo$$android_content_ClipDescription$setExtras(PersistableBundle extras) {
        this.mExtras = new PersistableBundle(extras);
    }

    private final void $$robo$$android_content_ClipDescription$validate() {
        if (this.mMimeTypes == null) {
            throw new NullPointerException("null mime types");
        }
        int size = this.mMimeTypes.size();
        if (size <= 0) {
            throw new IllegalArgumentException("must have at least 1 mime type");
        }
        for (int i = 0; i < size; ++i) {
            if (this.mMimeTypes.get(i) != null) continue;
            throw new NullPointerException("mime type at " + i + " is null");
        }
    }

    private final String $$robo$$android_content_ClipDescription$toString() {
        StringBuilder b = new StringBuilder(128);
        b.append("ClipDescription { ");
        this.toShortString(b);
        b.append(" }");
        return b.toString();
    }

    private final boolean $$robo$$android_content_ClipDescription$toShortString(StringBuilder b) {
        boolean first;
        boolean bl = first = !this.toShortStringTypesOnly(b);
        if (this.mLabel != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append('\"');
            b.append(this.mLabel);
            b.append('\"');
        }
        if (this.mExtras != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append(this.mExtras.toString());
        }
        if (this.mTimeStamp > 0L) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append('<');
            b.append(TimeUtils.logTimeOfDay(this.mTimeStamp));
            b.append('>');
        }
        return !first;
    }

    private final boolean $$robo$$android_content_ClipDescription$toShortStringTypesOnly(StringBuilder b) {
        boolean first = true;
        int size = this.mMimeTypes.size();
        for (int i = 0; i < size; ++i) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append(this.mMimeTypes.get(i));
        }
        return !first;
    }

    private final void $$robo$$android_content_ClipDescription$writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        int size = this.mMimeTypes.size();
        for (int i = 0; i < size; ++i) {
            proto.write(2237677961217L, this.mMimeTypes.get(i));
        }
        if (this.mLabel != null) {
            proto.write(1138166333442L, this.mLabel.toString());
        }
        if (this.mExtras != null) {
            this.mExtras.writeToProto(proto, 1146756268035L);
        }
        if (this.mTimeStamp > 0L) {
            proto.write(1112396529668L, this.mTimeStamp);
        }
        proto.end(token);
    }

    private final int $$robo$$android_content_ClipDescription$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_ClipDescription$writeToParcel(Parcel dest, int flags) {
        TextUtils.writeToParcel(this.mLabel, dest, flags);
        dest.writeStringList(this.mMimeTypes);
        dest.writePersistableBundle(this.mExtras);
        dest.writeLong(this.mTimeStamp);
    }

    private void $$robo$$android_content_ClipDescription$__constructor__(Parcel in) {
        this.mLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mMimeTypes = in.createStringArrayList();
        this.mExtras = in.readPersistableBundle();
        this.mTimeStamp = in.readLong();
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ClipDescription>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_ClipDescription_1$__constructor__() {
            }

            private final ClipDescription $$robo$$android_content_ClipDescription_1$createFromParcel(Parcel source) {
                return new ClipDescription(source);
            }

            private final ClipDescription[] $$robo$$android_content_ClipDescription_1$newArray(int size) {
                return new ClipDescription[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_ClipDescription_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipDescription_1$__constructor__(), 0, this);
            }

            @Override
            public ClipDescription createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_ClipDescription_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ClipDescription[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_ClipDescription_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(CharSequence charSequence, String[] stringArray) {
        this.$$robo$$android_content_ClipDescription$__constructor__(charSequence, stringArray);
    }

    public ClipDescription(CharSequence charSequence, String[] stringArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipDescription$__constructor__(java.lang.CharSequence java.lang.String[] ), 0, this, charSequence, stringArray);
    }

    private void __constructor__(ClipDescription clipDescription) {
        this.$$robo$$android_content_ClipDescription$__constructor__(clipDescription);
    }

    public ClipDescription(ClipDescription clipDescription) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipDescription$__constructor__(android.content.ClipDescription ), 0, this, clipDescription);
    }

    public static boolean compareMimeTypes(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("compareMimeTypes", $$robo$$android_content_ClipDescription$compareMimeTypes(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public void setTimestamp(long l) {
        InvokeDynamicSupport.bootstrap("setTimestamp", $$robo$$android_content_ClipDescription$setTimestamp(long ), 0, this, l);
    }

    public long getTimestamp() {
        return (long)InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$android_content_ClipDescription$getTimestamp(), 0, this);
    }

    public CharSequence getLabel() {
        return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_content_ClipDescription$getLabel(), 0, this);
    }

    public boolean hasMimeType(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMimeType", $$robo$$android_content_ClipDescription$hasMimeType(java.lang.String ), 0, this, string2);
    }

    public String[] filterMimeTypes(String string2) {
        return InvokeDynamicSupport.bootstrap("filterMimeTypes", $$robo$$android_content_ClipDescription$filterMimeTypes(java.lang.String ), 0, this, string2);
    }

    public int getMimeTypeCount() {
        return (int)InvokeDynamicSupport.bootstrap("getMimeTypeCount", $$robo$$android_content_ClipDescription$getMimeTypeCount(), 0, this);
    }

    public String getMimeType(int n) {
        return InvokeDynamicSupport.bootstrap("getMimeType", $$robo$$android_content_ClipDescription$getMimeType(int ), 0, this, n);
    }

    void addMimeTypes(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("addMimeTypes", $$robo$$android_content_ClipDescription$addMimeTypes(java.lang.String[] ), 0, this, stringArray);
    }

    public PersistableBundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_content_ClipDescription$getExtras(), 0, this);
    }

    public void setExtras(PersistableBundle persistableBundle) {
        InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_content_ClipDescription$setExtras(android.os.PersistableBundle ), 0, this, persistableBundle);
    }

    public void validate() {
        InvokeDynamicSupport.bootstrap("validate", $$robo$$android_content_ClipDescription$validate(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_ClipDescription$toString(), 0, this);
    }

    public boolean toShortString(StringBuilder stringBuilder) {
        return (boolean)InvokeDynamicSupport.bootstrap("toShortString", $$robo$$android_content_ClipDescription$toShortString(java.lang.StringBuilder ), 0, this, stringBuilder);
    }

    public boolean toShortStringTypesOnly(StringBuilder stringBuilder) {
        return (boolean)InvokeDynamicSupport.bootstrap("toShortStringTypesOnly", $$robo$$android_content_ClipDescription$toShortStringTypesOnly(java.lang.StringBuilder ), 0, this, stringBuilder);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long l) {
        InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_content_ClipDescription$writeToProto(android.util.proto.ProtoOutputStream long ), 0, this, protoOutputStream, l);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_ClipDescription$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_ClipDescription$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_ClipDescription$__constructor__(parcel);
    }

    ClipDescription(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ClipDescription$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    static {
        RobolectricInternals.classInitializing(ClipDescription.class);
    }

    public /* synthetic */ ClipDescription() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ClipDescription)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

