/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.res.AssetFileDescriptor;
import android.database.CrossProcessCursorWrapper;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.ICancellationSignal;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ContentProviderClient
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ContentProviderClient";
    @GuardedBy(value="ContentProviderClient.class")
    private static Handler sAnrHandler;
    private ContentResolver mContentResolver;
    private IContentProvider mContentProvider;
    private String mPackageName;
    private boolean mStable;
    private AtomicBoolean mClosed;
    private CloseGuard mCloseGuard;
    private long mAnrTimeout;
    private NotRespondingRunnable mAnrRunnable;

    @VisibleForTesting
    private void $$robo$$android_content_ContentProviderClient$__constructor__(ContentResolver contentResolver, IContentProvider contentProvider, boolean stable) {
        this.mClosed = new AtomicBoolean();
        this.mCloseGuard = CloseGuard.get();
        this.mContentResolver = contentResolver;
        this.mContentProvider = contentProvider;
        this.mPackageName = contentResolver.mPackageName;
        this.mStable = stable;
        this.mCloseGuard.open("close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_ContentProviderClient$setDetectNotResponding(long timeoutMillis) {
        Class<ContentProviderClient> clazz = ContentProviderClient.class;
        synchronized (ContentProviderClient.class) {
            this.mAnrTimeout = timeoutMillis;
            if (timeoutMillis > 0L) {
                if (this.mAnrRunnable == null) {
                    this.mAnrRunnable = new NotRespondingRunnable(this);
                }
                if (sAnrHandler == null) {
                    sAnrHandler = new Handler(Looper.getMainLooper(), null, true);
                }
                Binder.allowBlocking(this.mContentProvider.asBinder());
            } else {
                this.mAnrRunnable = null;
                Binder.defaultBlocking(this.mContentProvider.asBinder());
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    private final void $$robo$$android_content_ContentProviderClient$beforeRemote() {
        if (this.mAnrRunnable != null) {
            sAnrHandler.postDelayed(this.mAnrRunnable, this.mAnrTimeout);
        }
    }

    private final void $$robo$$android_content_ContentProviderClient$afterRemote() {
        if (this.mAnrRunnable != null) {
            sAnrHandler.removeCallbacks(this.mAnrRunnable);
        }
    }

    private final Cursor $$robo$$android_content_ContentProviderClient$query(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder) throws RemoteException {
        return this.query(url, projection, selection, selectionArgs, sortOrder, null);
    }

    private final Cursor $$robo$$android_content_ContentProviderClient$query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) throws RemoteException {
        Bundle queryArgs = ContentResolver.createSqlQueryBundle(selection, selectionArgs, sortOrder);
        return this.query(uri, projection, queryArgs, cancellationSignal);
    }

    private final Cursor $$robo$$android_content_ContentProviderClient$query(Uri uri, String[] projection, Bundle queryArgs, CancellationSignal cancellationSignal) throws RemoteException {
        Preconditions.checkNotNull(uri, "url");
        this.beforeRemote();
        try {
            Cursor cursor;
            ICancellationSignal remoteCancellationSignal = null;
            if (cancellationSignal != null) {
                cancellationSignal.throwIfCanceled();
                remoteCancellationSignal = this.mContentProvider.createCancellationSignal();
                cancellationSignal.setRemote(remoteCancellationSignal);
            }
            if ((cursor = this.mContentProvider.query(this.mPackageName, uri, projection, queryArgs, remoteCancellationSignal)) == null) {
                Cursor cursor2 = null;
                return cursor2;
            }
            CursorWrapperInner cursorWrapperInner = new CursorWrapperInner(this, cursor);
            return cursorWrapperInner;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final String $$robo$$android_content_ContentProviderClient$getType(Uri url) throws RemoteException {
        Preconditions.checkNotNull(url, "url");
        this.beforeRemote();
        try {
            String string2 = this.mContentProvider.getType(url);
            return string2;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final String[] $$robo$$android_content_ContentProviderClient$getStreamTypes(Uri url, String mimeTypeFilter) throws RemoteException {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(mimeTypeFilter, "mimeTypeFilter");
        this.beforeRemote();
        try {
            String[] stringArray = this.mContentProvider.getStreamTypes(url, mimeTypeFilter);
            return stringArray;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final Uri $$robo$$android_content_ContentProviderClient$canonicalize(Uri url) throws RemoteException {
        Preconditions.checkNotNull(url, "url");
        this.beforeRemote();
        try {
            Uri uri = this.mContentProvider.canonicalize(this.mPackageName, url);
            return uri;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final Uri $$robo$$android_content_ContentProviderClient$uncanonicalize(Uri url) throws RemoteException {
        Preconditions.checkNotNull(url, "url");
        this.beforeRemote();
        try {
            Uri uri = this.mContentProvider.uncanonicalize(this.mPackageName, url);
            return uri;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final boolean $$robo$$android_content_ContentProviderClient$refresh(Uri url, Bundle args, CancellationSignal cancellationSignal) throws RemoteException {
        Preconditions.checkNotNull(url, "url");
        this.beforeRemote();
        try {
            ICancellationSignal remoteCancellationSignal = null;
            if (cancellationSignal != null) {
                cancellationSignal.throwIfCanceled();
                remoteCancellationSignal = this.mContentProvider.createCancellationSignal();
                cancellationSignal.setRemote(remoteCancellationSignal);
            }
            boolean bl = this.mContentProvider.refresh(this.mPackageName, url, args, remoteCancellationSignal);
            return bl;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final Uri $$robo$$android_content_ContentProviderClient$insert(Uri url, ContentValues initialValues) throws RemoteException {
        Preconditions.checkNotNull(url, "url");
        this.beforeRemote();
        try {
            Uri uri = this.mContentProvider.insert(this.mPackageName, url, initialValues);
            return uri;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final int $$robo$$android_content_ContentProviderClient$bulkInsert(Uri url, ContentValues[] initialValues) throws RemoteException {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(initialValues, "initialValues");
        this.beforeRemote();
        try {
            int n = this.mContentProvider.bulkInsert(this.mPackageName, url, initialValues);
            return n;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final int $$robo$$android_content_ContentProviderClient$delete(Uri url, String selection, String[] selectionArgs) throws RemoteException {
        Preconditions.checkNotNull(url, "url");
        this.beforeRemote();
        try {
            int n = this.mContentProvider.delete(this.mPackageName, url, selection, selectionArgs);
            return n;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final int $$robo$$android_content_ContentProviderClient$update(Uri url, ContentValues values, String selection, String[] selectionArgs) throws RemoteException {
        Preconditions.checkNotNull(url, "url");
        this.beforeRemote();
        try {
            int n = this.mContentProvider.update(this.mPackageName, url, values, selection, selectionArgs);
            return n;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final ParcelFileDescriptor $$robo$$android_content_ContentProviderClient$openFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        return this.openFile(url, mode, null);
    }

    private final ParcelFileDescriptor $$robo$$android_content_ContentProviderClient$openFile(Uri url, String mode, CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(mode, "mode");
        this.beforeRemote();
        try {
            ICancellationSignal remoteSignal = null;
            if (signal != null) {
                signal.throwIfCanceled();
                remoteSignal = this.mContentProvider.createCancellationSignal();
                signal.setRemote(remoteSignal);
            }
            ParcelFileDescriptor parcelFileDescriptor = this.mContentProvider.openFile(this.mPackageName, url, mode, remoteSignal, null);
            return parcelFileDescriptor;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final AssetFileDescriptor $$robo$$android_content_ContentProviderClient$openAssetFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        return this.openAssetFile(url, mode, null);
    }

    private final AssetFileDescriptor $$robo$$android_content_ContentProviderClient$openAssetFile(Uri url, String mode, CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(mode, "mode");
        this.beforeRemote();
        try {
            ICancellationSignal remoteSignal = null;
            if (signal != null) {
                signal.throwIfCanceled();
                remoteSignal = this.mContentProvider.createCancellationSignal();
                signal.setRemote(remoteSignal);
            }
            AssetFileDescriptor assetFileDescriptor = this.mContentProvider.openAssetFile(this.mPackageName, url, mode, remoteSignal);
            return assetFileDescriptor;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final AssetFileDescriptor $$robo$$android_content_ContentProviderClient$openTypedAssetFileDescriptor(Uri uri, String mimeType, Bundle opts) throws RemoteException, FileNotFoundException {
        return this.openTypedAssetFileDescriptor(uri, mimeType, opts, null);
    }

    private final AssetFileDescriptor $$robo$$android_content_ContentProviderClient$openTypedAssetFileDescriptor(Uri uri, String mimeType, Bundle opts, CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Preconditions.checkNotNull(uri, "uri");
        Preconditions.checkNotNull(mimeType, "mimeType");
        this.beforeRemote();
        try {
            ICancellationSignal remoteSignal = null;
            if (signal != null) {
                signal.throwIfCanceled();
                remoteSignal = this.mContentProvider.createCancellationSignal();
                signal.setRemote(remoteSignal);
            }
            AssetFileDescriptor assetFileDescriptor = this.mContentProvider.openTypedAssetFile(this.mPackageName, uri, mimeType, opts, remoteSignal);
            return assetFileDescriptor;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final ContentProviderResult[] $$robo$$android_content_ContentProviderClient$applyBatch(ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        Preconditions.checkNotNull(operations, "operations");
        this.beforeRemote();
        try {
            ContentProviderResult[] contentProviderResultArray = this.mContentProvider.applyBatch(this.mPackageName, operations);
            return contentProviderResultArray;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final Bundle $$robo$$android_content_ContentProviderClient$call(String method, String arg, Bundle extras) throws RemoteException {
        Preconditions.checkNotNull(method, "method");
        this.beforeRemote();
        try {
            Bundle bundle = this.mContentProvider.call(this.mPackageName, method, arg, extras);
            return bundle;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    private final void $$robo$$android_content_ContentProviderClient$close() {
        this.closeInternal();
    }

    @Deprecated
    private final boolean $$robo$$android_content_ContentProviderClient$release() {
        return this.closeInternal();
    }

    private final boolean $$robo$$android_content_ContentProviderClient$closeInternal() {
        this.mCloseGuard.close();
        if (this.mClosed.compareAndSet(false, true)) {
            this.setDetectNotResponding(0L);
            if (this.mStable) {
                return this.mContentResolver.releaseProvider(this.mContentProvider);
            }
            return this.mContentResolver.releaseUnstableProvider(this.mContentProvider);
        }
        return false;
    }

    private final void $$robo$$android_content_ContentProviderClient$finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final ContentProvider $$robo$$android_content_ContentProviderClient$getLocalContentProvider() {
        return ContentProvider.coerceToLocalContentProvider(this.mContentProvider);
    }

    private static final void $$robo$$android_content_ContentProviderClient$releaseQuietly(ContentProviderClient client) {
        if (client != null) {
            try {
                client.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void __constructor__(ContentResolver contentResolver, IContentProvider iContentProvider, boolean bl) {
        this.$$robo$$android_content_ContentProviderClient$__constructor__(contentResolver, iContentProvider, bl);
    }

    public ContentProviderClient(ContentResolver contentResolver, IContentProvider iContentProvider, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentProviderClient$__constructor__(android.content.ContentResolver android.content.IContentProvider boolean ), 0, this, contentResolver, iContentProvider, bl);
    }

    public void setDetectNotResponding(long l) {
        InvokeDynamicSupport.bootstrap("setDetectNotResponding", $$robo$$android_content_ContentProviderClient$setDetectNotResponding(long ), 0, this, l);
    }

    private void beforeRemote() {
        InvokeDynamicSupport.bootstrap("beforeRemote", $$robo$$android_content_ContentProviderClient$beforeRemote(), 0, this);
    }

    private void afterRemote() {
        InvokeDynamicSupport.bootstrap("afterRemote", $$robo$$android_content_ContentProviderClient$afterRemote(), 0, this);
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_content_ContentProviderClient$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String ), 0, this, uri, stringArray, string2, stringArray2, string3);
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3, CancellationSignal cancellationSignal) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_content_ContentProviderClient$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String android.os.CancellationSignal ), 0, this, uri, stringArray, string2, stringArray2, string3, cancellationSignal);
    }

    public Cursor query(Uri uri, String[] stringArray, Bundle bundle, CancellationSignal cancellationSignal) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_content_ContentProviderClient$query(android.net.Uri java.lang.String[] android.os.Bundle android.os.CancellationSignal ), 0, this, uri, stringArray, bundle, cancellationSignal);
    }

    public String getType(Uri uri) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_content_ContentProviderClient$getType(android.net.Uri ), 0, this, uri);
    }

    public String[] getStreamTypes(Uri uri, String string2) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getStreamTypes", $$robo$$android_content_ContentProviderClient$getStreamTypes(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public Uri canonicalize(Uri uri) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("canonicalize", $$robo$$android_content_ContentProviderClient$canonicalize(android.net.Uri ), 0, this, uri);
    }

    public Uri uncanonicalize(Uri uri) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("uncanonicalize", $$robo$$android_content_ContentProviderClient$uncanonicalize(android.net.Uri ), 0, this, uri);
    }

    public boolean refresh(Uri uri, Bundle bundle, CancellationSignal cancellationSignal) throws RemoteException {
        return (boolean)InvokeDynamicSupport.bootstrap("refresh", $$robo$$android_content_ContentProviderClient$refresh(android.net.Uri android.os.Bundle android.os.CancellationSignal ), 0, this, uri, bundle, cancellationSignal);
    }

    public Uri insert(Uri uri, ContentValues contentValues) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("insert", $$robo$$android_content_ContentProviderClient$insert(android.net.Uri android.content.ContentValues ), 0, this, uri, contentValues);
    }

    public int bulkInsert(Uri uri, ContentValues[] contentValuesArray) throws RemoteException {
        return (int)InvokeDynamicSupport.bootstrap("bulkInsert", $$robo$$android_content_ContentProviderClient$bulkInsert(android.net.Uri android.content.ContentValues[] ), 0, this, uri, contentValuesArray);
    }

    public int delete(Uri uri, String string2, String[] stringArray) throws RemoteException {
        return (int)InvokeDynamicSupport.bootstrap("delete", $$robo$$android_content_ContentProviderClient$delete(android.net.Uri java.lang.String java.lang.String[] ), 0, this, uri, string2, stringArray);
    }

    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) throws RemoteException {
        return (int)InvokeDynamicSupport.bootstrap("update", $$robo$$android_content_ContentProviderClient$update(android.net.Uri android.content.ContentValues java.lang.String java.lang.String[] ), 0, this, uri, contentValues, string2, stringArray);
    }

    public ParcelFileDescriptor openFile(Uri uri, String string2) throws RemoteException, FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openFile", $$robo$$android_content_ContentProviderClient$openFile(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public ParcelFileDescriptor openFile(Uri uri, String string2, CancellationSignal cancellationSignal) throws RemoteException, FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openFile", $$robo$$android_content_ContentProviderClient$openFile(android.net.Uri java.lang.String android.os.CancellationSignal ), 0, this, uri, string2, cancellationSignal);
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String string2) throws RemoteException, FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openAssetFile", $$robo$$android_content_ContentProviderClient$openAssetFile(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String string2, CancellationSignal cancellationSignal) throws RemoteException, FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openAssetFile", $$robo$$android_content_ContentProviderClient$openAssetFile(android.net.Uri java.lang.String android.os.CancellationSignal ), 0, this, uri, string2, cancellationSignal);
    }

    public AssetFileDescriptor openTypedAssetFileDescriptor(Uri uri, String string2, Bundle bundle) throws RemoteException, FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openTypedAssetFileDescriptor", $$robo$$android_content_ContentProviderClient$openTypedAssetFileDescriptor(android.net.Uri java.lang.String android.os.Bundle ), 0, this, uri, string2, bundle);
    }

    public AssetFileDescriptor openTypedAssetFileDescriptor(Uri uri, String string2, Bundle bundle, CancellationSignal cancellationSignal) throws RemoteException, FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openTypedAssetFileDescriptor", $$robo$$android_content_ContentProviderClient$openTypedAssetFileDescriptor(android.net.Uri java.lang.String android.os.Bundle android.os.CancellationSignal ), 0, this, uri, string2, bundle, cancellationSignal);
    }

    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> arrayList) throws RemoteException, OperationApplicationException {
        return InvokeDynamicSupport.bootstrap("applyBatch", $$robo$$android_content_ContentProviderClient$applyBatch(java.util.ArrayList<android.content.ContentProviderOperation> ), 0, this, arrayList);
    }

    public Bundle call(String string2, String string3, Bundle bundle) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("call", $$robo$$android_content_ContentProviderClient$call(java.lang.String java.lang.String android.os.Bundle ), 0, this, string2, string3, bundle);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_content_ContentProviderClient$close(), 0, this);
    }

    @Deprecated
    public boolean release() {
        return (boolean)InvokeDynamicSupport.bootstrap("release", $$robo$$android_content_ContentProviderClient$release(), 0, this);
    }

    private boolean closeInternal() {
        return (boolean)InvokeDynamicSupport.bootstrap("closeInternal", $$robo$$android_content_ContentProviderClient$closeInternal(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_content_ContentProviderClient$finalize(), 0, this);
    }

    public ContentProvider getLocalContentProvider() {
        return InvokeDynamicSupport.bootstrap("getLocalContentProvider", $$robo$$android_content_ContentProviderClient$getLocalContentProvider(), 0, this);
    }

    public static void releaseQuietly(ContentProviderClient contentProviderClient) {
        InvokeDynamicSupport.bootstrapStatic("releaseQuietly", $$robo$$android_content_ContentProviderClient$releaseQuietly(android.content.ContentProviderClient ), 0, (ContentProviderClient)contentProviderClient);
    }

    public /* synthetic */ ContentProviderClient() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContentProviderClient)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class CursorWrapperInner
    extends CrossProcessCursorWrapper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CloseGuard mCloseGuard;
        /* synthetic */ ContentProviderClient this$0;

        private void $$robo$$android_content_ContentProviderClient_CursorWrapperInner$__constructor__(ContentProviderClient contentProviderClient, Cursor cursor) {
            this.mCloseGuard = CloseGuard.get();
            this.mCloseGuard.open("close");
        }

        private final void $$robo$$android_content_ContentProviderClient_CursorWrapperInner$close() {
            this.mCloseGuard.close();
            super.close();
        }

        private final void $$robo$$android_content_ContentProviderClient_CursorWrapperInner$finalize() throws Throwable {
            try {
                if (this.mCloseGuard != null) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private void __constructor__(ContentProviderClient contentProviderClient, Cursor cursor) {
            this.$$robo$$android_content_ContentProviderClient_CursorWrapperInner$__constructor__(contentProviderClient, cursor);
        }

        CursorWrapperInner(ContentProviderClient contentProviderClient, Cursor cursor) {
            this.this$0 = contentProviderClient;
            super(cursor);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentProviderClient_CursorWrapperInner$__constructor__(android.content.ContentProviderClient android.database.Cursor ), 0, this, contentProviderClient, cursor);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_content_ContentProviderClient_CursorWrapperInner$close(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_content_ContentProviderClient_CursorWrapperInner$finalize(), 0, this);
        }

        public /* synthetic */ CursorWrapperInner() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CursorWrapperInner)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class NotRespondingRunnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ContentProviderClient this$0;

        private void $$robo$$android_content_ContentProviderClient_NotRespondingRunnable$__constructor__(ContentProviderClient contentProviderClient) {
        }

        private final void $$robo$$android_content_ContentProviderClient_NotRespondingRunnable$run() {
            Log.w("ContentProviderClient", "Detected provider not responding: " + this.this$0.mContentProvider);
            this.this$0.mContentResolver.appNotRespondingViaProvider(this.this$0.mContentProvider);
        }

        private /* synthetic */ void $$robo$$android_content_ContentProviderClient_NotRespondingRunnable$__constructor__(ContentProviderClient x0, 1 x1) {
        }

        private void __constructor__(ContentProviderClient contentProviderClient) {
            this.$$robo$$android_content_ContentProviderClient_NotRespondingRunnable$__constructor__(contentProviderClient);
        }

        private NotRespondingRunnable(ContentProviderClient contentProviderClient) {
            this.this$0 = contentProviderClient;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentProviderClient_NotRespondingRunnable$__constructor__(android.content.ContentProviderClient ), 0, this, contentProviderClient);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_content_ContentProviderClient_NotRespondingRunnable$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(ContentProviderClient contentProviderClient, 1 var2_2) {
            this.$$robo$$android_content_ContentProviderClient_NotRespondingRunnable$__constructor__(contentProviderClient, var2_2);
        }

        public /* synthetic */ NotRespondingRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotRespondingRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

