/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.Context;
import android.content.IRestrictionsManager;
import android.content.Intent;
import android.content.RestrictionEntry;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class RestrictionsManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RestrictionsManager";
    public static String ACTION_PERMISSION_RESPONSE_RECEIVED = "android.content.action.PERMISSION_RESPONSE_RECEIVED";
    public static String ACTION_REQUEST_PERMISSION = "android.content.action.REQUEST_PERMISSION";
    public static String ACTION_REQUEST_LOCAL_APPROVAL = "android.content.action.REQUEST_LOCAL_APPROVAL";
    public static String EXTRA_PACKAGE_NAME = "android.content.extra.PACKAGE_NAME";
    public static String EXTRA_REQUEST_TYPE = "android.content.extra.REQUEST_TYPE";
    public static String EXTRA_REQUEST_ID = "android.content.extra.REQUEST_ID";
    public static String EXTRA_REQUEST_BUNDLE = "android.content.extra.REQUEST_BUNDLE";
    public static String EXTRA_RESPONSE_BUNDLE = "android.content.extra.RESPONSE_BUNDLE";
    public static String REQUEST_TYPE_APPROVAL = "android.request.type.approval";
    public static String REQUEST_KEY_ID = "android.request.id";
    public static String REQUEST_KEY_DATA = "android.request.data";
    public static String REQUEST_KEY_TITLE = "android.request.title";
    public static String REQUEST_KEY_MESSAGE = "android.request.mesg";
    public static String REQUEST_KEY_ICON = "android.request.icon";
    public static String REQUEST_KEY_APPROVE_LABEL = "android.request.approve_label";
    public static String REQUEST_KEY_DENY_LABEL = "android.request.deny_label";
    public static String REQUEST_KEY_NEW_REQUEST = "android.request.new_request";
    public static String RESPONSE_KEY_RESULT = "android.response.result";
    public static int RESULT_APPROVED = 1;
    public static int RESULT_DENIED = 2;
    public static int RESULT_NO_RESPONSE = 3;
    public static int RESULT_UNKNOWN_REQUEST = 4;
    public static int RESULT_ERROR = 5;
    public static int RESULT_ERROR_BAD_REQUEST = 1;
    public static int RESULT_ERROR_NETWORK = 2;
    public static int RESULT_ERROR_INTERNAL = 3;
    public static String RESPONSE_KEY_ERROR_CODE = "android.response.errorcode";
    public static String RESPONSE_KEY_MESSAGE = "android.response.msg";
    public static String RESPONSE_KEY_RESPONSE_TIMESTAMP = "android.response.timestamp";
    public static String META_DATA_APP_RESTRICTIONS = "android.content.APP_RESTRICTIONS";
    private static String TAG_RESTRICTION = "restriction";
    private Context mContext;
    private IRestrictionsManager mService;

    private void $$robo$$android_content_RestrictionsManager$__constructor__(Context context, IRestrictionsManager service) {
        this.mContext = context;
        this.mService = service;
    }

    private final Bundle $$robo$$android_content_RestrictionsManager$getApplicationRestrictions() {
        try {
            if (this.mService != null) {
                return this.mService.getApplicationRestrictions(this.mContext.getPackageName());
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return null;
    }

    private final boolean $$robo$$android_content_RestrictionsManager$hasRestrictionsProvider() {
        try {
            if (this.mService != null) {
                return this.mService.hasRestrictionsProvider();
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return false;
    }

    private final void $$robo$$android_content_RestrictionsManager$requestPermission(String requestType, String requestId, PersistableBundle request) {
        if (requestType == null) {
            throw new NullPointerException("requestType cannot be null");
        }
        if (requestId == null) {
            throw new NullPointerException("requestId cannot be null");
        }
        if (request == null) {
            throw new NullPointerException("request cannot be null");
        }
        try {
            if (this.mService != null) {
                this.mService.requestPermission(this.mContext.getPackageName(), requestType, requestId, request);
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final Intent $$robo$$android_content_RestrictionsManager$createLocalApprovalIntent() {
        try {
            if (this.mService != null) {
                return this.mService.createLocalApprovalIntent();
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return null;
    }

    private final void $$robo$$android_content_RestrictionsManager$notifyPermissionResponse(String packageName, PersistableBundle response) {
        if (packageName == null) {
            throw new NullPointerException("packageName cannot be null");
        }
        if (response == null) {
            throw new NullPointerException("request cannot be null");
        }
        if (!response.containsKey("android.request.id")) {
            throw new IllegalArgumentException("REQUEST_KEY_ID must be specified");
        }
        if (!response.containsKey("android.response.result")) {
            throw new IllegalArgumentException("RESPONSE_KEY_RESULT must be specified");
        }
        try {
            if (this.mService != null) {
                this.mService.notifyPermissionResponse(packageName, response);
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<RestrictionEntry> $$robo$$android_content_RestrictionsManager$getManifestRestrictions(String packageName) {
        ApplicationInfo appInfo = null;
        try {
            appInfo = this.mContext.getPackageManager().getApplicationInfo(packageName, 128);
        }
        catch (PackageManager.NameNotFoundException pnfe) {
            throw new IllegalArgumentException("No such package " + packageName);
        }
        if (appInfo == null || !appInfo.metaData.containsKey("android.content.APP_RESTRICTIONS")) {
            return null;
        }
        XmlResourceParser xml2 = appInfo.loadXmlMetaData(this.mContext.getPackageManager(), "android.content.APP_RESTRICTIONS");
        return this.loadManifestRestrictions(packageName, xml2);
    }

    private final List<RestrictionEntry> $$robo$$android_content_RestrictionsManager$loadManifestRestrictions(String packageName, XmlResourceParser xml2) {
        Context appContext;
        try {
            appContext = this.mContext.createPackageContext(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nnfe) {
            return null;
        }
        ArrayList<RestrictionEntry> restrictions = new ArrayList<RestrictionEntry>();
        try {
            int tagType = xml2.next();
            while (tagType != 1) {
                RestrictionEntry restriction;
                if (tagType == 2 && (restriction = this.loadRestrictionElement(appContext, xml2)) != null) {
                    restrictions.add(restriction);
                }
                tagType = xml2.next();
            }
        }
        catch (XmlPullParserException e) {
            Log.w("RestrictionsManager", "Reading restriction metadata for " + packageName, e);
            return null;
        }
        catch (IOException e) {
            Log.w("RestrictionsManager", "Reading restriction metadata for " + packageName, e);
            return null;
        }
        return restrictions;
    }

    private final RestrictionEntry $$robo$$android_content_RestrictionsManager$loadRestrictionElement(Context appContext, XmlResourceParser xml2) throws IOException, XmlPullParserException {
        AttributeSet attrSet;
        if (xml2.getName().equals("restriction") && (attrSet = Xml.asAttributeSet(xml2)) != null) {
            TypedArray a = appContext.obtainStyledAttributes(attrSet, R.styleable.RestrictionEntry);
            return this.loadRestriction(appContext, a, xml2);
        }
        return null;
    }

    private final RestrictionEntry $$robo$$android_content_RestrictionsManager$loadRestriction(Context appContext, TypedArray a, XmlResourceParser xml2) throws IOException, XmlPullParserException {
        String key = a.getString(3);
        int restrictionType = a.getInt(6, -1);
        String title = a.getString(2);
        String description = a.getString(0);
        int entries = a.getResourceId(1, 0);
        int entryValues = a.getResourceId(5, 0);
        if (restrictionType == -1) {
            Log.w("RestrictionsManager", "restrictionType cannot be omitted");
            return null;
        }
        if (key == null) {
            Log.w("RestrictionsManager", "key cannot be omitted");
            return null;
        }
        RestrictionEntry restriction = new RestrictionEntry(restrictionType, key);
        restriction.setTitle(title);
        restriction.setDescription(description);
        if (entries != 0) {
            restriction.setChoiceEntries(appContext, entries);
        }
        if (entryValues != 0) {
            restriction.setChoiceValues(appContext, entryValues);
        }
        switch (restrictionType) {
            case 0: 
            case 2: 
            case 6: {
                restriction.setSelectedString(a.getString(4));
                break;
            }
            case 5: {
                restriction.setIntValue(a.getInt(4, 0));
                break;
            }
            case 4: {
                int resId = a.getResourceId(4, 0);
                if (resId == 0) break;
                restriction.setAllSelectedStrings(appContext.getResources().getStringArray(resId));
                break;
            }
            case 1: {
                restriction.setSelectedState(a.getBoolean(4, false));
                break;
            }
            case 7: 
            case 8: {
                int outerDepth = xml2.getDepth();
                ArrayList<RestrictionEntry> restrictionEntries = new ArrayList<RestrictionEntry>();
                while (XmlUtils.nextElementWithin(xml2, outerDepth)) {
                    RestrictionEntry childEntry = this.loadRestrictionElement(appContext, xml2);
                    if (childEntry == null) {
                        Log.w("RestrictionsManager", "Child entry cannot be loaded for bundle restriction " + key);
                        continue;
                    }
                    restrictionEntries.add(childEntry);
                    if (restrictionType != 8 || childEntry.getType() == 7) continue;
                    Log.w("RestrictionsManager", "bundle_array " + key + " can only contain entries of type bundle");
                }
                restriction.setRestrictions(restrictionEntries.toArray(new RestrictionEntry[restrictionEntries.size()]));
                break;
            }
            default: {
                Log.w("RestrictionsManager", "Unknown restriction type " + restrictionType);
            }
        }
        return restriction;
    }

    private static final Bundle $$robo$$android_content_RestrictionsManager$convertRestrictionsToBundle(List<RestrictionEntry> entries) {
        Bundle bundle = new Bundle();
        for (RestrictionEntry entry : entries) {
            RestrictionsManager.addRestrictionToBundle(bundle, entry);
        }
        return bundle;
    }

    private static final Bundle $$robo$$android_content_RestrictionsManager$addRestrictionToBundle(Bundle bundle, RestrictionEntry entry) {
        switch (entry.getType()) {
            case 1: {
                bundle.putBoolean(entry.getKey(), entry.getSelectedState());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                bundle.putStringArray(entry.getKey(), entry.getAllSelectedStrings());
                break;
            }
            case 5: {
                bundle.putInt(entry.getKey(), entry.getIntValue());
                break;
            }
            case 0: 
            case 6: {
                bundle.putString(entry.getKey(), entry.getSelectedString());
                break;
            }
            case 7: {
                RestrictionEntry[] restrictions = entry.getRestrictions();
                Bundle childBundle = RestrictionsManager.convertRestrictionsToBundle(Arrays.asList(restrictions));
                bundle.putBundle(entry.getKey(), childBundle);
                break;
            }
            case 8: {
                RestrictionEntry[] bundleRestrictionArray = entry.getRestrictions();
                Parcelable[] bundleArray = new Bundle[bundleRestrictionArray.length];
                for (int i = 0; i < bundleRestrictionArray.length; ++i) {
                    RestrictionEntry[] bundleRestrictions = bundleRestrictionArray[i].getRestrictions();
                    if (bundleRestrictions == null) {
                        Log.w("RestrictionsManager", "addRestrictionToBundle: Non-bundle entry found in bundle array");
                        bundleArray[i] = new Bundle();
                        continue;
                    }
                    bundleArray[i] = RestrictionsManager.convertRestrictionsToBundle(Arrays.asList(bundleRestrictions));
                }
                bundle.putParcelableArray(entry.getKey(), bundleArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported restrictionEntry type: " + entry.getType());
            }
        }
        return bundle;
    }

    private void __constructor__(Context context, IRestrictionsManager iRestrictionsManager) {
        this.$$robo$$android_content_RestrictionsManager$__constructor__(context, iRestrictionsManager);
    }

    public RestrictionsManager(Context context, IRestrictionsManager iRestrictionsManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_RestrictionsManager$__constructor__(android.content.Context android.content.IRestrictionsManager ), 0, this, context, iRestrictionsManager);
    }

    public Bundle getApplicationRestrictions() {
        return InvokeDynamicSupport.bootstrap("getApplicationRestrictions", $$robo$$android_content_RestrictionsManager$getApplicationRestrictions(), 0, this);
    }

    public boolean hasRestrictionsProvider() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasRestrictionsProvider", $$robo$$android_content_RestrictionsManager$hasRestrictionsProvider(), 0, this);
    }

    public void requestPermission(String string2, String string3, PersistableBundle persistableBundle) {
        InvokeDynamicSupport.bootstrap("requestPermission", $$robo$$android_content_RestrictionsManager$requestPermission(java.lang.String java.lang.String android.os.PersistableBundle ), 0, this, string2, string3, persistableBundle);
    }

    public Intent createLocalApprovalIntent() {
        return InvokeDynamicSupport.bootstrap("createLocalApprovalIntent", $$robo$$android_content_RestrictionsManager$createLocalApprovalIntent(), 0, this);
    }

    public void notifyPermissionResponse(String string2, PersistableBundle persistableBundle) {
        InvokeDynamicSupport.bootstrap("notifyPermissionResponse", $$robo$$android_content_RestrictionsManager$notifyPermissionResponse(java.lang.String android.os.PersistableBundle ), 0, this, string2, persistableBundle);
    }

    public List<RestrictionEntry> getManifestRestrictions(String string2) {
        return InvokeDynamicSupport.bootstrap("getManifestRestrictions", $$robo$$android_content_RestrictionsManager$getManifestRestrictions(java.lang.String ), 0, this, string2);
    }

    private List<RestrictionEntry> loadManifestRestrictions(String string2, XmlResourceParser xmlResourceParser) {
        return InvokeDynamicSupport.bootstrap("loadManifestRestrictions", $$robo$$android_content_RestrictionsManager$loadManifestRestrictions(java.lang.String android.content.res.XmlResourceParser ), 0, this, string2, xmlResourceParser);
    }

    private RestrictionEntry loadRestrictionElement(Context context, XmlResourceParser xmlResourceParser) throws IOException, XmlPullParserException {
        return InvokeDynamicSupport.bootstrap("loadRestrictionElement", $$robo$$android_content_RestrictionsManager$loadRestrictionElement(android.content.Context android.content.res.XmlResourceParser ), 0, this, context, xmlResourceParser);
    }

    private RestrictionEntry loadRestriction(Context context, TypedArray typedArray, XmlResourceParser xmlResourceParser) throws IOException, XmlPullParserException {
        return InvokeDynamicSupport.bootstrap("loadRestriction", $$robo$$android_content_RestrictionsManager$loadRestriction(android.content.Context android.content.res.TypedArray android.content.res.XmlResourceParser ), 0, this, context, typedArray, xmlResourceParser);
    }

    public static Bundle convertRestrictionsToBundle(List<RestrictionEntry> list) {
        return InvokeDynamicSupport.bootstrapStatic("convertRestrictionsToBundle", $$robo$$android_content_RestrictionsManager$convertRestrictionsToBundle(java.util.List<android.content.RestrictionEntry> ), 0, list);
    }

    private static Bundle addRestrictionToBundle(Bundle bundle, RestrictionEntry restrictionEntry) {
        return InvokeDynamicSupport.bootstrapStatic("addRestrictionToBundle", $$robo$$android_content_RestrictionsManager$addRestrictionToBundle(android.os.Bundle android.content.RestrictionEntry ), 0, (Bundle)bundle, (RestrictionEntry)restrictionEntry);
    }

    public /* synthetic */ RestrictionsManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RestrictionsManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

