/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.SystemApi;
import android.content.pm.InstantAppIntentFilter;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class InstantAppResolveInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String SHA_ALGORITHM = "SHA-256";
    private static byte[] EMPTY_DIGEST;
    private InstantAppDigest mDigest;
    private String mPackageName;
    private List<InstantAppIntentFilter> mFilters;
    private long mVersionCode;
    private Bundle mExtras;
    private boolean mShouldLetInstallerDecide;
    public static Parcelable.Creator<InstantAppResolveInfo> CREATOR;

    private void $$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(InstantAppDigest digest, String packageName, List<InstantAppIntentFilter> filters, int versionCode) {
    }

    private void $$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(InstantAppDigest digest, String packageName, List<InstantAppIntentFilter> filters, long versionCode, Bundle extras) {
    }

    private void $$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(String hostName, String packageName, List<InstantAppIntentFilter> filters) {
    }

    private void $$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(Bundle extras) {
    }

    private void $$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(InstantAppDigest digest, String packageName, List<InstantAppIntentFilter> filters, long versionCode, Bundle extras, boolean shouldLetInstallerDecide) {
        if (packageName == null && filters != null && filters.size() != 0 || packageName != null && (filters == null || filters.size() == 0)) {
            throw new IllegalArgumentException();
        }
        this.mDigest = digest;
        if (filters != null) {
            this.mFilters = new ArrayList<InstantAppIntentFilter>(filters.size());
            this.mFilters.addAll(filters);
        } else {
            this.mFilters = null;
        }
        this.mPackageName = packageName;
        this.mVersionCode = versionCode;
        this.mExtras = extras;
        this.mShouldLetInstallerDecide = shouldLetInstallerDecide;
    }

    private void $$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(Parcel in) {
        this.mShouldLetInstallerDecide = in.readBoolean();
        this.mExtras = in.readBundle();
        if (this.mShouldLetInstallerDecide) {
            this.mDigest = InstantAppDigest.UNDEFINED;
            this.mPackageName = null;
            this.mFilters = Collections.emptyList();
            this.mVersionCode = -1L;
        } else {
            this.mDigest = (InstantAppDigest)in.readParcelable(null);
            this.mPackageName = in.readString();
            this.mFilters = new ArrayList<InstantAppIntentFilter>();
            in.readList(this.mFilters, null);
            this.mVersionCode = in.readLong();
        }
    }

    private final boolean $$robo$$android_content_pm_InstantAppResolveInfo$shouldLetInstallerDecide() {
        return this.mShouldLetInstallerDecide;
    }

    private final byte[] $$robo$$android_content_pm_InstantAppResolveInfo$getDigestBytes() {
        return this.mDigest.mDigestBytes.length > 0 ? this.mDigest.getDigestBytes()[0] : EMPTY_DIGEST;
    }

    private final int $$robo$$android_content_pm_InstantAppResolveInfo$getDigestPrefix() {
        return this.mDigest.getDigestPrefix()[0];
    }

    private final String $$robo$$android_content_pm_InstantAppResolveInfo$getPackageName() {
        return this.mPackageName;
    }

    private final List<InstantAppIntentFilter> $$robo$$android_content_pm_InstantAppResolveInfo$getIntentFilters() {
        return this.mFilters;
    }

    @Deprecated
    private final int $$robo$$android_content_pm_InstantAppResolveInfo$getVersionCode() {
        return (int)(this.mVersionCode & 0xFFFFFFFFFFFFFFFFL);
    }

    private final long $$robo$$android_content_pm_InstantAppResolveInfo$getLongVersionCode() {
        return this.mVersionCode;
    }

    private final Bundle $$robo$$android_content_pm_InstantAppResolveInfo$getExtras() {
        return this.mExtras;
    }

    private final int $$robo$$android_content_pm_InstantAppResolveInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_pm_InstantAppResolveInfo$writeToParcel(Parcel out, int flags) {
        out.writeBoolean(this.mShouldLetInstallerDecide);
        out.writeBundle(this.mExtras);
        if (this.mShouldLetInstallerDecide) {
            return;
        }
        out.writeParcelable(this.mDigest, flags);
        out.writeString(this.mPackageName);
        out.writeList(this.mFilters);
        out.writeLong(this.mVersionCode);
    }

    static void __staticInitializer__() {
        EMPTY_DIGEST = new byte[0];
        CREATOR = new Parcelable.Creator<InstantAppResolveInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_pm_InstantAppResolveInfo_1$__constructor__() {
            }

            private final InstantAppResolveInfo $$robo$$android_content_pm_InstantAppResolveInfo_1$createFromParcel(Parcel in) {
                return new InstantAppResolveInfo(in);
            }

            private final InstantAppResolveInfo[] $$robo$$android_content_pm_InstantAppResolveInfo_1$newArray(int size) {
                return new InstantAppResolveInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_pm_InstantAppResolveInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_InstantAppResolveInfo_1$__constructor__(), 0, this);
            }

            @Override
            public InstantAppResolveInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_InstantAppResolveInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public InstantAppResolveInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_InstantAppResolveInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(InstantAppDigest instantAppDigest, String string2, List<InstantAppIntentFilter> list, int n) {
        this.$$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(instantAppDigest, string2, list, n);
    }

    public InstantAppResolveInfo(InstantAppDigest instantAppDigest, String string2, List<InstantAppIntentFilter> list, int n) {
        this(instantAppDigest, string2, list, n, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(android.content.pm.InstantAppResolveInfo$InstantAppDigest java.lang.String java.util.List<android.content.pm.InstantAppIntentFilter> int ), 0, this, instantAppDigest, string2, list, n);
    }

    private void __constructor__(InstantAppDigest instantAppDigest, String string2, List<InstantAppIntentFilter> list, long l, Bundle bundle) {
        this.$$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(instantAppDigest, string2, list, l, bundle);
    }

    public InstantAppResolveInfo(InstantAppDigest instantAppDigest, String string2, List<InstantAppIntentFilter> list, long l, Bundle bundle) {
        this(instantAppDigest, string2, list, l, bundle, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(android.content.pm.InstantAppResolveInfo$InstantAppDigest java.lang.String java.util.List<android.content.pm.InstantAppIntentFilter> long android.os.Bundle ), 0, this, instantAppDigest, string2, list, l, bundle);
    }

    private void __constructor__(String string2, String string3, List<InstantAppIntentFilter> list) {
        this.$$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(string2, string3, list);
    }

    public InstantAppResolveInfo(String string2, String string3, List<InstantAppIntentFilter> list) {
        this(new InstantAppDigest(string2), string3, list, -1L, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(java.lang.String java.lang.String java.util.List<android.content.pm.InstantAppIntentFilter> ), 0, this, string2, string3, list);
    }

    private void __constructor__(Bundle bundle) {
        this.$$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(bundle);
    }

    public InstantAppResolveInfo(Bundle bundle) {
        this(InstantAppDigest.UNDEFINED, null, null, -1L, bundle, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(android.os.Bundle ), 0, this, bundle);
    }

    private void __constructor__(InstantAppDigest instantAppDigest, String string2, List<InstantAppIntentFilter> list, long l, Bundle bundle, boolean bl) {
        this.$$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(instantAppDigest, string2, list, l, bundle, bl);
    }

    private InstantAppResolveInfo(InstantAppDigest instantAppDigest, String string2, List<InstantAppIntentFilter> list, long l, Bundle bundle, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(android.content.pm.InstantAppResolveInfo$InstantAppDigest java.lang.String java.util.List<android.content.pm.InstantAppIntentFilter> long android.os.Bundle boolean ), 0, this, instantAppDigest, string2, list, l, bundle, bl);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(parcel);
    }

    InstantAppResolveInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_InstantAppResolveInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public boolean shouldLetInstallerDecide() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldLetInstallerDecide", $$robo$$android_content_pm_InstantAppResolveInfo$shouldLetInstallerDecide(), 0, this);
    }

    public byte[] getDigestBytes() {
        return InvokeDynamicSupport.bootstrap("getDigestBytes", $$robo$$android_content_pm_InstantAppResolveInfo$getDigestBytes(), 0, this);
    }

    public int getDigestPrefix() {
        return (int)InvokeDynamicSupport.bootstrap("getDigestPrefix", $$robo$$android_content_pm_InstantAppResolveInfo$getDigestPrefix(), 0, this);
    }

    public String getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_content_pm_InstantAppResolveInfo$getPackageName(), 0, this);
    }

    public List<InstantAppIntentFilter> getIntentFilters() {
        return InvokeDynamicSupport.bootstrap("getIntentFilters", $$robo$$android_content_pm_InstantAppResolveInfo$getIntentFilters(), 0, this);
    }

    @Deprecated
    public int getVersionCode() {
        return (int)InvokeDynamicSupport.bootstrap("getVersionCode", $$robo$$android_content_pm_InstantAppResolveInfo$getVersionCode(), 0, this);
    }

    public long getLongVersionCode() {
        return (long)InvokeDynamicSupport.bootstrap("getLongVersionCode", $$robo$$android_content_pm_InstantAppResolveInfo$getLongVersionCode(), 0, this);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_content_pm_InstantAppResolveInfo$getExtras(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_InstantAppResolveInfo$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_InstantAppResolveInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(InstantAppResolveInfo.class);
    }

    public /* synthetic */ InstantAppResolveInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InstantAppResolveInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @SystemApi
    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class InstantAppDigest
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int DIGEST_MASK = -4096;
        public static InstantAppDigest UNDEFINED;
        private static Random sRandom;
        private byte[][] mDigestBytes;
        private int[] mDigestPrefix;
        private int[] mDigestPrefixSecure;
        public static Parcelable.Creator<InstantAppDigest> CREATOR;

        private void $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$__constructor__(String hostName) {
        }

        private void $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$__constructor__(String hostName, int maxDigests) {
            if (hostName == null) {
                throw new IllegalArgumentException();
            }
            this.mDigestBytes = InstantAppDigest.generateDigest(hostName.toLowerCase(Locale.ENGLISH), maxDigests);
            this.mDigestPrefix = new int[this.mDigestBytes.length];
            for (int i = 0; i < this.mDigestBytes.length; ++i) {
                this.mDigestPrefix[i] = ((this.mDigestBytes[i][0] & 0xFF) << 24 | (this.mDigestBytes[i][1] & 0xFF) << 16 | (this.mDigestBytes[i][2] & 0xFF) << 8 | (this.mDigestBytes[i][3] & 0xFF) << 0) & 0xFFFFF000;
            }
        }

        private void $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$__constructor__(byte[][] digestBytes, int[] prefix) {
            this.mDigestPrefix = prefix;
            this.mDigestBytes = digestBytes;
        }

        private static final byte[][] $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$generateDigest(String hostName, int maxDigests) {
            ArrayList<byte[]> digests = new ArrayList<byte[]>();
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                if (maxDigests <= 0) {
                    byte[] hostBytes = hostName.getBytes();
                    digests.add(digest.digest(hostBytes));
                } else {
                    int prevDot = hostName.lastIndexOf(46);
                    if ((prevDot = hostName.lastIndexOf(46, prevDot - 1)) < 0) {
                        digests.add(digest.digest(hostName.getBytes()));
                    } else {
                        byte[] hostBytes = hostName.substring(prevDot + 1, hostName.length()).getBytes();
                        digests.add(digest.digest(hostBytes));
                        for (int digestCount = 1; prevDot >= 0 && digestCount < maxDigests; ++digestCount) {
                            prevDot = hostName.lastIndexOf(46, prevDot - 1);
                            hostBytes = hostName.substring(prevDot + 1, hostName.length()).getBytes();
                            digests.add(digest.digest(hostBytes));
                        }
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("could not find digest algorithm");
            }
            return (byte[][])digests.toArray((T[])new byte[digests.size()][]);
        }

        private void $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$__constructor__(Parcel in) {
            int digestCount = in.readInt();
            if (digestCount == -1) {
                this.mDigestBytes = null;
            } else {
                this.mDigestBytes = new byte[digestCount][];
                for (int i = 0; i < digestCount; ++i) {
                    this.mDigestBytes[i] = in.createByteArray();
                }
            }
            this.mDigestPrefix = in.createIntArray();
            this.mDigestPrefixSecure = in.createIntArray();
        }

        private final byte[][] $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$getDigestBytes() {
            return this.mDigestBytes;
        }

        private final int[] $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$getDigestPrefix() {
            return this.mDigestPrefix;
        }

        private final int[] $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$getDigestPrefixSecure() {
            if (this == UNDEFINED) {
                return this.getDigestPrefix();
            }
            if (this.mDigestPrefixSecure == null) {
                int realSize = this.getDigestPrefix().length;
                int manufacturedSize = realSize + 10 + sRandom.nextInt(10);
                this.mDigestPrefixSecure = Arrays.copyOf(this.getDigestPrefix(), manufacturedSize);
                for (int i = realSize; i < manufacturedSize; ++i) {
                    this.mDigestPrefixSecure[i] = sRandom.nextInt() & 0xFFFFF000;
                }
                Arrays.sort(this.mDigestPrefixSecure);
            }
            return this.mDigestPrefixSecure;
        }

        private final int $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$describeContents() {
            return 0;
        }

        private final void $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$writeToParcel(Parcel out, int flags) {
            boolean isUndefined = this == UNDEFINED;
            out.writeBoolean(isUndefined);
            if (isUndefined) {
                return;
            }
            if (this.mDigestBytes == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(this.mDigestBytes.length);
                for (int i = 0; i < this.mDigestBytes.length; ++i) {
                    out.writeByteArray(this.mDigestBytes[i]);
                }
            }
            out.writeIntArray(this.mDigestPrefix);
            out.writeIntArray(this.mDigestPrefixSecure);
        }

        static void __staticInitializer__() {
            UNDEFINED = new InstantAppDigest(new byte[0][], new int[0]);
            sRandom = null;
            try {
                sRandom = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                sRandom = new Random();
            }
            CREATOR = new Parcelable.Creator<InstantAppDigest>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest_1$__constructor__() {
                }

                private final InstantAppDigest $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest_1$createFromParcel(Parcel in) {
                    if (in.readBoolean()) {
                        return UNDEFINED;
                    }
                    return new InstantAppDigest(in);
                }

                private final InstantAppDigest[] $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest_1$newArray(int size) {
                    return new InstantAppDigest[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest_1$__constructor__(), 0, this);
                }

                @Override
                public InstantAppDigest createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public InstantAppDigest[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$__constructor__(string2);
        }

        public InstantAppDigest(String string2) {
            this(string2, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$__constructor__(java.lang.String ), 0, this, string2);
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$__constructor__(string2, n);
        }

        public InstantAppDigest(String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        private void __constructor__(byte[][] byArray, int[] nArray) {
            this.$$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$__constructor__(byArray, nArray);
        }

        private InstantAppDigest(byte[][] byArray, int[] nArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$__constructor__(byte[][] int[] ), 0, this, byArray, nArray);
        }

        private static byte[][] generateDigest(String string2, int n) {
            return InvokeDynamicSupport.bootstrapStatic("generateDigest", $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$generateDigest(java.lang.String int ), 0, (String)string2, (int)n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$__constructor__(parcel);
        }

        InstantAppDigest(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public byte[][] getDigestBytes() {
            return InvokeDynamicSupport.bootstrap("getDigestBytes", $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$getDigestBytes(), 0, this);
        }

        public int[] getDigestPrefix() {
            return InvokeDynamicSupport.bootstrap("getDigestPrefix", $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$getDigestPrefix(), 0, this);
        }

        public int[] getDigestPrefixSecure() {
            return InvokeDynamicSupport.bootstrap("getDigestPrefixSecure", $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$getDigestPrefixSecure(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_InstantAppResolveInfo_InstantAppDigest$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(InstantAppDigest.class);
        }

        public /* synthetic */ InstantAppDigest() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InstantAppDigest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

