/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FallbackCategoryProvider;
import android.content.pm.FeatureGroupInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageBackwardCompatibility;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParserCacheHelper;
import android.content.pm.PackageUserState;
import android.content.pm.PathPermission;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.SELinuxUtil;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import android.content.pm.VerifierInfo;
import android.content.pm.split.DefaultSplitAssetLoader;
import android.content.pm.split.SplitAssetDependencyLoader;
import android.content.pm.split.SplitAssetLoader;
import android.content.pm.split.SplitDependencyLoader;
import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.os.Bundle;
import android.os.FileUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PatternMatcher;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Base64;
import android.util.ByteStringUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.PackageUtils;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TypedValue;
import android.util.apk.ApkSignatureVerifier;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.ClassLoaderFactory;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PackageParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG_JAR = false;
    private static boolean DEBUG_PARSER = false;
    private static boolean DEBUG_BACKUP = false;
    private static boolean LOG_PARSE_TIMINGS;
    private static int LOG_PARSE_TIMINGS_THRESHOLD_MS = 100;
    private static String PROPERTY_CHILD_PACKAGES_ENABLED = "persist.sys.child_packages_enabled";
    private static boolean MULTI_PACKAGE_APK_ENABLED;
    private static float DEFAULT_PRE_O_MAX_ASPECT_RATIO = 1.86f;
    public static String ANDROID_MANIFEST_FILENAME = "AndroidManifest.xml";
    private static String MNT_EXPAND = "/mnt/expand/";
    private static String TAG_MANIFEST = "manifest";
    private static String TAG_APPLICATION = "application";
    private static String TAG_PACKAGE_VERIFIER = "package-verifier";
    private static String TAG_OVERLAY = "overlay";
    private static String TAG_KEY_SETS = "key-sets";
    private static String TAG_PERMISSION_GROUP = "permission-group";
    private static String TAG_PERMISSION = "permission";
    private static String TAG_PERMISSION_TREE = "permission-tree";
    private static String TAG_USES_PERMISSION = "uses-permission";
    private static String TAG_USES_PERMISSION_SDK_M = "uses-permission-sdk-m";
    private static String TAG_USES_PERMISSION_SDK_23 = "uses-permission-sdk-23";
    private static String TAG_USES_CONFIGURATION = "uses-configuration";
    private static String TAG_USES_FEATURE = "uses-feature";
    private static String TAG_FEATURE_GROUP = "feature-group";
    private static String TAG_USES_SDK = "uses-sdk";
    private static String TAG_SUPPORT_SCREENS = "supports-screens";
    private static String TAG_PROTECTED_BROADCAST = "protected-broadcast";
    private static String TAG_INSTRUMENTATION = "instrumentation";
    private static String TAG_ORIGINAL_PACKAGE = "original-package";
    private static String TAG_ADOPT_PERMISSIONS = "adopt-permissions";
    private static String TAG_USES_GL_TEXTURE = "uses-gl-texture";
    private static String TAG_COMPATIBLE_SCREENS = "compatible-screens";
    private static String TAG_SUPPORTS_INPUT = "supports-input";
    private static String TAG_EAT_COMMENT = "eat-comment";
    private static String TAG_PACKAGE = "package";
    private static String TAG_RESTRICT_UPDATE = "restrict-update";
    private static String TAG_USES_SPLIT = "uses-split";
    private static String METADATA_MAX_ASPECT_RATIO = "android.max_aspect";
    private static int RECREATE_ON_CONFIG_CHANGES_MASK = 3;
    private static Set<String> CHILD_PACKAGE_TAGS;
    private static boolean LOG_UNSAFE_BROADCASTS = false;
    public static AtomicInteger sCachedPackageReadCount;
    private static Set<String> SAFE_BROADCASTS;
    public static String APK_FILE_EXTENSION = ".apk";
    public static NewPermissionInfo[] NEW_PERMISSIONS;
    public static SplitPermissionInfo[] SPLIT_PERMISSIONS;
    @Deprecated
    private String mArchiveSourcePath;
    private String[] mSeparateProcesses;
    private boolean mOnlyCoreApps;
    private DisplayMetrics mMetrics;
    private Callback mCallback;
    private File mCacheDir;
    private static int SDK_VERSION;
    private static String[] SDK_CODENAMES;
    private int mParseError;
    private static boolean sCompatibilityModeEnabled;
    private static int PARSE_DEFAULT_INSTALL_LOCATION = -1;
    private static int PARSE_DEFAULT_TARGET_SANDBOX = 1;
    private ParsePackageItemArgs mParseInstrumentationArgs;
    private static boolean RIGID_PARSER = false;
    private static String TAG = "PackageParser";
    public static int PARSE_MUST_BE_APK = 1;
    public static int PARSE_IGNORE_PROCESSES = 2;
    @Deprecated
    public static int PARSE_FORWARD_LOCK = 4;
    public static int PARSE_EXTERNAL_STORAGE = 8;
    public static int PARSE_IS_SYSTEM_DIR = 16;
    public static int PARSE_COLLECT_CERTIFICATES = 32;
    public static int PARSE_ENFORCE_CODE = 64;
    public static int PARSE_FORCE_SDK = 128;
    public static int PARSE_CHATTY = Integer.MIN_VALUE;
    private static Comparator<String> sSplitNameComparator;
    private static String ANDROID_RESOURCES = "http://schemas.android.com/apk/res/android";

    private void $$robo$$android_content_pm_PackageParser$__constructor__() {
        this.mParseError = 1;
        this.mMetrics = new DisplayMetrics();
        this.mMetrics.setToDefaults();
    }

    private final void $$robo$$android_content_pm_PackageParser$setSeparateProcesses(String[] procs) {
        this.mSeparateProcesses = procs;
    }

    private final void $$robo$$android_content_pm_PackageParser$setOnlyCoreApps(boolean onlyCoreApps) {
        this.mOnlyCoreApps = onlyCoreApps;
    }

    private final void $$robo$$android_content_pm_PackageParser$setDisplayMetrics(DisplayMetrics metrics) {
        this.mMetrics = metrics;
    }

    private final void $$robo$$android_content_pm_PackageParser$setCacheDir(File cacheDir) {
        this.mCacheDir = cacheDir;
    }

    private final void $$robo$$android_content_pm_PackageParser$setCallback(Callback cb) {
        this.mCallback = cb;
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$isApkFile(File file) {
        return PackageParser.isApkPath(file.getName());
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$isApkPath(String path) {
        return path.endsWith(".apk");
    }

    private static final PackageInfo $$robo$$android_content_pm_PackageParser$generatePackageInfo(Package p, int[] gids, int flags, long firstInstallTime, long lastUpdateTime, Set<String> grantedPermissions, PackageUserState state) {
        return PackageParser.generatePackageInfo(p, gids, flags, firstInstallTime, lastUpdateTime, grantedPermissions, state, UserHandle.getCallingUserId());
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$checkUseInstalledOrHidden(int flags, PackageUserState state, ApplicationInfo appInfo) {
        if ((flags & 0x20000000) == 0 && !state.installed && appInfo != null && appInfo.hiddenUntilInstalled) {
            return false;
        }
        return state.isAvailable(flags) || appInfo != null && appInfo.isSystemApp() && ((flags & 0x402000) != 0 || (flags & 0x20000000) != 0);
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$isAvailable(PackageUserState state) {
        return PackageParser.checkUseInstalledOrHidden(0, state, null);
    }

    private static final PackageInfo $$robo$$android_content_pm_PackageParser$generatePackageInfo(Package p, int[] gids, int flags, long firstInstallTime, long lastUpdateTime, Set<String> grantedPermissions, PackageUserState state, int userId) {
        int i;
        Activity a;
        int i2;
        ComponentInfo[] res;
        int num;
        int N;
        if (!PackageParser.checkUseInstalledOrHidden(flags, state, p.applicationInfo) || !p.isMatch(flags)) {
            return null;
        }
        PackageInfo pi = new PackageInfo();
        pi.packageName = p.packageName;
        pi.splitNames = p.splitNames;
        pi.versionCode = p.mVersionCode;
        pi.versionCodeMajor = p.mVersionCodeMajor;
        pi.baseRevisionCode = p.baseRevisionCode;
        pi.splitRevisionCodes = p.splitRevisionCodes;
        pi.versionName = p.mVersionName;
        pi.sharedUserId = p.mSharedUserId;
        pi.sharedUserLabel = p.mSharedUserLabel;
        pi.applicationInfo = PackageParser.generateApplicationInfo(p, flags, state, userId);
        pi.installLocation = p.installLocation;
        pi.isStub = p.isStub;
        pi.coreApp = p.coreApp;
        if ((pi.applicationInfo.flags & 1) != 0 || (pi.applicationInfo.flags & 0x80) != 0) {
            pi.requiredForAllUsers = p.mRequiredForAllUsers;
        }
        pi.restrictedAccountType = p.mRestrictedAccountType;
        pi.requiredAccountType = p.mRequiredAccountType;
        pi.overlayTarget = p.mOverlayTarget;
        pi.overlayCategory = p.mOverlayCategory;
        pi.overlayPriority = p.mOverlayPriority;
        pi.mOverlayIsStatic = p.mOverlayIsStatic;
        pi.compileSdkVersion = p.mCompileSdkVersion;
        pi.compileSdkVersionCodename = p.mCompileSdkVersionCodename;
        pi.firstInstallTime = firstInstallTime;
        pi.lastUpdateTime = lastUpdateTime;
        if ((flags & 0x100) != 0) {
            pi.gids = gids;
        }
        if ((flags & 0x4000) != 0) {
            int n = N = p.configPreferences != null ? p.configPreferences.size() : 0;
            if (N > 0) {
                pi.configPreferences = new ConfigurationInfo[N];
                p.configPreferences.toArray(pi.configPreferences);
            }
            int n2 = N = p.reqFeatures != null ? p.reqFeatures.size() : 0;
            if (N > 0) {
                pi.reqFeatures = new FeatureInfo[N];
                p.reqFeatures.toArray(pi.reqFeatures);
            }
            int n3 = N = p.featureGroups != null ? p.featureGroups.size() : 0;
            if (N > 0) {
                pi.featureGroups = new FeatureGroupInfo[N];
                p.featureGroups.toArray(pi.featureGroups);
            }
        }
        if ((flags & 1) != 0 && (N = p.activities.size()) > 0) {
            num = 0;
            res = new ActivityInfo[N];
            for (i2 = 0; i2 < N; ++i2) {
                a = p.activities.get(i2);
                if (!state.isMatch(a.info, flags)) continue;
                res[num++] = PackageParser.generateActivityInfo(a, flags, state, userId);
            }
            pi.activities = ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 2) != 0 && (N = p.receivers.size()) > 0) {
            num = 0;
            res = new ActivityInfo[N];
            for (i2 = 0; i2 < N; ++i2) {
                a = p.receivers.get(i2);
                if (!state.isMatch(a.info, flags)) continue;
                res[num++] = PackageParser.generateActivityInfo(a, flags, state, userId);
            }
            pi.receivers = (ActivityInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 4) != 0 && (N = p.services.size()) > 0) {
            num = 0;
            res = new ServiceInfo[N];
            for (i2 = 0; i2 < N; ++i2) {
                Service s = p.services.get(i2);
                if (!state.isMatch(s.info, flags)) continue;
                res[num++] = PackageParser.generateServiceInfo(s, flags, state, userId);
            }
            pi.services = (ServiceInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 8) != 0 && (N = p.providers.size()) > 0) {
            num = 0;
            res = new ProviderInfo[N];
            for (i2 = 0; i2 < N; ++i2) {
                Provider pr = p.providers.get(i2);
                if (!state.isMatch(pr.info, flags)) continue;
                res[num++] = PackageParser.generateProviderInfo(pr, flags, state, userId);
            }
            pi.providers = (ProviderInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 0x10) != 0 && (N = p.instrumentation.size()) > 0) {
            pi.instrumentation = new InstrumentationInfo[N];
            for (i = 0; i < N; ++i) {
                pi.instrumentation[i] = PackageParser.generateInstrumentationInfo(p.instrumentation.get(i), flags);
            }
        }
        if ((flags & 0x1000) != 0) {
            N = p.permissions.size();
            if (N > 0) {
                pi.permissions = new PermissionInfo[N];
                for (i = 0; i < N; ++i) {
                    pi.permissions[i] = PackageParser.generatePermissionInfo(p.permissions.get(i), flags);
                }
            }
            if ((N = p.requestedPermissions.size()) > 0) {
                pi.requestedPermissions = new String[N];
                pi.requestedPermissionsFlags = new int[N];
                for (i = 0; i < N; ++i) {
                    String perm;
                    pi.requestedPermissions[i] = perm = p.requestedPermissions.get(i);
                    int n = i;
                    pi.requestedPermissionsFlags[n] = pi.requestedPermissionsFlags[n] | 1;
                    if (grantedPermissions == null || !grantedPermissions.contains(perm)) continue;
                    int n4 = i;
                    pi.requestedPermissionsFlags[n4] = pi.requestedPermissionsFlags[n4] | 2;
                }
            }
        }
        if ((flags & 0x40) != 0) {
            if (p.mSigningDetails.hasPastSigningCertificates()) {
                pi.signatures = new Signature[1];
                pi.signatures[0] = p.mSigningDetails.pastSigningCertificates[0];
            } else if (p.mSigningDetails.hasSignatures()) {
                int numberOfSigs = p.mSigningDetails.signatures.length;
                pi.signatures = new Signature[numberOfSigs];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)p.mSigningDetails.signatures, (int)0, (Object)pi.signatures, (int)0, (int)numberOfSigs);
            }
        }
        if ((flags & 0x8000000) != 0) {
            pi.signingInfo = p.mSigningDetails != SigningDetails.UNKNOWN ? new SigningInfo(p.mSigningDetails) : null;
        }
        return pi;
    }

    private static final PackageLite $$robo$$android_content_pm_PackageParser$parsePackageLite(File packageFile, int flags) throws PackageParserException {
        if (packageFile.isDirectory()) {
            return PackageParser.parseClusterPackageLite(packageFile, flags);
        }
        return PackageParser.parseMonolithicPackageLite(packageFile, flags);
    }

    private static final PackageLite $$robo$$android_content_pm_PackageParser$parseMonolithicPackageLite(File packageFile, int flags) throws PackageParserException {
        Trace.traceBegin(262144L, "parseApkLite");
        ApkLite baseApk = PackageParser.parseApkLite(packageFile, flags);
        String packagePath = packageFile.getAbsolutePath();
        Trace.traceEnd(262144L);
        return new PackageLite(packagePath, baseApk, null, null, null, null, null, null);
    }

    private static final PackageLite $$robo$$android_content_pm_PackageParser$parseClusterPackageLite(File packageDir, int flags) throws PackageParserException {
        File[] files = packageDir.listFiles();
        if (ArrayUtils.isEmpty(files)) {
            throw new PackageParserException(-100, "No packages found in split");
        }
        String packageName = null;
        int versionCode = 0;
        Trace.traceBegin(262144L, "parseApkLite");
        ArrayMap<String, ApkLite> apks = new ArrayMap<String, ApkLite>();
        for (File file : files) {
            if (!PackageParser.isApkFile(file)) continue;
            ApkLite lite = PackageParser.parseApkLite(file, flags);
            if (packageName == null) {
                packageName = lite.packageName;
                versionCode = lite.versionCode;
            } else {
                if (!packageName.equals(lite.packageName)) {
                    throw new PackageParserException(-101, "Inconsistent package " + lite.packageName + " in " + file + "; expected " + packageName);
                }
                if (versionCode != lite.versionCode) {
                    throw new PackageParserException(-101, "Inconsistent version " + lite.versionCode + " in " + file + "; expected " + versionCode);
                }
            }
            if (apks.put(lite.splitName, lite) == null) continue;
            throw new PackageParserException(-101, "Split name " + lite.splitName + " defined more than once; most recent was " + file);
        }
        Trace.traceEnd(262144L);
        ApkLite baseApk = (ApkLite)apks.remove(null);
        if (baseApk == null) {
            throw new PackageParserException(-101, "Missing base APK in " + packageDir);
        }
        int size = apks.size();
        String[] splitNames = null;
        boolean[] isFeatureSplits = null;
        String[] usesSplitNames = null;
        String[] configForSplits = null;
        String[] splitCodePaths = null;
        int[] splitRevisionCodes = null;
        Object splitClassLoaderNames = null;
        if (size > 0) {
            splitNames = new String[size];
            isFeatureSplits = new boolean[size];
            usesSplitNames = new String[size];
            configForSplits = new String[size];
            splitCodePaths = new String[size];
            splitRevisionCodes = new int[size];
            splitNames = apks.keySet().toArray(splitNames);
            Arrays.sort(splitNames, sSplitNameComparator);
            for (int i = 0; i < size; ++i) {
                ApkLite apk = (ApkLite)apks.get(splitNames[i]);
                usesSplitNames[i] = apk.usesSplitName;
                isFeatureSplits[i] = apk.isFeatureSplit;
                configForSplits[i] = apk.configForSplit;
                splitCodePaths[i] = apk.codePath;
                splitRevisionCodes[i] = apk.revisionCode;
            }
        }
        String codePath = packageDir.getAbsolutePath();
        return new PackageLite(codePath, baseApk, splitNames, isFeatureSplits, usesSplitNames, configForSplits, splitCodePaths, splitRevisionCodes);
    }

    private final Package $$robo$$android_content_pm_PackageParser$parsePackage(File packageFile, int flags, boolean useCaches) throws PackageParserException {
        Package parsed;
        Package package_ = parsed = useCaches ? this.getCachedResult(packageFile, flags) : null;
        if (parsed != null) {
            return parsed;
        }
        long parseTime = LOG_PARSE_TIMINGS ? SystemClock.uptimeMillis() : 0L;
        parsed = packageFile.isDirectory() ? this.parseClusterPackage(packageFile, flags) : this.parseMonolithicPackage(packageFile, flags);
        long cacheTime = LOG_PARSE_TIMINGS ? SystemClock.uptimeMillis() : 0L;
        this.cacheResult(packageFile, flags, parsed);
        if (LOG_PARSE_TIMINGS && (parseTime = cacheTime - parseTime) + (cacheTime = SystemClock.uptimeMillis() - cacheTime) > 100L) {
            Slog.i("PackageParser", "Parse times for '" + packageFile + "': parse=" + parseTime + "ms, update_cache=" + cacheTime + " ms");
        }
        return parsed;
    }

    private final Package $$robo$$android_content_pm_PackageParser$parsePackage(File packageFile, int flags) throws PackageParserException {
        return this.parsePackage(packageFile, flags, false);
    }

    private final String $$robo$$android_content_pm_PackageParser$getCacheKey(File packageFile, int flags) {
        StringBuilder sb = new StringBuilder(packageFile.getName());
        sb.append('-');
        sb.append(flags);
        return sb.toString();
    }

    @VisibleForTesting
    private final Package $$robo$$android_content_pm_PackageParser$fromCacheEntry(byte[] bytes) {
        return PackageParser.fromCacheEntryStatic(bytes);
    }

    @VisibleForTesting
    private static final Package $$robo$$android_content_pm_PackageParser$fromCacheEntryStatic(byte[] bytes) {
        Parcel p = Parcel.obtain();
        p.unmarshall(bytes, 0, bytes.length);
        p.setDataPosition(0);
        PackageParserCacheHelper.ReadHelper helper = new PackageParserCacheHelper.ReadHelper(p);
        helper.startAndInstall();
        Package pkg = new Package(p);
        p.recycle();
        sCachedPackageReadCount.incrementAndGet();
        return pkg;
    }

    @VisibleForTesting
    private final byte[] $$robo$$android_content_pm_PackageParser$toCacheEntry(Package pkg) {
        return PackageParser.toCacheEntryStatic(pkg);
    }

    @VisibleForTesting
    private static final byte[] $$robo$$android_content_pm_PackageParser$toCacheEntryStatic(Package pkg) {
        Parcel p = Parcel.obtain();
        PackageParserCacheHelper.WriteHelper helper = new PackageParserCacheHelper.WriteHelper(p);
        pkg.writeToParcel(p, 0);
        helper.finishAndUninstall();
        byte[] serialized = p.marshall();
        p.recycle();
        return serialized;
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$isCacheUpToDate(File packageFile, File cacheFile) {
        try {
            StructStat pkg = Os.stat(packageFile.getAbsolutePath());
            StructStat cache = Os.stat(cacheFile.getAbsolutePath());
            return pkg.st_mtime < cache.st_mtime;
        }
        catch (ErrnoException ee) {
            if (ee.errno != OsConstants.ENOENT) {
                Slog.w("Error while stating package cache : ", ee);
            }
            return false;
        }
    }

    private final Package $$robo$$android_content_pm_PackageParser$getCachedResult(File packageFile, int flags) {
        if (this.mCacheDir == null) {
            return null;
        }
        String cacheKey = this.getCacheKey(packageFile, flags);
        File cacheFile = new File(this.mCacheDir, cacheKey);
        try {
            String[] overlayApks;
            if (!PackageParser.isCacheUpToDate(packageFile, cacheFile)) {
                return null;
            }
            byte[] bytes = IoUtils.readFileAsByteArray(cacheFile.getAbsolutePath());
            Package p = this.fromCacheEntry(bytes);
            if (this.mCallback != null && (overlayApks = this.mCallback.getOverlayApks(p.packageName)) != null && overlayApks.length > 0) {
                for (String overlayApk : overlayApks) {
                    if (PackageParser.isCacheUpToDate(new File(overlayApk), cacheFile)) continue;
                    return null;
                }
            }
            return p;
        }
        catch (Throwable e) {
            Slog.w("PackageParser", "Error reading package cache: ", e);
            cacheFile.delete();
            return null;
        }
    }

    private final void $$robo$$android_content_pm_PackageParser$cacheResult(File packageFile, int flags, Package parsed) {
        if (this.mCacheDir == null) {
            return;
        }
        try {
            byte[] cacheEntry;
            String cacheKey = this.getCacheKey(packageFile, flags);
            File cacheFile = new File(this.mCacheDir, cacheKey);
            if (cacheFile.exists() && !cacheFile.delete()) {
                Slog.e("PackageParser", "Unable to delete cache file: " + cacheFile);
            }
            if ((cacheEntry = this.toCacheEntry(parsed)) == null) {
                return;
            }
            try (FileOutputStream fos = new FileOutputStream(cacheFile);){
                fos.write(cacheEntry);
            }
            catch (IOException ioe) {
                Slog.w("PackageParser", "Error writing cache entry.", ioe);
                cacheFile.delete();
            }
        }
        catch (Throwable e) {
            Slog.w("PackageParser", "Error saving package cache.", e);
        }
    }

    private final Package $$robo$$android_content_pm_PackageParser$parseClusterPackage(File packageDir, int flags) throws PackageParserException {
        SplitAssetLoader assetLoader;
        PackageLite lite = PackageParser.parseClusterPackageLite(packageDir, 0);
        if (this.mOnlyCoreApps && !lite.coreApp) {
            throw new PackageParserException(-108, "Not a coreApp: " + packageDir);
        }
        SparseArray<int[]> splitDependencies = null;
        if (lite.isolatedSplits && !ArrayUtils.isEmpty(lite.splitNames)) {
            try {
                splitDependencies = SplitAssetDependencyLoader.createDependenciesFromPackage(lite);
                assetLoader = new SplitAssetDependencyLoader(lite, splitDependencies, flags);
            }
            catch (SplitDependencyLoader.IllegalDependencyException e) {
                throw new PackageParserException(-101, e.getMessage());
            }
        } else {
            assetLoader = new DefaultSplitAssetLoader(lite, flags);
        }
        try {
            AssetManager assets = assetLoader.getBaseAssetManager();
            File baseApk = new File(lite.baseCodePath);
            Package pkg = this.parseBaseApk(baseApk, assets, flags);
            if (pkg == null) {
                throw new PackageParserException(-100, "Failed to parse base APK: " + baseApk);
            }
            if (!ArrayUtils.isEmpty(lite.splitNames)) {
                int num = lite.splitNames.length;
                pkg.splitNames = lite.splitNames;
                pkg.splitCodePaths = lite.splitCodePaths;
                pkg.splitRevisionCodes = lite.splitRevisionCodes;
                pkg.splitFlags = new int[num];
                pkg.splitPrivateFlags = new int[num];
                pkg.applicationInfo.splitNames = pkg.splitNames;
                pkg.applicationInfo.splitDependencies = splitDependencies;
                pkg.applicationInfo.splitClassLoaderNames = new String[num];
                for (int i = 0; i < num; ++i) {
                    AssetManager splitAssets = assetLoader.getSplitAssetManager(i);
                    this.parseSplitApk(pkg, i, splitAssets, flags);
                }
            }
            pkg.setCodePath(packageDir.getCanonicalPath());
            pkg.setUse32bitAbi(lite.use32bitAbi);
            Package package_ = pkg;
            return package_;
        }
        catch (IOException e) {
            throw new PackageParserException(-102, "Failed to get path: " + lite.baseCodePath, e);
        }
        finally {
            IoUtils.closeQuietly(assetLoader);
        }
    }

    @Deprecated
    private final Package $$robo$$android_content_pm_PackageParser$parseMonolithicPackage(File apkFile, int flags) throws PackageParserException {
        PackageLite lite = PackageParser.parseMonolithicPackageLite(apkFile, flags);
        if (this.mOnlyCoreApps && !lite.coreApp) {
            throw new PackageParserException(-108, "Not a coreApp: " + apkFile);
        }
        DefaultSplitAssetLoader assetLoader = new DefaultSplitAssetLoader(lite, flags);
        try {
            Package pkg = this.parseBaseApk(apkFile, assetLoader.getBaseAssetManager(), flags);
            pkg.setCodePath(apkFile.getCanonicalPath());
            pkg.setUse32bitAbi(lite.use32bitAbi);
            Package package_ = pkg;
            return package_;
        }
        catch (IOException e) {
            throw new PackageParserException(-102, "Failed to get path: " + apkFile, e);
        }
        finally {
            IoUtils.closeQuietly(assetLoader);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Package $$robo$$android_content_pm_PackageParser$parseBaseApk(File apkFile, AssetManager assets, int flags) throws PackageParserException {
        Package package_;
        String apkPath = apkFile.getAbsolutePath();
        String volumeUuid = null;
        if (apkPath.startsWith("/mnt/expand/")) {
            int end = apkPath.indexOf(47, "/mnt/expand/".length());
            volumeUuid = apkPath.substring("/mnt/expand/".length(), end);
        }
        this.mParseError = 1;
        this.mArchiveSourcePath = apkFile.getAbsolutePath();
        XmlResourceParser parser = null;
        try {
            String[] outError;
            int cookie = assets.findCookieForPath(apkPath);
            if (cookie == 0) {
                throw new PackageParserException(-101, "Failed adding asset path: " + apkPath);
            }
            Resources res = new Resources(assets, this.mMetrics, null);
            parser = assets.openXmlResourceParser(cookie, "AndroidManifest.xml");
            Package pkg = this.parseBaseApk(apkPath, res, parser, flags, outError = new String[1]);
            if (pkg == null) {
                throw new PackageParserException(this.mParseError, apkPath + " (at " + parser.getPositionDescription() + "): " + outError[0]);
            }
            pkg.setVolumeUuid(volumeUuid);
            pkg.setApplicationVolumeUuid(volumeUuid);
            pkg.setBaseCodePath(apkPath);
            pkg.setSigningDetails(SigningDetails.UNKNOWN);
            package_ = pkg;
        }
        catch (PackageParserException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new PackageParserException(-102, "Failed to read manifest from " + apkPath, e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(parser);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(parser);
        return package_;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void $$robo$$android_content_pm_PackageParser$parseSplitApk(Package pkg, int splitIndex, AssetManager assets, int flags) throws PackageParserException {
        String apkPath = pkg.splitCodePaths[splitIndex];
        this.mParseError = 1;
        this.mArchiveSourcePath = apkPath;
        XmlResourceParser parser = null;
        try {
            String[] outError;
            int cookie = assets.findCookieForPath(apkPath);
            if (cookie == 0) {
                throw new PackageParserException(-101, "Failed adding asset path: " + apkPath);
            }
            Resources res = new Resources(assets, this.mMetrics, null);
            parser = assets.openXmlResourceParser(cookie, "AndroidManifest.xml");
            if ((pkg = this.parseSplitApk(pkg, res, parser, flags, splitIndex, outError = new String[1])) == null) {
                throw new PackageParserException(this.mParseError, apkPath + " (at " + parser.getPositionDescription() + "): " + outError[0]);
            }
        }
        catch (PackageParserException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new PackageParserException(-102, "Failed to read manifest from " + apkPath, e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(parser);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(parser);
    }

    private final Package $$robo$$android_content_pm_PackageParser$parseSplitApk(Package pkg, Resources res, XmlResourceParser parser, int flags, int splitIndex, String[] outError) throws XmlPullParserException, IOException, PackageParserException {
        int type;
        XmlResourceParser attrs = parser;
        PackageParser.parsePackageSplitNames(parser, attrs);
        this.mParseInstrumentationArgs = null;
        boolean foundApp = false;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("application")) {
                if (foundApp) {
                    Slog.w("PackageParser", "<manifest> has more than one <application>");
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                foundApp = true;
                if (this.parseSplitApplication(pkg, res, parser, flags, splitIndex, outError)) continue;
                return null;
            }
            Slog.w("PackageParser", "Unknown element under <manifest>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!foundApp) {
            outError[0] = "<manifest> does not contain an <application>";
            this.mParseError = -109;
        }
        return pkg;
    }

    private static final ArraySet<PublicKey> $$robo$$android_content_pm_PackageParser$toSigningKeys(Signature[] signatures) throws CertificateException {
        ArraySet<PublicKey> keys = new ArraySet<PublicKey>(signatures.length);
        for (int i = 0; i < signatures.length; ++i) {
            keys.add(signatures[i].getPublicKey());
        }
        return keys;
    }

    private static final void $$robo$$android_content_pm_PackageParser$collectCertificates(Package pkg, boolean skipVerify) throws PackageParserException {
        PackageParser.collectCertificatesInternal(pkg, skipVerify);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            Package childPkg = pkg.childPackages.get(i);
            childPkg.mSigningDetails = pkg.mSigningDetails;
        }
    }

    private static final void $$robo$$android_content_pm_PackageParser$collectCertificatesInternal(Package pkg, boolean skipVerify) throws PackageParserException {
        pkg.mSigningDetails = SigningDetails.UNKNOWN;
        Trace.traceBegin(262144L, "collectCertificates");
        try {
            PackageParser.collectCertificates(pkg, new File(pkg.baseCodePath), skipVerify);
            if (!ArrayUtils.isEmpty(pkg.splitCodePaths)) {
                for (int i = 0; i < pkg.splitCodePaths.length; ++i) {
                    PackageParser.collectCertificates(pkg, new File(pkg.splitCodePaths[i]), skipVerify);
                }
            }
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    private static final void $$robo$$android_content_pm_PackageParser$collectCertificates(Package pkg, File apkFile, boolean skipVerify) throws PackageParserException {
        String apkPath = apkFile.getAbsolutePath();
        int minSignatureScheme = 1;
        if (pkg.applicationInfo.isStaticSharedLibrary()) {
            minSignatureScheme = 2;
        }
        SigningDetails verified = skipVerify ? ApkSignatureVerifier.plsCertsNoVerifyOnlyCerts(apkPath, minSignatureScheme) : ApkSignatureVerifier.verify(apkPath, minSignatureScheme);
        if (pkg.mSigningDetails == SigningDetails.UNKNOWN) {
            pkg.mSigningDetails = verified;
        } else if (!Signature.areExactMatch(pkg.mSigningDetails.signatures, verified.signatures)) {
            throw new PackageParserException(-104, apkPath + " has mismatched certificates");
        }
    }

    private static final AssetManager $$robo$$android_content_pm_PackageParser$newConfiguredAssetManager() {
        AssetManager assetManager = new AssetManager();
        assetManager.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
        return assetManager;
    }

    private static final ApkLite $$robo$$android_content_pm_PackageParser$parseApkLite(File apkFile, int flags) throws PackageParserException {
        return PackageParser.parseApkLiteInner(apkFile, null, null, flags);
    }

    private static final ApkLite $$robo$$android_content_pm_PackageParser$parseApkLite(FileDescriptor fd, String debugPathName, int flags) throws PackageParserException {
        return PackageParser.parseApkLiteInner(null, fd, debugPathName, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ApkLite $$robo$$android_content_pm_PackageParser$parseApkLiteInner(File apkFile, FileDescriptor fd, String debugPathName, int flags) throws PackageParserException {
        ApkLite apkLite;
        String apkPath = fd != null ? debugPathName : apkFile.getAbsolutePath();
        XmlResourceParser parser = null;
        try {
            SigningDetails signingDetails;
            ApkAssets apkAssets;
            try {
                apkAssets = fd != null ? ApkAssets.loadFromFd(fd, debugPathName, false, false) : ApkAssets.loadFromPath(apkPath);
            }
            catch (IOException e) {
                throw new PackageParserException(-100, "Failed to parse " + apkPath);
            }
            parser = apkAssets.openXml("AndroidManifest.xml");
            if ((flags & 0x20) != 0) {
                Package tempPkg = new Package((String)null);
                boolean skipVerify = (flags & 0x10) != 0;
                Trace.traceBegin(262144L, "collectCertificates");
                try {
                    PackageParser.collectCertificates(tempPkg, apkFile, skipVerify);
                }
                finally {
                    Trace.traceEnd(262144L);
                }
                signingDetails = tempPkg.mSigningDetails;
            } else {
                signingDetails = SigningDetails.UNKNOWN;
            }
            XmlResourceParser attrs = parser;
            apkLite = PackageParser.parseApkLite(apkPath, parser, attrs, signingDetails);
        }
        catch (IOException | RuntimeException | XmlPullParserException e) {
            try {
                Slog.w("PackageParser", "Failed to parse " + apkPath, e);
                throw new PackageParserException(-102, "Failed to parse " + apkPath, e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(parser);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(parser);
        return apkLite;
    }

    private static final String $$robo$$android_content_pm_PackageParser$validateName(String name, boolean requireSeparator, boolean requireFilename) {
        int N = name.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (!front && (c >= '0' && c <= '9' || c == '_')) continue;
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return "bad character '" + c + "'";
        }
        if (requireFilename && !FileUtils.isValidExtFilename(name)) {
            return "Invalid filename";
        }
        return hasSep || !requireSeparator ? null : "must have at least one '.' separator";
    }

    private static final Pair<String, String> $$robo$$android_content_pm_PackageParser$parsePackageSplitNames(XmlPullParser parser, AttributeSet attrs) throws IOException, XmlPullParserException, PackageParserException {
        String error;
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new PackageParserException(-108, "No start tag found");
        }
        if (!parser.getName().equals("manifest")) {
            throw new PackageParserException(-108, "No <manifest> tag");
        }
        String packageName = attrs.getAttributeValue(null, "package");
        if (!"android".equals(packageName) && (error = PackageParser.validateName(packageName, true, true)) != null) {
            throw new PackageParserException(-106, "Invalid manifest package: " + error);
        }
        String splitName = attrs.getAttributeValue(null, "split");
        if (splitName != null) {
            if (splitName.length() == 0) {
                splitName = null;
            } else {
                String error2 = PackageParser.validateName(splitName, false, false);
                if (error2 != null) {
                    throw new PackageParserException(-106, "Invalid manifest split: " + error2);
                }
            }
        }
        return Pair.create(packageName.intern(), splitName != null ? splitName.intern() : splitName);
    }

    private static final ApkLite $$robo$$android_content_pm_PackageParser$parseApkLite(String codePath, XmlPullParser parser, AttributeSet attrs, SigningDetails signingDetails) throws IOException, XmlPullParserException, PackageParserException {
        int type;
        Pair<String, String> packageSplit = PackageParser.parsePackageSplitNames(parser, attrs);
        int installLocation = -1;
        int versionCode = 0;
        int versionCodeMajor = 0;
        int revisionCode = 0;
        boolean coreApp = false;
        boolean debuggable = false;
        boolean multiArch = false;
        boolean use32bitAbi = false;
        boolean extractNativeLibs = true;
        boolean isolatedSplits = false;
        boolean isFeatureSplit = false;
        String configForSplit = null;
        String usesSplitName = null;
        for (int i = 0; i < attrs.getAttributeCount(); ++i) {
            String attr2 = attrs.getAttributeName(i);
            if (attr2.equals("installLocation")) {
                installLocation = attrs.getAttributeIntValue(i, -1);
                continue;
            }
            if (attr2.equals("versionCode")) {
                versionCode = attrs.getAttributeIntValue(i, 0);
                continue;
            }
            if (attr2.equals("versionCodeMajor")) {
                versionCodeMajor = attrs.getAttributeIntValue(i, 0);
                continue;
            }
            if (attr2.equals("revisionCode")) {
                revisionCode = attrs.getAttributeIntValue(i, 0);
                continue;
            }
            if (attr2.equals("coreApp")) {
                coreApp = attrs.getAttributeBooleanValue(i, false);
                continue;
            }
            if (attr2.equals("isolatedSplits")) {
                isolatedSplits = attrs.getAttributeBooleanValue(i, false);
                continue;
            }
            if (attr2.equals("configForSplit")) {
                configForSplit = attrs.getAttributeValue(i);
                continue;
            }
            if (!attr2.equals("isFeatureSplit")) continue;
            isFeatureSplit = attrs.getAttributeBooleanValue(i, false);
        }
        int searchDepth = parser.getDepth() + 1;
        ArrayList<VerifierInfo> verifiers = new ArrayList<VerifierInfo>();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() >= searchDepth)) {
            if (type == 3 || type == 4 || parser.getDepth() != searchDepth) continue;
            if ("package-verifier".equals(parser.getName())) {
                VerifierInfo verifier = PackageParser.parseVerifier(attrs);
                if (verifier == null) continue;
                verifiers.add(verifier);
                continue;
            }
            if ("application".equals(parser.getName())) {
                for (int i = 0; i < attrs.getAttributeCount(); ++i) {
                    String attr3 = attrs.getAttributeName(i);
                    if ("debuggable".equals(attr3)) {
                        debuggable = attrs.getAttributeBooleanValue(i, false);
                    }
                    if ("multiArch".equals(attr3)) {
                        multiArch = attrs.getAttributeBooleanValue(i, false);
                    }
                    if ("use32bitAbi".equals(attr3)) {
                        use32bitAbi = attrs.getAttributeBooleanValue(i, false);
                    }
                    if (!"extractNativeLibs".equals(attr3)) continue;
                    extractNativeLibs = attrs.getAttributeBooleanValue(i, true);
                }
                continue;
            }
            if (!"uses-split".equals(parser.getName())) continue;
            if (usesSplitName != null) {
                Slog.w("PackageParser", "Only one <uses-split> permitted. Ignoring others.");
                continue;
            }
            usesSplitName = attrs.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
            if (usesSplitName != null) continue;
            throw new PackageParserException(-108, "<uses-split> tag requires 'android:name' attribute");
        }
        return new ApkLite(codePath, (String)packageSplit.first, (String)packageSplit.second, isFeatureSplit, configForSplit, usesSplitName, versionCode, versionCodeMajor, revisionCode, installLocation, verifiers, signingDetails, coreApp, debuggable, multiArch, use32bitAbi, extractNativeLibs, isolatedSplits);
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseBaseApkChild(Package parentPkg, Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        String childPackageName = parser.getAttributeValue(null, "package");
        if (PackageParser.validateName(childPackageName, true, false) != null) {
            this.mParseError = -106;
            return false;
        }
        if (childPackageName.equals(parentPkg.packageName)) {
            String message = "Child package name cannot be equal to parent package name: " + parentPkg.packageName;
            Slog.w("PackageParser", message);
            outError[0] = message;
            this.mParseError = -108;
            return false;
        }
        if (parentPkg.hasChildPackage(childPackageName)) {
            String message = "Duplicate child package:" + childPackageName;
            Slog.w("PackageParser", message);
            outError[0] = message;
            this.mParseError = -108;
            return false;
        }
        Package childPkg = new Package(childPackageName);
        childPkg.mVersionCode = parentPkg.mVersionCode;
        childPkg.baseRevisionCode = parentPkg.baseRevisionCode;
        childPkg.mVersionName = parentPkg.mVersionName;
        childPkg.applicationInfo.targetSdkVersion = parentPkg.applicationInfo.targetSdkVersion;
        childPkg.applicationInfo.minSdkVersion = parentPkg.applicationInfo.minSdkVersion;
        if ((childPkg = this.parseBaseApkCommon(childPkg, CHILD_PACKAGE_TAGS, res, parser, flags, outError)) == null) {
            return false;
        }
        if (parentPkg.childPackages == null) {
            parentPkg.childPackages = new ArrayList();
        }
        parentPkg.childPackages.add(childPkg);
        childPkg.parentPackage = parentPkg;
        return true;
    }

    private final Package $$robo$$android_content_pm_PackageParser$parseBaseApk(String apkPath, Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        String[] overlayPaths;
        String pkgName;
        try {
            Pair<String, String> packageSplit = PackageParser.parsePackageSplitNames(parser, parser);
            pkgName = (String)packageSplit.first;
            String splitName = (String)packageSplit.second;
            if (!TextUtils.isEmpty(splitName)) {
                outError[0] = "Expected base APK, but found split " + splitName;
                this.mParseError = -106;
                return null;
            }
        }
        catch (PackageParserException e) {
            this.mParseError = -106;
            return null;
        }
        if (this.mCallback != null && (overlayPaths = this.mCallback.getOverlayPaths(pkgName, apkPath)) != null && overlayPaths.length > 0) {
            for (String overlayPath : overlayPaths) {
                res.getAssets().addOverlayPath(overlayPath);
            }
        }
        Package pkg = new Package(pkgName);
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifest);
        pkg.mVersionCode = sa.getInteger(1, 0);
        pkg.mVersionCodeMajor = sa.getInteger(11, 0);
        pkg.applicationInfo.setVersionCode(pkg.getLongVersionCode());
        pkg.baseRevisionCode = sa.getInteger(5, 0);
        pkg.mVersionName = sa.getNonConfigurationString(2, 0);
        if (pkg.mVersionName != null) {
            pkg.mVersionName = pkg.mVersionName.intern();
        }
        pkg.coreApp = parser.getAttributeBooleanValue(null, "coreApp", false);
        pkg.applicationInfo.compileSdkVersion = pkg.mCompileSdkVersion = sa.getInteger(9, 0);
        pkg.mCompileSdkVersionCodename = sa.getNonConfigurationString(10, 0);
        if (pkg.mCompileSdkVersionCodename != null) {
            pkg.mCompileSdkVersionCodename = pkg.mCompileSdkVersionCodename.intern();
        }
        pkg.applicationInfo.compileSdkVersionCodename = pkg.mCompileSdkVersionCodename;
        sa.recycle();
        return this.parseBaseApkCommon(pkg, null, res, parser, flags, outError);
    }

    private final Package $$robo$$android_content_pm_PackageParser$parseBaseApkCommon(Package pkg, Set<String> acceptedTags, Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int targetSandboxVersion;
        this.mParseInstrumentationArgs = null;
        boolean foundApp = false;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifest);
        String str = sa.getNonConfigurationString(0, 0);
        if (str != null && str.length() > 0) {
            String nameError = PackageParser.validateName(str, true, false);
            if (nameError != null && !"android".equals(pkg.packageName)) {
                outError[0] = "<manifest> specifies bad sharedUserId name \"" + str + "\": " + nameError;
                this.mParseError = -107;
                return null;
            }
            pkg.mSharedUserId = str.intern();
            pkg.mSharedUserLabel = sa.getResourceId(3, 0);
        }
        pkg.applicationInfo.installLocation = pkg.installLocation = sa.getInteger(4, -1);
        pkg.applicationInfo.targetSandboxVersion = targetSandboxVersion = sa.getInteger(7, 1);
        if ((flags & 4) != 0) {
            pkg.applicationInfo.privateFlags |= 4;
        }
        if ((flags & 8) != 0) {
            pkg.applicationInfo.flags |= 0x40000;
        }
        if (sa.getBoolean(6, false)) {
            pkg.applicationInfo.privateFlags |= 0x8000;
        }
        int supportsSmallScreens = 1;
        int supportsNormalScreens = 1;
        int supportsLargeScreens = 1;
        int supportsXLargeScreens = 1;
        int resizeable = 1;
        int anyDensity = 1;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (acceptedTags != null && !acceptedTags.contains(tagName)) {
                Slog.w("PackageParser", "Skipping unsupported element under <manifest>: " + tagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("application")) {
                if (foundApp) {
                    Slog.w("PackageParser", "<manifest> has more than one <application>");
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                foundApp = true;
                if (this.parseBaseApplication(pkg, res, parser, flags, outError)) continue;
                return null;
            }
            if (tagName.equals("overlay")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestResourceOverlay);
                pkg.mOverlayTarget = sa.getString(1);
                pkg.mOverlayCategory = sa.getString(2);
                pkg.mOverlayPriority = sa.getInt(0, 0);
                pkg.mOverlayIsStatic = sa.getBoolean(3, false);
                String propName = sa.getString(4);
                String propValue = sa.getString(5);
                sa.recycle();
                if (pkg.mOverlayTarget == null) {
                    outError[0] = "<overlay> does not specify a target package";
                    this.mParseError = -108;
                    return null;
                }
                if (pkg.mOverlayPriority < 0 || pkg.mOverlayPriority > 9999) {
                    outError[0] = "<overlay> priority must be between 0 and 9999";
                    this.mParseError = -108;
                    return null;
                }
                if (!this.checkOverlayRequiredSystemProperty(propName, propValue)) {
                    Slog.i("PackageParser", "Skipping target and overlay pair " + pkg.mOverlayTarget + " and " + pkg.baseCodePath + ": overlay ignored due to required system property: " + propName + " with value: " + propValue);
                    return null;
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("key-sets")) {
                if (this.parseKeySets(pkg, res, parser, outError)) continue;
                return null;
            }
            if (tagName.equals("permission-group")) {
                if (this.parsePermissionGroup(pkg, flags, res, parser, outError)) continue;
                return null;
            }
            if (tagName.equals("permission")) {
                if (this.parsePermission(pkg, res, parser, outError)) continue;
                return null;
            }
            if (tagName.equals("permission-tree")) {
                if (this.parsePermissionTree(pkg, res, parser, outError)) continue;
                return null;
            }
            if (tagName.equals("uses-permission")) {
                if (this.parseUsesPermission(pkg, res, parser)) continue;
                return null;
            }
            if (tagName.equals("uses-permission-sdk-m") || tagName.equals("uses-permission-sdk-23")) {
                if (this.parseUsesPermission(pkg, res, parser)) continue;
                return null;
            }
            if (tagName.equals("uses-configuration")) {
                ConfigurationInfo cPref = new ConfigurationInfo();
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesConfiguration);
                cPref.reqTouchScreen = sa.getInt(0, 0);
                cPref.reqKeyboardType = sa.getInt(1, 0);
                if (sa.getBoolean(2, false)) {
                    cPref.reqInputFeatures |= 1;
                }
                cPref.reqNavigation = sa.getInt(3, 0);
                if (sa.getBoolean(4, false)) {
                    cPref.reqInputFeatures |= 2;
                }
                sa.recycle();
                pkg.configPreferences = ArrayUtils.add(pkg.configPreferences, cPref);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-feature")) {
                FeatureInfo fi = this.parseUsesFeature(res, parser);
                pkg.reqFeatures = ArrayUtils.add(pkg.reqFeatures, fi);
                if (fi.name == null) {
                    ConfigurationInfo cPref = new ConfigurationInfo();
                    cPref.reqGlEsVersion = fi.reqGlEsVersion;
                    pkg.configPreferences = ArrayUtils.add(pkg.configPreferences, cPref);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("feature-group")) {
                FeatureGroupInfo group = new FeatureGroupInfo();
                ArrayList<FeatureInfo> features = null;
                int innerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
                    if (type == 3 || type == 4) continue;
                    String innerTagName = parser.getName();
                    if (innerTagName.equals("uses-feature")) {
                        FeatureInfo featureInfo = this.parseUsesFeature(res, parser);
                        featureInfo.flags |= 1;
                        features = ArrayUtils.add(features, featureInfo);
                    } else {
                        Slog.w("PackageParser", "Unknown element under <feature-group>: " + innerTagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    }
                    XmlUtils.skipCurrentTag(parser);
                }
                if (features != null) {
                    group.features = new FeatureInfo[features.size()];
                    group.features = features.toArray(group.features);
                }
                pkg.featureGroups = ArrayUtils.add(pkg.featureGroups, group);
                continue;
            }
            if (tagName.equals("uses-sdk")) {
                if (SDK_VERSION > 0) {
                    sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesSdk);
                    int minVers = 1;
                    String minCode = null;
                    int targetVers = 0;
                    String targetCode = null;
                    TypedValue val = sa.peekValue(0);
                    if (val != null) {
                        if (val.type == 3 && val.string != null) {
                            targetCode = minCode = val.string.toString();
                        } else {
                            targetVers = minVers = val.data;
                        }
                    }
                    if ((val = sa.peekValue(1)) != null) {
                        if (val.type == 3 && val.string != null) {
                            targetCode = val.string.toString();
                            if (minCode == null) {
                                minCode = targetCode;
                            }
                        } else {
                            targetVers = val.data;
                        }
                    }
                    sa.recycle();
                    int minSdkVersion = PackageParser.computeMinSdkVersion(minVers, minCode, SDK_VERSION, SDK_CODENAMES, outError);
                    if (minSdkVersion < 0) {
                        this.mParseError = -12;
                        return null;
                    }
                    boolean defaultToCurrentDevBranch = (flags & 0x80) != 0;
                    int targetSdkVersion = PackageParser.computeTargetSdkVersion(targetVers, targetCode, SDK_CODENAMES, outError, defaultToCurrentDevBranch);
                    if (targetSdkVersion < 0) {
                        this.mParseError = -12;
                        return null;
                    }
                    pkg.applicationInfo.minSdkVersion = minSdkVersion;
                    pkg.applicationInfo.targetSdkVersion = targetSdkVersion;
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("supports-screens")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestSupportsScreens);
                pkg.applicationInfo.requiresSmallestWidthDp = sa.getInteger(6, 0);
                pkg.applicationInfo.compatibleWidthLimitDp = sa.getInteger(7, 0);
                pkg.applicationInfo.largestWidthLimitDp = sa.getInteger(8, 0);
                supportsSmallScreens = sa.getInteger(1, supportsSmallScreens);
                supportsNormalScreens = sa.getInteger(2, supportsNormalScreens);
                supportsLargeScreens = sa.getInteger(3, supportsLargeScreens);
                supportsXLargeScreens = sa.getInteger(5, supportsXLargeScreens);
                resizeable = sa.getInteger(4, resizeable);
                anyDensity = sa.getInteger(0, anyDensity);
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("protected-broadcast")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProtectedBroadcast);
                String name = sa.getNonResourceString(0);
                sa.recycle();
                if (name != null) {
                    if (pkg.protectedBroadcasts == null) {
                        pkg.protectedBroadcasts = new ArrayList();
                    }
                    if (!pkg.protectedBroadcasts.contains(name)) {
                        pkg.protectedBroadcasts.add(name.intern());
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("instrumentation")) {
                if (this.parseInstrumentation(pkg, res, parser, outError) != null) continue;
                return null;
            }
            if (tagName.equals("original-package")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestOriginalPackage);
                String orig = sa.getNonConfigurationString(0, 0);
                if (!pkg.packageName.equals(orig)) {
                    if (pkg.mOriginalPackages == null) {
                        pkg.mOriginalPackages = new ArrayList();
                        pkg.mRealPackage = pkg.packageName;
                    }
                    pkg.mOriginalPackages.add(orig);
                }
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("adopt-permissions")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestOriginalPackage);
                String name = sa.getNonConfigurationString(0, 0);
                sa.recycle();
                if (name != null) {
                    if (pkg.mAdoptPermissions == null) {
                        pkg.mAdoptPermissions = new ArrayList();
                    }
                    pkg.mAdoptPermissions.add(name);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-gl-texture")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("compatible-screens")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("supports-input")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("eat-comment")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("package")) {
                if (!MULTI_PACKAGE_APK_ENABLED) {
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if (this.parseBaseApkChild(pkg, res, parser, flags, outError)) continue;
                return null;
            }
            if (tagName.equals("restrict-update")) {
                if ((flags & 0x10) != 0) {
                    sa = res.obtainAttributes(parser, R.styleable.AndroidManifestRestrictUpdate);
                    String hash = sa.getNonConfigurationString(0, 0);
                    sa.recycle();
                    pkg.restrictUpdateHash = null;
                    if (hash != null) {
                        int hashLength = hash.length();
                        byte[] hashBytes = new byte[hashLength / 2];
                        for (int i = 0; i < hashLength; i += 2) {
                            hashBytes[i / 2] = (byte)((Character.digit(hash.charAt(i), 16) << 4) + Character.digit(hash.charAt(i + 1), 16));
                        }
                        pkg.restrictUpdateHash = hashBytes;
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <manifest>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!foundApp && pkg.instrumentation.size() == 0) {
            outError[0] = "<manifest> does not contain an <application> or <instrumentation>";
            this.mParseError = -109;
        }
        int NP = NEW_PERMISSIONS.length;
        StringBuilder implicitPerms = null;
        for (int ip = 0; ip < NP; ++ip) {
            NewPermissionInfo npi = NEW_PERMISSIONS[ip];
            if (pkg.applicationInfo.targetSdkVersion >= npi.sdkVersion) break;
            if (pkg.requestedPermissions.contains(npi.name)) continue;
            if (implicitPerms == null) {
                implicitPerms = new StringBuilder(128);
                implicitPerms.append(pkg.packageName);
                implicitPerms.append(": compat added ");
            } else {
                implicitPerms.append(' ');
            }
            implicitPerms.append(npi.name);
            pkg.requestedPermissions.add(npi.name);
        }
        if (implicitPerms != null) {
            Slog.i("PackageParser", implicitPerms.toString());
        }
        for (SplitPermissionInfo spi : SPLIT_PERMISSIONS) {
            if (pkg.applicationInfo.targetSdkVersion >= spi.targetSdk || !pkg.requestedPermissions.contains(spi.rootPerm)) continue;
            for (int in = 0; in < spi.newPerms.length; ++in) {
                String perm = spi.newPerms[in];
                if (pkg.requestedPermissions.contains(perm)) continue;
                pkg.requestedPermissions.add(perm);
            }
        }
        if (supportsSmallScreens < 0 || supportsSmallScreens > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x200;
        }
        if (supportsNormalScreens != 0) {
            pkg.applicationInfo.flags |= 0x400;
        }
        if (supportsLargeScreens < 0 || supportsLargeScreens > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x800;
        }
        if (supportsXLargeScreens < 0 || supportsXLargeScreens > 0 && pkg.applicationInfo.targetSdkVersion >= 9) {
            pkg.applicationInfo.flags |= 0x80000;
        }
        if (resizeable < 0 || resizeable > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x1000;
        }
        if (anyDensity < 0 || anyDensity > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x2000;
        }
        if (pkg.applicationInfo.usesCompatibilityMode()) {
            this.adjustPackageToBeUnresizeableAndUnpipable(pkg);
        }
        return pkg;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$checkOverlayRequiredSystemProperty(String propName, String propValue) {
        if (TextUtils.isEmpty(propName) || TextUtils.isEmpty(propValue)) {
            if (!TextUtils.isEmpty(propName) || !TextUtils.isEmpty(propValue)) {
                Slog.w("PackageParser", "Disabling overlay - incomplete property :'" + propName + "=" + propValue + "' - require both requiredSystemPropertyName AND requiredSystemPropertyValue to be specified.");
                return false;
            }
            return true;
        }
        String currValue = SystemProperties.get(propName);
        return currValue != null && currValue.equals(propValue);
    }

    private final void $$robo$$android_content_pm_PackageParser$adjustPackageToBeUnresizeableAndUnpipable(Package pkg) {
        for (Activity a : pkg.activities) {
            a.info.resizeMode = 0;
            a.info.flags &= 0xFFBFFFFF;
        }
    }

    private static final int $$robo$$android_content_pm_PackageParser$computeTargetSdkVersion(int targetVers, String targetCode, String[] platformSdkCodenames, String[] outError, boolean forceCurrentDev) {
        if (targetCode == null) {
            return targetVers;
        }
        if (ArrayUtils.contains(platformSdkCodenames, targetCode) || forceCurrentDev) {
            return 10000;
        }
        outError[0] = platformSdkCodenames.length > 0 ? "Requires development platform " + targetCode + " (current platform is any of " + Arrays.toString(platformSdkCodenames) + ")" : "Requires development platform " + targetCode + " but this is a release platform.";
        return -1;
    }

    private static final int $$robo$$android_content_pm_PackageParser$computeMinSdkVersion(int minVers, String minCode, int platformSdkVersion, String[] platformSdkCodenames, String[] outError) {
        if (minCode == null) {
            if (minVers <= platformSdkVersion) {
                return minVers;
            }
            outError[0] = "Requires newer sdk version #" + minVers + " (current version is #" + platformSdkVersion + ")";
            return -1;
        }
        if (ArrayUtils.contains(platformSdkCodenames, minCode)) {
            return 10000;
        }
        outError[0] = platformSdkCodenames.length > 0 ? "Requires development platform " + minCode + " (current platform is any of " + Arrays.toString(platformSdkCodenames) + ")" : "Requires development platform " + minCode + " but this is a release platform.";
        return -1;
    }

    private final FeatureInfo $$robo$$android_content_pm_PackageParser$parseUsesFeature(Resources res, AttributeSet attrs) {
        FeatureInfo fi = new FeatureInfo();
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesFeature);
        fi.name = sa.getNonResourceString(0);
        fi.version = sa.getInt(3, 0);
        if (fi.name == null) {
            fi.reqGlEsVersion = sa.getInt(1, 0);
        }
        if (sa.getBoolean(2, true)) {
            fi.flags |= 1;
        }
        sa.recycle();
        return fi;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseUsesStaticLibrary(Package pkg, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesStaticLibrary);
        String lname = sa.getNonResourceString(0);
        int version = sa.getInt(1, -1);
        String certSha256Digest = sa.getNonResourceString(2);
        sa.recycle();
        if (lname == null || version < 0 || certSha256Digest == null) {
            outError[0] = "Bad uses-static-library declaration name: " + lname + " version: " + version + " certDigest" + certSha256Digest;
            this.mParseError = -108;
            XmlUtils.skipCurrentTag(parser);
            return false;
        }
        if (pkg.usesStaticLibraries != null && pkg.usesStaticLibraries.contains(lname)) {
            outError[0] = "Depending on multiple versions of static library " + lname;
            this.mParseError = -108;
            XmlUtils.skipCurrentTag(parser);
            return false;
        }
        lname = lname.intern();
        certSha256Digest = certSha256Digest.replace(":", "").toLowerCase();
        String[] additionalCertSha256Digests = EmptyArray.STRING;
        if (pkg.applicationInfo.targetSdkVersion >= 27) {
            additionalCertSha256Digests = this.parseAdditionalCertificates(res, parser, outError);
            if (additionalCertSha256Digests == null) {
                return false;
            }
        } else {
            XmlUtils.skipCurrentTag(parser);
        }
        String[] certSha256Digests = new String[additionalCertSha256Digests.length + 1];
        certSha256Digests[0] = certSha256Digest;
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)additionalCertSha256Digests, (int)0, (Object)certSha256Digests, (int)1, (int)additionalCertSha256Digests.length);
        pkg.usesStaticLibraries = ArrayUtils.add(pkg.usesStaticLibraries, lname);
        pkg.usesStaticLibrariesVersions = ArrayUtils.appendLong(pkg.usesStaticLibrariesVersions, version, true);
        pkg.usesStaticLibrariesCertDigests = ArrayUtils.appendElement(String[].class, pkg.usesStaticLibrariesCertDigests, certSha256Digests, true);
        return true;
    }

    private final String[] $$robo$$android_content_pm_PackageParser$parseAdditionalCertificates(Resources resources, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String[] certSha256Digests = EmptyArray.STRING;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("additional-certificate")) {
                TypedArray sa = resources.obtainAttributes(parser, R.styleable.AndroidManifestAdditionalCertificate);
                String certSha256Digest = sa.getNonResourceString(0);
                sa.recycle();
                if (TextUtils.isEmpty(certSha256Digest)) {
                    outError[0] = "Bad additional-certificate declaration with empty certDigest:" + certSha256Digest;
                    this.mParseError = -108;
                    XmlUtils.skipCurrentTag(parser);
                    sa.recycle();
                    return null;
                }
                certSha256Digest = certSha256Digest.replace(":", "").toLowerCase();
                certSha256Digests = ArrayUtils.appendElement(String.class, certSha256Digests, certSha256Digest);
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
        return certSha256Digests;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseUsesPermission(Package pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesPermission);
        String name = sa.getNonResourceString(0);
        int maxSdkVersion = 0;
        TypedValue val = sa.peekValue(1);
        if (val != null && val.type >= 16 && val.type <= 31) {
            maxSdkVersion = val.data;
        }
        String requiredFeature = sa.getNonConfigurationString(2, 0);
        String requiredNotfeature = sa.getNonConfigurationString(3, 0);
        sa.recycle();
        XmlUtils.skipCurrentTag(parser);
        if (name == null) {
            return true;
        }
        if (maxSdkVersion != 0 && maxSdkVersion < Build.VERSION.RESOURCES_SDK_INT) {
            return true;
        }
        if (requiredFeature != null && this.mCallback != null && !this.mCallback.hasFeature(requiredFeature)) {
            return true;
        }
        if (requiredNotfeature != null && this.mCallback != null && this.mCallback.hasFeature(requiredNotfeature)) {
            return true;
        }
        int index = pkg.requestedPermissions.indexOf(name);
        if (index == -1) {
            pkg.requestedPermissions.add(name.intern());
        } else {
            Slog.w("PackageParser", "Ignoring duplicate uses-permissions/uses-permissions-sdk-m: " + name + " in package: " + pkg.packageName + " at: " + parser.getPositionDescription());
        }
        return true;
    }

    private static final String $$robo$$android_content_pm_PackageParser$buildClassName(String pkg, CharSequence clsSeq, String[] outError) {
        if (clsSeq == null || clsSeq.length() <= 0) {
            outError[0] = "Empty class name in package " + pkg;
            return null;
        }
        String cls = clsSeq.toString();
        char c = cls.charAt(0);
        if (c == '.') {
            return pkg + cls;
        }
        if (cls.indexOf(46) < 0) {
            StringBuilder b = new StringBuilder(pkg);
            b.append('.');
            b.append(cls);
            return b.toString();
        }
        return cls;
    }

    private static final String $$robo$$android_content_pm_PackageParser$buildCompoundName(String pkg, CharSequence procSeq, String type, String[] outError) {
        String proc = procSeq.toString();
        char c = proc.charAt(0);
        if (pkg != null && c == ':') {
            if (proc.length() < 2) {
                outError[0] = "Bad " + type + " name " + proc + " in package " + pkg + ": must be at least two characters";
                return null;
            }
            String subName = proc.substring(1);
            String nameError = PackageParser.validateName(subName, false, false);
            if (nameError != null) {
                outError[0] = "Invalid " + type + " name " + proc + " in package " + pkg + ": " + nameError;
                return null;
            }
            return pkg + proc;
        }
        String nameError = PackageParser.validateName(proc, true, false);
        if (nameError != null && !"system".equals(proc)) {
            outError[0] = "Invalid " + type + " name " + proc + " in package " + pkg + ": " + nameError;
            return null;
        }
        return proc;
    }

    private static final String $$robo$$android_content_pm_PackageParser$buildProcessName(String pkg, String defProc, CharSequence procSeq, int flags, String[] separateProcesses, String[] outError) {
        if ((flags & 2) != 0 && !"system".equals(procSeq)) {
            return defProc != null ? defProc : pkg;
        }
        if (separateProcesses != null) {
            for (int i = separateProcesses.length - 1; i >= 0; --i) {
                String sp = separateProcesses[i];
                if (!sp.equals(pkg) && !sp.equals(defProc) && !sp.equals(procSeq)) continue;
                return pkg;
            }
        }
        if (procSeq == null || procSeq.length() <= 0) {
            return defProc;
        }
        return TextUtils.safeIntern(PackageParser.buildCompoundName(pkg, procSeq, "process", outError));
    }

    private static final String $$robo$$android_content_pm_PackageParser$buildTaskAffinityName(String pkg, String defProc, CharSequence procSeq, String[] outError) {
        if (procSeq == null) {
            return defProc;
        }
        if (procSeq.length() <= 0) {
            return null;
        }
        return PackageParser.buildCompoundName(pkg, procSeq, "taskAffinity", outError);
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseKeySets(Package owner, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        int currentKeySetDepth = -1;
        String currentKeySet = null;
        ArrayMap<String, PublicKey> publicKeys = new ArrayMap<String, PublicKey>();
        ArraySet<String> upgradeKeySets = new ArraySet<String>();
        ArrayMap definedKeySets = new ArrayMap();
        ArraySet<String> improperKeySets = new ArraySet<String>();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            TypedArray sa;
            if (type == 3) {
                if (parser.getDepth() != currentKeySetDepth) continue;
                currentKeySet = null;
                currentKeySetDepth = -1;
                continue;
            }
            String tagName = parser.getName();
            if (tagName.equals("key-set")) {
                if (currentKeySet != null) {
                    outError[0] = "Improperly nested 'key-set' tag at " + parser.getPositionDescription();
                    this.mParseError = -108;
                    return false;
                }
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestKeySet);
                String keysetName = sa.getNonResourceString(0);
                definedKeySets.put(keysetName, new ArraySet());
                currentKeySet = keysetName;
                currentKeySetDepth = parser.getDepth();
                sa.recycle();
                continue;
            }
            if (tagName.equals("public-key")) {
                if (currentKeySet == null) {
                    outError[0] = "Improperly nested 'key-set' tag at " + parser.getPositionDescription();
                    this.mParseError = -108;
                    return false;
                }
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPublicKey);
                String publicKeyName = sa.getNonResourceString(0);
                String encodedKey = sa.getNonResourceString(1);
                if (encodedKey == null && publicKeys.get(publicKeyName) == null) {
                    outError[0] = "'public-key' " + publicKeyName + " must define a public-key value on first use at " + parser.getPositionDescription();
                    this.mParseError = -108;
                    sa.recycle();
                    return false;
                }
                if (encodedKey != null) {
                    PublicKey currentKey = PackageParser.parsePublicKey(encodedKey);
                    if (currentKey == null) {
                        Slog.w("PackageParser", "No recognized valid key in 'public-key' tag at " + parser.getPositionDescription() + " key-set " + currentKeySet + " will not be added to the package's defined key-sets.");
                        sa.recycle();
                        improperKeySets.add(currentKeySet);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    if (publicKeys.get(publicKeyName) == null || ((PublicKey)publicKeys.get(publicKeyName)).equals(currentKey)) {
                        publicKeys.put(publicKeyName, currentKey);
                    } else {
                        outError[0] = "Value of 'public-key' " + publicKeyName + " conflicts with previously defined value at " + parser.getPositionDescription();
                        this.mParseError = -108;
                        sa.recycle();
                        return false;
                    }
                }
                ((ArraySet)definedKeySets.get(currentKeySet)).add(publicKeyName);
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("upgrade-key-set")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUpgradeKeySet);
                String name = sa.getNonResourceString(0);
                upgradeKeySets.add(name);
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <key-sets>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        Set publicKeyNames = publicKeys.keySet();
        if (publicKeyNames.removeAll(definedKeySets.keySet())) {
            outError[0] = "Package" + owner.packageName + " AndroidManifext.xml 'key-set' and 'public-key' names must be distinct.";
            this.mParseError = -108;
            return false;
        }
        owner.mKeySetMapping = new ArrayMap();
        for (Map.Entry e : definedKeySets.entrySet()) {
            String keySetName = (String)e.getKey();
            if (((ArraySet)e.getValue()).size() == 0) {
                Slog.w("PackageParser", "Package" + owner.packageName + " AndroidManifext.xml 'key-set' " + keySetName + " has no valid associated 'public-key'. Not including in package's defined key-sets.");
                continue;
            }
            if (improperKeySets.contains(keySetName)) {
                Slog.w("PackageParser", "Package" + owner.packageName + " AndroidManifext.xml 'key-set' " + keySetName + " contained improper 'public-key' tags. Not including in package's defined key-sets.");
                continue;
            }
            owner.mKeySetMapping.put(keySetName, new ArraySet());
            for (String s : (ArraySet)e.getValue()) {
                owner.mKeySetMapping.get(keySetName).add((PublicKey)publicKeys.get(s));
            }
        }
        if (!owner.mKeySetMapping.keySet().containsAll(upgradeKeySets)) {
            outError[0] = "Package" + owner.packageName + " AndroidManifext.xml does not define all 'upgrade-key-set's .";
            this.mParseError = -108;
            return false;
        }
        owner.mUpgradeKeySets = upgradeKeySets;
        return true;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parsePermissionGroup(Package owner, int flags, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        PermissionGroup perm = new PermissionGroup(owner);
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermissionGroup);
        if (!PackageParser.parsePackageItemInfo(owner, perm.info, outError, "<permission-group>", sa, true, 2, 0, 1, 8, 5, 7)) {
            sa.recycle();
            this.mParseError = -108;
            return false;
        }
        perm.info.descriptionRes = sa.getResourceId(4, 0);
        perm.info.requestRes = sa.getResourceId(9, 0);
        perm.info.flags = sa.getInt(6, 0);
        perm.info.priority = sa.getInt(3, 0);
        sa.recycle();
        if (!this.parseAllMetaData(res, parser, "<permission-group>", perm, outError)) {
            this.mParseError = -108;
            return false;
        }
        owner.permissionGroups.add(perm);
        return true;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parsePermission(Package owner, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermission);
        Permission perm = new Permission(owner);
        if (!PackageParser.parsePackageItemInfo(owner, perm.info, outError, "<permission>", sa, true, 2, 0, 1, 9, 6, 8)) {
            sa.recycle();
            this.mParseError = -108;
            return false;
        }
        perm.info.group = sa.getNonResourceString(4);
        if (perm.info.group != null) {
            perm.info.group = perm.info.group.intern();
        }
        perm.info.descriptionRes = sa.getResourceId(5, 0);
        perm.info.requestRes = sa.getResourceId(10, 0);
        perm.info.protectionLevel = sa.getInt(3, 0);
        perm.info.flags = sa.getInt(7, 0);
        sa.recycle();
        if (perm.info.protectionLevel == -1) {
            outError[0] = "<permission> does not specify protectionLevel";
            this.mParseError = -108;
            return false;
        }
        perm.info.protectionLevel = PermissionInfo.fixProtectionLevel(perm.info.protectionLevel);
        if (perm.info.getProtectionFlags() != 0 && (perm.info.protectionLevel & 0x1000) == 0 && (perm.info.protectionLevel & 0x2000) == 0 && (perm.info.protectionLevel & 0xF) != 2) {
            outError[0] = "<permission>  protectionLevel specifies a non-instant flag but is not based on signature type";
            this.mParseError = -108;
            return false;
        }
        if (!this.parseAllMetaData(res, parser, "<permission>", perm, outError)) {
            this.mParseError = -108;
            return false;
        }
        owner.permissions.add(perm);
        return true;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parsePermissionTree(Package owner, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        Permission perm = new Permission(owner);
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermissionTree);
        if (!PackageParser.parsePackageItemInfo(owner, perm.info, outError, "<permission-tree>", sa, true, 2, 0, 1, 5, 3, 4)) {
            sa.recycle();
            this.mParseError = -108;
            return false;
        }
        sa.recycle();
        int index = perm.info.name.indexOf(46);
        if (index > 0) {
            index = perm.info.name.indexOf(46, index + 1);
        }
        if (index < 0) {
            outError[0] = "<permission-tree> name has less than three segments: " + perm.info.name;
            this.mParseError = -108;
            return false;
        }
        perm.info.descriptionRes = 0;
        perm.info.requestRes = 0;
        perm.info.protectionLevel = 0;
        perm.tree = true;
        if (!this.parseAllMetaData(res, parser, "<permission-tree>", perm, outError)) {
            this.mParseError = -108;
            return false;
        }
        owner.permissions.add(perm);
        return true;
    }

    private final Instrumentation $$robo$$android_content_pm_PackageParser$parseInstrumentation(Package owner, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestInstrumentation);
        if (this.mParseInstrumentationArgs == null) {
            this.mParseInstrumentationArgs = new ParsePackageItemArgs(owner, outError, 2, 0, 1, 8, 6, 7);
            this.mParseInstrumentationArgs.tag = "<instrumentation>";
        }
        this.mParseInstrumentationArgs.sa = sa;
        Instrumentation a = new Instrumentation(this.mParseInstrumentationArgs, new InstrumentationInfo());
        if (outError[0] != null) {
            sa.recycle();
            this.mParseError = -108;
            return null;
        }
        String str = sa.getNonResourceString(3);
        a.info.targetPackage = str != null ? str.intern() : null;
        str = sa.getNonResourceString(9);
        a.info.targetProcesses = str != null ? str.intern() : null;
        a.info.handleProfiling = sa.getBoolean(4, false);
        a.info.functionalTest = sa.getBoolean(5, false);
        sa.recycle();
        if (a.info.targetPackage == null) {
            outError[0] = "<instrumentation> does not specify targetPackage";
            this.mParseError = -108;
            return null;
        }
        if (!this.parseAllMetaData(res, parser, "<instrumentation>", a, outError)) {
            this.mParseError = -108;
            return null;
        }
        owner.instrumentation.add(a);
        return a;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseBaseApplication(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String requiredAccountType;
        String restrictedAccountType;
        String requiredFeature;
        boolean allowBackup;
        String manageSpaceActivity;
        ApplicationInfo ai = owner.applicationInfo;
        String pkgName = owner.applicationInfo.packageName;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestApplication);
        if (!PackageParser.parsePackageItemInfo(owner, ai, outError, "<application>", sa, false, 3, 1, 2, 42, 22, 30)) {
            sa.recycle();
            this.mParseError = -108;
            return false;
        }
        if (ai.name != null) {
            ai.className = ai.name;
        }
        if ((manageSpaceActivity = sa.getNonConfigurationString(4, 1024)) != null) {
            ai.manageSpaceActivityName = PackageParser.buildClassName(pkgName, manageSpaceActivity, outError);
        }
        if (allowBackup = sa.getBoolean(17, true)) {
            TypedValue v;
            ai.flags |= 0x8000;
            String backupAgent = sa.getNonConfigurationString(16, 1024);
            if (backupAgent != null) {
                ai.backupAgentName = PackageParser.buildClassName(pkgName, backupAgent, outError);
                if (sa.getBoolean(18, true)) {
                    ai.flags |= 0x10000;
                }
                if (sa.getBoolean(21, false)) {
                    ai.flags |= 0x20000;
                }
                if (sa.getBoolean(32, false)) {
                    ai.flags |= 0x4000000;
                }
                if (sa.getBoolean(40, false)) {
                    ai.privateFlags |= 0x2000;
                }
            }
            if ((v = sa.peekValue(35)) != null && (ai.fullBackupContent = v.resourceId) == 0) {
                ai.fullBackupContent = v.data == 0 ? -1 : 0;
            }
        }
        ai.theme = sa.getResourceId(0, 0);
        ai.descriptionRes = sa.getResourceId(13, 0);
        if (sa.getBoolean(8, false) && ((requiredFeature = sa.getNonResourceString(45)) == null || this.mCallback.hasFeature(requiredFeature))) {
            ai.flags |= 8;
        }
        if (sa.getBoolean(27, false)) {
            owner.mRequiredForAllUsers = true;
        }
        if ((restrictedAccountType = sa.getString(28)) != null && restrictedAccountType.length() > 0) {
            owner.mRestrictedAccountType = restrictedAccountType;
        }
        if ((requiredAccountType = sa.getString(29)) != null && requiredAccountType.length() > 0) {
            owner.mRequiredAccountType = requiredAccountType;
        }
        if (sa.getBoolean(10, false)) {
            ai.flags |= 2;
        }
        if (sa.getBoolean(20, false)) {
            ai.flags |= 0x4000;
        }
        owner.baseHardwareAccelerated = sa.getBoolean(23, owner.applicationInfo.targetSdkVersion >= 14);
        if (owner.baseHardwareAccelerated) {
            ai.flags |= 0x20000000;
        }
        if (sa.getBoolean(7, true)) {
            ai.flags |= 4;
        }
        if (sa.getBoolean(14, false)) {
            ai.flags |= 0x20;
        }
        if (sa.getBoolean(5, true)) {
            ai.flags |= 0x40;
        }
        if (owner.parentPackage == null && sa.getBoolean(15, false)) {
            ai.flags |= 0x100;
        }
        if (sa.getBoolean(24, false)) {
            ai.flags |= 0x100000;
        }
        if (sa.getBoolean(36, owner.applicationInfo.targetSdkVersion < 28)) {
            ai.flags |= 0x8000000;
        }
        if (sa.getBoolean(26, false)) {
            ai.flags |= 0x400000;
        }
        if (sa.getBoolean(33, false)) {
            ai.flags |= Integer.MIN_VALUE;
        }
        if (sa.getBoolean(34, true)) {
            ai.flags |= 0x10000000;
        }
        if (sa.getBoolean(38, false)) {
            ai.privateFlags |= 0x20;
        }
        if (sa.getBoolean(39, false)) {
            ai.privateFlags |= 0x40;
        }
        if (sa.hasValueOrEmpty(37)) {
            ai.privateFlags = sa.getBoolean(37, true) ? (ai.privateFlags |= 0x400) : (ai.privateFlags |= 0x800);
        } else if (owner.applicationInfo.targetSdkVersion >= 24) {
            ai.privateFlags |= 0x1000;
        }
        ai.maxAspectRatio = sa.getFloat(44, 0.0f);
        ai.networkSecurityConfigRes = sa.getResourceId(41, 0);
        ai.category = sa.getInt(43, -1);
        String str = sa.getNonConfigurationString(6, 0);
        ai.permission = str != null && str.length() > 0 ? str.intern() : null;
        str = owner.applicationInfo.targetSdkVersion >= 8 ? sa.getNonConfigurationString(12, 1024) : sa.getNonResourceString(12);
        ai.taskAffinity = PackageParser.buildTaskAffinityName(ai.packageName, ai.packageName, str, outError);
        String factory = sa.getNonResourceString(48);
        if (factory != null) {
            ai.appComponentFactory = PackageParser.buildClassName(ai.packageName, factory, outError);
        }
        if (outError[0] == null) {
            String pname = owner.applicationInfo.targetSdkVersion >= 8 ? sa.getNonConfigurationString(11, 1024) : sa.getNonResourceString(11);
            ai.processName = PackageParser.buildProcessName(ai.packageName, null, pname, flags, this.mSeparateProcesses, outError);
            ai.enabled = sa.getBoolean(9, true);
            if (sa.getBoolean(31, false)) {
                ai.flags |= 0x2000000;
            }
            if (sa.getBoolean(47, false)) {
                ai.privateFlags |= 2;
                if (ai.processName != null && !ai.processName.equals(ai.packageName)) {
                    outError[0] = "cantSaveState applications can not use custom processes";
                }
            }
        }
        ai.uiOptions = sa.getInt(25, 0);
        ai.classLoaderName = sa.getString(46);
        if (ai.classLoaderName != null && !ClassLoaderFactory.isValidClassLoaderName(ai.classLoaderName)) {
            outError[0] = "Invalid class loader name: " + ai.classLoaderName;
        }
        sa.recycle();
        if (outError[0] != null) {
            this.mParseError = -108;
            return false;
        }
        int innerDepth = parser.getDepth();
        CachedComponentArgs cachedArgs = new CachedComponentArgs();
        boolean hasActivityOrder = false;
        boolean hasReceiverOrder = false;
        boolean hasServiceOrder = false;
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
            String lname;
            Activity a;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("activity")) {
                a = this.parseActivity(owner, res, parser, flags, outError, cachedArgs, false, owner.baseHardwareAccelerated);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                hasActivityOrder |= a.order != 0;
                owner.activities.add(a);
                continue;
            }
            if (tagName.equals("receiver")) {
                a = this.parseActivity(owner, res, parser, flags, outError, cachedArgs, true, false);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                hasReceiverOrder |= a.order != 0;
                owner.receivers.add(a);
                continue;
            }
            if (tagName.equals("service")) {
                Service s = this.parseService(owner, res, parser, flags, outError, cachedArgs);
                if (s == null) {
                    this.mParseError = -108;
                    return false;
                }
                hasServiceOrder |= s.order != 0;
                owner.services.add(s);
                continue;
            }
            if (tagName.equals("provider")) {
                Provider p = this.parseProvider(owner, res, parser, flags, outError, cachedArgs);
                if (p == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.providers.add(p);
                continue;
            }
            if (tagName.equals("activity-alias")) {
                a = this.parseActivityAlias(owner, res, parser, flags, outError, cachedArgs);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                hasActivityOrder |= a.order != 0;
                owner.activities.add(a);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                owner.mAppMetaData = this.parseMetaData(res, parser, owner.mAppMetaData, outError);
                if (owner.mAppMetaData != null) continue;
                this.mParseError = -108;
                return false;
            }
            if (tagName.equals("static-library")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestStaticLibrary);
                lname = sa.getNonResourceString(0);
                int version = sa.getInt(1, -1);
                int versionMajor = sa.getInt(2, 0);
                sa.recycle();
                if (lname == null || version < 0) {
                    outError[0] = "Bad static-library declaration name: " + lname + " version: " + version;
                    this.mParseError = -108;
                    XmlUtils.skipCurrentTag(parser);
                    return false;
                }
                if (owner.mSharedUserId != null) {
                    outError[0] = "sharedUserId not allowed in static shared library";
                    this.mParseError = -107;
                    XmlUtils.skipCurrentTag(parser);
                    return false;
                }
                if (owner.staticSharedLibName != null) {
                    outError[0] = "Multiple static-shared libs for package " + pkgName;
                    this.mParseError = -108;
                    XmlUtils.skipCurrentTag(parser);
                    return false;
                }
                owner.staticSharedLibName = lname.intern();
                owner.staticSharedLibVersion = version >= 0 ? PackageInfo.composeLongVersionCode(versionMajor, version) : (long)version;
                ai.privateFlags |= 0x4000;
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("library")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestLibrary);
                lname = sa.getNonResourceString(0);
                sa.recycle();
                if (lname != null && !ArrayUtils.contains(owner.libraryNames, lname = lname.intern())) {
                    owner.libraryNames = ArrayUtils.add(owner.libraryNames, lname);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-static-library")) {
                if (this.parseUsesStaticLibrary(owner, res, parser, outError)) continue;
                return false;
            }
            if (tagName.equals("uses-library")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesLibrary);
                lname = sa.getNonResourceString(0);
                boolean req = sa.getBoolean(1, true);
                sa.recycle();
                if (lname != null) {
                    lname = lname.intern();
                    if (req) {
                        owner.usesLibraries = ArrayUtils.add(owner.usesLibraries, lname);
                    } else {
                        owner.usesOptionalLibraries = ArrayUtils.add(owner.usesOptionalLibraries, lname);
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-package")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <application>: " + tagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (hasActivityOrder) {
            Collections.sort(owner.activities, (a1, a2) -> Integer.compare(a2.order, a1.order));
        }
        if (hasReceiverOrder) {
            Collections.sort(owner.receivers, (r1, r2) -> Integer.compare(r2.order, r1.order));
        }
        if (hasServiceOrder) {
            Collections.sort(owner.services, (s1, s2) -> Integer.compare(s2.order, s1.order));
        }
        this.setMaxAspectRatio(owner);
        PackageBackwardCompatibility.modifySharedLibraries(owner);
        owner.applicationInfo.privateFlags = PackageParser.hasDomainURLs(owner) ? (owner.applicationInfo.privateFlags |= 0x10) : (owner.applicationInfo.privateFlags &= 0xFFFFFFEF);
        return true;
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$hasDomainURLs(Package pkg) {
        if (pkg == null || pkg.activities == null) {
            return false;
        }
        ArrayList<Activity> activities = pkg.activities;
        int countActivities = activities.size();
        for (int n = 0; n < countActivities; ++n) {
            Activity activity = activities.get(n);
            ArrayList filters = activity.intents;
            if (filters == null) continue;
            int countFilters = filters.size();
            for (int m = 0; m < countFilters; ++m) {
                ActivityIntentInfo aii = (ActivityIntentInfo)filters.get(m);
                if (!aii.hasAction("android.intent.action.VIEW") || !aii.hasAction("android.intent.action.VIEW") || !aii.hasDataScheme("http") && !aii.hasDataScheme("https")) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseSplitApplication(Package owner, Resources res, XmlResourceParser parser, int flags, int splitIndex, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String classLoaderName;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestApplication);
        if (sa.getBoolean(7, true)) {
            int n = splitIndex;
            owner.splitFlags[n] = owner.splitFlags[n] | 4;
        }
        if ((classLoaderName = sa.getString(46)) != null && !ClassLoaderFactory.isValidClassLoaderName(classLoaderName)) {
            outError[0] = "Invalid class loader name: " + classLoaderName;
            this.mParseError = -108;
            return false;
        }
        owner.applicationInfo.splitClassLoaderNames[splitIndex] = classLoaderName;
        int innerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
            Activity a;
            if (type == 3 || type == 4) continue;
            ComponentInfo parsedComponent = null;
            CachedComponentArgs cachedArgs = new CachedComponentArgs();
            String tagName = parser.getName();
            if (tagName.equals("activity")) {
                a = this.parseActivity(owner, res, parser, flags, outError, cachedArgs, false, owner.baseHardwareAccelerated);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.activities.add(a);
                parsedComponent = a.info;
            } else if (tagName.equals("receiver")) {
                a = this.parseActivity(owner, res, parser, flags, outError, cachedArgs, true, false);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.receivers.add(a);
                parsedComponent = a.info;
            } else if (tagName.equals("service")) {
                Service s = this.parseService(owner, res, parser, flags, outError, cachedArgs);
                if (s == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.services.add(s);
                parsedComponent = s.info;
            } else if (tagName.equals("provider")) {
                Provider p = this.parseProvider(owner, res, parser, flags, outError, cachedArgs);
                if (p == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.providers.add(p);
                parsedComponent = p.info;
            } else if (tagName.equals("activity-alias")) {
                a = this.parseActivityAlias(owner, res, parser, flags, outError, cachedArgs);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.activities.add(a);
                parsedComponent = a.info;
            } else if (parser.getName().equals("meta-data")) {
                owner.mAppMetaData = this.parseMetaData(res, parser, owner.mAppMetaData, outError);
                if (owner.mAppMetaData == null) {
                    this.mParseError = -108;
                    return false;
                }
            } else if (tagName.equals("uses-static-library")) {
                if (!this.parseUsesStaticLibrary(owner, res, parser, outError)) {
                    return false;
                }
            } else if (tagName.equals("uses-library")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesLibrary);
                String lname = sa.getNonResourceString(0);
                boolean req = sa.getBoolean(1, true);
                sa.recycle();
                if (lname != null) {
                    lname = lname.intern();
                    if (req) {
                        owner.usesLibraries = ArrayUtils.add(owner.usesLibraries, lname);
                        owner.usesOptionalLibraries = ArrayUtils.remove(owner.usesOptionalLibraries, lname);
                    } else if (!ArrayUtils.contains(owner.usesLibraries, lname)) {
                        owner.usesOptionalLibraries = ArrayUtils.add(owner.usesOptionalLibraries, lname);
                    }
                }
                XmlUtils.skipCurrentTag(parser);
            } else if (tagName.equals("uses-package")) {
                XmlUtils.skipCurrentTag(parser);
            } else {
                Slog.w("PackageParser", "Unknown element under <application>: " + tagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (parsedComponent == null || parsedComponent.splitName != null) continue;
            parsedComponent.splitName = owner.splitNames[splitIndex];
        }
        return true;
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$parsePackageItemInfo(Package owner, PackageItemInfo outInfo, String[] outError, String tag, TypedArray sa, boolean nameRequired, int nameRes, int labelRes, int iconRes, int roundIconRes, int logoRes, int bannerRes) {
        TypedValue v;
        int bannerVal;
        boolean useRoundIcon;
        int roundIconVal;
        if (sa == null) {
            outError[0] = tag + " does not contain any attributes";
            return false;
        }
        String name = sa.getNonConfigurationString(nameRes, 0);
        if (name == null) {
            if (nameRequired) {
                outError[0] = tag + " does not specify android:name";
                return false;
            }
        } else {
            outInfo.name = PackageParser.buildClassName(owner.applicationInfo.packageName, name, outError);
            if (outInfo.name == null) {
                return false;
            }
        }
        int n = roundIconVal = (useRoundIcon = Resources.getSystem().getBoolean(17957064)) ? sa.getResourceId(roundIconRes, 0) : 0;
        if (roundIconVal != 0) {
            outInfo.icon = roundIconVal;
            outInfo.nonLocalizedLabel = null;
        } else {
            int iconVal = sa.getResourceId(iconRes, 0);
            if (iconVal != 0) {
                outInfo.icon = iconVal;
                outInfo.nonLocalizedLabel = null;
            }
        }
        int logoVal = sa.getResourceId(logoRes, 0);
        if (logoVal != 0) {
            outInfo.logo = logoVal;
        }
        if ((bannerVal = sa.getResourceId(bannerRes, 0)) != 0) {
            outInfo.banner = bannerVal;
        }
        if ((v = sa.peekValue(labelRes)) != null && (outInfo.labelRes = v.resourceId) == 0) {
            outInfo.nonLocalizedLabel = v.coerceToString();
        }
        outInfo.packageName = owner.packageName;
        return true;
    }

    private final Activity $$robo$$android_content_pm_PackageParser$parseActivity(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError, CachedComponentArgs cachedArgs, boolean receiver, boolean hardwareAccelerated) throws XmlPullParserException, IOException {
        int type;
        boolean visibleToEphemeral;
        String str;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestActivity);
        if (cachedArgs.mActivityArgs == null) {
            cachedArgs.mActivityArgs = new ParseComponentArgs(owner, outError, 3, 1, 2, 44, 23, 30, this.mSeparateProcesses, 7, 17, 5);
        }
        cachedArgs.mActivityArgs.tag = receiver ? "<receiver>" : "<activity>";
        cachedArgs.mActivityArgs.sa = sa;
        cachedArgs.mActivityArgs.flags = flags;
        Activity a = new Activity(cachedArgs.mActivityArgs, new ActivityInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(6);
        if (setExported) {
            a.info.exported = sa.getBoolean(6, false);
        }
        a.info.theme = sa.getResourceId(0, 0);
        a.info.uiOptions = sa.getInt(26, a.info.applicationInfo.uiOptions);
        String parentName = sa.getNonConfigurationString(27, 1024);
        if (parentName != null) {
            String parentClassName = PackageParser.buildClassName(a.info.packageName, parentName, outError);
            if (outError[0] == null) {
                a.info.parentActivityName = parentClassName;
            } else {
                Log.e("PackageParser", "Activity " + a.info.name + " specified invalid parentActivityName " + parentName);
                outError[0] = null;
            }
        }
        a.info.permission = (str = sa.getNonConfigurationString(4, 0)) == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        str = sa.getNonConfigurationString(8, 1024);
        a.info.taskAffinity = PackageParser.buildTaskAffinityName(owner.applicationInfo.packageName, owner.applicationInfo.taskAffinity, str, outError);
        a.info.splitName = sa.getNonConfigurationString(48, 0);
        a.info.flags = 0;
        if (sa.getBoolean(9, false)) {
            a.info.flags |= 1;
        }
        if (sa.getBoolean(10, false)) {
            a.info.flags |= 2;
        }
        if (sa.getBoolean(11, false)) {
            a.info.flags |= 4;
        }
        if (sa.getBoolean(21, false)) {
            a.info.flags |= 0x80;
        }
        if (sa.getBoolean(18, false)) {
            a.info.flags |= 8;
        }
        if (sa.getBoolean(12, false)) {
            a.info.flags |= 0x10;
        }
        if (sa.getBoolean(13, false)) {
            a.info.flags |= 0x20;
        }
        if (sa.getBoolean(19, (owner.applicationInfo.flags & 0x20) != 0)) {
            a.info.flags |= 0x40;
        }
        if (sa.getBoolean(22, false)) {
            a.info.flags |= 0x100;
        }
        if (sa.getBoolean(29, false) || sa.getBoolean(39, false)) {
            a.info.flags |= 0x400;
        }
        if (sa.getBoolean(24, false)) {
            a.info.flags |= 0x800;
        }
        if (sa.getBoolean(54, false)) {
            a.info.flags |= 0x20000000;
        }
        if (!receiver) {
            if (sa.getBoolean(25, hardwareAccelerated)) {
                a.info.flags |= 0x200;
            }
            a.info.launchMode = sa.getInt(14, 0);
            a.info.documentLaunchMode = sa.getInt(33, 0);
            a.info.maxRecents = sa.getInt(34, ActivityManager.getDefaultAppRecentsLimitStatic());
            a.info.configChanges = PackageParser.getActivityConfigChanges(sa.getInt(16, 0), sa.getInt(47, 0));
            a.info.softInputMode = sa.getInt(20, 0);
            a.info.persistableMode = sa.getInteger(32, 0);
            if (sa.getBoolean(31, false)) {
                a.info.flags |= Integer.MIN_VALUE;
            }
            if (sa.getBoolean(35, false)) {
                a.info.flags |= 0x2000;
            }
            if (sa.getBoolean(36, false)) {
                a.info.flags |= 0x1000;
            }
            if (sa.getBoolean(37, false)) {
                a.info.flags |= 0x4000;
            }
            a.info.screenOrientation = sa.getInt(15, -1);
            this.setActivityResizeMode(a.info, sa, owner);
            if (sa.getBoolean(41, false)) {
                a.info.flags |= 0x400000;
            }
            if (sa.getBoolean(53, false)) {
                a.info.flags |= 0x40000;
            }
            if (sa.hasValue(50) && sa.getType(50) == 4) {
                a.setMaxAspectRatio(sa.getFloat(50, 0.0f));
            }
            a.info.lockTaskLaunchMode = sa.getInt(38, 0);
            a.info.encryptionAware = a.info.directBootAware = sa.getBoolean(42, false);
            a.info.requestedVrComponent = sa.getString(43);
            a.info.rotationAnimation = sa.getInt(46, -1);
            a.info.colorMode = sa.getInt(49, 0);
            if (sa.getBoolean(51, false)) {
                a.info.flags |= 0x800000;
            }
            if (sa.getBoolean(52, false)) {
                a.info.flags |= 0x1000000;
            }
        } else {
            a.info.launchMode = 0;
            a.info.configChanges = 0;
            if (sa.getBoolean(28, false)) {
                a.info.flags |= 0x40000000;
            }
            a.info.encryptionAware = a.info.directBootAware = sa.getBoolean(42, false);
        }
        if (a.info.directBootAware) {
            owner.applicationInfo.privateFlags |= 0x100;
        }
        if (visibleToEphemeral = sa.getBoolean(45, false)) {
            a.info.flags |= 0x100000;
            owner.visibleToInstantApps = true;
        }
        sa.recycle();
        if (receiver && (owner.applicationInfo.privateFlags & 2) != 0 && a.info.processName == owner.packageName) {
            outError[0] = "Heavy-weight applications can not have receivers in main process";
        }
        if (outError[0] != null) {
            return null;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            int visibility;
            ActivityIntentInfo intent;
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                intent = new ActivityIntentInfo(a);
                if (!this.parseIntent(res, parser, true, true, intent, outError)) {
                    return null;
                }
                if (intent.countActions() == 0) {
                    Slog.w("PackageParser", "No actions in intent filter at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                } else {
                    a.order = Math.max(intent.getOrder(), a.order);
                    a.intents.add(intent);
                }
                visibility = visibleToEphemeral ? 1 : (!receiver && this.isImplicitlyExposedIntent(intent) ? 2 : 0);
                intent.setVisibilityToInstantApp(visibility);
                if (intent.isVisibleToInstantApp()) {
                    a.info.flags |= 0x100000;
                }
                if (!intent.isImplicitlyVisibleToInstantApp()) continue;
                a.info.flags |= 0x200000;
                continue;
            }
            if (!receiver && parser.getName().equals("preferred")) {
                intent = new ActivityIntentInfo(a);
                if (!this.parseIntent(res, parser, false, false, intent, outError)) {
                    return null;
                }
                if (intent.countActions() == 0) {
                    Slog.w("PackageParser", "No actions in preferred at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                } else {
                    if (owner.preferredActivityFilters == null) {
                        owner.preferredActivityFilters = new ArrayList();
                    }
                    owner.preferredActivityFilters.add(intent);
                }
                visibility = visibleToEphemeral ? 1 : (!receiver && this.isImplicitlyExposedIntent(intent) ? 2 : 0);
                intent.setVisibilityToInstantApp(visibility);
                if (intent.isVisibleToInstantApp()) {
                    a.info.flags |= 0x100000;
                }
                if (!intent.isImplicitlyVisibleToInstantApp()) continue;
                a.info.flags |= 0x200000;
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                a.metaData = this.parseMetaData(res, parser, a.metaData, outError);
                if (a.metaData != null) continue;
                return null;
            }
            if (!receiver && parser.getName().equals("layout")) {
                this.parseLayout(res, parser, a);
                continue;
            }
            Slog.w("PackageParser", "Problem in package " + this.mArchiveSourcePath + ":");
            if (receiver) {
                Slog.w("PackageParser", "Unknown element under <receiver>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            } else {
                Slog.w("PackageParser", "Unknown element under <activity>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            }
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            a.info.exported = a.intents.size() > 0;
        }
        return a;
    }

    private final void $$robo$$android_content_pm_PackageParser$setActivityResizeMode(ActivityInfo aInfo, TypedArray sa, Package owner) {
        boolean appExplicitDefault;
        boolean bl = appExplicitDefault = (owner.applicationInfo.privateFlags & 0xC00) != 0;
        if (sa.hasValue(40) || appExplicitDefault) {
            boolean appResizeable = (owner.applicationInfo.privateFlags & 0x400) != 0;
            aInfo.resizeMode = sa.getBoolean(40, appResizeable) ? 2 : 0;
            return;
        }
        if ((owner.applicationInfo.privateFlags & 0x1000) != 0) {
            aInfo.resizeMode = 1;
            return;
        }
        aInfo.resizeMode = aInfo.isFixedOrientationPortrait() ? 6 : (aInfo.isFixedOrientationLandscape() ? 5 : (aInfo.isFixedOrientation() ? 7 : 4));
    }

    private final void $$robo$$android_content_pm_PackageParser$setMaxAspectRatio(Package owner) {
        float maxAspectRatio;
        float f = maxAspectRatio = owner.applicationInfo.targetSdkVersion < 26 ? 1.86f : 0.0f;
        if (owner.applicationInfo.maxAspectRatio != 0.0f) {
            maxAspectRatio = owner.applicationInfo.maxAspectRatio;
        } else if (owner.mAppMetaData != null && owner.mAppMetaData.containsKey("android.max_aspect")) {
            maxAspectRatio = owner.mAppMetaData.getFloat("android.max_aspect", maxAspectRatio);
        }
        for (Activity activity : owner.activities) {
            if (activity.hasMaxAspectRatio()) continue;
            float activityAspectRatio = activity.metaData != null ? activity.metaData.getFloat("android.max_aspect", maxAspectRatio) : maxAspectRatio;
            activity.setMaxAspectRatio(activityAspectRatio);
        }
    }

    private static final int $$robo$$android_content_pm_PackageParser$getActivityConfigChanges(int configChanges, int recreateOnConfigChanges) {
        return configChanges | ~recreateOnConfigChanges & 3;
    }

    private final void $$robo$$android_content_pm_PackageParser$parseLayout(Resources res, AttributeSet attrs, Activity a) {
        TypedArray sw = res.obtainAttributes(attrs, R.styleable.AndroidManifestLayout);
        int width = -1;
        float widthFraction = -1.0f;
        int height = -1;
        float heightFraction = -1.0f;
        int widthType = sw.getType(3);
        if (widthType == 6) {
            widthFraction = sw.getFraction(3, 1, 1, -1.0f);
        } else if (widthType == 5) {
            width = sw.getDimensionPixelSize(3, -1);
        }
        int heightType = sw.getType(4);
        if (heightType == 6) {
            heightFraction = sw.getFraction(4, 1, 1, -1.0f);
        } else if (heightType == 5) {
            height = sw.getDimensionPixelSize(4, -1);
        }
        int gravity = sw.getInt(0, 17);
        int minWidth = sw.getDimensionPixelSize(1, -1);
        int minHeight = sw.getDimensionPixelSize(2, -1);
        sw.recycle();
        a.info.windowLayout = new ActivityInfo.WindowLayout(width, widthFraction, height, heightFraction, gravity, minWidth, minHeight);
    }

    private final Activity $$robo$$android_content_pm_PackageParser$parseActivityAlias(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError, CachedComponentArgs cachedArgs) throws XmlPullParserException, IOException {
        int type;
        String parentName;
        String str;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestActivityAlias);
        String targetActivity = sa.getNonConfigurationString(7, 1024);
        if (targetActivity == null) {
            outError[0] = "<activity-alias> does not specify android:targetActivity";
            sa.recycle();
            return null;
        }
        if ((targetActivity = PackageParser.buildClassName(owner.applicationInfo.packageName, targetActivity, outError)) == null) {
            sa.recycle();
            return null;
        }
        if (cachedArgs.mActivityAliasArgs == null) {
            cachedArgs.mActivityAliasArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, 11, 8, 10, this.mSeparateProcesses, 0, 6, 4);
            cachedArgs.mActivityAliasArgs.tag = "<activity-alias>";
        }
        cachedArgs.mActivityAliasArgs.sa = sa;
        cachedArgs.mActivityAliasArgs.flags = flags;
        Activity target = null;
        int NA = owner.activities.size();
        for (int i = 0; i < NA; ++i) {
            Activity t = owner.activities.get(i);
            if (!targetActivity.equals(t.info.name)) continue;
            target = t;
            break;
        }
        if (target == null) {
            outError[0] = "<activity-alias> target activity " + targetActivity + " not found in manifest";
            sa.recycle();
            return null;
        }
        ActivityInfo info = new ActivityInfo();
        info.targetActivity = targetActivity;
        info.configChanges = target.info.configChanges;
        info.flags = target.info.flags;
        info.icon = target.info.icon;
        info.logo = target.info.logo;
        info.banner = target.info.banner;
        info.labelRes = target.info.labelRes;
        info.nonLocalizedLabel = target.info.nonLocalizedLabel;
        info.launchMode = target.info.launchMode;
        info.lockTaskLaunchMode = target.info.lockTaskLaunchMode;
        info.processName = target.info.processName;
        if (info.descriptionRes == 0) {
            info.descriptionRes = target.info.descriptionRes;
        }
        info.screenOrientation = target.info.screenOrientation;
        info.taskAffinity = target.info.taskAffinity;
        info.theme = target.info.theme;
        info.softInputMode = target.info.softInputMode;
        info.uiOptions = target.info.uiOptions;
        info.parentActivityName = target.info.parentActivityName;
        info.maxRecents = target.info.maxRecents;
        info.windowLayout = target.info.windowLayout;
        info.resizeMode = target.info.resizeMode;
        info.maxAspectRatio = target.info.maxAspectRatio;
        info.requestedVrComponent = target.info.requestedVrComponent;
        info.encryptionAware = info.directBootAware = target.info.directBootAware;
        Activity a = new Activity(cachedArgs.mActivityAliasArgs, info);
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(5);
        if (setExported) {
            a.info.exported = sa.getBoolean(5, false);
        }
        if ((str = sa.getNonConfigurationString(3, 0)) != null) {
            String string2 = a.info.permission = str.length() > 0 ? str.toString().intern() : null;
        }
        if ((parentName = sa.getNonConfigurationString(9, 1024)) != null) {
            String parentClassName = PackageParser.buildClassName(a.info.packageName, parentName, outError);
            if (outError[0] == null) {
                a.info.parentActivityName = parentClassName;
            } else {
                Log.e("PackageParser", "Activity alias " + a.info.name + " specified invalid parentActivityName " + parentName);
                outError[0] = null;
            }
        }
        boolean visibleToEphemeral = (a.info.flags & 0x100000) != 0;
        sa.recycle();
        if (outError[0] != null) {
            return null;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ActivityIntentInfo intent = new ActivityIntentInfo(a);
                if (!this.parseIntent(res, parser, true, true, intent, outError)) {
                    return null;
                }
                if (intent.countActions() == 0) {
                    Slog.w("PackageParser", "No actions in intent filter at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                } else {
                    a.order = Math.max(intent.getOrder(), a.order);
                    a.intents.add(intent);
                }
                int visibility = visibleToEphemeral ? 1 : (this.isImplicitlyExposedIntent(intent) ? 2 : 0);
                intent.setVisibilityToInstantApp(visibility);
                if (intent.isVisibleToInstantApp()) {
                    a.info.flags |= 0x100000;
                }
                if (!intent.isImplicitlyVisibleToInstantApp()) continue;
                a.info.flags |= 0x200000;
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                a.metaData = this.parseMetaData(res, parser, a.metaData, outError);
                if (a.metaData != null) continue;
                return null;
            }
            Slog.w("PackageParser", "Unknown element under <activity-alias>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            a.info.exported = a.intents.size() > 0;
        }
        return a;
    }

    private final Provider $$robo$$android_content_pm_PackageParser$parseProvider(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError, CachedComponentArgs cachedArgs) throws XmlPullParserException, IOException {
        boolean visibleToEphemeral;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProvider);
        if (cachedArgs.mProviderArgs == null) {
            cachedArgs.mProviderArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, 19, 15, 17, this.mSeparateProcesses, 8, 14, 6);
            cachedArgs.mProviderArgs.tag = "<provider>";
        }
        cachedArgs.mProviderArgs.sa = sa;
        cachedArgs.mProviderArgs.flags = flags;
        Provider p = new Provider(cachedArgs.mProviderArgs, new ProviderInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean providerExportedDefault = false;
        if (owner.applicationInfo.targetSdkVersion < 17) {
            providerExportedDefault = true;
        }
        p.info.exported = sa.getBoolean(7, providerExportedDefault);
        String cpname = sa.getNonConfigurationString(10, 0);
        p.info.isSyncable = sa.getBoolean(11, false);
        String permission2 = sa.getNonConfigurationString(3, 0);
        String str = sa.getNonConfigurationString(4, 0);
        if (str == null) {
            str = permission2;
        }
        p.info.readPermission = str == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        str = sa.getNonConfigurationString(5, 0);
        if (str == null) {
            str = permission2;
        }
        p.info.writePermission = str == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        p.info.grantUriPermissions = sa.getBoolean(13, false);
        p.info.multiprocess = sa.getBoolean(9, false);
        p.info.initOrder = sa.getInt(12, 0);
        p.info.splitName = sa.getNonConfigurationString(21, 0);
        p.info.flags = 0;
        if (sa.getBoolean(16, false)) {
            p.info.flags |= 0x40000000;
        }
        p.info.encryptionAware = p.info.directBootAware = sa.getBoolean(18, false);
        if (p.info.directBootAware) {
            owner.applicationInfo.privateFlags |= 0x100;
        }
        if (visibleToEphemeral = sa.getBoolean(20, false)) {
            p.info.flags |= 0x100000;
            owner.visibleToInstantApps = true;
        }
        sa.recycle();
        if ((owner.applicationInfo.privateFlags & 2) != 0 && p.info.processName == owner.packageName) {
            outError[0] = "Heavy-weight applications can not have providers in main process";
            return null;
        }
        if (cpname == null) {
            outError[0] = "<provider> does not include authorities attribute";
            return null;
        }
        if (cpname.length() <= 0) {
            outError[0] = "<provider> has empty authorities attribute";
            return null;
        }
        p.info.authority = cpname.intern();
        if (!this.parseProviderTags(res, parser, visibleToEphemeral, p, outError)) {
            return null;
        }
        return p;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseProviderTags(Resources res, XmlResourceParser parser, boolean visibleToEphemeral, Provider outInfo, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            PatternMatcher pa;
            TypedArray sa;
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ProviderIntentInfo intent = new ProviderIntentInfo(outInfo);
                if (!this.parseIntent(res, parser, true, false, intent, outError)) {
                    return false;
                }
                if (visibleToEphemeral) {
                    intent.setVisibilityToInstantApp(1);
                    outInfo.info.flags |= 0x100000;
                }
                outInfo.order = Math.max(intent.getOrder(), outInfo.order);
                outInfo.intents.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                outInfo.metaData = this.parseMetaData(res, parser, outInfo.metaData, outError);
                if (outInfo.metaData != null) continue;
                return false;
            }
            if (parser.getName().equals("grant-uri-permission")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestGrantUriPermission);
                pa = null;
                String str = sa.getNonConfigurationString(0, 0);
                if (str != null) {
                    pa = new PatternMatcher(str, 0);
                }
                if ((str = sa.getNonConfigurationString(1, 0)) != null) {
                    pa = new PatternMatcher(str, 1);
                }
                if ((str = sa.getNonConfigurationString(2, 0)) != null) {
                    pa = new PatternMatcher(str, 2);
                }
                sa.recycle();
                if (pa != null) {
                    if (outInfo.info.uriPermissionPatterns == null) {
                        outInfo.info.uriPermissionPatterns = new PatternMatcher[1];
                        outInfo.info.uriPermissionPatterns[0] = pa;
                    } else {
                        int N = outInfo.info.uriPermissionPatterns.length;
                        PatternMatcher[] newp = new PatternMatcher[N + 1];
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)outInfo.info.uriPermissionPatterns, (int)0, (Object)newp, (int)0, (int)N);
                        newp[N] = pa;
                        outInfo.info.uriPermissionPatterns = newp;
                    }
                } else {
                    Slog.w("PackageParser", "Unknown element under <path-permission>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                outInfo.info.grantUriPermissions = true;
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (parser.getName().equals("path-permission")) {
                String writePermission;
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPathPermission);
                pa = null;
                String permission2 = sa.getNonConfigurationString(0, 0);
                String readPermission = sa.getNonConfigurationString(1, 0);
                if (readPermission == null) {
                    readPermission = permission2;
                }
                if ((writePermission = sa.getNonConfigurationString(2, 0)) == null) {
                    writePermission = permission2;
                }
                boolean havePerm = false;
                if (readPermission != null) {
                    readPermission = readPermission.intern();
                    havePerm = true;
                }
                if (writePermission != null) {
                    writePermission = writePermission.intern();
                    havePerm = true;
                }
                if (!havePerm) {
                    Slog.w("PackageParser", "No readPermission or writePermssion for <path-permission>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                String path = sa.getNonConfigurationString(3, 0);
                if (path != null) {
                    pa = new PathPermission(path, 0, readPermission, writePermission);
                }
                if ((path = sa.getNonConfigurationString(4, 0)) != null) {
                    pa = new PathPermission(path, 1, readPermission, writePermission);
                }
                if ((path = sa.getNonConfigurationString(5, 0)) != null) {
                    pa = new PathPermission(path, 2, readPermission, writePermission);
                }
                if ((path = sa.getNonConfigurationString(6, 0)) != null) {
                    pa = new PathPermission(path, 3, readPermission, writePermission);
                }
                sa.recycle();
                if (pa != null) {
                    if (outInfo.info.pathPermissions == null) {
                        outInfo.info.pathPermissions = new PathPermission[1];
                        outInfo.info.pathPermissions[0] = pa;
                    } else {
                        int N = outInfo.info.pathPermissions.length;
                        PathPermission[] newp = new PathPermission[N + 1];
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)outInfo.info.pathPermissions, (int)0, (Object)newp, (int)0, (int)N);
                        newp[N] = pa;
                        outInfo.info.pathPermissions = newp;
                    }
                } else {
                    Slog.w("PackageParser", "No path, pathPrefix, or pathPattern for <path-permission>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <provider>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        return true;
    }

    private final Service $$robo$$android_content_pm_PackageParser$parseService(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError, CachedComponentArgs cachedArgs) throws XmlPullParserException, IOException {
        int type;
        boolean visibleToEphemeral;
        String str;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestService);
        if (cachedArgs.mServiceArgs == null) {
            cachedArgs.mServiceArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, 15, 8, 12, this.mSeparateProcesses, 6, 7, 4);
            cachedArgs.mServiceArgs.tag = "<service>";
        }
        cachedArgs.mServiceArgs.sa = sa;
        cachedArgs.mServiceArgs.flags = flags;
        Service s = new Service(cachedArgs.mServiceArgs, new ServiceInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(5);
        if (setExported) {
            s.info.exported = sa.getBoolean(5, false);
        }
        s.info.permission = (str = sa.getNonConfigurationString(3, 0)) == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        s.info.splitName = sa.getNonConfigurationString(17, 0);
        s.info.flags = 0;
        if (sa.getBoolean(9, false)) {
            s.info.flags |= 1;
        }
        if (sa.getBoolean(10, false)) {
            s.info.flags |= 2;
        }
        if (sa.getBoolean(14, false)) {
            s.info.flags |= 4;
        }
        if (sa.getBoolean(11, false)) {
            s.info.flags |= 0x40000000;
        }
        s.info.encryptionAware = s.info.directBootAware = sa.getBoolean(13, false);
        if (s.info.directBootAware) {
            owner.applicationInfo.privateFlags |= 0x100;
        }
        if (visibleToEphemeral = sa.getBoolean(16, false)) {
            s.info.flags |= 0x100000;
            owner.visibleToInstantApps = true;
        }
        sa.recycle();
        if ((owner.applicationInfo.privateFlags & 2) != 0 && s.info.processName == owner.packageName) {
            outError[0] = "Heavy-weight applications can not have services in main process";
            return null;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ServiceIntentInfo intent = new ServiceIntentInfo(s);
                if (!this.parseIntent(res, parser, true, false, intent, outError)) {
                    return null;
                }
                if (visibleToEphemeral) {
                    intent.setVisibilityToInstantApp(1);
                    s.info.flags |= 0x100000;
                }
                s.order = Math.max(intent.getOrder(), s.order);
                s.intents.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                s.metaData = this.parseMetaData(res, parser, s.metaData, outError);
                if (s.metaData != null) continue;
                return null;
            }
            Slog.w("PackageParser", "Unknown element under <service>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            s.info.exported = s.intents.size() > 0;
        }
        return s;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$isImplicitlyExposedIntent(IntentInfo intent) {
        return intent.hasCategory("android.intent.category.BROWSABLE") || intent.hasAction("android.intent.action.SEND") || intent.hasAction("android.intent.action.SENDTO") || intent.hasAction("android.intent.action.SEND_MULTIPLE");
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseAllMetaData(Resources res, XmlResourceParser parser, String tag, Component<?> outInfo, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("meta-data")) {
                outInfo.metaData = this.parseMetaData(res, parser, outInfo.metaData, outError);
                if (outInfo.metaData != null) continue;
                return false;
            }
            Slog.w("PackageParser", "Unknown element under " + tag + ": " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        return true;
    }

    private final Bundle $$robo$$android_content_pm_PackageParser$parseMetaData(Resources res, XmlResourceParser parser, Bundle data, String[] outError) throws XmlPullParserException, IOException {
        String name;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestMetaData);
        if (data == null) {
            data = new Bundle();
        }
        if ((name = sa.getNonConfigurationString(0, 0)) == null) {
            outError[0] = "<meta-data> requires an android:name attribute";
            sa.recycle();
            return null;
        }
        name = name.intern();
        TypedValue v = sa.peekValue(2);
        if (v != null && v.resourceId != 0) {
            data.putInt(name, v.resourceId);
        } else {
            v = sa.peekValue(1);
            if (v != null) {
                if (v.type == 3) {
                    CharSequence cs = v.coerceToString();
                    data.putString(name, cs != null ? cs.toString() : null);
                } else if (v.type == 18) {
                    data.putBoolean(name, v.data != 0);
                } else if (v.type >= 16 && v.type <= 31) {
                    data.putInt(name, v.data);
                } else if (v.type == 4) {
                    data.putFloat(name, v.getFloat());
                } else {
                    Slog.w("PackageParser", "<meta-data> only supports string, integer, float, color, boolean, and resource reference types: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                }
            } else {
                outError[0] = "<meta-data> requires an android:value or android:resource attribute";
                data = null;
            }
        }
        sa.recycle();
        XmlUtils.skipCurrentTag(parser);
        return data;
    }

    private static final VerifierInfo $$robo$$android_content_pm_PackageParser$parseVerifier(AttributeSet attrs) {
        String packageName = null;
        String encodedPublicKey = null;
        int attrCount = attrs.getAttributeCount();
        block4: for (int i = 0; i < attrCount; ++i) {
            int attrResId = attrs.getAttributeNameResource(i);
            switch (attrResId) {
                case 0x1010003: {
                    packageName = attrs.getAttributeValue(i);
                    continue block4;
                }
                case 16843686: {
                    encodedPublicKey = attrs.getAttributeValue(i);
                }
            }
        }
        if (packageName == null || packageName.length() == 0) {
            Slog.i("PackageParser", "verifier package name was null; skipping");
            return null;
        }
        PublicKey publicKey = PackageParser.parsePublicKey(encodedPublicKey);
        if (publicKey == null) {
            Slog.i("PackageParser", "Unable to parse verifier public key for " + packageName);
            return null;
        }
        return new VerifierInfo(packageName, publicKey);
    }

    private static final PublicKey $$robo$$android_content_pm_PackageParser$parsePublicKey(String encodedPublicKey) {
        X509EncodedKeySpec keySpec;
        if (encodedPublicKey == null) {
            Slog.w("PackageParser", "Could not parse null public key");
            return null;
        }
        try {
            byte[] encoded = Base64.decode(encodedPublicKey, 0);
            keySpec = new X509EncodedKeySpec(encoded);
        }
        catch (IllegalArgumentException e) {
            Slog.w("PackageParser", "Could not parse verifier public key; invalid Base64");
            return null;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            Slog.wtf("PackageParser", "Could not parse public key: RSA KeyFactory not included in build");
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            Slog.wtf("PackageParser", "Could not parse public key: EC KeyFactory not included in build");
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            Slog.wtf("PackageParser", "Could not parse public key: DSA KeyFactory not included in build");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return null;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseIntent(Resources res, XmlResourceParser parser, boolean allowGlobs, boolean allowAutoVerify, IntentInfo outInfo, String[] outError) throws XmlPullParserException, IOException {
        int type;
        boolean useRoundIcon;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestIntentFilter);
        int priority = sa.getInt(2, 0);
        outInfo.setPriority(priority);
        int order = sa.getInt(3, 0);
        outInfo.setOrder(order);
        TypedValue v = sa.peekValue(0);
        if (v != null && (outInfo.labelRes = v.resourceId) == 0) {
            outInfo.nonLocalizedLabel = v.coerceToString();
        }
        int roundIconVal = (useRoundIcon = Resources.getSystem().getBoolean(17957064)) ? sa.getResourceId(7, 0) : 0;
        outInfo.icon = roundIconVal != 0 ? roundIconVal : sa.getResourceId(1, 0);
        outInfo.logo = sa.getResourceId(4, 0);
        outInfo.banner = sa.getResourceId(5, 0);
        if (allowAutoVerify) {
            outInfo.setAutoVerify(sa.getBoolean(6, false));
        }
        sa.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String value;
            if (type == 3 || type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("action")) {
                value = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
                if (value == null || value == "") {
                    outError[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(parser);
                outInfo.addAction(value);
                continue;
            }
            if (nodeName.equals("category")) {
                value = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
                if (value == null || value == "") {
                    outError[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(parser);
                outInfo.addCategory(value);
                continue;
            }
            if (nodeName.equals("data")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestData);
                String str = sa.getNonConfigurationString(0, 0);
                if (str != null) {
                    try {
                        outInfo.addDataType(str);
                    }
                    catch (IntentFilter.MalformedMimeTypeException e) {
                        outError[0] = e.toString();
                        sa.recycle();
                        return false;
                    }
                }
                if ((str = sa.getNonConfigurationString(1, 0)) != null) {
                    outInfo.addDataScheme(str);
                }
                if ((str = sa.getNonConfigurationString(7, 0)) != null) {
                    outInfo.addDataSchemeSpecificPart(str, 0);
                }
                if ((str = sa.getNonConfigurationString(8, 0)) != null) {
                    outInfo.addDataSchemeSpecificPart(str, 1);
                }
                if ((str = sa.getNonConfigurationString(9, 0)) != null) {
                    if (!allowGlobs) {
                        outError[0] = "sspPattern not allowed here; ssp must be literal";
                        return false;
                    }
                    outInfo.addDataSchemeSpecificPart(str, 2);
                }
                String host = sa.getNonConfigurationString(2, 0);
                String port = sa.getNonConfigurationString(3, 0);
                if (host != null) {
                    outInfo.addDataAuthority(host, port);
                }
                if ((str = sa.getNonConfigurationString(4, 0)) != null) {
                    outInfo.addDataPath(str, 0);
                }
                if ((str = sa.getNonConfigurationString(5, 0)) != null) {
                    outInfo.addDataPath(str, 1);
                }
                if ((str = sa.getNonConfigurationString(6, 0)) != null) {
                    if (!allowGlobs) {
                        outError[0] = "pathPattern not allowed here; path must be literal";
                        return false;
                    }
                    outInfo.addDataPath(str, 2);
                }
                if ((str = sa.getNonConfigurationString(10, 0)) != null) {
                    if (!allowGlobs) {
                        outError[0] = "pathAdvancedPattern not allowed here; path must be literal";
                        return false;
                    }
                    outInfo.addDataPath(str, 3);
                }
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <intent-filter>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        outInfo.hasDefault = outInfo.hasCategory("android.intent.category.DEFAULT");
        return true;
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$copyNeeded(int flags, Package p, PackageUserState state, Bundle metaData, int userId) {
        boolean suspended;
        if (userId != 0) {
            return true;
        }
        if (state.enabled != 0) {
            boolean enabled;
            boolean bl = enabled = state.enabled == 1;
            if (p.applicationInfo.enabled != enabled) {
                return true;
            }
        }
        boolean bl = suspended = (p.applicationInfo.flags & 0x40000000) != 0;
        if (state.suspended != suspended) {
            return true;
        }
        if (!state.installed || state.hidden) {
            return true;
        }
        if (state.stopped) {
            return true;
        }
        if (state.instantApp != p.applicationInfo.isInstantApp()) {
            return true;
        }
        if ((flags & 0x80) != 0 && (metaData != null || p.mAppMetaData != null)) {
            return true;
        }
        if ((flags & 0x400) != 0 && p.usesLibraryFiles != null) {
            return true;
        }
        return p.staticSharedLibName != null;
    }

    private static final ApplicationInfo $$robo$$android_content_pm_PackageParser$generateApplicationInfo(Package p, int flags, PackageUserState state) {
        return PackageParser.generateApplicationInfo(p, flags, state, UserHandle.getCallingUserId());
    }

    private static final void $$robo$$android_content_pm_PackageParser$updateApplicationInfo(ApplicationInfo ai, int flags, PackageUserState state) {
        if (!sCompatibilityModeEnabled) {
            ai.disableCompatibilityMode();
        }
        ai.flags = state.installed ? (ai.flags |= 0x800000) : (ai.flags &= 0xFF7FFFFF);
        ai.flags = state.suspended ? (ai.flags |= 0x40000000) : (ai.flags &= 0xBFFFFFFF);
        ai.privateFlags = state.instantApp ? (ai.privateFlags |= 0x80) : (ai.privateFlags &= 0xFFFFFF7F);
        ai.privateFlags = state.virtualPreload ? (ai.privateFlags |= 0x10000) : (ai.privateFlags &= 0xFFFEFFFF);
        ai.privateFlags = state.hidden ? (ai.privateFlags |= 1) : (ai.privateFlags &= 0xFFFFFFFE);
        if (state.enabled == 1) {
            ai.enabled = true;
        } else if (state.enabled == 4) {
            ai.enabled = (flags & 0x8000) != 0;
        } else if (state.enabled == 2 || state.enabled == 3) {
            ai.enabled = false;
        }
        ai.enabledSetting = state.enabled;
        if (ai.category == -1) {
            ai.category = state.categoryHint;
        }
        if (ai.category == -1) {
            ai.category = FallbackCategoryProvider.getFallbackCategory(ai.packageName);
        }
        ai.seInfoUser = SELinuxUtil.assignSeinfoUser(state);
        ai.resourceDirs = state.overlayPaths;
    }

    private static final ApplicationInfo $$robo$$android_content_pm_PackageParser$generateApplicationInfo(Package p, int flags, PackageUserState state, int userId) {
        if (p == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state, p.applicationInfo) || !p.isMatch(flags)) {
            return null;
        }
        if (!(PackageParser.copyNeeded(flags, p, state, null, userId) || (flags & 0x8000) != 0 && state.enabled == 4)) {
            PackageParser.updateApplicationInfo(p.applicationInfo, flags, state);
            return p.applicationInfo;
        }
        ApplicationInfo ai = new ApplicationInfo(p.applicationInfo);
        ai.initForUser(userId);
        if ((flags & 0x80) != 0) {
            ai.metaData = p.mAppMetaData;
        }
        if ((flags & 0x400) != 0) {
            ai.sharedLibraryFiles = p.usesLibraryFiles;
        }
        ai.flags = state.stopped ? (ai.flags |= 0x200000) : (ai.flags &= 0xFFDFFFFF);
        PackageParser.updateApplicationInfo(ai, flags, state);
        return ai;
    }

    private static final ApplicationInfo $$robo$$android_content_pm_PackageParser$generateApplicationInfo(ApplicationInfo ai, int flags, PackageUserState state, int userId) {
        if (ai == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state, ai)) {
            return null;
        }
        ai = new ApplicationInfo(ai);
        ai.initForUser(userId);
        ai.flags = state.stopped ? (ai.flags |= 0x200000) : (ai.flags &= 0xFFDFFFFF);
        PackageParser.updateApplicationInfo(ai, flags, state);
        return ai;
    }

    private static final PermissionInfo $$robo$$android_content_pm_PackageParser$generatePermissionInfo(Permission p, int flags) {
        if (p == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return p.info;
        }
        PermissionInfo pi = new PermissionInfo(p.info);
        pi.metaData = p.metaData;
        return pi;
    }

    private static final PermissionGroupInfo $$robo$$android_content_pm_PackageParser$generatePermissionGroupInfo(PermissionGroup pg, int flags) {
        if (pg == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return pg.info;
        }
        PermissionGroupInfo pgi = new PermissionGroupInfo(pg.info);
        pgi.metaData = pg.metaData;
        return pgi;
    }

    private static final ActivityInfo $$robo$$android_content_pm_PackageParser$generateActivityInfo(Activity a, int flags, PackageUserState state, int userId) {
        if (a == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state, a.owner.applicationInfo)) {
            return null;
        }
        if (!PackageParser.copyNeeded(flags, a.owner, state, a.metaData, userId)) {
            PackageParser.updateApplicationInfo(a.info.applicationInfo, flags, state);
            return a.info;
        }
        ActivityInfo ai = new ActivityInfo(a.info);
        ai.metaData = a.metaData;
        ai.applicationInfo = PackageParser.generateApplicationInfo(a.owner, flags, state, userId);
        return ai;
    }

    private static final ActivityInfo $$robo$$android_content_pm_PackageParser$generateActivityInfo(ActivityInfo ai, int flags, PackageUserState state, int userId) {
        if (ai == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state, ai.applicationInfo)) {
            return null;
        }
        ai = new ActivityInfo(ai);
        ai.applicationInfo = PackageParser.generateApplicationInfo(ai.applicationInfo, flags, state, userId);
        return ai;
    }

    private static final ServiceInfo $$robo$$android_content_pm_PackageParser$generateServiceInfo(Service s, int flags, PackageUserState state, int userId) {
        if (s == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state, s.owner.applicationInfo)) {
            return null;
        }
        if (!PackageParser.copyNeeded(flags, s.owner, state, s.metaData, userId)) {
            PackageParser.updateApplicationInfo(s.info.applicationInfo, flags, state);
            return s.info;
        }
        ServiceInfo si = new ServiceInfo(s.info);
        si.metaData = s.metaData;
        si.applicationInfo = PackageParser.generateApplicationInfo(s.owner, flags, state, userId);
        return si;
    }

    private static final ProviderInfo $$robo$$android_content_pm_PackageParser$generateProviderInfo(Provider p, int flags, PackageUserState state, int userId) {
        if (p == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state, p.owner.applicationInfo)) {
            return null;
        }
        if (!(PackageParser.copyNeeded(flags, p.owner, state, p.metaData, userId) || (flags & 0x800) == 0 && p.info.uriPermissionPatterns != null)) {
            PackageParser.updateApplicationInfo(p.info.applicationInfo, flags, state);
            return p.info;
        }
        ProviderInfo pi = new ProviderInfo(p.info);
        pi.metaData = p.metaData;
        if ((flags & 0x800) == 0) {
            pi.uriPermissionPatterns = null;
        }
        pi.applicationInfo = PackageParser.generateApplicationInfo(p.owner, flags, state, userId);
        return pi;
    }

    private static final InstrumentationInfo $$robo$$android_content_pm_PackageParser$generateInstrumentationInfo(Instrumentation i, int flags) {
        if (i == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return i.info;
        }
        InstrumentationInfo ii = new InstrumentationInfo(i.info);
        ii.metaData = i.metaData;
        return ii;
    }

    private static final void $$robo$$android_content_pm_PackageParser$setCompatibilityModeEnabled(boolean compatibilityModeEnabled) {
        sCompatibilityModeEnabled = compatibilityModeEnabled;
    }

    static void __staticInitializer__() {
        LOG_PARSE_TIMINGS = Build.IS_DEBUGGABLE;
        MULTI_PACKAGE_APK_ENABLED = Build.IS_DEBUGGABLE && SystemProperties.getBoolean("persist.sys.child_packages_enabled", false);
        CHILD_PACKAGE_TAGS = new ArraySet<String>();
        CHILD_PACKAGE_TAGS.add("application");
        CHILD_PACKAGE_TAGS.add("uses-permission");
        CHILD_PACKAGE_TAGS.add("uses-permission-sdk-m");
        CHILD_PACKAGE_TAGS.add("uses-permission-sdk-23");
        CHILD_PACKAGE_TAGS.add("uses-configuration");
        CHILD_PACKAGE_TAGS.add("uses-feature");
        CHILD_PACKAGE_TAGS.add("feature-group");
        CHILD_PACKAGE_TAGS.add("uses-sdk");
        CHILD_PACKAGE_TAGS.add("supports-screens");
        CHILD_PACKAGE_TAGS.add("instrumentation");
        CHILD_PACKAGE_TAGS.add("uses-gl-texture");
        CHILD_PACKAGE_TAGS.add("compatible-screens");
        CHILD_PACKAGE_TAGS.add("supports-input");
        CHILD_PACKAGE_TAGS.add("eat-comment");
        sCachedPackageReadCount = new AtomicInteger();
        SAFE_BROADCASTS = new ArraySet<String>();
        SAFE_BROADCASTS.add("android.intent.action.BOOT_COMPLETED");
        NEW_PERMISSIONS = new NewPermissionInfo[]{new NewPermissionInfo("android.permission.WRITE_EXTERNAL_STORAGE", 4, 0), new NewPermissionInfo("android.permission.READ_PHONE_STATE", 4, 0)};
        SPLIT_PERMISSIONS = new SplitPermissionInfo[]{new SplitPermissionInfo("android.permission.WRITE_EXTERNAL_STORAGE", new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 10001), new SplitPermissionInfo("android.permission.READ_CONTACTS", new String[]{"android.permission.READ_CALL_LOG"}, 16), new SplitPermissionInfo("android.permission.WRITE_CONTACTS", new String[]{"android.permission.WRITE_CALL_LOG"}, 16)};
        SDK_VERSION = Build.VERSION.SDK_INT;
        SDK_CODENAMES = Build.VERSION.ACTIVE_CODENAMES;
        sCompatibilityModeEnabled = true;
        sSplitNameComparator = new SplitNameComparator();
    }

    private void __constructor__() {
        this.$$robo$$android_content_pm_PackageParser$__constructor__();
    }

    public PackageParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser$__constructor__(), 0, this);
    }

    public void setSeparateProcesses(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setSeparateProcesses", $$robo$$android_content_pm_PackageParser$setSeparateProcesses(java.lang.String[] ), 0, this, stringArray);
    }

    public void setOnlyCoreApps(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOnlyCoreApps", $$robo$$android_content_pm_PackageParser$setOnlyCoreApps(boolean ), 0, this, bl);
    }

    public void setDisplayMetrics(DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("setDisplayMetrics", $$robo$$android_content_pm_PackageParser$setDisplayMetrics(android.util.DisplayMetrics ), 0, this, displayMetrics);
    }

    public void setCacheDir(File file) {
        InvokeDynamicSupport.bootstrap("setCacheDir", $$robo$$android_content_pm_PackageParser$setCacheDir(java.io.File ), 0, this, file);
    }

    public void setCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_content_pm_PackageParser$setCallback(android.content.pm.PackageParser$Callback ), 0, this, callback);
    }

    public static boolean isApkFile(File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isApkFile", $$robo$$android_content_pm_PackageParser$isApkFile(java.io.File ), 0, (File)file);
    }

    public static boolean isApkPath(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isApkPath", $$robo$$android_content_pm_PackageParser$isApkPath(java.lang.String ), 0, (String)string2);
    }

    public static PackageInfo generatePackageInfo(Package package_, int[] nArray, int n, long l, long l2, Set<String> set, PackageUserState packageUserState) {
        return InvokeDynamicSupport.bootstrapStatic("generatePackageInfo", $$robo$$android_content_pm_PackageParser$generatePackageInfo(android.content.pm.PackageParser$Package int[] int long long java.util.Set<java.lang.String> android.content.pm.PackageUserState ), 0, (Package)package_, (int[])nArray, (int)n, (long)l, (long)l2, set, (PackageUserState)packageUserState);
    }

    private static boolean checkUseInstalledOrHidden(int n, PackageUserState packageUserState, ApplicationInfo applicationInfo) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkUseInstalledOrHidden", $$robo$$android_content_pm_PackageParser$checkUseInstalledOrHidden(int android.content.pm.PackageUserState android.content.pm.ApplicationInfo ), 0, (int)n, (PackageUserState)packageUserState, (ApplicationInfo)applicationInfo);
    }

    public static boolean isAvailable(PackageUserState packageUserState) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAvailable", $$robo$$android_content_pm_PackageParser$isAvailable(android.content.pm.PackageUserState ), 0, (PackageUserState)packageUserState);
    }

    public static PackageInfo generatePackageInfo(Package package_, int[] nArray, int n, long l, long l2, Set<String> set, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generatePackageInfo", $$robo$$android_content_pm_PackageParser$generatePackageInfo(android.content.pm.PackageParser$Package int[] int long long java.util.Set<java.lang.String> android.content.pm.PackageUserState int ), 0, (Package)package_, (int[])nArray, (int)n, (long)l, (long)l2, set, (PackageUserState)packageUserState, (int)n2);
    }

    public static PackageLite parsePackageLite(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parsePackageLite", $$robo$$android_content_pm_PackageParser$parsePackageLite(java.io.File int ), 0, (File)file, (int)n);
    }

    private static PackageLite parseMonolithicPackageLite(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseMonolithicPackageLite", $$robo$$android_content_pm_PackageParser$parseMonolithicPackageLite(java.io.File int ), 0, (File)file, (int)n);
    }

    static PackageLite parseClusterPackageLite(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseClusterPackageLite", $$robo$$android_content_pm_PackageParser$parseClusterPackageLite(java.io.File int ), 0, (File)file, (int)n);
    }

    public Package parsePackage(File file, int n, boolean bl) throws PackageParserException {
        return InvokeDynamicSupport.bootstrap("parsePackage", $$robo$$android_content_pm_PackageParser$parsePackage(java.io.File int boolean ), 0, this, file, n, bl);
    }

    public Package parsePackage(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrap("parsePackage", $$robo$$android_content_pm_PackageParser$parsePackage(java.io.File int ), 0, this, file, n);
    }

    private String getCacheKey(File file, int n) {
        return InvokeDynamicSupport.bootstrap("getCacheKey", $$robo$$android_content_pm_PackageParser$getCacheKey(java.io.File int ), 0, this, file, n);
    }

    protected Package fromCacheEntry(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("fromCacheEntry", $$robo$$android_content_pm_PackageParser$fromCacheEntry(byte[] ), 0, this, byArray);
    }

    public static Package fromCacheEntryStatic(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("fromCacheEntryStatic", $$robo$$android_content_pm_PackageParser$fromCacheEntryStatic(byte[] ), 0, (byte[])byArray);
    }

    protected byte[] toCacheEntry(Package package_) {
        return InvokeDynamicSupport.bootstrap("toCacheEntry", $$robo$$android_content_pm_PackageParser$toCacheEntry(android.content.pm.PackageParser$Package ), 0, this, package_);
    }

    public static byte[] toCacheEntryStatic(Package package_) {
        return InvokeDynamicSupport.bootstrapStatic("toCacheEntryStatic", $$robo$$android_content_pm_PackageParser$toCacheEntryStatic(android.content.pm.PackageParser$Package ), 0, (Package)package_);
    }

    private static boolean isCacheUpToDate(File file, File file2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCacheUpToDate", $$robo$$android_content_pm_PackageParser$isCacheUpToDate(java.io.File java.io.File ), 0, (File)file, (File)file2);
    }

    private Package getCachedResult(File file, int n) {
        return InvokeDynamicSupport.bootstrap("getCachedResult", $$robo$$android_content_pm_PackageParser$getCachedResult(java.io.File int ), 0, this, file, n);
    }

    private void cacheResult(File file, int n, Package package_) {
        InvokeDynamicSupport.bootstrap("cacheResult", $$robo$$android_content_pm_PackageParser$cacheResult(java.io.File int android.content.pm.PackageParser$Package ), 0, this, file, n, package_);
    }

    private Package parseClusterPackage(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrap("parseClusterPackage", $$robo$$android_content_pm_PackageParser$parseClusterPackage(java.io.File int ), 0, this, file, n);
    }

    @Deprecated
    public Package parseMonolithicPackage(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrap("parseMonolithicPackage", $$robo$$android_content_pm_PackageParser$parseMonolithicPackage(java.io.File int ), 0, this, file, n);
    }

    private Package parseBaseApk(File file, AssetManager assetManager, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrap("parseBaseApk", $$robo$$android_content_pm_PackageParser$parseBaseApk(java.io.File android.content.res.AssetManager int ), 0, this, file, assetManager, n);
    }

    private void parseSplitApk(Package package_, int n, AssetManager assetManager, int n2) throws PackageParserException {
        InvokeDynamicSupport.bootstrap("parseSplitApk", $$robo$$android_content_pm_PackageParser$parseSplitApk(android.content.pm.PackageParser$Package int android.content.res.AssetManager int ), 0, this, package_, n, assetManager, n2);
    }

    private Package parseSplitApk(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, int n2, String[] stringArray) throws XmlPullParserException, IOException, PackageParserException {
        return InvokeDynamicSupport.bootstrap("parseSplitApk", $$robo$$android_content_pm_PackageParser$parseSplitApk(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int int java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, n, n2, stringArray);
    }

    public static ArraySet<PublicKey> toSigningKeys(Signature[] signatureArray) throws CertificateException {
        return InvokeDynamicSupport.bootstrapStatic("toSigningKeys", $$robo$$android_content_pm_PackageParser$toSigningKeys(android.content.pm.Signature[] ), 0, (Signature[])signatureArray);
    }

    public static void collectCertificates(Package package_, boolean bl) throws PackageParserException {
        InvokeDynamicSupport.bootstrapStatic("collectCertificates", $$robo$$android_content_pm_PackageParser$collectCertificates(android.content.pm.PackageParser$Package boolean ), 0, (Package)package_, (boolean)bl);
    }

    private static void collectCertificatesInternal(Package package_, boolean bl) throws PackageParserException {
        InvokeDynamicSupport.bootstrapStatic("collectCertificatesInternal", $$robo$$android_content_pm_PackageParser$collectCertificatesInternal(android.content.pm.PackageParser$Package boolean ), 0, (Package)package_, (boolean)bl);
    }

    private static void collectCertificates(Package package_, File file, boolean bl) throws PackageParserException {
        InvokeDynamicSupport.bootstrapStatic("collectCertificates", $$robo$$android_content_pm_PackageParser$collectCertificates(android.content.pm.PackageParser$Package java.io.File boolean ), 0, (Package)package_, (File)file, (boolean)bl);
    }

    private static AssetManager newConfiguredAssetManager() {
        return InvokeDynamicSupport.bootstrapStatic("newConfiguredAssetManager", $$robo$$android_content_pm_PackageParser$newConfiguredAssetManager(), 0);
    }

    public static ApkLite parseApkLite(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseApkLite", $$robo$$android_content_pm_PackageParser$parseApkLite(java.io.File int ), 0, (File)file, (int)n);
    }

    public static ApkLite parseApkLite(FileDescriptor fileDescriptor, String string2, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseApkLite", $$robo$$android_content_pm_PackageParser$parseApkLite(java.io.FileDescriptor java.lang.String int ), 0, (FileDescriptor)fileDescriptor, (String)string2, (int)n);
    }

    private static ApkLite parseApkLiteInner(File file, FileDescriptor fileDescriptor, String string2, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseApkLiteInner", $$robo$$android_content_pm_PackageParser$parseApkLiteInner(java.io.File java.io.FileDescriptor java.lang.String int ), 0, (File)file, (FileDescriptor)fileDescriptor, (String)string2, (int)n);
    }

    private static String validateName(String string2, boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrapStatic("validateName", $$robo$$android_content_pm_PackageParser$validateName(java.lang.String boolean boolean ), 0, (String)string2, (boolean)bl, (boolean)bl2);
    }

    private static Pair<String, String> parsePackageSplitNames(XmlPullParser xmlPullParser, AttributeSet attributeSet) throws IOException, XmlPullParserException, PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parsePackageSplitNames", $$robo$$android_content_pm_PackageParser$parsePackageSplitNames(org.xmlpull.v1.XmlPullParser android.util.AttributeSet ), 0, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet);
    }

    private static ApkLite parseApkLite(String string2, XmlPullParser xmlPullParser, AttributeSet attributeSet, SigningDetails signingDetails) throws IOException, XmlPullParserException, PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseApkLite", $$robo$$android_content_pm_PackageParser$parseApkLite(java.lang.String org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.pm.PackageParser$SigningDetails ), 0, (String)string2, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet, (SigningDetails)signingDetails);
    }

    private boolean parseBaseApkChild(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseBaseApkChild", $$robo$$android_content_pm_PackageParser$parseBaseApkChild(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, n, stringArray);
    }

    private Package parseBaseApk(String string2, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseBaseApk", $$robo$$android_content_pm_PackageParser$parseBaseApk(java.lang.String android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] ), 0, this, string2, resources, xmlResourceParser, n, stringArray);
    }

    private Package parseBaseApkCommon(Package package_, Set<String> set, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseBaseApkCommon", $$robo$$android_content_pm_PackageParser$parseBaseApkCommon(android.content.pm.PackageParser$Package java.util.Set<java.lang.String> android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] ), 0, this, package_, set, resources, xmlResourceParser, n, stringArray);
    }

    private boolean checkOverlayRequiredSystemProperty(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkOverlayRequiredSystemProperty", $$robo$$android_content_pm_PackageParser$checkOverlayRequiredSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void adjustPackageToBeUnresizeableAndUnpipable(Package package_) {
        InvokeDynamicSupport.bootstrap("adjustPackageToBeUnresizeableAndUnpipable", $$robo$$android_content_pm_PackageParser$adjustPackageToBeUnresizeableAndUnpipable(android.content.pm.PackageParser$Package ), 0, this, package_);
    }

    public static int computeTargetSdkVersion(int n, String string2, String[] stringArray, String[] stringArray2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("computeTargetSdkVersion", $$robo$$android_content_pm_PackageParser$computeTargetSdkVersion(int java.lang.String java.lang.String[] java.lang.String[] boolean ), 0, (int)n, (String)string2, (String[])stringArray, (String[])stringArray2, (boolean)bl);
    }

    public static int computeMinSdkVersion(int n, String string2, int n2, String[] stringArray, String[] stringArray2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("computeMinSdkVersion", $$robo$$android_content_pm_PackageParser$computeMinSdkVersion(int java.lang.String int java.lang.String[] java.lang.String[] ), 0, (int)n, (String)string2, (int)n2, (String[])stringArray, (String[])stringArray2);
    }

    private FeatureInfo parseUsesFeature(Resources resources, AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("parseUsesFeature", $$robo$$android_content_pm_PackageParser$parseUsesFeature(android.content.res.Resources android.util.AttributeSet ), 0, this, resources, attributeSet);
    }

    private boolean parseUsesStaticLibrary(Package package_, Resources resources, XmlResourceParser xmlResourceParser, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseUsesStaticLibrary", $$robo$$android_content_pm_PackageParser$parseUsesStaticLibrary(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, stringArray);
    }

    private String[] parseAdditionalCertificates(Resources resources, XmlResourceParser xmlResourceParser, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseAdditionalCertificates", $$robo$$android_content_pm_PackageParser$parseAdditionalCertificates(android.content.res.Resources android.content.res.XmlResourceParser java.lang.String[] ), 0, this, resources, xmlResourceParser, stringArray);
    }

    private boolean parseUsesPermission(Package package_, Resources resources, XmlResourceParser xmlResourceParser) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseUsesPermission", $$robo$$android_content_pm_PackageParser$parseUsesPermission(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser ), 0, this, package_, resources, xmlResourceParser);
    }

    private static String buildClassName(String string2, CharSequence charSequence, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildClassName", $$robo$$android_content_pm_PackageParser$buildClassName(java.lang.String java.lang.CharSequence java.lang.String[] ), 0, (String)string2, (CharSequence)charSequence, (String[])stringArray);
    }

    private static String buildCompoundName(String string2, CharSequence charSequence, String string3, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildCompoundName", $$robo$$android_content_pm_PackageParser$buildCompoundName(java.lang.String java.lang.CharSequence java.lang.String java.lang.String[] ), 0, (String)string2, (CharSequence)charSequence, (String)string3, (String[])stringArray);
    }

    private static String buildProcessName(String string2, String string3, CharSequence charSequence, int n, String[] stringArray, String[] stringArray2) {
        return InvokeDynamicSupport.bootstrapStatic("buildProcessName", $$robo$$android_content_pm_PackageParser$buildProcessName(java.lang.String java.lang.String java.lang.CharSequence int java.lang.String[] java.lang.String[] ), 0, (String)string2, (String)string3, (CharSequence)charSequence, (int)n, (String[])stringArray, (String[])stringArray2);
    }

    private static String buildTaskAffinityName(String string2, String string3, CharSequence charSequence, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildTaskAffinityName", $$robo$$android_content_pm_PackageParser$buildTaskAffinityName(java.lang.String java.lang.String java.lang.CharSequence java.lang.String[] ), 0, (String)string2, (String)string3, (CharSequence)charSequence, (String[])stringArray);
    }

    private boolean parseKeySets(Package package_, Resources resources, XmlResourceParser xmlResourceParser, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseKeySets", $$robo$$android_content_pm_PackageParser$parseKeySets(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, stringArray);
    }

    private boolean parsePermissionGroup(Package package_, int n, Resources resources, XmlResourceParser xmlResourceParser, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parsePermissionGroup", $$robo$$android_content_pm_PackageParser$parsePermissionGroup(android.content.pm.PackageParser$Package int android.content.res.Resources android.content.res.XmlResourceParser java.lang.String[] ), 0, this, package_, n, resources, xmlResourceParser, stringArray);
    }

    private boolean parsePermission(Package package_, Resources resources, XmlResourceParser xmlResourceParser, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parsePermission", $$robo$$android_content_pm_PackageParser$parsePermission(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, stringArray);
    }

    private boolean parsePermissionTree(Package package_, Resources resources, XmlResourceParser xmlResourceParser, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parsePermissionTree", $$robo$$android_content_pm_PackageParser$parsePermissionTree(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, stringArray);
    }

    private Instrumentation parseInstrumentation(Package package_, Resources resources, XmlResourceParser xmlResourceParser, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseInstrumentation", $$robo$$android_content_pm_PackageParser$parseInstrumentation(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, stringArray);
    }

    private boolean parseBaseApplication(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseBaseApplication", $$robo$$android_content_pm_PackageParser$parseBaseApplication(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, n, stringArray);
    }

    private static boolean hasDomainURLs(Package package_) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasDomainURLs", $$robo$$android_content_pm_PackageParser$hasDomainURLs(android.content.pm.PackageParser$Package ), 0, (Package)package_);
    }

    private boolean parseSplitApplication(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, int n2, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseSplitApplication", $$robo$$android_content_pm_PackageParser$parseSplitApplication(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int int java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, n, n2, stringArray);
    }

    private static boolean parsePackageItemInfo(Package package_, PackageItemInfo packageItemInfo, String[] stringArray, String string2, TypedArray typedArray, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("parsePackageItemInfo", $$robo$$android_content_pm_PackageParser$parsePackageItemInfo(android.content.pm.PackageParser$Package android.content.pm.PackageItemInfo java.lang.String[] java.lang.String android.content.res.TypedArray boolean int int int int int int ), 0, (Package)package_, (PackageItemInfo)packageItemInfo, (String[])stringArray, (String)string2, (TypedArray)typedArray, (boolean)bl, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6);
    }

    private Activity parseActivity(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray, CachedComponentArgs cachedComponentArgs, boolean bl, boolean bl2) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseActivity", $$robo$$android_content_pm_PackageParser$parseActivity(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] android.content.pm.PackageParser$CachedComponentArgs boolean boolean ), 0, this, package_, resources, xmlResourceParser, n, stringArray, cachedComponentArgs, bl, bl2);
    }

    private void setActivityResizeMode(ActivityInfo activityInfo, TypedArray typedArray, Package package_) {
        InvokeDynamicSupport.bootstrap("setActivityResizeMode", $$robo$$android_content_pm_PackageParser$setActivityResizeMode(android.content.pm.ActivityInfo android.content.res.TypedArray android.content.pm.PackageParser$Package ), 0, this, activityInfo, typedArray, package_);
    }

    private void setMaxAspectRatio(Package package_) {
        InvokeDynamicSupport.bootstrap("setMaxAspectRatio", $$robo$$android_content_pm_PackageParser$setMaxAspectRatio(android.content.pm.PackageParser$Package ), 0, this, package_);
    }

    public static int getActivityConfigChanges(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getActivityConfigChanges", $$robo$$android_content_pm_PackageParser$getActivityConfigChanges(int int ), 0, (int)n, (int)n2);
    }

    private void parseLayout(Resources resources, AttributeSet attributeSet, Activity activity) {
        InvokeDynamicSupport.bootstrap("parseLayout", $$robo$$android_content_pm_PackageParser$parseLayout(android.content.res.Resources android.util.AttributeSet android.content.pm.PackageParser$Activity ), 0, this, resources, attributeSet, activity);
    }

    private Activity parseActivityAlias(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray, CachedComponentArgs cachedComponentArgs) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseActivityAlias", $$robo$$android_content_pm_PackageParser$parseActivityAlias(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] android.content.pm.PackageParser$CachedComponentArgs ), 0, this, package_, resources, xmlResourceParser, n, stringArray, cachedComponentArgs);
    }

    private Provider parseProvider(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray, CachedComponentArgs cachedComponentArgs) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseProvider", $$robo$$android_content_pm_PackageParser$parseProvider(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] android.content.pm.PackageParser$CachedComponentArgs ), 0, this, package_, resources, xmlResourceParser, n, stringArray, cachedComponentArgs);
    }

    private boolean parseProviderTags(Resources resources, XmlResourceParser xmlResourceParser, boolean bl, Provider provider, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseProviderTags", $$robo$$android_content_pm_PackageParser$parseProviderTags(android.content.res.Resources android.content.res.XmlResourceParser boolean android.content.pm.PackageParser$Provider java.lang.String[] ), 0, this, resources, xmlResourceParser, bl, provider, stringArray);
    }

    private Service parseService(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray, CachedComponentArgs cachedComponentArgs) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseService", $$robo$$android_content_pm_PackageParser$parseService(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] android.content.pm.PackageParser$CachedComponentArgs ), 0, this, package_, resources, xmlResourceParser, n, stringArray, cachedComponentArgs);
    }

    private boolean isImplicitlyExposedIntent(IntentInfo intentInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("isImplicitlyExposedIntent", $$robo$$android_content_pm_PackageParser$isImplicitlyExposedIntent(android.content.pm.PackageParser$IntentInfo ), 0, this, intentInfo);
    }

    private boolean parseAllMetaData(Resources resources, XmlResourceParser xmlResourceParser, String string2, Component<?> component, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseAllMetaData", $$robo$$android_content_pm_PackageParser$parseAllMetaData(android.content.res.Resources android.content.res.XmlResourceParser java.lang.String android.content.pm.PackageParser$Component<?> java.lang.String[] ), 0, this, resources, xmlResourceParser, string2, component, stringArray);
    }

    private Bundle parseMetaData(Resources resources, XmlResourceParser xmlResourceParser, Bundle bundle, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseMetaData", $$robo$$android_content_pm_PackageParser$parseMetaData(android.content.res.Resources android.content.res.XmlResourceParser android.os.Bundle java.lang.String[] ), 0, this, resources, xmlResourceParser, bundle, stringArray);
    }

    private static VerifierInfo parseVerifier(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrapStatic("parseVerifier", $$robo$$android_content_pm_PackageParser$parseVerifier(android.util.AttributeSet ), 0, (AttributeSet)attributeSet);
    }

    public static PublicKey parsePublicKey(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parsePublicKey", $$robo$$android_content_pm_PackageParser$parsePublicKey(java.lang.String ), 0, (String)string2);
    }

    private boolean parseIntent(Resources resources, XmlResourceParser xmlResourceParser, boolean bl, boolean bl2, IntentInfo intentInfo, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseIntent", $$robo$$android_content_pm_PackageParser$parseIntent(android.content.res.Resources android.content.res.XmlResourceParser boolean boolean android.content.pm.PackageParser$IntentInfo java.lang.String[] ), 0, this, resources, xmlResourceParser, bl, bl2, intentInfo, stringArray);
    }

    private static boolean copyNeeded(int n, Package package_, PackageUserState packageUserState, Bundle bundle, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("copyNeeded", $$robo$$android_content_pm_PackageParser$copyNeeded(int android.content.pm.PackageParser$Package android.content.pm.PackageUserState android.os.Bundle int ), 0, (int)n, (Package)package_, (PackageUserState)packageUserState, (Bundle)bundle, (int)n2);
    }

    public static ApplicationInfo generateApplicationInfo(Package package_, int n, PackageUserState packageUserState) {
        return InvokeDynamicSupport.bootstrapStatic("generateApplicationInfo", $$robo$$android_content_pm_PackageParser$generateApplicationInfo(android.content.pm.PackageParser$Package int android.content.pm.PackageUserState ), 0, (Package)package_, (int)n, (PackageUserState)packageUserState);
    }

    private static void updateApplicationInfo(ApplicationInfo applicationInfo, int n, PackageUserState packageUserState) {
        InvokeDynamicSupport.bootstrapStatic("updateApplicationInfo", $$robo$$android_content_pm_PackageParser$updateApplicationInfo(android.content.pm.ApplicationInfo int android.content.pm.PackageUserState ), 0, (ApplicationInfo)applicationInfo, (int)n, (PackageUserState)packageUserState);
    }

    public static ApplicationInfo generateApplicationInfo(Package package_, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateApplicationInfo", $$robo$$android_content_pm_PackageParser$generateApplicationInfo(android.content.pm.PackageParser$Package int android.content.pm.PackageUserState int ), 0, (Package)package_, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static ApplicationInfo generateApplicationInfo(ApplicationInfo applicationInfo, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateApplicationInfo", $$robo$$android_content_pm_PackageParser$generateApplicationInfo(android.content.pm.ApplicationInfo int android.content.pm.PackageUserState int ), 0, (ApplicationInfo)applicationInfo, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static PermissionInfo generatePermissionInfo(Permission permission2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("generatePermissionInfo", $$robo$$android_content_pm_PackageParser$generatePermissionInfo(android.content.pm.PackageParser$Permission int ), 0, (Permission)permission2, (int)n);
    }

    public static PermissionGroupInfo generatePermissionGroupInfo(PermissionGroup permissionGroup, int n) {
        return InvokeDynamicSupport.bootstrapStatic("generatePermissionGroupInfo", $$robo$$android_content_pm_PackageParser$generatePermissionGroupInfo(android.content.pm.PackageParser$PermissionGroup int ), 0, (PermissionGroup)permissionGroup, (int)n);
    }

    public static ActivityInfo generateActivityInfo(Activity activity, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateActivityInfo", $$robo$$android_content_pm_PackageParser$generateActivityInfo(android.content.pm.PackageParser$Activity int android.content.pm.PackageUserState int ), 0, (Activity)activity, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static ActivityInfo generateActivityInfo(ActivityInfo activityInfo, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateActivityInfo", $$robo$$android_content_pm_PackageParser$generateActivityInfo(android.content.pm.ActivityInfo int android.content.pm.PackageUserState int ), 0, (ActivityInfo)activityInfo, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static ServiceInfo generateServiceInfo(Service service, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateServiceInfo", $$robo$$android_content_pm_PackageParser$generateServiceInfo(android.content.pm.PackageParser$Service int android.content.pm.PackageUserState int ), 0, (Service)service, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static ProviderInfo generateProviderInfo(Provider provider, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateProviderInfo", $$robo$$android_content_pm_PackageParser$generateProviderInfo(android.content.pm.PackageParser$Provider int android.content.pm.PackageUserState int ), 0, (Provider)provider, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static InstrumentationInfo generateInstrumentationInfo(Instrumentation instrumentation, int n) {
        return InvokeDynamicSupport.bootstrapStatic("generateInstrumentationInfo", $$robo$$android_content_pm_PackageParser$generateInstrumentationInfo(android.content.pm.PackageParser$Instrumentation int ), 0, (Instrumentation)instrumentation, (int)n);
    }

    public static void setCompatibilityModeEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setCompatibilityModeEnabled", $$robo$$android_content_pm_PackageParser$setCompatibilityModeEnabled(boolean ), 0, (boolean)bl);
    }

    static {
        RobolectricInternals.classInitializing(PackageParser.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class PackageParserException
    extends Exception
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int error;

        private void $$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(int error, String detailMessage) {
            this.error = error;
        }

        private void $$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(int error, String detailMessage, Throwable throwable) {
            this.error = error;
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(n, string2);
        }

        public PackageParserException(int n, String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(int java.lang.String ), 0, this, n, string2);
        }

        private void __constructor__(int n, String string2, Throwable throwable) {
            this.$$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(n, string2, throwable);
        }

        public PackageParserException(int n, String string2, Throwable throwable) {
            super(string2, throwable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(int java.lang.String java.lang.Throwable ), 0, this, n, string2, throwable);
        }

        public /* synthetic */ PackageParserException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageParserException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProviderIntentInfo
    extends IntentInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Provider provider;

        private void $$robo$$android_content_pm_PackageParser_ProviderIntentInfo$__constructor__(Provider provider) {
            this.provider = provider;
        }

        private final String $$robo$$android_content_pm_PackageParser_ProviderIntentInfo$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ProviderIntentInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.provider.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void $$robo$$android_content_pm_PackageParser_ProviderIntentInfo$__constructor__(Parcel in) {
        }

        private void __constructor__(Provider provider) {
            this.$$robo$$android_content_pm_PackageParser_ProviderIntentInfo$__constructor__(provider);
        }

        public ProviderIntentInfo(Provider provider) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ProviderIntentInfo$__constructor__(android.content.pm.PackageParser$Provider ), 0, this, provider);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_ProviderIntentInfo$toString(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageParser_ProviderIntentInfo$__constructor__(parcel);
        }

        public ProviderIntentInfo(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ProviderIntentInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public /* synthetic */ ProviderIntentInfo() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProviderIntentInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ServiceIntentInfo
    extends IntentInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Service service;

        private void $$robo$$android_content_pm_PackageParser_ServiceIntentInfo$__constructor__(Service _service) {
            this.service = _service;
        }

        private final String $$robo$$android_content_pm_PackageParser_ServiceIntentInfo$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ServiceIntentInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.service.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void $$robo$$android_content_pm_PackageParser_ServiceIntentInfo$__constructor__(Parcel in) {
        }

        private void __constructor__(Service service) {
            this.$$robo$$android_content_pm_PackageParser_ServiceIntentInfo$__constructor__(service);
        }

        public ServiceIntentInfo(Service service) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ServiceIntentInfo$__constructor__(android.content.pm.PackageParser$Service ), 0, this, service);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_ServiceIntentInfo$toString(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageParser_ServiceIntentInfo$__constructor__(parcel);
        }

        public ServiceIntentInfo(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ServiceIntentInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public /* synthetic */ ServiceIntentInfo() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceIntentInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ActivityIntentInfo
    extends IntentInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Activity activity;

        private void $$robo$$android_content_pm_PackageParser_ActivityIntentInfo$__constructor__(Activity _activity) {
            this.activity = _activity;
        }

        private final String $$robo$$android_content_pm_PackageParser_ActivityIntentInfo$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ActivityIntentInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.activity.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void $$robo$$android_content_pm_PackageParser_ActivityIntentInfo$__constructor__(Parcel in) {
        }

        private void __constructor__(Activity activity) {
            this.$$robo$$android_content_pm_PackageParser_ActivityIntentInfo$__constructor__(activity);
        }

        public ActivityIntentInfo(Activity activity) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ActivityIntentInfo$__constructor__(android.content.pm.PackageParser$Activity ), 0, this, activity);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_ActivityIntentInfo$toString(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageParser_ActivityIntentInfo$__constructor__(parcel);
        }

        public ActivityIntentInfo(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ActivityIntentInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public /* synthetic */ ActivityIntentInfo() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityIntentInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class IntentInfo
    extends IntentFilter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public boolean hasDefault;
        public int labelRes;
        public CharSequence nonLocalizedLabel;
        public int icon;
        public int logo;
        public int banner;
        public int preferred;

        private void $$robo$$android_content_pm_PackageParser_IntentInfo$__constructor__() {
        }

        private void $$robo$$android_content_pm_PackageParser_IntentInfo$__constructor__(Parcel dest) {
            this.hasDefault = dest.readInt() == 1;
            this.labelRes = dest.readInt();
            this.nonLocalizedLabel = dest.readCharSequence();
            this.icon = dest.readInt();
            this.logo = dest.readInt();
            this.banner = dest.readInt();
            this.preferred = dest.readInt();
        }

        private final void $$robo$$android_content_pm_PackageParser_IntentInfo$writeIntentInfoToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.hasDefault ? 1 : 0);
            dest.writeInt(this.labelRes);
            dest.writeCharSequence(this.nonLocalizedLabel);
            dest.writeInt(this.icon);
            dest.writeInt(this.logo);
            dest.writeInt(this.banner);
            dest.writeInt(this.preferred);
        }

        private void __constructor__() {
            this.$$robo$$android_content_pm_PackageParser_IntentInfo$__constructor__();
        }

        protected IntentInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_IntentInfo$__constructor__(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageParser_IntentInfo$__constructor__(parcel);
        }

        protected IntentInfo(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_IntentInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public void writeIntentInfoToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeIntentInfoToParcel", $$robo$$android_content_pm_PackageParser_IntentInfo$writeIntentInfoToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntentInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Instrumentation
    extends Component<IntentInfo>
    implements Parcelable {
        public transient /* synthetic */ Object __robo_data__;
        public InstrumentationInfo info;
        public static Parcelable.Creator CREATOR;

        private void $$robo$$android_content_pm_PackageParser_Instrumentation$__constructor__(ParsePackageItemArgs args, InstrumentationInfo _info) {
            this.info = _info;
        }

        private final void $$robo$$android_content_pm_PackageParser_Instrumentation$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_Instrumentation$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Instrumentation{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private final int $$robo$$android_content_pm_PackageParser_Instrumentation$describeContents() {
            return 0;
        }

        private final void $$robo$$android_content_pm_PackageParser_Instrumentation$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.info, flags);
        }

        private void $$robo$$android_content_pm_PackageParser_Instrumentation$__constructor__(Parcel in) {
            this.info = (InstrumentationInfo)in.readParcelable(Object.class.getClassLoader());
            if (this.info.targetPackage != null) {
                this.info.targetPackage = this.info.targetPackage.intern();
            }
            if (this.info.targetProcesses != null) {
                this.info.targetProcesses = this.info.targetProcesses.intern();
            }
        }

        private /* synthetic */ void $$robo$$android_content_pm_PackageParser_Instrumentation$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Instrumentation>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_content_pm_PackageParser_Instrumentation_1$__constructor__() {
                }

                private final Instrumentation $$robo$$android_content_pm_PackageParser_Instrumentation_1$createFromParcel(Parcel in) {
                    return new Instrumentation(in);
                }

                private final Instrumentation[] $$robo$$android_content_pm_PackageParser_Instrumentation_1$newArray(int size) {
                    return new Instrumentation[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_content_pm_PackageParser_Instrumentation_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Instrumentation_1$__constructor__(), 0, this);
                }

                @Override
                public Instrumentation createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_PackageParser_Instrumentation_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Instrumentation[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_PackageParser_Instrumentation_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(ParsePackageItemArgs parsePackageItemArgs, InstrumentationInfo instrumentationInfo) {
            this.$$robo$$android_content_pm_PackageParser_Instrumentation$__constructor__(parsePackageItemArgs, instrumentationInfo);
        }

        public Instrumentation(ParsePackageItemArgs parsePackageItemArgs, InstrumentationInfo instrumentationInfo) {
            super(parsePackageItemArgs, instrumentationInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Instrumentation$__constructor__(android.content.pm.PackageParser$ParsePackageItemArgs android.content.pm.InstrumentationInfo ), 0, this, parsePackageItemArgs, instrumentationInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Instrumentation$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Instrumentation$toString(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_PackageParser_Instrumentation$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_PackageParser_Instrumentation$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageParser_Instrumentation$__constructor__(parcel);
        }

        private Instrumentation(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Instrumentation$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_content_pm_PackageParser_Instrumentation$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Instrumentation.class);
        }

        public /* synthetic */ Instrumentation() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Instrumentation)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Provider
    extends Component<ProviderIntentInfo>
    implements Parcelable {
        public transient /* synthetic */ Object __robo_data__;
        public ProviderInfo info;
        public boolean syncable;
        public static Parcelable.Creator CREATOR;

        private void $$robo$$android_content_pm_PackageParser_Provider$__constructor__(ParseComponentArgs args, ProviderInfo _info) {
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
            this.syncable = false;
        }

        private void $$robo$$android_content_pm_PackageParser_Provider$__constructor__(Provider existingProvider) {
            this.info = existingProvider.info;
            this.syncable = existingProvider.syncable;
        }

        private final void $$robo$$android_content_pm_PackageParser_Provider$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_Provider$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Provider{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private final int $$robo$$android_content_pm_PackageParser_Provider$describeContents() {
            return 0;
        }

        private final void $$robo$$android_content_pm_PackageParser_Provider$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.info, flags | 2);
            dest.writeInt(this.syncable ? 1 : 0);
        }

        private void $$robo$$android_content_pm_PackageParser_Provider$__constructor__(Parcel in) {
            this.info = (ProviderInfo)in.readParcelable(Object.class.getClassLoader());
            this.syncable = in.readInt() == 1;
            for (ProviderIntentInfo aii : this.intents) {
                aii.provider = this;
            }
            if (this.info.readPermission != null) {
                this.info.readPermission = this.info.readPermission.intern();
            }
            if (this.info.writePermission != null) {
                this.info.writePermission = this.info.writePermission.intern();
            }
            if (this.info.authority != null) {
                this.info.authority = this.info.authority.intern();
            }
        }

        private /* synthetic */ void $$robo$$android_content_pm_PackageParser_Provider$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Provider>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_content_pm_PackageParser_Provider_1$__constructor__() {
                }

                private final Provider $$robo$$android_content_pm_PackageParser_Provider_1$createFromParcel(Parcel in) {
                    return new Provider(in);
                }

                private final Provider[] $$robo$$android_content_pm_PackageParser_Provider_1$newArray(int size) {
                    return new Provider[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_content_pm_PackageParser_Provider_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Provider_1$__constructor__(), 0, this);
                }

                @Override
                public Provider createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_PackageParser_Provider_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Provider[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_PackageParser_Provider_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(ParseComponentArgs parseComponentArgs, ProviderInfo providerInfo) {
            this.$$robo$$android_content_pm_PackageParser_Provider$__constructor__(parseComponentArgs, providerInfo);
        }

        public Provider(ParseComponentArgs parseComponentArgs, ProviderInfo providerInfo) {
            super(parseComponentArgs, providerInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Provider$__constructor__(android.content.pm.PackageParser$ParseComponentArgs android.content.pm.ProviderInfo ), 0, this, parseComponentArgs, providerInfo);
        }

        private void __constructor__(Provider provider) {
            this.$$robo$$android_content_pm_PackageParser_Provider$__constructor__(provider);
        }

        public Provider(Provider provider) {
            super(provider);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Provider$__constructor__(android.content.pm.PackageParser$Provider ), 0, this, provider);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Provider$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Provider$toString(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_PackageParser_Provider$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_PackageParser_Provider$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageParser_Provider$__constructor__(parcel);
        }

        private Provider(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Provider$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_content_pm_PackageParser_Provider$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Provider.class);
        }

        public /* synthetic */ Provider() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Provider)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Service
    extends Component<ServiceIntentInfo>
    implements Parcelable {
        public transient /* synthetic */ Object __robo_data__;
        public ServiceInfo info;
        public static Parcelable.Creator CREATOR;

        private void $$robo$$android_content_pm_PackageParser_Service$__constructor__(ParseComponentArgs args, ServiceInfo _info) {
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
        }

        private final void $$robo$$android_content_pm_PackageParser_Service$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_Service$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Service{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private final int $$robo$$android_content_pm_PackageParser_Service$describeContents() {
            return 0;
        }

        private final void $$robo$$android_content_pm_PackageParser_Service$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.info, flags | 2);
        }

        private void $$robo$$android_content_pm_PackageParser_Service$__constructor__(Parcel in) {
            this.info = (ServiceInfo)in.readParcelable(Object.class.getClassLoader());
            for (ServiceIntentInfo aii : this.intents) {
                aii.service = this;
                this.order = Math.max(aii.getOrder(), this.order);
            }
            if (this.info.permission != null) {
                this.info.permission = this.info.permission.intern();
            }
        }

        private /* synthetic */ void $$robo$$android_content_pm_PackageParser_Service$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Service>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_content_pm_PackageParser_Service_1$__constructor__() {
                }

                private final Service $$robo$$android_content_pm_PackageParser_Service_1$createFromParcel(Parcel in) {
                    return new Service(in);
                }

                private final Service[] $$robo$$android_content_pm_PackageParser_Service_1$newArray(int size) {
                    return new Service[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_content_pm_PackageParser_Service_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Service_1$__constructor__(), 0, this);
                }

                @Override
                public Service createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_PackageParser_Service_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Service[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_PackageParser_Service_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(ParseComponentArgs parseComponentArgs, ServiceInfo serviceInfo) {
            this.$$robo$$android_content_pm_PackageParser_Service$__constructor__(parseComponentArgs, serviceInfo);
        }

        public Service(ParseComponentArgs parseComponentArgs, ServiceInfo serviceInfo) {
            super(parseComponentArgs, serviceInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Service$__constructor__(android.content.pm.PackageParser$ParseComponentArgs android.content.pm.ServiceInfo ), 0, this, parseComponentArgs, serviceInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Service$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Service$toString(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_PackageParser_Service$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_PackageParser_Service$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageParser_Service$__constructor__(parcel);
        }

        private Service(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Service$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_content_pm_PackageParser_Service$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Service.class);
        }

        public /* synthetic */ Service() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Service)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Activity
    extends Component<ActivityIntentInfo>
    implements Parcelable {
        public transient /* synthetic */ Object __robo_data__;
        public ActivityInfo info;
        private boolean mHasMaxAspectRatio;
        public static Parcelable.Creator CREATOR;

        private final boolean $$robo$$android_content_pm_PackageParser_Activity$hasMaxAspectRatio() {
            return this.mHasMaxAspectRatio;
        }

        private void $$robo$$android_content_pm_PackageParser_Activity$__constructor__(ParseComponentArgs args, ActivityInfo _info) {
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
        }

        private final void $$robo$$android_content_pm_PackageParser_Activity$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final void $$robo$$android_content_pm_PackageParser_Activity$setMaxAspectRatio(float maxAspectRatio) {
            if (this.info.resizeMode == 2 || this.info.resizeMode == 1) {
                return;
            }
            if (maxAspectRatio < 1.0f && maxAspectRatio != 0.0f) {
                return;
            }
            this.info.maxAspectRatio = maxAspectRatio;
            this.mHasMaxAspectRatio = true;
        }

        private final String $$robo$$android_content_pm_PackageParser_Activity$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Activity{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private final int $$robo$$android_content_pm_PackageParser_Activity$describeContents() {
            return 0;
        }

        private final void $$robo$$android_content_pm_PackageParser_Activity$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.info, flags | 2);
            dest.writeBoolean(this.mHasMaxAspectRatio);
        }

        private void $$robo$$android_content_pm_PackageParser_Activity$__constructor__(Parcel in) {
            this.info = (ActivityInfo)in.readParcelable(Object.class.getClassLoader());
            this.mHasMaxAspectRatio = in.readBoolean();
            for (ActivityIntentInfo aii : this.intents) {
                aii.activity = this;
                this.order = Math.max(aii.getOrder(), this.order);
            }
            if (this.info.permission != null) {
                this.info.permission = this.info.permission.intern();
            }
        }

        private /* synthetic */ void $$robo$$android_content_pm_PackageParser_Activity$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Activity>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_content_pm_PackageParser_Activity_1$__constructor__() {
                }

                private final Activity $$robo$$android_content_pm_PackageParser_Activity_1$createFromParcel(Parcel in) {
                    return new Activity(in);
                }

                private final Activity[] $$robo$$android_content_pm_PackageParser_Activity_1$newArray(int size) {
                    return new Activity[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_content_pm_PackageParser_Activity_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Activity_1$__constructor__(), 0, this);
                }

                @Override
                public Activity createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_PackageParser_Activity_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Activity[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_PackageParser_Activity_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private boolean hasMaxAspectRatio() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasMaxAspectRatio", $$robo$$android_content_pm_PackageParser_Activity$hasMaxAspectRatio(), 0, this);
        }

        private void __constructor__(ParseComponentArgs parseComponentArgs, ActivityInfo activityInfo) {
            this.$$robo$$android_content_pm_PackageParser_Activity$__constructor__(parseComponentArgs, activityInfo);
        }

        public Activity(ParseComponentArgs parseComponentArgs, ActivityInfo activityInfo) {
            super(parseComponentArgs, activityInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Activity$__constructor__(android.content.pm.PackageParser$ParseComponentArgs android.content.pm.ActivityInfo ), 0, this, parseComponentArgs, activityInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Activity$setPackageName(java.lang.String ), 0, this, string2);
        }

        private void setMaxAspectRatio(float f) {
            InvokeDynamicSupport.bootstrap("setMaxAspectRatio", $$robo$$android_content_pm_PackageParser_Activity$setMaxAspectRatio(float ), 0, this, f);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Activity$toString(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_PackageParser_Activity$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_PackageParser_Activity$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageParser_Activity$__constructor__(parcel);
        }

        private Activity(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Activity$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_content_pm_PackageParser_Activity$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Activity.class);
        }

        public /* synthetic */ Activity() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Activity)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PermissionGroup
    extends Component<IntentInfo>
    implements Parcelable {
        public transient /* synthetic */ Object __robo_data__;
        public PermissionGroupInfo info;
        public static Parcelable.Creator CREATOR;

        private void $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(Package _owner) {
            this.info = new PermissionGroupInfo();
        }

        private void $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(Package _owner, PermissionGroupInfo _info) {
            this.info = _info;
        }

        private final void $$robo$$android_content_pm_PackageParser_PermissionGroup$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_PermissionGroup$toString() {
            return "PermissionGroup{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }

        private final int $$robo$$android_content_pm_PackageParser_PermissionGroup$describeContents() {
            return 0;
        }

        private final void $$robo$$android_content_pm_PackageParser_PermissionGroup$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.info, flags);
        }

        private void $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(Parcel in) {
            this.info = (PermissionGroupInfo)in.readParcelable(Object.class.getClassLoader());
        }

        private /* synthetic */ void $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<PermissionGroup>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_content_pm_PackageParser_PermissionGroup_1$__constructor__() {
                }

                private final PermissionGroup $$robo$$android_content_pm_PackageParser_PermissionGroup_1$createFromParcel(Parcel in) {
                    return new PermissionGroup(in);
                }

                private final PermissionGroup[] $$robo$$android_content_pm_PackageParser_PermissionGroup_1$newArray(int size) {
                    return new PermissionGroup[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_content_pm_PackageParser_PermissionGroup_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PermissionGroup_1$__constructor__(), 0, this);
                }

                @Override
                public PermissionGroup createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_PackageParser_PermissionGroup_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public PermissionGroup[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_PackageParser_PermissionGroup_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Package package_) {
            this.$$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(package_);
        }

        public PermissionGroup(Package package_) {
            super(package_);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(android.content.pm.PackageParser$Package ), 0, this, package_);
        }

        private void __constructor__(Package package_, PermissionGroupInfo permissionGroupInfo) {
            this.$$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(package_, permissionGroupInfo);
        }

        public PermissionGroup(Package package_, PermissionGroupInfo permissionGroupInfo) {
            super(package_);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(android.content.pm.PackageParser$Package android.content.pm.PermissionGroupInfo ), 0, this, package_, permissionGroupInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_PermissionGroup$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_PermissionGroup$toString(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_PackageParser_PermissionGroup$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_PackageParser_PermissionGroup$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(parcel);
        }

        private PermissionGroup(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(PermissionGroup.class);
        }

        public /* synthetic */ PermissionGroup() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PermissionGroup)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Permission
    extends Component<IntentInfo>
    implements Parcelable {
        public transient /* synthetic */ Object __robo_data__;
        public PermissionInfo info;
        public boolean tree;
        public PermissionGroup group;
        public static Parcelable.Creator CREATOR;

        private void $$robo$$android_content_pm_PackageParser_Permission$__constructor__(Package _owner) {
            this.info = new PermissionInfo();
        }

        private void $$robo$$android_content_pm_PackageParser_Permission$__constructor__(Package _owner, PermissionInfo _info) {
            this.info = _info;
        }

        private final void $$robo$$android_content_pm_PackageParser_Permission$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_Permission$toString() {
            return "Permission{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }

        private final int $$robo$$android_content_pm_PackageParser_Permission$describeContents() {
            return 0;
        }

        private final void $$robo$$android_content_pm_PackageParser_Permission$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.info, flags);
            dest.writeInt(this.tree ? 1 : 0);
            dest.writeParcelable(this.group, flags);
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Permission$isAppOp() {
            return this.info.isAppOp();
        }

        private void $$robo$$android_content_pm_PackageParser_Permission$__constructor__(Parcel in) {
            ClassLoader boot = Object.class.getClassLoader();
            this.info = (PermissionInfo)in.readParcelable(boot);
            if (this.info.group != null) {
                this.info.group = this.info.group.intern();
            }
            this.tree = in.readInt() == 1;
            this.group = (PermissionGroup)in.readParcelable(boot);
        }

        private /* synthetic */ void $$robo$$android_content_pm_PackageParser_Permission$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Permission>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_content_pm_PackageParser_Permission_1$__constructor__() {
                }

                private final Permission $$robo$$android_content_pm_PackageParser_Permission_1$createFromParcel(Parcel in) {
                    return new Permission(in);
                }

                private final Permission[] $$robo$$android_content_pm_PackageParser_Permission_1$newArray(int size) {
                    return new Permission[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_content_pm_PackageParser_Permission_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Permission_1$__constructor__(), 0, this);
                }

                @Override
                public Permission createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_PackageParser_Permission_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Permission[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_PackageParser_Permission_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Package package_) {
            this.$$robo$$android_content_pm_PackageParser_Permission$__constructor__(package_);
        }

        public Permission(Package package_) {
            super(package_);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Permission$__constructor__(android.content.pm.PackageParser$Package ), 0, this, package_);
        }

        private void __constructor__(Package package_, PermissionInfo permissionInfo) {
            this.$$robo$$android_content_pm_PackageParser_Permission$__constructor__(package_, permissionInfo);
        }

        public Permission(Package package_, PermissionInfo permissionInfo) {
            super(package_);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Permission$__constructor__(android.content.pm.PackageParser$Package android.content.pm.PermissionInfo ), 0, this, package_, permissionInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Permission$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Permission$toString(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_PackageParser_Permission$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_PackageParser_Permission$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public boolean isAppOp() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAppOp", $$robo$$android_content_pm_PackageParser_Permission$isAppOp(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageParser_Permission$__constructor__(parcel);
        }

        private Permission(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Permission$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_content_pm_PackageParser_Permission$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Permission.class);
        }

        public /* synthetic */ Permission() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Permission)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Component<II extends IntentInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public ArrayList<II> intents;
        public String className;
        public Bundle metaData;
        public Package owner;
        public int order;
        ComponentName componentName;
        String componentShortName;

        private void $$robo$$android_content_pm_PackageParser_Component$__constructor__(Package _owner) {
            this.owner = _owner;
            this.intents = null;
            this.className = null;
        }

        private void $$robo$$android_content_pm_PackageParser_Component$__constructor__(ParsePackageItemArgs args, PackageItemInfo outInfo) {
            this.owner = args.owner;
            this.intents = new ArrayList(0);
            this.className = PackageParser.parsePackageItemInfo(args.owner, outInfo, args.outError, args.tag, args.sa, true, args.nameRes, args.labelRes, args.iconRes, args.roundIconRes, args.logoRes, args.bannerRes) ? outInfo.name : null;
        }

        private void $$robo$$android_content_pm_PackageParser_Component$__constructor__(ParseComponentArgs args, ComponentInfo outInfo) {
            if (args.outError[0] != null) {
                return;
            }
            if (args.processRes != 0) {
                String pname = this.owner.applicationInfo.targetSdkVersion >= 8 ? args.sa.getNonConfigurationString(args.processRes, 1024) : args.sa.getNonResourceString(args.processRes);
                outInfo.processName = PackageParser.buildProcessName(this.owner.applicationInfo.packageName, this.owner.applicationInfo.processName, pname, args.flags, args.sepProcesses, args.outError);
            }
            if (args.descriptionRes != 0) {
                outInfo.descriptionRes = args.sa.getResourceId(args.descriptionRes, 0);
            }
            outInfo.enabled = args.sa.getBoolean(args.enabledRes, true);
        }

        private void $$robo$$android_content_pm_PackageParser_Component$__constructor__(Component<II> clone) {
            this.owner = clone.owner;
            this.intents = clone.intents;
            this.className = clone.className;
            this.componentName = clone.componentName;
            this.componentShortName = clone.componentShortName;
        }

        private final ComponentName $$robo$$android_content_pm_PackageParser_Component$getComponentName() {
            if (this.componentName != null) {
                return this.componentName;
            }
            if (this.className != null) {
                this.componentName = new ComponentName(this.owner.applicationInfo.packageName, this.className);
            }
            return this.componentName;
        }

        private void $$robo$$android_content_pm_PackageParser_Component$__constructor__(Parcel in) {
            this.className = in.readString();
            this.metaData = in.readBundle();
            this.intents = Component.createIntentsList(in);
            this.owner = null;
        }

        private final void $$robo$$android_content_pm_PackageParser_Component$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.className);
            dest.writeBundle(this.metaData);
            Component.writeIntentsList(this.intents, dest, flags);
        }

        private static final void $$robo$$android_content_pm_PackageParser_Component$writeIntentsList(ArrayList<? extends IntentInfo> list, Parcel out, int flags) {
            if (list == null) {
                out.writeInt(-1);
                return;
            }
            int N = list.size();
            out.writeInt(N);
            if (N > 0) {
                IntentInfo info = list.get(0);
                out.writeString(info.getClass().getName());
                for (int i = 0; i < N; ++i) {
                    list.get(i).writeIntentInfoToParcel(out, flags);
                }
            }
        }

        private static final <T extends IntentInfo> ArrayList<T> $$robo$$android_content_pm_PackageParser_Component$createIntentsList(Parcel in) {
            ArrayList<IntentInfo> intentsList;
            int N = in.readInt();
            if (N == -1) {
                return null;
            }
            if (N == 0) {
                return new ArrayList(0);
            }
            String componentName = in.readString();
            try {
                Class<?> cls = Class.forName(componentName);
                Constructor<?> cons = cls.getConstructor(Parcel.class);
                intentsList = new ArrayList<IntentInfo>(N);
                for (int i = 0; i < N; ++i) {
                    intentsList.add((IntentInfo)cons.newInstance(in));
                }
            }
            catch (ReflectiveOperationException ree) {
                throw new AssertionError((Object)("Unable to construct intent list for: " + componentName));
            }
            return intentsList;
        }

        private final void $$robo$$android_content_pm_PackageParser_Component$appendComponentShortName(StringBuilder sb) {
            ComponentName.appendShortString(sb, this.owner.applicationInfo.packageName, this.className);
        }

        private final void $$robo$$android_content_pm_PackageParser_Component$printComponentShortName(PrintWriter pw) {
            ComponentName.printShortString(pw, this.owner.applicationInfo.packageName, this.className);
        }

        private final void $$robo$$android_content_pm_PackageParser_Component$setPackageName(String packageName) {
            this.componentName = null;
            this.componentShortName = null;
        }

        private void __constructor__(Package package_) {
            this.$$robo$$android_content_pm_PackageParser_Component$__constructor__(package_);
        }

        public Component(Package package_) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Component$__constructor__(android.content.pm.PackageParser$Package ), 0, this, package_);
        }

        private void __constructor__(ParsePackageItemArgs parsePackageItemArgs, PackageItemInfo packageItemInfo) {
            this.$$robo$$android_content_pm_PackageParser_Component$__constructor__(parsePackageItemArgs, packageItemInfo);
        }

        public Component(ParsePackageItemArgs parsePackageItemArgs, PackageItemInfo packageItemInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Component$__constructor__(android.content.pm.PackageParser$ParsePackageItemArgs android.content.pm.PackageItemInfo ), 0, this, parsePackageItemArgs, packageItemInfo);
        }

        private void __constructor__(ParseComponentArgs parseComponentArgs, ComponentInfo componentInfo) {
            this.$$robo$$android_content_pm_PackageParser_Component$__constructor__(parseComponentArgs, componentInfo);
        }

        public Component(ParseComponentArgs parseComponentArgs, ComponentInfo componentInfo) {
            this((ParsePackageItemArgs)parseComponentArgs, (PackageItemInfo)componentInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Component$__constructor__(android.content.pm.PackageParser$ParseComponentArgs android.content.pm.ComponentInfo ), 0, this, parseComponentArgs, componentInfo);
        }

        private void __constructor__(Component<II> component) {
            this.$$robo$$android_content_pm_PackageParser_Component$__constructor__(component);
        }

        public Component(Component<II> component) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Component$__constructor__(android.content.pm.PackageParser$Component<II> ), 0, this, component);
        }

        public ComponentName getComponentName() {
            return InvokeDynamicSupport.bootstrap("getComponentName", $$robo$$android_content_pm_PackageParser_Component$getComponentName(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageParser_Component$__constructor__(parcel);
        }

        protected Component(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Component$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        protected void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_PackageParser_Component$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private static void writeIntentsList(ArrayList<? extends IntentInfo> arrayList, Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrapStatic("writeIntentsList", $$robo$$android_content_pm_PackageParser_Component$writeIntentsList(java.util.ArrayList<? extends android.content.pm.PackageParser$IntentInfo> android.os.Parcel int ), 0, arrayList, (Parcel)parcel, (int)n);
        }

        private static <T extends IntentInfo> ArrayList<T> createIntentsList(Parcel parcel) {
            return InvokeDynamicSupport.bootstrapStatic("createIntentsList", $$robo$$android_content_pm_PackageParser_Component$createIntentsList(android.os.Parcel ), 0, (Parcel)parcel);
        }

        public void appendComponentShortName(StringBuilder stringBuilder) {
            InvokeDynamicSupport.bootstrap("appendComponentShortName", $$robo$$android_content_pm_PackageParser_Component$appendComponentShortName(java.lang.StringBuilder ), 0, this, stringBuilder);
        }

        public void printComponentShortName(PrintWriter printWriter) {
            InvokeDynamicSupport.bootstrap("printComponentShortName", $$robo$$android_content_pm_PackageParser_Component$printComponentShortName(java.io.PrintWriter ), 0, this, printWriter);
        }

        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Component$setPackageName(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ Component() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Component)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Package
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String packageName;
        public String manifestPackageName;
        public String[] splitNames;
        public String volumeUuid;
        public String codePath;
        public String baseCodePath;
        public String[] splitCodePaths;
        public int baseRevisionCode;
        public int[] splitRevisionCodes;
        public int[] splitFlags;
        public int[] splitPrivateFlags;
        public boolean baseHardwareAccelerated;
        public ApplicationInfo applicationInfo;
        public ArrayList<Permission> permissions;
        public ArrayList<PermissionGroup> permissionGroups;
        public ArrayList<Activity> activities;
        public ArrayList<Activity> receivers;
        public ArrayList<Provider> providers;
        public ArrayList<Service> services;
        public ArrayList<Instrumentation> instrumentation;
        public ArrayList<String> requestedPermissions;
        public ArrayList<String> protectedBroadcasts;
        public Package parentPackage;
        public ArrayList<Package> childPackages;
        public String staticSharedLibName;
        public long staticSharedLibVersion;
        public ArrayList<String> libraryNames;
        public ArrayList<String> usesLibraries;
        public ArrayList<String> usesStaticLibraries;
        public long[] usesStaticLibrariesVersions;
        public String[][] usesStaticLibrariesCertDigests;
        public ArrayList<String> usesOptionalLibraries;
        public String[] usesLibraryFiles;
        public ArrayList<ActivityIntentInfo> preferredActivityFilters;
        public ArrayList<String> mOriginalPackages;
        public String mRealPackage;
        public ArrayList<String> mAdoptPermissions;
        public Bundle mAppMetaData;
        public int mVersionCode;
        public int mVersionCodeMajor;
        public String mVersionName;
        public String mSharedUserId;
        public int mSharedUserLabel;
        public SigningDetails mSigningDetails;
        public int mPreferredOrder;
        public long[] mLastPackageUsageTimeInMills;
        public Object mExtras;
        public ArrayList<ConfigurationInfo> configPreferences;
        public ArrayList<FeatureInfo> reqFeatures;
        public ArrayList<FeatureGroupInfo> featureGroups;
        public int installLocation;
        public boolean coreApp;
        public boolean mRequiredForAllUsers;
        public String mRestrictedAccountType;
        public String mRequiredAccountType;
        public String mOverlayTarget;
        public String mOverlayCategory;
        public int mOverlayPriority;
        public boolean mOverlayIsStatic;
        public int mCompileSdkVersion;
        public String mCompileSdkVersionCodename;
        public ArraySet<String> mUpgradeKeySets;
        public ArrayMap<String, ArraySet<PublicKey>> mKeySetMapping;
        public String cpuAbiOverride;
        public boolean use32bitAbi;
        public byte[] restrictUpdateHash;
        public boolean visibleToInstantApps;
        public boolean isStub;
        public static Parcelable.Creator CREATOR;

        private final long $$robo$$android_content_pm_PackageParser_Package$getLongVersionCode() {
            return PackageInfo.composeLongVersionCode(this.mVersionCodeMajor, this.mVersionCode);
        }

        private void $$robo$$android_content_pm_PackageParser_Package$__constructor__(String packageName) {
            this.applicationInfo = new ApplicationInfo();
            this.permissions = new ArrayList(0);
            this.permissionGroups = new ArrayList(0);
            this.activities = new ArrayList(0);
            this.receivers = new ArrayList(0);
            this.providers = new ArrayList(0);
            this.services = new ArrayList(0);
            this.instrumentation = new ArrayList(0);
            this.requestedPermissions = new ArrayList();
            this.staticSharedLibName = null;
            this.staticSharedLibVersion = 0L;
            this.libraryNames = null;
            this.usesLibraries = null;
            this.usesStaticLibraries = null;
            this.usesStaticLibrariesVersions = null;
            this.usesStaticLibrariesCertDigests = null;
            this.usesOptionalLibraries = null;
            this.usesLibraryFiles = null;
            this.preferredActivityFilters = null;
            this.mOriginalPackages = null;
            this.mRealPackage = null;
            this.mAdoptPermissions = null;
            this.mAppMetaData = null;
            this.mSigningDetails = SigningDetails.UNKNOWN;
            this.mPreferredOrder = 0;
            this.mLastPackageUsageTimeInMills = new long[8];
            this.configPreferences = null;
            this.reqFeatures = null;
            this.featureGroups = null;
            this.packageName = packageName;
            this.manifestPackageName = packageName;
            this.applicationInfo.packageName = packageName;
            this.applicationInfo.uid = -1;
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationVolumeUuid(String volumeUuid) {
            UUID storageUuid = StorageManager.convert(volumeUuid);
            this.applicationInfo.volumeUuid = volumeUuid;
            this.applicationInfo.storageUuid = storageUuid;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.volumeUuid = volumeUuid;
                    this.childPackages.get((int)i).applicationInfo.storageUuid = storageUuid;
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoCodePath(String codePath) {
            this.applicationInfo.setCodePath(codePath);
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.setCodePath(codePath);
                }
            }
        }

        @Deprecated
        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoResourcePath(String resourcePath) {
            this.applicationInfo.setResourcePath(resourcePath);
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.setResourcePath(resourcePath);
                }
            }
        }

        @Deprecated
        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoBaseResourcePath(String resourcePath) {
            this.applicationInfo.setBaseResourcePath(resourcePath);
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.setBaseResourcePath(resourcePath);
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoBaseCodePath(String baseCodePath) {
            this.applicationInfo.setBaseCodePath(baseCodePath);
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.setBaseCodePath(baseCodePath);
                }
            }
        }

        private final List<String> $$robo$$android_content_pm_PackageParser_Package$getChildPackageNames() {
            if (this.childPackages == null) {
                return null;
            }
            int childCount = this.childPackages.size();
            ArrayList<String> childPackageNames = new ArrayList<String>(childCount);
            for (int i = 0; i < childCount; ++i) {
                String childPackageName = this.childPackages.get((int)i).packageName;
                childPackageNames.add(childPackageName);
            }
            return childPackageNames;
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$hasChildPackage(String packageName) {
            int childCount = this.childPackages != null ? this.childPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                if (!this.childPackages.get((int)i).packageName.equals(packageName)) continue;
                return true;
            }
            return false;
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoSplitCodePaths(String[] splitCodePaths) {
            this.applicationInfo.setSplitCodePaths(splitCodePaths);
        }

        @Deprecated
        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoSplitResourcePaths(String[] resroucePaths) {
            this.applicationInfo.setSplitResourcePaths(resroucePaths);
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setSplitCodePaths(String[] codePaths) {
            this.splitCodePaths = codePaths;
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setCodePath(String codePath) {
            this.codePath = codePath;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).codePath = codePath;
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setBaseCodePath(String baseCodePath) {
            this.baseCodePath = baseCodePath;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).baseCodePath = baseCodePath;
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setSigningDetails(SigningDetails signingDetails) {
            this.mSigningDetails = signingDetails;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).mSigningDetails = signingDetails;
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setVolumeUuid(String volumeUuid) {
            this.volumeUuid = volumeUuid;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).volumeUuid = volumeUuid;
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoFlags(int mask, int flags) {
            this.applicationInfo.flags = this.applicationInfo.flags & ~mask | mask & flags;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.flags = this.applicationInfo.flags & ~mask | mask & flags;
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setUse32bitAbi(boolean use32bitAbi) {
            this.use32bitAbi = use32bitAbi;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).use32bitAbi = use32bitAbi;
                }
            }
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isLibrary() {
            return this.staticSharedLibName != null || !ArrayUtils.isEmpty(this.libraryNames);
        }

        private final List<String> $$robo$$android_content_pm_PackageParser_Package$getAllCodePaths() {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(this.baseCodePath);
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                Collections.addAll(paths, this.splitCodePaths);
            }
            return paths;
        }

        private final List<String> $$robo$$android_content_pm_PackageParser_Package$getAllCodePathsExcludingResourceOnly() {
            ArrayList<String> paths = new ArrayList<String>();
            if ((this.applicationInfo.flags & 4) != 0) {
                paths.add(this.baseCodePath);
            }
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                for (int i = 0; i < this.splitCodePaths.length; ++i) {
                    if ((this.splitFlags[i] & 4) == 0) continue;
                    paths.add(this.splitCodePaths[i]);
                }
            }
            return paths;
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setPackageName(String newName) {
            int i;
            this.packageName = newName;
            this.applicationInfo.packageName = newName;
            for (i = this.permissions.size() - 1; i >= 0; --i) {
                this.permissions.get(i).setPackageName(newName);
            }
            for (i = this.permissionGroups.size() - 1; i >= 0; --i) {
                this.permissionGroups.get(i).setPackageName(newName);
            }
            for (i = this.activities.size() - 1; i >= 0; --i) {
                this.activities.get(i).setPackageName(newName);
            }
            for (i = this.receivers.size() - 1; i >= 0; --i) {
                this.receivers.get(i).setPackageName(newName);
            }
            for (i = this.providers.size() - 1; i >= 0; --i) {
                this.providers.get(i).setPackageName(newName);
            }
            for (i = this.services.size() - 1; i >= 0; --i) {
                this.services.get(i).setPackageName(newName);
            }
            for (i = this.instrumentation.size() - 1; i >= 0; --i) {
                this.instrumentation.get(i).setPackageName(newName);
            }
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$hasComponentClassName(String name) {
            int i;
            for (i = this.activities.size() - 1; i >= 0; --i) {
                if (!name.equals(this.activities.get((int)i).className)) continue;
                return true;
            }
            for (i = this.receivers.size() - 1; i >= 0; --i) {
                if (!name.equals(this.receivers.get((int)i).className)) continue;
                return true;
            }
            for (i = this.providers.size() - 1; i >= 0; --i) {
                if (!name.equals(this.providers.get((int)i).className)) continue;
                return true;
            }
            for (i = this.services.size() - 1; i >= 0; --i) {
                if (!name.equals(this.services.get((int)i).className)) continue;
                return true;
            }
            for (i = this.instrumentation.size() - 1; i >= 0; --i) {
                if (!name.equals(this.instrumentation.get((int)i).className)) continue;
                return true;
            }
            return false;
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isExternal() {
            return this.applicationInfo.isExternal();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isForwardLocked() {
            return this.applicationInfo.isForwardLocked();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isOem() {
            return this.applicationInfo.isOem();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isVendor() {
            return this.applicationInfo.isVendor();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isProduct() {
            return this.applicationInfo.isProduct();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isPrivileged() {
            return this.applicationInfo.isPrivilegedApp();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isSystem() {
            return this.applicationInfo.isSystemApp();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isUpdatedSystemApp() {
            return this.applicationInfo.isUpdatedSystemApp();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$canHaveOatDir() {
            return (!this.isSystem() || this.isUpdatedSystemApp()) && !this.isForwardLocked() && !this.applicationInfo.isExternalAsec();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isMatch(int flags) {
            if ((flags & 0x100000) != 0) {
                return this.isSystem();
            }
            return true;
        }

        private final long $$robo$$android_content_pm_PackageParser_Package$getLatestPackageUseTimeInMills() {
            long latestUse = 0L;
            for (long use : this.mLastPackageUsageTimeInMills) {
                latestUse = Math.max(latestUse, use);
            }
            return latestUse;
        }

        private final long $$robo$$android_content_pm_PackageParser_Package$getLatestForegroundPackageUseTimeInMills() {
            int[] foregroundReasons = new int[]{0, 2};
            long latestUse = 0L;
            for (int reason : foregroundReasons) {
                latestUse = Math.max(latestUse, this.mLastPackageUsageTimeInMills[reason]);
            }
            return latestUse;
        }

        private final String $$robo$$android_content_pm_PackageParser_Package$toString() {
            return "Package{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
        }

        private final int $$robo$$android_content_pm_PackageParser_Package$describeContents() {
            return 0;
        }

        private void $$robo$$android_content_pm_PackageParser_Package$__constructor__(Parcel dest) {
            this.applicationInfo = new ApplicationInfo();
            this.permissions = new ArrayList(0);
            this.permissionGroups = new ArrayList(0);
            this.activities = new ArrayList(0);
            this.receivers = new ArrayList(0);
            this.providers = new ArrayList(0);
            this.services = new ArrayList(0);
            this.instrumentation = new ArrayList(0);
            this.requestedPermissions = new ArrayList();
            this.staticSharedLibName = null;
            this.staticSharedLibVersion = 0L;
            this.libraryNames = null;
            this.usesLibraries = null;
            this.usesStaticLibraries = null;
            this.usesStaticLibrariesVersions = null;
            this.usesStaticLibrariesCertDigests = null;
            this.usesOptionalLibraries = null;
            this.usesLibraryFiles = null;
            this.preferredActivityFilters = null;
            this.mOriginalPackages = null;
            this.mRealPackage = null;
            this.mAdoptPermissions = null;
            this.mAppMetaData = null;
            this.mSigningDetails = SigningDetails.UNKNOWN;
            this.mPreferredOrder = 0;
            this.mLastPackageUsageTimeInMills = new long[8];
            this.configPreferences = null;
            this.reqFeatures = null;
            this.featureGroups = null;
            ClassLoader boot = Object.class.getClassLoader();
            this.packageName = dest.readString().intern();
            this.manifestPackageName = dest.readString();
            this.splitNames = dest.readStringArray();
            this.volumeUuid = dest.readString();
            this.codePath = dest.readString();
            this.baseCodePath = dest.readString();
            this.splitCodePaths = dest.readStringArray();
            this.baseRevisionCode = dest.readInt();
            this.splitRevisionCodes = dest.createIntArray();
            this.splitFlags = dest.createIntArray();
            this.splitPrivateFlags = dest.createIntArray();
            this.baseHardwareAccelerated = dest.readInt() == 1;
            this.applicationInfo = (ApplicationInfo)dest.readParcelable(boot);
            if (this.applicationInfo.permission != null) {
                this.applicationInfo.permission = this.applicationInfo.permission.intern();
            }
            dest.readParcelableList(this.permissions, boot);
            this.fixupOwner(this.permissions);
            dest.readParcelableList(this.permissionGroups, boot);
            this.fixupOwner(this.permissionGroups);
            dest.readParcelableList(this.activities, boot);
            this.fixupOwner(this.activities);
            dest.readParcelableList(this.receivers, boot);
            this.fixupOwner(this.receivers);
            dest.readParcelableList(this.providers, boot);
            this.fixupOwner(this.providers);
            dest.readParcelableList(this.services, boot);
            this.fixupOwner(this.services);
            dest.readParcelableList(this.instrumentation, boot);
            this.fixupOwner(this.instrumentation);
            dest.readStringList(this.requestedPermissions);
            Package.internStringArrayList(this.requestedPermissions);
            this.protectedBroadcasts = dest.createStringArrayList();
            Package.internStringArrayList(this.protectedBroadcasts);
            this.parentPackage = (Package)dest.readParcelable(boot);
            this.childPackages = new ArrayList();
            dest.readParcelableList(this.childPackages, boot);
            if (this.childPackages.size() == 0) {
                this.childPackages = null;
            }
            this.staticSharedLibName = dest.readString();
            if (this.staticSharedLibName != null) {
                this.staticSharedLibName = this.staticSharedLibName.intern();
            }
            this.staticSharedLibVersion = dest.readLong();
            this.libraryNames = dest.createStringArrayList();
            Package.internStringArrayList(this.libraryNames);
            this.usesLibraries = dest.createStringArrayList();
            Package.internStringArrayList(this.usesLibraries);
            this.usesOptionalLibraries = dest.createStringArrayList();
            Package.internStringArrayList(this.usesOptionalLibraries);
            this.usesLibraryFiles = dest.readStringArray();
            int libCount = dest.readInt();
            if (libCount > 0) {
                this.usesStaticLibraries = new ArrayList(libCount);
                dest.readStringList(this.usesStaticLibraries);
                Package.internStringArrayList(this.usesStaticLibraries);
                this.usesStaticLibrariesVersions = new long[libCount];
                dest.readLongArray(this.usesStaticLibrariesVersions);
                this.usesStaticLibrariesCertDigests = new String[libCount][];
                for (int i = 0; i < libCount; ++i) {
                    this.usesStaticLibrariesCertDigests[i] = dest.createStringArray();
                }
            }
            this.preferredActivityFilters = new ArrayList();
            dest.readParcelableList(this.preferredActivityFilters, boot);
            if (this.preferredActivityFilters.size() == 0) {
                this.preferredActivityFilters = null;
            }
            this.mOriginalPackages = dest.createStringArrayList();
            this.mRealPackage = dest.readString();
            this.mAdoptPermissions = dest.createStringArrayList();
            this.mAppMetaData = dest.readBundle();
            this.mVersionCode = dest.readInt();
            this.mVersionCodeMajor = dest.readInt();
            this.mVersionName = dest.readString();
            if (this.mVersionName != null) {
                this.mVersionName = this.mVersionName.intern();
            }
            this.mSharedUserId = dest.readString();
            if (this.mSharedUserId != null) {
                this.mSharedUserId = this.mSharedUserId.intern();
            }
            this.mSharedUserLabel = dest.readInt();
            this.mSigningDetails = (SigningDetails)dest.readParcelable(boot);
            this.mPreferredOrder = dest.readInt();
            this.configPreferences = new ArrayList();
            dest.readParcelableList(this.configPreferences, boot);
            if (this.configPreferences.size() == 0) {
                this.configPreferences = null;
            }
            this.reqFeatures = new ArrayList();
            dest.readParcelableList(this.reqFeatures, boot);
            if (this.reqFeatures.size() == 0) {
                this.reqFeatures = null;
            }
            this.featureGroups = new ArrayList();
            dest.readParcelableList(this.featureGroups, boot);
            if (this.featureGroups.size() == 0) {
                this.featureGroups = null;
            }
            this.installLocation = dest.readInt();
            this.coreApp = dest.readInt() == 1;
            this.mRequiredForAllUsers = dest.readInt() == 1;
            this.mRestrictedAccountType = dest.readString();
            this.mRequiredAccountType = dest.readString();
            this.mOverlayTarget = dest.readString();
            this.mOverlayCategory = dest.readString();
            this.mOverlayPriority = dest.readInt();
            this.mOverlayIsStatic = dest.readInt() == 1;
            this.mCompileSdkVersion = dest.readInt();
            this.mCompileSdkVersionCodename = dest.readString();
            this.mUpgradeKeySets = dest.readArraySet(boot);
            this.mKeySetMapping = Package.readKeySetMapping(dest);
            this.cpuAbiOverride = dest.readString();
            this.use32bitAbi = dest.readInt() == 1;
            this.restrictUpdateHash = dest.createByteArray();
            this.visibleToInstantApps = dest.readInt() == 1;
        }

        private static final void $$robo$$android_content_pm_PackageParser_Package$internStringArrayList(List<String> list) {
            if (list != null) {
                int N = list.size();
                for (int i = 0; i < N; ++i) {
                    list.set(i, list.get(i).intern());
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$fixupOwner(List<? extends Component<?>> list) {
            if (list != null) {
                for (Component<?> c : list) {
                    c.owner = this;
                    if (c instanceof Activity) {
                        ((Activity)c).info.applicationInfo = this.applicationInfo;
                        continue;
                    }
                    if (c instanceof Service) {
                        ((Service)c).info.applicationInfo = this.applicationInfo;
                        continue;
                    }
                    if (!(c instanceof Provider)) continue;
                    ((Provider)c).info.applicationInfo = this.applicationInfo;
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.packageName);
            dest.writeString(this.manifestPackageName);
            dest.writeStringArray(this.splitNames);
            dest.writeString(this.volumeUuid);
            dest.writeString(this.codePath);
            dest.writeString(this.baseCodePath);
            dest.writeStringArray(this.splitCodePaths);
            dest.writeInt(this.baseRevisionCode);
            dest.writeIntArray(this.splitRevisionCodes);
            dest.writeIntArray(this.splitFlags);
            dest.writeIntArray(this.splitPrivateFlags);
            dest.writeInt(this.baseHardwareAccelerated ? 1 : 0);
            dest.writeParcelable(this.applicationInfo, flags);
            dest.writeParcelableList(this.permissions, flags);
            dest.writeParcelableList(this.permissionGroups, flags);
            dest.writeParcelableList(this.activities, flags);
            dest.writeParcelableList(this.receivers, flags);
            dest.writeParcelableList(this.providers, flags);
            dest.writeParcelableList(this.services, flags);
            dest.writeParcelableList(this.instrumentation, flags);
            dest.writeStringList(this.requestedPermissions);
            dest.writeStringList(this.protectedBroadcasts);
            dest.writeParcelable(this.parentPackage, flags);
            dest.writeParcelableList(this.childPackages, flags);
            dest.writeString(this.staticSharedLibName);
            dest.writeLong(this.staticSharedLibVersion);
            dest.writeStringList(this.libraryNames);
            dest.writeStringList(this.usesLibraries);
            dest.writeStringList(this.usesOptionalLibraries);
            dest.writeStringArray(this.usesLibraryFiles);
            if (ArrayUtils.isEmpty(this.usesStaticLibraries)) {
                dest.writeInt(-1);
            } else {
                dest.writeInt(this.usesStaticLibraries.size());
                dest.writeStringList(this.usesStaticLibraries);
                dest.writeLongArray(this.usesStaticLibrariesVersions);
                for (String[] usesStaticLibrariesCertDigest : this.usesStaticLibrariesCertDigests) {
                    dest.writeStringArray(usesStaticLibrariesCertDigest);
                }
            }
            dest.writeParcelableList(this.preferredActivityFilters, flags);
            dest.writeStringList(this.mOriginalPackages);
            dest.writeString(this.mRealPackage);
            dest.writeStringList(this.mAdoptPermissions);
            dest.writeBundle(this.mAppMetaData);
            dest.writeInt(this.mVersionCode);
            dest.writeInt(this.mVersionCodeMajor);
            dest.writeString(this.mVersionName);
            dest.writeString(this.mSharedUserId);
            dest.writeInt(this.mSharedUserLabel);
            dest.writeParcelable(this.mSigningDetails, flags);
            dest.writeInt(this.mPreferredOrder);
            dest.writeParcelableList(this.configPreferences, flags);
            dest.writeParcelableList(this.reqFeatures, flags);
            dest.writeParcelableList(this.featureGroups, flags);
            dest.writeInt(this.installLocation);
            dest.writeInt(this.coreApp ? 1 : 0);
            dest.writeInt(this.mRequiredForAllUsers ? 1 : 0);
            dest.writeString(this.mRestrictedAccountType);
            dest.writeString(this.mRequiredAccountType);
            dest.writeString(this.mOverlayTarget);
            dest.writeString(this.mOverlayCategory);
            dest.writeInt(this.mOverlayPriority);
            dest.writeInt(this.mOverlayIsStatic ? 1 : 0);
            dest.writeInt(this.mCompileSdkVersion);
            dest.writeString(this.mCompileSdkVersionCodename);
            dest.writeArraySet(this.mUpgradeKeySets);
            Package.writeKeySetMapping(dest, this.mKeySetMapping);
            dest.writeString(this.cpuAbiOverride);
            dest.writeInt(this.use32bitAbi ? 1 : 0);
            dest.writeByteArray(this.restrictUpdateHash);
            dest.writeInt(this.visibleToInstantApps ? 1 : 0);
        }

        private static final void $$robo$$android_content_pm_PackageParser_Package$writeKeySetMapping(Parcel dest, ArrayMap<String, ArraySet<PublicKey>> keySetMapping) {
            if (keySetMapping == null) {
                dest.writeInt(-1);
                return;
            }
            int N = keySetMapping.size();
            dest.writeInt(N);
            for (int i = 0; i < N; ++i) {
                dest.writeString(keySetMapping.keyAt(i));
                ArraySet<PublicKey> keys = keySetMapping.valueAt(i);
                if (keys == null) {
                    dest.writeInt(-1);
                    continue;
                }
                int M = keys.size();
                dest.writeInt(M);
                for (int j = 0; j < M; ++j) {
                    dest.writeSerializable(keys.valueAt(j));
                }
            }
        }

        private static final ArrayMap<String, ArraySet<PublicKey>> $$robo$$android_content_pm_PackageParser_Package$readKeySetMapping(Parcel in) {
            int N = in.readInt();
            if (N == -1) {
                return null;
            }
            ArrayMap<String, ArraySet<PublicKey>> keySetMapping = new ArrayMap<String, ArraySet<PublicKey>>();
            for (int i = 0; i < N; ++i) {
                String key = in.readString();
                int M = in.readInt();
                if (M == -1) {
                    keySetMapping.put(key, null);
                    continue;
                }
                ArraySet<PublicKey> keys = new ArraySet<PublicKey>(M);
                for (int j = 0; j < M; ++j) {
                    PublicKey pk = (PublicKey)in.readSerializable();
                    keys.add(pk);
                }
                keySetMapping.put(key, keys);
            }
            return keySetMapping;
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Package>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_content_pm_PackageParser_Package_1$__constructor__() {
                }

                private final Package $$robo$$android_content_pm_PackageParser_Package_1$createFromParcel(Parcel in) {
                    return new Package(in);
                }

                private final Package[] $$robo$$android_content_pm_PackageParser_Package_1$newArray(int size) {
                    return new Package[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_content_pm_PackageParser_Package_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Package_1$__constructor__(), 0, this);
                }

                @Override
                public Package createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_PackageParser_Package_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Package[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_PackageParser_Package_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        public long getLongVersionCode() {
            return (long)InvokeDynamicSupport.bootstrap("getLongVersionCode", $$robo$$android_content_pm_PackageParser_Package$getLongVersionCode(), 0, this);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_content_pm_PackageParser_Package$__constructor__(string2);
        }

        public Package(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Package$__constructor__(java.lang.String ), 0, this, string2);
        }

        public void setApplicationVolumeUuid(String string2) {
            InvokeDynamicSupport.bootstrap("setApplicationVolumeUuid", $$robo$$android_content_pm_PackageParser_Package$setApplicationVolumeUuid(java.lang.String ), 0, this, string2);
        }

        public void setApplicationInfoCodePath(String string2) {
            InvokeDynamicSupport.bootstrap("setApplicationInfoCodePath", $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoCodePath(java.lang.String ), 0, this, string2);
        }

        @Deprecated
        public void setApplicationInfoResourcePath(String string2) {
            InvokeDynamicSupport.bootstrap("setApplicationInfoResourcePath", $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoResourcePath(java.lang.String ), 0, this, string2);
        }

        @Deprecated
        public void setApplicationInfoBaseResourcePath(String string2) {
            InvokeDynamicSupport.bootstrap("setApplicationInfoBaseResourcePath", $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoBaseResourcePath(java.lang.String ), 0, this, string2);
        }

        public void setApplicationInfoBaseCodePath(String string2) {
            InvokeDynamicSupport.bootstrap("setApplicationInfoBaseCodePath", $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoBaseCodePath(java.lang.String ), 0, this, string2);
        }

        public List<String> getChildPackageNames() {
            return InvokeDynamicSupport.bootstrap("getChildPackageNames", $$robo$$android_content_pm_PackageParser_Package$getChildPackageNames(), 0, this);
        }

        public boolean hasChildPackage(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasChildPackage", $$robo$$android_content_pm_PackageParser_Package$hasChildPackage(java.lang.String ), 0, this, string2);
        }

        public void setApplicationInfoSplitCodePaths(String[] stringArray) {
            InvokeDynamicSupport.bootstrap("setApplicationInfoSplitCodePaths", $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoSplitCodePaths(java.lang.String[] ), 0, this, stringArray);
        }

        @Deprecated
        public void setApplicationInfoSplitResourcePaths(String[] stringArray) {
            InvokeDynamicSupport.bootstrap("setApplicationInfoSplitResourcePaths", $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoSplitResourcePaths(java.lang.String[] ), 0, this, stringArray);
        }

        public void setSplitCodePaths(String[] stringArray) {
            InvokeDynamicSupport.bootstrap("setSplitCodePaths", $$robo$$android_content_pm_PackageParser_Package$setSplitCodePaths(java.lang.String[] ), 0, this, stringArray);
        }

        public void setCodePath(String string2) {
            InvokeDynamicSupport.bootstrap("setCodePath", $$robo$$android_content_pm_PackageParser_Package$setCodePath(java.lang.String ), 0, this, string2);
        }

        public void setBaseCodePath(String string2) {
            InvokeDynamicSupport.bootstrap("setBaseCodePath", $$robo$$android_content_pm_PackageParser_Package$setBaseCodePath(java.lang.String ), 0, this, string2);
        }

        public void setSigningDetails(SigningDetails signingDetails) {
            InvokeDynamicSupport.bootstrap("setSigningDetails", $$robo$$android_content_pm_PackageParser_Package$setSigningDetails(android.content.pm.PackageParser$SigningDetails ), 0, this, signingDetails);
        }

        public void setVolumeUuid(String string2) {
            InvokeDynamicSupport.bootstrap("setVolumeUuid", $$robo$$android_content_pm_PackageParser_Package$setVolumeUuid(java.lang.String ), 0, this, string2);
        }

        public void setApplicationInfoFlags(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setApplicationInfoFlags", $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoFlags(int int ), 0, this, n, n2);
        }

        public void setUse32bitAbi(boolean bl) {
            InvokeDynamicSupport.bootstrap("setUse32bitAbi", $$robo$$android_content_pm_PackageParser_Package$setUse32bitAbi(boolean ), 0, this, bl);
        }

        public boolean isLibrary() {
            return (boolean)InvokeDynamicSupport.bootstrap("isLibrary", $$robo$$android_content_pm_PackageParser_Package$isLibrary(), 0, this);
        }

        public List<String> getAllCodePaths() {
            return InvokeDynamicSupport.bootstrap("getAllCodePaths", $$robo$$android_content_pm_PackageParser_Package$getAllCodePaths(), 0, this);
        }

        public List<String> getAllCodePathsExcludingResourceOnly() {
            return InvokeDynamicSupport.bootstrap("getAllCodePathsExcludingResourceOnly", $$robo$$android_content_pm_PackageParser_Package$getAllCodePathsExcludingResourceOnly(), 0, this);
        }

        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Package$setPackageName(java.lang.String ), 0, this, string2);
        }

        public boolean hasComponentClassName(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasComponentClassName", $$robo$$android_content_pm_PackageParser_Package$hasComponentClassName(java.lang.String ), 0, this, string2);
        }

        public boolean isExternal() {
            return (boolean)InvokeDynamicSupport.bootstrap("isExternal", $$robo$$android_content_pm_PackageParser_Package$isExternal(), 0, this);
        }

        public boolean isForwardLocked() {
            return (boolean)InvokeDynamicSupport.bootstrap("isForwardLocked", $$robo$$android_content_pm_PackageParser_Package$isForwardLocked(), 0, this);
        }

        public boolean isOem() {
            return (boolean)InvokeDynamicSupport.bootstrap("isOem", $$robo$$android_content_pm_PackageParser_Package$isOem(), 0, this);
        }

        public boolean isVendor() {
            return (boolean)InvokeDynamicSupport.bootstrap("isVendor", $$robo$$android_content_pm_PackageParser_Package$isVendor(), 0, this);
        }

        public boolean isProduct() {
            return (boolean)InvokeDynamicSupport.bootstrap("isProduct", $$robo$$android_content_pm_PackageParser_Package$isProduct(), 0, this);
        }

        public boolean isPrivileged() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPrivileged", $$robo$$android_content_pm_PackageParser_Package$isPrivileged(), 0, this);
        }

        public boolean isSystem() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSystem", $$robo$$android_content_pm_PackageParser_Package$isSystem(), 0, this);
        }

        public boolean isUpdatedSystemApp() {
            return (boolean)InvokeDynamicSupport.bootstrap("isUpdatedSystemApp", $$robo$$android_content_pm_PackageParser_Package$isUpdatedSystemApp(), 0, this);
        }

        public boolean canHaveOatDir() {
            return (boolean)InvokeDynamicSupport.bootstrap("canHaveOatDir", $$robo$$android_content_pm_PackageParser_Package$canHaveOatDir(), 0, this);
        }

        public boolean isMatch(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isMatch", $$robo$$android_content_pm_PackageParser_Package$isMatch(int ), 0, this, n);
        }

        public long getLatestPackageUseTimeInMills() {
            return (long)InvokeDynamicSupport.bootstrap("getLatestPackageUseTimeInMills", $$robo$$android_content_pm_PackageParser_Package$getLatestPackageUseTimeInMills(), 0, this);
        }

        public long getLatestForegroundPackageUseTimeInMills() {
            return (long)InvokeDynamicSupport.bootstrap("getLatestForegroundPackageUseTimeInMills", $$robo$$android_content_pm_PackageParser_Package$getLatestForegroundPackageUseTimeInMills(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Package$toString(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_PackageParser_Package$describeContents(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageParser_Package$__constructor__(parcel);
        }

        public Package(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Package$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private static void internStringArrayList(List<String> list) {
            InvokeDynamicSupport.bootstrapStatic("internStringArrayList", $$robo$$android_content_pm_PackageParser_Package$internStringArrayList(java.util.List<java.lang.String> ), 0, list);
        }

        private void fixupOwner(List<? extends Component<?>> list) {
            InvokeDynamicSupport.bootstrap("fixupOwner", $$robo$$android_content_pm_PackageParser_Package$fixupOwner(java.util.List<? extends android.content.pm.PackageParser$Component<?>> ), 0, this, list);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_PackageParser_Package$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private static void writeKeySetMapping(Parcel parcel, ArrayMap<String, ArraySet<PublicKey>> arrayMap) {
            InvokeDynamicSupport.bootstrapStatic("writeKeySetMapping", $$robo$$android_content_pm_PackageParser_Package$writeKeySetMapping(android.os.Parcel android.util.ArrayMap<java.lang.String, android.util.ArraySet<java.security.PublicKey>> ), 0, (Parcel)parcel, arrayMap);
        }

        private static ArrayMap<String, ArraySet<PublicKey>> readKeySetMapping(Parcel parcel) {
            return InvokeDynamicSupport.bootstrapStatic("readKeySetMapping", $$robo$$android_content_pm_PackageParser_Package$readKeySetMapping(android.os.Parcel ), 0, (Parcel)parcel);
        }

        static {
            RobolectricInternals.classInitializing(Package.class);
        }

        public /* synthetic */ Package() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Package)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class SigningDetails
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Signature[] signatures;
        @SignatureSchemeVersion
        public int signatureSchemeVersion;
        public ArraySet<PublicKey> publicKeys;
        public Signature[] pastSigningCertificates;
        private static int PAST_CERT_EXISTS = 0;
        public int[] pastSigningCertificatesFlags;
        public static SigningDetails UNKNOWN;
        public static Parcelable.Creator<SigningDetails> CREATOR;

        @VisibleForTesting
        private void $$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(Signature[] signatures, @SignatureSchemeVersion int signatureSchemeVersion, ArraySet<PublicKey> keys, Signature[] pastSigningCertificates, int[] pastSigningCertificatesFlags) {
            this.signatures = signatures;
            this.signatureSchemeVersion = signatureSchemeVersion;
            this.publicKeys = keys;
            this.pastSigningCertificates = pastSigningCertificates;
            this.pastSigningCertificatesFlags = pastSigningCertificatesFlags;
        }

        private void $$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(Signature[] signatures, @SignatureSchemeVersion int signatureSchemeVersion, Signature[] pastSigningCertificates, int[] pastSigningCertificatesFlags) throws CertificateException {
        }

        private void $$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(Signature[] signatures, @SignatureSchemeVersion int signatureSchemeVersion) throws CertificateException {
        }

        private void $$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(SigningDetails orig) {
            if (orig != null) {
                this.signatures = orig.signatures != null ? (Signature[])orig.signatures.clone() : null;
                this.signatureSchemeVersion = orig.signatureSchemeVersion;
                this.publicKeys = new ArraySet<PublicKey>(orig.publicKeys);
                if (orig.pastSigningCertificates != null) {
                    this.pastSigningCertificates = (Signature[])orig.pastSigningCertificates.clone();
                    this.pastSigningCertificatesFlags = (int[])orig.pastSigningCertificatesFlags.clone();
                } else {
                    this.pastSigningCertificates = null;
                    this.pastSigningCertificatesFlags = null;
                }
            } else {
                this.signatures = null;
                this.signatureSchemeVersion = 0;
                this.publicKeys = null;
                this.pastSigningCertificates = null;
                this.pastSigningCertificatesFlags = null;
            }
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$hasSignatures() {
            return this.signatures != null && this.signatures.length > 0;
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$hasPastSigningCertificates() {
            return this.pastSigningCertificates != null && this.pastSigningCertificates.length > 0;
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$hasAncestorOrSelf(SigningDetails oldDetails) {
            if (this == UNKNOWN || oldDetails == UNKNOWN) {
                return false;
            }
            if (oldDetails.signatures.length > 1) {
                return this.signaturesMatchExactly(oldDetails);
            }
            return this.hasCertificate(oldDetails.signatures[0]);
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$hasAncestor(SigningDetails oldDetails) {
            if (this == UNKNOWN || oldDetails == UNKNOWN) {
                return false;
            }
            if (this.hasPastSigningCertificates() && oldDetails.signatures.length == 1) {
                for (int i = 0; i < this.pastSigningCertificates.length - 1; ++i) {
                    if (!this.pastSigningCertificates[i].equals(oldDetails.signatures[i])) continue;
                    return true;
                }
            }
            return false;
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$checkCapability(SigningDetails oldDetails, @CertCapabilities int flags) {
            if (this == UNKNOWN || oldDetails == UNKNOWN) {
                return false;
            }
            if (oldDetails.signatures.length > 1) {
                return this.signaturesMatchExactly(oldDetails);
            }
            return this.hasCertificate(oldDetails.signatures[0], flags);
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$checkCapabilityRecover(SigningDetails oldDetails, @CertCapabilities int flags) throws CertificateException {
            if (oldDetails == UNKNOWN || this == UNKNOWN) {
                return false;
            }
            if (this.hasPastSigningCertificates() && oldDetails.signatures.length == 1) {
                for (int i = 0; i < this.pastSigningCertificates.length; ++i) {
                    if (!Signature.areEffectiveMatch(oldDetails.signatures[0], this.pastSigningCertificates[i]) || this.pastSigningCertificatesFlags[i] != flags) continue;
                    return true;
                }
            } else {
                return Signature.areEffectiveMatch(oldDetails.signatures, this.signatures);
            }
            return false;
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$hasCertificate(Signature signature) {
            return this.hasCertificateInternal(signature, 0);
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$hasCertificate(Signature signature, @CertCapabilities int flags) {
            return this.hasCertificateInternal(signature, flags);
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$hasCertificate(byte[] certificate) {
            Signature signature = new Signature(certificate);
            return this.hasCertificate(signature);
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$hasCertificateInternal(Signature signature, int flags) {
            if (this == UNKNOWN) {
                return false;
            }
            if (this.hasPastSigningCertificates()) {
                for (int i = 0; i < this.pastSigningCertificates.length - 1; ++i) {
                    if (!this.pastSigningCertificates[i].equals(signature) || flags != 0 && (flags & this.pastSigningCertificatesFlags[i]) != flags) continue;
                    return true;
                }
            }
            return this.signatures.length == 1 && this.signatures[0].equals(signature);
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$checkCapability(String sha256String, @CertCapabilities int flags) {
            if (this == UNKNOWN) {
                return false;
            }
            byte[] sha256Bytes = ByteStringUtils.fromHexToByteArray(sha256String);
            if (this.hasSha256Certificate(sha256Bytes, flags)) {
                return true;
            }
            String[] mSignaturesSha256Digests = PackageUtils.computeSignaturesSha256Digests(this.signatures);
            String mSignaturesSha256Digest = PackageUtils.computeSignaturesSha256Digest(mSignaturesSha256Digests);
            return mSignaturesSha256Digest.equals(sha256String);
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$hasSha256Certificate(byte[] sha256Certificate) {
            return this.hasSha256CertificateInternal(sha256Certificate, 0);
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$hasSha256Certificate(byte[] sha256Certificate, @CertCapabilities int flags) {
            return this.hasSha256CertificateInternal(sha256Certificate, flags);
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$hasSha256CertificateInternal(byte[] sha256Certificate, int flags) {
            if (this == UNKNOWN) {
                return false;
            }
            if (this.hasPastSigningCertificates()) {
                for (int i = 0; i < this.pastSigningCertificates.length - 1; ++i) {
                    byte[] digest = PackageUtils.computeSha256DigestBytes(this.pastSigningCertificates[i].toByteArray());
                    if (!Arrays.equals(sha256Certificate, digest) || flags != 0 && (flags & this.pastSigningCertificatesFlags[i]) != flags) continue;
                    return true;
                }
            }
            if (this.signatures.length == 1) {
                byte[] digest = PackageUtils.computeSha256DigestBytes(this.signatures[0].toByteArray());
                return Arrays.equals(sha256Certificate, digest);
            }
            return false;
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$signaturesMatchExactly(SigningDetails other) {
            return Signature.areExactMatch(this.signatures, other.signatures);
        }

        private final int $$robo$$android_content_pm_PackageParser_SigningDetails$describeContents() {
            return 0;
        }

        private final void $$robo$$android_content_pm_PackageParser_SigningDetails$writeToParcel(Parcel dest, int flags) {
            boolean isUnknown = UNKNOWN == this;
            dest.writeBoolean(isUnknown);
            if (isUnknown) {
                return;
            }
            dest.writeTypedArray(this.signatures, flags);
            dest.writeInt(this.signatureSchemeVersion);
            dest.writeArraySet(this.publicKeys);
            dest.writeTypedArray(this.pastSigningCertificates, flags);
            dest.writeIntArray(this.pastSigningCertificatesFlags);
        }

        private void $$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(Parcel in) {
            ClassLoader boot = Object.class.getClassLoader();
            this.signatures = in.createTypedArray(Signature.CREATOR);
            this.signatureSchemeVersion = in.readInt();
            this.publicKeys = in.readArraySet(boot);
            this.pastSigningCertificates = in.createTypedArray(Signature.CREATOR);
            this.pastSigningCertificatesFlags = in.createIntArray();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_SigningDetails$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SigningDetails)) {
                return false;
            }
            SigningDetails that = (SigningDetails)o;
            if (this.signatureSchemeVersion != that.signatureSchemeVersion) {
                return false;
            }
            if (!Signature.areExactMatch(this.signatures, that.signatures)) {
                return false;
            }
            if (this.publicKeys != null ? !this.publicKeys.equals(that.publicKeys) : that.publicKeys != null) {
                return false;
            }
            if (!Arrays.equals(this.pastSigningCertificates, that.pastSigningCertificates)) {
                return false;
            }
            return Arrays.equals(this.pastSigningCertificatesFlags, that.pastSigningCertificatesFlags);
        }

        private final int $$robo$$android_content_pm_PackageParser_SigningDetails$hashCode() {
            int result = Arrays.hashCode(this.signatures);
            result = 31 * result + this.signatureSchemeVersion;
            result = 31 * result + (this.publicKeys != null ? this.publicKeys.hashCode() : 0);
            result = 31 * result + Arrays.hashCode(this.pastSigningCertificates);
            result = 31 * result + Arrays.hashCode(this.pastSigningCertificatesFlags);
            return result;
        }

        static void __staticInitializer__() {
            UNKNOWN = new SigningDetails(null, 0, null, null, null);
            CREATOR = new Parcelable.Creator<SigningDetails>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_content_pm_PackageParser_SigningDetails_1$__constructor__() {
                }

                private final SigningDetails $$robo$$android_content_pm_PackageParser_SigningDetails_1$createFromParcel(Parcel source) {
                    if (source.readBoolean()) {
                        return UNKNOWN;
                    }
                    return new SigningDetails(source);
                }

                private final SigningDetails[] $$robo$$android_content_pm_PackageParser_SigningDetails_1$newArray(int size) {
                    return new SigningDetails[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_content_pm_PackageParser_SigningDetails_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_SigningDetails_1$__constructor__(), 0, this);
                }

                @Override
                public SigningDetails createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_PackageParser_SigningDetails_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SigningDetails[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_PackageParser_SigningDetails_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Signature[] signatureArray, int n, ArraySet<PublicKey> arraySet, Signature[] signatureArray2, int[] nArray) {
            this.$$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(signatureArray, n, arraySet, signatureArray2, nArray);
        }

        public SigningDetails(Signature[] signatureArray, int n, ArraySet<PublicKey> arraySet, Signature[] signatureArray2, int[] nArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(android.content.pm.Signature[] int android.util.ArraySet<java.security.PublicKey> android.content.pm.Signature[] int[] ), 0, this, signatureArray, n, arraySet, signatureArray2, nArray);
        }

        private void __constructor__(Signature[] signatureArray, int n, Signature[] signatureArray2, int[] nArray) throws CertificateException {
            this.$$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(signatureArray, n, signatureArray2, nArray);
        }

        public SigningDetails(Signature[] signatureArray, int n, Signature[] signatureArray2, int[] nArray) throws CertificateException {
            this(signatureArray, n, PackageParser.toSigningKeys(signatureArray), signatureArray2, nArray);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(android.content.pm.Signature[] int android.content.pm.Signature[] int[] ), 0, this, signatureArray, n, signatureArray2, nArray);
        }

        private void __constructor__(Signature[] signatureArray, int n) throws CertificateException {
            this.$$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(signatureArray, n);
        }

        public SigningDetails(Signature[] signatureArray, int n) throws CertificateException {
            this(signatureArray, n, null, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(android.content.pm.Signature[] int ), 0, this, signatureArray, n);
        }

        private void __constructor__(SigningDetails signingDetails) {
            this.$$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(signingDetails);
        }

        public SigningDetails(SigningDetails signingDetails) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(android.content.pm.PackageParser$SigningDetails ), 0, this, signingDetails);
        }

        public boolean hasSignatures() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasSignatures", $$robo$$android_content_pm_PackageParser_SigningDetails$hasSignatures(), 0, this);
        }

        public boolean hasPastSigningCertificates() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasPastSigningCertificates", $$robo$$android_content_pm_PackageParser_SigningDetails$hasPastSigningCertificates(), 0, this);
        }

        public boolean hasAncestorOrSelf(SigningDetails signingDetails) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasAncestorOrSelf", $$robo$$android_content_pm_PackageParser_SigningDetails$hasAncestorOrSelf(android.content.pm.PackageParser$SigningDetails ), 0, this, signingDetails);
        }

        public boolean hasAncestor(SigningDetails signingDetails) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasAncestor", $$robo$$android_content_pm_PackageParser_SigningDetails$hasAncestor(android.content.pm.PackageParser$SigningDetails ), 0, this, signingDetails);
        }

        public boolean checkCapability(SigningDetails signingDetails, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("checkCapability", $$robo$$android_content_pm_PackageParser_SigningDetails$checkCapability(android.content.pm.PackageParser$SigningDetails int ), 0, this, signingDetails, n);
        }

        public boolean checkCapabilityRecover(SigningDetails signingDetails, int n) throws CertificateException {
            return (boolean)InvokeDynamicSupport.bootstrap("checkCapabilityRecover", $$robo$$android_content_pm_PackageParser_SigningDetails$checkCapabilityRecover(android.content.pm.PackageParser$SigningDetails int ), 0, this, signingDetails, n);
        }

        public boolean hasCertificate(Signature signature) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasCertificate", $$robo$$android_content_pm_PackageParser_SigningDetails$hasCertificate(android.content.pm.Signature ), 0, this, signature);
        }

        public boolean hasCertificate(Signature signature, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasCertificate", $$robo$$android_content_pm_PackageParser_SigningDetails$hasCertificate(android.content.pm.Signature int ), 0, this, signature, n);
        }

        public boolean hasCertificate(byte[] byArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasCertificate", $$robo$$android_content_pm_PackageParser_SigningDetails$hasCertificate(byte[] ), 0, this, byArray);
        }

        private boolean hasCertificateInternal(Signature signature, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasCertificateInternal", $$robo$$android_content_pm_PackageParser_SigningDetails$hasCertificateInternal(android.content.pm.Signature int ), 0, this, signature, n);
        }

        public boolean checkCapability(String string2, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("checkCapability", $$robo$$android_content_pm_PackageParser_SigningDetails$checkCapability(java.lang.String int ), 0, this, string2, n);
        }

        public boolean hasSha256Certificate(byte[] byArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasSha256Certificate", $$robo$$android_content_pm_PackageParser_SigningDetails$hasSha256Certificate(byte[] ), 0, this, byArray);
        }

        public boolean hasSha256Certificate(byte[] byArray, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasSha256Certificate", $$robo$$android_content_pm_PackageParser_SigningDetails$hasSha256Certificate(byte[] int ), 0, this, byArray, n);
        }

        private boolean hasSha256CertificateInternal(byte[] byArray, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasSha256CertificateInternal", $$robo$$android_content_pm_PackageParser_SigningDetails$hasSha256CertificateInternal(byte[] int ), 0, this, byArray, n);
        }

        public boolean signaturesMatchExactly(SigningDetails signingDetails) {
            return (boolean)InvokeDynamicSupport.bootstrap("signaturesMatchExactly", $$robo$$android_content_pm_PackageParser_SigningDetails$signaturesMatchExactly(android.content.pm.PackageParser$SigningDetails ), 0, this, signingDetails);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_PackageParser_SigningDetails$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_PackageParser_SigningDetails$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(parcel);
        }

        protected SigningDetails(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_SigningDetails$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_content_pm_PackageParser_SigningDetails$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_content_pm_PackageParser_SigningDetails$hashCode(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(SigningDetails.class);
        }

        public /* synthetic */ SigningDetails() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SigningDetails)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class Builder
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private Signature[] mSignatures;
            private int mSignatureSchemeVersion;
            private Signature[] mPastSigningCertificates;
            private int[] mPastSigningCertificatesFlags;

            private void $$robo$$android_content_pm_PackageParser_SigningDetails_Builder$__constructor__() {
                this.mSignatureSchemeVersion = 0;
            }

            private final Builder $$robo$$android_content_pm_PackageParser_SigningDetails_Builder$setSignatures(Signature[] signatures) {
                this.mSignatures = signatures;
                return this;
            }

            private final Builder $$robo$$android_content_pm_PackageParser_SigningDetails_Builder$setSignatureSchemeVersion(int signatureSchemeVersion) {
                this.mSignatureSchemeVersion = signatureSchemeVersion;
                return this;
            }

            private final Builder $$robo$$android_content_pm_PackageParser_SigningDetails_Builder$setPastSigningCertificates(Signature[] pastSigningCertificates) {
                this.mPastSigningCertificates = pastSigningCertificates;
                return this;
            }

            private final Builder $$robo$$android_content_pm_PackageParser_SigningDetails_Builder$setPastSigningCertificatesFlags(int[] pastSigningCertificatesFlags) {
                this.mPastSigningCertificatesFlags = pastSigningCertificatesFlags;
                return this;
            }

            private final void $$robo$$android_content_pm_PackageParser_SigningDetails_Builder$checkInvariants() {
                if (this.mSignatures == null) {
                    throw new IllegalStateException("SigningDetails requires the current signing certificates.");
                }
                boolean pastMismatch = false;
                if (this.mPastSigningCertificates != null && this.mPastSigningCertificatesFlags != null) {
                    if (this.mPastSigningCertificates.length != this.mPastSigningCertificatesFlags.length) {
                        pastMismatch = true;
                    }
                } else if (this.mPastSigningCertificates != null || this.mPastSigningCertificatesFlags != null) {
                    pastMismatch = true;
                }
                if (pastMismatch) {
                    throw new IllegalStateException("SigningDetails must have a one to one mapping between pastSigningCertificates and pastSigningCertificatesFlags");
                }
            }

            private final SigningDetails $$robo$$android_content_pm_PackageParser_SigningDetails_Builder$build() throws CertificateException {
                this.checkInvariants();
                return new SigningDetails(this.mSignatures, this.mSignatureSchemeVersion, this.mPastSigningCertificates, this.mPastSigningCertificatesFlags);
            }

            private void __constructor__() {
                this.$$robo$$android_content_pm_PackageParser_SigningDetails_Builder$__constructor__();
            }

            public Builder() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_SigningDetails_Builder$__constructor__(), 0, this);
            }

            public Builder setSignatures(Signature[] signatureArray) {
                return InvokeDynamicSupport.bootstrap("setSignatures", $$robo$$android_content_pm_PackageParser_SigningDetails_Builder$setSignatures(android.content.pm.Signature[] ), 0, this, signatureArray);
            }

            public Builder setSignatureSchemeVersion(int n) {
                return InvokeDynamicSupport.bootstrap("setSignatureSchemeVersion", $$robo$$android_content_pm_PackageParser_SigningDetails_Builder$setSignatureSchemeVersion(int ), 0, this, n);
            }

            public Builder setPastSigningCertificates(Signature[] signatureArray) {
                return InvokeDynamicSupport.bootstrap("setPastSigningCertificates", $$robo$$android_content_pm_PackageParser_SigningDetails_Builder$setPastSigningCertificates(android.content.pm.Signature[] ), 0, this, signatureArray);
            }

            public Builder setPastSigningCertificatesFlags(int[] nArray) {
                return InvokeDynamicSupport.bootstrap("setPastSigningCertificatesFlags", $$robo$$android_content_pm_PackageParser_SigningDetails_Builder$setPastSigningCertificatesFlags(int[] ), 0, this, nArray);
            }

            private void checkInvariants() {
                InvokeDynamicSupport.bootstrap("checkInvariants", $$robo$$android_content_pm_PackageParser_SigningDetails_Builder$checkInvariants(), 0, this);
            }

            public SigningDetails build() throws CertificateException {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_content_pm_PackageParser_SigningDetails_Builder$build(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static @interface CertCapabilities {
            public static final int INSTALLED_DATA = 1;
            public static final int SHARED_USER_ID = 2;
            public static final int PERMISSION = 4;
            public static final int ROLLBACK = 8;
            public static final int AUTH = 16;
        }

        public static @interface SignatureSchemeVersion {
            public static final int UNKNOWN = 0;
            public static final int JAR = 1;
            public static final int SIGNING_BLOCK_V2 = 2;
            public static final int SIGNING_BLOCK_V3 = 3;
        }
    }

    private static class SplitNameComparator
    implements Comparator<String> {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__() {
        }

        private final int $$robo$$android_content_pm_PackageParser_SplitNameComparator$compare(String lhs, String rhs) {
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            return lhs.compareTo(rhs);
        }

        private /* synthetic */ void $$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__();
        }

        private SplitNameComparator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__(), 0, this);
        }

        @Override
        public int compare(String string2, String string3) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_content_pm_PackageParser_SplitNameComparator$compare(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SplitNameComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ParseFlags {
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CallbackImpl
    implements Callback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private PackageManager mPm;

        private void $$robo$$android_content_pm_PackageParser_CallbackImpl$__constructor__(PackageManager pm) {
            this.mPm = pm;
        }

        private final boolean $$robo$$android_content_pm_PackageParser_CallbackImpl$hasFeature(String feature) {
            return this.mPm.hasSystemFeature(feature);
        }

        private final String[] $$robo$$android_content_pm_PackageParser_CallbackImpl$getOverlayPaths(String targetPackageName, String targetPath) {
            return null;
        }

        private final String[] $$robo$$android_content_pm_PackageParser_CallbackImpl$getOverlayApks(String targetPackageName) {
            return null;
        }

        private void __constructor__(PackageManager packageManager) {
            this.$$robo$$android_content_pm_PackageParser_CallbackImpl$__constructor__(packageManager);
        }

        public CallbackImpl(PackageManager packageManager) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_CallbackImpl$__constructor__(android.content.pm.PackageManager ), 0, this, packageManager);
        }

        @Override
        public boolean hasFeature(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasFeature", $$robo$$android_content_pm_PackageParser_CallbackImpl$hasFeature(java.lang.String ), 0, this, string2);
        }

        @Override
        public String[] getOverlayPaths(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("getOverlayPaths", $$robo$$android_content_pm_PackageParser_CallbackImpl$getOverlayPaths(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        @Override
        public String[] getOverlayApks(String string2) {
            return InvokeDynamicSupport.bootstrap("getOverlayApks", $$robo$$android_content_pm_PackageParser_CallbackImpl$getOverlayApks(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ CallbackImpl() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Callback
    extends InstrumentedInterface {
        public boolean hasFeature(String var1);

        public String[] getOverlayPaths(String var1, String var2);

        public String[] getOverlayApks(String var1);
    }

    private static class CachedComponentArgs
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ParseComponentArgs mActivityArgs;
        ParseComponentArgs mActivityAliasArgs;
        ParseComponentArgs mServiceArgs;
        ParseComponentArgs mProviderArgs;

        private void $$robo$$android_content_pm_PackageParser_CachedComponentArgs$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_content_pm_PackageParser_CachedComponentArgs$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_content_pm_PackageParser_CachedComponentArgs$__constructor__();
        }

        private CachedComponentArgs() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_CachedComponentArgs$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_content_pm_PackageParser_CachedComponentArgs$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CachedComponentArgs)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ApkLite
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String codePath;
        public String packageName;
        public String splitName;
        public boolean isFeatureSplit;
        public String configForSplit;
        public String usesSplitName;
        public int versionCode;
        public int versionCodeMajor;
        public int revisionCode;
        public int installLocation;
        public VerifierInfo[] verifiers;
        public SigningDetails signingDetails;
        public boolean coreApp;
        public boolean debuggable;
        public boolean multiArch;
        public boolean use32bitAbi;
        public boolean extractNativeLibs;
        public boolean isolatedSplits;

        private void $$robo$$android_content_pm_PackageParser_ApkLite$__constructor__(String codePath, String packageName, String splitName, boolean isFeatureSplit, String configForSplit, String usesSplitName, int versionCode, int versionCodeMajor, int revisionCode, int installLocation, List<VerifierInfo> verifiers, SigningDetails signingDetails, boolean coreApp, boolean debuggable, boolean multiArch, boolean use32bitAbi, boolean extractNativeLibs, boolean isolatedSplits) {
            this.codePath = codePath;
            this.packageName = packageName;
            this.splitName = splitName;
            this.isFeatureSplit = isFeatureSplit;
            this.configForSplit = configForSplit;
            this.usesSplitName = usesSplitName;
            this.versionCode = versionCode;
            this.versionCodeMajor = versionCodeMajor;
            this.revisionCode = revisionCode;
            this.installLocation = installLocation;
            this.signingDetails = signingDetails;
            this.verifiers = verifiers.toArray(new VerifierInfo[verifiers.size()]);
            this.coreApp = coreApp;
            this.debuggable = debuggable;
            this.multiArch = multiArch;
            this.use32bitAbi = use32bitAbi;
            this.extractNativeLibs = extractNativeLibs;
            this.isolatedSplits = isolatedSplits;
        }

        private final long $$robo$$android_content_pm_PackageParser_ApkLite$getLongVersionCode() {
            return PackageInfo.composeLongVersionCode(this.versionCodeMajor, this.versionCode);
        }

        private void __constructor__(String string2, String string3, String string4, boolean bl, String string5, String string6, int n, int n2, int n3, int n4, List<VerifierInfo> list, SigningDetails signingDetails, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
            this.$$robo$$android_content_pm_PackageParser_ApkLite$__constructor__(string2, string3, string4, bl, string5, string6, n, n2, n3, n4, list, signingDetails, bl2, bl3, bl4, bl5, bl6, bl7);
        }

        public ApkLite(String string2, String string3, String string4, boolean bl, String string5, String string6, int n, int n2, int n3, int n4, List<VerifierInfo> list, SigningDetails signingDetails, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ApkLite$__constructor__(java.lang.String java.lang.String java.lang.String boolean java.lang.String java.lang.String int int int int java.util.List<android.content.pm.VerifierInfo> android.content.pm.PackageParser$SigningDetails boolean boolean boolean boolean boolean boolean ), 0, this, string2, string3, string4, bl, string5, string6, n, n2, n3, n4, list, signingDetails, bl2, bl3, bl4, bl5, bl6, bl7);
        }

        public long getLongVersionCode() {
            return (long)InvokeDynamicSupport.bootstrap("getLongVersionCode", $$robo$$android_content_pm_PackageParser_ApkLite$getLongVersionCode(), 0, this);
        }

        public /* synthetic */ ApkLite() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApkLite)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PackageLite
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String packageName;
        public int versionCode;
        public int versionCodeMajor;
        public int installLocation;
        public VerifierInfo[] verifiers;
        public String[] splitNames;
        public boolean[] isFeatureSplits;
        public String[] usesSplitNames;
        public String[] configForSplit;
        public String codePath;
        public String baseCodePath;
        public String[] splitCodePaths;
        public int baseRevisionCode;
        public int[] splitRevisionCodes;
        public boolean coreApp;
        public boolean debuggable;
        public boolean multiArch;
        public boolean use32bitAbi;
        public boolean extractNativeLibs;
        public boolean isolatedSplits;

        private void $$robo$$android_content_pm_PackageParser_PackageLite$__constructor__(String codePath, ApkLite baseApk, String[] splitNames, boolean[] isFeatureSplits, String[] usesSplitNames, String[] configForSplit, String[] splitCodePaths, int[] splitRevisionCodes) {
            this.packageName = baseApk.packageName;
            this.versionCode = baseApk.versionCode;
            this.versionCodeMajor = baseApk.versionCodeMajor;
            this.installLocation = baseApk.installLocation;
            this.verifiers = baseApk.verifiers;
            this.splitNames = splitNames;
            this.isFeatureSplits = isFeatureSplits;
            this.usesSplitNames = usesSplitNames;
            this.configForSplit = configForSplit;
            this.codePath = codePath;
            this.baseCodePath = baseApk.codePath;
            this.splitCodePaths = splitCodePaths;
            this.baseRevisionCode = baseApk.revisionCode;
            this.splitRevisionCodes = splitRevisionCodes;
            this.coreApp = baseApk.coreApp;
            this.debuggable = baseApk.debuggable;
            this.multiArch = baseApk.multiArch;
            this.use32bitAbi = baseApk.use32bitAbi;
            this.extractNativeLibs = baseApk.extractNativeLibs;
            this.isolatedSplits = baseApk.isolatedSplits;
        }

        private final List<String> $$robo$$android_content_pm_PackageParser_PackageLite$getAllCodePaths() {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(this.baseCodePath);
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                Collections.addAll(paths, this.splitCodePaths);
            }
            return paths;
        }

        private void __constructor__(String string2, ApkLite apkLite, String[] stringArray, boolean[] blArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, int[] nArray) {
            this.$$robo$$android_content_pm_PackageParser_PackageLite$__constructor__(string2, apkLite, stringArray, blArray, stringArray2, stringArray3, stringArray4, nArray);
        }

        public PackageLite(String string2, ApkLite apkLite, String[] stringArray, boolean[] blArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, int[] nArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PackageLite$__constructor__(java.lang.String android.content.pm.PackageParser$ApkLite java.lang.String[] boolean[] java.lang.String[] java.lang.String[] java.lang.String[] int[] ), 0, this, string2, apkLite, stringArray, blArray, stringArray2, stringArray3, stringArray4, nArray);
        }

        public List<String> getAllCodePaths() {
            return InvokeDynamicSupport.bootstrap("getAllCodePaths", $$robo$$android_content_pm_PackageParser_PackageLite$getAllCodePaths(), 0, this);
        }

        public /* synthetic */ PackageLite() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageLite)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @VisibleForTesting
    public static class ParseComponentArgs
    extends ParsePackageItemArgs
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String[] sepProcesses;
        int processRes;
        int descriptionRes;
        int enabledRes;
        int flags;

        private void $$robo$$android_content_pm_PackageParser_ParseComponentArgs$__constructor__(Package _owner, String[] _outError, int _nameRes, int _labelRes, int _iconRes, int _roundIconRes, int _logoRes, int _bannerRes, String[] _sepProcesses, int _processRes, int _descriptionRes, int _enabledRes) {
            this.sepProcesses = _sepProcesses;
            this.processRes = _processRes;
            this.descriptionRes = _descriptionRes;
            this.enabledRes = _enabledRes;
        }

        private void __constructor__(Package package_, String[] stringArray, int n, int n2, int n3, int n4, int n5, int n6, String[] stringArray2, int n7, int n8, int n9) {
            this.$$robo$$android_content_pm_PackageParser_ParseComponentArgs$__constructor__(package_, stringArray, n, n2, n3, n4, n5, n6, stringArray2, n7, n8, n9);
        }

        public ParseComponentArgs(Package package_, String[] stringArray, int n, int n2, int n3, int n4, int n5, int n6, String[] stringArray2, int n7, int n8, int n9) {
            super(package_, stringArray, n, n2, n3, n4, n5, n6);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ParseComponentArgs$__constructor__(android.content.pm.PackageParser$Package java.lang.String[] int int int int int int java.lang.String[] int int int ), 0, this, package_, stringArray, n, n2, n3, n4, n5, n6, stringArray2, n7, n8, n9);
        }

        public /* synthetic */ ParseComponentArgs() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParseComponentArgs)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ParsePackageItemArgs
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Package owner;
        String[] outError;
        int nameRes;
        int labelRes;
        int iconRes;
        int roundIconRes;
        int logoRes;
        int bannerRes;
        String tag;
        TypedArray sa;

        private void $$robo$$android_content_pm_PackageParser_ParsePackageItemArgs$__constructor__(Package _owner, String[] _outError, int _nameRes, int _labelRes, int _iconRes, int _roundIconRes, int _logoRes, int _bannerRes) {
            this.owner = _owner;
            this.outError = _outError;
            this.nameRes = _nameRes;
            this.labelRes = _labelRes;
            this.iconRes = _iconRes;
            this.logoRes = _logoRes;
            this.bannerRes = _bannerRes;
            this.roundIconRes = _roundIconRes;
        }

        private void __constructor__(Package package_, String[] stringArray, int n, int n2, int n3, int n4, int n5, int n6) {
            this.$$robo$$android_content_pm_PackageParser_ParsePackageItemArgs$__constructor__(package_, stringArray, n, n2, n3, n4, n5, n6);
        }

        ParsePackageItemArgs(Package package_, String[] stringArray, int n, int n2, int n3, int n4, int n5, int n6) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ParsePackageItemArgs$__constructor__(android.content.pm.PackageParser$Package java.lang.String[] int int int int int int ), 0, this, package_, stringArray, n, n2, n3, n4, n5, n6);
        }

        public /* synthetic */ ParsePackageItemArgs() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParsePackageItemArgs)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SplitPermissionInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String rootPerm;
        public String[] newPerms;
        public int targetSdk;

        private void $$robo$$android_content_pm_PackageParser_SplitPermissionInfo$__constructor__(String rootPerm, String[] newPerms, int targetSdk) {
            this.rootPerm = rootPerm;
            this.newPerms = newPerms;
            this.targetSdk = targetSdk;
        }

        private void __constructor__(String string2, String[] stringArray, int n) {
            this.$$robo$$android_content_pm_PackageParser_SplitPermissionInfo$__constructor__(string2, stringArray, n);
        }

        public SplitPermissionInfo(String string2, String[] stringArray, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_SplitPermissionInfo$__constructor__(java.lang.String java.lang.String[] int ), 0, this, string2, stringArray, n);
        }

        public /* synthetic */ SplitPermissionInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SplitPermissionInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class NewPermissionInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String name;
        public int sdkVersion;
        public int fileVersion;

        private void $$robo$$android_content_pm_PackageParser_NewPermissionInfo$__constructor__(String name, int sdkVersion, int fileVersion) {
            this.name = name;
            this.sdkVersion = sdkVersion;
            this.fileVersion = fileVersion;
        }

        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_content_pm_PackageParser_NewPermissionInfo$__constructor__(string2, n, n2);
        }

        public NewPermissionInfo(String string2, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_NewPermissionInfo$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        public /* synthetic */ NewPermissionInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NewPermissionInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

