/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.SystemApi;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PermissionInfo
extends PackageItemInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int PROTECTION_NORMAL = 0;
    public static int PROTECTION_DANGEROUS = 1;
    public static int PROTECTION_SIGNATURE = 2;
    @Deprecated
    public static int PROTECTION_SIGNATURE_OR_SYSTEM = 3;
    public static int PROTECTION_FLAG_PRIVILEGED = 16;
    @Deprecated
    public static int PROTECTION_FLAG_SYSTEM = 16;
    public static int PROTECTION_FLAG_DEVELOPMENT = 32;
    public static int PROTECTION_FLAG_APPOP = 64;
    public static int PROTECTION_FLAG_PRE23 = 128;
    public static int PROTECTION_FLAG_INSTALLER = 256;
    public static int PROTECTION_FLAG_VERIFIER = 512;
    public static int PROTECTION_FLAG_PREINSTALLED = 1024;
    public static int PROTECTION_FLAG_SETUP = 2048;
    public static int PROTECTION_FLAG_INSTANT = 4096;
    public static int PROTECTION_FLAG_RUNTIME_ONLY = 8192;
    @SystemApi
    public static int PROTECTION_FLAG_OEM = 16384;
    public static int PROTECTION_FLAG_VENDOR_PRIVILEGED = 32768;
    @SystemApi
    public static int PROTECTION_FLAG_SYSTEM_TEXT_CLASSIFIER = 65536;
    @Deprecated
    public static int PROTECTION_MASK_BASE = 15;
    @Deprecated
    public static int PROTECTION_MASK_FLAGS = 65520;
    @Deprecated
    public int protectionLevel;
    public String group;
    public static int FLAG_COSTS_MONEY = 1;
    @SystemApi
    public static int FLAG_REMOVED = 2;
    public static int FLAG_INSTALLED = 0x40000000;
    public int flags;
    public int descriptionRes;
    @SystemApi
    public int requestRes;
    public CharSequence nonLocalizedDescription;
    public static Parcelable.Creator<PermissionInfo> CREATOR;

    private static final int $$robo$$android_content_pm_PermissionInfo$fixProtectionLevel(int level) {
        if (level == 3) {
            level = 18;
        }
        if ((level & 0x8000) != 0 && (level & 0x10) == 0) {
            level &= 0xFFFF7FFF;
        }
        return level;
    }

    private static final String $$robo$$android_content_pm_PermissionInfo$protectionToString(int level) {
        String protLevel = "????";
        switch (level & 0xF) {
            case 1: {
                protLevel = "dangerous";
                break;
            }
            case 0: {
                protLevel = "normal";
                break;
            }
            case 2: {
                protLevel = "signature";
                break;
            }
            case 3: {
                protLevel = "signatureOrSystem";
            }
        }
        if ((level & 0x10) != 0) {
            protLevel = protLevel + "|privileged";
        }
        if ((level & 0x20) != 0) {
            protLevel = protLevel + "|development";
        }
        if ((level & 0x40) != 0) {
            protLevel = protLevel + "|appop";
        }
        if ((level & 0x80) != 0) {
            protLevel = protLevel + "|pre23";
        }
        if ((level & 0x100) != 0) {
            protLevel = protLevel + "|installer";
        }
        if ((level & 0x200) != 0) {
            protLevel = protLevel + "|verifier";
        }
        if ((level & 0x400) != 0) {
            protLevel = protLevel + "|preinstalled";
        }
        if ((level & 0x800) != 0) {
            protLevel = protLevel + "|setup";
        }
        if ((level & 0x1000) != 0) {
            protLevel = protLevel + "|instant";
        }
        if ((level & 0x2000) != 0) {
            protLevel = protLevel + "|runtime";
        }
        if ((level & 0x4000) != 0) {
            protLevel = protLevel + "|oem";
        }
        if ((level & 0x8000) != 0) {
            protLevel = protLevel + "|vendorPrivileged";
        }
        if ((level & 0x10000) != 0) {
            protLevel = protLevel + "|textClassifier";
        }
        return protLevel;
    }

    private void $$robo$$android_content_pm_PermissionInfo$__constructor__() {
    }

    private void $$robo$$android_content_pm_PermissionInfo$__constructor__(PermissionInfo orig) {
        this.protectionLevel = orig.protectionLevel;
        this.flags = orig.flags;
        this.group = orig.group;
        this.descriptionRes = orig.descriptionRes;
        this.requestRes = orig.requestRes;
        this.nonLocalizedDescription = orig.nonLocalizedDescription;
    }

    private final CharSequence $$robo$$android_content_pm_PermissionInfo$loadDescription(PackageManager pm) {
        CharSequence label;
        if (this.nonLocalizedDescription != null) {
            return this.nonLocalizedDescription;
        }
        if (this.descriptionRes != 0 && (label = pm.getText(this.packageName, this.descriptionRes, null)) != null) {
            return label;
        }
        return null;
    }

    private final int $$robo$$android_content_pm_PermissionInfo$getProtection() {
        return this.protectionLevel & 0xF;
    }

    private final int $$robo$$android_content_pm_PermissionInfo$getProtectionFlags() {
        return this.protectionLevel & 0xFFFFFFF0;
    }

    private final String $$robo$$android_content_pm_PermissionInfo$toString() {
        return "PermissionInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.name + "}";
    }

    private final int $$robo$$android_content_pm_PermissionInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_pm_PermissionInfo$writeToParcel(Parcel dest, int parcelableFlags) {
        super.writeToParcel(dest, parcelableFlags);
        dest.writeInt(this.protectionLevel);
        dest.writeInt(this.flags);
        dest.writeString(this.group);
        dest.writeInt(this.descriptionRes);
        dest.writeInt(this.requestRes);
        TextUtils.writeToParcel(this.nonLocalizedDescription, dest, parcelableFlags);
    }

    private final int $$robo$$android_content_pm_PermissionInfo$calculateFootprint() {
        int size = this.name.length();
        if (this.nonLocalizedLabel != null) {
            size += this.nonLocalizedLabel.length();
        }
        if (this.nonLocalizedDescription != null) {
            size += this.nonLocalizedDescription.length();
        }
        return size;
    }

    private final boolean $$robo$$android_content_pm_PermissionInfo$isAppOp() {
        return (this.protectionLevel & 0x40) != 0;
    }

    private void $$robo$$android_content_pm_PermissionInfo$__constructor__(Parcel source) {
        this.protectionLevel = source.readInt();
        this.flags = source.readInt();
        this.group = source.readString();
        this.descriptionRes = source.readInt();
        this.requestRes = source.readInt();
        this.nonLocalizedDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
    }

    private /* synthetic */ void $$robo$$android_content_pm_PermissionInfo$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<PermissionInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_pm_PermissionInfo_1$__constructor__() {
            }

            private final PermissionInfo $$robo$$android_content_pm_PermissionInfo_1$createFromParcel(Parcel source) {
                return new PermissionInfo(source);
            }

            private final PermissionInfo[] $$robo$$android_content_pm_PermissionInfo_1$newArray(int size) {
                return new PermissionInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_pm_PermissionInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PermissionInfo_1$__constructor__(), 0, this);
            }

            @Override
            public PermissionInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_PermissionInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public PermissionInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_PermissionInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static int fixProtectionLevel(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("fixProtectionLevel", $$robo$$android_content_pm_PermissionInfo$fixProtectionLevel(int ), 0, (int)n);
    }

    public static String protectionToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("protectionToString", $$robo$$android_content_pm_PermissionInfo$protectionToString(int ), 0, (int)n);
    }

    private void __constructor__() {
        this.$$robo$$android_content_pm_PermissionInfo$__constructor__();
    }

    public PermissionInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PermissionInfo$__constructor__(), 0, this);
    }

    private void __constructor__(PermissionInfo permissionInfo) {
        this.$$robo$$android_content_pm_PermissionInfo$__constructor__(permissionInfo);
    }

    public PermissionInfo(PermissionInfo permissionInfo) {
        super(permissionInfo);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PermissionInfo$__constructor__(android.content.pm.PermissionInfo ), 0, this, permissionInfo);
    }

    public CharSequence loadDescription(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadDescription", $$robo$$android_content_pm_PermissionInfo$loadDescription(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public int getProtection() {
        return (int)InvokeDynamicSupport.bootstrap("getProtection", $$robo$$android_content_pm_PermissionInfo$getProtection(), 0, this);
    }

    public int getProtectionFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getProtectionFlags", $$robo$$android_content_pm_PermissionInfo$getProtectionFlags(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PermissionInfo$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_PermissionInfo$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_PermissionInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public int calculateFootprint() {
        return (int)InvokeDynamicSupport.bootstrap("calculateFootprint", $$robo$$android_content_pm_PermissionInfo$calculateFootprint(), 0, this);
    }

    public boolean isAppOp() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAppOp", $$robo$$android_content_pm_PermissionInfo$isAppOp(), 0, this);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_pm_PermissionInfo$__constructor__(parcel);
    }

    private PermissionInfo(Parcel parcel) {
        super(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PermissionInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_content_pm_PermissionInfo$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(PermissionInfo.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PermissionInfo)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProtectionFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Protection {
    }
}

