/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.permission;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.permission.IRuntimePermissionPresenter;
import android.content.pm.permission.RuntimePermissionPresentationInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.SomeArgs;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class RuntimePermissionPresenter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RuntimePermPresenter";
    public static String KEY_RESULT = "android.content.pm.permission.RuntimePermissionPresenter.key.result";
    private static Object sLock;
    @GuardedBy(value="sLock")
    private static RuntimePermissionPresenter sInstance;
    private RemoteService mRemoteService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final RuntimePermissionPresenter $$robo$$android_content_pm_permission_RuntimePermissionPresenter$getInstance(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new RuntimePermissionPresenter(context.getApplicationContext());
            }
            return sInstance;
        }
    }

    private void $$robo$$android_content_pm_permission_RuntimePermissionPresenter$__constructor__(Context context) {
        this.mRemoteService = new RemoteService(context);
    }

    private final void $$robo$$android_content_pm_permission_RuntimePermissionPresenter$getAppPermissions(String packageName, OnResultCallback callback, Handler handler) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = packageName;
        args.arg2 = callback;
        args.arg3 = handler;
        Message message = this.mRemoteService.obtainMessage(1, args);
        this.mRemoteService.processMessage(message);
    }

    private final void $$robo$$android_content_pm_permission_RuntimePermissionPresenter$revokeRuntimePermission(String packageName, String permissionName) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = packageName;
        args.arg2 = permissionName;
        Message message = this.mRemoteService.obtainMessage(4, args);
        this.mRemoteService.processMessage(message);
    }

    static void __staticInitializer__() {
        sLock = new Object();
    }

    public static RuntimePermissionPresenter getInstance(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_content_pm_permission_RuntimePermissionPresenter$getInstance(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_content_pm_permission_RuntimePermissionPresenter$__constructor__(context);
    }

    private RuntimePermissionPresenter(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_permission_RuntimePermissionPresenter$__constructor__(android.content.Context ), 0, this, context);
    }

    public void getAppPermissions(String string2, OnResultCallback onResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("getAppPermissions", $$robo$$android_content_pm_permission_RuntimePermissionPresenter$getAppPermissions(java.lang.String android.content.pm.permission.RuntimePermissionPresenter$OnResultCallback android.os.Handler ), 0, this, string2, onResultCallback, handler);
    }

    public void revokeRuntimePermission(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("revokeRuntimePermission", $$robo$$android_content_pm_permission_RuntimePermissionPresenter$revokeRuntimePermission(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    static {
        RobolectricInternals.classInitializing(RuntimePermissionPresenter.class);
    }

    public /* synthetic */ RuntimePermissionPresenter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RuntimePermissionPresenter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class RemoteService
    extends Handler
    implements ServiceConnection,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static long UNBIND_TIMEOUT_MILLIS = 10000L;
        public static int MSG_GET_APP_PERMISSIONS = 1;
        public static int MSG_GET_APPS_USING_PERMISSIONS = 2;
        public static int MSG_UNBIND = 3;
        public static int MSG_REVOKE_APP_PERMISSIONS = 4;
        private Object mLock;
        private Context mContext;
        @GuardedBy(value="mLock")
        private List<Message> mPendingWork;
        @GuardedBy(value="mLock")
        private IRuntimePermissionPresenter mRemoteInstance;
        @GuardedBy(value="mLock")
        private boolean mBound;

        private void $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$__constructor__(Context context) {
            this.mLock = new Object();
            this.mPendingWork = new ArrayList<Message>();
            this.mContext = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$processMessage(Message message) {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mBound) {
                    Intent intent = new Intent("android.permissionpresenterservice.RuntimePermissionPresenterService");
                    intent.setPackage(this.mContext.getPackageManager().getPermissionControllerPackageName());
                    this.mBound = this.mContext.bindService(intent, this, 1);
                }
                this.mPendingWork.add(message);
                this.scheduleNextMessageIfNeededLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$onServiceConnected(ComponentName name, IBinder service) {
            Object object = this.mLock;
            synchronized (object) {
                this.mRemoteInstance = IRuntimePermissionPresenter.Stub.asInterface(service);
                this.scheduleNextMessageIfNeededLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$onServiceDisconnected(ComponentName name) {
            Object object = this.mLock;
            synchronized (object) {
                this.mRemoteInstance = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    IRuntimePermissionPresenter remoteInstance;
                    Object args = (SomeArgs)msg.obj;
                    String packageName = (String)((SomeArgs)args).arg1;
                    OnResultCallback callback = (OnResultCallback)((SomeArgs)args).arg2;
                    Handler handler = (Handler)((SomeArgs)args).arg3;
                    ((SomeArgs)args).recycle();
                    Object object = this.mLock;
                    synchronized (object) {
                        remoteInstance = this.mRemoteInstance;
                    }
                    if (remoteInstance == null) {
                        return;
                    }
                    try {
                        remoteInstance.getAppPermissions(packageName, new RemoteCallback(new RemoteCallback.OnResultListener(this, handler, callback){
                            public transient /* synthetic */ Object __robo_data__;
                            /* synthetic */ Handler val$handler;
                            /* synthetic */ OnResultCallback val$callback;
                            /* synthetic */ RemoteService this$0;

                            private void $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService_1$__constructor__(RemoteService this$0, Handler handler, OnResultCallback onResultCallback) {
                            }

                            private final void $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService_1$onResult(Bundle result) {
                                List<RuntimePermissionPresentationInfo> permissions = null;
                                if (result != null) {
                                    permissions = result.getParcelableArrayList("android.content.pm.permission.RuntimePermissionPresenter.key.result");
                                }
                                if (permissions == null) {
                                    permissions = Collections.emptyList();
                                }
                                ArrayList<RuntimePermissionPresentationInfo> reportedPermissions = permissions;
                                if (this.val$handler != null) {
                                    this.val$handler.post(new Runnable(this, reportedPermissions){
                                        public transient /* synthetic */ Object __robo_data__;
                                        /* synthetic */ List val$reportedPermissions;
                                        /* synthetic */ 1 this$1;

                                        private void $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService_1_1$__constructor__(1 this$1, List list) {
                                        }

                                        private final void $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService_1_1$run() {
                                            this.this$1.val$callback.onGetAppPermissions(this.val$reportedPermissions);
                                        }

                                        private void __constructor__(1 var1_1, List list) {
                                            this.$$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService_1_1$__constructor__(var1_1, list);
                                        }
                                        {
                                            this.this$1 = var1_1;
                                            this.val$reportedPermissions = list;
                                            this.$$robo$init();
                                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService_1_1$__constructor__(android.content.pm.permission.RuntimePermissionPresenter$RemoteService$1 java.util.List ), 0, this, var1_1, list);
                                        }

                                        @Override
                                        public void run() {
                                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService_1_1$run(), 0, this);
                                        }
                                        {
                                            this.$$robo$init();
                                        }

                                        protected /* synthetic */ void $$robo$init() {
                                            if (this.__robo_data__ == null) {
                                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                            }
                                        }

                                        public /* synthetic */ Object $$robo$getData() {
                                            return this.__robo_data__;
                                        }
                                    });
                                } else {
                                    this.val$callback.onGetAppPermissions(reportedPermissions);
                                }
                            }

                            private void __constructor__(RemoteService remoteService, Handler handler, OnResultCallback onResultCallback) {
                                this.$$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService_1$__constructor__(remoteService, handler, onResultCallback);
                            }
                            {
                                this.this$0 = remoteService;
                                this.val$handler = handler;
                                this.val$callback = onResultCallback;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService_1$__constructor__(android.content.pm.permission.RuntimePermissionPresenter$RemoteService android.os.Handler android.content.pm.permission.RuntimePermissionPresenter$OnResultCallback ), 0, this, remoteService, handler, onResultCallback);
                            }

                            @Override
                            public void onResult(Bundle bundle) {
                                InvokeDynamicSupport.bootstrap("onResult", $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService_1$onResult(android.os.Bundle ), 0, this, bundle);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        }, this));
                    }
                    catch (RemoteException re) {
                        Log.e("RuntimePermPresenter", "Error getting app permissions", re);
                    }
                    this.scheduleUnbind();
                    break;
                }
                case 3: {
                    Object args = this.mLock;
                    synchronized (args) {
                        if (this.mBound) {
                            this.mContext.unbindService(this);
                            this.mBound = false;
                        }
                        this.mRemoteInstance = null;
                        break;
                    }
                }
                case 4: {
                    IRuntimePermissionPresenter remoteInstance;
                    Object args = (SomeArgs)msg.obj;
                    String packageName = (String)((SomeArgs)args).arg1;
                    String permissionName = (String)((SomeArgs)args).arg2;
                    ((SomeArgs)args).recycle();
                    Object remoteInstance2 = this.mLock;
                    synchronized (remoteInstance2) {
                        remoteInstance = this.mRemoteInstance;
                    }
                    if (remoteInstance == null) {
                        return;
                    }
                    try {
                        remoteInstance.revokeRuntimePermission(packageName, permissionName);
                        break;
                    }
                    catch (RemoteException re) {
                        Log.e("RuntimePermPresenter", "Error getting app permissions", re);
                    }
                }
            }
            Object object = this.mLock;
            synchronized (object) {
                this.scheduleNextMessageIfNeededLocked();
            }
        }

        @GuardedBy(value="mLock")
        private final void $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$scheduleNextMessageIfNeededLocked() {
            if (this.mBound && this.mRemoteInstance != null && !this.mPendingWork.isEmpty()) {
                Message nextMessage = this.mPendingWork.remove(0);
                this.sendMessage(nextMessage);
            }
        }

        private final void $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$scheduleUnbind() {
            this.removeMessages(3);
            this.sendEmptyMessageDelayed(3, 10000L);
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$__constructor__(context);
        }

        public RemoteService(Context context) {
            super(context.getMainLooper(), null, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$__constructor__(android.content.Context ), 0, this, context);
        }

        public void processMessage(Message message) {
            InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$processMessage(android.os.Message ), 0, this, message);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$handleMessage(android.os.Message ), 0, this, message);
        }

        private void scheduleNextMessageIfNeededLocked() {
            InvokeDynamicSupport.bootstrap("scheduleNextMessageIfNeededLocked", $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$scheduleNextMessageIfNeededLocked(), 0, this);
        }

        private void scheduleUnbind() {
            InvokeDynamicSupport.bootstrap("scheduleUnbind", $$robo$$android_content_pm_permission_RuntimePermissionPresenter_RemoteService$scheduleUnbind(), 0, this);
        }

        public /* synthetic */ RemoteService() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteService)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class OnResultCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_content_pm_permission_RuntimePermissionPresenter_OnResultCallback$__constructor__() {
        }

        private final void $$robo$$android_content_pm_permission_RuntimePermissionPresenter_OnResultCallback$onGetAppPermissions(List<RuntimePermissionPresentationInfo> permissions) {
        }

        private void __constructor__() {
            this.$$robo$$android_content_pm_permission_RuntimePermissionPresenter_OnResultCallback$__constructor__();
        }

        public OnResultCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_permission_RuntimePermissionPresenter_OnResultCallback$__constructor__(), 0, this);
        }

        public void onGetAppPermissions(List<RuntimePermissionPresentationInfo> list) {
            InvokeDynamicSupport.bootstrap("onGetAppPermissions", $$robo$$android_content_pm_permission_RuntimePermissionPresenter_OnResultCallback$onGetAppPermissions(java.util.List<android.content.pm.permission.RuntimePermissionPresentationInfo> ), 0, this, list);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnResultCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

