/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.split;

import android.content.pm.PackageParser;
import android.content.pm.split.SplitAssetLoader;
import android.content.pm.split.SplitDependencyLoader;
import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import android.os.Build;
import android.util.SparseArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

public class SplitAssetDependencyLoader
extends SplitDependencyLoader<PackageParser.PackageParserException>
implements SplitAssetLoader {
    public transient /* synthetic */ Object __robo_data__;
    private String[] mSplitPaths;
    private int mFlags;
    private ApkAssets[][] mCachedSplitApks;
    private AssetManager[] mCachedAssetManagers;

    private void $$robo$$android_content_pm_split_SplitAssetDependencyLoader$__constructor__(PackageParser.PackageLite pkg, SparseArray<int[]> dependencies, int flags) {
        this.mSplitPaths = new String[pkg.splitCodePaths.length + 1];
        this.mSplitPaths[0] = pkg.baseCodePath;
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)pkg.splitCodePaths, (int)0, (Object)this.mSplitPaths, (int)1, (int)pkg.splitCodePaths.length);
        this.mFlags = flags;
        this.mCachedSplitApks = new ApkAssets[this.mSplitPaths.length][];
        this.mCachedAssetManagers = new AssetManager[this.mSplitPaths.length];
    }

    private final boolean $$robo$$android_content_pm_split_SplitAssetDependencyLoader$isSplitCached(int splitIdx) {
        return this.mCachedAssetManagers[splitIdx] != null;
    }

    private static final ApkAssets $$robo$$android_content_pm_split_SplitAssetDependencyLoader$loadApkAssets(String path, int flags) throws PackageParser.PackageParserException {
        if ((flags & 1) != 0 && !PackageParser.isApkPath(path)) {
            throw new PackageParser.PackageParserException(-100, "Invalid package file: " + path);
        }
        try {
            return ApkAssets.loadFromPath(path);
        }
        catch (IOException e) {
            throw new PackageParser.PackageParserException(-2, "Failed to load APK at path " + path, e);
        }
    }

    private static final AssetManager $$robo$$android_content_pm_split_SplitAssetDependencyLoader$createAssetManagerWithAssets(ApkAssets[] apkAssets) {
        AssetManager assets = new AssetManager();
        assets.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
        assets.setApkAssets(apkAssets, false);
        return assets;
    }

    private final void $$robo$$android_content_pm_split_SplitAssetDependencyLoader$constructSplit(int splitIdx, int[] configSplitIndices, int parentSplitIdx) throws PackageParser.PackageParserException {
        ArrayList<ApkAssets> assets = new ArrayList<ApkAssets>();
        if (parentSplitIdx >= 0) {
            Collections.addAll(assets, this.mCachedSplitApks[parentSplitIdx]);
        }
        assets.add(SplitAssetDependencyLoader.loadApkAssets(this.mSplitPaths[splitIdx], this.mFlags));
        for (int configSplitIdx : configSplitIndices) {
            assets.add(SplitAssetDependencyLoader.loadApkAssets(this.mSplitPaths[configSplitIdx], this.mFlags));
        }
        this.mCachedSplitApks[splitIdx] = assets.toArray(new ApkAssets[assets.size()]);
        this.mCachedAssetManagers[splitIdx] = SplitAssetDependencyLoader.createAssetManagerWithAssets(this.mCachedSplitApks[splitIdx]);
    }

    private final AssetManager $$robo$$android_content_pm_split_SplitAssetDependencyLoader$getBaseAssetManager() throws PackageParser.PackageParserException {
        this.loadDependenciesForSplit(0);
        return this.mCachedAssetManagers[0];
    }

    private final AssetManager $$robo$$android_content_pm_split_SplitAssetDependencyLoader$getSplitAssetManager(int idx) throws PackageParser.PackageParserException {
        this.loadDependenciesForSplit(idx + 1);
        return this.mCachedAssetManagers[idx + 1];
    }

    private final void $$robo$$android_content_pm_split_SplitAssetDependencyLoader$close() throws Exception {
        for (AssetManager assets : this.mCachedAssetManagers) {
            IoUtils.closeQuietly(assets);
        }
    }

    private void __constructor__(PackageParser.PackageLite packageLite, SparseArray<int[]> sparseArray, int n) {
        this.$$robo$$android_content_pm_split_SplitAssetDependencyLoader$__constructor__(packageLite, sparseArray, n);
    }

    public SplitAssetDependencyLoader(PackageParser.PackageLite packageLite, SparseArray<int[]> sparseArray, int n) {
        super(sparseArray);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$__constructor__(android.content.pm.PackageParser$PackageLite android.util.SparseArray<int[]> int ), 0, this, packageLite, sparseArray, n);
    }

    @Override
    protected boolean isSplitCached(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSplitCached", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$isSplitCached(int ), 0, this, n);
    }

    private static ApkAssets loadApkAssets(String string2, int n) throws PackageParser.PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("loadApkAssets", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$loadApkAssets(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static AssetManager createAssetManagerWithAssets(ApkAssets[] apkAssetsArray) {
        return InvokeDynamicSupport.bootstrapStatic("createAssetManagerWithAssets", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$createAssetManagerWithAssets(android.content.res.ApkAssets[] ), 0, (ApkAssets[])apkAssetsArray);
    }

    @Override
    protected void constructSplit(int n, int[] nArray, int n2) throws PackageParser.PackageParserException {
        InvokeDynamicSupport.bootstrap("constructSplit", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$constructSplit(int int[] int ), 0, this, n, nArray, n2);
    }

    @Override
    public AssetManager getBaseAssetManager() throws PackageParser.PackageParserException {
        return InvokeDynamicSupport.bootstrap("getBaseAssetManager", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$getBaseAssetManager(), 0, this);
    }

    @Override
    public AssetManager getSplitAssetManager(int n) throws PackageParser.PackageParserException {
        return InvokeDynamicSupport.bootstrap("getSplitAssetManager", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$getSplitAssetManager(int ), 0, this, n);
    }

    @Override
    public void close() throws Exception {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$close(), 0, this);
    }

    public /* synthetic */ SplitAssetDependencyLoader() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SplitAssetDependencyLoader)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

