/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FontResourcesParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "FontResourcesParser";

    private void $$robo$$android_content_res_FontResourcesParser$__constructor__() {
    }

    private static final FamilyResourceEntry $$robo$$android_content_res_FontResourcesParser$parse(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        return FontResourcesParser.readFamilies(parser, resources);
    }

    private static final FamilyResourceEntry $$robo$$android_content_res_FontResourcesParser$readFamilies(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        parser.require(2, null, "font-family");
        String tag = parser.getName();
        Object result = null;
        if (tag.equals("font-family")) {
            return FontResourcesParser.readFamily(parser, resources);
        }
        FontResourcesParser.skip(parser);
        Log.e("FontResourcesParser", "Failed to find font-family tag");
        return null;
    }

    private static final FamilyResourceEntry $$robo$$android_content_res_FontResourcesParser$readFamily(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        AttributeSet attrs = Xml.asAttributeSet(parser);
        TypedArray array2 = resources.obtainAttributes(attrs, R.styleable.FontFamily);
        String authority = array2.getString(0);
        String providerPackage = array2.getString(2);
        String query = array2.getString(1);
        int certsId = array2.getResourceId(3, 0);
        array2.recycle();
        if (authority != null && providerPackage != null && query != null) {
            TypedArray typedArray;
            while (parser.next() != 3) {
                FontResourcesParser.skip(parser);
            }
            ArrayList<List<String>> certs = null;
            if (certsId != 0 && (typedArray = resources.obtainTypedArray(certsId)).length() > 0) {
                boolean isArrayOfArrays;
                certs = new ArrayList<List<String>>();
                boolean bl = isArrayOfArrays = typedArray.getResourceId(0, 0) != 0;
                if (isArrayOfArrays) {
                    for (int i = 0; i < typedArray.length(); ++i) {
                        int certId = typedArray.getResourceId(i, 0);
                        String[] certsArray = resources.getStringArray(certId);
                        List<String> certsList = Arrays.asList(certsArray);
                        certs.add(certsList);
                    }
                } else {
                    String[] certsArray = resources.getStringArray(certsId);
                    List<String> certsList = Arrays.asList(certsArray);
                    certs.add(certsList);
                }
            }
            return new ProviderResourceEntry(authority, providerPackage, query, certs);
        }
        ArrayList<FontFileResourceEntry> fonts = new ArrayList<FontFileResourceEntry>();
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("font")) {
                FontFileResourceEntry entry = FontResourcesParser.readFont(parser, resources);
                if (entry == null) continue;
                fonts.add(entry);
                continue;
            }
            FontResourcesParser.skip(parser);
        }
        if (fonts.isEmpty()) {
            return null;
        }
        return new FontFamilyFilesResourceEntry(fonts.toArray(new FontFileResourceEntry[fonts.size()]));
    }

    private static final FontFileResourceEntry $$robo$$android_content_res_FontResourcesParser$readFont(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        AttributeSet attrs = Xml.asAttributeSet(parser);
        TypedArray array2 = resources.obtainAttributes(attrs, R.styleable.FontFamilyFont);
        int weight = array2.getInt(1, -1);
        int italic = array2.getInt(2, -1);
        String variationSettings = array2.getString(4);
        int ttcIndex = array2.getInt(3, 0);
        String filename = array2.getString(0);
        array2.recycle();
        while (parser.next() != 3) {
            FontResourcesParser.skip(parser);
        }
        if (filename == null) {
            return null;
        }
        return new FontFileResourceEntry(filename, weight, italic, variationSettings, ttcIndex);
    }

    private static final void $$robo$$android_content_res_FontResourcesParser$skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        int depth = 1;
        while (depth > 0) {
            switch (parser.next()) {
                case 2: {
                    ++depth;
                    break;
                }
                case 3: {
                    --depth;
                }
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$android_content_res_FontResourcesParser$__constructor__();
    }

    public FontResourcesParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_FontResourcesParser$__constructor__(), 0, this);
    }

    public static FamilyResourceEntry parse(XmlPullParser xmlPullParser, Resources resources) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$android_content_res_FontResourcesParser$parse(org.xmlpull.v1.XmlPullParser android.content.res.Resources ), 0, (XmlPullParser)xmlPullParser, (Resources)resources);
    }

    private static FamilyResourceEntry readFamilies(XmlPullParser xmlPullParser, Resources resources) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFamilies", $$robo$$android_content_res_FontResourcesParser$readFamilies(org.xmlpull.v1.XmlPullParser android.content.res.Resources ), 0, (XmlPullParser)xmlPullParser, (Resources)resources);
    }

    private static FamilyResourceEntry readFamily(XmlPullParser xmlPullParser, Resources resources) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFamily", $$robo$$android_content_res_FontResourcesParser$readFamily(org.xmlpull.v1.XmlPullParser android.content.res.Resources ), 0, (XmlPullParser)xmlPullParser, (Resources)resources);
    }

    private static FontFileResourceEntry readFont(XmlPullParser xmlPullParser, Resources resources) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFont", $$robo$$android_content_res_FontResourcesParser$readFont(org.xmlpull.v1.XmlPullParser android.content.res.Resources ), 0, (XmlPullParser)xmlPullParser, (Resources)resources);
    }

    private static void skip(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("skip", $$robo$$android_content_res_FontResourcesParser$skip(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontResourcesParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class FontFamilyFilesResourceEntry
    implements FamilyResourceEntry,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private FontFileResourceEntry[] mEntries;

        private void $$robo$$android_content_res_FontResourcesParser_FontFamilyFilesResourceEntry$__constructor__(FontFileResourceEntry[] entries) {
            this.mEntries = entries;
        }

        private final FontFileResourceEntry[] $$robo$$android_content_res_FontResourcesParser_FontFamilyFilesResourceEntry$getEntries() {
            return this.mEntries;
        }

        private void __constructor__(FontFileResourceEntry[] fontFileResourceEntryArray) {
            this.$$robo$$android_content_res_FontResourcesParser_FontFamilyFilesResourceEntry$__constructor__(fontFileResourceEntryArray);
        }

        public FontFamilyFilesResourceEntry(FontFileResourceEntry[] fontFileResourceEntryArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_FontResourcesParser_FontFamilyFilesResourceEntry$__constructor__(android.content.res.FontResourcesParser$FontFileResourceEntry[] ), 0, this, fontFileResourceEntryArray);
        }

        public FontFileResourceEntry[] getEntries() {
            return InvokeDynamicSupport.bootstrap("getEntries", $$robo$$android_content_res_FontResourcesParser_FontFamilyFilesResourceEntry$getEntries(), 0, this);
        }

        public /* synthetic */ FontFamilyFilesResourceEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontFamilyFilesResourceEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class FontFileResourceEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mFileName;
        private int mWeight;
        private int mItalic;
        private int mTtcIndex;
        private String mVariationSettings;
        private int mResourceId;

        private void $$robo$$android_content_res_FontResourcesParser_FontFileResourceEntry$__constructor__(String fileName, int weight, int italic, String variationSettings, int ttcIndex) {
            this.mFileName = fileName;
            this.mWeight = weight;
            this.mItalic = italic;
            this.mVariationSettings = variationSettings;
            this.mTtcIndex = ttcIndex;
        }

        private final String $$robo$$android_content_res_FontResourcesParser_FontFileResourceEntry$getFileName() {
            return this.mFileName;
        }

        private final int $$robo$$android_content_res_FontResourcesParser_FontFileResourceEntry$getWeight() {
            return this.mWeight;
        }

        private final int $$robo$$android_content_res_FontResourcesParser_FontFileResourceEntry$getItalic() {
            return this.mItalic;
        }

        private final String $$robo$$android_content_res_FontResourcesParser_FontFileResourceEntry$getVariationSettings() {
            return this.mVariationSettings;
        }

        private final int $$robo$$android_content_res_FontResourcesParser_FontFileResourceEntry$getTtcIndex() {
            return this.mTtcIndex;
        }

        private void __constructor__(String string2, int n, int n2, String string3, int n3) {
            this.$$robo$$android_content_res_FontResourcesParser_FontFileResourceEntry$__constructor__(string2, n, n2, string3, n3);
        }

        public FontFileResourceEntry(String string2, int n, int n2, String string3, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_FontResourcesParser_FontFileResourceEntry$__constructor__(java.lang.String int int java.lang.String int ), 0, this, string2, n, n2, string3, n3);
        }

        public String getFileName() {
            return InvokeDynamicSupport.bootstrap("getFileName", $$robo$$android_content_res_FontResourcesParser_FontFileResourceEntry$getFileName(), 0, this);
        }

        public int getWeight() {
            return (int)InvokeDynamicSupport.bootstrap("getWeight", $$robo$$android_content_res_FontResourcesParser_FontFileResourceEntry$getWeight(), 0, this);
        }

        public int getItalic() {
            return (int)InvokeDynamicSupport.bootstrap("getItalic", $$robo$$android_content_res_FontResourcesParser_FontFileResourceEntry$getItalic(), 0, this);
        }

        public String getVariationSettings() {
            return InvokeDynamicSupport.bootstrap("getVariationSettings", $$robo$$android_content_res_FontResourcesParser_FontFileResourceEntry$getVariationSettings(), 0, this);
        }

        public int getTtcIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getTtcIndex", $$robo$$android_content_res_FontResourcesParser_FontFileResourceEntry$getTtcIndex(), 0, this);
        }

        public /* synthetic */ FontFileResourceEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontFileResourceEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProviderResourceEntry
    implements FamilyResourceEntry,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mProviderAuthority;
        private String mProviderPackage;
        private String mQuery;
        private List<List<String>> mCerts;

        private void $$robo$$android_content_res_FontResourcesParser_ProviderResourceEntry$__constructor__(String authority, String pkg, String query, List<List<String>> certs) {
            this.mProviderAuthority = authority;
            this.mProviderPackage = pkg;
            this.mQuery = query;
            this.mCerts = certs;
        }

        private final String $$robo$$android_content_res_FontResourcesParser_ProviderResourceEntry$getAuthority() {
            return this.mProviderAuthority;
        }

        private final String $$robo$$android_content_res_FontResourcesParser_ProviderResourceEntry$getPackage() {
            return this.mProviderPackage;
        }

        private final String $$robo$$android_content_res_FontResourcesParser_ProviderResourceEntry$getQuery() {
            return this.mQuery;
        }

        private final List<List<String>> $$robo$$android_content_res_FontResourcesParser_ProviderResourceEntry$getCerts() {
            return this.mCerts;
        }

        private void __constructor__(String string2, String string3, String string4, List<List<String>> list) {
            this.$$robo$$android_content_res_FontResourcesParser_ProviderResourceEntry$__constructor__(string2, string3, string4, list);
        }

        public ProviderResourceEntry(String string2, String string3, String string4, List<List<String>> list) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_FontResourcesParser_ProviderResourceEntry$__constructor__(java.lang.String java.lang.String java.lang.String java.util.List<java.util.List<java.lang.String>> ), 0, this, string2, string3, string4, list);
        }

        public String getAuthority() {
            return InvokeDynamicSupport.bootstrap("getAuthority", $$robo$$android_content_res_FontResourcesParser_ProviderResourceEntry$getAuthority(), 0, this);
        }

        public String getPackage() {
            return InvokeDynamicSupport.bootstrap("getPackage", $$robo$$android_content_res_FontResourcesParser_ProviderResourceEntry$getPackage(), 0, this);
        }

        public String getQuery() {
            return InvokeDynamicSupport.bootstrap("getQuery", $$robo$$android_content_res_FontResourcesParser_ProviderResourceEntry$getQuery(), 0, this);
        }

        public List<List<String>> getCerts() {
            return InvokeDynamicSupport.bootstrap("getCerts", $$robo$$android_content_res_FontResourcesParser_ProviderResourceEntry$getCerts(), 0, this);
        }

        public /* synthetic */ ProviderResourceEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProviderResourceEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface FamilyResourceEntry
    extends InstrumentedInterface {
    }
}

