/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.AbstractWindowedCursor;
import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.sqlite.DatabaseObjectNotClosedException;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQuery;
import android.os.StrictMode;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SQLiteCursor
extends AbstractWindowedCursor
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "SQLiteCursor";
    static int NO_COUNT = -1;
    private String mEditTable;
    private String[] mColumns;
    private SQLiteQuery mQuery;
    private SQLiteCursorDriver mDriver;
    private int mCount;
    private int mCursorWindowCapacity;
    private Map<String, Integer> mColumnNameMap;
    private Throwable mStackTrace;
    private boolean mFillWindowForwardOnly;

    @Deprecated
    private void $$robo$$android_database_sqlite_SQLiteCursor$__constructor__(SQLiteDatabase db, SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
    }

    private void $$robo$$android_database_sqlite_SQLiteCursor$__constructor__(SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
        this.mCount = -1;
        if (query == null) {
            throw new IllegalArgumentException("query object cannot be null");
        }
        this.mStackTrace = StrictMode.vmSqliteObjectLeaksEnabled() ? new DatabaseObjectNotClosedException().fillInStackTrace() : null;
        this.mDriver = driver;
        this.mEditTable = editTable;
        this.mColumnNameMap = null;
        this.mQuery = query;
        this.mColumns = query.getColumnNames();
    }

    private final SQLiteDatabase $$robo$$android_database_sqlite_SQLiteCursor$getDatabase() {
        return this.mQuery.getDatabase();
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteCursor$onMove(int oldPosition, int newPosition) {
        if (this.mWindow == null || newPosition < this.mWindow.getStartPosition() || newPosition >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
            this.fillWindow(newPosition);
        }
        return true;
    }

    private final int $$robo$$android_database_sqlite_SQLiteCursor$getCount() {
        if (this.mCount == -1) {
            this.fillWindow(0);
        }
        return this.mCount;
    }

    private final void $$robo$$android_database_sqlite_SQLiteCursor$fillWindow(int requiredPos) {
        this.clearOrCreateWindow(this.getDatabase().getPath());
        try {
            Preconditions.checkArgumentNonnegative(requiredPos, "requiredPos cannot be negative, but was " + requiredPos);
            if (this.mCount == -1) {
                this.mCount = this.mQuery.fillWindow(this.mWindow, requiredPos, requiredPos, true);
                this.mCursorWindowCapacity = this.mWindow.getNumRows();
                if (Log.isLoggable("SQLiteCursor", 3)) {
                    Log.d("SQLiteCursor", "received count(*) from native_fill_window: " + this.mCount);
                }
            } else {
                int startPos = this.mFillWindowForwardOnly ? requiredPos : DatabaseUtils.cursorPickFillWindowStartPosition(requiredPos, this.mCursorWindowCapacity);
                this.mQuery.fillWindow(this.mWindow, startPos, requiredPos, false);
            }
        }
        catch (RuntimeException ex) {
            this.closeWindow();
            throw ex;
        }
    }

    private final int $$robo$$android_database_sqlite_SQLiteCursor$getColumnIndex(String columnName) {
        Integer i;
        int periodIndex;
        if (this.mColumnNameMap == null) {
            String[] columns = this.mColumns;
            int columnCount = columns.length;
            HashMap<String, Integer> map = new HashMap<String, Integer>(columnCount, 1.0f);
            for (int i2 = 0; i2 < columnCount; ++i2) {
                map.put(columns[i2], i2);
            }
            this.mColumnNameMap = map;
        }
        if ((periodIndex = columnName.lastIndexOf(46)) != -1) {
            Exception e = new Exception();
            Log.e("SQLiteCursor", "requesting column name with table name -- " + columnName, e);
            columnName = columnName.substring(periodIndex + 1);
        }
        if ((i = this.mColumnNameMap.get(columnName)) != null) {
            return i;
        }
        return -1;
    }

    private final String[] $$robo$$android_database_sqlite_SQLiteCursor$getColumnNames() {
        return this.mColumns;
    }

    private final void $$robo$$android_database_sqlite_SQLiteCursor$deactivate() {
        super.deactivate();
        this.mDriver.cursorDeactivated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteCursor$close() {
        super.close();
        SQLiteCursor sQLiteCursor = this;
        synchronized (sQLiteCursor) {
            this.mQuery.close();
            this.mDriver.cursorClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_database_sqlite_SQLiteCursor$requery() {
        if (this.isClosed()) {
            return false;
        }
        SQLiteCursor sQLiteCursor = this;
        synchronized (sQLiteCursor) {
            if (!this.mQuery.getDatabase().isOpen()) {
                return false;
            }
            if (this.mWindow != null) {
                this.mWindow.clear();
            }
            this.mPos = -1;
            this.mCount = -1;
            this.mDriver.cursorRequeried(this);
        }
        try {
            return super.requery();
        }
        catch (IllegalStateException e) {
            Log.w("SQLiteCursor", "requery() failed " + e.getMessage(), e);
            return false;
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteCursor$setWindow(CursorWindow window) {
        super.setWindow(window);
        this.mCount = -1;
    }

    private final void $$robo$$android_database_sqlite_SQLiteCursor$setSelectionArguments(String[] selectionArgs) {
        this.mDriver.setBindArguments(selectionArgs);
    }

    private final void $$robo$$android_database_sqlite_SQLiteCursor$setFillWindowForwardOnly(boolean fillWindowForwardOnly) {
        this.mFillWindowForwardOnly = fillWindowForwardOnly;
    }

    private final void $$robo$$android_database_sqlite_SQLiteCursor$finalize() {
        try {
            if (this.mWindow != null) {
                if (this.mStackTrace != null) {
                    String sql = this.mQuery.getSql();
                    int len = sql.length();
                    StrictMode.onSqliteObjectLeaked("Finalizing a Cursor that has not been deactivated or closed. database = " + this.mQuery.getDatabase().getLabel() + ", table = " + this.mEditTable + ", query = " + sql.substring(0, len > 1000 ? 1000 : len), this.mStackTrace);
                }
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    private void __constructor__(SQLiteDatabase sQLiteDatabase, SQLiteCursorDriver sQLiteCursorDriver, String string2, SQLiteQuery sQLiteQuery) {
        this.$$robo$$android_database_sqlite_SQLiteCursor$__constructor__(sQLiteDatabase, sQLiteCursorDriver, string2, sQLiteQuery);
    }

    public SQLiteCursor(SQLiteDatabase sQLiteDatabase, SQLiteCursorDriver sQLiteCursorDriver, String string2, SQLiteQuery sQLiteQuery) {
        this(sQLiteCursorDriver, string2, sQLiteQuery);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteCursor$__constructor__(android.database.sqlite.SQLiteDatabase android.database.sqlite.SQLiteCursorDriver java.lang.String android.database.sqlite.SQLiteQuery ), 0, this, sQLiteDatabase, sQLiteCursorDriver, string2, sQLiteQuery);
    }

    private void __constructor__(SQLiteCursorDriver sQLiteCursorDriver, String string2, SQLiteQuery sQLiteQuery) {
        this.$$robo$$android_database_sqlite_SQLiteCursor$__constructor__(sQLiteCursorDriver, string2, sQLiteQuery);
    }

    public SQLiteCursor(SQLiteCursorDriver sQLiteCursorDriver, String string2, SQLiteQuery sQLiteQuery) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteCursor$__constructor__(android.database.sqlite.SQLiteCursorDriver java.lang.String android.database.sqlite.SQLiteQuery ), 0, this, sQLiteCursorDriver, string2, sQLiteQuery);
    }

    public SQLiteDatabase getDatabase() {
        return InvokeDynamicSupport.bootstrap("getDatabase", $$robo$$android_database_sqlite_SQLiteCursor$getDatabase(), 0, this);
    }

    @Override
    public boolean onMove(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onMove", $$robo$$android_database_sqlite_SQLiteCursor$onMove(int int ), 0, this, n, n2);
    }

    @Override
    public int getCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_database_sqlite_SQLiteCursor$getCount(), 0, this);
    }

    private void fillWindow(int n) {
        InvokeDynamicSupport.bootstrap("fillWindow", $$robo$$android_database_sqlite_SQLiteCursor$fillWindow(int ), 0, this, n);
    }

    @Override
    public int getColumnIndex(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getColumnIndex", $$robo$$android_database_sqlite_SQLiteCursor$getColumnIndex(java.lang.String ), 0, this, string2);
    }

    @Override
    public String[] getColumnNames() {
        return InvokeDynamicSupport.bootstrap("getColumnNames", $$robo$$android_database_sqlite_SQLiteCursor$getColumnNames(), 0, this);
    }

    @Override
    public void deactivate() {
        InvokeDynamicSupport.bootstrap("deactivate", $$robo$$android_database_sqlite_SQLiteCursor$deactivate(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_database_sqlite_SQLiteCursor$close(), 0, this);
    }

    @Override
    public boolean requery() {
        return (boolean)InvokeDynamicSupport.bootstrap("requery", $$robo$$android_database_sqlite_SQLiteCursor$requery(), 0, this);
    }

    @Override
    public void setWindow(CursorWindow cursorWindow) {
        InvokeDynamicSupport.bootstrap("setWindow", $$robo$$android_database_sqlite_SQLiteCursor$setWindow(android.database.CursorWindow ), 0, this, cursorWindow);
    }

    public void setSelectionArguments(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setSelectionArguments", $$robo$$android_database_sqlite_SQLiteCursor$setSelectionArguments(java.lang.String[] ), 0, this, stringArray);
    }

    public void setFillWindowForwardOnly(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFillWindowForwardOnly", $$robo$$android_database_sqlite_SQLiteCursor$setFillWindowForwardOnly(boolean ), 0, this, bl);
    }

    @Override
    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_database_sqlite_SQLiteCursor$finalize(), 0, this);
    }

    public /* synthetic */ SQLiteCursor() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SQLiteCursor)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

