/*
 * Decompiled with CFR 0.152.
 */
package android.drm;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.drm.DrmConvertedStatus;
import android.drm.DrmErrorEvent;
import android.drm.DrmEvent;
import android.drm.DrmInfo;
import android.drm.DrmInfoEvent;
import android.drm.DrmInfoRequest;
import android.drm.DrmInfoStatus;
import android.drm.DrmRights;
import android.drm.DrmStore;
import android.drm.DrmSupportInfo;
import android.drm.DrmUtils;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DrmManagerClient
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int ERROR_NONE = 0;
    public static int ERROR_UNKNOWN = -2000;
    public static int INVALID_SESSION = -1;
    HandlerThread mInfoThread;
    HandlerThread mEventThread;
    private static String TAG = "DrmManagerClient";
    private AtomicBoolean mClosed;
    private CloseGuard mCloseGuard;
    private static int ACTION_REMOVE_ALL_RIGHTS = 1001;
    private static int ACTION_PROCESS_DRM_INFO = 1002;
    private int mUniqueId;
    private long mNativeContext;
    private Context mContext;
    private InfoHandler mInfoHandler;
    private EventHandler mEventHandler;
    private OnInfoListener mOnInfoListener;
    private OnEventListener mOnEventListener;
    private OnErrorListener mOnErrorListener;

    private static final void $$robo$$android_drm_DrmManagerClient$notify(Object thisReference, int uniqueId, int infoType, String message) {
        DrmManagerClient instance = (DrmManagerClient)((WeakReference)thisReference).get();
        if (null != instance && null != instance.mInfoHandler) {
            Message m = instance.mInfoHandler.obtainMessage(1, uniqueId, infoType, message);
            instance.mInfoHandler.sendMessage(m);
        }
    }

    private void $$robo$$android_drm_DrmManagerClient$__constructor__(Context context) {
        this.mClosed = new AtomicBoolean();
        this.mCloseGuard = CloseGuard.get();
        this.mContext = context;
        this.createEventThreads();
        this.mUniqueId = this._initialize();
        this.mCloseGuard.open("release");
    }

    private final void $$robo$$android_drm_DrmManagerClient$finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_drm_DrmManagerClient$close() {
        this.mCloseGuard.close();
        if (this.mClosed.compareAndSet(false, true)) {
            if (this.mEventHandler != null) {
                this.mEventThread.quit();
                this.mEventThread = null;
            }
            if (this.mInfoHandler != null) {
                this.mInfoThread.quit();
                this.mInfoThread = null;
            }
            this.mEventHandler = null;
            this.mInfoHandler = null;
            this.mOnEventListener = null;
            this.mOnInfoListener = null;
            this.mOnErrorListener = null;
            this._release(this.mUniqueId);
        }
    }

    @Deprecated
    private final void $$robo$$android_drm_DrmManagerClient$release() {
        this.close();
    }

    private final synchronized void $$robo$$android_drm_DrmManagerClient$setOnInfoListener(OnInfoListener infoListener) {
        this.mOnInfoListener = infoListener;
        if (null != infoListener) {
            this.createListeners();
        }
    }

    private final synchronized void $$robo$$android_drm_DrmManagerClient$setOnEventListener(OnEventListener eventListener) {
        this.mOnEventListener = eventListener;
        if (null != eventListener) {
            this.createListeners();
        }
    }

    private final synchronized void $$robo$$android_drm_DrmManagerClient$setOnErrorListener(OnErrorListener errorListener) {
        this.mOnErrorListener = errorListener;
        if (null != errorListener) {
            this.createListeners();
        }
    }

    private final String[] $$robo$$android_drm_DrmManagerClient$getAvailableDrmEngines() {
        DrmSupportInfo[] supportInfos = this._getAllSupportInfo(this.mUniqueId);
        ArrayList<String> descriptions = new ArrayList<String>();
        for (int i = 0; i < supportInfos.length; ++i) {
            descriptions.add(supportInfos[i].getDescriprition());
        }
        String[] drmEngines = new String[descriptions.size()];
        return descriptions.toArray(drmEngines);
    }

    private final ContentValues $$robo$$android_drm_DrmManagerClient$getConstraints(String path, int action) {
        if (null == path || path.equals("") || !DrmStore.Action.isValid(action)) {
            throw new IllegalArgumentException("Given usage or path is invalid/null");
        }
        return this._getConstraints(this.mUniqueId, path, action);
    }

    private final ContentValues $$robo$$android_drm_DrmManagerClient$getMetadata(String path) {
        if (null == path || path.equals("")) {
            throw new IllegalArgumentException("Given path is invalid/null");
        }
        return this._getMetadata(this.mUniqueId, path);
    }

    private final ContentValues $$robo$$android_drm_DrmManagerClient$getConstraints(Uri uri, int action) {
        if (null == uri || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Uri should be non null");
        }
        return this.getConstraints(this.convertUriToPath(uri), action);
    }

    private final ContentValues $$robo$$android_drm_DrmManagerClient$getMetadata(Uri uri) {
        if (null == uri || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Uri should be non null");
        }
        return this.getMetadata(this.convertUriToPath(uri));
    }

    private final int $$robo$$android_drm_DrmManagerClient$saveRights(DrmRights drmRights, String rightsPath, String contentPath) throws IOException {
        if (null == drmRights || !drmRights.isValid()) {
            throw new IllegalArgumentException("Given drmRights or contentPath is not valid");
        }
        if (null != rightsPath && !rightsPath.equals("")) {
            DrmUtils.writeToFile(rightsPath, drmRights.getData());
        }
        return this._saveRights(this.mUniqueId, drmRights, rightsPath, contentPath);
    }

    private final void $$robo$$android_drm_DrmManagerClient$installDrmEngine(String engineFilePath) {
        if (null == engineFilePath || engineFilePath.equals("")) {
            throw new IllegalArgumentException("Given engineFilePath: " + engineFilePath + "is not valid");
        }
        this._installDrmEngine(this.mUniqueId, engineFilePath);
    }

    private final boolean $$robo$$android_drm_DrmManagerClient$canHandle(String path, String mimeType) {
        if ((null == path || path.equals("")) && (null == mimeType || mimeType.equals(""))) {
            throw new IllegalArgumentException("Path or the mimetype should be non null");
        }
        return this._canHandle(this.mUniqueId, path, mimeType);
    }

    private final boolean $$robo$$android_drm_DrmManagerClient$canHandle(Uri uri, String mimeType) {
        if (!(null != uri && Uri.EMPTY != uri || null != mimeType && !mimeType.equals(""))) {
            throw new IllegalArgumentException("Uri or the mimetype should be non null");
        }
        return this.canHandle(this.convertUriToPath(uri), mimeType);
    }

    private final int $$robo$$android_drm_DrmManagerClient$processDrmInfo(DrmInfo drmInfo) {
        if (null == drmInfo || !drmInfo.isValid()) {
            throw new IllegalArgumentException("Given drmInfo is invalid/null");
        }
        int result = -2000;
        if (null != this.mEventHandler) {
            Message msg = this.mEventHandler.obtainMessage(1002, drmInfo);
            result = this.mEventHandler.sendMessage(msg) ? 0 : result;
        }
        return result;
    }

    private final DrmInfo $$robo$$android_drm_DrmManagerClient$acquireDrmInfo(DrmInfoRequest drmInfoRequest) {
        if (null == drmInfoRequest || !drmInfoRequest.isValid()) {
            throw new IllegalArgumentException("Given drmInfoRequest is invalid/null");
        }
        return this._acquireDrmInfo(this.mUniqueId, drmInfoRequest);
    }

    private final int $$robo$$android_drm_DrmManagerClient$acquireRights(DrmInfoRequest drmInfoRequest) {
        DrmInfo drmInfo = this.acquireDrmInfo(drmInfoRequest);
        if (null == drmInfo) {
            return -2000;
        }
        return this.processDrmInfo(drmInfo);
    }

    private final int $$robo$$android_drm_DrmManagerClient$getDrmObjectType(String path, String mimeType) {
        if ((null == path || path.equals("")) && (null == mimeType || mimeType.equals(""))) {
            throw new IllegalArgumentException("Path or the mimetype should be non null");
        }
        return this._getDrmObjectType(this.mUniqueId, path, mimeType);
    }

    private final int $$robo$$android_drm_DrmManagerClient$getDrmObjectType(Uri uri, String mimeType) {
        if (!(null != uri && Uri.EMPTY != uri || null != mimeType && !mimeType.equals(""))) {
            throw new IllegalArgumentException("Uri or the mimetype should be non null");
        }
        String path = "";
        try {
            path = this.convertUriToPath(uri);
        }
        catch (Exception e) {
            Log.w("DrmManagerClient", "Given Uri could not be found in media store");
        }
        return this.getDrmObjectType(path, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_drm_DrmManagerClient$getOriginalMimeType(String path) {
        if (null == path || path.equals("")) {
            throw new IllegalArgumentException("Given path should be non null");
        }
        String mime = null;
        FileInputStream is = null;
        try {
            FileDescriptor fd = null;
            File file = new File(path);
            if (file.exists()) {
                is = new FileInputStream(file);
                fd = is.getFD();
            }
            mime = this._getOriginalMimeType(this.mUniqueId, path, fd);
        }
        catch (IOException iOException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return mime;
    }

    private final String $$robo$$android_drm_DrmManagerClient$getOriginalMimeType(Uri uri) {
        if (null == uri || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Given uri is not valid");
        }
        return this.getOriginalMimeType(this.convertUriToPath(uri));
    }

    private final int $$robo$$android_drm_DrmManagerClient$checkRightsStatus(String path) {
        return this.checkRightsStatus(path, 0);
    }

    private final int $$robo$$android_drm_DrmManagerClient$checkRightsStatus(Uri uri) {
        if (null == uri || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Given uri is not valid");
        }
        return this.checkRightsStatus(this.convertUriToPath(uri));
    }

    private final int $$robo$$android_drm_DrmManagerClient$checkRightsStatus(String path, int action) {
        if (null == path || path.equals("") || !DrmStore.Action.isValid(action)) {
            throw new IllegalArgumentException("Given path or action is not valid");
        }
        return this._checkRightsStatus(this.mUniqueId, path, action);
    }

    private final int $$robo$$android_drm_DrmManagerClient$checkRightsStatus(Uri uri, int action) {
        if (null == uri || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Given uri is not valid");
        }
        return this.checkRightsStatus(this.convertUriToPath(uri), action);
    }

    private final int $$robo$$android_drm_DrmManagerClient$removeRights(String path) {
        if (null == path || path.equals("")) {
            throw new IllegalArgumentException("Given path should be non null");
        }
        return this._removeRights(this.mUniqueId, path);
    }

    private final int $$robo$$android_drm_DrmManagerClient$removeRights(Uri uri) {
        if (null == uri || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Given uri is not valid");
        }
        return this.removeRights(this.convertUriToPath(uri));
    }

    private final int $$robo$$android_drm_DrmManagerClient$removeAllRights() {
        int result = -2000;
        if (null != this.mEventHandler) {
            Message msg = this.mEventHandler.obtainMessage(1001);
            result = this.mEventHandler.sendMessage(msg) ? 0 : result;
        }
        return result;
    }

    private final int $$robo$$android_drm_DrmManagerClient$openConvertSession(String mimeType) {
        if (null == mimeType || mimeType.equals("")) {
            throw new IllegalArgumentException("Path or the mimeType should be non null");
        }
        return this._openConvertSession(this.mUniqueId, mimeType);
    }

    private final DrmConvertedStatus $$robo$$android_drm_DrmManagerClient$convertData(int convertId, byte[] inputData) {
        if (null == inputData || 0 >= inputData.length) {
            throw new IllegalArgumentException("Given inputData should be non null");
        }
        return this._convertData(this.mUniqueId, convertId, inputData);
    }

    private final DrmConvertedStatus $$robo$$android_drm_DrmManagerClient$closeConvertSession(int convertId) {
        return this._closeConvertSession(this.mUniqueId, convertId);
    }

    private final int $$robo$$android_drm_DrmManagerClient$getEventType(int infoType) {
        int eventType = -1;
        switch (infoType) {
            case 1: 
            case 2: 
            case 3: {
                eventType = 1002;
            }
        }
        return eventType;
    }

    private final int $$robo$$android_drm_DrmManagerClient$getErrorType(int infoType) {
        int error = -1;
        switch (infoType) {
            case 1: 
            case 2: 
            case 3: {
                error = 2006;
            }
        }
        return error;
    }

    private final String $$robo$$android_drm_DrmManagerClient$convertUriToPath(Uri uri) {
        String path = null;
        if (null != uri) {
            String scheme = uri.getScheme();
            if (null == scheme || scheme.equals("") || scheme.equals("file")) {
                path = uri.getPath();
            } else if (scheme.equals("http")) {
                path = uri.toString();
            } else if (scheme.equals("content")) {
                String[] projection = new String[]{"_data"};
                Cursor cursor = null;
                try {
                    cursor = this.mContext.getContentResolver().query(uri, projection, null, null, null);
                    if (null == cursor || 0 == cursor.getCount() || !cursor.moveToFirst()) {
                        throw new IllegalArgumentException("Given Uri could not be found in media store");
                    }
                    int pathIndex = cursor.getColumnIndexOrThrow("_data");
                    path = cursor.getString(pathIndex);
                }
                catch (SQLiteException e) {
                    throw new IllegalArgumentException("Given Uri is not formatted in a way so that it can be found in media store.");
                }
                finally {
                    if (null != cursor) {
                        cursor.close();
                    }
                }
            } else {
                throw new IllegalArgumentException("Given Uri scheme is not supported");
            }
        }
        return path;
    }

    private final int $$robo$$android_drm_DrmManagerClient$_initialize() {
        return 0;
    }

    private final void $$robo$$android_drm_DrmManagerClient$_setListeners(int n, Object object) {
    }

    private final void $$robo$$android_drm_DrmManagerClient$_release(int n) {
    }

    private final void $$robo$$android_drm_DrmManagerClient$_installDrmEngine(int n, String string2) {
    }

    private final ContentValues $$robo$$android_drm_DrmManagerClient$_getConstraints(int n, String string2, int n2) {
        return null;
    }

    private final ContentValues $$robo$$android_drm_DrmManagerClient$_getMetadata(int n, String string2) {
        return null;
    }

    private final boolean $$robo$$android_drm_DrmManagerClient$_canHandle(int n, String string2, String string3) {
        return false;
    }

    private final DrmInfoStatus $$robo$$android_drm_DrmManagerClient$_processDrmInfo(int n, DrmInfo drmInfo) {
        return null;
    }

    private final DrmInfo $$robo$$android_drm_DrmManagerClient$_acquireDrmInfo(int n, DrmInfoRequest drmInfoRequest) {
        return null;
    }

    private final int $$robo$$android_drm_DrmManagerClient$_saveRights(int n, DrmRights drmRights, String string2, String string3) {
        return 0;
    }

    private final int $$robo$$android_drm_DrmManagerClient$_getDrmObjectType(int n, String string2, String string3) {
        return 0;
    }

    private final String $$robo$$android_drm_DrmManagerClient$_getOriginalMimeType(int n, String string2, FileDescriptor fileDescriptor) {
        return null;
    }

    private final int $$robo$$android_drm_DrmManagerClient$_checkRightsStatus(int n, String string2, int n2) {
        return 0;
    }

    private final int $$robo$$android_drm_DrmManagerClient$_removeRights(int n, String string2) {
        return 0;
    }

    private final int $$robo$$android_drm_DrmManagerClient$_removeAllRights(int n) {
        return 0;
    }

    private final int $$robo$$android_drm_DrmManagerClient$_openConvertSession(int n, String string2) {
        return 0;
    }

    private final DrmConvertedStatus $$robo$$android_drm_DrmManagerClient$_convertData(int n, int n2, byte[] byArray) {
        return null;
    }

    private final DrmConvertedStatus $$robo$$android_drm_DrmManagerClient$_closeConvertSession(int n, int n2) {
        return null;
    }

    private final DrmSupportInfo[] $$robo$$android_drm_DrmManagerClient$_getAllSupportInfo(int n) {
        return null;
    }

    private final void $$robo$$android_drm_DrmManagerClient$createEventThreads() {
        if (this.mEventHandler == null && this.mInfoHandler == null) {
            this.mInfoThread = new HandlerThread("DrmManagerClient.InfoHandler");
            this.mInfoThread.start();
            this.mInfoHandler = new InfoHandler(this, this.mInfoThread.getLooper());
            this.mEventThread = new HandlerThread("DrmManagerClient.EventHandler");
            this.mEventThread.start();
            this.mEventHandler = new EventHandler(this, this.mEventThread.getLooper());
        }
    }

    private final void $$robo$$android_drm_DrmManagerClient$createListeners() {
        this._setListeners(this.mUniqueId, new WeakReference<DrmManagerClient>(this));
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"drmframework_jni");
    }

    public static void notify(Object object, int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrapStatic("notify", $$robo$$android_drm_DrmManagerClient$notify(java.lang.Object int int java.lang.String ), 0, (Object)object, (int)n, (int)n2, (String)string2);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_drm_DrmManagerClient$__constructor__(context);
    }

    public DrmManagerClient(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_drm_DrmManagerClient$__constructor__(android.content.Context ), 0, this, context);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_drm_DrmManagerClient$finalize(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_drm_DrmManagerClient$close(), 0, this);
    }

    @Deprecated
    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_drm_DrmManagerClient$release(), 0, this);
    }

    public synchronized void setOnInfoListener(OnInfoListener onInfoListener) {
        InvokeDynamicSupport.bootstrap("setOnInfoListener", $$robo$$android_drm_DrmManagerClient$setOnInfoListener(android.drm.DrmManagerClient$OnInfoListener ), 0, this, onInfoListener);
    }

    public synchronized void setOnEventListener(OnEventListener onEventListener) {
        InvokeDynamicSupport.bootstrap("setOnEventListener", $$robo$$android_drm_DrmManagerClient$setOnEventListener(android.drm.DrmManagerClient$OnEventListener ), 0, this, onEventListener);
    }

    public synchronized void setOnErrorListener(OnErrorListener onErrorListener) {
        InvokeDynamicSupport.bootstrap("setOnErrorListener", $$robo$$android_drm_DrmManagerClient$setOnErrorListener(android.drm.DrmManagerClient$OnErrorListener ), 0, this, onErrorListener);
    }

    public String[] getAvailableDrmEngines() {
        return InvokeDynamicSupport.bootstrap("getAvailableDrmEngines", $$robo$$android_drm_DrmManagerClient$getAvailableDrmEngines(), 0, this);
    }

    public ContentValues getConstraints(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getConstraints", $$robo$$android_drm_DrmManagerClient$getConstraints(java.lang.String int ), 0, this, string2, n);
    }

    public ContentValues getMetadata(String string2) {
        return InvokeDynamicSupport.bootstrap("getMetadata", $$robo$$android_drm_DrmManagerClient$getMetadata(java.lang.String ), 0, this, string2);
    }

    public ContentValues getConstraints(Uri uri, int n) {
        return InvokeDynamicSupport.bootstrap("getConstraints", $$robo$$android_drm_DrmManagerClient$getConstraints(android.net.Uri int ), 0, this, uri, n);
    }

    public ContentValues getMetadata(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getMetadata", $$robo$$android_drm_DrmManagerClient$getMetadata(android.net.Uri ), 0, this, uri);
    }

    public int saveRights(DrmRights drmRights, String string2, String string3) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("saveRights", $$robo$$android_drm_DrmManagerClient$saveRights(android.drm.DrmRights java.lang.String java.lang.String ), 0, this, drmRights, string2, string3);
    }

    public void installDrmEngine(String string2) {
        InvokeDynamicSupport.bootstrap("installDrmEngine", $$robo$$android_drm_DrmManagerClient$installDrmEngine(java.lang.String ), 0, this, string2);
    }

    public boolean canHandle(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("canHandle", $$robo$$android_drm_DrmManagerClient$canHandle(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public boolean canHandle(Uri uri, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("canHandle", $$robo$$android_drm_DrmManagerClient$canHandle(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public int processDrmInfo(DrmInfo drmInfo) {
        return (int)InvokeDynamicSupport.bootstrap("processDrmInfo", $$robo$$android_drm_DrmManagerClient$processDrmInfo(android.drm.DrmInfo ), 0, this, drmInfo);
    }

    public DrmInfo acquireDrmInfo(DrmInfoRequest drmInfoRequest) {
        return InvokeDynamicSupport.bootstrap("acquireDrmInfo", $$robo$$android_drm_DrmManagerClient$acquireDrmInfo(android.drm.DrmInfoRequest ), 0, this, drmInfoRequest);
    }

    public int acquireRights(DrmInfoRequest drmInfoRequest) {
        return (int)InvokeDynamicSupport.bootstrap("acquireRights", $$robo$$android_drm_DrmManagerClient$acquireRights(android.drm.DrmInfoRequest ), 0, this, drmInfoRequest);
    }

    public int getDrmObjectType(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("getDrmObjectType", $$robo$$android_drm_DrmManagerClient$getDrmObjectType(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public int getDrmObjectType(Uri uri, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getDrmObjectType", $$robo$$android_drm_DrmManagerClient$getDrmObjectType(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public String getOriginalMimeType(String string2) {
        return InvokeDynamicSupport.bootstrap("getOriginalMimeType", $$robo$$android_drm_DrmManagerClient$getOriginalMimeType(java.lang.String ), 0, this, string2);
    }

    public String getOriginalMimeType(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getOriginalMimeType", $$robo$$android_drm_DrmManagerClient$getOriginalMimeType(android.net.Uri ), 0, this, uri);
    }

    public int checkRightsStatus(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("checkRightsStatus", $$robo$$android_drm_DrmManagerClient$checkRightsStatus(java.lang.String ), 0, this, string2);
    }

    public int checkRightsStatus(Uri uri) {
        return (int)InvokeDynamicSupport.bootstrap("checkRightsStatus", $$robo$$android_drm_DrmManagerClient$checkRightsStatus(android.net.Uri ), 0, this, uri);
    }

    public int checkRightsStatus(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("checkRightsStatus", $$robo$$android_drm_DrmManagerClient$checkRightsStatus(java.lang.String int ), 0, this, string2, n);
    }

    public int checkRightsStatus(Uri uri, int n) {
        return (int)InvokeDynamicSupport.bootstrap("checkRightsStatus", $$robo$$android_drm_DrmManagerClient$checkRightsStatus(android.net.Uri int ), 0, this, uri, n);
    }

    public int removeRights(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("removeRights", $$robo$$android_drm_DrmManagerClient$removeRights(java.lang.String ), 0, this, string2);
    }

    public int removeRights(Uri uri) {
        return (int)InvokeDynamicSupport.bootstrap("removeRights", $$robo$$android_drm_DrmManagerClient$removeRights(android.net.Uri ), 0, this, uri);
    }

    public int removeAllRights() {
        return (int)InvokeDynamicSupport.bootstrap("removeAllRights", $$robo$$android_drm_DrmManagerClient$removeAllRights(), 0, this);
    }

    public int openConvertSession(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("openConvertSession", $$robo$$android_drm_DrmManagerClient$openConvertSession(java.lang.String ), 0, this, string2);
    }

    public DrmConvertedStatus convertData(int n, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("convertData", $$robo$$android_drm_DrmManagerClient$convertData(int byte[] ), 0, this, n, byArray);
    }

    public DrmConvertedStatus closeConvertSession(int n) {
        return InvokeDynamicSupport.bootstrap("closeConvertSession", $$robo$$android_drm_DrmManagerClient$closeConvertSession(int ), 0, this, n);
    }

    private int getEventType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getEventType", $$robo$$android_drm_DrmManagerClient$getEventType(int ), 0, this, n);
    }

    private int getErrorType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getErrorType", $$robo$$android_drm_DrmManagerClient$getErrorType(int ), 0, this, n);
    }

    private String convertUriToPath(Uri uri) {
        return InvokeDynamicSupport.bootstrap("convertUriToPath", $$robo$$android_drm_DrmManagerClient$convertUriToPath(android.net.Uri ), 0, this, uri);
    }

    private final native /* synthetic */ int $$robo$$_initialize$nativeBinding();

    private int _initialize() {
        return (int)InvokeDynamicSupport.bootstrap("_initialize", $$robo$$android_drm_DrmManagerClient$_initialize(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$_setListeners$nativeBinding(int var1, Object var2);

    private void _setListeners(int n, Object object) {
        InvokeDynamicSupport.bootstrap("_setListeners", $$robo$$android_drm_DrmManagerClient$_setListeners(int java.lang.Object ), 1, this, n, object);
    }

    private final native /* synthetic */ void $$robo$$_release$nativeBinding(int var1);

    private void _release(int n) {
        InvokeDynamicSupport.bootstrap("_release", $$robo$$android_drm_DrmManagerClient$_release(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$_installDrmEngine$nativeBinding(int var1, String var2);

    private void _installDrmEngine(int n, String string2) {
        InvokeDynamicSupport.bootstrap("_installDrmEngine", $$robo$$android_drm_DrmManagerClient$_installDrmEngine(int java.lang.String ), 1, this, n, string2);
    }

    private final native /* synthetic */ ContentValues $$robo$$_getConstraints$nativeBinding(int var1, String var2, int var3);

    private ContentValues _getConstraints(int n, String string2, int n2) {
        return InvokeDynamicSupport.bootstrap("_getConstraints", $$robo$$android_drm_DrmManagerClient$_getConstraints(int java.lang.String int ), 1, this, n, string2, n2);
    }

    private final native /* synthetic */ ContentValues $$robo$$_getMetadata$nativeBinding(int var1, String var2);

    private ContentValues _getMetadata(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("_getMetadata", $$robo$$android_drm_DrmManagerClient$_getMetadata(int java.lang.String ), 1, this, n, string2);
    }

    private final native /* synthetic */ boolean $$robo$$_canHandle$nativeBinding(int var1, String var2, String var3);

    private boolean _canHandle(int n, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("_canHandle", $$robo$$android_drm_DrmManagerClient$_canHandle(int java.lang.String java.lang.String ), 1, this, n, string2, string3);
    }

    private final native /* synthetic */ DrmInfoStatus $$robo$$_processDrmInfo$nativeBinding(int var1, DrmInfo var2);

    private DrmInfoStatus _processDrmInfo(int n, DrmInfo drmInfo) {
        return InvokeDynamicSupport.bootstrap("_processDrmInfo", $$robo$$android_drm_DrmManagerClient$_processDrmInfo(int android.drm.DrmInfo ), 1, this, n, drmInfo);
    }

    private final native /* synthetic */ DrmInfo $$robo$$_acquireDrmInfo$nativeBinding(int var1, DrmInfoRequest var2);

    private DrmInfo _acquireDrmInfo(int n, DrmInfoRequest drmInfoRequest) {
        return InvokeDynamicSupport.bootstrap("_acquireDrmInfo", $$robo$$android_drm_DrmManagerClient$_acquireDrmInfo(int android.drm.DrmInfoRequest ), 1, this, n, drmInfoRequest);
    }

    private final native /* synthetic */ int $$robo$$_saveRights$nativeBinding(int var1, DrmRights var2, String var3, String var4);

    private int _saveRights(int n, DrmRights drmRights, String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("_saveRights", $$robo$$android_drm_DrmManagerClient$_saveRights(int android.drm.DrmRights java.lang.String java.lang.String ), 1, this, n, drmRights, string2, string3);
    }

    private final native /* synthetic */ int $$robo$$_getDrmObjectType$nativeBinding(int var1, String var2, String var3);

    private int _getDrmObjectType(int n, String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("_getDrmObjectType", $$robo$$android_drm_DrmManagerClient$_getDrmObjectType(int java.lang.String java.lang.String ), 1, this, n, string2, string3);
    }

    private final native /* synthetic */ String $$robo$$_getOriginalMimeType$nativeBinding(int var1, String var2, FileDescriptor var3);

    private String _getOriginalMimeType(int n, String string2, FileDescriptor fileDescriptor) {
        return InvokeDynamicSupport.bootstrap("_getOriginalMimeType", $$robo$$android_drm_DrmManagerClient$_getOriginalMimeType(int java.lang.String java.io.FileDescriptor ), 1, this, n, string2, fileDescriptor);
    }

    private final native /* synthetic */ int $$robo$$_checkRightsStatus$nativeBinding(int var1, String var2, int var3);

    private int _checkRightsStatus(int n, String string2, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("_checkRightsStatus", $$robo$$android_drm_DrmManagerClient$_checkRightsStatus(int java.lang.String int ), 1, this, n, string2, n2);
    }

    private final native /* synthetic */ int $$robo$$_removeRights$nativeBinding(int var1, String var2);

    private int _removeRights(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("_removeRights", $$robo$$android_drm_DrmManagerClient$_removeRights(int java.lang.String ), 1, this, n, string2);
    }

    private final native /* synthetic */ int $$robo$$_removeAllRights$nativeBinding(int var1);

    private int _removeAllRights(int n) {
        return (int)InvokeDynamicSupport.bootstrap("_removeAllRights", $$robo$$android_drm_DrmManagerClient$_removeAllRights(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$_openConvertSession$nativeBinding(int var1, String var2);

    private int _openConvertSession(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("_openConvertSession", $$robo$$android_drm_DrmManagerClient$_openConvertSession(int java.lang.String ), 1, this, n, string2);
    }

    private final native /* synthetic */ DrmConvertedStatus $$robo$$_convertData$nativeBinding(int var1, int var2, byte[] var3);

    private DrmConvertedStatus _convertData(int n, int n2, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("_convertData", $$robo$$android_drm_DrmManagerClient$_convertData(int int byte[] ), 1, this, n, n2, byArray);
    }

    private final native /* synthetic */ DrmConvertedStatus $$robo$$_closeConvertSession$nativeBinding(int var1, int var2);

    private DrmConvertedStatus _closeConvertSession(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("_closeConvertSession", $$robo$$android_drm_DrmManagerClient$_closeConvertSession(int int ), 1, this, n, n2);
    }

    private final native /* synthetic */ DrmSupportInfo[] $$robo$$_getAllSupportInfo$nativeBinding(int var1);

    private DrmSupportInfo[] _getAllSupportInfo(int n) {
        return InvokeDynamicSupport.bootstrap("_getAllSupportInfo", $$robo$$android_drm_DrmManagerClient$_getAllSupportInfo(int ), 1, this, n);
    }

    private void createEventThreads() {
        InvokeDynamicSupport.bootstrap("createEventThreads", $$robo$$android_drm_DrmManagerClient$createEventThreads(), 0, this);
    }

    private void createListeners() {
        InvokeDynamicSupport.bootstrap("createListeners", $$robo$$android_drm_DrmManagerClient$createListeners(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(DrmManagerClient.class);
    }

    public /* synthetic */ DrmManagerClient() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DrmManagerClient)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class InfoHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int INFO_EVENT_TYPE = 1;
        /* synthetic */ DrmManagerClient this$0;

        private void $$robo$$android_drm_DrmManagerClient_InfoHandler$__constructor__(DrmManagerClient drmManagerClient, Looper looper) {
        }

        private final void $$robo$$android_drm_DrmManagerClient_InfoHandler$handleMessage(Message msg) {
            DrmInfoEvent info = null;
            DrmErrorEvent error = null;
            switch (msg.what) {
                case 1: {
                    int uniqueId = msg.arg1;
                    int infoType = msg.arg2;
                    String message = msg.obj.toString();
                    switch (infoType) {
                        case 2: {
                            try {
                                DrmUtils.removeFile(message);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            info = new DrmInfoEvent(uniqueId, infoType, message);
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            info = new DrmInfoEvent(uniqueId, infoType, message);
                            break;
                        }
                        default: {
                            error = new DrmErrorEvent(uniqueId, infoType, message);
                        }
                    }
                    if (null != this.this$0.mOnInfoListener && null != info) {
                        this.this$0.mOnInfoListener.onInfo(this.this$0, info);
                    }
                    if (null != this.this$0.mOnErrorListener && null != error) {
                        this.this$0.mOnErrorListener.onError(this.this$0, error);
                    }
                    return;
                }
            }
            Log.e("DrmManagerClient", "Unknown message type " + msg.what);
        }

        private void __constructor__(DrmManagerClient drmManagerClient, Looper looper) {
            this.$$robo$$android_drm_DrmManagerClient_InfoHandler$__constructor__(drmManagerClient, looper);
        }

        public InfoHandler(DrmManagerClient drmManagerClient, Looper looper) {
            this.this$0 = drmManagerClient;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_drm_DrmManagerClient_InfoHandler$__constructor__(android.drm.DrmManagerClient android.os.Looper ), 0, this, drmManagerClient, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_drm_DrmManagerClient_InfoHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ InfoHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InfoHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EventHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DrmManagerClient this$0;

        private void $$robo$$android_drm_DrmManagerClient_EventHandler$__constructor__(DrmManagerClient drmManagerClient, Looper looper) {
        }

        private final void $$robo$$android_drm_DrmManagerClient_EventHandler$handleMessage(Message msg) {
            DrmEvent event = null;
            DrmErrorEvent error = null;
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            switch (msg.what) {
                case 1002: {
                    DrmInfo drmInfo = (DrmInfo)msg.obj;
                    DrmInfoStatus status = this.this$0._processDrmInfo(this.this$0.mUniqueId, drmInfo);
                    attributes.put("drm_info_status_object", status);
                    attributes.put("drm_info_object", drmInfo);
                    if (null != status && 1 == status.statusCode) {
                        event = new DrmEvent(this.this$0.mUniqueId, this.this$0.getEventType(status.infoType), null, attributes);
                        break;
                    }
                    int infoType = null != status ? status.infoType : drmInfo.getInfoType();
                    error = new DrmErrorEvent(this.this$0.mUniqueId, this.this$0.getErrorType(infoType), null, attributes);
                    break;
                }
                case 1001: {
                    if (0 == this.this$0._removeAllRights(this.this$0.mUniqueId)) {
                        event = new DrmEvent(this.this$0.mUniqueId, 1001, null);
                        break;
                    }
                    error = new DrmErrorEvent(this.this$0.mUniqueId, 2007, null);
                    break;
                }
                default: {
                    Log.e("DrmManagerClient", "Unknown message type " + msg.what);
                    return;
                }
            }
            if (null != this.this$0.mOnEventListener && null != event) {
                this.this$0.mOnEventListener.onEvent(this.this$0, event);
            }
            if (null != this.this$0.mOnErrorListener && null != error) {
                this.this$0.mOnErrorListener.onError(this.this$0, error);
            }
        }

        private void __constructor__(DrmManagerClient drmManagerClient, Looper looper) {
            this.$$robo$$android_drm_DrmManagerClient_EventHandler$__constructor__(drmManagerClient, looper);
        }

        public EventHandler(DrmManagerClient drmManagerClient, Looper looper) {
            this.this$0 = drmManagerClient;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_drm_DrmManagerClient_EventHandler$__constructor__(android.drm.DrmManagerClient android.os.Looper ), 0, this, drmManagerClient, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_drm_DrmManagerClient_EventHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ EventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnErrorListener
    extends InstrumentedInterface {
        public void onError(DrmManagerClient var1, DrmErrorEvent var2);
    }

    public static interface OnEventListener
    extends InstrumentedInterface {
        public void onEvent(DrmManagerClient var1, DrmEvent var2);
    }

    public static interface OnInfoListener
    extends InstrumentedInterface {
        public void onInfo(DrmManagerClient var1, DrmInfoEvent var2);
    }
}

