/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameManager;
import android.filterfw.core.GLEnvironment;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FilterContext
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private FrameManager mFrameManager;
    private GLEnvironment mGLEnvironment;
    private HashMap<String, Frame> mStoredFrames;
    private Set<FilterGraph> mGraphs;

    private void $$robo$$android_filterfw_core_FilterContext$__constructor__() {
        this.mStoredFrames = new HashMap();
        this.mGraphs = new HashSet<FilterGraph>();
    }

    private final FrameManager $$robo$$android_filterfw_core_FilterContext$getFrameManager() {
        return this.mFrameManager;
    }

    private final void $$robo$$android_filterfw_core_FilterContext$setFrameManager(FrameManager manager) {
        if (manager == null) {
            throw new NullPointerException("Attempting to set null FrameManager!");
        }
        if (manager.getContext() != null) {
            throw new IllegalArgumentException("Attempting to set FrameManager which is already bound to another FilterContext!");
        }
        this.mFrameManager = manager;
        this.mFrameManager.setContext(this);
    }

    private final GLEnvironment $$robo$$android_filterfw_core_FilterContext$getGLEnvironment() {
        return this.mGLEnvironment;
    }

    private final void $$robo$$android_filterfw_core_FilterContext$initGLEnvironment(GLEnvironment environment) {
        if (this.mGLEnvironment != null) {
            throw new RuntimeException("Attempting to re-initialize GL Environment for FilterContext!");
        }
        this.mGLEnvironment = environment;
    }

    private final synchronized void $$robo$$android_filterfw_core_FilterContext$storeFrame(String key, Frame frame) {
        Frame storedFrame = this.fetchFrame(key);
        if (storedFrame != null) {
            storedFrame.release();
        }
        frame.onFrameStore();
        this.mStoredFrames.put(key, frame.retain());
    }

    private final synchronized Frame $$robo$$android_filterfw_core_FilterContext$fetchFrame(String key) {
        Frame frame = this.mStoredFrames.get(key);
        if (frame != null) {
            frame.onFrameFetch();
        }
        return frame;
    }

    private final synchronized void $$robo$$android_filterfw_core_FilterContext$removeFrame(String key) {
        Frame frame = this.mStoredFrames.get(key);
        if (frame != null) {
            this.mStoredFrames.remove(key);
            frame.release();
        }
    }

    private final synchronized void $$robo$$android_filterfw_core_FilterContext$tearDown() {
        for (Frame frame : this.mStoredFrames.values()) {
            frame.release();
        }
        this.mStoredFrames.clear();
        for (FilterGraph graph : this.mGraphs) {
            graph.tearDown(this);
        }
        this.mGraphs.clear();
        if (this.mFrameManager != null) {
            this.mFrameManager.tearDown();
            this.mFrameManager = null;
        }
        if (this.mGLEnvironment != null) {
            this.mGLEnvironment.tearDown();
            this.mGLEnvironment = null;
        }
    }

    private final void $$robo$$android_filterfw_core_FilterContext$addGraph(FilterGraph graph) {
        this.mGraphs.add(graph);
    }

    private void __constructor__() {
        this.$$robo$$android_filterfw_core_FilterContext$__constructor__();
    }

    public FilterContext() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_FilterContext$__constructor__(), 0, this);
    }

    public FrameManager getFrameManager() {
        return InvokeDynamicSupport.bootstrap("getFrameManager", $$robo$$android_filterfw_core_FilterContext$getFrameManager(), 0, this);
    }

    public void setFrameManager(FrameManager frameManager) {
        InvokeDynamicSupport.bootstrap("setFrameManager", $$robo$$android_filterfw_core_FilterContext$setFrameManager(android.filterfw.core.FrameManager ), 0, this, frameManager);
    }

    public GLEnvironment getGLEnvironment() {
        return InvokeDynamicSupport.bootstrap("getGLEnvironment", $$robo$$android_filterfw_core_FilterContext$getGLEnvironment(), 0, this);
    }

    public void initGLEnvironment(GLEnvironment gLEnvironment) {
        InvokeDynamicSupport.bootstrap("initGLEnvironment", $$robo$$android_filterfw_core_FilterContext$initGLEnvironment(android.filterfw.core.GLEnvironment ), 0, this, gLEnvironment);
    }

    public synchronized void storeFrame(String string2, Frame frame) {
        InvokeDynamicSupport.bootstrap("storeFrame", $$robo$$android_filterfw_core_FilterContext$storeFrame(java.lang.String android.filterfw.core.Frame ), 0, this, string2, frame);
    }

    public synchronized Frame fetchFrame(String string2) {
        return InvokeDynamicSupport.bootstrap("fetchFrame", $$robo$$android_filterfw_core_FilterContext$fetchFrame(java.lang.String ), 0, this, string2);
    }

    public synchronized void removeFrame(String string2) {
        InvokeDynamicSupport.bootstrap("removeFrame", $$robo$$android_filterfw_core_FilterContext$removeFrame(java.lang.String ), 0, this, string2);
    }

    public synchronized void tearDown() {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_filterfw_core_FilterContext$tearDown(), 0, this);
    }

    void addGraph(FilterGraph filterGraph) {
        InvokeDynamicSupport.bootstrap("addGraph", $$robo$$android_filterfw_core_FilterContext$addGraph(android.filterfw.core.FilterGraph ), 0, this, filterGraph);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FilterContext)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnFrameReceivedListener
    extends InstrumentedInterface {
        public void onFrameReceived(Filter var1, Frame var2, Object var3);
    }
}

