/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RedEyeFilter
extends Filter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static float RADIUS_RATIO = 0.06f;
    private static float MIN_RADIUS = 10.0f;
    private static float DEFAULT_RED_INTENSITY = 1.3f;
    @GenerateFieldPort(name="centers")
    private float[] mCenters;
    @GenerateFieldPort(name="tile_size", hasDefault=true)
    private int mTileSize;
    private Frame mRedEyeFrame;
    private Bitmap mRedEyeBitmap;
    private Canvas mCanvas;
    private Paint mPaint;
    private float mRadius;
    private int mWidth;
    private int mHeight;
    private Program mProgram;
    private int mTarget;
    private String mRedEyeShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform float intensity;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  vec4 mask = texture2D(tex_sampler_1, v_texcoord);\n  if (mask.a > 0.0) {\n    float green_blue = color.g + color.b;\n    float red_intensity = color.r / green_blue;\n    if (red_intensity > intensity) {\n      color.r = 0.5 * green_blue;\n    }\n  }\n  gl_FragColor = color;\n}\n";

    private void $$robo$$android_filterpacks_imageproc_RedEyeFilter$__constructor__(String name) {
        this.mTileSize = 640;
        this.mCanvas = new Canvas();
        this.mPaint = new Paint();
        this.mWidth = 0;
        this.mHeight = 0;
        this.mTarget = 0;
        this.mRedEyeShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform float intensity;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  vec4 mask = texture2D(tex_sampler_1, v_texcoord);\n  if (mask.a > 0.0) {\n    float green_blue = color.g + color.b;\n    float red_intensity = color.r / green_blue;\n    if (red_intensity > intensity) {\n      color.r = 0.5 * green_blue;\n    }\n  }\n  gl_FragColor = color;\n}\n";
    }

    private final void $$robo$$android_filterpacks_imageproc_RedEyeFilter$setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }

    private final FrameFormat $$robo$$android_filterpacks_imageproc_RedEyeFilter$getOutputFormat(String portName, FrameFormat inputFormat) {
        return inputFormat;
    }

    private final void $$robo$$android_filterpacks_imageproc_RedEyeFilter$initProgram(FilterContext context, int target) {
        switch (target) {
            case 3: {
                ShaderProgram shaderProgram = new ShaderProgram(context, "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform float intensity;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  vec4 mask = texture2D(tex_sampler_1, v_texcoord);\n  if (mask.a > 0.0) {\n    float green_blue = color.g + color.b;\n    float red_intensity = color.r / green_blue;\n    if (red_intensity > intensity) {\n      color.r = 0.5 * green_blue;\n    }\n  }\n  gl_FragColor = color;\n}\n");
                shaderProgram.setMaximumTileSize(this.mTileSize);
                this.mProgram = shaderProgram;
                this.mProgram.setHostValue("intensity", Float.valueOf(1.3f));
                break;
            }
            default: {
                throw new RuntimeException("Filter RedEye does not support frames of target " + target + "!");
            }
        }
        this.mTarget = target;
    }

    private final void $$robo$$android_filterpacks_imageproc_RedEyeFilter$process(FilterContext context) {
        Frame input = this.pullInput("image");
        FrameFormat inputFormat = input.getFormat();
        Frame output = context.getFrameManager().newFrame(inputFormat);
        if (this.mProgram == null || inputFormat.getTarget() != this.mTarget) {
            this.initProgram(context, inputFormat.getTarget());
        }
        if (inputFormat.getWidth() != this.mWidth || inputFormat.getHeight() != this.mHeight) {
            this.mWidth = inputFormat.getWidth();
            this.mHeight = inputFormat.getHeight();
        }
        this.createRedEyeFrame(context);
        Frame[] inputs = new Frame[]{input, this.mRedEyeFrame};
        this.mProgram.process(inputs, output);
        this.pushOutput("image", output);
        output.release();
        this.mRedEyeFrame.release();
        this.mRedEyeFrame = null;
    }

    private final void $$robo$$android_filterpacks_imageproc_RedEyeFilter$fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mProgram != null) {
            this.updateProgramParams();
        }
    }

    private final void $$robo$$android_filterpacks_imageproc_RedEyeFilter$createRedEyeFrame(FilterContext context) {
        int bitmapWidth = this.mWidth / 2;
        int bitmapHeight = this.mHeight / 2;
        Bitmap redEyeBitmap = Bitmap.createBitmap(bitmapWidth, bitmapHeight, Bitmap.Config.ARGB_8888);
        this.mCanvas.setBitmap(redEyeBitmap);
        this.mPaint.setColor(-1);
        this.mRadius = Math.max(10.0f, 0.06f * (float)Math.min(bitmapWidth, bitmapHeight));
        for (int i = 0; i < this.mCenters.length; i += 2) {
            this.mCanvas.drawCircle(this.mCenters[i] * (float)bitmapWidth, this.mCenters[i + 1] * (float)bitmapHeight, this.mRadius, this.mPaint);
        }
        MutableFrameFormat format = ImageFormat.create(bitmapWidth, bitmapHeight, 3, 3);
        this.mRedEyeFrame = context.getFrameManager().newFrame(format);
        this.mRedEyeFrame.setBitmap(redEyeBitmap);
        redEyeBitmap.recycle();
    }

    private final void $$robo$$android_filterpacks_imageproc_RedEyeFilter$updateProgramParams() {
        if (this.mCenters.length % 2 == 1) {
            throw new RuntimeException("The size of center array must be even.");
        }
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_imageproc_RedEyeFilter$__constructor__(string2);
    }

    public RedEyeFilter(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_imageproc_RedEyeFilter$__constructor__(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_imageproc_RedEyeFilter$setupPorts(), 0, this);
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return InvokeDynamicSupport.bootstrap("getOutputFormat", $$robo$$android_filterpacks_imageproc_RedEyeFilter$getOutputFormat(java.lang.String android.filterfw.core.FrameFormat ), 0, this, string2, frameFormat);
    }

    public void initProgram(FilterContext filterContext, int n) {
        InvokeDynamicSupport.bootstrap("initProgram", $$robo$$android_filterpacks_imageproc_RedEyeFilter$initProgram(android.filterfw.core.FilterContext int ), 0, this, filterContext, n);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_imageproc_RedEyeFilter$process(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("fieldPortValueUpdated", $$robo$$android_filterpacks_imageproc_RedEyeFilter$fieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), 0, this, string2, filterContext);
    }

    private void createRedEyeFrame(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("createRedEyeFrame", $$robo$$android_filterpacks_imageproc_RedEyeFilter$createRedEyeFrame(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    private void updateProgramParams() {
        InvokeDynamicSupport.bootstrap("updateProgramParams", $$robo$$android_filterpacks_imageproc_RedEyeFilter$updateProgramParams(), 0, this);
    }

    public /* synthetic */ RedEyeFilter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RedEyeFilter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

