/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ToPackedGrayFilter
extends Filter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @GenerateFieldPort(name="owidth", hasDefault=true)
    private int mOWidth;
    @GenerateFieldPort(name="oheight", hasDefault=true)
    private int mOHeight;
    @GenerateFieldPort(name="keepAspectRatio", hasDefault=true)
    private boolean mKeepAspectRatio;
    private Program mProgram;
    private String mColorToPackedGrayShader = "precision mediump float;\nconst vec4 coeff_y = vec4(0.299, 0.587, 0.114, 0);\nuniform sampler2D tex_sampler_0;\nuniform float pix_stride;\nvarying vec2 v_texcoord;\nvoid main() {\n  for (int i = 0; i < 4; ++i) {\n    vec4 p = texture2D(tex_sampler_0,\n                       v_texcoord + vec2(pix_stride * float(i), 0.0));\n    gl_FragColor[i] = dot(p, coeff_y);\n  }\n}\n";

    private void $$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$__constructor__(String name) {
        this.mOWidth = 0;
        this.mOHeight = 0;
        this.mKeepAspectRatio = false;
        this.mColorToPackedGrayShader = "precision mediump float;\nconst vec4 coeff_y = vec4(0.299, 0.587, 0.114, 0);\nuniform sampler2D tex_sampler_0;\nuniform float pix_stride;\nvarying vec2 v_texcoord;\nvoid main() {\n  for (int i = 0; i < 4; ++i) {\n    vec4 p = texture2D(tex_sampler_0,\n                       v_texcoord + vec2(pix_stride * float(i), 0.0));\n    gl_FragColor[i] = dot(p, coeff_y);\n  }\n}\n";
    }

    private final void $$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3, 3));
        this.addOutputBasedOnInput("image", "image");
    }

    private final FrameFormat $$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$getOutputFormat(String portName, FrameFormat inputFormat) {
        return this.convertInputFormat(inputFormat);
    }

    private final void $$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$checkOutputDimensions(int outputWidth, int outputHeight) {
        if (outputWidth <= 0 || outputHeight <= 0) {
            throw new RuntimeException("Invalid output dimensions: " + outputWidth + " " + outputHeight);
        }
    }

    private final FrameFormat $$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$convertInputFormat(FrameFormat inputFormat) {
        int ow = this.mOWidth;
        int oh = this.mOHeight;
        int w = inputFormat.getWidth();
        int h = inputFormat.getHeight();
        if (this.mOWidth == 0) {
            ow = w;
        }
        if (this.mOHeight == 0) {
            oh = h;
        }
        if (this.mKeepAspectRatio) {
            if (w > h) {
                ow = Math.max(ow, oh);
                oh = ow * h / w;
            } else {
                oh = Math.max(ow, oh);
                ow = oh * w / h;
            }
        }
        ow = ow > 0 && ow < 4 ? 4 : ow / 4 * 4;
        return ImageFormat.create(ow, oh, 1, 2);
    }

    private final void $$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$prepare(FilterContext context) {
        this.mProgram = new ShaderProgram(context, "precision mediump float;\nconst vec4 coeff_y = vec4(0.299, 0.587, 0.114, 0);\nuniform sampler2D tex_sampler_0;\nuniform float pix_stride;\nvarying vec2 v_texcoord;\nvoid main() {\n  for (int i = 0; i < 4; ++i) {\n    vec4 p = texture2D(tex_sampler_0,\n                       v_texcoord + vec2(pix_stride * float(i), 0.0));\n    gl_FragColor[i] = dot(p, coeff_y);\n  }\n}\n");
    }

    private final void $$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$process(FilterContext context) {
        Frame input = this.pullInput("image");
        FrameFormat inputFormat = input.getFormat();
        FrameFormat outputFormat = this.convertInputFormat(inputFormat);
        int ow = outputFormat.getWidth();
        int oh = outputFormat.getHeight();
        this.checkOutputDimensions(ow, oh);
        this.mProgram.setHostValue("pix_stride", Float.valueOf(1.0f / (float)ow));
        MutableFrameFormat tempFrameFormat = inputFormat.mutableCopy();
        tempFrameFormat.setDimensions(ow / 4, oh);
        Frame temp = context.getFrameManager().newFrame(tempFrameFormat);
        this.mProgram.process(input, temp);
        Frame output = context.getFrameManager().newFrame(outputFormat);
        output.setDataFromFrame(temp);
        temp.release();
        this.pushOutput("image", output);
        output.release();
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$__constructor__(string2);
    }

    public ToPackedGrayFilter(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$__constructor__(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$setupPorts(), 0, this);
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return InvokeDynamicSupport.bootstrap("getOutputFormat", $$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$getOutputFormat(java.lang.String android.filterfw.core.FrameFormat ), 0, this, string2, frameFormat);
    }

    private void checkOutputDimensions(int n, int n2) {
        InvokeDynamicSupport.bootstrap("checkOutputDimensions", $$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$checkOutputDimensions(int int ), 0, this, n, n2);
    }

    private FrameFormat convertInputFormat(FrameFormat frameFormat) {
        return InvokeDynamicSupport.bootstrap("convertInputFormat", $$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$convertInputFormat(android.filterfw.core.FrameFormat ), 0, this, frameFormat);
    }

    @Override
    public void prepare(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$prepare(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_imageproc_ToPackedGrayFilter$process(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    public /* synthetic */ ToPackedGrayFilter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ToPackedGrayFilter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

