/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.videosink;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.filterfw.geometry.Point;
import android.filterfw.geometry.Quad;
import android.filterpacks.videosink.MediaRecorderStopException;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaEncoderFilter
extends Filter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @GenerateFieldPort(name="recording", hasDefault=true)
    private boolean mRecording;
    @GenerateFieldPort(name="outputFile", hasDefault=true)
    private String mOutputFile;
    @GenerateFieldPort(name="outputFileDescriptor", hasDefault=true)
    private FileDescriptor mFd;
    @GenerateFieldPort(name="audioSource", hasDefault=true)
    private int mAudioSource;
    @GenerateFieldPort(name="infoListener", hasDefault=true)
    private MediaRecorder.OnInfoListener mInfoListener;
    @GenerateFieldPort(name="errorListener", hasDefault=true)
    private MediaRecorder.OnErrorListener mErrorListener;
    @GenerateFieldPort(name="recordingDoneListener", hasDefault=true)
    private OnRecordingDoneListener mRecordingDoneListener;
    @GenerateFieldPort(name="orientationHint", hasDefault=true)
    private int mOrientationHint;
    @GenerateFieldPort(name="recordingProfile", hasDefault=true)
    private CamcorderProfile mProfile;
    @GenerateFieldPort(name="width", hasDefault=true)
    private int mWidth;
    @GenerateFieldPort(name="height", hasDefault=true)
    private int mHeight;
    @GenerateFieldPort(name="framerate", hasDefault=true)
    private int mFps;
    @GenerateFieldPort(name="outputFormat", hasDefault=true)
    private int mOutputFormat;
    @GenerateFieldPort(name="videoEncoder", hasDefault=true)
    private int mVideoEncoder;
    @GenerateFieldPort(name="inputRegion", hasDefault=true)
    private Quad mSourceRegion;
    @GenerateFieldPort(name="maxFileSize", hasDefault=true)
    private long mMaxFileSize;
    @GenerateFieldPort(name="maxDurationMs", hasDefault=true)
    private int mMaxDurationMs;
    @GenerateFieldPort(name="timelapseRecordingIntervalUs", hasDefault=true)
    private long mTimeBetweenTimeLapseFrameCaptureUs;
    private static int NO_AUDIO_SOURCE = -1;
    private int mSurfaceId;
    private ShaderProgram mProgram;
    private GLFrame mScreen;
    private boolean mRecordingActive;
    private long mTimestampNs;
    private long mLastTimeLapseFrameRealTimestampNs;
    private int mNumFramesEncoded;
    private boolean mCaptureTimeLapse;
    private boolean mLogVerbose;
    private static String TAG = "MediaEncoderFilter";
    private MediaRecorder mMediaRecorder;

    private void $$robo$$android_filterpacks_videosink_MediaEncoderFilter$__constructor__(String name) {
        this.mRecording = true;
        this.mOutputFile = new String("/sdcard/MediaEncoderOut.mp4");
        this.mFd = null;
        this.mAudioSource = -1;
        this.mInfoListener = null;
        this.mErrorListener = null;
        this.mRecordingDoneListener = null;
        this.mOrientationHint = 0;
        this.mProfile = null;
        this.mWidth = 0;
        this.mHeight = 0;
        this.mFps = 30;
        this.mOutputFormat = 2;
        this.mVideoEncoder = 2;
        this.mMaxFileSize = 0L;
        this.mMaxDurationMs = 0;
        this.mTimeBetweenTimeLapseFrameCaptureUs = 0L;
        this.mRecordingActive = false;
        this.mTimestampNs = 0L;
        this.mLastTimeLapseFrameRealTimestampNs = 0L;
        this.mNumFramesEncoded = 0;
        this.mCaptureTimeLapse = false;
        Point bl = new Point(0.0f, 0.0f);
        Point br = new Point(1.0f, 0.0f);
        Point tl = new Point(0.0f, 1.0f);
        Point tr = new Point(1.0f, 1.0f);
        this.mSourceRegion = new Quad(bl, br, tl, tr);
        this.mLogVerbose = Log.isLoggable("MediaEncoderFilter", 2);
    }

    private final void $$robo$$android_filterpacks_videosink_MediaEncoderFilter$setupPorts() {
        this.addMaskedInputPort("videoframe", ImageFormat.create(3, 3));
    }

    private final void $$robo$$android_filterpacks_videosink_MediaEncoderFilter$fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("MediaEncoderFilter", "Port " + name + " has been updated");
        }
        if (name.equals("recording")) {
            return;
        }
        if (name.equals("inputRegion")) {
            if (this.isOpen()) {
                this.updateSourceRegion();
            }
            return;
        }
        if (this.isOpen() && this.mRecordingActive) {
            throw new RuntimeException("Cannot change recording parameters when the filter is recording!");
        }
    }

    private final void $$robo$$android_filterpacks_videosink_MediaEncoderFilter$updateSourceRegion() {
        Quad flippedRegion = new Quad();
        flippedRegion.p0 = this.mSourceRegion.p2;
        flippedRegion.p1 = this.mSourceRegion.p3;
        flippedRegion.p2 = this.mSourceRegion.p0;
        flippedRegion.p3 = this.mSourceRegion.p1;
        this.mProgram.setSourceRegion(flippedRegion);
    }

    private final void $$robo$$android_filterpacks_videosink_MediaEncoderFilter$updateMediaRecorderParams() {
        this.mCaptureTimeLapse = this.mTimeBetweenTimeLapseFrameCaptureUs > 0L;
        int GRALLOC_BUFFER = 2;
        this.mMediaRecorder.setVideoSource(2);
        if (!this.mCaptureTimeLapse && this.mAudioSource != -1) {
            this.mMediaRecorder.setAudioSource(this.mAudioSource);
        }
        if (this.mProfile != null) {
            this.mMediaRecorder.setProfile(this.mProfile);
            this.mFps = this.mProfile.videoFrameRate;
            if (this.mWidth > 0 && this.mHeight > 0) {
                this.mMediaRecorder.setVideoSize(this.mWidth, this.mHeight);
            }
        } else {
            this.mMediaRecorder.setOutputFormat(this.mOutputFormat);
            this.mMediaRecorder.setVideoEncoder(this.mVideoEncoder);
            this.mMediaRecorder.setVideoSize(this.mWidth, this.mHeight);
            this.mMediaRecorder.setVideoFrameRate(this.mFps);
        }
        this.mMediaRecorder.setOrientationHint(this.mOrientationHint);
        this.mMediaRecorder.setOnInfoListener(this.mInfoListener);
        this.mMediaRecorder.setOnErrorListener(this.mErrorListener);
        if (this.mFd != null) {
            this.mMediaRecorder.setOutputFile(this.mFd);
        } else {
            this.mMediaRecorder.setOutputFile(this.mOutputFile);
        }
        try {
            this.mMediaRecorder.setMaxFileSize(this.mMaxFileSize);
        }
        catch (Exception e) {
            Log.w("MediaEncoderFilter", "Setting maxFileSize on MediaRecorder unsuccessful! " + e.getMessage());
        }
        this.mMediaRecorder.setMaxDuration(this.mMaxDurationMs);
    }

    private final void $$robo$$android_filterpacks_videosink_MediaEncoderFilter$prepare(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("MediaEncoderFilter", "Preparing");
        }
        this.mProgram = ShaderProgram.createIdentity(context);
        this.mRecordingActive = false;
    }

    private final void $$robo$$android_filterpacks_videosink_MediaEncoderFilter$open(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("MediaEncoderFilter", "Opening");
        }
        this.updateSourceRegion();
        if (this.mRecording) {
            this.startRecording(context);
        }
    }

    private final void $$robo$$android_filterpacks_videosink_MediaEncoderFilter$startRecording(FilterContext context) {
        int height;
        int width;
        boolean widthHeightSpecified;
        if (this.mLogVerbose) {
            Log.v("MediaEncoderFilter", "Starting recording");
        }
        MutableFrameFormat screenFormat = new MutableFrameFormat(2, 3);
        screenFormat.setBytesPerSample(4);
        boolean bl = widthHeightSpecified = this.mWidth > 0 && this.mHeight > 0;
        if (this.mProfile != null && !widthHeightSpecified) {
            width = this.mProfile.videoFrameWidth;
            height = this.mProfile.videoFrameHeight;
        } else {
            width = this.mWidth;
            height = this.mHeight;
        }
        screenFormat.setDimensions(width, height);
        this.mScreen = (GLFrame)context.getFrameManager().newBoundFrame(screenFormat, 101, 0L);
        this.mMediaRecorder = new MediaRecorder();
        this.updateMediaRecorderParams();
        try {
            this.mMediaRecorder.prepare();
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException inMediaRecorder.prepare()!", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown Exception inMediaRecorder.prepare()!", e);
        }
        this.mMediaRecorder.start();
        if (this.mLogVerbose) {
            Log.v("MediaEncoderFilter", "Open: registering surface from Mediarecorder");
        }
        this.mSurfaceId = context.getGLEnvironment().registerSurfaceFromMediaRecorder(this.mMediaRecorder);
        this.mNumFramesEncoded = 0;
        this.mRecordingActive = true;
    }

    private final boolean $$robo$$android_filterpacks_videosink_MediaEncoderFilter$skipFrameAndModifyTimestamp(long timestampNs) {
        if (this.mNumFramesEncoded == 0) {
            this.mLastTimeLapseFrameRealTimestampNs = timestampNs;
            this.mTimestampNs = timestampNs;
            if (this.mLogVerbose) {
                Log.v("MediaEncoderFilter", "timelapse: FIRST frame, last real t= " + this.mLastTimeLapseFrameRealTimestampNs + ", setting t = " + this.mTimestampNs);
            }
            return false;
        }
        if (this.mNumFramesEncoded >= 2 && timestampNs < this.mLastTimeLapseFrameRealTimestampNs + 1000L * this.mTimeBetweenTimeLapseFrameCaptureUs) {
            if (this.mLogVerbose) {
                Log.v("MediaEncoderFilter", "timelapse: skipping intermediate frame");
            }
            return true;
        }
        if (this.mLogVerbose) {
            Log.v("MediaEncoderFilter", "timelapse: encoding frame, Timestamp t = " + timestampNs + ", last real t= " + this.mLastTimeLapseFrameRealTimestampNs + ", interval = " + this.mTimeBetweenTimeLapseFrameCaptureUs);
        }
        this.mLastTimeLapseFrameRealTimestampNs = timestampNs;
        this.mTimestampNs += 1000000000L / (long)this.mFps;
        if (this.mLogVerbose) {
            Log.v("MediaEncoderFilter", "timelapse: encoding frame, setting t = " + this.mTimestampNs + ", delta t = " + 1000000000L / (long)this.mFps + ", fps = " + this.mFps);
        }
        return false;
    }

    private final void $$robo$$android_filterpacks_videosink_MediaEncoderFilter$process(FilterContext context) {
        GLEnvironment glEnv = context.getGLEnvironment();
        Frame input = this.pullInput("videoframe");
        if (!this.mRecordingActive && this.mRecording) {
            this.startRecording(context);
        }
        if (this.mRecordingActive && !this.mRecording) {
            this.stopRecording(context);
        }
        if (!this.mRecordingActive) {
            return;
        }
        if (this.mCaptureTimeLapse) {
            if (this.skipFrameAndModifyTimestamp(input.getTimestamp())) {
                return;
            }
        } else {
            this.mTimestampNs = input.getTimestamp();
        }
        glEnv.activateSurfaceWithId(this.mSurfaceId);
        this.mProgram.process(input, (Frame)this.mScreen);
        glEnv.setSurfaceTimestamp(this.mTimestampNs);
        glEnv.swapBuffers();
        ++this.mNumFramesEncoded;
    }

    private final void $$robo$$android_filterpacks_videosink_MediaEncoderFilter$stopRecording(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("MediaEncoderFilter", "Stopping recording");
        }
        this.mRecordingActive = false;
        this.mNumFramesEncoded = 0;
        GLEnvironment glEnv = context.getGLEnvironment();
        if (this.mLogVerbose) {
            Log.v("MediaEncoderFilter", String.format("Unregistering surface %d", this.mSurfaceId));
        }
        glEnv.unregisterSurfaceId(this.mSurfaceId);
        try {
            this.mMediaRecorder.stop();
        }
        catch (RuntimeException e) {
            throw new MediaRecorderStopException("MediaRecorder.stop() failed!", e);
        }
        this.mMediaRecorder.release();
        this.mMediaRecorder = null;
        this.mScreen.release();
        this.mScreen = null;
        if (this.mRecordingDoneListener != null) {
            this.mRecordingDoneListener.onRecordingDone();
        }
    }

    private final void $$robo$$android_filterpacks_videosink_MediaEncoderFilter$close(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("MediaEncoderFilter", "Closing");
        }
        if (this.mRecordingActive) {
            this.stopRecording(context);
        }
    }

    private final void $$robo$$android_filterpacks_videosink_MediaEncoderFilter$tearDown(FilterContext context) {
        if (this.mMediaRecorder != null) {
            this.mMediaRecorder.release();
        }
        if (this.mScreen != null) {
            this.mScreen.release();
        }
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_videosink_MediaEncoderFilter$__constructor__(string2);
    }

    public MediaEncoderFilter(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_videosink_MediaEncoderFilter$__constructor__(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_videosink_MediaEncoderFilter$setupPorts(), 0, this);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("fieldPortValueUpdated", $$robo$$android_filterpacks_videosink_MediaEncoderFilter$fieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), 0, this, string2, filterContext);
    }

    private void updateSourceRegion() {
        InvokeDynamicSupport.bootstrap("updateSourceRegion", $$robo$$android_filterpacks_videosink_MediaEncoderFilter$updateSourceRegion(), 0, this);
    }

    private void updateMediaRecorderParams() {
        InvokeDynamicSupport.bootstrap("updateMediaRecorderParams", $$robo$$android_filterpacks_videosink_MediaEncoderFilter$updateMediaRecorderParams(), 0, this);
    }

    @Override
    public void prepare(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_filterpacks_videosink_MediaEncoderFilter$prepare(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void open(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("open", $$robo$$android_filterpacks_videosink_MediaEncoderFilter$open(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    private void startRecording(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("startRecording", $$robo$$android_filterpacks_videosink_MediaEncoderFilter$startRecording(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    public boolean skipFrameAndModifyTimestamp(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("skipFrameAndModifyTimestamp", $$robo$$android_filterpacks_videosink_MediaEncoderFilter$skipFrameAndModifyTimestamp(long ), 0, this, l);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_videosink_MediaEncoderFilter$process(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    private void stopRecording(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("stopRecording", $$robo$$android_filterpacks_videosink_MediaEncoderFilter$stopRecording(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void close(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_filterpacks_videosink_MediaEncoderFilter$close(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void tearDown(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_filterpacks_videosink_MediaEncoderFilter$tearDown(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    public /* synthetic */ MediaEncoderFilter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaEncoderFilter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnRecordingDoneListener
    extends InstrumentedInterface {
        public void onRecordingDone();
    }
}

