/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.ResourcesImpl;
import android.graphics.Canvas;
import android.graphics.ColorSpace;
import android.graphics.GraphicBuffer;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.os.Trace;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.DisplayListCanvas;
import android.view.RenderNode;
import android.view.ThreadedRenderer;
import com.google.errorprone.annotations.DoNotMock;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import libcore.util.NativeAllocationRegistry;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Bitmap
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Bitmap";
    public static int DENSITY_NONE = 0;
    private static long NATIVE_ALLOCATION_SIZE = 32L;
    private long mNativePtr;
    private boolean mIsMutable;
    private boolean mRequestPremultiplied;
    private byte[] mNinePatchChunk;
    private NinePatch.InsetStruct mNinePatchInsets;
    private int mWidth;
    private int mHeight;
    private boolean mRecycled;
    private ColorSpace mColorSpace;
    public int mDensity;
    private static volatile int sDefaultDensity;
    public static volatile int sPreloadTracingNumInstantiatedBitmaps;
    public static volatile long sPreloadTracingTotalBitmapsSize;
    private static int WORKING_COMPRESS_STORAGE = 4096;
    public static Parcelable.Creator<Bitmap> CREATOR;

    private static final void $$robo$$android_graphics_Bitmap$setDefaultDensity(int density) {
        sDefaultDensity = density;
    }

    private static final int $$robo$$android_graphics_Bitmap$getDefaultDensity() {
        if (sDefaultDensity >= 0) {
            return sDefaultDensity;
        }
        sDefaultDensity = DisplayMetrics.DENSITY_DEVICE;
        return sDefaultDensity;
    }

    private void $$robo$$android_graphics_Bitmap$__constructor__(long nativeBitmap, int width, int height, int density, boolean isMutable, boolean requestPremultiplied, byte[] ninePatchChunk, NinePatch.InsetStruct ninePatchInsets) {
        this.mDensity = Bitmap.getDefaultDensity();
        if (nativeBitmap == 0L) {
            throw new RuntimeException("internal error: native bitmap is 0");
        }
        this.mWidth = width;
        this.mHeight = height;
        this.mIsMutable = isMutable;
        this.mRequestPremultiplied = requestPremultiplied;
        this.mNinePatchChunk = ninePatchChunk;
        this.mNinePatchInsets = ninePatchInsets;
        if (density >= 0) {
            this.mDensity = density;
        }
        this.mNativePtr = nativeBitmap;
        long nativeSize = 32L + (long)this.getAllocationByteCount();
        NativeAllocationRegistry registry = new NativeAllocationRegistry(Bitmap.class.getClassLoader(), Bitmap.nativeGetNativeFinalizer(), nativeSize);
        registry.registerNativeAllocation((Object)this, nativeBitmap);
        if (ResourcesImpl.TRACE_FOR_DETAILED_PRELOAD) {
            ++sPreloadTracingNumInstantiatedBitmaps;
            sPreloadTracingTotalBitmapsSize += nativeSize;
        }
    }

    private final long $$robo$$android_graphics_Bitmap$getNativeInstance() {
        return this.mNativePtr;
    }

    private final void $$robo$$android_graphics_Bitmap$reinit(int width, int height, boolean requestPremultiplied) {
        this.mWidth = width;
        this.mHeight = height;
        this.mRequestPremultiplied = requestPremultiplied;
        this.mColorSpace = null;
    }

    private final int $$robo$$android_graphics_Bitmap$getDensity() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getDensity() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mDensity;
    }

    private final void $$robo$$android_graphics_Bitmap$setDensity(int density) {
        this.mDensity = density;
    }

    private final void $$robo$$android_graphics_Bitmap$reconfigure(int width, int height, Config config) {
        this.checkRecycled("Can't call reconfigure() on a recycled bitmap");
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        if (!this.isMutable()) {
            throw new IllegalStateException("only mutable bitmaps may be reconfigured");
        }
        Bitmap.nativeReconfigure(this.mNativePtr, width, height, config.nativeInt, this.mRequestPremultiplied);
        this.mWidth = width;
        this.mHeight = height;
        this.mColorSpace = null;
    }

    private final void $$robo$$android_graphics_Bitmap$setWidth(int width) {
        this.reconfigure(width, this.getHeight(), this.getConfig());
    }

    private final void $$robo$$android_graphics_Bitmap$setHeight(int height) {
        this.reconfigure(this.getWidth(), height, this.getConfig());
    }

    private final void $$robo$$android_graphics_Bitmap$setConfig(Config config) {
        this.reconfigure(this.getWidth(), this.getHeight(), config);
    }

    private final void $$robo$$android_graphics_Bitmap$setNinePatchChunk(byte[] chunk) {
        this.mNinePatchChunk = chunk;
    }

    private final void $$robo$$android_graphics_Bitmap$recycle() {
        if (!this.mRecycled && this.mNativePtr != 0L) {
            if (Bitmap.nativeRecycle(this.mNativePtr)) {
                this.mNinePatchChunk = null;
            }
            this.mRecycled = true;
        }
    }

    private final boolean $$robo$$android_graphics_Bitmap$isRecycled() {
        return this.mRecycled;
    }

    private final int $$robo$$android_graphics_Bitmap$getGenerationId() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getGenerationId() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeGenerationId(this.mNativePtr);
    }

    private final void $$robo$$android_graphics_Bitmap$checkRecycled(String errorMessage) {
        if (this.mRecycled) {
            throw new IllegalStateException(errorMessage);
        }
    }

    private final void $$robo$$android_graphics_Bitmap$checkHardware(String errorMessage) {
        if (this.getConfig() == Config.HARDWARE) {
            throw new IllegalStateException(errorMessage);
        }
    }

    private static final void $$robo$$android_graphics_Bitmap$checkXYSign(int x, int y) {
        if (x < 0) {
            throw new IllegalArgumentException("x must be >= 0");
        }
        if (y < 0) {
            throw new IllegalArgumentException("y must be >= 0");
        }
    }

    private static final void $$robo$$android_graphics_Bitmap$checkWidthHeight(int width, int height) {
        if (width <= 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("height must be > 0");
        }
    }

    private final void $$robo$$android_graphics_Bitmap$copyPixelsToBuffer(Buffer dst) {
        int shift;
        this.checkHardware("unable to copyPixelsToBuffer, pixel access is not supported on Config#HARDWARE bitmaps");
        int elements = dst.remaining();
        if (dst instanceof ByteBuffer) {
            shift = 0;
        } else if (dst instanceof ShortBuffer) {
            shift = 1;
        } else if (dst instanceof IntBuffer) {
            shift = 2;
        } else {
            throw new RuntimeException("unsupported Buffer subclass");
        }
        long bufferSize = (long)elements << shift;
        long pixelSize = this.getByteCount();
        if (bufferSize < pixelSize) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        Bitmap.nativeCopyPixelsToBuffer(this.mNativePtr, dst);
        int position = dst.position();
        position = (int)((long)position + (pixelSize >> shift));
        dst.position(position);
    }

    private final void $$robo$$android_graphics_Bitmap$copyPixelsFromBuffer(Buffer src) {
        int shift;
        this.checkRecycled("copyPixelsFromBuffer called on recycled bitmap");
        this.checkHardware("unable to copyPixelsFromBuffer, Config#HARDWARE bitmaps are immutable");
        int elements = src.remaining();
        if (src instanceof ByteBuffer) {
            shift = 0;
        } else if (src instanceof ShortBuffer) {
            shift = 1;
        } else if (src instanceof IntBuffer) {
            shift = 2;
        } else {
            throw new RuntimeException("unsupported Buffer subclass");
        }
        long bufferBytes = (long)elements << shift;
        long bitmapBytes = this.getByteCount();
        if (bufferBytes < bitmapBytes) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        Bitmap.nativeCopyPixelsFromBuffer(this.mNativePtr, src);
        int position = src.position();
        position = (int)((long)position + (bitmapBytes >> shift));
        src.position(position);
    }

    private final void $$robo$$android_graphics_Bitmap$noteHardwareBitmapSlowCall() {
        if (this.getConfig() == Config.HARDWARE) {
            StrictMode.noteSlowCall("Warning: attempt to read pixels from hardware bitmap, which is very slow operation");
        }
    }

    private final Bitmap $$robo$$android_graphics_Bitmap$copy(Config config, boolean isMutable) {
        this.checkRecycled("Can't copy a recycled bitmap");
        if (config == Config.HARDWARE && isMutable) {
            throw new IllegalArgumentException("Hardware bitmaps are always immutable");
        }
        this.noteHardwareBitmapSlowCall();
        Bitmap b = Bitmap.nativeCopy(this.mNativePtr, config.nativeInt, isMutable);
        if (b != null) {
            b.setPremultiplied(this.mRequestPremultiplied);
            b.mDensity = this.mDensity;
        }
        return b;
    }

    private final Bitmap $$robo$$android_graphics_Bitmap$createAshmemBitmap() {
        this.checkRecycled("Can't copy a recycled bitmap");
        this.noteHardwareBitmapSlowCall();
        Bitmap b = Bitmap.nativeCopyAshmem(this.mNativePtr);
        if (b != null) {
            b.setPremultiplied(this.mRequestPremultiplied);
            b.mDensity = this.mDensity;
        }
        return b;
    }

    private final Bitmap $$robo$$android_graphics_Bitmap$createAshmemBitmap(Config config) {
        this.checkRecycled("Can't copy a recycled bitmap");
        this.noteHardwareBitmapSlowCall();
        Bitmap b = Bitmap.nativeCopyAshmemConfig(this.mNativePtr, config.nativeInt);
        if (b != null) {
            b.setPremultiplied(this.mRequestPremultiplied);
            b.mDensity = this.mDensity;
        }
        return b;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createHardwareBitmap(GraphicBuffer graphicBuffer) {
        return Bitmap.nativeCreateHardwareBitmap(graphicBuffer);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createScaledBitmap(Bitmap src, int dstWidth, int dstHeight, boolean filter) {
        Matrix m = new Matrix();
        int width = src.getWidth();
        int height = src.getHeight();
        if (width != dstWidth || height != dstHeight) {
            float sx = (float)dstWidth / (float)width;
            float sy = (float)dstHeight / (float)height;
            m.setScale(sx, sy);
        }
        return Bitmap.createBitmap(src, 0, 0, width, height, m, filter);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(Bitmap src) {
        return Bitmap.createBitmap(src, 0, 0, src.getWidth(), src.getHeight());
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(Bitmap source, int x, int y, int width, int height) {
        return Bitmap.createBitmap(source, x, y, width, height, null, false);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(Bitmap source, int x, int y, int width, int height, Matrix m, boolean filter) {
        Paint paint;
        Bitmap bitmap;
        boolean isHardware;
        Bitmap.checkXYSign(x, y);
        Bitmap.checkWidthHeight(width, height);
        if (x + width > source.getWidth()) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        if (y + height > source.getHeight()) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        if (!source.isMutable() && x == 0 && y == 0 && width == source.getWidth() && height == source.getHeight() && (m == null || m.isIdentity())) {
            return source;
        }
        boolean bl = isHardware = source.getConfig() == Config.HARDWARE;
        if (isHardware) {
            source.noteHardwareBitmapSlowCall();
            source = Bitmap.nativeCopyPreserveInternalConfig(source.mNativePtr);
        }
        int neww = width;
        int newh = height;
        Rect srcR = new Rect(x, y, x + width, y + height);
        RectF dstR = new RectF(0.0f, 0.0f, width, height);
        RectF deviceR = new RectF();
        Config newConfig = Config.ARGB_8888;
        Config config = source.getConfig();
        if (config != null) {
            switch (2.$SwitchMap$android$graphics$Bitmap$Config[config.ordinal()]) {
                case 1: {
                    newConfig = Config.RGB_565;
                    break;
                }
                case 2: {
                    newConfig = Config.ALPHA_8;
                    break;
                }
                case 3: {
                    newConfig = Config.RGBA_F16;
                    break;
                }
                default: {
                    newConfig = Config.ARGB_8888;
                }
            }
        }
        if (m == null || m.isIdentity()) {
            bitmap = Bitmap.createBitmap(neww, newh, newConfig, source.hasAlpha());
            paint = null;
        } else {
            boolean transformed = !m.rectStaysRect();
            m.mapRect(deviceR, dstR);
            neww = Math.round(deviceR.width());
            newh = Math.round(deviceR.height());
            Config transformedConfig = newConfig;
            if (transformed && transformedConfig != Config.ARGB_8888 && transformedConfig != Config.RGBA_F16) {
                transformedConfig = Config.ARGB_8888;
            }
            bitmap = Bitmap.createBitmap(neww, newh, transformedConfig, transformed || source.hasAlpha());
            paint = new Paint();
            paint.setFilterBitmap(filter);
            if (transformed) {
                paint.setAntiAlias(true);
            }
        }
        Bitmap.nativeCopyColorSpace(source.mNativePtr, bitmap.mNativePtr);
        bitmap.mDensity = source.mDensity;
        bitmap.setHasAlpha(source.hasAlpha());
        bitmap.setPremultiplied(source.mRequestPremultiplied);
        Canvas canvas = new Canvas(bitmap);
        canvas.translate(-deviceR.left, -deviceR.top);
        canvas.concat(m);
        canvas.drawBitmap(source, srcR, dstR, paint);
        canvas.setBitmap(null);
        if (isHardware) {
            return bitmap.copy(Config.HARDWARE, false);
        }
        return bitmap;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(int width, int height, Config config) {
        return Bitmap.createBitmap(width, height, config, true);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(DisplayMetrics display, int width, int height, Config config) {
        return Bitmap.createBitmap(display, width, height, config, true);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(int width, int height, Config config, boolean hasAlpha) {
        return Bitmap.createBitmap(null, width, height, config, hasAlpha);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(int width, int height, Config config, boolean hasAlpha, ColorSpace colorSpace) {
        return Bitmap.createBitmap(null, width, height, config, hasAlpha, colorSpace);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(DisplayMetrics display, int width, int height, Config config, boolean hasAlpha) {
        return Bitmap.createBitmap(display, width, height, config, hasAlpha, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(DisplayMetrics display, int width, int height, Config config, boolean hasAlpha, ColorSpace colorSpace) {
        Bitmap bm;
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        if (config == Config.HARDWARE) {
            throw new IllegalArgumentException("can't create mutable bitmap with Config.HARDWARE");
        }
        if (colorSpace == null) {
            throw new IllegalArgumentException("can't create bitmap without a color space");
        }
        if (config != Config.ARGB_8888 || colorSpace == ColorSpace.get(ColorSpace.Named.SRGB)) {
            bm = Bitmap.nativeCreate(null, 0, width, width, height, config.nativeInt, true, null, null);
        } else {
            if (!(colorSpace instanceof ColorSpace.Rgb)) {
                throw new IllegalArgumentException("colorSpace must be an RGB color space");
            }
            ColorSpace.Rgb rgb = (ColorSpace.Rgb)colorSpace;
            ColorSpace.Rgb.TransferParameters parameters = rgb.getTransferParameters();
            if (parameters == null) {
                throw new IllegalArgumentException("colorSpace must use an ICC parametric transfer function");
            }
            ColorSpace.Rgb d50 = (ColorSpace.Rgb)ColorSpace.adapt(rgb, ColorSpace.ILLUMINANT_D50);
            bm = Bitmap.nativeCreate(null, 0, width, width, height, config.nativeInt, true, d50.getTransform(), parameters);
        }
        if (display != null) {
            bm.mDensity = display.densityDpi;
        }
        bm.setHasAlpha(hasAlpha);
        if (!(config != Config.ARGB_8888 && config != Config.RGBA_F16 || hasAlpha)) {
            Bitmap.nativeErase(bm.mNativePtr, -16777216);
        }
        return bm;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(int[] colors, int offset, int stride, int width, int height, Config config) {
        return Bitmap.createBitmap(null, colors, offset, stride, width, height, config);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(DisplayMetrics display, int[] colors, int offset, int stride, int width, int height, Config config) {
        Bitmap.checkWidthHeight(width, height);
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        Bitmap bm = Bitmap.nativeCreate(colors, offset, stride, width, height, config.nativeInt, false, null, null);
        if (display != null) {
            bm.mDensity = display.densityDpi;
        }
        return bm;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(int[] colors, int width, int height, Config config) {
        return Bitmap.createBitmap(null, colors, 0, width, width, height, config);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(DisplayMetrics display, int[] colors, int width, int height, Config config) {
        return Bitmap.createBitmap(display, colors, 0, width, width, height, config);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(Picture source) {
        return Bitmap.createBitmap(source, source.getWidth(), source.getHeight(), Config.HARDWARE);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(Picture source, int width, int height, Config config) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width & height must be > 0");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config must not be null");
        }
        source.endRecording();
        if (source.requiresHardwareAcceleration() && config != Config.HARDWARE) {
            StrictMode.noteSlowCall("GPU readback");
        }
        if (config == Config.HARDWARE || source.requiresHardwareAcceleration()) {
            RenderNode node = RenderNode.create("BitmapTemporary", null);
            node.setLeftTopRightBottom(0, 0, width, height);
            node.setClipToBounds(false);
            DisplayListCanvas canvas = node.start(width, height);
            if (source.getWidth() != width || source.getHeight() != height) {
                canvas.scale((float)width / (float)source.getWidth(), (float)height / (float)source.getHeight());
            }
            canvas.drawPicture(source);
            node.end(canvas);
            Bitmap bitmap = ThreadedRenderer.createHardwareBitmap(node, width, height);
            if (config != Config.HARDWARE) {
                bitmap = bitmap.copy(config, false);
            }
            return bitmap;
        }
        Bitmap bitmap = Bitmap.createBitmap(width, height, config);
        Canvas canvas = new Canvas(bitmap);
        if (source.getWidth() != width || source.getHeight() != height) {
            canvas.scale((float)width / (float)source.getWidth(), (float)height / (float)source.getHeight());
        }
        canvas.drawPicture(source);
        canvas.setBitmap(null);
        bitmap.makeImmutable();
        return bitmap;
    }

    private final byte[] $$robo$$android_graphics_Bitmap$getNinePatchChunk() {
        return this.mNinePatchChunk;
    }

    private final void $$robo$$android_graphics_Bitmap$getOpticalInsets(Rect outInsets) {
        if (this.mNinePatchInsets == null) {
            outInsets.setEmpty();
        } else {
            outInsets.set(this.mNinePatchInsets.opticalRect);
        }
    }

    private final NinePatch.InsetStruct $$robo$$android_graphics_Bitmap$getNinePatchInsets() {
        return this.mNinePatchInsets;
    }

    private final boolean $$robo$$android_graphics_Bitmap$compress(CompressFormat format, int quality, OutputStream stream) {
        this.checkRecycled("Can't compress a recycled bitmap");
        if (stream == null) {
            throw new NullPointerException();
        }
        if (quality < 0 || quality > 100) {
            throw new IllegalArgumentException("quality must be 0..100");
        }
        StrictMode.noteSlowCall("Compression of a bitmap is slow");
        Trace.traceBegin(8192L, "Bitmap.compress");
        boolean result = Bitmap.nativeCompress(this.mNativePtr, format.nativeInt, quality, stream, new byte[4096]);
        Trace.traceEnd(8192L);
        return result;
    }

    private final boolean $$robo$$android_graphics_Bitmap$isMutable() {
        return this.mIsMutable;
    }

    private final void $$robo$$android_graphics_Bitmap$makeImmutable() {
    }

    private final boolean $$robo$$android_graphics_Bitmap$isPremultiplied() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called isPremultiplied() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeIsPremultiplied(this.mNativePtr);
    }

    private final void $$robo$$android_graphics_Bitmap$setPremultiplied(boolean premultiplied) {
        this.checkRecycled("setPremultiplied called on a recycled bitmap");
        this.mRequestPremultiplied = premultiplied;
        Bitmap.nativeSetPremultiplied(this.mNativePtr, premultiplied);
    }

    private final int $$robo$$android_graphics_Bitmap$getWidth() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getWidth() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mWidth;
    }

    private final int $$robo$$android_graphics_Bitmap$getHeight() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getHeight() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mHeight;
    }

    private final int $$robo$$android_graphics_Bitmap$getScaledWidth(Canvas canvas) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, canvas.mDensity);
    }

    private final int $$robo$$android_graphics_Bitmap$getScaledHeight(Canvas canvas) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, canvas.mDensity);
    }

    private final int $$robo$$android_graphics_Bitmap$getScaledWidth(DisplayMetrics metrics) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, metrics.densityDpi);
    }

    private final int $$robo$$android_graphics_Bitmap$getScaledHeight(DisplayMetrics metrics) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, metrics.densityDpi);
    }

    private final int $$robo$$android_graphics_Bitmap$getScaledWidth(int targetDensity) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, targetDensity);
    }

    private final int $$robo$$android_graphics_Bitmap$getScaledHeight(int targetDensity) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, targetDensity);
    }

    private static final int $$robo$$android_graphics_Bitmap$scaleFromDensity(int size, int sdensity, int tdensity) {
        if (sdensity == 0 || tdensity == 0 || sdensity == tdensity) {
            return size;
        }
        return (size * tdensity + (sdensity >> 1)) / sdensity;
    }

    private final int $$robo$$android_graphics_Bitmap$getRowBytes() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getRowBytes() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeRowBytes(this.mNativePtr);
    }

    private final int $$robo$$android_graphics_Bitmap$getByteCount() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getByteCount() on a recycle()'d bitmap! This is undefined behavior!");
            return 0;
        }
        return this.getRowBytes() * this.getHeight();
    }

    private final int $$robo$$android_graphics_Bitmap$getAllocationByteCount() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getAllocationByteCount() on a recycle()'d bitmap! This is undefined behavior!");
            return 0;
        }
        return Bitmap.nativeGetAllocationByteCount(this.mNativePtr);
    }

    private final Config $$robo$$android_graphics_Bitmap$getConfig() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getConfig() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Config.nativeToConfig(Bitmap.nativeConfig(this.mNativePtr));
    }

    private final boolean $$robo$$android_graphics_Bitmap$hasAlpha() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called hasAlpha() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeHasAlpha(this.mNativePtr);
    }

    private final void $$robo$$android_graphics_Bitmap$setHasAlpha(boolean hasAlpha) {
        this.checkRecycled("setHasAlpha called on a recycled bitmap");
        Bitmap.nativeSetHasAlpha(this.mNativePtr, hasAlpha, this.mRequestPremultiplied);
    }

    private final boolean $$robo$$android_graphics_Bitmap$hasMipMap() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called hasMipMap() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeHasMipMap(this.mNativePtr);
    }

    private final void $$robo$$android_graphics_Bitmap$setHasMipMap(boolean hasMipMap) {
        this.checkRecycled("setHasMipMap called on a recycled bitmap");
        Bitmap.nativeSetHasMipMap(this.mNativePtr, hasMipMap);
    }

    private final ColorSpace $$robo$$android_graphics_Bitmap$getColorSpace() {
        if (this.getConfig() == Config.RGBA_F16) {
            this.mColorSpace = null;
            return ColorSpace.get(ColorSpace.Named.LINEAR_EXTENDED_SRGB);
        }
        if (this.mColorSpace == null) {
            if (Bitmap.nativeIsSRGB(this.mNativePtr)) {
                this.mColorSpace = ColorSpace.get(ColorSpace.Named.SRGB);
            } else if (this.getConfig() == Config.HARDWARE && Bitmap.nativeIsSRGBLinear(this.mNativePtr)) {
                this.mColorSpace = ColorSpace.get(ColorSpace.Named.LINEAR_EXTENDED_SRGB);
            } else {
                float[] xyz = new float[9];
                float[] params = new float[7];
                boolean hasColorSpace = Bitmap.nativeGetColorSpace(this.mNativePtr, xyz, params);
                if (hasColorSpace) {
                    ColorSpace.Rgb.TransferParameters parameters = new ColorSpace.Rgb.TransferParameters(params[0], params[1], params[2], params[3], params[4], params[5], params[6]);
                    ColorSpace cs = ColorSpace.match(xyz, parameters);
                    this.mColorSpace = cs != null ? cs : new ColorSpace.Rgb("Unknown", xyz, parameters);
                }
            }
        }
        return this.mColorSpace;
    }

    private final void $$robo$$android_graphics_Bitmap$eraseColor(int c) {
        this.checkRecycled("Can't erase a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException("cannot erase immutable bitmaps");
        }
        Bitmap.nativeErase(this.mNativePtr, c);
    }

    private final int $$robo$$android_graphics_Bitmap$getPixel(int x, int y) {
        this.checkRecycled("Can't call getPixel() on a recycled bitmap");
        this.checkHardware("unable to getPixel(), pixel access is not supported on Config#HARDWARE bitmaps");
        this.checkPixelAccess(x, y);
        return Bitmap.nativeGetPixel(this.mNativePtr, x, y);
    }

    private final void $$robo$$android_graphics_Bitmap$getPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.checkRecycled("Can't call getPixels() on a recycled bitmap");
        this.checkHardware("unable to getPixels(), pixel access is not supported on Config#HARDWARE bitmaps");
        if (width == 0 || height == 0) {
            return;
        }
        this.checkPixelsAccess(x, y, width, height, offset, stride, pixels);
        Bitmap.nativeGetPixels(this.mNativePtr, pixels, offset, stride, x, y, width, height);
    }

    private final void $$robo$$android_graphics_Bitmap$checkPixelAccess(int x, int y) {
        Bitmap.checkXYSign(x, y);
        if (x >= this.getWidth()) {
            throw new IllegalArgumentException("x must be < bitmap.width()");
        }
        if (y >= this.getHeight()) {
            throw new IllegalArgumentException("y must be < bitmap.height()");
        }
    }

    private final void $$robo$$android_graphics_Bitmap$checkPixelsAccess(int x, int y, int width, int height, int offset, int stride, int[] pixels) {
        Bitmap.checkXYSign(x, y);
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (x + width > this.getWidth()) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        if (y + height > this.getHeight()) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = pixels.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private final void $$robo$$android_graphics_Bitmap$setPixel(int x, int y, int color2) {
        this.checkRecycled("Can't call setPixel() on a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException();
        }
        this.checkPixelAccess(x, y);
        Bitmap.nativeSetPixel(this.mNativePtr, x, y, color2);
    }

    private final void $$robo$$android_graphics_Bitmap$setPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.checkRecycled("Can't call setPixels() on a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException();
        }
        if (width == 0 || height == 0) {
            return;
        }
        this.checkPixelsAccess(x, y, width, height, offset, stride, pixels);
        Bitmap.nativeSetPixels(this.mNativePtr, pixels, offset, stride, x, y, width, height);
    }

    private final int $$robo$$android_graphics_Bitmap$describeContents() {
        return 0;
    }

    private final void $$robo$$android_graphics_Bitmap$writeToParcel(Parcel p, int flags) {
        this.checkRecycled("Can't parcel a recycled bitmap");
        this.noteHardwareBitmapSlowCall();
        if (!Bitmap.nativeWriteToParcel(this.mNativePtr, this.mIsMutable, this.mDensity, p)) {
            throw new RuntimeException("native writeToParcel failed");
        }
    }

    private final Bitmap $$robo$$android_graphics_Bitmap$extractAlpha() {
        return this.extractAlpha(null, null);
    }

    private final Bitmap $$robo$$android_graphics_Bitmap$extractAlpha(Paint paint, int[] offsetXY) {
        this.checkRecycled("Can't extractAlpha on a recycled bitmap");
        long nativePaint = paint != null ? paint.getNativeInstance() : 0L;
        this.noteHardwareBitmapSlowCall();
        Bitmap bm = Bitmap.nativeExtractAlpha(this.mNativePtr, nativePaint, offsetXY);
        if (bm == null) {
            throw new RuntimeException("Failed to extractAlpha on Bitmap");
        }
        bm.mDensity = this.mDensity;
        return bm;
    }

    private final boolean $$robo$$android_graphics_Bitmap$sameAs(Bitmap other) {
        this.checkRecycled("Can't call sameAs on a recycled bitmap!");
        this.noteHardwareBitmapSlowCall();
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        other.noteHardwareBitmapSlowCall();
        if (other.isRecycled()) {
            throw new IllegalArgumentException("Can't compare to a recycled bitmap!");
        }
        return Bitmap.nativeSameAs(this.mNativePtr, other.mNativePtr);
    }

    private final void $$robo$$android_graphics_Bitmap$prepareToDraw() {
        this.checkRecycled("Can't prepareToDraw on a recycled bitmap!");
        Bitmap.nativePrepareToDraw(this.mNativePtr);
    }

    private final GraphicBuffer $$robo$$android_graphics_Bitmap$createGraphicBufferHandle() {
        return Bitmap.nativeCreateGraphicBufferHandle(this.mNativePtr);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeCreate(int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl, float[] fArray, ColorSpace.Rgb.TransferParameters transferParameters) {
        return null;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeCopy(long l, int n, boolean bl) {
        return null;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeCopyAshmem(long l) {
        return null;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeCopyAshmemConfig(long l, int n) {
        return null;
    }

    private static final long $$robo$$android_graphics_Bitmap$nativeGetNativeFinalizer() {
        return 0L;
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeRecycle(long l) {
        return false;
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeReconfigure(long l, int n, int n2, int n3, boolean bl) {
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeCompress(long l, int n, int n2, OutputStream outputStream, byte[] byArray) {
        return false;
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeErase(long l, int n) {
    }

    private static final int $$robo$$android_graphics_Bitmap$nativeRowBytes(long l) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Bitmap$nativeConfig(long l) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Bitmap$nativeGetPixel(long l, int n, int n2) {
        return 0;
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeGetPixels(long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeSetPixel(long l, int n, int n2, int n3) {
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeSetPixels(long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeCopyPixelsToBuffer(long l, Buffer buffer) {
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeCopyPixelsFromBuffer(long l, Buffer buffer) {
    }

    private static final int $$robo$$android_graphics_Bitmap$nativeGenerationId(long l) {
        return 0;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeCreateFromParcel(Parcel parcel) {
        return null;
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeWriteToParcel(long l, boolean bl, int n, Parcel parcel) {
        return false;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeExtractAlpha(long l, long l2, int[] nArray) {
        return null;
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeHasAlpha(long l) {
        return false;
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeIsPremultiplied(long l) {
        return false;
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeSetPremultiplied(long l, boolean bl) {
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeSetHasAlpha(long l, boolean bl, boolean bl2) {
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeHasMipMap(long l) {
        return false;
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeSetHasMipMap(long l, boolean bl) {
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeSameAs(long l, long l2) {
        return false;
    }

    private static final void $$robo$$android_graphics_Bitmap$nativePrepareToDraw(long l) {
    }

    private static final int $$robo$$android_graphics_Bitmap$nativeGetAllocationByteCount(long l) {
        return 0;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeCopyPreserveInternalConfig(long l) {
        return null;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeCreateHardwareBitmap(GraphicBuffer graphicBuffer) {
        return null;
    }

    private static final GraphicBuffer $$robo$$android_graphics_Bitmap$nativeCreateGraphicBufferHandle(long l) {
        return null;
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeGetColorSpace(long l, float[] fArray, float[] fArray2) {
        return false;
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeIsSRGB(long l) {
        return false;
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeIsSRGBLinear(long l) {
        return false;
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeCopyColorSpace(long l, long l2) {
    }

    static void __staticInitializer__() {
        sDefaultDensity = -1;
        CREATOR = new Parcelable.Creator<Bitmap>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_graphics_Bitmap_1$__constructor__() {
            }

            private final Bitmap $$robo$$android_graphics_Bitmap_1$createFromParcel(Parcel p) {
                Bitmap bm = Bitmap.nativeCreateFromParcel(p);
                if (bm == null) {
                    throw new RuntimeException("Failed to unparcel Bitmap");
                }
                return bm;
            }

            private final Bitmap[] $$robo$$android_graphics_Bitmap_1$newArray(int size) {
                return new Bitmap[size];
            }

            private void __constructor__() {
                this.$$robo$$android_graphics_Bitmap_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Bitmap_1$__constructor__(), 0, this);
            }

            @Override
            public Bitmap createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_graphics_Bitmap_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Bitmap[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_graphics_Bitmap_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static void setDefaultDensity(int n) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultDensity", $$robo$$android_graphics_Bitmap$setDefaultDensity(int ), 0, (int)n);
    }

    static int getDefaultDensity() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultDensity", $$robo$$android_graphics_Bitmap$getDefaultDensity(), 0);
    }

    private void __constructor__(long l, int n, int n2, int n3, boolean bl, boolean bl2, byte[] byArray, NinePatch.InsetStruct insetStruct) {
        this.$$robo$$android_graphics_Bitmap$__constructor__(l, n, n2, n3, bl, bl2, byArray, insetStruct);
    }

    Bitmap(long l, int n, int n2, int n3, boolean bl, boolean bl2, byte[] byArray, NinePatch.InsetStruct insetStruct) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Bitmap$__constructor__(long int int int boolean boolean byte[] android.graphics.NinePatch$InsetStruct ), 0, this, l, n, n2, n3, bl, bl2, byArray, insetStruct);
    }

    public long getNativeInstance() {
        return (long)InvokeDynamicSupport.bootstrap("getNativeInstance", $$robo$$android_graphics_Bitmap$getNativeInstance(), 0, this);
    }

    void reinit(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("reinit", $$robo$$android_graphics_Bitmap$reinit(int int boolean ), 0, this, n, n2, bl);
    }

    public int getDensity() {
        return (int)InvokeDynamicSupport.bootstrap("getDensity", $$robo$$android_graphics_Bitmap$getDensity(), 0, this);
    }

    public void setDensity(int n) {
        InvokeDynamicSupport.bootstrap("setDensity", $$robo$$android_graphics_Bitmap$setDensity(int ), 0, this, n);
    }

    public void reconfigure(int n, int n2, Config config) {
        InvokeDynamicSupport.bootstrap("reconfigure", $$robo$$android_graphics_Bitmap$reconfigure(int int android.graphics.Bitmap$Config ), 0, this, n, n2, config);
    }

    public void setWidth(int n) {
        InvokeDynamicSupport.bootstrap("setWidth", $$robo$$android_graphics_Bitmap$setWidth(int ), 0, this, n);
    }

    public void setHeight(int n) {
        InvokeDynamicSupport.bootstrap("setHeight", $$robo$$android_graphics_Bitmap$setHeight(int ), 0, this, n);
    }

    public void setConfig(Config config) {
        InvokeDynamicSupport.bootstrap("setConfig", $$robo$$android_graphics_Bitmap$setConfig(android.graphics.Bitmap$Config ), 0, this, config);
    }

    public void setNinePatchChunk(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("setNinePatchChunk", $$robo$$android_graphics_Bitmap$setNinePatchChunk(byte[] ), 0, this, byArray);
    }

    public void recycle() {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_graphics_Bitmap$recycle(), 0, this);
    }

    public boolean isRecycled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRecycled", $$robo$$android_graphics_Bitmap$isRecycled(), 0, this);
    }

    public int getGenerationId() {
        return (int)InvokeDynamicSupport.bootstrap("getGenerationId", $$robo$$android_graphics_Bitmap$getGenerationId(), 0, this);
    }

    private void checkRecycled(String string2) {
        InvokeDynamicSupport.bootstrap("checkRecycled", $$robo$$android_graphics_Bitmap$checkRecycled(java.lang.String ), 0, this, string2);
    }

    private void checkHardware(String string2) {
        InvokeDynamicSupport.bootstrap("checkHardware", $$robo$$android_graphics_Bitmap$checkHardware(java.lang.String ), 0, this, string2);
    }

    private static void checkXYSign(int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("checkXYSign", $$robo$$android_graphics_Bitmap$checkXYSign(int int ), 0, (int)n, (int)n2);
    }

    private static void checkWidthHeight(int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("checkWidthHeight", $$robo$$android_graphics_Bitmap$checkWidthHeight(int int ), 0, (int)n, (int)n2);
    }

    public void copyPixelsToBuffer(Buffer buffer) {
        InvokeDynamicSupport.bootstrap("copyPixelsToBuffer", $$robo$$android_graphics_Bitmap$copyPixelsToBuffer(java.nio.Buffer ), 0, this, buffer);
    }

    public void copyPixelsFromBuffer(Buffer buffer) {
        InvokeDynamicSupport.bootstrap("copyPixelsFromBuffer", $$robo$$android_graphics_Bitmap$copyPixelsFromBuffer(java.nio.Buffer ), 0, this, buffer);
    }

    private void noteHardwareBitmapSlowCall() {
        InvokeDynamicSupport.bootstrap("noteHardwareBitmapSlowCall", $$robo$$android_graphics_Bitmap$noteHardwareBitmapSlowCall(), 0, this);
    }

    public Bitmap copy(Config config, boolean bl) {
        return InvokeDynamicSupport.bootstrap("copy", $$robo$$android_graphics_Bitmap$copy(android.graphics.Bitmap$Config boolean ), 0, this, config, bl);
    }

    public Bitmap createAshmemBitmap() {
        return InvokeDynamicSupport.bootstrap("createAshmemBitmap", $$robo$$android_graphics_Bitmap$createAshmemBitmap(), 0, this);
    }

    public Bitmap createAshmemBitmap(Config config) {
        return InvokeDynamicSupport.bootstrap("createAshmemBitmap", $$robo$$android_graphics_Bitmap$createAshmemBitmap(android.graphics.Bitmap$Config ), 0, this, config);
    }

    public static Bitmap createHardwareBitmap(GraphicBuffer graphicBuffer) {
        return InvokeDynamicSupport.bootstrapStatic("createHardwareBitmap", $$robo$$android_graphics_Bitmap$createHardwareBitmap(android.graphics.GraphicBuffer ), 0, (GraphicBuffer)graphicBuffer);
    }

    public static Bitmap createScaledBitmap(Bitmap bitmap, int n, int n2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createScaledBitmap", $$robo$$android_graphics_Bitmap$createScaledBitmap(android.graphics.Bitmap int int boolean ), 0, (Bitmap)bitmap, (int)n, (int)n2, (boolean)bl);
    }

    public static Bitmap createBitmap(Bitmap bitmap) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.graphics.Bitmap ), 0, (Bitmap)bitmap);
    }

    public static Bitmap createBitmap(Bitmap bitmap, int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.graphics.Bitmap int int int int ), 0, (Bitmap)bitmap, (int)n, (int)n2, (int)n3, (int)n4);
    }

    public static Bitmap createBitmap(Bitmap bitmap, int n, int n2, int n3, int n4, Matrix matrix, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.graphics.Bitmap int int int int android.graphics.Matrix boolean ), 0, (Bitmap)bitmap, (int)n, (int)n2, (int)n3, (int)n4, (Matrix)matrix, (boolean)bl);
    }

    public static Bitmap createBitmap(int n, int n2, Config config) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(int int android.graphics.Bitmap$Config ), 0, (int)n, (int)n2, (Config)config);
    }

    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int n, int n2, Config config) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.util.DisplayMetrics int int android.graphics.Bitmap$Config ), 0, (DisplayMetrics)displayMetrics, (int)n, (int)n2, (Config)config);
    }

    public static Bitmap createBitmap(int n, int n2, Config config, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(int int android.graphics.Bitmap$Config boolean ), 0, (int)n, (int)n2, (Config)config, (boolean)bl);
    }

    public static Bitmap createBitmap(int n, int n2, Config config, boolean bl, ColorSpace colorSpace) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(int int android.graphics.Bitmap$Config boolean android.graphics.ColorSpace ), 0, (int)n, (int)n2, (Config)config, (boolean)bl, (ColorSpace)colorSpace);
    }

    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int n, int n2, Config config, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.util.DisplayMetrics int int android.graphics.Bitmap$Config boolean ), 0, (DisplayMetrics)displayMetrics, (int)n, (int)n2, (Config)config, (boolean)bl);
    }

    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int n, int n2, Config config, boolean bl, ColorSpace colorSpace) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.util.DisplayMetrics int int android.graphics.Bitmap$Config boolean android.graphics.ColorSpace ), 0, (DisplayMetrics)displayMetrics, (int)n, (int)n2, (Config)config, (boolean)bl, (ColorSpace)colorSpace);
    }

    public static Bitmap createBitmap(int[] nArray, int n, int n2, int n3, int n4, Config config) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(int[] int int int int android.graphics.Bitmap$Config ), 0, (int[])nArray, (int)n, (int)n2, (int)n3, (int)n4, (Config)config);
    }

    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int[] nArray, int n, int n2, int n3, int n4, Config config) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.util.DisplayMetrics int[] int int int int android.graphics.Bitmap$Config ), 0, (DisplayMetrics)displayMetrics, (int[])nArray, (int)n, (int)n2, (int)n3, (int)n4, (Config)config);
    }

    public static Bitmap createBitmap(int[] nArray, int n, int n2, Config config) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(int[] int int android.graphics.Bitmap$Config ), 0, (int[])nArray, (int)n, (int)n2, (Config)config);
    }

    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int[] nArray, int n, int n2, Config config) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.util.DisplayMetrics int[] int int android.graphics.Bitmap$Config ), 0, (DisplayMetrics)displayMetrics, (int[])nArray, (int)n, (int)n2, (Config)config);
    }

    public static Bitmap createBitmap(Picture picture) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.graphics.Picture ), 0, (Picture)picture);
    }

    public static Bitmap createBitmap(Picture picture, int n, int n2, Config config) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.graphics.Picture int int android.graphics.Bitmap$Config ), 0, (Picture)picture, (int)n, (int)n2, (Config)config);
    }

    public byte[] getNinePatchChunk() {
        return InvokeDynamicSupport.bootstrap("getNinePatchChunk", $$robo$$android_graphics_Bitmap$getNinePatchChunk(), 0, this);
    }

    public void getOpticalInsets(Rect rect) {
        InvokeDynamicSupport.bootstrap("getOpticalInsets", $$robo$$android_graphics_Bitmap$getOpticalInsets(android.graphics.Rect ), 0, this, rect);
    }

    public NinePatch.InsetStruct getNinePatchInsets() {
        return InvokeDynamicSupport.bootstrap("getNinePatchInsets", $$robo$$android_graphics_Bitmap$getNinePatchInsets(), 0, this);
    }

    public boolean compress(CompressFormat compressFormat, int n, OutputStream outputStream) {
        return (boolean)InvokeDynamicSupport.bootstrap("compress", $$robo$$android_graphics_Bitmap$compress(android.graphics.Bitmap$CompressFormat int java.io.OutputStream ), 0, this, compressFormat, n, outputStream);
    }

    public boolean isMutable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMutable", $$robo$$android_graphics_Bitmap$isMutable(), 0, this);
    }

    public void makeImmutable() {
        InvokeDynamicSupport.bootstrap("makeImmutable", $$robo$$android_graphics_Bitmap$makeImmutable(), 0, this);
    }

    public boolean isPremultiplied() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPremultiplied", $$robo$$android_graphics_Bitmap$isPremultiplied(), 0, this);
    }

    public void setPremultiplied(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPremultiplied", $$robo$$android_graphics_Bitmap$setPremultiplied(boolean ), 0, this, bl);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_graphics_Bitmap$getWidth(), 0, this);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_graphics_Bitmap$getHeight(), 0, this);
    }

    public int getScaledWidth(Canvas canvas) {
        return (int)InvokeDynamicSupport.bootstrap("getScaledWidth", $$robo$$android_graphics_Bitmap$getScaledWidth(android.graphics.Canvas ), 0, this, canvas);
    }

    public int getScaledHeight(Canvas canvas) {
        return (int)InvokeDynamicSupport.bootstrap("getScaledHeight", $$robo$$android_graphics_Bitmap$getScaledHeight(android.graphics.Canvas ), 0, this, canvas);
    }

    public int getScaledWidth(DisplayMetrics displayMetrics) {
        return (int)InvokeDynamicSupport.bootstrap("getScaledWidth", $$robo$$android_graphics_Bitmap$getScaledWidth(android.util.DisplayMetrics ), 0, this, displayMetrics);
    }

    public int getScaledHeight(DisplayMetrics displayMetrics) {
        return (int)InvokeDynamicSupport.bootstrap("getScaledHeight", $$robo$$android_graphics_Bitmap$getScaledHeight(android.util.DisplayMetrics ), 0, this, displayMetrics);
    }

    public int getScaledWidth(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getScaledWidth", $$robo$$android_graphics_Bitmap$getScaledWidth(int ), 0, this, n);
    }

    public int getScaledHeight(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getScaledHeight", $$robo$$android_graphics_Bitmap$getScaledHeight(int ), 0, this, n);
    }

    public static int scaleFromDensity(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("scaleFromDensity", $$robo$$android_graphics_Bitmap$scaleFromDensity(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public int getRowBytes() {
        return (int)InvokeDynamicSupport.bootstrap("getRowBytes", $$robo$$android_graphics_Bitmap$getRowBytes(), 0, this);
    }

    public int getByteCount() {
        return (int)InvokeDynamicSupport.bootstrap("getByteCount", $$robo$$android_graphics_Bitmap$getByteCount(), 0, this);
    }

    public int getAllocationByteCount() {
        return (int)InvokeDynamicSupport.bootstrap("getAllocationByteCount", $$robo$$android_graphics_Bitmap$getAllocationByteCount(), 0, this);
    }

    public Config getConfig() {
        return InvokeDynamicSupport.bootstrap("getConfig", $$robo$$android_graphics_Bitmap$getConfig(), 0, this);
    }

    public boolean hasAlpha() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAlpha", $$robo$$android_graphics_Bitmap$hasAlpha(), 0, this);
    }

    public void setHasAlpha(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHasAlpha", $$robo$$android_graphics_Bitmap$setHasAlpha(boolean ), 0, this, bl);
    }

    public boolean hasMipMap() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMipMap", $$robo$$android_graphics_Bitmap$hasMipMap(), 0, this);
    }

    public void setHasMipMap(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHasMipMap", $$robo$$android_graphics_Bitmap$setHasMipMap(boolean ), 0, this, bl);
    }

    public ColorSpace getColorSpace() {
        return InvokeDynamicSupport.bootstrap("getColorSpace", $$robo$$android_graphics_Bitmap$getColorSpace(), 0, this);
    }

    public void eraseColor(int n) {
        InvokeDynamicSupport.bootstrap("eraseColor", $$robo$$android_graphics_Bitmap$eraseColor(int ), 0, this, n);
    }

    public int getPixel(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getPixel", $$robo$$android_graphics_Bitmap$getPixel(int int ), 0, this, n, n2);
    }

    public void getPixels(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("getPixels", $$robo$$android_graphics_Bitmap$getPixels(int[] int int int int int int ), 0, this, nArray, n, n2, n3, n4, n5, n6);
    }

    private void checkPixelAccess(int n, int n2) {
        InvokeDynamicSupport.bootstrap("checkPixelAccess", $$robo$$android_graphics_Bitmap$checkPixelAccess(int int ), 0, this, n, n2);
    }

    private void checkPixelsAccess(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        InvokeDynamicSupport.bootstrap("checkPixelsAccess", $$robo$$android_graphics_Bitmap$checkPixelsAccess(int int int int int int int[] ), 0, this, n, n2, n3, n4, n5, n6, nArray);
    }

    public void setPixel(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setPixel", $$robo$$android_graphics_Bitmap$setPixel(int int int ), 0, this, n, n2, n3);
    }

    public void setPixels(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("setPixels", $$robo$$android_graphics_Bitmap$setPixels(int[] int int int int int int ), 0, this, nArray, n, n2, n3, n4, n5, n6);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_graphics_Bitmap$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_graphics_Bitmap$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public Bitmap extractAlpha() {
        return InvokeDynamicSupport.bootstrap("extractAlpha", $$robo$$android_graphics_Bitmap$extractAlpha(), 0, this);
    }

    public Bitmap extractAlpha(Paint paint, int[] nArray) {
        return InvokeDynamicSupport.bootstrap("extractAlpha", $$robo$$android_graphics_Bitmap$extractAlpha(android.graphics.Paint int[] ), 0, this, paint, nArray);
    }

    public boolean sameAs(Bitmap bitmap) {
        return (boolean)InvokeDynamicSupport.bootstrap("sameAs", $$robo$$android_graphics_Bitmap$sameAs(android.graphics.Bitmap ), 0, this, bitmap);
    }

    public void prepareToDraw() {
        InvokeDynamicSupport.bootstrap("prepareToDraw", $$robo$$android_graphics_Bitmap$prepareToDraw(), 0, this);
    }

    public GraphicBuffer createGraphicBufferHandle() {
        return InvokeDynamicSupport.bootstrap("createGraphicBufferHandle", $$robo$$android_graphics_Bitmap$createGraphicBufferHandle(), 0, this);
    }

    private static final native /* synthetic */ Bitmap $$robo$$nativeCreate$nativeBinding(int[] var0, int var1, int var2, int var3, int var4, int var5, boolean var6, float[] var7, ColorSpace.Rgb.TransferParameters var8);

    private static Bitmap nativeCreate(int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl, float[] fArray, ColorSpace.Rgb.TransferParameters transferParameters) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCreate", $$robo$$android_graphics_Bitmap$nativeCreate(int[] int int int int int boolean float[] android.graphics.ColorSpace$Rgb$TransferParameters ), 1, (int[])nArray, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (boolean)bl, (float[])fArray, (ColorSpace.Rgb.TransferParameters)transferParameters);
    }

    private static final native /* synthetic */ Bitmap $$robo$$nativeCopy$nativeBinding(long var0, int var2, boolean var3);

    private static Bitmap nativeCopy(long l, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCopy", $$robo$$android_graphics_Bitmap$nativeCopy(long int boolean ), 1, (long)l, (int)n, (boolean)bl);
    }

    private static final native /* synthetic */ Bitmap $$robo$$nativeCopyAshmem$nativeBinding(long var0);

    private static Bitmap nativeCopyAshmem(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCopyAshmem", $$robo$$android_graphics_Bitmap$nativeCopyAshmem(long ), 1, (long)l);
    }

    private static final native /* synthetic */ Bitmap $$robo$$nativeCopyAshmemConfig$nativeBinding(long var0, int var2);

    private static Bitmap nativeCopyAshmemConfig(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCopyAshmemConfig", $$robo$$android_graphics_Bitmap$nativeCopyAshmemConfig(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ long $$robo$$nativeGetNativeFinalizer$nativeBinding();

    private static long nativeGetNativeFinalizer() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeGetNativeFinalizer", $$robo$$android_graphics_Bitmap$nativeGetNativeFinalizer(), 1);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeRecycle$nativeBinding(long var0);

    private static boolean nativeRecycle(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeRecycle", $$robo$$android_graphics_Bitmap$nativeRecycle(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeReconfigure$nativeBinding(long var0, int var2, int var3, int var4, boolean var5);

    private static void nativeReconfigure(long l, int n, int n2, int n3, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nativeReconfigure", $$robo$$android_graphics_Bitmap$nativeReconfigure(long int int int boolean ), 1, (long)l, (int)n, (int)n2, (int)n3, (boolean)bl);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeCompress$nativeBinding(long var0, int var2, int var3, OutputStream var4, byte[] var5);

    private static boolean nativeCompress(long l, int n, int n2, OutputStream outputStream, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeCompress", $$robo$$android_graphics_Bitmap$nativeCompress(long int int java.io.OutputStream byte[] ), 1, (long)l, (int)n, (int)n2, (OutputStream)outputStream, (byte[])byArray);
    }

    private static final native /* synthetic */ void $$robo$$nativeErase$nativeBinding(long var0, int var2);

    private static void nativeErase(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeErase", $$robo$$android_graphics_Bitmap$nativeErase(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeRowBytes$nativeBinding(long var0);

    private static int nativeRowBytes(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeRowBytes", $$robo$$android_graphics_Bitmap$nativeRowBytes(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeConfig$nativeBinding(long var0);

    private static int nativeConfig(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeConfig", $$robo$$android_graphics_Bitmap$nativeConfig(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetPixel$nativeBinding(long var0, int var2, int var3);

    private static int nativeGetPixel(long l, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetPixel", $$robo$$android_graphics_Bitmap$nativeGetPixel(long int int ), 1, (long)l, (int)n, (int)n2);
    }

    private static final native /* synthetic */ void $$robo$$nativeGetPixels$nativeBinding(long var0, int[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

    private static void nativeGetPixels(long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrapStatic("nativeGetPixels", $$robo$$android_graphics_Bitmap$nativeGetPixels(long int[] int int int int int int ), 1, (long)l, (int[])nArray, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetPixel$nativeBinding(long var0, int var2, int var3, int var4);

    private static void nativeSetPixel(long l, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetPixel", $$robo$$android_graphics_Bitmap$nativeSetPixel(long int int int ), 1, (long)l, (int)n, (int)n2, (int)n3);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetPixels$nativeBinding(long var0, int[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

    private static void nativeSetPixels(long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetPixels", $$robo$$android_graphics_Bitmap$nativeSetPixels(long int[] int int int int int int ), 1, (long)l, (int[])nArray, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6);
    }

    private static final native /* synthetic */ void $$robo$$nativeCopyPixelsToBuffer$nativeBinding(long var0, Buffer var2);

    private static void nativeCopyPixelsToBuffer(long l, Buffer buffer) {
        InvokeDynamicSupport.bootstrapStatic("nativeCopyPixelsToBuffer", $$robo$$android_graphics_Bitmap$nativeCopyPixelsToBuffer(long java.nio.Buffer ), 1, (long)l, (Buffer)buffer);
    }

    private static final native /* synthetic */ void $$robo$$nativeCopyPixelsFromBuffer$nativeBinding(long var0, Buffer var2);

    private static void nativeCopyPixelsFromBuffer(long l, Buffer buffer) {
        InvokeDynamicSupport.bootstrapStatic("nativeCopyPixelsFromBuffer", $$robo$$android_graphics_Bitmap$nativeCopyPixelsFromBuffer(long java.nio.Buffer ), 1, (long)l, (Buffer)buffer);
    }

    private static final native /* synthetic */ int $$robo$$nativeGenerationId$nativeBinding(long var0);

    private static int nativeGenerationId(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGenerationId", $$robo$$android_graphics_Bitmap$nativeGenerationId(long ), 1, (long)l);
    }

    private static final native /* synthetic */ Bitmap $$robo$$nativeCreateFromParcel$nativeBinding(Parcel var0);

    private static Bitmap nativeCreateFromParcel(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCreateFromParcel", $$robo$$android_graphics_Bitmap$nativeCreateFromParcel(android.os.Parcel ), 1, (Parcel)parcel);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeWriteToParcel$nativeBinding(long var0, boolean var2, int var3, Parcel var4);

    private static boolean nativeWriteToParcel(long l, boolean bl, int n, Parcel parcel) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeWriteToParcel", $$robo$$android_graphics_Bitmap$nativeWriteToParcel(long boolean int android.os.Parcel ), 1, (long)l, (boolean)bl, (int)n, (Parcel)parcel);
    }

    private static final native /* synthetic */ Bitmap $$robo$$nativeExtractAlpha$nativeBinding(long var0, long var2, int[] var4);

    private static Bitmap nativeExtractAlpha(long l, long l2, int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("nativeExtractAlpha", $$robo$$android_graphics_Bitmap$nativeExtractAlpha(long long int[] ), 1, (long)l, (long)l2, (int[])nArray);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeHasAlpha$nativeBinding(long var0);

    private static boolean nativeHasAlpha(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeHasAlpha", $$robo$$android_graphics_Bitmap$nativeHasAlpha(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeIsPremultiplied$nativeBinding(long var0);

    private static boolean nativeIsPremultiplied(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeIsPremultiplied", $$robo$$android_graphics_Bitmap$nativeIsPremultiplied(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetPremultiplied$nativeBinding(long var0, boolean var2);

    private static void nativeSetPremultiplied(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetPremultiplied", $$robo$$android_graphics_Bitmap$nativeSetPremultiplied(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetHasAlpha$nativeBinding(long var0, boolean var2, boolean var3);

    private static void nativeSetHasAlpha(long l, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetHasAlpha", $$robo$$android_graphics_Bitmap$nativeSetHasAlpha(long boolean boolean ), 1, (long)l, (boolean)bl, (boolean)bl2);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeHasMipMap$nativeBinding(long var0);

    private static boolean nativeHasMipMap(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeHasMipMap", $$robo$$android_graphics_Bitmap$nativeHasMipMap(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetHasMipMap$nativeBinding(long var0, boolean var2);

    private static void nativeSetHasMipMap(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetHasMipMap", $$robo$$android_graphics_Bitmap$nativeSetHasMipMap(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeSameAs$nativeBinding(long var0, long var2);

    private static boolean nativeSameAs(long l, long l2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeSameAs", $$robo$$android_graphics_Bitmap$nativeSameAs(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nativePrepareToDraw$nativeBinding(long var0);

    private static void nativePrepareToDraw(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativePrepareToDraw", $$robo$$android_graphics_Bitmap$nativePrepareToDraw(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetAllocationByteCount$nativeBinding(long var0);

    private static int nativeGetAllocationByteCount(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetAllocationByteCount", $$robo$$android_graphics_Bitmap$nativeGetAllocationByteCount(long ), 1, (long)l);
    }

    private static final native /* synthetic */ Bitmap $$robo$$nativeCopyPreserveInternalConfig$nativeBinding(long var0);

    private static Bitmap nativeCopyPreserveInternalConfig(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCopyPreserveInternalConfig", $$robo$$android_graphics_Bitmap$nativeCopyPreserveInternalConfig(long ), 1, (long)l);
    }

    private static final native /* synthetic */ Bitmap $$robo$$nativeCreateHardwareBitmap$nativeBinding(GraphicBuffer var0);

    private static Bitmap nativeCreateHardwareBitmap(GraphicBuffer graphicBuffer) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCreateHardwareBitmap", $$robo$$android_graphics_Bitmap$nativeCreateHardwareBitmap(android.graphics.GraphicBuffer ), 1, (GraphicBuffer)graphicBuffer);
    }

    private static final native /* synthetic */ GraphicBuffer $$robo$$nativeCreateGraphicBufferHandle$nativeBinding(long var0);

    private static GraphicBuffer nativeCreateGraphicBufferHandle(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCreateGraphicBufferHandle", $$robo$$android_graphics_Bitmap$nativeCreateGraphicBufferHandle(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeGetColorSpace$nativeBinding(long var0, float[] var2, float[] var3);

    private static boolean nativeGetColorSpace(long l, float[] fArray, float[] fArray2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeGetColorSpace", $$robo$$android_graphics_Bitmap$nativeGetColorSpace(long float[] float[] ), 1, (long)l, (float[])fArray, (float[])fArray2);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeIsSRGB$nativeBinding(long var0);

    private static boolean nativeIsSRGB(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeIsSRGB", $$robo$$android_graphics_Bitmap$nativeIsSRGB(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeIsSRGBLinear$nativeBinding(long var0);

    private static boolean nativeIsSRGBLinear(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeIsSRGBLinear", $$robo$$android_graphics_Bitmap$nativeIsSRGBLinear(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeCopyColorSpace$nativeBinding(long var0, long var2);

    private static void nativeCopyColorSpace(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nativeCopyColorSpace", $$robo$$android_graphics_Bitmap$nativeCopyColorSpace(long long ), 1, (long)l, (long)l2);
    }

    static {
        RobolectricInternals.classInitializing(Bitmap.class);
    }

    public /* synthetic */ Bitmap() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Bitmap)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CompressFormat
    extends Enum<CompressFormat> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ CompressFormat JPEG;
        public static /* enum */ CompressFormat PNG;
        public static /* enum */ CompressFormat WEBP;
        int nativeInt;
        private static /* synthetic */ CompressFormat[] $VALUES;

        private static final CompressFormat[] $$robo$$android_graphics_Bitmap_CompressFormat$values() {
            return (CompressFormat[])$VALUES.clone();
        }

        private static final CompressFormat $$robo$$android_graphics_Bitmap_CompressFormat$valueOf(String name) {
            return Enum.valueOf(CompressFormat.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Bitmap_CompressFormat$__constructor__(String string2, int n, int nativeInt) {
            this.nativeInt = nativeInt;
        }

        static void __staticInitializer__() {
            JPEG = new CompressFormat(0);
            PNG = new CompressFormat(1);
            WEBP = new CompressFormat(2);
            $VALUES = new CompressFormat[]{JPEG, PNG, WEBP};
        }

        public static CompressFormat[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Bitmap_CompressFormat$values(), 0);
        }

        public static CompressFormat valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Bitmap_CompressFormat$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Bitmap_CompressFormat$__constructor__(string2, n, n2);
        }

        private CompressFormat(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Bitmap_CompressFormat$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(CompressFormat.class);
        }

        public /* synthetic */ CompressFormat() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompressFormat)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Config
    extends Enum<Config> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Config ALPHA_8;
        public static /* enum */ Config RGB_565;
        @Deprecated
        public static /* enum */ Config ARGB_4444;
        public static /* enum */ Config ARGB_8888;
        public static /* enum */ Config RGBA_F16;
        public static /* enum */ Config HARDWARE;
        int nativeInt;
        private static Config[] sConfigs;
        private static /* synthetic */ Config[] $VALUES;

        private static final Config[] $$robo$$android_graphics_Bitmap_Config$values() {
            return (Config[])$VALUES.clone();
        }

        private static final Config $$robo$$android_graphics_Bitmap_Config$valueOf(String name) {
            return Enum.valueOf(Config.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Bitmap_Config$__constructor__(String string2, int n, int ni) {
            this.nativeInt = ni;
        }

        private static final Config $$robo$$android_graphics_Bitmap_Config$nativeToConfig(int ni) {
            return sConfigs[ni];
        }

        static void __staticInitializer__() {
            ALPHA_8 = new Config(1);
            RGB_565 = new Config(3);
            ARGB_4444 = new Config(4);
            ARGB_8888 = new Config(5);
            RGBA_F16 = new Config(6);
            HARDWARE = new Config(7);
            $VALUES = new Config[]{ALPHA_8, RGB_565, ARGB_4444, ARGB_8888, RGBA_F16, HARDWARE};
            sConfigs = new Config[]{null, ALPHA_8, null, RGB_565, ARGB_4444, ARGB_8888, RGBA_F16, HARDWARE};
        }

        public static Config[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Bitmap_Config$values(), 0);
        }

        public static Config valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Bitmap_Config$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Bitmap_Config$__constructor__(string2, n, n2);
        }

        private Config(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Bitmap_Config$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static Config nativeToConfig(int n) {
            return InvokeDynamicSupport.bootstrapStatic("nativeToConfig", $$robo$$android_graphics_Bitmap_Config$nativeToConfig(int ), 0, (int)n);
        }

        static {
            RobolectricInternals.classInitializing(Config.class);
        }

        public /* synthetic */ Config() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Config)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

