/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.os.Trace;
import android.util.Log;
import android.util.TypedValue;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BitmapFactory
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int DECODE_BUFFER_SIZE = 16384;

    private void $$robo$$android_graphics_BitmapFactory$__constructor__() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Bitmap $$robo$$android_graphics_BitmapFactory$decodeFile(String pathName, Options opts) {
        Options.validate(opts);
        Bitmap bm = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(pathName);
            bm = BitmapFactory.decodeStream(stream, null, opts);
        }
        catch (Exception e) {
            Log.e("BitmapFactory", "Unable to decode stream: " + e);
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return bm;
    }

    private static final Bitmap $$robo$$android_graphics_BitmapFactory$decodeFile(String pathName) {
        return BitmapFactory.decodeFile(pathName, null);
    }

    private static final Bitmap $$robo$$android_graphics_BitmapFactory$decodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad, Options opts) {
        Options.validate(opts);
        if (opts == null) {
            opts = new Options();
        }
        if (opts.inDensity == 0 && value != null) {
            int density = value.density;
            if (density == 0) {
                opts.inDensity = 160;
            } else if (density != 65535) {
                opts.inDensity = density;
            }
        }
        if (opts.inTargetDensity == 0 && res != null) {
            opts.inTargetDensity = res.getDisplayMetrics().densityDpi;
        }
        return BitmapFactory.decodeStream(is, pad, opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Bitmap $$robo$$android_graphics_BitmapFactory$decodeResource(Resources res, int id2, Options opts) {
        Options.validate(opts);
        Bitmap bm = null;
        InputStream is = null;
        try {
            TypedValue value = new TypedValue();
            is = res.openRawResource(id2, value);
            bm = BitmapFactory.decodeResourceStream(res, value, is, null, opts);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (bm == null && opts != null && opts.inBitmap != null) {
            throw new IllegalArgumentException("Problem decoding into existing bitmap");
        }
        return bm;
    }

    private static final Bitmap $$robo$$android_graphics_BitmapFactory$decodeResource(Resources res, int id2) {
        return BitmapFactory.decodeResource(res, id2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Bitmap $$robo$$android_graphics_BitmapFactory$decodeByteArray(byte[] data, int offset, int length, Options opts) {
        Bitmap bm;
        if ((offset | length) < 0 || data.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Options.validate(opts);
        Trace.traceBegin(2L, "decodeBitmap");
        try {
            bm = BitmapFactory.nativeDecodeByteArray(data, offset, length, opts);
            if (bm == null && opts != null && opts.inBitmap != null) {
                throw new IllegalArgumentException("Problem decoding into existing bitmap");
            }
            BitmapFactory.setDensityFromOptions(bm, opts);
        }
        finally {
            Trace.traceEnd(2L);
        }
        return bm;
    }

    private static final Bitmap $$robo$$android_graphics_BitmapFactory$decodeByteArray(byte[] data, int offset, int length) {
        return BitmapFactory.decodeByteArray(data, offset, length, null);
    }

    private static final void $$robo$$android_graphics_BitmapFactory$setDensityFromOptions(Bitmap outputBitmap, Options opts) {
        if (outputBitmap == null || opts == null) {
            return;
        }
        int density = opts.inDensity;
        if (density != 0) {
            boolean isNinePatch;
            outputBitmap.setDensity(density);
            int targetDensity = opts.inTargetDensity;
            if (targetDensity == 0 || density == targetDensity || density == opts.inScreenDensity) {
                return;
            }
            byte[] np = outputBitmap.getNinePatchChunk();
            boolean bl = isNinePatch = np != null && NinePatch.isNinePatchChunk(np);
            if (opts.inScaled || isNinePatch) {
                outputBitmap.setDensity(targetDensity);
            }
        } else if (opts.inBitmap != null) {
            outputBitmap.setDensity(Bitmap.getDefaultDensity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Bitmap $$robo$$android_graphics_BitmapFactory$decodeStream(InputStream is, Rect outPadding, Options opts) {
        if (is == null) {
            return null;
        }
        Options.validate(opts);
        Bitmap bm = null;
        Trace.traceBegin(2L, "decodeBitmap");
        try {
            if (is instanceof AssetManager.AssetInputStream) {
                long asset = ((AssetManager.AssetInputStream)is).getNativeAsset();
                bm = BitmapFactory.nativeDecodeAsset(asset, outPadding, opts);
            } else {
                bm = BitmapFactory.decodeStreamInternal(is, outPadding, opts);
            }
            if (bm == null && opts != null && opts.inBitmap != null) {
                throw new IllegalArgumentException("Problem decoding into existing bitmap");
            }
            BitmapFactory.setDensityFromOptions(bm, opts);
        }
        finally {
            Trace.traceEnd(2L);
        }
        return bm;
    }

    private static final Bitmap $$robo$$android_graphics_BitmapFactory$decodeStreamInternal(InputStream is, Rect outPadding, Options opts) {
        byte[] tempStorage = null;
        if (opts != null) {
            tempStorage = opts.inTempStorage;
        }
        if (tempStorage == null) {
            tempStorage = new byte[16384];
        }
        return BitmapFactory.nativeDecodeStream(is, tempStorage, outPadding, opts);
    }

    private static final Bitmap $$robo$$android_graphics_BitmapFactory$decodeStream(InputStream is) {
        return BitmapFactory.decodeStream(is, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Bitmap $$robo$$android_graphics_BitmapFactory$decodeFileDescriptor(FileDescriptor fd, Rect outPadding, Options opts) {
        Bitmap bm;
        Options.validate(opts);
        Trace.traceBegin(2L, "decodeFileDescriptor");
        try {
            if (BitmapFactory.nativeIsSeekable(fd)) {
                bm = BitmapFactory.nativeDecodeFileDescriptor(fd, outPadding, opts);
            } else {
                FileInputStream fis = new FileInputStream(fd);
                try {
                    bm = BitmapFactory.decodeStreamInternal(fis, outPadding, opts);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (bm == null && opts != null && opts.inBitmap != null) {
                throw new IllegalArgumentException("Problem decoding into existing bitmap");
            }
            BitmapFactory.setDensityFromOptions(bm, opts);
        }
        finally {
            Trace.traceEnd(2L);
        }
        return bm;
    }

    private static final Bitmap $$robo$$android_graphics_BitmapFactory$decodeFileDescriptor(FileDescriptor fd) {
        return BitmapFactory.decodeFileDescriptor(fd, null, null);
    }

    private static final Bitmap $$robo$$android_graphics_BitmapFactory$nativeDecodeStream(InputStream inputStream, byte[] byArray, Rect rect, Options options) {
        return null;
    }

    private static final Bitmap $$robo$$android_graphics_BitmapFactory$nativeDecodeFileDescriptor(FileDescriptor fileDescriptor, Rect rect, Options options) {
        return null;
    }

    private static final Bitmap $$robo$$android_graphics_BitmapFactory$nativeDecodeAsset(long l, Rect rect, Options options) {
        return null;
    }

    private static final Bitmap $$robo$$android_graphics_BitmapFactory$nativeDecodeByteArray(byte[] byArray, int n, int n2, Options options) {
        return null;
    }

    private static final boolean $$robo$$android_graphics_BitmapFactory$nativeIsSeekable(FileDescriptor fileDescriptor) {
        return false;
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_BitmapFactory$__constructor__();
    }

    public BitmapFactory() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_BitmapFactory$__constructor__(), 0, this);
    }

    public static Bitmap decodeFile(String string2, Options options) {
        return InvokeDynamicSupport.bootstrapStatic("decodeFile", $$robo$$android_graphics_BitmapFactory$decodeFile(java.lang.String android.graphics.BitmapFactory$Options ), 0, (String)string2, (Options)options);
    }

    public static Bitmap decodeFile(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("decodeFile", $$robo$$android_graphics_BitmapFactory$decodeFile(java.lang.String ), 0, (String)string2);
    }

    public static Bitmap decodeResourceStream(Resources resources, TypedValue typedValue, InputStream inputStream, Rect rect, Options options) {
        return InvokeDynamicSupport.bootstrapStatic("decodeResourceStream", $$robo$$android_graphics_BitmapFactory$decodeResourceStream(android.content.res.Resources android.util.TypedValue java.io.InputStream android.graphics.Rect android.graphics.BitmapFactory$Options ), 0, (Resources)resources, (TypedValue)typedValue, (InputStream)inputStream, (Rect)rect, (Options)options);
    }

    public static Bitmap decodeResource(Resources resources, int n, Options options) {
        return InvokeDynamicSupport.bootstrapStatic("decodeResource", $$robo$$android_graphics_BitmapFactory$decodeResource(android.content.res.Resources int android.graphics.BitmapFactory$Options ), 0, (Resources)resources, (int)n, (Options)options);
    }

    public static Bitmap decodeResource(Resources resources, int n) {
        return InvokeDynamicSupport.bootstrapStatic("decodeResource", $$robo$$android_graphics_BitmapFactory$decodeResource(android.content.res.Resources int ), 0, (Resources)resources, (int)n);
    }

    public static Bitmap decodeByteArray(byte[] byArray, int n, int n2, Options options) {
        return InvokeDynamicSupport.bootstrapStatic("decodeByteArray", $$robo$$android_graphics_BitmapFactory$decodeByteArray(byte[] int int android.graphics.BitmapFactory$Options ), 0, (byte[])byArray, (int)n, (int)n2, (Options)options);
    }

    public static Bitmap decodeByteArray(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("decodeByteArray", $$robo$$android_graphics_BitmapFactory$decodeByteArray(byte[] int int ), 0, (byte[])byArray, (int)n, (int)n2);
    }

    private static void setDensityFromOptions(Bitmap bitmap, Options options) {
        InvokeDynamicSupport.bootstrapStatic("setDensityFromOptions", $$robo$$android_graphics_BitmapFactory$setDensityFromOptions(android.graphics.Bitmap android.graphics.BitmapFactory$Options ), 0, (Bitmap)bitmap, (Options)options);
    }

    public static Bitmap decodeStream(InputStream inputStream, Rect rect, Options options) {
        return InvokeDynamicSupport.bootstrapStatic("decodeStream", $$robo$$android_graphics_BitmapFactory$decodeStream(java.io.InputStream android.graphics.Rect android.graphics.BitmapFactory$Options ), 0, (InputStream)inputStream, (Rect)rect, (Options)options);
    }

    private static Bitmap decodeStreamInternal(InputStream inputStream, Rect rect, Options options) {
        return InvokeDynamicSupport.bootstrapStatic("decodeStreamInternal", $$robo$$android_graphics_BitmapFactory$decodeStreamInternal(java.io.InputStream android.graphics.Rect android.graphics.BitmapFactory$Options ), 0, (InputStream)inputStream, (Rect)rect, (Options)options);
    }

    public static Bitmap decodeStream(InputStream inputStream) {
        return InvokeDynamicSupport.bootstrapStatic("decodeStream", $$robo$$android_graphics_BitmapFactory$decodeStream(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fileDescriptor, Rect rect, Options options) {
        return InvokeDynamicSupport.bootstrapStatic("decodeFileDescriptor", $$robo$$android_graphics_BitmapFactory$decodeFileDescriptor(java.io.FileDescriptor android.graphics.Rect android.graphics.BitmapFactory$Options ), 0, (FileDescriptor)fileDescriptor, (Rect)rect, (Options)options);
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fileDescriptor) {
        return InvokeDynamicSupport.bootstrapStatic("decodeFileDescriptor", $$robo$$android_graphics_BitmapFactory$decodeFileDescriptor(java.io.FileDescriptor ), 0, (FileDescriptor)fileDescriptor);
    }

    private static final native /* synthetic */ Bitmap $$robo$$nativeDecodeStream$nativeBinding(InputStream var0, byte[] var1, Rect var2, Options var3);

    private static Bitmap nativeDecodeStream(InputStream inputStream, byte[] byArray, Rect rect, Options options) {
        return InvokeDynamicSupport.bootstrapStatic("nativeDecodeStream", $$robo$$android_graphics_BitmapFactory$nativeDecodeStream(java.io.InputStream byte[] android.graphics.Rect android.graphics.BitmapFactory$Options ), 1, (InputStream)inputStream, (byte[])byArray, (Rect)rect, (Options)options);
    }

    private static final native /* synthetic */ Bitmap $$robo$$nativeDecodeFileDescriptor$nativeBinding(FileDescriptor var0, Rect var1, Options var2);

    private static Bitmap nativeDecodeFileDescriptor(FileDescriptor fileDescriptor, Rect rect, Options options) {
        return InvokeDynamicSupport.bootstrapStatic("nativeDecodeFileDescriptor", $$robo$$android_graphics_BitmapFactory$nativeDecodeFileDescriptor(java.io.FileDescriptor android.graphics.Rect android.graphics.BitmapFactory$Options ), 1, (FileDescriptor)fileDescriptor, (Rect)rect, (Options)options);
    }

    private static final native /* synthetic */ Bitmap $$robo$$nativeDecodeAsset$nativeBinding(long var0, Rect var2, Options var3);

    private static Bitmap nativeDecodeAsset(long l, Rect rect, Options options) {
        return InvokeDynamicSupport.bootstrapStatic("nativeDecodeAsset", $$robo$$android_graphics_BitmapFactory$nativeDecodeAsset(long android.graphics.Rect android.graphics.BitmapFactory$Options ), 1, (long)l, (Rect)rect, (Options)options);
    }

    private static final native /* synthetic */ Bitmap $$robo$$nativeDecodeByteArray$nativeBinding(byte[] var0, int var1, int var2, Options var3);

    private static Bitmap nativeDecodeByteArray(byte[] byArray, int n, int n2, Options options) {
        return InvokeDynamicSupport.bootstrapStatic("nativeDecodeByteArray", $$robo$$android_graphics_BitmapFactory$nativeDecodeByteArray(byte[] int int android.graphics.BitmapFactory$Options ), 1, (byte[])byArray, (int)n, (int)n2, (Options)options);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeIsSeekable$nativeBinding(FileDescriptor var0);

    private static boolean nativeIsSeekable(FileDescriptor fileDescriptor) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeIsSeekable", $$robo$$android_graphics_BitmapFactory$nativeIsSeekable(java.io.FileDescriptor ), 1, (FileDescriptor)fileDescriptor);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BitmapFactory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Options
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Bitmap inBitmap;
        public boolean inMutable;
        public boolean inJustDecodeBounds;
        public int inSampleSize;
        public Bitmap.Config inPreferredConfig;
        public ColorSpace inPreferredColorSpace;
        public boolean inPremultiplied;
        public boolean inDither;
        public int inDensity;
        public int inTargetDensity;
        public int inScreenDensity;
        public boolean inScaled;
        @Deprecated
        public boolean inPurgeable;
        @Deprecated
        public boolean inInputShareable;
        @Deprecated
        public boolean inPreferQualityOverSpeed;
        public int outWidth;
        public int outHeight;
        public String outMimeType;
        public Bitmap.Config outConfig;
        public ColorSpace outColorSpace;
        public byte[] inTempStorage;
        @Deprecated
        public boolean mCancel;

        private void $$robo$$android_graphics_BitmapFactory_Options$__constructor__() {
            this.inPreferredConfig = Bitmap.Config.ARGB_8888;
            this.inPreferredColorSpace = null;
            this.inScaled = true;
            this.inPremultiplied = true;
        }

        @Deprecated
        private final void $$robo$$android_graphics_BitmapFactory_Options$requestCancelDecode() {
            this.mCancel = true;
        }

        private static final void $$robo$$android_graphics_BitmapFactory_Options$validate(Options opts) {
            if (opts == null) {
                return;
            }
            if (opts.inBitmap != null && opts.inBitmap.getConfig() == Bitmap.Config.HARDWARE) {
                throw new IllegalArgumentException("Bitmaps with Config.HARWARE are always immutable");
            }
            if (opts.inMutable && opts.inPreferredConfig == Bitmap.Config.HARDWARE) {
                throw new IllegalArgumentException("Bitmaps with Config.HARDWARE cannot be decoded into - they are immutable");
            }
            if (opts.inPreferredColorSpace != null) {
                if (!(opts.inPreferredColorSpace instanceof ColorSpace.Rgb)) {
                    throw new IllegalArgumentException("The destination color space must use the RGB color model");
                }
                if (((ColorSpace.Rgb)opts.inPreferredColorSpace).getTransferParameters() == null) {
                    throw new IllegalArgumentException("The destination color space must use an ICC parametric transfer function");
                }
            }
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_BitmapFactory_Options$__constructor__();
        }

        public Options() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_BitmapFactory_Options$__constructor__(), 0, this);
        }

        @Deprecated
        public void requestCancelDecode() {
            InvokeDynamicSupport.bootstrap("requestCancelDecode", $$robo$$android_graphics_BitmapFactory_Options$requestCancelDecode(), 0, this);
        }

        static void validate(Options options) {
            InvokeDynamicSupport.bootstrapStatic("validate", $$robo$$android_graphics_BitmapFactory_Options$validate(android.graphics.BitmapFactory$Options ), 0, (Options)options);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Options)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

