/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.fonts.FontVariationAxis;
import android.text.FontConfig;
import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FontListParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Pattern FILENAME_WHITESPACE_PATTERN;

    private void $$robo$$android_graphics_FontListParser$__constructor__() {
    }

    private static final FontConfig $$robo$$android_graphics_FontListParser$parse(InputStream in) throws XmlPullParserException, IOException {
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(in, null);
            parser.nextTag();
            FontConfig fontConfig = FontListParser.readFamilies(parser);
            return fontConfig;
        }
        finally {
            in.close();
        }
    }

    private static final FontConfig $$robo$$android_graphics_FontListParser$readFamilies(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<FontConfig.Family> families = new ArrayList<FontConfig.Family>();
        ArrayList<FontConfig.Alias> aliases = new ArrayList<FontConfig.Alias>();
        parser.require(2, null, "familyset");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("family")) {
                families.add(FontListParser.readFamily(parser));
                continue;
            }
            if (tag.equals("alias")) {
                aliases.add(FontListParser.readAlias(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        return new FontConfig(families.toArray(new FontConfig.Family[families.size()]), aliases.toArray(new FontConfig.Alias[aliases.size()]));
    }

    private static final FontConfig.Family $$robo$$android_graphics_FontListParser$readFamily(XmlPullParser parser) throws XmlPullParserException, IOException {
        String name = parser.getAttributeValue(null, "name");
        String lang = parser.getAttributeValue(null, "lang");
        String[] langs = lang == null ? null : lang.split("\\s+");
        String variant = parser.getAttributeValue(null, "variant");
        ArrayList<FontConfig.Font> fonts = new ArrayList<FontConfig.Font>();
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("font")) {
                fonts.add(FontListParser.readFont(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        int intVariant = 0;
        if (variant != null) {
            if (variant.equals("compact")) {
                intVariant = 1;
            } else if (variant.equals("elegant")) {
                intVariant = 2;
            }
        }
        return new FontConfig.Family(name, fonts.toArray(new FontConfig.Font[fonts.size()]), langs, intVariant);
    }

    private static final FontConfig.Font $$robo$$android_graphics_FontListParser$readFont(XmlPullParser parser) throws XmlPullParserException, IOException {
        String indexStr = parser.getAttributeValue(null, "index");
        int index = indexStr == null ? 0 : Integer.parseInt(indexStr);
        ArrayList<FontVariationAxis> axes = new ArrayList<FontVariationAxis>();
        String weightStr = parser.getAttributeValue(null, "weight");
        int weight = weightStr == null ? 400 : Integer.parseInt(weightStr);
        boolean isItalic = "italic".equals(parser.getAttributeValue(null, "style"));
        String fallbackFor = parser.getAttributeValue(null, "fallbackFor");
        StringBuilder filename = new StringBuilder();
        while (parser.next() != 3) {
            if (parser.getEventType() == 4) {
                filename.append(parser.getText());
            }
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("axis")) {
                axes.add(FontListParser.readAxis(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        String sanitizedName = FILENAME_WHITESPACE_PATTERN.matcher(filename).replaceAll("");
        return new FontConfig.Font(sanitizedName, index, axes.toArray(new FontVariationAxis[axes.size()]), weight, isItalic, fallbackFor);
    }

    private static final FontVariationAxis $$robo$$android_graphics_FontListParser$readAxis(XmlPullParser parser) throws XmlPullParserException, IOException {
        String tagStr = parser.getAttributeValue(null, "tag");
        String styleValueStr = parser.getAttributeValue(null, "stylevalue");
        FontListParser.skip(parser);
        return new FontVariationAxis(tagStr, Float.parseFloat(styleValueStr));
    }

    private static final FontConfig.Alias $$robo$$android_graphics_FontListParser$readAlias(XmlPullParser parser) throws XmlPullParserException, IOException {
        String name = parser.getAttributeValue(null, "name");
        String toName = parser.getAttributeValue(null, "to");
        String weightStr = parser.getAttributeValue(null, "weight");
        int weight = weightStr == null ? 400 : Integer.parseInt(weightStr);
        FontListParser.skip(parser);
        return new FontConfig.Alias(name, toName, weight);
    }

    private static final void $$robo$$android_graphics_FontListParser$skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        int depth = 1;
        while (depth > 0) {
            switch (parser.next()) {
                case 2: {
                    ++depth;
                    break;
                }
                case 3: {
                    --depth;
                }
            }
        }
    }

    static void __staticInitializer__() {
        FILENAME_WHITESPACE_PATTERN = Pattern.compile("^[ \\n\\r\\t]+|[ \\n\\r\\t]+$");
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_FontListParser$__constructor__();
    }

    public FontListParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_FontListParser$__constructor__(), 0, this);
    }

    public static FontConfig parse(InputStream inputStream) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$android_graphics_FontListParser$parse(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    private static FontConfig readFamilies(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFamilies", $$robo$$android_graphics_FontListParser$readFamilies(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    private static FontConfig.Family readFamily(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFamily", $$robo$$android_graphics_FontListParser$readFamily(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    private static FontConfig.Font readFont(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFont", $$robo$$android_graphics_FontListParser$readFont(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    private static FontVariationAxis readAxis(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readAxis", $$robo$$android_graphics_FontListParser$readAxis(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    private static FontConfig.Alias readAlias(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readAlias", $$robo$$android_graphics_FontListParser$readAlias(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    private static void skip(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("skip", $$robo$$android_graphics_FontListParser$skip(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    static {
        RobolectricInternals.classInitializing(FontListParser.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontListParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

