/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorSpace;
import android.graphics.NinePatch;
import android.graphics.PostProcessor;
import android.graphics.Rect;
import android.graphics.drawable.AnimatedImageDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.net.Uri;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Size;
import android.util.TypedValue;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ImageDecoder
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int sApiLevel;
    @Deprecated
    public static int ERROR_SOURCE_EXCEPTION = 1;
    @Deprecated
    public static int ERROR_SOURCE_INCOMPLETE = 2;
    @Deprecated
    public static int ERROR_SOURCE_ERROR = 3;
    private long mNativePtr;
    private int mWidth;
    private int mHeight;
    private boolean mAnimated;
    private boolean mIsNinePatch;
    private int mDesiredWidth;
    private int mDesiredHeight;
    private int mAllocator;
    private boolean mUnpremultipliedRequired;
    private boolean mMutable;
    private boolean mConserveMemory;
    private boolean mDecodeAsAlphaMask;
    private ColorSpace mDesiredColorSpace;
    private Rect mCropRect;
    private Rect mOutPaddingRect;
    private Source mSource;
    private PostProcessor mPostProcessor;
    private OnPartialImageListener mOnPartialImageListener;
    private InputStream mInputStream;
    private boolean mOwnsInputStream;
    private byte[] mTempStorage;
    private AssetFileDescriptor mAssetFd;
    private AtomicBoolean mClosed;
    private CloseGuard mCloseGuard;
    public static int ALLOCATOR_DEFAULT = 0;
    public static int ALLOCATOR_SOFTWARE = 1;
    public static int ALLOCATOR_SHARED_MEMORY = 2;
    public static int ALLOCATOR_HARDWARE = 3;
    public static int MEMORY_POLICY_LOW_RAM = 0;
    public static int MEMORY_POLICY_DEFAULT = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ImageDecoder $$robo$$android_graphics_ImageDecoder$createFromFile(File file, Source source) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        FileDescriptor fd = stream.getFD();
        try {
            Os.lseek(fd, 0L, OsConstants.SEEK_CUR);
        }
        catch (ErrnoException e) {
            return ImageDecoder.createFromStream(stream, true, source);
        }
        ImageDecoder decoder = null;
        try {
            decoder = ImageDecoder.nCreate(fd, source);
        }
        finally {
            if (decoder == null) {
                IoUtils.closeQuietly(stream);
            } else {
                decoder.mInputStream = stream;
                decoder.mOwnsInputStream = true;
            }
        }
        return decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ImageDecoder $$robo$$android_graphics_ImageDecoder$createFromStream(InputStream is, boolean closeInputStream, Source source) throws IOException {
        byte[] storage = new byte[16384];
        ImageDecoder decoder = null;
        try {
            decoder = ImageDecoder.nCreate(is, storage, source);
        }
        finally {
            if (decoder == null) {
                if (closeInputStream) {
                    IoUtils.closeQuietly(is);
                }
            } else {
                decoder.mInputStream = is;
                decoder.mOwnsInputStream = closeInputStream;
                decoder.mTempStorage = storage;
            }
        }
        return decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ImageDecoder $$robo$$android_graphics_ImageDecoder$createFromAsset(AssetManager.AssetInputStream ais, Source source) throws IOException {
        ImageDecoder decoder = null;
        try {
            long asset = ais.getNativeAsset();
            decoder = ImageDecoder.nCreate(asset, source);
        }
        finally {
            if (decoder == null) {
                IoUtils.closeQuietly(ais);
            } else {
                decoder.mInputStream = ais;
                decoder.mOwnsInputStream = true;
            }
        }
        return decoder;
    }

    private void $$robo$$android_graphics_ImageDecoder$__constructor__(long nativePtr, int width, int height, boolean animated, boolean isNinePatch) {
        this.mAllocator = 0;
        this.mUnpremultipliedRequired = false;
        this.mMutable = false;
        this.mConserveMemory = false;
        this.mDecodeAsAlphaMask = false;
        this.mDesiredColorSpace = null;
        this.mClosed = new AtomicBoolean();
        this.mCloseGuard = CloseGuard.get();
        this.mNativePtr = nativePtr;
        this.mWidth = width;
        this.mHeight = height;
        this.mDesiredWidth = width;
        this.mDesiredHeight = height;
        this.mAnimated = animated;
        this.mIsNinePatch = isNinePatch;
        this.mCloseGuard.open("close");
    }

    private final void $$robo$$android_graphics_ImageDecoder$finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mInputStream = null;
            this.mAssetFd = null;
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private static final Source $$robo$$android_graphics_ImageDecoder$createSource(Resources res, int resId) {
        return new ResourceSource(res, resId);
    }

    private static final Source $$robo$$android_graphics_ImageDecoder$createSource(ContentResolver cr, Uri uri) {
        return new ContentResolverSource(cr, uri, null);
    }

    private static final Source $$robo$$android_graphics_ImageDecoder$createSource(ContentResolver cr, Uri uri, Resources res) {
        return new ContentResolverSource(cr, uri, res);
    }

    private static final Source $$robo$$android_graphics_ImageDecoder$createSource(AssetManager assets, String fileName) {
        return new AssetSource(assets, fileName);
    }

    private static final Source $$robo$$android_graphics_ImageDecoder$createSource(byte[] data, int offset, int length) throws ArrayIndexOutOfBoundsException {
        if (data == null) {
            throw new NullPointerException("null byte[] in createSource!");
        }
        if (offset < 0 || length < 0 || offset >= data.length || offset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException("invalid offset/length!");
        }
        return new ByteArraySource(data, offset, length);
    }

    private static final Source $$robo$$android_graphics_ImageDecoder$createSource(byte[] data) {
        return ImageDecoder.createSource(data, 0, data.length);
    }

    private static final Source $$robo$$android_graphics_ImageDecoder$createSource(ByteBuffer buffer) {
        return new ByteBufferSource(buffer);
    }

    private static final Source $$robo$$android_graphics_ImageDecoder$createSource(Resources res, InputStream is) {
        return new InputStreamSource(res, is, Bitmap.getDefaultDensity());
    }

    private static final Source $$robo$$android_graphics_ImageDecoder$createSource(Resources res, InputStream is, int density) {
        return new InputStreamSource(res, is, density);
    }

    private static final Source $$robo$$android_graphics_ImageDecoder$createSource(File file) {
        return new FileSource(file);
    }

    private final Size $$robo$$android_graphics_ImageDecoder$getSampledSize(int sampleSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("sampleSize must be positive! provided " + sampleSize);
        }
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("ImageDecoder is closed!");
        }
        return ImageDecoder.nGetSampledSize(this.mNativePtr, sampleSize);
    }

    @Deprecated
    private final ImageDecoder $$robo$$android_graphics_ImageDecoder$setResize(int width, int height) {
        this.setTargetSize(width, height);
        return this;
    }

    private final void $$robo$$android_graphics_ImageDecoder$setTargetSize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Dimensions must be positive! provided (" + width + ", " + height + ")");
        }
        this.mDesiredWidth = width;
        this.mDesiredHeight = height;
    }

    @Deprecated
    private final ImageDecoder $$robo$$android_graphics_ImageDecoder$setResize(int sampleSize) {
        this.setTargetSampleSize(sampleSize);
        return this;
    }

    private final int $$robo$$android_graphics_ImageDecoder$getTargetDimension(int original, int sampleSize, int computed) {
        if (sampleSize >= original) {
            return 1;
        }
        int target = original / sampleSize;
        if (computed == target) {
            return computed;
        }
        int reverse = computed * sampleSize;
        if (Math.abs(reverse - original) < sampleSize) {
            return computed;
        }
        return target;
    }

    private final void $$robo$$android_graphics_ImageDecoder$setTargetSampleSize(int sampleSize) {
        Size size = this.getSampledSize(sampleSize);
        int targetWidth = this.getTargetDimension(this.mWidth, sampleSize, size.getWidth());
        int targetHeight = this.getTargetDimension(this.mHeight, sampleSize, size.getHeight());
        this.setTargetSize(targetWidth, targetHeight);
    }

    private final boolean $$robo$$android_graphics_ImageDecoder$requestedResize() {
        return this.mWidth != this.mDesiredWidth || this.mHeight != this.mDesiredHeight;
    }

    private final void $$robo$$android_graphics_ImageDecoder$setAllocator(int allocator) {
        if (allocator < 0 || allocator > 3) {
            throw new IllegalArgumentException("invalid allocator " + allocator);
        }
        this.mAllocator = allocator;
    }

    private final int $$robo$$android_graphics_ImageDecoder$getAllocator() {
        return this.mAllocator;
    }

    private final void $$robo$$android_graphics_ImageDecoder$setUnpremultipliedRequired(boolean unpremultipliedRequired) {
        this.mUnpremultipliedRequired = unpremultipliedRequired;
    }

    @Deprecated
    private final ImageDecoder $$robo$$android_graphics_ImageDecoder$setRequireUnpremultiplied(boolean unpremultipliedRequired) {
        this.setUnpremultipliedRequired(unpremultipliedRequired);
        return this;
    }

    private final boolean $$robo$$android_graphics_ImageDecoder$isUnpremultipliedRequired() {
        return this.mUnpremultipliedRequired;
    }

    @Deprecated
    private final boolean $$robo$$android_graphics_ImageDecoder$getRequireUnpremultiplied() {
        return this.isUnpremultipliedRequired();
    }

    private final void $$robo$$android_graphics_ImageDecoder$setPostProcessor(PostProcessor postProcessor) {
        this.mPostProcessor = postProcessor;
    }

    private final PostProcessor $$robo$$android_graphics_ImageDecoder$getPostProcessor() {
        return this.mPostProcessor;
    }

    private final void $$robo$$android_graphics_ImageDecoder$setOnPartialImageListener(OnPartialImageListener listener) {
        this.mOnPartialImageListener = listener;
    }

    private final OnPartialImageListener $$robo$$android_graphics_ImageDecoder$getOnPartialImageListener() {
        return this.mOnPartialImageListener;
    }

    private final void $$robo$$android_graphics_ImageDecoder$setCrop(Rect subset) {
        this.mCropRect = subset;
    }

    private final Rect $$robo$$android_graphics_ImageDecoder$getCrop() {
        return this.mCropRect;
    }

    private final void $$robo$$android_graphics_ImageDecoder$setOutPaddingRect(Rect outPadding) {
        this.mOutPaddingRect = outPadding;
    }

    private final void $$robo$$android_graphics_ImageDecoder$setMutableRequired(boolean mutable) {
        this.mMutable = mutable;
    }

    @Deprecated
    private final ImageDecoder $$robo$$android_graphics_ImageDecoder$setMutable(boolean mutable) {
        this.setMutableRequired(mutable);
        return this;
    }

    private final boolean $$robo$$android_graphics_ImageDecoder$isMutableRequired() {
        return this.mMutable;
    }

    @Deprecated
    private final boolean $$robo$$android_graphics_ImageDecoder$getMutable() {
        return this.isMutableRequired();
    }

    private final void $$robo$$android_graphics_ImageDecoder$setMemorySizePolicy(int policy) {
        this.mConserveMemory = policy == 0;
    }

    private final int $$robo$$android_graphics_ImageDecoder$getMemorySizePolicy() {
        return this.mConserveMemory ? 0 : 1;
    }

    @Deprecated
    private final void $$robo$$android_graphics_ImageDecoder$setConserveMemory(boolean conserveMemory) {
        this.mConserveMemory = conserveMemory;
    }

    @Deprecated
    private final boolean $$robo$$android_graphics_ImageDecoder$getConserveMemory() {
        return this.mConserveMemory;
    }

    private final void $$robo$$android_graphics_ImageDecoder$setDecodeAsAlphaMaskEnabled(boolean enabled) {
        this.mDecodeAsAlphaMask = enabled;
    }

    @Deprecated
    private final ImageDecoder $$robo$$android_graphics_ImageDecoder$setDecodeAsAlphaMask(boolean enabled) {
        this.setDecodeAsAlphaMaskEnabled(enabled);
        return this;
    }

    @Deprecated
    private final ImageDecoder $$robo$$android_graphics_ImageDecoder$setAsAlphaMask(boolean asAlphaMask) {
        this.setDecodeAsAlphaMask(asAlphaMask);
        return this;
    }

    private final boolean $$robo$$android_graphics_ImageDecoder$isDecodeAsAlphaMaskEnabled() {
        return this.mDecodeAsAlphaMask;
    }

    @Deprecated
    private final boolean $$robo$$android_graphics_ImageDecoder$getDecodeAsAlphaMask() {
        return this.mDecodeAsAlphaMask;
    }

    @Deprecated
    private final boolean $$robo$$android_graphics_ImageDecoder$getAsAlphaMask() {
        return this.getDecodeAsAlphaMask();
    }

    private final void $$robo$$android_graphics_ImageDecoder$setTargetColorSpace(ColorSpace colorSpace) {
        this.mDesiredColorSpace = colorSpace;
    }

    private final void $$robo$$android_graphics_ImageDecoder$close() {
        this.mCloseGuard.close();
        if (!this.mClosed.compareAndSet(false, true)) {
            return;
        }
        ImageDecoder.nClose(this.mNativePtr);
        this.mNativePtr = 0L;
        if (this.mOwnsInputStream) {
            IoUtils.closeQuietly(this.mInputStream);
        }
        IoUtils.closeQuietly(this.mAssetFd);
        this.mInputStream = null;
        this.mAssetFd = null;
        this.mTempStorage = null;
    }

    private final void $$robo$$android_graphics_ImageDecoder$checkState() {
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("Cannot use closed ImageDecoder!");
        }
        ImageDecoder.checkSubset(this.mDesiredWidth, this.mDesiredHeight, this.mCropRect);
        if (this.mAllocator == 3) {
            if (this.mMutable) {
                throw new IllegalStateException("Cannot make mutable HARDWARE Bitmap!");
            }
            if (this.mDecodeAsAlphaMask) {
                throw new IllegalStateException("Cannot make HARDWARE Alpha mask Bitmap!");
            }
        }
        if (this.mPostProcessor != null && this.mUnpremultipliedRequired) {
            throw new IllegalStateException("Cannot draw to unpremultiplied pixels!");
        }
        if (this.mDesiredColorSpace != null) {
            if (!(this.mDesiredColorSpace instanceof ColorSpace.Rgb)) {
                throw new IllegalArgumentException("The target color space must use the RGB color model - provided: " + this.mDesiredColorSpace);
            }
            if (((ColorSpace.Rgb)this.mDesiredColorSpace).getTransferParameters() == null) {
                throw new IllegalArgumentException("The target color space must use an ICC parametric transfer function - provided: " + this.mDesiredColorSpace);
            }
        }
    }

    private static final void $$robo$$android_graphics_ImageDecoder$checkSubset(int width, int height, Rect r) {
        if (r == null) {
            return;
        }
        if (r.left < 0 || r.top < 0 || r.right > width || r.bottom > height) {
            throw new IllegalStateException("Subset " + r + " not contained by scaled image bounds: (" + width + " x " + height + ")");
        }
    }

    private final Bitmap $$robo$$android_graphics_ImageDecoder$decodeBitmapInternal() throws IOException {
        this.checkState();
        return ImageDecoder.nDecodeBitmap(this.mNativePtr, this, this.mPostProcessor != null, this.mDesiredWidth, this.mDesiredHeight, this.mCropRect, this.mMutable, this.mAllocator, this.mUnpremultipliedRequired, this.mConserveMemory, this.mDecodeAsAlphaMask, this.mDesiredColorSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_ImageDecoder$callHeaderDecoded(OnHeaderDecodedListener listener, Source src) {
        if (listener != null) {
            ImageInfo info = new ImageInfo(this);
            try {
                listener.onHeaderDecoded(this, info, src);
            }
            finally {
                info.mDecoder = null;
            }
        }
    }

    private static final Drawable $$robo$$android_graphics_ImageDecoder$decodeDrawable(Source src, OnHeaderDecodedListener listener) throws IOException {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null! Use decodeDrawable(Source) to not have a listener");
        }
        return ImageDecoder.decodeDrawableImpl(src, listener);
    }

    private static final Drawable $$robo$$android_graphics_ImageDecoder$decodeDrawableImpl(Source src, OnHeaderDecodedListener listener) throws IOException {
        try (ImageDecoder decoder = src.createImageDecoder();){
            decoder.mSource = src;
            decoder.callHeaderDecoded(listener, src);
            if (decoder.mUnpremultipliedRequired) {
                throw new IllegalStateException("Cannot decode a Drawable with unpremultiplied pixels!");
            }
            if (decoder.mMutable) {
                throw new IllegalStateException("Cannot decode a mutable Drawable!");
            }
            int srcDensity = decoder.computeDensity(src);
            if (decoder.mAnimated) {
                ImageDecoder postProcessPtr = decoder.mPostProcessor == null ? null : decoder;
                AnimatedImageDrawable d = new AnimatedImageDrawable(decoder.mNativePtr, postProcessPtr, decoder.mDesiredWidth, decoder.mDesiredHeight, srcDensity, src.computeDstDensity(), decoder.mCropRect, decoder.mInputStream, decoder.mAssetFd);
                decoder.mInputStream = null;
                decoder.mAssetFd = null;
                AnimatedImageDrawable animatedImageDrawable = d;
                return animatedImageDrawable;
            }
            Bitmap bm = decoder.decodeBitmapInternal();
            bm.setDensity(srcDensity);
            Resources res = src.getResources();
            byte[] np = bm.getNinePatchChunk();
            if (np != null && NinePatch.isNinePatchChunk(np)) {
                Rect opticalInsets = new Rect();
                bm.getOpticalInsets(opticalInsets);
                Rect padding = decoder.mOutPaddingRect;
                if (padding == null) {
                    padding = new Rect();
                }
                ImageDecoder.nGetPadding(decoder.mNativePtr, padding);
                NinePatchDrawable ninePatchDrawable = new NinePatchDrawable(res, bm, np, padding, opticalInsets, null);
                return ninePatchDrawable;
            }
            BitmapDrawable bitmapDrawable = new BitmapDrawable(res, bm);
            return bitmapDrawable;
        }
    }

    private static final Drawable $$robo$$android_graphics_ImageDecoder$decodeDrawable(Source src) throws IOException {
        return ImageDecoder.decodeDrawableImpl(src, null);
    }

    private static final Bitmap $$robo$$android_graphics_ImageDecoder$decodeBitmap(Source src, OnHeaderDecodedListener listener) throws IOException {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null! Use decodeBitmap(Source) to not have a listener");
        }
        return ImageDecoder.decodeBitmapImpl(src, listener);
    }

    private static final Bitmap $$robo$$android_graphics_ImageDecoder$decodeBitmapImpl(Source src, OnHeaderDecodedListener listener) throws IOException {
        try (ImageDecoder decoder = src.createImageDecoder();){
            byte[] np;
            decoder.mSource = src;
            decoder.callHeaderDecoded(listener, src);
            int srcDensity = decoder.computeDensity(src);
            Bitmap bm = decoder.decodeBitmapInternal();
            bm.setDensity(srcDensity);
            Rect padding = decoder.mOutPaddingRect;
            if (padding != null && (np = bm.getNinePatchChunk()) != null && NinePatch.isNinePatchChunk(np)) {
                ImageDecoder.nGetPadding(decoder.mNativePtr, padding);
            }
            Bitmap bitmap = bm;
            return bitmap;
        }
    }

    private final int $$robo$$android_graphics_ImageDecoder$computeDensity(Source src) {
        if (this.requestedResize()) {
            return 0;
        }
        int srcDensity = src.getDensity();
        if (srcDensity == 0) {
            return srcDensity;
        }
        if (this.mIsNinePatch && this.mPostProcessor == null) {
            return srcDensity;
        }
        Resources res = src.getResources();
        if (res != null && res.getDisplayMetrics().noncompatDensityDpi == srcDensity) {
            return srcDensity;
        }
        int dstDensity = src.computeDstDensity();
        if (srcDensity == dstDensity) {
            return srcDensity;
        }
        if (srcDensity < dstDensity && sApiLevel >= 28) {
            return srcDensity;
        }
        float scale = (float)dstDensity / (float)srcDensity;
        int scaledWidth = (int)((float)this.mWidth * scale + 0.5f);
        int scaledHeight = (int)((float)this.mHeight * scale + 0.5f);
        this.setTargetSize(scaledWidth, scaledHeight);
        return dstDensity;
    }

    private final String $$robo$$android_graphics_ImageDecoder$getMimeType() {
        return ImageDecoder.nGetMimeType(this.mNativePtr);
    }

    private final ColorSpace $$robo$$android_graphics_ImageDecoder$getColorSpace() {
        return ImageDecoder.nGetColorSpace(this.mNativePtr);
    }

    private static final Bitmap $$robo$$android_graphics_ImageDecoder$decodeBitmap(Source src) throws IOException {
        return ImageDecoder.decodeBitmapImpl(src, null);
    }

    private final int $$robo$$android_graphics_ImageDecoder$postProcessAndRelease(Canvas canvas) {
        try {
            int n = this.mPostProcessor.onPostProcess(canvas);
            return n;
        }
        finally {
            canvas.release();
        }
    }

    private final void $$robo$$android_graphics_ImageDecoder$onPartialImage(int error, Throwable cause) throws DecodeException {
        DecodeException exception = new DecodeException(error, cause, this.mSource);
        if (this.mOnPartialImageListener == null || !this.mOnPartialImageListener.onPartialImage(exception)) {
            throw exception;
        }
    }

    private static final ImageDecoder $$robo$$android_graphics_ImageDecoder$nCreate(long l, Source source) throws IOException {
        return null;
    }

    private static final ImageDecoder $$robo$$android_graphics_ImageDecoder$nCreate(ByteBuffer byteBuffer, int n, int n2, Source source) throws IOException {
        return null;
    }

    private static final ImageDecoder $$robo$$android_graphics_ImageDecoder$nCreate(byte[] byArray, int n, int n2, Source source) throws IOException {
        return null;
    }

    private static final ImageDecoder $$robo$$android_graphics_ImageDecoder$nCreate(InputStream inputStream, byte[] byArray, Source source) throws IOException {
        return null;
    }

    private static final ImageDecoder $$robo$$android_graphics_ImageDecoder$nCreate(FileDescriptor fileDescriptor, Source source) throws IOException {
        return null;
    }

    private static final Bitmap $$robo$$android_graphics_ImageDecoder$nDecodeBitmap(long l, ImageDecoder imageDecoder, boolean bl, int n, int n2, Rect rect, boolean bl2, int n3, boolean bl3, boolean bl4, boolean bl5, ColorSpace colorSpace) throws IOException {
        return null;
    }

    private static final Size $$robo$$android_graphics_ImageDecoder$nGetSampledSize(long l, int n) {
        return null;
    }

    private static final void $$robo$$android_graphics_ImageDecoder$nGetPadding(long l, Rect rect) {
    }

    private static final void $$robo$$android_graphics_ImageDecoder$nClose(long l) {
    }

    private static final String $$robo$$android_graphics_ImageDecoder$nGetMimeType(long l) {
        return null;
    }

    private static final ColorSpace $$robo$$android_graphics_ImageDecoder$nGetColorSpace(long l) {
        return null;
    }

    private static ImageDecoder createFromFile(File file, Source source) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromFile", $$robo$$android_graphics_ImageDecoder$createFromFile(java.io.File android.graphics.ImageDecoder$Source ), 0, (File)file, (Source)source);
    }

    private static ImageDecoder createFromStream(InputStream inputStream, boolean bl, Source source) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromStream", $$robo$$android_graphics_ImageDecoder$createFromStream(java.io.InputStream boolean android.graphics.ImageDecoder$Source ), 0, (InputStream)inputStream, (boolean)bl, (Source)source);
    }

    private static ImageDecoder createFromAsset(AssetManager.AssetInputStream assetInputStream, Source source) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromAsset", $$robo$$android_graphics_ImageDecoder$createFromAsset(android.content.res.AssetManager$AssetInputStream android.graphics.ImageDecoder$Source ), 0, (AssetManager.AssetInputStream)assetInputStream, (Source)source);
    }

    private void __constructor__(long l, int n, int n2, boolean bl, boolean bl2) {
        this.$$robo$$android_graphics_ImageDecoder$__constructor__(l, n, n2, bl, bl2);
    }

    private ImageDecoder(long l, int n, int n2, boolean bl, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ImageDecoder$__constructor__(long int int boolean boolean ), 0, this, l, n, n2, bl, bl2);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_ImageDecoder$finalize(), 0, this);
    }

    public static Source createSource(Resources resources, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createSource", $$robo$$android_graphics_ImageDecoder$createSource(android.content.res.Resources int ), 0, (Resources)resources, (int)n);
    }

    public static Source createSource(ContentResolver contentResolver, Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("createSource", $$robo$$android_graphics_ImageDecoder$createSource(android.content.ContentResolver android.net.Uri ), 0, (ContentResolver)contentResolver, (Uri)uri);
    }

    public static Source createSource(ContentResolver contentResolver, Uri uri, Resources resources) {
        return InvokeDynamicSupport.bootstrapStatic("createSource", $$robo$$android_graphics_ImageDecoder$createSource(android.content.ContentResolver android.net.Uri android.content.res.Resources ), 0, (ContentResolver)contentResolver, (Uri)uri, (Resources)resources);
    }

    public static Source createSource(AssetManager assetManager, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createSource", $$robo$$android_graphics_ImageDecoder$createSource(android.content.res.AssetManager java.lang.String ), 0, (AssetManager)assetManager, (String)string2);
    }

    public static Source createSource(byte[] byArray, int n, int n2) throws ArrayIndexOutOfBoundsException {
        return InvokeDynamicSupport.bootstrapStatic("createSource", $$robo$$android_graphics_ImageDecoder$createSource(byte[] int int ), 0, (byte[])byArray, (int)n, (int)n2);
    }

    public static Source createSource(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("createSource", $$robo$$android_graphics_ImageDecoder$createSource(byte[] ), 0, (byte[])byArray);
    }

    public static Source createSource(ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrapStatic("createSource", $$robo$$android_graphics_ImageDecoder$createSource(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
    }

    public static Source createSource(Resources resources, InputStream inputStream) {
        return InvokeDynamicSupport.bootstrapStatic("createSource", $$robo$$android_graphics_ImageDecoder$createSource(android.content.res.Resources java.io.InputStream ), 0, (Resources)resources, (InputStream)inputStream);
    }

    public static Source createSource(Resources resources, InputStream inputStream, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createSource", $$robo$$android_graphics_ImageDecoder$createSource(android.content.res.Resources java.io.InputStream int ), 0, (Resources)resources, (InputStream)inputStream, (int)n);
    }

    public static Source createSource(File file) {
        return InvokeDynamicSupport.bootstrapStatic("createSource", $$robo$$android_graphics_ImageDecoder$createSource(java.io.File ), 0, (File)file);
    }

    public Size getSampledSize(int n) {
        return InvokeDynamicSupport.bootstrap("getSampledSize", $$robo$$android_graphics_ImageDecoder$getSampledSize(int ), 0, this, n);
    }

    @Deprecated
    public ImageDecoder setResize(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("setResize", $$robo$$android_graphics_ImageDecoder$setResize(int int ), 0, this, n, n2);
    }

    public void setTargetSize(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setTargetSize", $$robo$$android_graphics_ImageDecoder$setTargetSize(int int ), 0, this, n, n2);
    }

    @Deprecated
    public ImageDecoder setResize(int n) {
        return InvokeDynamicSupport.bootstrap("setResize", $$robo$$android_graphics_ImageDecoder$setResize(int ), 0, this, n);
    }

    private int getTargetDimension(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("getTargetDimension", $$robo$$android_graphics_ImageDecoder$getTargetDimension(int int int ), 0, this, n, n2, n3);
    }

    public void setTargetSampleSize(int n) {
        InvokeDynamicSupport.bootstrap("setTargetSampleSize", $$robo$$android_graphics_ImageDecoder$setTargetSampleSize(int ), 0, this, n);
    }

    private boolean requestedResize() {
        return (boolean)InvokeDynamicSupport.bootstrap("requestedResize", $$robo$$android_graphics_ImageDecoder$requestedResize(), 0, this);
    }

    public void setAllocator(int n) {
        InvokeDynamicSupport.bootstrap("setAllocator", $$robo$$android_graphics_ImageDecoder$setAllocator(int ), 0, this, n);
    }

    public int getAllocator() {
        return (int)InvokeDynamicSupport.bootstrap("getAllocator", $$robo$$android_graphics_ImageDecoder$getAllocator(), 0, this);
    }

    public void setUnpremultipliedRequired(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUnpremultipliedRequired", $$robo$$android_graphics_ImageDecoder$setUnpremultipliedRequired(boolean ), 0, this, bl);
    }

    @Deprecated
    public ImageDecoder setRequireUnpremultiplied(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setRequireUnpremultiplied", $$robo$$android_graphics_ImageDecoder$setRequireUnpremultiplied(boolean ), 0, this, bl);
    }

    public boolean isUnpremultipliedRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUnpremultipliedRequired", $$robo$$android_graphics_ImageDecoder$isUnpremultipliedRequired(), 0, this);
    }

    @Deprecated
    public boolean getRequireUnpremultiplied() {
        return (boolean)InvokeDynamicSupport.bootstrap("getRequireUnpremultiplied", $$robo$$android_graphics_ImageDecoder$getRequireUnpremultiplied(), 0, this);
    }

    public void setPostProcessor(PostProcessor postProcessor) {
        InvokeDynamicSupport.bootstrap("setPostProcessor", $$robo$$android_graphics_ImageDecoder$setPostProcessor(android.graphics.PostProcessor ), 0, this, postProcessor);
    }

    public PostProcessor getPostProcessor() {
        return InvokeDynamicSupport.bootstrap("getPostProcessor", $$robo$$android_graphics_ImageDecoder$getPostProcessor(), 0, this);
    }

    public void setOnPartialImageListener(OnPartialImageListener onPartialImageListener) {
        InvokeDynamicSupport.bootstrap("setOnPartialImageListener", $$robo$$android_graphics_ImageDecoder$setOnPartialImageListener(android.graphics.ImageDecoder$OnPartialImageListener ), 0, this, onPartialImageListener);
    }

    public OnPartialImageListener getOnPartialImageListener() {
        return InvokeDynamicSupport.bootstrap("getOnPartialImageListener", $$robo$$android_graphics_ImageDecoder$getOnPartialImageListener(), 0, this);
    }

    public void setCrop(Rect rect) {
        InvokeDynamicSupport.bootstrap("setCrop", $$robo$$android_graphics_ImageDecoder$setCrop(android.graphics.Rect ), 0, this, rect);
    }

    public Rect getCrop() {
        return InvokeDynamicSupport.bootstrap("getCrop", $$robo$$android_graphics_ImageDecoder$getCrop(), 0, this);
    }

    public void setOutPaddingRect(Rect rect) {
        InvokeDynamicSupport.bootstrap("setOutPaddingRect", $$robo$$android_graphics_ImageDecoder$setOutPaddingRect(android.graphics.Rect ), 0, this, rect);
    }

    public void setMutableRequired(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMutableRequired", $$robo$$android_graphics_ImageDecoder$setMutableRequired(boolean ), 0, this, bl);
    }

    @Deprecated
    public ImageDecoder setMutable(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setMutable", $$robo$$android_graphics_ImageDecoder$setMutable(boolean ), 0, this, bl);
    }

    public boolean isMutableRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMutableRequired", $$robo$$android_graphics_ImageDecoder$isMutableRequired(), 0, this);
    }

    @Deprecated
    public boolean getMutable() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMutable", $$robo$$android_graphics_ImageDecoder$getMutable(), 0, this);
    }

    public void setMemorySizePolicy(int n) {
        InvokeDynamicSupport.bootstrap("setMemorySizePolicy", $$robo$$android_graphics_ImageDecoder$setMemorySizePolicy(int ), 0, this, n);
    }

    public int getMemorySizePolicy() {
        return (int)InvokeDynamicSupport.bootstrap("getMemorySizePolicy", $$robo$$android_graphics_ImageDecoder$getMemorySizePolicy(), 0, this);
    }

    @Deprecated
    public void setConserveMemory(boolean bl) {
        InvokeDynamicSupport.bootstrap("setConserveMemory", $$robo$$android_graphics_ImageDecoder$setConserveMemory(boolean ), 0, this, bl);
    }

    @Deprecated
    public boolean getConserveMemory() {
        return (boolean)InvokeDynamicSupport.bootstrap("getConserveMemory", $$robo$$android_graphics_ImageDecoder$getConserveMemory(), 0, this);
    }

    public void setDecodeAsAlphaMaskEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDecodeAsAlphaMaskEnabled", $$robo$$android_graphics_ImageDecoder$setDecodeAsAlphaMaskEnabled(boolean ), 0, this, bl);
    }

    @Deprecated
    public ImageDecoder setDecodeAsAlphaMask(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setDecodeAsAlphaMask", $$robo$$android_graphics_ImageDecoder$setDecodeAsAlphaMask(boolean ), 0, this, bl);
    }

    @Deprecated
    public ImageDecoder setAsAlphaMask(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setAsAlphaMask", $$robo$$android_graphics_ImageDecoder$setAsAlphaMask(boolean ), 0, this, bl);
    }

    public boolean isDecodeAsAlphaMaskEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDecodeAsAlphaMaskEnabled", $$robo$$android_graphics_ImageDecoder$isDecodeAsAlphaMaskEnabled(), 0, this);
    }

    @Deprecated
    public boolean getDecodeAsAlphaMask() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDecodeAsAlphaMask", $$robo$$android_graphics_ImageDecoder$getDecodeAsAlphaMask(), 0, this);
    }

    @Deprecated
    public boolean getAsAlphaMask() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAsAlphaMask", $$robo$$android_graphics_ImageDecoder$getAsAlphaMask(), 0, this);
    }

    public void setTargetColorSpace(ColorSpace colorSpace) {
        InvokeDynamicSupport.bootstrap("setTargetColorSpace", $$robo$$android_graphics_ImageDecoder$setTargetColorSpace(android.graphics.ColorSpace ), 0, this, colorSpace);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_graphics_ImageDecoder$close(), 0, this);
    }

    private void checkState() {
        InvokeDynamicSupport.bootstrap("checkState", $$robo$$android_graphics_ImageDecoder$checkState(), 0, this);
    }

    private static void checkSubset(int n, int n2, Rect rect) {
        InvokeDynamicSupport.bootstrapStatic("checkSubset", $$robo$$android_graphics_ImageDecoder$checkSubset(int int android.graphics.Rect ), 0, (int)n, (int)n2, (Rect)rect);
    }

    private Bitmap decodeBitmapInternal() throws IOException {
        return InvokeDynamicSupport.bootstrap("decodeBitmapInternal", $$robo$$android_graphics_ImageDecoder$decodeBitmapInternal(), 0, this);
    }

    private void callHeaderDecoded(OnHeaderDecodedListener onHeaderDecodedListener, Source source) {
        InvokeDynamicSupport.bootstrap("callHeaderDecoded", $$robo$$android_graphics_ImageDecoder$callHeaderDecoded(android.graphics.ImageDecoder$OnHeaderDecodedListener android.graphics.ImageDecoder$Source ), 0, this, onHeaderDecodedListener, source);
    }

    public static Drawable decodeDrawable(Source source, OnHeaderDecodedListener onHeaderDecodedListener) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("decodeDrawable", $$robo$$android_graphics_ImageDecoder$decodeDrawable(android.graphics.ImageDecoder$Source android.graphics.ImageDecoder$OnHeaderDecodedListener ), 0, (Source)source, (OnHeaderDecodedListener)onHeaderDecodedListener);
    }

    private static Drawable decodeDrawableImpl(Source source, OnHeaderDecodedListener onHeaderDecodedListener) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("decodeDrawableImpl", $$robo$$android_graphics_ImageDecoder$decodeDrawableImpl(android.graphics.ImageDecoder$Source android.graphics.ImageDecoder$OnHeaderDecodedListener ), 0, (Source)source, (OnHeaderDecodedListener)onHeaderDecodedListener);
    }

    public static Drawable decodeDrawable(Source source) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("decodeDrawable", $$robo$$android_graphics_ImageDecoder$decodeDrawable(android.graphics.ImageDecoder$Source ), 0, (Source)source);
    }

    public static Bitmap decodeBitmap(Source source, OnHeaderDecodedListener onHeaderDecodedListener) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("decodeBitmap", $$robo$$android_graphics_ImageDecoder$decodeBitmap(android.graphics.ImageDecoder$Source android.graphics.ImageDecoder$OnHeaderDecodedListener ), 0, (Source)source, (OnHeaderDecodedListener)onHeaderDecodedListener);
    }

    private static Bitmap decodeBitmapImpl(Source source, OnHeaderDecodedListener onHeaderDecodedListener) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("decodeBitmapImpl", $$robo$$android_graphics_ImageDecoder$decodeBitmapImpl(android.graphics.ImageDecoder$Source android.graphics.ImageDecoder$OnHeaderDecodedListener ), 0, (Source)source, (OnHeaderDecodedListener)onHeaderDecodedListener);
    }

    private int computeDensity(Source source) {
        return (int)InvokeDynamicSupport.bootstrap("computeDensity", $$robo$$android_graphics_ImageDecoder$computeDensity(android.graphics.ImageDecoder$Source ), 0, this, source);
    }

    private String getMimeType() {
        return InvokeDynamicSupport.bootstrap("getMimeType", $$robo$$android_graphics_ImageDecoder$getMimeType(), 0, this);
    }

    private ColorSpace getColorSpace() {
        return InvokeDynamicSupport.bootstrap("getColorSpace", $$robo$$android_graphics_ImageDecoder$getColorSpace(), 0, this);
    }

    public static Bitmap decodeBitmap(Source source) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("decodeBitmap", $$robo$$android_graphics_ImageDecoder$decodeBitmap(android.graphics.ImageDecoder$Source ), 0, (Source)source);
    }

    private int postProcessAndRelease(Canvas canvas) {
        return (int)InvokeDynamicSupport.bootstrap("postProcessAndRelease", $$robo$$android_graphics_ImageDecoder$postProcessAndRelease(android.graphics.Canvas ), 0, this, canvas);
    }

    private void onPartialImage(int n, Throwable throwable) throws DecodeException {
        InvokeDynamicSupport.bootstrap("onPartialImage", $$robo$$android_graphics_ImageDecoder$onPartialImage(int java.lang.Throwable ), 0, this, n, throwable);
    }

    private static final native /* synthetic */ ImageDecoder $$robo$$nCreate$nativeBinding(long var0, Source var2) throws IOException;

    private static ImageDecoder nCreate(long l, Source source) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("nCreate", $$robo$$android_graphics_ImageDecoder$nCreate(long android.graphics.ImageDecoder$Source ), 1, (long)l, (Source)source);
    }

    private static final native /* synthetic */ ImageDecoder $$robo$$nCreate$nativeBinding(ByteBuffer var0, int var1, int var2, Source var3) throws IOException;

    private static ImageDecoder nCreate(ByteBuffer byteBuffer, int n, int n2, Source source) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("nCreate", $$robo$$android_graphics_ImageDecoder$nCreate(java.nio.ByteBuffer int int android.graphics.ImageDecoder$Source ), 1, (ByteBuffer)byteBuffer, (int)n, (int)n2, (Source)source);
    }

    private static final native /* synthetic */ ImageDecoder $$robo$$nCreate$nativeBinding(byte[] var0, int var1, int var2, Source var3) throws IOException;

    private static ImageDecoder nCreate(byte[] byArray, int n, int n2, Source source) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("nCreate", $$robo$$android_graphics_ImageDecoder$nCreate(byte[] int int android.graphics.ImageDecoder$Source ), 1, (byte[])byArray, (int)n, (int)n2, (Source)source);
    }

    private static final native /* synthetic */ ImageDecoder $$robo$$nCreate$nativeBinding(InputStream var0, byte[] var1, Source var2) throws IOException;

    private static ImageDecoder nCreate(InputStream inputStream, byte[] byArray, Source source) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("nCreate", $$robo$$android_graphics_ImageDecoder$nCreate(java.io.InputStream byte[] android.graphics.ImageDecoder$Source ), 1, (InputStream)inputStream, (byte[])byArray, (Source)source);
    }

    private static final native /* synthetic */ ImageDecoder $$robo$$nCreate$nativeBinding(FileDescriptor var0, Source var1) throws IOException;

    private static ImageDecoder nCreate(FileDescriptor fileDescriptor, Source source) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("nCreate", $$robo$$android_graphics_ImageDecoder$nCreate(java.io.FileDescriptor android.graphics.ImageDecoder$Source ), 1, (FileDescriptor)fileDescriptor, (Source)source);
    }

    private static final native /* synthetic */ Bitmap $$robo$$nDecodeBitmap$nativeBinding(long var0, ImageDecoder var2, boolean var3, int var4, int var5, Rect var6, boolean var7, int var8, boolean var9, boolean var10, boolean var11, ColorSpace var12) throws IOException;

    private static Bitmap nDecodeBitmap(long l, ImageDecoder imageDecoder, boolean bl, int n, int n2, Rect rect, boolean bl2, int n3, boolean bl3, boolean bl4, boolean bl5, ColorSpace colorSpace) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("nDecodeBitmap", $$robo$$android_graphics_ImageDecoder$nDecodeBitmap(long android.graphics.ImageDecoder boolean int int android.graphics.Rect boolean int boolean boolean boolean android.graphics.ColorSpace ), 1, (long)l, (ImageDecoder)imageDecoder, (boolean)bl, (int)n, (int)n2, (Rect)rect, (boolean)bl2, (int)n3, (boolean)bl3, (boolean)bl4, (boolean)bl5, (ColorSpace)colorSpace);
    }

    private static final native /* synthetic */ Size $$robo$$nGetSampledSize$nativeBinding(long var0, int var2);

    private static Size nGetSampledSize(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("nGetSampledSize", $$robo$$android_graphics_ImageDecoder$nGetSampledSize(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nGetPadding$nativeBinding(long var0, Rect var2);

    private static void nGetPadding(long l, Rect rect) {
        InvokeDynamicSupport.bootstrapStatic("nGetPadding", $$robo$$android_graphics_ImageDecoder$nGetPadding(long android.graphics.Rect ), 1, (long)l, (Rect)rect);
    }

    private static final native /* synthetic */ void $$robo$$nClose$nativeBinding(long var0);

    private static void nClose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nClose", $$robo$$android_graphics_ImageDecoder$nClose(long ), 1, (long)l);
    }

    private static final native /* synthetic */ String $$robo$$nGetMimeType$nativeBinding(long var0);

    private static String nGetMimeType(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nGetMimeType", $$robo$$android_graphics_ImageDecoder$nGetMimeType(long ), 1, (long)l);
    }

    private static final native /* synthetic */ ColorSpace $$robo$$nGetColorSpace$nativeBinding(long var0);

    private static ColorSpace nGetColorSpace(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nGetColorSpace", $$robo$$android_graphics_ImageDecoder$nGetColorSpace(long ), 1, (long)l);
    }

    public /* synthetic */ ImageDecoder() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImageDecoder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MemoryPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Allocator {
    }

    public static interface OnPartialImageListener
    extends InstrumentedInterface {
        public boolean onPartialImage(DecodeException var1);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class DecodeException
    extends IOException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int SOURCE_EXCEPTION = 1;
        public static int SOURCE_INCOMPLETE = 2;
        public static int SOURCE_MALFORMED_DATA = 3;
        int mError;
        Source mSource;

        private void $$robo$$android_graphics_ImageDecoder_DecodeException$__constructor__(int error, Throwable cause, Source source) {
            this.mError = error;
            this.mSource = source;
        }

        private void $$robo$$android_graphics_ImageDecoder_DecodeException$__constructor__(int error, String msg, Throwable cause, Source source) {
            this.mError = error;
            this.mSource = source;
        }

        private final int $$robo$$android_graphics_ImageDecoder_DecodeException$getError() {
            return this.mError;
        }

        private final Source $$robo$$android_graphics_ImageDecoder_DecodeException$getSource() {
            return this.mSource;
        }

        private static final String $$robo$$android_graphics_ImageDecoder_DecodeException$errorMessage(int error, Throwable cause) {
            switch (error) {
                case 1: {
                    return "Exception in input: " + cause;
                }
                case 2: {
                    return "Input was incomplete.";
                }
                case 3: {
                    return "Input contained an error.";
                }
            }
            return "";
        }

        private void __constructor__(int n, Throwable throwable, Source source) {
            this.$$robo$$android_graphics_ImageDecoder_DecodeException$__constructor__(n, throwable, source);
        }

        DecodeException(int n, Throwable throwable, Source source) {
            super(DecodeException.errorMessage(n, throwable), throwable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ImageDecoder_DecodeException$__constructor__(int java.lang.Throwable android.graphics.ImageDecoder$Source ), 0, this, n, throwable, source);
        }

        private void __constructor__(int n, String string2, Throwable throwable, Source source) {
            this.$$robo$$android_graphics_ImageDecoder_DecodeException$__constructor__(n, string2, throwable, source);
        }

        DecodeException(int n, String string2, Throwable throwable, Source source) {
            super(string2 + DecodeException.errorMessage(n, throwable), throwable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ImageDecoder_DecodeException$__constructor__(int java.lang.String java.lang.Throwable android.graphics.ImageDecoder$Source ), 0, this, n, string2, throwable, source);
        }

        public int getError() {
            return (int)InvokeDynamicSupport.bootstrap("getError", $$robo$$android_graphics_ImageDecoder_DecodeException$getError(), 0, this);
        }

        public Source getSource() {
            return InvokeDynamicSupport.bootstrap("getSource", $$robo$$android_graphics_ImageDecoder_DecodeException$getSource(), 0, this);
        }

        private static String errorMessage(int n, Throwable throwable) {
            return InvokeDynamicSupport.bootstrapStatic("errorMessage", $$robo$$android_graphics_ImageDecoder_DecodeException$errorMessage(int java.lang.Throwable ), 0, (int)n, (Throwable)throwable);
        }

        public /* synthetic */ DecodeException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DecodeException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Error {
        }
    }

    public static interface OnHeaderDecodedListener
    extends InstrumentedInterface {
        public void onHeaderDecoded(ImageDecoder var1, ImageInfo var2, Source var3);
    }

    @Deprecated
    public static class IncompleteException
    extends IOException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_graphics_ImageDecoder_IncompleteException$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_ImageDecoder_IncompleteException$__constructor__();
        }

        public IncompleteException() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ImageDecoder_IncompleteException$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IncompleteException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ImageInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Size mSize;
        private ImageDecoder mDecoder;

        private void $$robo$$android_graphics_ImageDecoder_ImageInfo$__constructor__(ImageDecoder decoder) {
            this.mSize = new Size(decoder.mWidth, decoder.mHeight);
            this.mDecoder = decoder;
        }

        private final Size $$robo$$android_graphics_ImageDecoder_ImageInfo$getSize() {
            return this.mSize;
        }

        private final String $$robo$$android_graphics_ImageDecoder_ImageInfo$getMimeType() {
            return this.mDecoder.getMimeType();
        }

        private final boolean $$robo$$android_graphics_ImageDecoder_ImageInfo$isAnimated() {
            return this.mDecoder.mAnimated;
        }

        private final ColorSpace $$robo$$android_graphics_ImageDecoder_ImageInfo$getColorSpace() {
            return this.mDecoder.getColorSpace();
        }

        private /* synthetic */ void $$robo$$android_graphics_ImageDecoder_ImageInfo$__constructor__(ImageDecoder x0, 1 x1) {
        }

        private void __constructor__(ImageDecoder imageDecoder) {
            this.$$robo$$android_graphics_ImageDecoder_ImageInfo$__constructor__(imageDecoder);
        }

        private ImageInfo(ImageDecoder imageDecoder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ImageDecoder_ImageInfo$__constructor__(android.graphics.ImageDecoder ), 0, this, imageDecoder);
        }

        public Size getSize() {
            return InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_graphics_ImageDecoder_ImageInfo$getSize(), 0, this);
        }

        public String getMimeType() {
            return InvokeDynamicSupport.bootstrap("getMimeType", $$robo$$android_graphics_ImageDecoder_ImageInfo$getMimeType(), 0, this);
        }

        public boolean isAnimated() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAnimated", $$robo$$android_graphics_ImageDecoder_ImageInfo$isAnimated(), 0, this);
        }

        public ColorSpace getColorSpace() {
            return InvokeDynamicSupport.bootstrap("getColorSpace", $$robo$$android_graphics_ImageDecoder_ImageInfo$getColorSpace(), 0, this);
        }

        private /* synthetic */ void __constructor__(ImageDecoder imageDecoder, 1 var2_2) {
            this.$$robo$$android_graphics_ImageDecoder_ImageInfo$__constructor__(imageDecoder, var2_2);
        }

        public /* synthetic */ ImageInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImageInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class FileSource
    extends Source
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private File mFile;

        private void $$robo$$android_graphics_ImageDecoder_FileSource$__constructor__(File file) {
            this.mFile = file;
        }

        private final ImageDecoder $$robo$$android_graphics_ImageDecoder_FileSource$createImageDecoder() throws IOException {
            return ImageDecoder.createFromFile(this.mFile, this);
        }

        private void __constructor__(File file) {
            this.$$robo$$android_graphics_ImageDecoder_FileSource$__constructor__(file);
        }

        FileSource(File file) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ImageDecoder_FileSource$__constructor__(java.io.File ), 0, this, file);
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return InvokeDynamicSupport.bootstrap("createImageDecoder", $$robo$$android_graphics_ImageDecoder_FileSource$createImageDecoder(), 0, this);
        }

        public /* synthetic */ FileSource() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileSource)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AssetSource
    extends Source
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AssetManager mAssets;
        private String mFileName;

        private void $$robo$$android_graphics_ImageDecoder_AssetSource$__constructor__(AssetManager assets, String fileName) {
            this.mAssets = assets;
            this.mFileName = fileName;
        }

        private final ImageDecoder $$robo$$android_graphics_ImageDecoder_AssetSource$createImageDecoder() throws IOException {
            InputStream is = this.mAssets.open(this.mFileName);
            return ImageDecoder.createFromAsset((AssetManager.AssetInputStream)is, this);
        }

        private void __constructor__(AssetManager assetManager, String string2) {
            this.$$robo$$android_graphics_ImageDecoder_AssetSource$__constructor__(assetManager, string2);
        }

        AssetSource(AssetManager assetManager, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ImageDecoder_AssetSource$__constructor__(android.content.res.AssetManager java.lang.String ), 0, this, assetManager, string2);
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return InvokeDynamicSupport.bootstrap("createImageDecoder", $$robo$$android_graphics_ImageDecoder_AssetSource$createImageDecoder(), 0, this);
        }

        public /* synthetic */ AssetSource() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AssetSource)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ResourceSource
    extends Source
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Resources mResources;
        int mResId;
        int mResDensity;
        private Object mLock;

        private void $$robo$$android_graphics_ImageDecoder_ResourceSource$__constructor__(Resources res, int resId) {
            this.mLock = new Object();
            this.mResources = res;
            this.mResId = resId;
            this.mResDensity = 0;
        }

        private final Resources $$robo$$android_graphics_ImageDecoder_ResourceSource$getResources() {
            return this.mResources;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_graphics_ImageDecoder_ResourceSource$getDensity() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mResDensity;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ImageDecoder $$robo$$android_graphics_ImageDecoder_ResourceSource$createImageDecoder() throws IOException {
            TypedValue value = new TypedValue();
            InputStream is = this.mResources.openRawResource(this.mResId, value);
            Object object = this.mLock;
            synchronized (object) {
                if (value.density == 0) {
                    this.mResDensity = 160;
                } else if (value.density != 65535) {
                    this.mResDensity = value.density;
                }
            }
            return ImageDecoder.createFromAsset((AssetManager.AssetInputStream)is, this);
        }

        private void __constructor__(Resources resources, int n) {
            this.$$robo$$android_graphics_ImageDecoder_ResourceSource$__constructor__(resources, n);
        }

        ResourceSource(Resources resources, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ImageDecoder_ResourceSource$__constructor__(android.content.res.Resources int ), 0, this, resources, n);
        }

        @Override
        public Resources getResources() {
            return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_graphics_ImageDecoder_ResourceSource$getResources(), 0, this);
        }

        @Override
        public int getDensity() {
            return (int)InvokeDynamicSupport.bootstrap("getDensity", $$robo$$android_graphics_ImageDecoder_ResourceSource$getDensity(), 0, this);
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return InvokeDynamicSupport.bootstrap("createImageDecoder", $$robo$$android_graphics_ImageDecoder_ResourceSource$createImageDecoder(), 0, this);
        }

        public /* synthetic */ ResourceSource() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResourceSource)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AssetInputStreamSource
    extends Source
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AssetManager.AssetInputStream mAssetInputStream;
        private Resources mResources;
        private int mDensity;

        private void $$robo$$android_graphics_ImageDecoder_AssetInputStreamSource$__constructor__(AssetManager.AssetInputStream ais, Resources res, TypedValue value) {
            this.mAssetInputStream = ais;
            this.mResources = res;
            this.mDensity = value.density == 0 ? 160 : (value.density != 65535 ? value.density : 0);
        }

        private final Resources $$robo$$android_graphics_ImageDecoder_AssetInputStreamSource$getResources() {
            return this.mResources;
        }

        private final int $$robo$$android_graphics_ImageDecoder_AssetInputStreamSource$getDensity() {
            return this.mDensity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ImageDecoder $$robo$$android_graphics_ImageDecoder_AssetInputStreamSource$createImageDecoder() throws IOException {
            AssetInputStreamSource assetInputStreamSource = this;
            synchronized (assetInputStreamSource) {
                if (this.mAssetInputStream == null) {
                    throw new IOException("Cannot reuse AssetInputStreamSource");
                }
                AssetManager.AssetInputStream ais = this.mAssetInputStream;
                this.mAssetInputStream = null;
                return ImageDecoder.createFromAsset(ais, this);
            }
        }

        private void __constructor__(AssetManager.AssetInputStream assetInputStream, Resources resources, TypedValue typedValue) {
            this.$$robo$$android_graphics_ImageDecoder_AssetInputStreamSource$__constructor__(assetInputStream, resources, typedValue);
        }

        public AssetInputStreamSource(AssetManager.AssetInputStream assetInputStream, Resources resources, TypedValue typedValue) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ImageDecoder_AssetInputStreamSource$__constructor__(android.content.res.AssetManager$AssetInputStream android.content.res.Resources android.util.TypedValue ), 0, this, assetInputStream, resources, typedValue);
        }

        @Override
        public Resources getResources() {
            return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_graphics_ImageDecoder_AssetInputStreamSource$getResources(), 0, this);
        }

        @Override
        public int getDensity() {
            return (int)InvokeDynamicSupport.bootstrap("getDensity", $$robo$$android_graphics_ImageDecoder_AssetInputStreamSource$getDensity(), 0, this);
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return InvokeDynamicSupport.bootstrap("createImageDecoder", $$robo$$android_graphics_ImageDecoder_AssetInputStreamSource$createImageDecoder(), 0, this);
        }

        public /* synthetic */ AssetInputStreamSource() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AssetInputStreamSource)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class InputStreamSource
    extends Source
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Resources mResources;
        InputStream mInputStream;
        int mInputDensity;

        private void $$robo$$android_graphics_ImageDecoder_InputStreamSource$__constructor__(Resources res, InputStream is, int inputDensity) {
            if (is == null) {
                throw new IllegalArgumentException("The InputStream cannot be null");
            }
            this.mResources = res;
            this.mInputStream = is;
            this.mInputDensity = res != null ? inputDensity : 0;
        }

        private final Resources $$robo$$android_graphics_ImageDecoder_InputStreamSource$getResources() {
            return this.mResources;
        }

        private final int $$robo$$android_graphics_ImageDecoder_InputStreamSource$getDensity() {
            return this.mInputDensity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ImageDecoder $$robo$$android_graphics_ImageDecoder_InputStreamSource$createImageDecoder() throws IOException {
            InputStreamSource inputStreamSource = this;
            synchronized (inputStreamSource) {
                if (this.mInputStream == null) {
                    throw new IOException("Cannot reuse InputStreamSource");
                }
                InputStream is = this.mInputStream;
                this.mInputStream = null;
                return ImageDecoder.createFromStream(is, false, this);
            }
        }

        private void __constructor__(Resources resources, InputStream inputStream, int n) {
            this.$$robo$$android_graphics_ImageDecoder_InputStreamSource$__constructor__(resources, inputStream, n);
        }

        InputStreamSource(Resources resources, InputStream inputStream, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ImageDecoder_InputStreamSource$__constructor__(android.content.res.Resources java.io.InputStream int ), 0, this, resources, inputStream, n);
        }

        @Override
        public Resources getResources() {
            return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_graphics_ImageDecoder_InputStreamSource$getResources(), 0, this);
        }

        @Override
        public int getDensity() {
            return (int)InvokeDynamicSupport.bootstrap("getDensity", $$robo$$android_graphics_ImageDecoder_InputStreamSource$getDensity(), 0, this);
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return InvokeDynamicSupport.bootstrap("createImageDecoder", $$robo$$android_graphics_ImageDecoder_InputStreamSource$createImageDecoder(), 0, this);
        }

        public /* synthetic */ InputStreamSource() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputStreamSource)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ContentResolverSource
    extends Source
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ContentResolver mResolver;
        private Uri mUri;
        private Resources mResources;

        private void $$robo$$android_graphics_ImageDecoder_ContentResolverSource$__constructor__(ContentResolver resolver, Uri uri, Resources res) {
            this.mResolver = resolver;
            this.mUri = uri;
            this.mResources = res;
        }

        private final Resources $$robo$$android_graphics_ImageDecoder_ContentResolverSource$getResources() {
            return this.mResources;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ImageDecoder $$robo$$android_graphics_ImageDecoder_ContentResolverSource$createImageDecoder() throws IOException {
            ImageDecoder decoder;
            block10: {
                AssetFileDescriptor assetFd;
                block9: {
                    assetFd = null;
                    try {
                        assetFd = this.mUri.getScheme() == "content" ? this.mResolver.openTypedAssetFileDescriptor(this.mUri, "image/*", null) : this.mResolver.openAssetFileDescriptor(this.mUri, "r");
                    }
                    catch (FileNotFoundException e) {
                        InputStream is = this.mResolver.openInputStream(this.mUri);
                        if (is == null) {
                            throw new FileNotFoundException(this.mUri.toString());
                        }
                        return ImageDecoder.createFromStream(is, true, this);
                    }
                    FileDescriptor fd = assetFd.getFileDescriptor();
                    long offset = assetFd.getStartOffset();
                    decoder = null;
                    try {
                        try {
                            Os.lseek(fd, offset, OsConstants.SEEK_SET);
                            decoder = ImageDecoder.nCreate(fd, this);
                        }
                        catch (ErrnoException e) {
                            decoder = ImageDecoder.createFromStream(new FileInputStream(fd), true, this);
                        }
                        if (decoder != null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (decoder == null) {
                            IoUtils.closeQuietly(assetFd);
                        } else {
                            decoder.mAssetFd = assetFd;
                        }
                        throw throwable;
                    }
                    IoUtils.closeQuietly(assetFd);
                    break block10;
                }
                decoder.mAssetFd = assetFd;
            }
            return decoder;
        }

        private void __constructor__(ContentResolver contentResolver, Uri uri, Resources resources) {
            this.$$robo$$android_graphics_ImageDecoder_ContentResolverSource$__constructor__(contentResolver, uri, resources);
        }

        ContentResolverSource(ContentResolver contentResolver, Uri uri, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ImageDecoder_ContentResolverSource$__constructor__(android.content.ContentResolver android.net.Uri android.content.res.Resources ), 0, this, contentResolver, uri, resources);
        }

        @Override
        Resources getResources() {
            return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_graphics_ImageDecoder_ContentResolverSource$getResources(), 0, this);
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return InvokeDynamicSupport.bootstrap("createImageDecoder", $$robo$$android_graphics_ImageDecoder_ContentResolverSource$createImageDecoder(), 0, this);
        }

        public /* synthetic */ ContentResolverSource() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContentResolverSource)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ByteBufferSource
    extends Source
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ByteBuffer mBuffer;

        private void $$robo$$android_graphics_ImageDecoder_ByteBufferSource$__constructor__(ByteBuffer buffer) {
            this.mBuffer = buffer;
        }

        private final ImageDecoder $$robo$$android_graphics_ImageDecoder_ByteBufferSource$createImageDecoder() throws IOException {
            if (!this.mBuffer.isDirect() && this.mBuffer.hasArray()) {
                int offset = this.mBuffer.arrayOffset() + this.mBuffer.position();
                int length = this.mBuffer.limit() - this.mBuffer.position();
                return ImageDecoder.nCreate(this.mBuffer.array(), offset, length, this);
            }
            ByteBuffer buffer = this.mBuffer.slice();
            return ImageDecoder.nCreate(buffer, buffer.position(), buffer.limit(), this);
        }

        private void __constructor__(ByteBuffer byteBuffer) {
            this.$$robo$$android_graphics_ImageDecoder_ByteBufferSource$__constructor__(byteBuffer);
        }

        ByteBufferSource(ByteBuffer byteBuffer) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ImageDecoder_ByteBufferSource$__constructor__(java.nio.ByteBuffer ), 0, this, byteBuffer);
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return InvokeDynamicSupport.bootstrap("createImageDecoder", $$robo$$android_graphics_ImageDecoder_ByteBufferSource$createImageDecoder(), 0, this);
        }

        public /* synthetic */ ByteBufferSource() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ByteBufferSource)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ByteArraySource
    extends Source
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mData;
        private int mOffset;
        private int mLength;

        private void $$robo$$android_graphics_ImageDecoder_ByteArraySource$__constructor__(byte[] data, int offset, int length) {
            this.mData = data;
            this.mOffset = offset;
            this.mLength = length;
        }

        private final ImageDecoder $$robo$$android_graphics_ImageDecoder_ByteArraySource$createImageDecoder() throws IOException {
            return ImageDecoder.nCreate(this.mData, this.mOffset, this.mLength, this);
        }

        private void __constructor__(byte[] byArray, int n, int n2) {
            this.$$robo$$android_graphics_ImageDecoder_ByteArraySource$__constructor__(byArray, n, n2);
        }

        ByteArraySource(byte[] byArray, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ImageDecoder_ByteArraySource$__constructor__(byte[] int int ), 0, this, byArray, n, n2);
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return InvokeDynamicSupport.bootstrap("createImageDecoder", $$robo$$android_graphics_ImageDecoder_ByteArraySource$createImageDecoder(), 0, this);
        }

        public /* synthetic */ ByteArraySource() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ByteArraySource)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Source
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_graphics_ImageDecoder_Source$__constructor__() {
        }

        private final Resources $$robo$$android_graphics_ImageDecoder_Source$getResources() {
            return null;
        }

        private final int $$robo$$android_graphics_ImageDecoder_Source$getDensity() {
            return 0;
        }

        private final int $$robo$$android_graphics_ImageDecoder_Source$computeDstDensity() {
            Resources res = this.getResources();
            if (res == null) {
                return Bitmap.getDefaultDensity();
            }
            return res.getDisplayMetrics().densityDpi;
        }

        abstract ImageDecoder createImageDecoder() throws IOException;

        private /* synthetic */ void $$robo$$android_graphics_ImageDecoder_Source$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_ImageDecoder_Source$__constructor__();
        }

        private Source() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ImageDecoder_Source$__constructor__(), 0, this);
        }

        Resources getResources() {
            return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_graphics_ImageDecoder_Source$getResources(), 0, this);
        }

        int getDensity() {
            return (int)InvokeDynamicSupport.bootstrap("getDensity", $$robo$$android_graphics_ImageDecoder_Source$getDensity(), 0, this);
        }

        int computeDstDensity() {
            return (int)InvokeDynamicSupport.bootstrap("computeDstDensity", $$robo$$android_graphics_ImageDecoder_Source$computeDstDensity(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_graphics_ImageDecoder_Source$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Source)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

