/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.content.res.FontResourcesParser;
import android.graphics.FontFamily;
import android.graphics.FontListParser;
import android.graphics.fonts.FontVariationAxis;
import android.net.Uri;
import android.provider.FontRequest;
import android.provider.FontsContract;
import android.text.FontConfig;
import android.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.LruCache;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.annotation.optimization.CriticalNative;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import libcore.util.NativeAllocationRegistry;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class Typeface
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static NativeAllocationRegistry sRegistry;
    public static Typeface DEFAULT;
    public static Typeface DEFAULT_BOLD;
    public static Typeface SANS_SERIF;
    public static Typeface SERIF;
    public static Typeface MONOSPACE;
    static Typeface[] sDefaults;
    @GuardedBy(value="sStyledCacheLock")
    private static LongSparseArray<SparseArray<Typeface>> sStyledTypefaceCache;
    private static Object sStyledCacheLock;
    @GuardedBy(value="sWeightCacheLock")
    private static LongSparseArray<SparseArray<Typeface>> sWeightTypefaceCache;
    private static Object sWeightCacheLock;
    @GuardedBy(value="sDynamicCacheLock")
    private static LruCache<String, Typeface> sDynamicTypefaceCache;
    private static Object sDynamicCacheLock;
    static Typeface sDefaultTypeface;
    static Map<String, Typeface> sSystemFontMap;
    static Map<String, FontFamily[]> sSystemFallbackMap;
    public long native_instance;
    public static int NORMAL = 0;
    public static int BOLD = 1;
    public static int ITALIC = 2;
    public static int BOLD_ITALIC = 3;
    public static int STYLE_MASK = 3;
    private int mStyle;
    public static int MAX_WEIGHT = 1000;
    private int mWeight;
    public static int RESOLVE_BY_FONT_TABLE = -1;
    private static String DEFAULT_FAMILY = "sans-serif";
    private static int STYLE_NORMAL = 0;
    private static int STYLE_ITALIC = 1;
    private int[] mSupportedAxes;
    private static int[] EMPTY_AXES;

    private static final void $$robo$$android_graphics_Typeface$setDefault(Typeface t) {
        sDefaultTypeface = t;
        Typeface.nativeSetDefault(t.native_instance);
    }

    private final int $$robo$$android_graphics_Typeface$getWeight() {
        return this.mWeight;
    }

    private final int $$robo$$android_graphics_Typeface$getStyle() {
        return this.mStyle;
    }

    private final boolean $$robo$$android_graphics_Typeface$isBold() {
        return (this.mStyle & 1) != 0;
    }

    private final boolean $$robo$$android_graphics_Typeface$isItalic() {
        return (this.mStyle & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Typeface $$robo$$android_graphics_Typeface$createFromResources(AssetManager mgr, String path, int cookie) {
        Object object = sDynamicCacheLock;
        synchronized (object) {
            String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1, "sans-serif");
            Typeface typeface = sDynamicTypefaceCache.get(key);
            if (typeface != null) {
                return typeface;
            }
            FontFamily fontFamily = new FontFamily();
            if (fontFamily.addFontFromAssetManager(mgr, path, cookie, false, 0, -1, -1, null)) {
                if (!fontFamily.freeze()) {
                    return null;
                }
                FontFamily[] families = new FontFamily[]{fontFamily};
                typeface = Typeface.createFromFamiliesWithDefault(families, "sans-serif", -1, -1);
                sDynamicTypefaceCache.put(key, typeface);
                return typeface;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Typeface $$robo$$android_graphics_Typeface$createFromResources(FontResourcesParser.FamilyResourceEntry entry, AssetManager mgr, String path) {
        if (entry instanceof FontResourcesParser.ProviderResourceEntry) {
            FontRequest request;
            Typeface typeface;
            FontResourcesParser.ProviderResourceEntry providerEntry = (FontResourcesParser.ProviderResourceEntry)entry;
            List<List<String>> givenCerts = providerEntry.getCerts();
            ArrayList<List<byte[]>> certs = new ArrayList<List<byte[]>>();
            if (givenCerts != null) {
                for (int i = 0; i < givenCerts.size(); ++i) {
                    List<String> certSet = givenCerts.get(i);
                    ArrayList<byte[]> byteArraySet = new ArrayList<byte[]>();
                    for (int j = 0; j < certSet.size(); ++j) {
                        byteArraySet.add(Base64.decode(certSet.get(j), 0));
                    }
                    certs.add(byteArraySet);
                }
            }
            return (typeface = FontsContract.getFontSync(request = new FontRequest(providerEntry.getAuthority(), providerEntry.getPackage(), providerEntry.getQuery(), certs))) == null ? DEFAULT : typeface;
        }
        Typeface typeface = Typeface.findFromCache(mgr, path);
        if (typeface != null) {
            return typeface;
        }
        FontResourcesParser.FontFamilyFilesResourceEntry filesEntry = (FontResourcesParser.FontFamilyFilesResourceEntry)entry;
        FontFamily fontFamily = new FontFamily();
        for (FontResourcesParser.FontFileResourceEntry fontFile : filesEntry.getEntries()) {
            if (fontFamily.addFontFromAssetManager(mgr, fontFile.getFileName(), 0, false, fontFile.getTtcIndex(), fontFile.getWeight(), fontFile.getItalic(), FontVariationAxis.fromFontVariationSettings(fontFile.getVariationSettings()))) continue;
            return null;
        }
        if (!fontFamily.freeze()) {
            return null;
        }
        FontFamily[] familyChain = new FontFamily[]{fontFamily};
        typeface = Typeface.createFromFamiliesWithDefault(familyChain, "sans-serif", -1, -1);
        Object object = sDynamicCacheLock;
        synchronized (object) {
            String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1, "sans-serif");
            sDynamicTypefaceCache.put(key, typeface);
        }
        return typeface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Typeface $$robo$$android_graphics_Typeface$findFromCache(AssetManager mgr, String path) {
        Object object = sDynamicCacheLock;
        synchronized (object) {
            String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1, "sans-serif");
            Typeface typeface = sDynamicTypefaceCache.get(key);
            if (typeface != null) {
                return typeface;
            }
        }
        return null;
    }

    private static final Typeface $$robo$$android_graphics_Typeface$create(String familyName, int style2) {
        return Typeface.create(sSystemFontMap.get(familyName), style2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Typeface $$robo$$android_graphics_Typeface$create(Typeface family, int style2) {
        Typeface typeface;
        if ((style2 & 0xFFFFFFFC) != 0) {
            style2 = 0;
        }
        if (family == null) {
            family = sDefaultTypeface;
        }
        if (family.mStyle == style2) {
            return family;
        }
        long ni = family.native_instance;
        Object object = sStyledCacheLock;
        synchronized (object) {
            SparseArray<Typeface> styles = sStyledTypefaceCache.get(ni);
            if (styles == null) {
                styles = new SparseArray(4);
                sStyledTypefaceCache.put(ni, styles);
            } else {
                typeface = styles.get(style2);
                if (typeface != null) {
                    return typeface;
                }
            }
            typeface = new Typeface(Typeface.nativeCreateFromTypeface(ni, style2));
            styles.put(style2, typeface);
        }
        return typeface;
    }

    private static final Typeface $$robo$$android_graphics_Typeface$create(Typeface family, int weight, boolean italic) {
        Preconditions.checkArgumentInRange(weight, 0, 1000, "weight");
        if (family == null) {
            family = sDefaultTypeface;
        }
        return Typeface.createWeightStyle(family, weight, italic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Typeface $$robo$$android_graphics_Typeface$createWeightStyle(Typeface base, int weight, boolean italic) {
        Typeface typeface;
        int key = weight << 1 | (italic ? 1 : 0);
        Object object = sWeightCacheLock;
        synchronized (object) {
            SparseArray<Typeface> innerCache = sWeightTypefaceCache.get(base.native_instance);
            if (innerCache == null) {
                innerCache = new SparseArray(4);
                sWeightTypefaceCache.put(base.native_instance, innerCache);
            } else {
                typeface = innerCache.get(key);
                if (typeface != null) {
                    return typeface;
                }
            }
            typeface = new Typeface(Typeface.nativeCreateFromTypefaceWithExactStyle(base.native_instance, weight, italic));
            innerCache.put(key, typeface);
        }
        return typeface;
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromTypefaceWithVariation(Typeface family, List<FontVariationAxis> axes) {
        long ni = family == null ? 0L : family.native_instance;
        return new Typeface(Typeface.nativeCreateFromTypefaceWithVariation(ni, axes));
    }

    private static final Typeface $$robo$$android_graphics_Typeface$defaultFromStyle(int style2) {
        return sDefaults[style2];
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromAsset(AssetManager mgr, String path) {
        Preconditions.checkNotNull(path);
        Preconditions.checkNotNull(mgr);
        Typeface typeface = new Builder(mgr, path).build();
        if (typeface != null) {
            return typeface;
        }
        try {
            InputStream inputStream = mgr.open(path);
            Throwable throwable = null;
            if (inputStream != null) {
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Font asset not found " + path);
        }
        return DEFAULT;
    }

    private static final String $$robo$$android_graphics_Typeface$createProviderUid(String authority, String query) {
        StringBuilder builder = new StringBuilder();
        builder.append("provider:");
        builder.append(authority);
        builder.append("-");
        builder.append(query);
        return builder.toString();
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromFile(File file) {
        Typeface typeface = new Builder(file).build();
        if (typeface != null) {
            return typeface;
        }
        if (!file.exists()) {
            throw new RuntimeException("Font asset not found " + file.getAbsolutePath());
        }
        return DEFAULT;
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromFile(String path) {
        Preconditions.checkNotNull(path);
        return Typeface.createFromFile(new File(path));
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromFamilies(FontFamily[] families) {
        long[] ptrArray = new long[families.length];
        for (int i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray, -1, -1));
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromFamiliesWithDefault(FontFamily[] families, int weight, int italic) {
        return Typeface.createFromFamiliesWithDefault(families, "sans-serif", weight, italic);
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromFamiliesWithDefault(FontFamily[] families, String fallbackName, int weight, int italic) {
        int i;
        FontFamily[] fallback = sSystemFallbackMap.get(fallbackName);
        if (fallback == null) {
            fallback = sSystemFallbackMap.get("sans-serif");
        }
        long[] ptrArray = new long[families.length + fallback.length];
        for (i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        for (i = 0; i < fallback.length; ++i) {
            ptrArray[i + families.length] = fallback[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray, weight, italic));
    }

    private void $$robo$$android_graphics_Typeface$__constructor__(long ni) {
        this.mStyle = 0;
        this.mWeight = 0;
        if (ni == 0L) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = ni;
        sRegistry.registerNativeAllocation((Object)this, this.native_instance);
        this.mStyle = Typeface.nativeGetStyle(ni);
        this.mWeight = Typeface.nativeGetWeight(ni);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final ByteBuffer $$robo$$android_graphics_Typeface$mmap(String fullPath) {
        try (FileInputStream file = new FileInputStream(fullPath);){
            FileChannel fileChannel = file.getChannel();
            long fontSize = fileChannel.size();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
            return mappedByteBuffer;
        }
        catch (IOException e) {
            Log.e(TAG, "Error mapping font file " + fullPath);
            return null;
        }
    }

    private static final FontFamily $$robo$$android_graphics_Typeface$createFontFamily(String familyName, List<FontConfig.Font> fonts, String[] languageTags, int variant, Map<String, ByteBuffer> cache, String fontDir) {
        FontFamily family = new FontFamily(languageTags, variant);
        for (int i = 0; i < fonts.size(); ++i) {
            FontConfig.Font font = fonts.get(i);
            String fullPath = fontDir + font.getFontName();
            ByteBuffer buffer = cache.get(fullPath);
            if (buffer == null) {
                if (cache.containsKey(fullPath)) continue;
                buffer = Typeface.mmap(fullPath);
                cache.put(fullPath, buffer);
                if (buffer == null) continue;
            }
            if (family.addFontFromBuffer(buffer, font.getTtcIndex(), font.getAxes(), font.getWeight(), font.isItalic() ? 1 : 0)) continue;
            Log.e(TAG, "Error creating font " + fullPath + "#" + font.getTtcIndex());
        }
        if (!family.freeze()) {
            Log.e(TAG, "Unable to load Family: " + familyName + " : " + Arrays.toString(languageTags));
            return null;
        }
        return family;
    }

    private static final void $$robo$$android_graphics_Typeface$pushFamilyToFallback(FontConfig.Family xmlFamily, ArrayMap<String, ArrayList<FontFamily>> fallbackMap, Map<String, ByteBuffer> cache, String fontDir) {
        String[] languageTags = xmlFamily.getLanguages();
        int variant = xmlFamily.getVariant();
        ArrayList<FontConfig.Font> defaultFonts = new ArrayList<FontConfig.Font>();
        ArrayMap<String, ArrayList<FontConfig.Font>> specificFallbackFonts = new ArrayMap<String, ArrayList<FontConfig.Font>>();
        for (FontConfig.Font font : xmlFamily.getFonts()) {
            String fallbackName = font.getFallbackFor();
            if (fallbackName == null) {
                defaultFonts.add(font);
                continue;
            }
            ArrayList<FontConfig.Font> fallback = (ArrayList<FontConfig.Font>)specificFallbackFonts.get(fallbackName);
            if (fallback == null) {
                fallback = new ArrayList<FontConfig.Font>();
                specificFallbackFonts.put(fallbackName, fallback);
            }
            fallback.add(font);
        }
        FontFamily defaultFamily = defaultFonts.isEmpty() ? null : Typeface.createFontFamily(xmlFamily.getName(), defaultFonts, languageTags, variant, cache, fontDir);
        for (int i = 0; i < fallbackMap.size(); ++i) {
            ArrayList fallback = (ArrayList)specificFallbackFonts.get(fallbackMap.keyAt(i));
            if (fallback == null) {
                if (defaultFamily == null) continue;
                fallbackMap.valueAt(i).add(defaultFamily);
                continue;
            }
            FontFamily family = Typeface.createFontFamily(xmlFamily.getName(), fallback, languageTags, variant, cache, fontDir);
            if (family != null) {
                fallbackMap.valueAt(i).add(family);
                continue;
            }
            if (defaultFamily == null) continue;
            fallbackMap.valueAt(i).add(defaultFamily);
        }
    }

    @VisibleForTesting
    private static final void $$robo$$android_graphics_Typeface$buildSystemFallback(String xmlPath, String fontDir, ArrayMap<String, Typeface> fontMap, ArrayMap<String, FontFamily[]> fallbackMap) {
        try {
            int i;
            FileInputStream fontsIn = new FileInputStream(xmlPath);
            FontConfig fontConfig = FontListParser.parse(fontsIn);
            HashMap<String, ByteBuffer> bufferCache = new HashMap<String, ByteBuffer>();
            FontConfig.Family[] xmlFamilies = fontConfig.getFamilies();
            ArrayMap<String, ArrayList<FontFamily>> fallbackListMap = new ArrayMap<String, ArrayList<FontFamily>>();
            for (FontConfig.Family xmlFamily : xmlFamilies) {
                FontFamily family;
                String familyName = xmlFamily.getName();
                if (familyName == null || (family = Typeface.createFontFamily(xmlFamily.getName(), Arrays.asList(xmlFamily.getFonts()), xmlFamily.getLanguages(), xmlFamily.getVariant(), bufferCache, fontDir)) == null) continue;
                ArrayList<FontFamily> fallback = new ArrayList<FontFamily>();
                fallback.add(family);
                fallbackListMap.put(familyName, fallback);
            }
            for (i = 0; i < xmlFamilies.length; ++i) {
                FontConfig.Family xmlFamily = xmlFamilies[i];
                if (i != 0 && xmlFamily.getName() != null) continue;
                Typeface.pushFamilyToFallback(xmlFamily, fallbackListMap, bufferCache, fontDir);
            }
            for (i = 0; i < fallbackListMap.size(); ++i) {
                String fallbackName = (String)fallbackListMap.keyAt(i);
                List familyList = fallbackListMap.valueAt(i);
                FontFamily[] families = familyList.toArray(new FontFamily[familyList.size()]);
                fallbackMap.put(fallbackName, families);
                long[] ptrArray = new long[families.length];
                for (int j = 0; j < families.length; ++j) {
                    ptrArray[j] = families[j].mNativePtr;
                }
                fontMap.put(fallbackName, new Typeface(Typeface.nativeCreateFromArray(ptrArray, -1, -1)));
            }
            for (FontConfig.Alias alias : fontConfig.getAliases()) {
                Typeface base;
                Typeface newFace = base = fontMap.get(alias.getToName());
                int weight = alias.getWeight();
                if (weight != 400) {
                    newFace = new Typeface(Typeface.nativeCreateWeightAlias(base.native_instance, weight));
                }
                fontMap.put(alias.getName(), newFace);
            }
        }
        catch (RuntimeException e) {
            Log.w(TAG, "Didn't create default family (most likely, non-Minikin build)", e);
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "Error opening " + xmlPath, e);
        }
        catch (IOException e) {
            Log.e(TAG, "Error reading " + xmlPath, e);
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "XML parse exception for " + xmlPath, e);
        }
    }

    private final boolean $$robo$$android_graphics_Typeface$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Typeface typeface = (Typeface)o;
        return this.mStyle == typeface.mStyle && this.native_instance == typeface.native_instance;
    }

    private final int $$robo$$android_graphics_Typeface$hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.native_instance ^ this.native_instance >>> 32);
        result = 31 * result + this.mStyle;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_graphics_Typeface$isSupportedAxes(int axis) {
        if (this.mSupportedAxes == null) {
            Typeface typeface = this;
            synchronized (typeface) {
                if (this.mSupportedAxes == null) {
                    this.mSupportedAxes = Typeface.nativeGetSupportedAxes(this.native_instance);
                    if (this.mSupportedAxes == null) {
                        this.mSupportedAxes = EMPTY_AXES;
                    }
                }
            }
        }
        return Arrays.binarySearch(this.mSupportedAxes, axis) >= 0;
    }

    private static final long $$robo$$android_graphics_Typeface$nativeCreateFromTypeface(long l, int n) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Typeface$nativeCreateFromTypefaceWithExactStyle(long l, int n, boolean bl) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Typeface$nativeCreateFromTypefaceWithVariation(long l, List<FontVariationAxis> list) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Typeface$nativeCreateWeightAlias(long l, int n) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Typeface$nativeCreateFromArray(long[] lArray, int n, int n2) {
        return 0L;
    }

    private static final int[] $$robo$$android_graphics_Typeface$nativeGetSupportedAxes(long l) {
        return null;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Typeface$nativeSetDefault(long l) {
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Typeface$nativeGetStyle(long l) {
        return 0;
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Typeface$nativeGetWeight(long l) {
        return 0;
    }

    @CriticalNative
    private static final long $$robo$$android_graphics_Typeface$nativeGetReleaseFunc() {
        return 0L;
    }

    static void __staticInitializer__() {
        TAG = "Typeface";
        sRegistry = new NativeAllocationRegistry(Typeface.class.getClassLoader(), Typeface.nativeGetReleaseFunc(), 64L);
        sStyledTypefaceCache = new LongSparseArray(3);
        sStyledCacheLock = new Object();
        sWeightTypefaceCache = new LongSparseArray(3);
        sWeightCacheLock = new Object();
        sDynamicTypefaceCache = new LruCache(16);
        sDynamicCacheLock = new Object();
        EMPTY_AXES = new int[0];
        ArrayMap<String, Typeface> systemFontMap = new ArrayMap<String, Typeface>();
        ArrayMap<String, FontFamily[]> systemFallbackMap = new ArrayMap<String, FontFamily[]>();
        Typeface.buildSystemFallback("/system/etc/fonts.xml", "/system/fonts/", systemFontMap, systemFallbackMap);
        sSystemFontMap = Collections.unmodifiableMap(systemFontMap);
        sSystemFallbackMap = Collections.unmodifiableMap(systemFallbackMap);
        Typeface.setDefault(sSystemFontMap.get("sans-serif"));
        DEFAULT = Typeface.create((String)null, 0);
        DEFAULT_BOLD = Typeface.create((String)null, 1);
        SANS_SERIF = Typeface.create("sans-serif", 0);
        SERIF = Typeface.create("serif", 0);
        MONOSPACE = Typeface.create("monospace", 0);
        sDefaults = new Typeface[]{DEFAULT, DEFAULT_BOLD, Typeface.create((String)null, 2), Typeface.create((String)null, 3)};
    }

    private static void setDefault(Typeface typeface) {
        InvokeDynamicSupport.bootstrapStatic("setDefault", $$robo$$android_graphics_Typeface$setDefault(android.graphics.Typeface ), 0, (Typeface)typeface);
    }

    public int getWeight() {
        return (int)InvokeDynamicSupport.bootstrap("getWeight", $$robo$$android_graphics_Typeface$getWeight(), 0, this);
    }

    public int getStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getStyle", $$robo$$android_graphics_Typeface$getStyle(), 0, this);
    }

    public boolean isBold() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBold", $$robo$$android_graphics_Typeface$isBold(), 0, this);
    }

    public boolean isItalic() {
        return (boolean)InvokeDynamicSupport.bootstrap("isItalic", $$robo$$android_graphics_Typeface$isItalic(), 0, this);
    }

    public static Typeface createFromResources(AssetManager assetManager, String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createFromResources", $$robo$$android_graphics_Typeface$createFromResources(android.content.res.AssetManager java.lang.String int ), 0, (AssetManager)assetManager, (String)string2, (int)n);
    }

    public static Typeface createFromResources(FontResourcesParser.FamilyResourceEntry familyResourceEntry, AssetManager assetManager, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromResources", $$robo$$android_graphics_Typeface$createFromResources(android.content.res.FontResourcesParser$FamilyResourceEntry android.content.res.AssetManager java.lang.String ), 0, (FontResourcesParser.FamilyResourceEntry)familyResourceEntry, (AssetManager)assetManager, (String)string2);
    }

    public static Typeface findFromCache(AssetManager assetManager, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("findFromCache", $$robo$$android_graphics_Typeface$findFromCache(android.content.res.AssetManager java.lang.String ), 0, (AssetManager)assetManager, (String)string2);
    }

    public static Typeface create(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_graphics_Typeface$create(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static Typeface create(Typeface typeface, int n) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_graphics_Typeface$create(android.graphics.Typeface int ), 0, (Typeface)typeface, (int)n);
    }

    public static Typeface create(Typeface typeface, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_graphics_Typeface$create(android.graphics.Typeface int boolean ), 0, (Typeface)typeface, (int)n, (boolean)bl);
    }

    private static Typeface createWeightStyle(Typeface typeface, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createWeightStyle", $$robo$$android_graphics_Typeface$createWeightStyle(android.graphics.Typeface int boolean ), 0, (Typeface)typeface, (int)n, (boolean)bl);
    }

    public static Typeface createFromTypefaceWithVariation(Typeface typeface, List<FontVariationAxis> list) {
        return InvokeDynamicSupport.bootstrapStatic("createFromTypefaceWithVariation", $$robo$$android_graphics_Typeface$createFromTypefaceWithVariation(android.graphics.Typeface java.util.List<android.graphics.fonts.FontVariationAxis> ), 0, (Typeface)typeface, list);
    }

    public static Typeface defaultFromStyle(int n) {
        return InvokeDynamicSupport.bootstrapStatic("defaultFromStyle", $$robo$$android_graphics_Typeface$defaultFromStyle(int ), 0, (int)n);
    }

    public static Typeface createFromAsset(AssetManager assetManager, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromAsset", $$robo$$android_graphics_Typeface$createFromAsset(android.content.res.AssetManager java.lang.String ), 0, (AssetManager)assetManager, (String)string2);
    }

    private static String createProviderUid(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("createProviderUid", $$robo$$android_graphics_Typeface$createProviderUid(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static Typeface createFromFile(File file) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFile", $$robo$$android_graphics_Typeface$createFromFile(java.io.File ), 0, (File)file);
    }

    public static Typeface createFromFile(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFile", $$robo$$android_graphics_Typeface$createFromFile(java.lang.String ), 0, (String)string2);
    }

    private static Typeface createFromFamilies(FontFamily[] fontFamilyArray) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFamilies", $$robo$$android_graphics_Typeface$createFromFamilies(android.graphics.FontFamily[] ), 0, (FontFamily[])fontFamilyArray);
    }

    private static Typeface createFromFamiliesWithDefault(FontFamily[] fontFamilyArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFamiliesWithDefault", $$robo$$android_graphics_Typeface$createFromFamiliesWithDefault(android.graphics.FontFamily[] int int ), 0, (FontFamily[])fontFamilyArray, (int)n, (int)n2);
    }

    private static Typeface createFromFamiliesWithDefault(FontFamily[] fontFamilyArray, String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFamiliesWithDefault", $$robo$$android_graphics_Typeface$createFromFamiliesWithDefault(android.graphics.FontFamily[] java.lang.String int int ), 0, (FontFamily[])fontFamilyArray, (String)string2, (int)n, (int)n2);
    }

    private void __constructor__(long l) {
        this.$$robo$$android_graphics_Typeface$__constructor__(l);
    }

    private Typeface(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Typeface$__constructor__(long ), 0, this, l);
    }

    private static ByteBuffer mmap(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("mmap", $$robo$$android_graphics_Typeface$mmap(java.lang.String ), 0, (String)string2);
    }

    private static FontFamily createFontFamily(String string2, List<FontConfig.Font> list, String[] stringArray, int n, Map<String, ByteBuffer> map, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("createFontFamily", $$robo$$android_graphics_Typeface$createFontFamily(java.lang.String java.util.List<android.text.FontConfig$Font> java.lang.String[] int java.util.Map<java.lang.String, java.nio.ByteBuffer> java.lang.String ), 0, (String)string2, list, (String[])stringArray, (int)n, map, (String)string3);
    }

    private static void pushFamilyToFallback(FontConfig.Family family, ArrayMap<String, ArrayList<FontFamily>> arrayMap, Map<String, ByteBuffer> map, String string2) {
        InvokeDynamicSupport.bootstrapStatic("pushFamilyToFallback", $$robo$$android_graphics_Typeface$pushFamilyToFallback(android.text.FontConfig$Family android.util.ArrayMap<java.lang.String, java.util.ArrayList<android.graphics.FontFamily>> java.util.Map<java.lang.String, java.nio.ByteBuffer> java.lang.String ), 0, (FontConfig.Family)family, arrayMap, map, (String)string2);
    }

    public static void buildSystemFallback(String string2, String string3, ArrayMap<String, Typeface> arrayMap, ArrayMap<String, FontFamily[]> arrayMap2) {
        InvokeDynamicSupport.bootstrapStatic("buildSystemFallback", $$robo$$android_graphics_Typeface$buildSystemFallback(java.lang.String java.lang.String android.util.ArrayMap<java.lang.String, android.graphics.Typeface> android.util.ArrayMap<java.lang.String, android.graphics.FontFamily[]> ), 0, (String)string2, (String)string3, arrayMap, arrayMap2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_graphics_Typeface$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_graphics_Typeface$hashCode(), 0, this);
    }

    public boolean isSupportedAxes(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSupportedAxes", $$robo$$android_graphics_Typeface$isSupportedAxes(int ), 0, this, n);
    }

    private static final native /* synthetic */ long $$robo$$nativeCreateFromTypeface$nativeBinding(long var0, int var2);

    private static long nativeCreateFromTypeface(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateFromTypeface", $$robo$$android_graphics_Typeface$nativeCreateFromTypeface(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ long $$robo$$nativeCreateFromTypefaceWithExactStyle$nativeBinding(long var0, int var2, boolean var3);

    private static long nativeCreateFromTypefaceWithExactStyle(long l, int n, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateFromTypefaceWithExactStyle", $$robo$$android_graphics_Typeface$nativeCreateFromTypefaceWithExactStyle(long int boolean ), 1, (long)l, (int)n, (boolean)bl);
    }

    private static final native /* synthetic */ long $$robo$$nativeCreateFromTypefaceWithVariation$nativeBinding(long var0, List<FontVariationAxis> var2);

    private static long nativeCreateFromTypefaceWithVariation(long l, List<FontVariationAxis> list) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateFromTypefaceWithVariation", $$robo$$android_graphics_Typeface$nativeCreateFromTypefaceWithVariation(long java.util.List<android.graphics.fonts.FontVariationAxis> ), 1, (long)l, list);
    }

    private static final native /* synthetic */ long $$robo$$nativeCreateWeightAlias$nativeBinding(long var0, int var2);

    private static long nativeCreateWeightAlias(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateWeightAlias", $$robo$$android_graphics_Typeface$nativeCreateWeightAlias(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ long $$robo$$nativeCreateFromArray$nativeBinding(long[] var0, int var1, int var2);

    private static long nativeCreateFromArray(long[] lArray, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateFromArray", $$robo$$android_graphics_Typeface$nativeCreateFromArray(long[] int int ), 1, (long[])lArray, (int)n, (int)n2);
    }

    private static final native /* synthetic */ int[] $$robo$$nativeGetSupportedAxes$nativeBinding(long var0);

    private static int[] nativeGetSupportedAxes(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetSupportedAxes", $$robo$$android_graphics_Typeface$nativeGetSupportedAxes(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetDefault$nativeBinding(long var0);

    private static void nativeSetDefault(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetDefault", $$robo$$android_graphics_Typeface$nativeSetDefault(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetStyle$nativeBinding(long var0);

    private static int nativeGetStyle(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetStyle", $$robo$$android_graphics_Typeface$nativeGetStyle(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetWeight$nativeBinding(long var0);

    private static int nativeGetWeight(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetWeight", $$robo$$android_graphics_Typeface$nativeGetWeight(long ), 1, (long)l);
    }

    private static final native /* synthetic */ long $$robo$$nativeGetReleaseFunc$nativeBinding();

    private static long nativeGetReleaseFunc() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeGetReleaseFunc", $$robo$$android_graphics_Typeface$nativeGetReleaseFunc(), 1);
    }

    static {
        RobolectricInternals.classInitializing(Typeface.class);
    }

    public /* synthetic */ Typeface() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Typeface)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int NORMAL_WEIGHT = 400;
        public static int BOLD_WEIGHT = 700;
        private int mTtcIndex;
        private FontVariationAxis[] mAxes;
        private AssetManager mAssetManager;
        private String mPath;
        private FileDescriptor mFd;
        private FontsContract.FontInfo[] mFonts;
        private Map<Uri, ByteBuffer> mFontBuffers;
        private String mFallbackFamilyName;
        private int mWeight;
        private int mItalic;

        private void $$robo$$android_graphics_Typeface_Builder$__constructor__(File path) {
            this.mWeight = -1;
            this.mItalic = -1;
            this.mPath = path.getAbsolutePath();
        }

        private void $$robo$$android_graphics_Typeface_Builder$__constructor__(FileDescriptor fd) {
            this.mWeight = -1;
            this.mItalic = -1;
            this.mFd = fd;
        }

        private void $$robo$$android_graphics_Typeface_Builder$__constructor__(String path) {
            this.mWeight = -1;
            this.mItalic = -1;
            this.mPath = path;
        }

        private void $$robo$$android_graphics_Typeface_Builder$__constructor__(AssetManager assetManager, String path) {
            this.mWeight = -1;
            this.mItalic = -1;
            this.mAssetManager = Preconditions.checkNotNull(assetManager);
            this.mPath = Preconditions.checkStringNotEmpty(path);
        }

        private void $$robo$$android_graphics_Typeface_Builder$__constructor__(FontsContract.FontInfo[] fonts, Map<Uri, ByteBuffer> buffers) {
            this.mWeight = -1;
            this.mItalic = -1;
            this.mFonts = fonts;
            this.mFontBuffers = buffers;
        }

        private final Builder $$robo$$android_graphics_Typeface_Builder$setWeight(int weight) {
            this.mWeight = weight;
            return this;
        }

        private final Builder $$robo$$android_graphics_Typeface_Builder$setItalic(boolean italic) {
            this.mItalic = italic ? 1 : 0;
            return this;
        }

        private final Builder $$robo$$android_graphics_Typeface_Builder$setTtcIndex(int ttcIndex) {
            if (this.mFonts != null) {
                throw new IllegalArgumentException("TTC index can not be specified for FontResult source.");
            }
            this.mTtcIndex = ttcIndex;
            return this;
        }

        private final Builder $$robo$$android_graphics_Typeface_Builder$setFontVariationSettings(String variationSettings) {
            if (this.mFonts != null) {
                throw new IllegalArgumentException("Font variation settings can not be specified for FontResult source.");
            }
            if (this.mAxes != null) {
                throw new IllegalStateException("Font variation settings are already set.");
            }
            this.mAxes = FontVariationAxis.fromFontVariationSettings(variationSettings);
            return this;
        }

        private final Builder $$robo$$android_graphics_Typeface_Builder$setFontVariationSettings(FontVariationAxis[] axes) {
            if (this.mFonts != null) {
                throw new IllegalArgumentException("Font variation settings can not be specified for FontResult source.");
            }
            if (this.mAxes != null) {
                throw new IllegalStateException("Font variation settings are already set.");
            }
            this.mAxes = axes;
            return this;
        }

        private final Builder $$robo$$android_graphics_Typeface_Builder$setFallback(String familyName) {
            this.mFallbackFamilyName = familyName;
            return this;
        }

        private static final String $$robo$$android_graphics_Typeface_Builder$createAssetUid(AssetManager mgr, String path, int ttcIndex, FontVariationAxis[] axes, int weight, int italic, String fallback) {
            SparseArray<String> pkgs = mgr.getAssignedPackageIdentifiers();
            StringBuilder builder = new StringBuilder();
            int size = pkgs.size();
            for (int i = 0; i < size; ++i) {
                builder.append(pkgs.valueAt(i));
                builder.append("-");
            }
            builder.append(path);
            builder.append("-");
            builder.append(Integer.toString(ttcIndex));
            builder.append("-");
            builder.append(Integer.toString(weight));
            builder.append("-");
            builder.append(Integer.toString(italic));
            builder.append("--");
            builder.append(fallback);
            builder.append("--");
            if (axes != null) {
                for (FontVariationAxis axis : axes) {
                    builder.append(axis.getTag());
                    builder.append("-");
                    builder.append(Float.toString(axis.getStyleValue()));
                }
            }
            return builder.toString();
        }

        private final Typeface $$robo$$android_graphics_Typeface_Builder$resolveFallbackTypeface() {
            int weight;
            if (this.mFallbackFamilyName == null) {
                return null;
            }
            Typeface base = sSystemFontMap.get(this.mFallbackFamilyName);
            if (base == null) {
                base = sDefaultTypeface;
            }
            if (this.mWeight == -1 && this.mItalic == -1) {
                return base;
            }
            int n = weight = this.mWeight == -1 ? base.mWeight : this.mWeight;
            boolean italic = this.mItalic == -1 ? (base.mStyle & 2) != 0 : this.mItalic == 1;
            return Typeface.createWeightStyle(base, weight, italic);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final Typeface $$robo$$android_graphics_Typeface_Builder$build() {
            if (this.mFd != null) {
                try (FileInputStream fis = new FileInputStream(this.mFd);){
                    FileChannel channel = fis.getChannel();
                    long size = channel.size();
                    MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                    FontFamily fontFamily = new FontFamily();
                    if (!fontFamily.addFontFromBuffer(buffer, this.mTtcIndex, this.mAxes, this.mWeight, this.mItalic)) {
                        fontFamily.abortCreation();
                        Typeface typeface = this.resolveFallbackTypeface();
                        return typeface;
                    }
                    if (!fontFamily.freeze()) {
                        Typeface typeface = this.resolveFallbackTypeface();
                        return typeface;
                    }
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    Typeface typeface = Typeface.createFromFamiliesWithDefault(families, this.mFallbackFamilyName, this.mWeight, this.mItalic);
                    return typeface;
                }
                catch (IOException e) {
                    return this.resolveFallbackTypeface();
                }
            }
            if (this.mAssetManager != null) {
                String key = Builder.createAssetUid(this.mAssetManager, this.mPath, this.mTtcIndex, this.mAxes, this.mWeight, this.mItalic, this.mFallbackFamilyName);
                Object object = sDynamicCacheLock;
                synchronized (object) {
                    Typeface typeface = (Typeface)sDynamicTypefaceCache.get(key);
                    if (typeface != null) {
                        return typeface;
                    }
                    FontFamily fontFamily = new FontFamily();
                    if (!fontFamily.addFontFromAssetManager(this.mAssetManager, this.mPath, this.mTtcIndex, true, this.mTtcIndex, this.mWeight, this.mItalic, this.mAxes)) {
                        fontFamily.abortCreation();
                        return this.resolveFallbackTypeface();
                    }
                    if (!fontFamily.freeze()) {
                        return this.resolveFallbackTypeface();
                    }
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families, this.mFallbackFamilyName, this.mWeight, this.mItalic);
                    sDynamicTypefaceCache.put(key, typeface);
                    return typeface;
                }
            }
            if (this.mPath != null) {
                FontFamily fontFamily = new FontFamily();
                if (!fontFamily.addFont(this.mPath, this.mTtcIndex, this.mAxes, this.mWeight, this.mItalic)) {
                    fontFamily.abortCreation();
                    return this.resolveFallbackTypeface();
                }
                if (!fontFamily.freeze()) {
                    return this.resolveFallbackTypeface();
                }
                FontFamily[] families = new FontFamily[]{fontFamily};
                return Typeface.createFromFamiliesWithDefault(families, this.mFallbackFamilyName, this.mWeight, this.mItalic);
            }
            if (this.mFonts == null) throw new IllegalArgumentException("No source was set.");
            FontFamily fontFamily = new FontFamily();
            boolean atLeastOneFont = false;
            for (FontsContract.FontInfo font : this.mFonts) {
                ByteBuffer fontBuffer = this.mFontBuffers.get(font.getUri());
                if (fontBuffer == null) continue;
                boolean success = fontFamily.addFontFromBuffer(fontBuffer, font.getTtcIndex(), font.getAxes(), font.getWeight(), font.isItalic() ? 1 : 0);
                if (!success) {
                    fontFamily.abortCreation();
                    return null;
                }
                atLeastOneFont = true;
            }
            if (!atLeastOneFont) {
                fontFamily.abortCreation();
                return null;
            }
            fontFamily.freeze();
            FontFamily[] families = new FontFamily[]{fontFamily};
            return Typeface.createFromFamiliesWithDefault(families, this.mFallbackFamilyName, this.mWeight, this.mItalic);
        }

        private void __constructor__(File file) {
            this.$$robo$$android_graphics_Typeface_Builder$__constructor__(file);
        }

        public Builder(File file) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Typeface_Builder$__constructor__(java.io.File ), 0, this, file);
        }

        private void __constructor__(FileDescriptor fileDescriptor) {
            this.$$robo$$android_graphics_Typeface_Builder$__constructor__(fileDescriptor);
        }

        public Builder(FileDescriptor fileDescriptor) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Typeface_Builder$__constructor__(java.io.FileDescriptor ), 0, this, fileDescriptor);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_graphics_Typeface_Builder$__constructor__(string2);
        }

        public Builder(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Typeface_Builder$__constructor__(java.lang.String ), 0, this, string2);
        }

        private void __constructor__(AssetManager assetManager, String string2) {
            this.$$robo$$android_graphics_Typeface_Builder$__constructor__(assetManager, string2);
        }

        public Builder(AssetManager assetManager, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Typeface_Builder$__constructor__(android.content.res.AssetManager java.lang.String ), 0, this, assetManager, string2);
        }

        private void __constructor__(FontsContract.FontInfo[] fontInfoArray, Map<Uri, ByteBuffer> map) {
            this.$$robo$$android_graphics_Typeface_Builder$__constructor__(fontInfoArray, map);
        }

        public Builder(FontsContract.FontInfo[] fontInfoArray, Map<Uri, ByteBuffer> map) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Typeface_Builder$__constructor__(android.provider.FontsContract$FontInfo[] java.util.Map<android.net.Uri, java.nio.ByteBuffer> ), 0, this, fontInfoArray, map);
        }

        public Builder setWeight(int n) {
            return InvokeDynamicSupport.bootstrap("setWeight", $$robo$$android_graphics_Typeface_Builder$setWeight(int ), 0, this, n);
        }

        public Builder setItalic(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setItalic", $$robo$$android_graphics_Typeface_Builder$setItalic(boolean ), 0, this, bl);
        }

        public Builder setTtcIndex(int n) {
            return InvokeDynamicSupport.bootstrap("setTtcIndex", $$robo$$android_graphics_Typeface_Builder$setTtcIndex(int ), 0, this, n);
        }

        public Builder setFontVariationSettings(String string2) {
            return InvokeDynamicSupport.bootstrap("setFontVariationSettings", $$robo$$android_graphics_Typeface_Builder$setFontVariationSettings(java.lang.String ), 0, this, string2);
        }

        public Builder setFontVariationSettings(FontVariationAxis[] fontVariationAxisArray) {
            return InvokeDynamicSupport.bootstrap("setFontVariationSettings", $$robo$$android_graphics_Typeface_Builder$setFontVariationSettings(android.graphics.fonts.FontVariationAxis[] ), 0, this, fontVariationAxisArray);
        }

        public Builder setFallback(String string2) {
            return InvokeDynamicSupport.bootstrap("setFallback", $$robo$$android_graphics_Typeface_Builder$setFallback(java.lang.String ), 0, this, string2);
        }

        private static String createAssetUid(AssetManager assetManager, String string2, int n, FontVariationAxis[] fontVariationAxisArray, int n2, int n3, String string3) {
            return InvokeDynamicSupport.bootstrapStatic("createAssetUid", $$robo$$android_graphics_Typeface_Builder$createAssetUid(android.content.res.AssetManager java.lang.String int android.graphics.fonts.FontVariationAxis[] int int java.lang.String ), 0, (AssetManager)assetManager, (String)string2, (int)n, (FontVariationAxis[])fontVariationAxisArray, (int)n2, (int)n3, (String)string3);
        }

        private Typeface resolveFallbackTypeface() {
            return InvokeDynamicSupport.bootstrap("resolveFallbackTypeface", $$robo$$android_graphics_Typeface_Builder$resolveFallbackTypeface(), 0, this);
        }

        public Typeface build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_graphics_Typeface_Builder$build(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Style {
    }
}

