/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ImageDecoder;
import android.graphics.Rect;
import android.graphics.drawable.Animatable2;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.TypedValue;
import com.android.internal.R;
import dalvik.annotation.optimization.FastNative;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import libcore.util.NativeAllocationRegistry;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedImageDrawable
extends Drawable
implements Animatable2,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mIntrinsicWidth;
    private int mIntrinsicHeight;
    private boolean mStarting;
    private Handler mHandler;
    private State mState;
    private Runnable mRunnable;
    private ColorFilter mColorFilter;
    public static int REPEAT_INFINITE = -1;
    @Deprecated
    public static int LOOP_INFINITE = -1;
    private static int REPEAT_UNDEFINED = -2;
    private static int FINISHED = -1;
    private ArrayList<Animatable2.AnimationCallback> mAnimationCallbacks;

    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$setRepeatCount(int repeatCount) {
        if (repeatCount < -1) {
            throw new IllegalArgumentException("invalid value passed to setRepeatCount" + repeatCount);
        }
        if (this.mState.mRepeatCount != repeatCount) {
            this.mState.mRepeatCount = repeatCount;
            if (this.mState.mNativePtr != 0L) {
                AnimatedImageDrawable.nSetRepeatCount(this.mState.mNativePtr, repeatCount);
            }
        }
    }

    @Deprecated
    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$setLoopCount(int loopCount) {
        this.setRepeatCount(loopCount);
    }

    private final int $$robo$$android_graphics_drawable_AnimatedImageDrawable$getRepeatCount() {
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called getRepeatCount on empty AnimatedImageDrawable");
        }
        if (this.mState.mRepeatCount == -2) {
            this.mState.mRepeatCount = AnimatedImageDrawable.nGetRepeatCount(this.mState.mNativePtr);
        }
        return this.mState.mRepeatCount;
    }

    @Deprecated
    private final int $$robo$$android_graphics_drawable_AnimatedImageDrawable$getLoopCount(int loopCount) {
        return this.getRepeatCount();
    }

    private void $$robo$$android_graphics_drawable_AnimatedImageDrawable$__constructor__() {
        this.mAnimationCallbacks = null;
        this.mState = new State(this, 0L, null, null);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = AnimatedImageDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimatedImageDrawable);
        this.updateStateFromTypedArray(a, this.mSrcDensityOverride);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$updateStateFromTypedArray(TypedArray a, int srcDensityOverride) throws XmlPullParserException {
        boolean autoStart;
        State oldState = this.mState;
        Resources r = a.getResources();
        int srcResId = a.getResourceId(0, 0);
        if (srcResId != 0) {
            TypedValue value = new TypedValue();
            r.getValueForDensity(srcResId, srcDensityOverride, value, true);
            if (srcDensityOverride > 0 && value.density > 0 && value.density != 65535) {
                value.density = value.density == srcDensityOverride ? r.getDisplayMetrics().densityDpi : value.density * r.getDisplayMetrics().densityDpi / srcDensityOverride;
            }
            int density = 0;
            if (value.density == 0) {
                density = 160;
            } else if (value.density != 65535) {
                density = value.density;
            }
            Drawable drawable2 = null;
            try {
                InputStream is = r.openRawResource(srcResId, value);
                ImageDecoder.Source source = ImageDecoder.createSource(r, is, density);
                drawable2 = ImageDecoder.decodeDrawable(source, (decoder, info, src) -> {
                    if (!info.isAnimated()) {
                        throw new IllegalArgumentException("image is not animated");
                    }
                });
            }
            catch (IOException e) {
                throw new XmlPullParserException(a.getPositionDescription() + ": <animated-image> requires a valid 'src' attribute", null, e);
            }
            if (!(drawable2 instanceof AnimatedImageDrawable)) {
                throw new XmlPullParserException(a.getPositionDescription() + ": <animated-image> did not decode animated");
            }
            int repeatCount = this.mState.mRepeatCount;
            AnimatedImageDrawable other = (AnimatedImageDrawable)drawable2;
            this.mState = other.mState;
            other.mState = null;
            this.mIntrinsicWidth = other.mIntrinsicWidth;
            this.mIntrinsicHeight = other.mIntrinsicHeight;
            if (repeatCount != -2) {
                this.setRepeatCount(repeatCount);
            }
        }
        this.mState.mThemeAttrs = a.extractThemeAttrs();
        if (this.mState.mNativePtr == 0L && (this.mState.mThemeAttrs == null || this.mState.mThemeAttrs[0] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <animated-image> requires a valid 'src' attribute");
        }
        this.mState.mAutoMirrored = a.getBoolean(3, oldState.mAutoMirrored);
        int repeatCount = a.getInt(1, -2);
        if (repeatCount != -2) {
            this.setRepeatCount(repeatCount);
        }
        if ((autoStart = a.getBoolean(2, false)) && this.mState.mNativePtr != 0L) {
            this.start();
        }
    }

    private void $$robo$$android_graphics_drawable_AnimatedImageDrawable$__constructor__(long nativeImageDecoder, ImageDecoder decoder, int width, int height, int srcDensity, int dstDensity, Rect cropRect, InputStream inputStream, AssetFileDescriptor afd) throws IOException {
        this.mAnimationCallbacks = null;
        width = Bitmap.scaleFromDensity(width, srcDensity, dstDensity);
        height = Bitmap.scaleFromDensity(height, srcDensity, dstDensity);
        if (cropRect == null) {
            this.mIntrinsicWidth = width;
            this.mIntrinsicHeight = height;
        } else {
            cropRect.set(Bitmap.scaleFromDensity(cropRect.left, srcDensity, dstDensity), Bitmap.scaleFromDensity(cropRect.top, srcDensity, dstDensity), Bitmap.scaleFromDensity(cropRect.right, srcDensity, dstDensity), Bitmap.scaleFromDensity(cropRect.bottom, srcDensity, dstDensity));
            this.mIntrinsicWidth = cropRect.width();
            this.mIntrinsicHeight = cropRect.height();
        }
        this.mState = new State(this, AnimatedImageDrawable.nCreate(nativeImageDecoder, decoder, width, height, cropRect), inputStream, afd);
        long nativeSize = AnimatedImageDrawable.nNativeByteSize(this.mState.mNativePtr);
        NativeAllocationRegistry registry = new NativeAllocationRegistry(AnimatedImageDrawable.class.getClassLoader(), AnimatedImageDrawable.nGetNativeFinalizer(), nativeSize);
        registry.registerNativeAllocation((Object)this.mState, this.mState.mNativePtr);
    }

    private final int $$robo$$android_graphics_drawable_AnimatedImageDrawable$getIntrinsicWidth() {
        return this.mIntrinsicWidth;
    }

    private final int $$robo$$android_graphics_drawable_AnimatedImageDrawable$getIntrinsicHeight() {
        return this.mIntrinsicHeight;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$draw(Canvas canvas) {
        long nextUpdate;
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called draw on empty AnimatedImageDrawable");
        }
        if (this.mStarting) {
            this.mStarting = false;
            this.postOnAnimationStart();
        }
        if ((nextUpdate = AnimatedImageDrawable.nDraw(this.mState.mNativePtr, canvas.getNativeCanvasWrapper())) > 0L) {
            if (this.mRunnable == null) {
                this.mRunnable = this::invalidateSelf;
            }
            this.scheduleSelf(this.mRunnable, nextUpdate + SystemClock.uptimeMillis());
        } else if (nextUpdate == -1L) {
            this.postOnAnimationEnd();
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$setAlpha(int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Alpha must be between 0 and 255! provided " + alpha);
        }
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called setAlpha on empty AnimatedImageDrawable");
        }
        AnimatedImageDrawable.nSetAlpha(this.mState.mNativePtr, alpha);
        this.invalidateSelf();
    }

    private final int $$robo$$android_graphics_drawable_AnimatedImageDrawable$getAlpha() {
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called getAlpha on empty AnimatedImageDrawable");
        }
        return AnimatedImageDrawable.nGetAlpha(this.mState.mNativePtr);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$setColorFilter(ColorFilter colorFilter) {
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called setColorFilter on empty AnimatedImageDrawable");
        }
        if (colorFilter != this.mColorFilter) {
            this.mColorFilter = colorFilter;
            long nativeFilter = colorFilter == null ? 0L : colorFilter.getNativeInstance();
            AnimatedImageDrawable.nSetColorFilter(this.mState.mNativePtr, nativeFilter);
            this.invalidateSelf();
        }
    }

    private final ColorFilter $$robo$$android_graphics_drawable_AnimatedImageDrawable$getColorFilter() {
        return this.mColorFilter;
    }

    private final int $$robo$$android_graphics_drawable_AnimatedImageDrawable$getOpacity() {
        return -3;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$setAutoMirrored(boolean mirrored) {
        if (this.mState.mAutoMirrored != mirrored) {
            this.mState.mAutoMirrored = mirrored;
            if (this.getLayoutDirection() == 1 && this.mState.mNativePtr != 0L) {
                AnimatedImageDrawable.nSetMirrored(this.mState.mNativePtr, mirrored);
                this.invalidateSelf();
            }
        }
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedImageDrawable$onLayoutDirectionChanged(int layoutDirection) {
        if (!this.mState.mAutoMirrored || this.mState.mNativePtr == 0L) {
            return false;
        }
        boolean mirror = layoutDirection == 1;
        AnimatedImageDrawable.nSetMirrored(this.mState.mNativePtr, mirror);
        return true;
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedImageDrawable$isAutoMirrored() {
        return this.mState.mAutoMirrored;
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedImageDrawable$isRunning() {
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called isRunning on empty AnimatedImageDrawable");
        }
        return AnimatedImageDrawable.nIsRunning(this.mState.mNativePtr);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$start() {
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called start on empty AnimatedImageDrawable");
        }
        if (AnimatedImageDrawable.nStart(this.mState.mNativePtr)) {
            this.mStarting = true;
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$stop() {
        if (this.mState.mNativePtr == 0L) {
            throw new IllegalStateException("called stop on empty AnimatedImageDrawable");
        }
        if (AnimatedImageDrawable.nStop(this.mState.mNativePtr)) {
            this.postOnAnimationEnd();
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$registerAnimationCallback(Animatable2.AnimationCallback callback) {
        if (callback == null) {
            return;
        }
        if (this.mAnimationCallbacks == null) {
            this.mAnimationCallbacks = new ArrayList();
            AnimatedImageDrawable.nSetOnAnimationEndListener(this.mState.mNativePtr, this);
        }
        if (!this.mAnimationCallbacks.contains(callback)) {
            this.mAnimationCallbacks.add(callback);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedImageDrawable$unregisterAnimationCallback(Animatable2.AnimationCallback callback) {
        if (callback == null || this.mAnimationCallbacks == null || !this.mAnimationCallbacks.remove(callback)) {
            return false;
        }
        if (this.mAnimationCallbacks.isEmpty()) {
            this.clearAnimationCallbacks();
        }
        return true;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$clearAnimationCallbacks() {
        if (this.mAnimationCallbacks != null) {
            this.mAnimationCallbacks = null;
            AnimatedImageDrawable.nSetOnAnimationEndListener(this.mState.mNativePtr, null);
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$postOnAnimationStart() {
        if (this.mAnimationCallbacks == null) {
            return;
        }
        this.getHandler().post(() -> {
            for (Animatable2.AnimationCallback callback : this.mAnimationCallbacks) {
                callback.onAnimationStart(this);
            }
        });
    }

    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$postOnAnimationEnd() {
        if (this.mAnimationCallbacks == null) {
            return;
        }
        this.getHandler().post(() -> {
            for (Animatable2.AnimationCallback callback : this.mAnimationCallbacks) {
                callback.onAnimationEnd(this);
            }
        });
    }

    private final Handler $$robo$$android_graphics_drawable_AnimatedImageDrawable$getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        return this.mHandler;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$onAnimationEnd() {
        if (this.mAnimationCallbacks != null) {
            for (Animatable2.AnimationCallback callback : this.mAnimationCallbacks) {
                callback.onAnimationEnd(this);
            }
        }
    }

    private static final long $$robo$$android_graphics_drawable_AnimatedImageDrawable$nCreate(long l, ImageDecoder imageDecoder, int n, int n2, Rect rect) throws IOException {
        return 0L;
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_AnimatedImageDrawable$nGetNativeFinalizer() {
        return 0L;
    }

    private static final long $$robo$$android_graphics_drawable_AnimatedImageDrawable$nDraw(long l, long l2) {
        return 0L;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$nSetAlpha(long l, int n) {
    }

    @FastNative
    private static final int $$robo$$android_graphics_drawable_AnimatedImageDrawable$nGetAlpha(long l) {
        return 0;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$nSetColorFilter(long l, long l2) {
    }

    @FastNative
    private static final boolean $$robo$$android_graphics_drawable_AnimatedImageDrawable$nIsRunning(long l) {
        return false;
    }

    @FastNative
    private static final boolean $$robo$$android_graphics_drawable_AnimatedImageDrawable$nStart(long l) {
        return false;
    }

    @FastNative
    private static final boolean $$robo$$android_graphics_drawable_AnimatedImageDrawable$nStop(long l) {
        return false;
    }

    @FastNative
    private static final int $$robo$$android_graphics_drawable_AnimatedImageDrawable$nGetRepeatCount(long l) {
        return 0;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$nSetRepeatCount(long l, int n) {
    }

    private static final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$nSetOnAnimationEndListener(long l, AnimatedImageDrawable animatedImageDrawable) {
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_AnimatedImageDrawable$nNativeByteSize(long l) {
        return 0L;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_AnimatedImageDrawable$nSetMirrored(long l, boolean bl) {
    }

    public void setRepeatCount(int n) {
        InvokeDynamicSupport.bootstrap("setRepeatCount", $$robo$$android_graphics_drawable_AnimatedImageDrawable$setRepeatCount(int ), 0, this, n);
    }

    @Deprecated
    public void setLoopCount(int n) {
        InvokeDynamicSupport.bootstrap("setLoopCount", $$robo$$android_graphics_drawable_AnimatedImageDrawable$setLoopCount(int ), 0, this, n);
    }

    public int getRepeatCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRepeatCount", $$robo$$android_graphics_drawable_AnimatedImageDrawable$getRepeatCount(), 0, this);
    }

    @Deprecated
    public int getLoopCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLoopCount", $$robo$$android_graphics_drawable_AnimatedImageDrawable$getLoopCount(int ), 0, this, n);
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_AnimatedImageDrawable$__constructor__();
    }

    public AnimatedImageDrawable() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedImageDrawable$__constructor__(), 0, this);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_AnimatedImageDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray, int n) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_AnimatedImageDrawable$updateStateFromTypedArray(android.content.res.TypedArray int ), 0, this, typedArray, n);
    }

    private void __constructor__(long l, ImageDecoder imageDecoder, int n, int n2, int n3, int n4, Rect rect, InputStream inputStream, AssetFileDescriptor assetFileDescriptor) throws IOException {
        this.$$robo$$android_graphics_drawable_AnimatedImageDrawable$__constructor__(l, imageDecoder, n, n2, n3, n4, rect, inputStream, assetFileDescriptor);
    }

    public AnimatedImageDrawable(long l, ImageDecoder imageDecoder, int n, int n2, int n3, int n4, Rect rect, InputStream inputStream, AssetFileDescriptor assetFileDescriptor) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedImageDrawable$__constructor__(long android.graphics.ImageDecoder int int int int android.graphics.Rect java.io.InputStream android.content.res.AssetFileDescriptor ), 0, this, l, imageDecoder, n, n2, n3, n4, rect, inputStream, assetFileDescriptor);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_AnimatedImageDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_AnimatedImageDrawable$getIntrinsicHeight(), 0, this);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_AnimatedImageDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_AnimatedImageDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_AnimatedImageDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_AnimatedImageDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public ColorFilter getColorFilter() {
        return InvokeDynamicSupport.bootstrap("getColorFilter", $$robo$$android_graphics_drawable_AnimatedImageDrawable$getColorFilter(), 0, this);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_AnimatedImageDrawable$getOpacity(), 0, this);
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoMirrored", $$robo$$android_graphics_drawable_AnimatedImageDrawable$setAutoMirrored(boolean ), 0, this, bl);
    }

    @Override
    public boolean onLayoutDirectionChanged(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLayoutDirectionChanged", $$robo$$android_graphics_drawable_AnimatedImageDrawable$onLayoutDirectionChanged(int ), 0, this, n);
    }

    @Override
    public boolean isAutoMirrored() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutoMirrored", $$robo$$android_graphics_drawable_AnimatedImageDrawable$isAutoMirrored(), 0, this);
    }

    @Override
    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_graphics_drawable_AnimatedImageDrawable$isRunning(), 0, this);
    }

    @Override
    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_AnimatedImageDrawable$start(), 0, this);
    }

    @Override
    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_graphics_drawable_AnimatedImageDrawable$stop(), 0, this);
    }

    @Override
    public void registerAnimationCallback(Animatable2.AnimationCallback animationCallback) {
        InvokeDynamicSupport.bootstrap("registerAnimationCallback", $$robo$$android_graphics_drawable_AnimatedImageDrawable$registerAnimationCallback(android.graphics.drawable.Animatable2$AnimationCallback ), 0, this, animationCallback);
    }

    @Override
    public boolean unregisterAnimationCallback(Animatable2.AnimationCallback animationCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("unregisterAnimationCallback", $$robo$$android_graphics_drawable_AnimatedImageDrawable$unregisterAnimationCallback(android.graphics.drawable.Animatable2$AnimationCallback ), 0, this, animationCallback);
    }

    @Override
    public void clearAnimationCallbacks() {
        InvokeDynamicSupport.bootstrap("clearAnimationCallbacks", $$robo$$android_graphics_drawable_AnimatedImageDrawable$clearAnimationCallbacks(), 0, this);
    }

    private void postOnAnimationStart() {
        InvokeDynamicSupport.bootstrap("postOnAnimationStart", $$robo$$android_graphics_drawable_AnimatedImageDrawable$postOnAnimationStart(), 0, this);
    }

    private void postOnAnimationEnd() {
        InvokeDynamicSupport.bootstrap("postOnAnimationEnd", $$robo$$android_graphics_drawable_AnimatedImageDrawable$postOnAnimationEnd(), 0, this);
    }

    private Handler getHandler() {
        return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_graphics_drawable_AnimatedImageDrawable$getHandler(), 0, this);
    }

    private void onAnimationEnd() {
        InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_graphics_drawable_AnimatedImageDrawable$onAnimationEnd(), 0, this);
    }

    private static final native /* synthetic */ long $$robo$$nCreate$nativeBinding(long var0, ImageDecoder var2, int var3, int var4, Rect var5) throws IOException;

    private static long nCreate(long l, ImageDecoder imageDecoder, int n, int n2, Rect rect) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreate", $$robo$$android_graphics_drawable_AnimatedImageDrawable$nCreate(long android.graphics.ImageDecoder int int android.graphics.Rect ), 1, (long)l, (ImageDecoder)imageDecoder, (int)n, (int)n2, (Rect)rect);
    }

    private static final native /* synthetic */ long $$robo$$nGetNativeFinalizer$nativeBinding();

    private static long nGetNativeFinalizer() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nGetNativeFinalizer", $$robo$$android_graphics_drawable_AnimatedImageDrawable$nGetNativeFinalizer(), 1);
    }

    private static final native /* synthetic */ long $$robo$$nDraw$nativeBinding(long var0, long var2);

    private static long nDraw(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nDraw", $$robo$$android_graphics_drawable_AnimatedImageDrawable$nDraw(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nSetAlpha$nativeBinding(long var0, int var2);

    private static void nSetAlpha(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetAlpha", $$robo$$android_graphics_drawable_AnimatedImageDrawable$nSetAlpha(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nGetAlpha$nativeBinding(long var0);

    private static int nGetAlpha(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetAlpha", $$robo$$android_graphics_drawable_AnimatedImageDrawable$nGetAlpha(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetColorFilter$nativeBinding(long var0, long var2);

    private static void nSetColorFilter(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nSetColorFilter", $$robo$$android_graphics_drawable_AnimatedImageDrawable$nSetColorFilter(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ boolean $$robo$$nIsRunning$nativeBinding(long var0);

    private static boolean nIsRunning(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nIsRunning", $$robo$$android_graphics_drawable_AnimatedImageDrawable$nIsRunning(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nStart$nativeBinding(long var0);

    private static boolean nStart(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nStart", $$robo$$android_graphics_drawable_AnimatedImageDrawable$nStart(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nStop$nativeBinding(long var0);

    private static boolean nStop(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nStop", $$robo$$android_graphics_drawable_AnimatedImageDrawable$nStop(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nGetRepeatCount$nativeBinding(long var0);

    private static int nGetRepeatCount(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetRepeatCount", $$robo$$android_graphics_drawable_AnimatedImageDrawable$nGetRepeatCount(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetRepeatCount$nativeBinding(long var0, int var2);

    private static void nSetRepeatCount(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetRepeatCount", $$robo$$android_graphics_drawable_AnimatedImageDrawable$nSetRepeatCount(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nSetOnAnimationEndListener$nativeBinding(long var0, AnimatedImageDrawable var2);

    private static void nSetOnAnimationEndListener(long l, AnimatedImageDrawable animatedImageDrawable) {
        InvokeDynamicSupport.bootstrapStatic("nSetOnAnimationEndListener", $$robo$$android_graphics_drawable_AnimatedImageDrawable$nSetOnAnimationEndListener(long android.graphics.drawable.AnimatedImageDrawable ), 1, (long)l, (AnimatedImageDrawable)animatedImageDrawable);
    }

    private static final native /* synthetic */ long $$robo$$nNativeByteSize$nativeBinding(long var0);

    private static long nNativeByteSize(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nNativeByteSize", $$robo$$android_graphics_drawable_AnimatedImageDrawable$nNativeByteSize(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetMirrored$nativeBinding(long var0, boolean var2);

    private static void nSetMirrored(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetMirrored", $$robo$$android_graphics_drawable_AnimatedImageDrawable$nSetMirrored(long boolean ), 1, (long)l, (boolean)bl);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedImageDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        long mNativePtr;
        private InputStream mInputStream;
        private AssetFileDescriptor mAssetFd;
        int[] mThemeAttrs;
        boolean mAutoMirrored;
        int mRepeatCount;
        /* synthetic */ AnimatedImageDrawable this$0;

        private void $$robo$$android_graphics_drawable_AnimatedImageDrawable_State$__constructor__(AnimatedImageDrawable animatedImageDrawable, long nativePtr, InputStream is, AssetFileDescriptor afd) {
            this.mThemeAttrs = null;
            this.mAutoMirrored = false;
            this.mRepeatCount = -2;
            this.mNativePtr = nativePtr;
            this.mInputStream = is;
            this.mAssetFd = afd;
        }

        private void __constructor__(AnimatedImageDrawable animatedImageDrawable, long l, InputStream inputStream, AssetFileDescriptor assetFileDescriptor) {
            this.$$robo$$android_graphics_drawable_AnimatedImageDrawable_State$__constructor__(animatedImageDrawable, l, inputStream, assetFileDescriptor);
        }

        State(AnimatedImageDrawable animatedImageDrawable, long l, InputStream inputStream, AssetFileDescriptor assetFileDescriptor) {
            this.this$0 = animatedImageDrawable;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedImageDrawable_State$__constructor__(android.graphics.drawable.AnimatedImageDrawable long java.io.InputStream android.content.res.AssetFileDescriptor ), 0, this, animatedImageDrawable, l, inputStream, assetFileDescriptor);
        }

        public /* synthetic */ State() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (State)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

