/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class DrawableWrapper
extends Drawable
implements Drawable.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private DrawableWrapperState mState;
    private Drawable mDrawable;
    private boolean mMutated;

    private void $$robo$$android_graphics_drawable_DrawableWrapper$__constructor__(DrawableWrapperState state, Resources res) {
        this.mState = state;
        this.updateLocalState(res);
    }

    private void $$robo$$android_graphics_drawable_DrawableWrapper$__constructor__(Drawable dr) {
        this.mState = null;
        this.mDrawable = dr;
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$updateLocalState(Resources res) {
        if (this.mState != null && this.mState.mDrawableState != null) {
            Drawable dr = this.mState.mDrawableState.newDrawable(res);
            this.setDrawable(dr);
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$setDrawable(Drawable dr) {
        if (this.mDrawable != null) {
            this.mDrawable.setCallback(null);
        }
        this.mDrawable = dr;
        if (dr != null) {
            dr.setCallback(this);
            dr.setVisible(this.isVisible(), true);
            dr.setState(this.getState());
            dr.setLevel(this.getLevel());
            dr.setBounds(this.getBounds());
            dr.setLayoutDirection(this.getLayoutDirection());
            if (this.mState != null) {
                this.mState.mDrawableState = dr.getConstantState();
            }
        }
        this.invalidateSelf();
    }

    private final Drawable $$robo$$android_graphics_drawable_DrawableWrapper$getDrawable() {
        return this.mDrawable;
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        DrawableWrapperState state = this.mState;
        if (state == null) {
            return;
        }
        int densityDpi = r.getDisplayMetrics().densityDpi;
        int targetDensity = densityDpi == 0 ? 160 : densityDpi;
        state.setDensity(targetDensity);
        state.mSrcDensityOverride = this.mSrcDensityOverride;
        TypedArray a = DrawableWrapper.obtainAttributes(r, theme, attrs, R.styleable.DrawableWrapper);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.inflateChildDrawable(r, parser, attrs, theme);
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$applyTheme(Resources.Theme t) {
        DrawableWrapperState state;
        super.applyTheme(t);
        if (this.mDrawable != null && this.mDrawable.canApplyTheme()) {
            this.mDrawable.applyTheme(t);
        }
        if ((state = this.mState) == null) {
            return;
        }
        int densityDpi = t.getResources().getDisplayMetrics().densityDpi;
        int density = densityDpi == 0 ? 160 : densityDpi;
        state.setDensity(density);
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.DrawableWrapper);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$updateStateFromTypedArray(TypedArray a) {
        DrawableWrapperState state = this.mState;
        if (state == null) {
            return;
        }
        state.mChangingConfigurations |= a.getChangingConfigurations();
        DrawableWrapperState.access$002(state, a.extractThemeAttrs());
        if (a.hasValueOrEmpty(0)) {
            this.setDrawable(a.getDrawable(0));
        }
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableWrapper$canApplyTheme() {
        return this.mState != null && this.mState.canApplyTheme() || super.canApplyTheme();
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$invalidateDrawable(Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, what, when);
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, what);
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$draw(Canvas canvas) {
        if (this.mDrawable != null) {
            this.mDrawable.draw(canvas);
        }
    }

    private final int $$robo$$android_graphics_drawable_DrawableWrapper$getChangingConfigurations() {
        return super.getChangingConfigurations() | (this.mState != null ? this.mState.getChangingConfigurations() : 0) | this.mDrawable.getChangingConfigurations();
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableWrapper$getPadding(Rect padding) {
        return this.mDrawable != null && this.mDrawable.getPadding(padding);
    }

    private final Insets $$robo$$android_graphics_drawable_DrawableWrapper$getOpticalInsets() {
        return this.mDrawable != null ? this.mDrawable.getOpticalInsets() : Insets.NONE;
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$setHotspot(float x, float y) {
        if (this.mDrawable != null) {
            this.mDrawable.setHotspot(x, y);
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$setHotspotBounds(int left, int top, int right, int bottom) {
        if (this.mDrawable != null) {
            this.mDrawable.setHotspotBounds(left, top, right, bottom);
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$getHotspotBounds(Rect outRect) {
        if (this.mDrawable != null) {
            this.mDrawable.getHotspotBounds(outRect);
        } else {
            outRect.set(this.getBounds());
        }
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableWrapper$setVisible(boolean visible, boolean restart) {
        boolean superChanged = super.setVisible(visible, restart);
        boolean changed = this.mDrawable != null && this.mDrawable.setVisible(visible, restart);
        return superChanged | changed;
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$setAlpha(int alpha) {
        if (this.mDrawable != null) {
            this.mDrawable.setAlpha(alpha);
        }
    }

    private final int $$robo$$android_graphics_drawable_DrawableWrapper$getAlpha() {
        return this.mDrawable != null ? this.mDrawable.getAlpha() : 255;
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$setColorFilter(ColorFilter colorFilter) {
        if (this.mDrawable != null) {
            this.mDrawable.setColorFilter(colorFilter);
        }
    }

    private final ColorFilter $$robo$$android_graphics_drawable_DrawableWrapper$getColorFilter() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            return drawable2.getColorFilter();
        }
        return super.getColorFilter();
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$setTintList(ColorStateList tint) {
        if (this.mDrawable != null) {
            this.mDrawable.setTintList(tint);
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$setTintMode(PorterDuff.Mode tintMode) {
        if (this.mDrawable != null) {
            this.mDrawable.setTintMode(tintMode);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableWrapper$onLayoutDirectionChanged(int layoutDirection) {
        return this.mDrawable != null && this.mDrawable.setLayoutDirection(layoutDirection);
    }

    private final int $$robo$$android_graphics_drawable_DrawableWrapper$getOpacity() {
        return this.mDrawable != null ? this.mDrawable.getOpacity() : -2;
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableWrapper$isStateful() {
        return this.mDrawable != null && this.mDrawable.isStateful();
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableWrapper$hasFocusStateSpecified() {
        return this.mDrawable != null && this.mDrawable.hasFocusStateSpecified();
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableWrapper$onStateChange(int[] state) {
        if (this.mDrawable != null && this.mDrawable.isStateful()) {
            boolean changed = this.mDrawable.setState(state);
            if (changed) {
                this.onBoundsChange(this.getBounds());
            }
            return changed;
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableWrapper$onLevelChange(int level) {
        return this.mDrawable != null && this.mDrawable.setLevel(level);
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$onBoundsChange(Rect bounds) {
        if (this.mDrawable != null) {
            this.mDrawable.setBounds(bounds);
        }
    }

    private final int $$robo$$android_graphics_drawable_DrawableWrapper$getIntrinsicWidth() {
        return this.mDrawable != null ? this.mDrawable.getIntrinsicWidth() : -1;
    }

    private final int $$robo$$android_graphics_drawable_DrawableWrapper$getIntrinsicHeight() {
        return this.mDrawable != null ? this.mDrawable.getIntrinsicHeight() : -1;
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$getOutline(Outline outline) {
        if (this.mDrawable != null) {
            this.mDrawable.getOutline(outline);
        } else {
            super.getOutline(outline);
        }
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_DrawableWrapper$getConstantState() {
        if (this.mState != null && this.mState.canConstantState()) {
            this.mState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mState;
        }
        return null;
    }

    private final Drawable $$robo$$android_graphics_drawable_DrawableWrapper$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mState = this.mutateConstantState();
            if (this.mDrawable != null) {
                this.mDrawable.mutate();
            }
            if (this.mState != null) {
                this.mState.mDrawableState = this.mDrawable != null ? this.mDrawable.getConstantState() : null;
            }
            this.mMutated = true;
        }
        return this;
    }

    private final DrawableWrapperState $$robo$$android_graphics_drawable_DrawableWrapper$mutateConstantState() {
        return this.mState;
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$clearMutated() {
        super.clearMutated();
        if (this.mDrawable != null) {
            this.mDrawable.clearMutated();
        }
        this.mMutated = false;
    }

    private final void $$robo$$android_graphics_drawable_DrawableWrapper$inflateChildDrawable(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int type;
        Drawable dr = null;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type != 2) continue;
            dr = Drawable.createFromXmlInnerForDensity(r, parser, attrs, this.mState.mSrcDensityOverride, theme);
        }
        if (dr != null) {
            this.setDrawable(dr);
        }
    }

    private void __constructor__(DrawableWrapperState drawableWrapperState, Resources resources) {
        this.$$robo$$android_graphics_drawable_DrawableWrapper$__constructor__(drawableWrapperState, resources);
    }

    DrawableWrapper(DrawableWrapperState drawableWrapperState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_DrawableWrapper$__constructor__(android.graphics.drawable.DrawableWrapper$DrawableWrapperState android.content.res.Resources ), 0, this, drawableWrapperState, resources);
    }

    private void __constructor__(Drawable drawable2) {
        this.$$robo$$android_graphics_drawable_DrawableWrapper$__constructor__(drawable2);
    }

    public DrawableWrapper(Drawable drawable2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_DrawableWrapper$__constructor__(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    private void updateLocalState(Resources resources) {
        InvokeDynamicSupport.bootstrap("updateLocalState", $$robo$$android_graphics_drawable_DrawableWrapper$updateLocalState(android.content.res.Resources ), 0, this, resources);
    }

    public void setDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setDrawable", $$robo$$android_graphics_drawable_DrawableWrapper$setDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public Drawable getDrawable() {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_graphics_drawable_DrawableWrapper$getDrawable(), 0, this);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_DrawableWrapper$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_DrawableWrapper$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_DrawableWrapper$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_DrawableWrapper$canApplyTheme(), 0, this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_graphics_drawable_DrawableWrapper$invalidateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        InvokeDynamicSupport.bootstrap("scheduleDrawable", $$robo$$android_graphics_drawable_DrawableWrapper$scheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable long ), 0, this, drawable2, runnable, l);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("unscheduleDrawable", $$robo$$android_graphics_drawable_DrawableWrapper$unscheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable ), 0, this, drawable2, runnable);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_DrawableWrapper$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_DrawableWrapper$getChangingConfigurations(), 0, this);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_DrawableWrapper$getPadding(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public Insets getOpticalInsets() {
        return InvokeDynamicSupport.bootstrap("getOpticalInsets", $$robo$$android_graphics_drawable_DrawableWrapper$getOpticalInsets(), 0, this);
    }

    @Override
    public void setHotspot(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setHotspot", $$robo$$android_graphics_drawable_DrawableWrapper$setHotspot(float float ), 0, this, f, f2);
    }

    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setHotspotBounds", $$robo$$android_graphics_drawable_DrawableWrapper$setHotspotBounds(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void getHotspotBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getHotspotBounds", $$robo$$android_graphics_drawable_DrawableWrapper$getHotspotBounds(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_DrawableWrapper$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_DrawableWrapper$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_DrawableWrapper$getAlpha(), 0, this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_DrawableWrapper$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public ColorFilter getColorFilter() {
        return InvokeDynamicSupport.bootstrap("getColorFilter", $$robo$$android_graphics_drawable_DrawableWrapper$getColorFilter(), 0, this);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_DrawableWrapper$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_DrawableWrapper$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    @Override
    public boolean onLayoutDirectionChanged(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLayoutDirectionChanged", $$robo$$android_graphics_drawable_DrawableWrapper$onLayoutDirectionChanged(int ), 0, this, n);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_DrawableWrapper$getOpacity(), 0, this);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_DrawableWrapper$isStateful(), 0, this);
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_graphics_drawable_DrawableWrapper$hasFocusStateSpecified(), 0, this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_DrawableWrapper$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_DrawableWrapper$onLevelChange(int ), 0, this, n);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_DrawableWrapper$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_DrawableWrapper$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_DrawableWrapper$getIntrinsicHeight(), 0, this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_DrawableWrapper$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_DrawableWrapper$getConstantState(), 0, this);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_DrawableWrapper$mutate(), 0, this);
    }

    DrawableWrapperState mutateConstantState() {
        return InvokeDynamicSupport.bootstrap("mutateConstantState", $$robo$$android_graphics_drawable_DrawableWrapper$mutateConstantState(), 0, this);
    }

    @Override
    public void clearMutated() {
        InvokeDynamicSupport.bootstrap("clearMutated", $$robo$$android_graphics_drawable_DrawableWrapper$clearMutated(), 0, this);
    }

    private void inflateChildDrawable(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflateChildDrawable", $$robo$$android_graphics_drawable_DrawableWrapper$inflateChildDrawable(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    public /* synthetic */ DrawableWrapper() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DrawableWrapper)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class DrawableWrapperState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] mThemeAttrs;
        int mChangingConfigurations;
        int mDensity;
        int mSrcDensityOverride;
        Drawable.ConstantState mDrawableState;

        private void $$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$__constructor__(DrawableWrapperState orig, Resources res) {
            this.mDensity = 160;
            this.mSrcDensityOverride = 0;
            if (orig != null) {
                this.mThemeAttrs = orig.mThemeAttrs;
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mDrawableState = orig.mDrawableState;
                this.mSrcDensityOverride = orig.mSrcDensityOverride;
            }
            int density = res != null ? res.getDisplayMetrics().densityDpi : (orig != null ? orig.mDensity : 0);
            this.mDensity = density == 0 ? 160 : density;
        }

        private final void $$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$setDensity(int targetDensity) {
            if (this.mDensity != targetDensity) {
                int sourceDensity = this.mDensity;
                this.mDensity = targetDensity;
                this.onDensityChanged(sourceDensity, targetDensity);
            }
        }

        private final void $$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$onDensityChanged(int sourceDensity, int targetDensity) {
        }

        private final boolean $$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$canApplyTheme() {
            return this.mThemeAttrs != null || this.mDrawableState != null && this.mDrawableState.canApplyTheme() || super.canApplyTheme();
        }

        private final Drawable $$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$newDrawable() {
            return this.newDrawable(null);
        }

        @Override
        public abstract Drawable newDrawable(Resources var1);

        private final int $$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$getChangingConfigurations() {
            return this.mChangingConfigurations | (this.mDrawableState != null ? this.mDrawableState.getChangingConfigurations() : 0);
        }

        private final boolean $$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$canConstantState() {
            return this.mDrawableState != null;
        }

        static /* synthetic */ int[] access$002(DrawableWrapperState x0, int[] x1) {
            x0.mThemeAttrs = x1;
            return x1;
        }

        private void __constructor__(DrawableWrapperState drawableWrapperState, Resources resources) {
            this.$$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$__constructor__(drawableWrapperState, resources);
        }

        DrawableWrapperState(DrawableWrapperState drawableWrapperState, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$__constructor__(android.graphics.drawable.DrawableWrapper$DrawableWrapperState android.content.res.Resources ), 0, this, drawableWrapperState, resources);
        }

        public void setDensity(int n) {
            InvokeDynamicSupport.bootstrap("setDensity", $$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$setDensity(int ), 0, this, n);
        }

        void onDensityChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onDensityChanged", $$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$onDensityChanged(int int ), 0, this, n, n2);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$canApplyTheme(), 0, this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$newDrawable(), 0, this);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$getChangingConfigurations(), 0, this);
        }

        public boolean canConstantState() {
            return (boolean)InvokeDynamicSupport.bootstrap("canConstantState", $$robo$$android_graphics_drawable_DrawableWrapper_DrawableWrapperState$canConstantState(), 0, this);
        }

        public /* synthetic */ DrawableWrapperState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DrawableWrapperState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

