/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.graphics.Rect;
import android.graphics.drawable.RippleDrawable;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class RippleComponent
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected RippleDrawable mOwner;
    protected Rect mBounds;
    private boolean mHasMaxRadius;
    protected float mTargetRadius;
    protected float mDensityScale;

    private void $$robo$$android_graphics_drawable_RippleComponent$__constructor__(RippleDrawable owner, Rect bounds) {
        this.mOwner = owner;
        this.mBounds = bounds;
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$onBoundsChange() {
        if (!this.mHasMaxRadius) {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
            this.onTargetRadiusChanged(this.mTargetRadius);
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$setup(float maxRadius, int densityDpi) {
        if (maxRadius >= 0.0f) {
            this.mHasMaxRadius = true;
            this.mTargetRadius = maxRadius;
        } else {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
        }
        this.mDensityScale = (float)densityDpi * 0.00625f;
        this.onTargetRadiusChanged(this.mTargetRadius);
    }

    private static final float $$robo$$android_graphics_drawable_RippleComponent$getTargetRadius(Rect bounds) {
        float halfWidth = (float)bounds.width() / 2.0f;
        float halfHeight = (float)bounds.height() / 2.0f;
        return (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$getBounds(Rect bounds) {
        int r = (int)Math.ceil(this.mTargetRadius);
        bounds.set(-r, -r, r, r);
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$invalidateSelf() {
        this.mOwner.invalidateSelf(false);
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$onHotspotBoundsChanged() {
        if (!this.mHasMaxRadius) {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
            this.onTargetRadiusChanged(this.mTargetRadius);
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$onTargetRadiusChanged(float targetRadius) {
    }

    private void __constructor__(RippleDrawable rippleDrawable, Rect rect) {
        this.$$robo$$android_graphics_drawable_RippleComponent$__constructor__(rippleDrawable, rect);
    }

    public RippleComponent(RippleDrawable rippleDrawable, Rect rect) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleComponent$__constructor__(android.graphics.drawable.RippleDrawable android.graphics.Rect ), 0, this, rippleDrawable, rect);
    }

    public void onBoundsChange() {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_RippleComponent$onBoundsChange(), 0, this);
    }

    public void setup(float f, int n) {
        InvokeDynamicSupport.bootstrap("setup", $$robo$$android_graphics_drawable_RippleComponent$setup(float int ), 0, this, f, n);
    }

    private static float getTargetRadius(Rect rect) {
        return (float)InvokeDynamicSupport.bootstrapStatic("getTargetRadius", $$robo$$android_graphics_drawable_RippleComponent$getTargetRadius(android.graphics.Rect ), 0, (Rect)rect);
    }

    public void getBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getBounds", $$robo$$android_graphics_drawable_RippleComponent$getBounds(android.graphics.Rect ), 0, this, rect);
    }

    protected void invalidateSelf() {
        InvokeDynamicSupport.bootstrap("invalidateSelf", $$robo$$android_graphics_drawable_RippleComponent$invalidateSelf(), 0, this);
    }

    protected void onHotspotBoundsChanged() {
        InvokeDynamicSupport.bootstrap("onHotspotBoundsChanged", $$robo$$android_graphics_drawable_RippleComponent$onHotspotBoundsChanged(), 0, this);
    }

    protected void onTargetRadiusChanged(float f) {
        InvokeDynamicSupport.bootstrap("onTargetRadiusChanged", $$robo$$android_graphics_drawable_RippleComponent$onTargetRadiusChanged(float ), 0, this, f);
    }

    public /* synthetic */ RippleComponent() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RippleComponent)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

